/* History

20130802 AB     changed all @ifconfig to ifconfig
                changed all @route to route

*/

/* DHCP configuration script for eComStation */
/*
This configurationscript have builtin support for updating
your account at http://dyndns.dk
If you do not have such an account yet, just sign up for one,
it is free.
Change the dynhost and dynpass with your own hostname and password.
(The default values are working values, as an example)
If you do not want to use the dyndns.dk updater, set dyndns=0
on the next line.  */
dyndns = 0
dynhost = 'dhcp'
dynpass = 'xxxx'
dyndomain = 'dyndns.dk'

debug = 1
say "1B"x || "[1;33;40m" || 'entering script'
Globals = "OurSocket dynup RB os2env dyndns dynhost dynpass dyndomain"
os2env = 'OS2ENVIRONMENT'
/* getting some basics from the environment */

dhcp.reason = value('REASON', ,os2env)
dhcp.interface = value('interface', ,os2env)
etce.envi = value('ETC', ,os2env)

If debug Then address CMD '@set > env.dmp'

say "1B"x || "[36;40m"
IF debug THEN do
  say "1B"x || "[36;40m" || "DHCP Configuration Script"
  say "Action code: " dhcp.reason
  "@ECHO Action code: " dhcp.reason ">> action"
  say "Interface  : " dhcp.interface
  say "ETC        : " etce.envi
  say ""
end

say ""
/* Valgmuligheder:
MEDIUM,  PREINIT,  BOUND,  RENEW,  REBIND,  REBOOT,
       EXPIRE, FAIL and TIMEOUT + NBI + STOP + RELEASE.
*/
dynup = 'Not updated'
select
  when dhcp.reason = 'PREINIT' then
    do
     tempfile = 'lanIFtst.tst '
     'ifconfig lan0 > 'tempfile
     lin = linein(tempfile)
     rc1 = pos('bc63',lin)
     rx = stream(tempfile,'C','close')
     '@del' tempfile

     IF rc1 = 0 Then
       Do
       'ifconfig 'dhcp.interface' 0.0.0.0 2>nul'

    say "Ŀ"
    say "                                                  "
    say "       Initializing interface "dhcp.interface"                "
    say "                                                  "
    say ""
        End
      Else
        Do
    say "Ŀ"
    say "                                                  "
    say "             Interface "dhcp.interface" Ready                 "
    say "                                                  "
    say ""

        End
    end

  when dhcp.reason = 'RENEW'
   then
    do
       dhcp.new_routers                 = value('new_routers',,os2env)
       Say "Pinging default route to test connection..."
       '@ping 'dhcp.new_routers '1500 1'
       say "Updating your account at DynDNS.DK"
       call updatedyndns
       call InfoScreen
    end

  when dhcp.reason = 'BOUND' | dhcp.reason ='REBOOT' | dhcp.reason ='REBIND' | dhcp.reason ='TIMEOUT'
   then
    do
       /* get more values from the environment*/
       dhcp.new_ip_address              = value('new_ip_address',,os2env)
       dhcp.new_subnet_mask             = value('new_subnet_mask',,os2env)
       dhcp.new_broadcast_address       = value('new_broadcast_address',,os2env)
       dhcp.new_routers                 = value('new_routers',,os2env)
       dhcp.new_domain_name             = value('new_domain_name',,os2env)
       dhcp.new_domain_name_servers     = value('new_domain_name_servers',,os2env)
       dhcp.new_dhcp_lease_time         = value('NEW_DHCP_LEASE_TIME',,os2env)
       dhcp.new.expiry                  = value('NEW_EXPIRY',,os2env)

       'ifconfig 'dhcp.interface 'down>nul'
       'route -f > nul'
       'ifconfig 'dhcp.interface dhcp.new_ip_address 'netmask' dhcp.new_subnet_mask 'broadcast' dhcp.new_broadcast_address
       'route add default 'dhcp.new_routers '>nul'

       Say "Pinging default route to test connection..."
       '@ping 'dhcp.new_routers '1500 1 >nul'
       'ping 'dhcp.new_routers '1500 3'
       '@echo domain 'dhcp.new_domain_name' > 'etce.envi'\RESOLV2'
       parse var dhcp.new_domain_name_servers name1 name2 name3
       '@echo nameserver 'name1' >> 'etce.envi'\resolv2'
       if length(name2) > 0 then '@echo nameserver 'name2' >> 'etce.envi'\resolv2'
       if length(name3) > 0 then '@echo nameserver 'name3' >> 'etce.envi'\resolv2'
       Call SysSleep 0
       call updatedyndns

       call InfoScreen

    end

  when dhcp.reason = 'EXPIRE' | dhcp.reason = 'FAIL' | dhcp.reason = 'STOP'
   then
    do
    'ifconfig 'dhcp.interface' delete'
    'route -f'
    'arp -f'
    Say 'Your 'dhcp.interface' interface have been closed and IP address released'
    say "1B"x || "[31;40m"
    say "Ŀ"
    say "                                                       "
    say " Your lease have expired, and the DHCP client          "
    say " have been unable to retrive a new valid lease.        "
    say "                                                       "
    say " Your Interface are now closed, and routes are deleted "
    say "                                                       "
    say ""
    Beep(500,500)
    Beep(1500,500)
    Beep(500,500)
    Beep(1500,500)
    Beep(500,500)
    Beep(1500,500)
    Beep(500,500)
    'ifconfig 'dhcp.interface' 0.0.0.0 netmask 255.255.255.0 broadcast 255.255.255.255 2>nul'
    end
  when dhcp.reason = 'RELEASE'
   then
    do
    ifconfig dhcp.interface delete
    route -f
    say "1B"x || "[31;40m"
    say "Ŀ"
    say "                                                       "
    say " Your have decided to release your IP address.         "
    say "                                                       "
    say " Your Interface are now closed, and routes are deleted "
    say "                                                       "
    say ""
    Beep(1500,500)
    Beep(500,500)
    end
  otherwise
    say "1B"x || "[33;40m" || dhcp.reason 'not yet implemented'
    say "Ŀ"
    say "                                                  "
    say " We are sorry for not having implemented this yet "
    say "                                                  "
    say ""
  end
/* say "1B"x || "[33;40m" || 'exiting script'||"1B"x || "[0m"*/
call Charout ,"1B"x || "[0m"
return 0

InfoScreen: PROCEDURE expose (Globals)
       /* get more values from the environment*/
       dhcp.reason                      = value('REASON', ,os2env)
       dhcp.interface                   = value('interface', ,os2env)
       dhcp.new_ip_address              = value('new_ip_address',,os2env)
       dhcp.new_subnet_mask             = value('new_subnet_mask',,os2env)
       dhcp.new_broadcast_address       = value('new_broadcast_address',,os2env)
       dhcp.new_routers                 = value('new_routers',,os2env)
       dhcp.new_domain_name             = value('new_domain_name',,os2env)
       dhcp.new_domain_name_servers     = value('new_domain_name_servers',,os2env)
       dhcp.new_dhcp_lease_time         = value('NEW_DHCP_LEASE_TIME',,os2env)
       dhcp.new.expiry                  = value('NEW_EXPIRY',,os2env)
       dhcp.new.rebind                  = value('NEW_rebind',,os2env)
       dhcp.new.renew                   = value('NEW_renewal',,os2env)

       say "1B"x || "[32;40m"
       say " "
       say "Ŀ"
       say "                                                     "
       say "   Your have recieved a valid IP address             "
       say "                                                     "
       say "                                                     "
       say "   State       : " left(dhcp.reason,34," ") ""
       say "   Interface   : " left(dhcp.interface,34," ") ""
       say "   IP          : " left(dhcp.new_ip_address,34,' ') ""
       say "   Subnet      : " left(dhcp.new_subnet_mask,34,' ') ""
       say "   Broadcast   : " left(dhcp.new_broadcast_address,34,' ') ""
       say "   Gateway     : " left(dhcp.new_routers,34,' ') ""
       say "   Domain name : " left(dhcp.new_domain_name,34,' ') ""
       say "   Nameservers : " left(dhcp.new_domain_name_servers,34,' ') ""
       if dyndns Then say "   DynDNS.DK   : " left(dynup,34,' ') ""
       say "                                                     "
       say "   Lease time  : " left(dhcp.new_dhcp_lease_time "secs",34,' ') ""
       call gmtime dhcp.new.renew
       parse var result sec min hour day mon year wday yday
       say "   Renew       : " right(day,2,'0')'/'right(mon,2,'0')'/'year' at' right(hour,2,' ')'.'right(min,2,'0')'.'right(sec,2,'0') "UTC         "
       call gmtime dhcp.new.rebind
       parse var result sec min hour day mon year wday yday
       say "   Rebind      : " right(day,2,'0')'/'right(mon,2,'0')'/'year' at' right(hour,2,' ')'.'right(min,2,'0')'.'right(sec,2,'0') "UTC         "
       call gmtime dhcp.new.expiry
       parse var result sec min hour day mon year wday yday
       say "   Expire      : " right(day,2,'0')'/'right(mon,2,'0')'/'year' at' right(hour,2,' ')'.'right(min,2,'0')'.'right(sec,2,'0') "UTC         "
       say "                                                     "
       say ""
Return

GmTime: PROCEDURE
/* convert unix time to 'tm' like structure
   ARG(1)   unix time
   RETURN   int   tm_sec   seconds after the minute [0-59]
            int   tm_min   minutes after the hour [0-59]
            int   tm_hour  hours since midnight [0-23]
            int   tm_mday  day of the month [1-31]
            int   tm_mon   months since January [0-11] - note the zero based offset!
            int   tm_year  years since 1900
            int   tm_wday  days since Sunday [0-6]
            int   tm_yday  days since January 1 [0-365]
*/
   sec = ARG(1) // 60
   t = ARG(1) % 60
   min = t // 60
   t = t % 60
   hour = t // 24
   days = t % 24
   wday = (days+4) // 7
   days4 = days * 4 +2 /* [days*4+2], now the funny part starts ... */
   year = days4 % 1461 + 70
   yday = days4 // 1461 % 4
   t = yday * 12 + 6 /* [remaining days *12 +6] */
   IF year // 4 \= 0 THEN DO
      IF t > 59*12 THEN
         t = t + 2*12
      END
    ELSE IF t > 60*12 THEN
      t = t + 1*12
   mon = t % 367 +1
   day = (t // 367) % 12 +1
   year = year + 1900
RETURN sec min hour day mon year wday yday

/****************************************************************/
/*                 CONNECTING TO THE SERVER                     */
/****************************************************************/

UpdateDyndns: procedure expose (Globals)

/*  App to update a dynamic DNS at DynDNS.DK
Change the values for your hostname and password at top of file
*/
If \dyndns then return
CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs
CALL RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
CALL SockLoadFuncs nul
RB = ""                                       /* Receive buffer */
/*Globals = "OurSocket RB ReturnPath ForwardPath FileName"
*/
OurSocket = SockSocket("AF_INET", "SOCK_STREAM", "IPPROTO_TCP")
IF OurSocket = -1 THEN
  DO
    say "Can't create socket"
    RETURN 0
  END
IF \SockGetHostByName('dyndns.dk','host.') THEN
  DO
  say "Unknown host"
  DROP host.
  RETURN 0
END

target.!family = 'AF_INET'
target.!port = 80
target.!addr = host.addr
DROP host.
IF SockConnect(OurSocket,"target.!") = -1 THEN
  DO
    say "Failed to connect"
    RETURN 0
  END

rc = SockSend(OurSocket, "GET http://dyndns.dk/update/simple?name="dynhost"&domain="dyndomain"&password="dynpass||"0D0A"X)
x = Receiveline()
if x = 0
Then do
  y = Receiveline()
  dynup = dynhost||'.'||dyndomain||' updated. '
  end
 Else
  do
  dynup = 'Error ' x 'updating IP at DynDNS.DK'
  end

call LINEOUT 'Dyndnsdk.Log','--------------------'
call LINEOUT 'Dyndnsdk.Log',date() time()
call LINEOUT 'dyndnsdk.log',y
call LINEOUT 'Dyndnsdk.Log',dynhost'.'dyndomain
call LINEOUT 'Dyndnsdk.Log','--------------------'

CALL SockSoClose(OurSocket)

Return

/****************************************************************/

SendLine: PROCEDURE expose (Globals)

    /* Sends a single line to the server */

    PARSE ARG str
    RETURN (SockSend(OurSocket, str||'0D0A'X) \= -1)

/****************************************************************/
/*              RECEIVING ONE LINE FROM THE SERVER              */
/*                                                              */
/*  Note: the global variable RB is the receive buffer; it      */
/*  holds input that has not yet been processed.                */
/****************************************************************/

ReceiveLine: PROCEDURE expose (Globals)
    line = ''
    DO FOREVER
      len = LENGTH(RB)
      IF len = 0 THEN
        DO
          NullResponseCount = 0
          DO WHILE len = 0
            len = SockRecv(OurSocket, 'RB', 256)
  /*          RB = RB||'0D0A'X
            len = len + 2
            Say "len=" len
    */        IF len = 0 THEN
              DO
                NullResponseCount = NullResponseCount+1
                IF NullResponseCount > 20 THEN len = -1
              END
          END /*do-while*/
          IF len = -1 THEN RETURN ''
        END /* if len=0 */
      j0 = POS('0A'X, RB)
      IF j0 = 0 THEN
        DO
          line = STRIP(line||RB, 'T', '0D'X)
          RB = ''
          RETURN line
        END
      ELSE
        DO
          line = STRIP(line||LEFT(RB,j0-1), 'T', '0D'X)
          RB = RIGHT(RB,len-j0)
          RETURN line
        END
    END /* do forever */
return
/****************************************************************/

