.. ***************************** Module Header *******************************
..
.. Module Name: xwlaneng.inc
..
.. Wireless LAN Monitor help source include file
.. Requires HyperText/2 package to compile
..
.. Copyright (c) WLan Project 2003
..
.. $Id: xwlaneng.inc,v 1.194 2009-11-13 12:50:03 cla Exp $
..
.. ===========================================================================
..
.. This file is part of the WLan Project and is free software.  You can
.. redistribute it and/or modify it under the terms of the GNU General
.. Public License as published by the Free Software Foundation, in version 2
.. as it comes in the "COPYING" file of the WLan Project CVS tree.
.. This program is distributed in the hope that it will be useful, but WITHOUT
.. ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
.. FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
.. for more details.
..
.. ***************************************************************************
.an IDPNL_MAIN
.res 1
.
This is the online help for the [=TITLE]. This program provides the
following features:
.ul compact
- monitoring the status of your Wireless LAN connection
- support of multipe connection profiles, which can be exported and imported
- optionally configuring the TCP/IP interface of the Wireless LAN device
- automatic [.IDPNL_CONFIGURE_PROFILESCAN connection scan] on startup
- support of WEP [.IDPNL_CONFIGURE_SECURITY encryption]
- support of WPA and WPA2 [.IDPNL_CONFIGURE_SECURITY encryption] using the
  [http://hostap.epitest.fi WPA Supplicant], for [.IDPNL_PREREQUISITES GenMac]
  compatible Wireless LAN devices
- automatic generation of WEP keys
- [.IDPNL_HOTSPOT detection] of public Wireless LANs
- execution of a [.IDPNL_CONFIGURE_SCRIPT script] when (dis)connecting

The [=TITLE] is available both as a XCenter Widget as well as a standalone program.
If either *XWorkplace* or the OEM-Version *EWorkplace* (contained in *eComStation V1.1*
or better) is installed, the usage of the XCenter Widget is recommended because of
the better integration into the user interface.

[=TOPICS]
.su 1

.. ################
.include copyright.eng
.. ################

.. ----------------------------------------
.2 Prerequisites
.. ----------------------------------------
.an IDPNL_PREREQUISITES
.
The following prerequisites apply to the current version of [=TITLE]
.ul
- *OS/2 Warp 4* or better
- *XWorkplace* or *EWorkplace* (OEM version included in *eComStation*)
- ISC DHCP client (dhclient.exe) in a directory which is in your PATH statement. Install with 'yum install dhcpclient' (http://rpm.netlabs.org/release/00/i386/i386/dhclient-3.1-2.oc00.i386.rpm.
  Maybe http://download.smedley.info/Dhcp-client-preview2.zip works too, but is not tested)

The following prerequisites apply for usage of
[.IDPNL_CONFIGURE_SECURITY WPA- and WPA2 encryption]
with the [http://hostap.epitest.fi WPA Supplicant],
which is part of the [=TITLE] package:
.ul
- WPA Supplicant 2.0. The included version is from Paul Smedley's package http://os2ports.smedley.id.au/index.php?page=wpa-supplicant
  wpa__supplicant.exe must reside in the directory where the xwlan **.dim files are installed, usually
  \xworkplace\plugins\xcenter\xwlan\ relative to the directory where wlanstat.exe is installed.
- GenMac [=__WPA_GENMAC_MINVERSION_LIT__]
- LibC Runtime Library [=__WPA_REQUIRED_LIBC_VERSION__]
.
  This library is automatically installed with eComStation
  [=__WPA_REQUIRED_LIBC_ECSINST__] or better.
  For OS/2 or older versions of eComStation install the
  [ftp://ftp.netlabs.org/pub/libc/libc-0.6.5-csd5.zip runtime DLL]
  in one of the directories of the LIBPATH statement of config.sys
  or from Netlabs RPM repository with 'yum install libc'.

.. ----------------------------------------
.2 Installation
.. ----------------------------------------
.an IDPNL_INSTALL
.
[=TOPICS]
.su V30 u 1

.. ----------------------------------------
.3 Install [=BASETITLE]
.. ----------------------------------------
.an IDPNL_INSTALL_WIDGET
.
The package comes with the following files
.pl compact break=none tsize=15 bold
- instwgt.cmd
= installation program for the XCenter Widget
- instexe.cmd
= installation program for the standalone executable
- setlang.cmd
= program to [.IDPNL_INSTALL_NLS determine the language used]
- readme.cmd
= script for to launch online help files
- file__id.diz
= package description file
- xcenter\**
= subdirectory with program, script and help files

Unzip this package into an empty directory and
execute either *instwgt.cmd* or *instexe.cmd*
to install the [=TITLE] either as a XCenter Widget
as well as a standalone program.

If either *XWorkplace* or the OEM-Version *EWorkplace*,
(contained in *eComStation V1.1* or better) is installed,
the usage of the XCenter Widget is recommended because of
the better integration into the user interface.

.at fc=red
[=NOTE]
.ul compact
- It is highly recommended to no set any values for the TCP/IP interface
  of the Wireless LAN devices within the *TCP/IP configuration program*, but
  herefore only use the
  [.IDPNL_PROFILEPROPERTIES_PAGETCPIP properties notebook of a connection profile].
.at

.. ----------------------------------------
.3 National Language Support
.. ----------------------------------------
.an IDPNL_INSTALL_NLS
.
The current package contains National Language Support for the
English, Dutch, German, Italian, Spanish, and Swedish languages.

The language used is chosen according to the language of your
operating system. If the language of the operating system
is not supported by [=TITLE], english is used as the default language.

If the language of the operating system is either not yet suported
by the [=TITLE] or not suitable for you, you may set the language
used by executing the program *setlang.cmd*. Execute it with the
following parameters:
.pl bold tsize=3
- <no parameter>
= displays the language currently used
- **
= sets up the [=TITLE] to use the default language (English)
- #xxx#
= specifies the identifier of the language to be used.
.
 Valid identifiers are: eng deu sve ita nld esp

.. ----------------------------------------
.2 Usage
.. ----------------------------------------
.an IDPNL_USAGE
.
[=TOPICS]
.su V30 u 1

.. ----------------------------------------
.3 Monitor Status Display
.. ----------------------------------------
.an IDPNL_STATUS
.
These are the status symbols being displayed in the
[=TITLE] (according to the screen resolution
the symbols being displayed can differ
from the ones shown here). These symbols can be
[.IDPNL_CHANGEBITMAPS replaced] by user-defined symbols.
.pl break=none tsize=5
-
.bi wlan-nocard.bmp
= no WLAN card inserted
-
.bi wlan-nodriver.bmp
= no WLAN device driver installed
-
.bi wlan-disabled.bmp
= radio is disabled
-
.bi wlan-ipdisabled.bmp
= TCP/IP interface is disabled
-
.bi wlan-nonet.bmp
= connected, but out of range
-
.bi wlan-searching.bmp
= searching connection with the current connection profile
-
.bi wlan-scanning.bmp
= searching connection with the current connection profile, switching
  to the next connection profile (included in the scan) after a user
  determined period of time
-
.bi wlan-configuring.bmp
= configuring the IP interface
.
 (this may take longer when using DHCP)
-
.bi wlan-script.bmp
= executing the script when (dis)connecting
-
.bi wlan-100.bmp
= connected, 81 to 100% signal
-
.bi wlan-80.bmp
= connected, 61 to 80% signal
-
.bi wlan-60.bmp
= connected, 41 to 60% signal
-
.bi wlan-40.bmp
= connected, 21 to 40% signal
-
.bi wlan-20.bmp
= connected, 1 to 20% signal
-
.bi wlan-nodataaccess.bmp
= Access denied, because [=TITLE] is already active

.. ----------------------------------------
.3 Mouse Actions
.. ----------------------------------------
.an IDPNL_MOUSEACTIONS
.
The [=TITLE] supports the following mouse actions:
.ul
- a click with mouse button two on the widget will
  launch the context menu
- a double-click with mouse button one on the widget
  will execute the action defined
  on the [.IDPNL_PROPERTIES_PAGEMOUSE] page of the
  [.IDPNL_PROPERTIES properties notebook].
- moving the mouse pointer over the widget will show
  a bubble help text, including the current status
  of the widget and selected Wireless LAN device.
  The Wireless LAN device can be selected within the
  [.IDPNL_PROPERTIES_PAGEDEVSELECT] page of the [=TITLE]
  [.IDPNL_PROPERTIES properties notebook]

In addition to that the window of the [.IDPNL_EXEOPTIONS standalone program]
can be moved with mouse button one.

.. ----------------------------------------
.3 Monitor Properties
.. ----------------------------------------
.an IDPNL_PROPERTIES
.res 100
.
The properties notebook of the [=TITLE]
contains the following pages:
.su 1 H50

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGERADIO]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGERADIO
.res 99
.
This page of the [=TITLE] properties notebook
determines the radio properties:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_RADIOSTARTUP]
= selects the action being taken on program startup
.. ------------------
.pl [=PARMLIST_PARMS]
  - [=IDT_IDSTR_RADIOPROFILE]
  = select this option to let [=TITLE] activate radio only if it was
    active during last shutdown of the program. A possible deactivation
    by the option *[=IDT_IDCHB_RADIOSHUTDOWN]* is ignored for that.
  - [=IDT_IDSTR_RADIOON]
  = select this option to let the [=TITLE] always activate radio during
    startup of the program
  - [=IDT_IDSTR_RADIOOFF]
  = select this option to let the [=TITLE] always deactivate radio during
    startup of the program
.el
.. ------------------
- [=IDT_IDCHB_RADIOSHUTDOWN]
= select this option to disable radio on program end
.. ------------------
- [=IDT_IDCHB_RADIOSTOP]
= select this option to disable radio if the connection gets lost
  or cannot be obtained on program startup
.. ------------------
- [=IDT_IDTXT_RADIOSTOPWAIT]
= this property determines the amount of minutes that should be waited
  without a connection, before the radio will be disabled

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGESCAN]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGESCAN
.res 101
.
This page of the [=TITLE] properties notebook
determines the following connection properties for all connection
profiles:
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_SCANONSTARTUP]
= select this option, if you want the [=TITLE] to scan connection
  profiles for a connection on startup
- [=IDT_IDCHB_SCANONREINSERT]
= select this option, if you want the [=TITLE] to scan connection
  profiles for a working connection, when you (re)connect
  a Wireless LAN device to the system.
  This setting does make sense only with removeable Wireless LAN devices
  such as PCMCIA cards or USB devices.
- [=IDT_IDTXT_SCANINTERVAL]
= this property determines the amount of seconds that the
  [.IDPNL_CONFIGURE_PROFILESCAN connection scan] should wait for a
  connection to be established, before the next connection
  profile is being selected
- [=IDT_IDTXT_SCANRETRIES]
= this property determines the amount of retries in scanning for connections.
  On each retry, the [=TITLE] will test each profile having the attribute
  *[=IDT_IDCHB_INCLUDEINSCAN]* checked.

.at fc=red
[=NOTE]
.ul compact
- In order to use the scan features, within at least one connection profile
  the attribute *[=IDT_IDCHB_INCLUDEINSCAN]* must be set.
.at

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEDEVSELECT]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEDEVSELECT
.res 102
.
This page of the [=TITLE] properties notebook
determines the device to be used
and displays driver version as
well as capabilities of the driver:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_DRVSELECT]
= select among the installed device drivers that manage
  the Wireless LAN devices in the system

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGETCPIP] 1/2
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGETCPIP
.res 103
.
This page of the [=TITLE] properties notebook
determines the properties for the configuration
of the TCP/IP interface of the Wireless LAN device:
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_TRIGGERWAN]
= select this option to let [=TITLE], after the wireless connect,
  immediately establish a connection over a WAN port (Internet)
  behind the Wireless LAN router. This is done by sending a DNS request.
.
  Hereby a dial-up/DSL connection can be established, which would
  otherwise not be established before a first TCP/IP request was put
  from the client side. This is recommended only if a dial-up/DSL connection
  behind the Wireless LAN router does not cause unnecessary costs, because
  this connection is required at once or charged by a flatrate.
- [=IDT_IDCHB_EXECSETUP]
= select this option to execute parts of the *TCP/IP LAN configuration*
  (setup.cmd), when a Wireless LAN connection is disconnected from.
.
  This will reset the configuration of TCP/IP interfaces and routes
  to the state after system startup and is particular useful when
  [.IDPNL_CONFIGURE_SWITCH switching between wireless and cabled connections].
.
.
  As the LAN configuration script normally deletes the default route,
  on reconnect this may require reconfiguration of the TCP/IP interface,
  even if the disconnect event was generated only by turning the radio off
  (this normally only temporarily disables the TCP/IP interface and therefore
  does not require a reconfiguration).
..
- [=IDT_IDTXT_CONFLRESOLVE]
= select the action to take, when a TCP/IP address range
  conflict occurrs between the Wireless and another interface
.ul compact
  - [=IDT_IDSTR_CONFLRESOLVE_PROMPT]
  - [=IDT_IDSTR_CONFLRESOLVE_KEEPWLAN]
  - [=IDT_IDSTR_CONFLRESOLVE_KEEPOTHER]
  - [=IDT_IDSTR_CONFLRESOLVE_AUTO]
.el
..
- [=IDT_IDCHB_GATEWAYNAME]
= select this option to have the TCP/IP address of the Wireless LAN router
  being added to the %ETC%\hosts file, when the connection is established.
- [=IDT_IDTXT_GATEWAYNAME]
= enter the name that is used to add the TCP/IP address of the Wireless
  LAN router to the %ETC%\hosts file
- [=IDT_IDCHB_SETLLAADDRESS]
= select this option to set an LLA Address (169.254/16) for the TCP/IP
  interface of the wireless network interface, when a Wireless LAN connection
  is disconnected from.

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGETCPIP2] 2/2
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGETCPIP2
.res 1031
.
This page of the [=TITLE] properties notebook
determines the properties for the configuration
of the DHCP client:
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_DHCPCONFIGURE]
= select this option to let the [=TITLE] configure the DHCP
  client. This rewrites the
  [.IDPNL_CONFIGURE_DHCP DHCP Client configuration file]
  before every DHCP lease request
- [=IDT_IDCHB_DHCPRESETCLIENTDB]
= select this option to reset the DHCP Client database before
  putting a DHCP lease request. In some cases this helps
  preventing from problems when a DHCP lease cannot be refreshed,
  and only a new request works
- [=IDT_IDCHB_DHCPLOG]
= select this option to let the DHCP client create a logfile. Usually you should set this option to
  let run the DHCP client in the background (detached). If you prefer to see messages from DHCP client
  in a separate window instead creating a logfile, leave this option unchecked.
- [=IDT_IDTXT_DHCPLOGFILE]
= select this option to determine the logfile
- [=IDT_IDCHB_DHCPRESETLOG]
= select this option to reset the logfile before putting a new
  DHCP lease request
.an IDT_IDCHB_DHCLIENTBEEP
- [=IDT_IDCHB_DHCLIENTBEEP]
= select this option to get a beep when the connection is established
  and to activate audible feedback from DHCP client
.an IDT_IDCHB_DHIFOVERRIDE
- [=IDT_IDCHB_DHIFOVERRIDE]
= select this option to override the interface number dhclient should use. This maybe necessary when GENMAC returns a wrong number.
  For some configurations with Injoy Firewall and VirtualPC switch driver this GENMAC bug was observed. This option can work around this bug.
.an IDT_IDTXT_DHIFOVERRIDENR
- [=IDT_IDTXT_DHIFOVERRIDENR]
= select this option to override the interface number dhclient should use. This maybe necessary when GENMAC returns a wrong number.
  For some configurations with Injoy Firewall and VirtualPC switch driver this GENMAC bug was observed. This option can work around this bug.


.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEWPASUPP]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEWPASUPP
.res 104
.
This page of the [=TITLE] properties notebook
determines the properties for the WPA Supplicant.
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_WPASHOW]
= select this option to let [=TITLE] launch
  or turn a currently hidden WPA Supplicant visible
- [=IDT_IDTXT_WPADEBLEVEL]
= select the debug output level of the WPA Supplicant
.ul compact
  - [=IDT_IDSTR_WPA_DEBUGLEVEL_MSGDUMP]
  - [=IDT_IDSTR_WPA_DEBUGLEVEL_DEBUG]
  - [=IDT_IDSTR_WPA_DEBUGLEVEL_INFO]
  - [=IDT_IDSTR_WPA_DEBUGLEVEL_WARNING]
  - [=IDT_IDSTR_WPA_DEBUGLEVEL_ERROR]
.el

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGESCRIPT]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGESCRIPT
.res 105
.
This page of the [=TITLE] properties notebook
determines the scripting properties for the widget/window
of the [=TITLE]
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_ENABLESCRIPTS]
= select this option to let [=TITLE] execute a
  [.IDPNL_CONFIGURE_SCRIPT_CMD CMD] or
  [.IDPNL_CONFIGURE_SCRIPT_REXX REXX] style script
  on connect and disconnect events (after configuration
  or unconfiguration of the TCP/IP interface).
  The script must be named [.IDPNL_CONFIGURE_SCRIPT_FILES xwlan.cmd].
- [=IDT_IDTXT_SCRIPTPATH]
= specifies the path of the [.IDPNL_CONFIGURE_SCRIPT_FILES script, input and logfile(s)].
  The existance of the specified directory is not checked, but it must exist.
- [=IDT_IDPBS_BROWSE]
= allows selection of the script directory
- [=IDT_IDPBS_OPEN]
= opens the script directory
- [=IDT_IDCHB_WAITFORSCRIPTS]
= select this option to let [=TITLE] execute the script,
  waiting for it to end. It is highly recommended to deselect this
  option only under [.IDPNL_CONFIGURE_SCRIPT_ASYNC specific circumstances].
- [=IDT_IDPBS_EDITSCRIPT]
= loads the scriptfile into the System Editor.
.
  If the scriptfile does not exist, this pushbutton is disabled.
- [=IDT_IDPBS_VIEWLOG]
= loads the logfile into the System Editor.
.
  If the logfile does not exist, this pushbutton is disabled.

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEMOUSE]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEMOUSE
.res 106
.
This page of the [=TITLE] properties notebook
determines the action for the following mouse events:
.ul compact
- *[=IDT_IDTXT_MB1DBLCLICK]*
- *[=IDT_IDTXT_SMB1DBLCLICK]*
- *[=IDT_IDTXT_CMB1DBLCLICK]*
- *[=IDT_IDTXT_AMB1DBLCLICK]*

The following actions can be selected:
.. -----------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_MB1DBL_NEXTPRFSCAN]
= this lets the widget either
.ul compact
  - switch to the next connection profile, if a connection is active  or
  - activate the [.IDPNL_CONFIGURE_PROFILESCAN connection scan], if for the current
    profile a connection could not yet be established
.el
- [=IDT_IDSTR_MB1DBL_NEXTPRF]
= switch to the next connection profile.
- [=IDT_IDSTR_MB1DBL_ENABLERADIO]
= enable or disable the radio
- [=IDT_IDSTR_MB1DBL_DISABLETCPIP]
= disable or enable the TCP/IP interface
...
..  This is useful when you want to switch between the wireless and
..  a cabled network interface.
- [=IDT_IDSTR_MB1DBL_DLGPROPERTIES]
= launch the [.IDPNL_PROPERTIES properties notebook]
- [=IDT_IDSTR_MB1DBL_DLGHOTSPOTSCAN]
= launch the [.IDPNL_HOTSPOT_SCAN scan dialog]. This dialog is
  not available for GenPrism style drivers.
- [=IDT_IDSTR_MB1DBL_DLGEDITPROFILE]
= launch the [.IDPNL_PROFILE profile dialog]
.el
.at fc=red
[=NOTE]
.ul compact
- If radio is disabled, no connection profile switch or connection scan
  can be initiated with the mouse. An error beep is generated instead.
.at fc

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEERROR]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEERROR
.res 107
.
This page of the [=TITLE] properties notebook
determines how the user is notified of errors:
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_BEEPPROFILEERR]
= select this option to let the [=TITLE]
  generate an error beep, if a selected connection profile
  cannot be activated
- [=IDT_IDCHB_BEEPCONFIGERR]
= select this option to let the [=TITLE]
  generate an error beep, if TCP/IP configuration is selected
  for the current connection profile and this configuration
  was not successful
- [=IDT_IDCHB_BEEPRANGE]
= select this option to let the [=TITLE]
  generate an error beep when getting out of range or in range again

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEDISPLAY] 1/2
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEDISPLAY
.res 108
.
This page of the [=TITLE] properties notebook
determines the display properties for the widget:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_BITMAPSIZE]
= determines the size of the status symbols
.. -----------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_DISPLAY_DEFAULT_16] or
.
  *[=IDT_IDSTR_DISPLAY_DEFAULT_20]*
= let the status symbol be of the size of the mini icons.
  This is determined by the screen resolution and the size of
  the standard font. With some video drivers the size of the
  standard font (and with it the size of the icons and mini
  icons) can be changed by switching between small and large fonts.
- [=IDT_IDSTR_DISPLAY_FORCE_16]
= forces the size of the status symbol to 16 pixel
- [=IDT_IDSTR_DISPLAY_FORCE_20]
= forces the size of the status symbol to 20 pixel
.el
.. -----------------
- [=IDT_IDTXT_BITMAPROTATION]
= determines the rotation of the status symbols
.. -----------------
.sl compact
- *[=IDT_IDSTR_ROTATION_0]*
- *[=IDT_IDSTR_ROTATION_90]*
- *[=IDT_IDSTR_ROTATION_180]*
- *[=IDT_IDSTR_ROTATION_270]*
.el
.. -----------------

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEDISPLAY] 2/2
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEDISPLAY2
.res 109
.
This page of the [=TITLE] properties notebook
determines the status symbols to be used by the widget.

Within this dialog
.ul
- new status symbols can be load by pressing the button *[=IDT_IDPBS_LOADSET]*.
  For that within the following dialog a folder must be selected, containing
  the [.IDPNL_APPENDIXOWNBITMAPS respective bitmap files].
..
- all status symbols can be reset to their default view
  by pressing the button *[=IDT_IDPBS_DEFAULT]*.

[=NOTE]
.ul compact
- a folder with status bitmap files can also be loaded by
  [.IDPNL_CHANGEBITMAPS dragging] it onto the [=TITLE] window

.. ----------------------------------------
.4 [=IDT_IDDLG_PROPERTIES_PAGEINFO]
.. ----------------------------------------
.an IDPNL_PROPERTIES_PAGEINFO
.res 110
.
This page of the [=TITLE] properties notebook
displays program information.

.. ----------------------------------------
.3 [=IDT_IDDLG_SELECTPRF]
.. ----------------------------------------
.an IDPNL_PROFILE
.res 200
.
This dialog allows you to maintain the available profiles.

Press one of the pushbuttons in order to perform the respective action:
.pl compact break=none tsize=15
.
- *[=IDT_IDPBS_SELECTPROFILE]*
= activate the selected profile.
  If the selected profile is currently active, this pushbutton is disabled.
.
- *[=IDT_IDPBS_CREATEPROFILE]*
= create a new profile
.
- *[=IDT_IDPBS_COPYPROFILE]*
= create a new profile from the selected one
.
- *[=IDT_IDPBS_EDITPROFILE]*
= edit the selected profile
.
- *[=IDT_IDPBS_DELETEPROFILE]*
= delete the selected profile.
  If the selected profile is currently active, this pushbutton is disabled.
.
- *[=IDT_IDPBS_IMPORTPROFILE]*
= import a profile previously exported with *[=IDT_IDPBS_EXPORTPROFILE]*
.
- *[=IDT_IDPBS_EXPORTPROFILE]*
= export the selected profile

.. ----------------------------------------
.3 Profile Properties
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES
.res 300
.
The properties notebook for a connection profile
of the [=TITLE] contains the following pages:
.su H50 1

.. ----------------------------------------
.4 [=IDT_IDDLG_PROFILE_PAGECONNECTION] 1/2
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES_PAGECONNECTION
.res 301
.
This page of the properties notebook for a
connection profile of the [=TITLE]
determines the following connection properties:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_NAMECAPTION]
= this property determines the name of the profile
- [=IDT_IDTXT_MODECAPTION]
= this property determines the connection mode, in which the Wireless LAN device
  should connect to a partner:
.. -----------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_STATIONMODE_BSS]
= this mode lets your Wireless LAN device connect
  to other devices implementing a basic or extended service set. This is mostly a
  so-called communication point, providing a gateway to a conventional LAN based on cables
  (e.g. a public access point/hotspot).
- [=IDT_IDSTR_STATIONMODE_ADHOC]
= this mode lets your Wireless LAN device connect other Wireless LAN Clients,
  building a mobile Wireless LAN.
.el
.. -----------------
- [=IDT_IDTXT_SSIDCAPTION]
= specify the name of the Wireless LAN. This lets the Wireless LAN device establish
  connections only to partners using the same network name.
.
  If you don't specify a network name, the Wireless LAN device will connect to any system
  matching the connection mode (either BSS/ESS or ADHOC)
- [=IDT_IDCHB_CREATEIBSS]
= this option is useful if the device is run in *peer mode* and no-one has already
  established a Wireless Peer LAN matching this connection profile. Selecting this
  option then will let the Wireless LAN device of this system establish it, once
  the connection profile is being activated.
.
  This option is ignored for devices being supported by the GenMac driver,
  as Windows drivers always create a peer network if none exists.
- [=IDT_IDCHB_INCLUDEINSCAN]
= select this option, if you want this connection profile being included
  in the [.IDPNL_CONFIGURE_PROFILESCAN connection scan]

.. ----------------------------------------
.4 [=IDT_IDDLG_PROFILE_PAGECONNECTION2] 2/2
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES_PAGECONNECTION2
.res 302
.
This page of the properties notebook for a
connection profile of the [=TITLE]
determines the following connection properties:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_SELNETWORK]
= determines the network type
.ul compact
  - [=IDT_IDSTR_NETWORK_ANY]
  - [=IDT_IDSTR_NETWORK_80211B_11MBIT]
  - [=IDT_IDSTR_NETWORK_80211G_54MBIT]
  - [=IDT_IDSTR_NETWORK_80211A_54MBIT]
.el
.
.at fc=red
  This property is currently experimental and
  therefore deactivated
.at

.. ----------------------------------------
.4 [=IDT_IDDLG_PROFILE_PAGESECURITY]
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES_PAGESECURITY
.res 303
.
This page of the properties notebook for a
connection profile of the [=TITLE]
determines the security properties:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_WEPCAPTION]
= this property determines the encryption mode, in which the
  Wireless LAN device should connect to a partner. The protocols in the
  list are ordered from the least to the most secure one.
.
  The partner, either an access point or another Wireless LAN device in
  another computer, must use the same setting. It is recommended to
  [.IDPNL_CONFIGURE_SECURITY use WPA or WPA2 encryption] whereever possible.
.. -----------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_WEPMODE_DISABLED]
= this disables the encryption. Don't use this setting for private Wireless LANs, because
  otherwise your system may be misused and your private data can be reached from outside.
  Not using encryption does make sense only when your system is to take part in a
  [.IDPNL_CONFIGURE_SECURITY public Wireless LAN].
.
- [=IDT_IDSTR_WEPMODE_WEP64]
= this lets the device encrypt all data with a 64 bit WEP key.
.
  Select this option for private Wireless LANs only if no better encryption
  standard is available for all stations taking part in that LAN, as this level can be
  cracked easier than stronger ones. Nevertheless this encryption level at any time
  provides a better security than not using any encryption at all.
  For more details read the section [.IDPNL_CONFIGURE_SECURITY].
- [=IDT_IDSTR_WEPMODE_WEP128]
= this lets the device encrypt all data with a 128 bit WEP key.
.
  Select this option for all private Wireless LANs, if no WPA encryption is available.
  For more details read the section [.IDPNL_CONFIGURE_SECURITY].
.
.
  *WEP encryption* is configured by the following settings:
.. ---------
.sl
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_TXKEYCAPTION]
= this property determines the key to be used for encryption of data transmitted by your
  Wireless LAN device. Your partner must have the same key configured in any of its four
  key slots in order to be able to decrypt your data. If your partner has the same
  four keys configured like for your device, you can choose any of the keys for transmission.
- ##1 to ##4
= WEP keys either specified as
.ul compact
  - characters and numbers  or
  - a hexadecimal value (prepending the value with a *0x* tag)
.el
.el
  In order to [.IDPNL_KEYGEN generate the WEP-Keys for encryption automatically], press the pushbutton
  *[=IDT_IDPBS_GENERATE]*. This saves you from the hassle of manually entering long hex values.
.el
.
- [=IDT_IDSTR_WEPMODE_WPA_PSK]
= this lets a [.IDPNL_PREREQUISITES GenMac] compatible Wireless LAN device
  encrypt all data with WPA, using the RC4 stream cipher.
  The preshared key is used to calculate a master key. This is used by the TKIP protocol
  to create working keys, which are changed after a given amount of time.
.
  Select this option for all private Wireless LANs, if no WPA2 encryption is available.
  For more details read the section [.IDPNL_CONFIGURE_SECURITY].
- [=IDT_IDSTR_WEPMODE_WPA2_PSK]
= this lets a [.IDPNL_PREREQUISITES GenMac] compatible Wireless LAN device
  encrypt all data with WPA2, using the more secure AES block cipher.
  The preshared key is used to calculate a master key. This is used by the CCMP protocol
  to create working keys, which are changed after a given amount of time.
  Select this option for all private Wireless LANs, wherever WPA2 is available, as it is the
  most secure protocol. For more details read the section [.IDPNL_CONFIGURE_SECURITY].
.el
.
.. ---------
  For *WPA encryption*, the following controls are available:
.sl
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_WPAPSK]
= this property determines the preshared key. It may have a length from 8 to 63
  characters.

.. ----------------------------------------
.5 Generating WEP keys
.. ----------------------------------------
.an IDPNL_KEYGEN
.res 400
.
This dialog allows to generate automatically the WEP keys that are required for
encryption of the data sent within the Wireless LAN, and that will be stored
in the [.IDPNL_PROFILEPROPERTIES_PAGESECURITY security properties]:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_KEYGENTYPE]
= Select the algorithm to be used for generating the WEP keys
- [=IDT_IDTXT_PASSPHRASE]
= Enter a string of any length

.. ----------------------------------------
.4 [=IDT_IDDLG_PROFILE_PAGETCPIP]
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES_PAGETCPIP
.res 304
.
This page of the properties notebook for a
connection profile of the [=TITLE]
determines the TCP/IP configuration properties:
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_CONFIGTYPE_NONE]
= select this option to let the [=TITLE] not configure the
  TCP/IP interface of your Wireless LAN device
- [=IDT_IDSTR_CONFIGTYPE_DHCP]
= select this option to let the [=TITLE] configure the
  TCP/IP interface of your Wireless LAN
  device automatically using DHCP.
  For that a DHCP server has to be reachable via the Wireless LAN.
.
  If the TCP/IP interface has already the same adress as after the
  last successful DHCP configuration, the configuration step is skipped.
  The DHCP configuration can be forced by executing *ifconfig #lanx# down*
  on the command line for the respective TCP/IP interface before selecting the
  connection profile set to DHCP configuration.
.
.
  Select the following options in order to configure the respective
  [.IDPNL_CONFIGURE_DHCP_OPTIONS DHCP options]:
.. ---------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_OPTIONDNS]
= select to request selected DNS related values from the DHCP server.
  If this option is deselected, the returned DNS values are ignored.
- [=IDT_IDCHB_OPTIONSTATICROUTES]
= select to request the static routes provided by the DHCP server.
  If this option is deselected, any returned static route will be ignored.
- [=IDT_IDCHB_OPTIONHOSTNAME]
= select to provide the DHCP server with the hostname of your system.
.el
.. ---------------
- [=IDT_IDSTR_CONFIGTYPE_MANUALLY]
= select this option to determine the TCP/IP address and network mask for the
  TCP/IP interface of your Wireless LAN device manually
.. ---------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_TCPIPADDRESS]
= specifies the address for the TCP/IP interface
  of your Wireless LAN device, if configured manually
- [=IDT_IDTXT_NETMASK]
= specifies the network mask for the TCP/IP interface
  of your Wireless LAN device, if configured manually.
  If no value is specified, the standard netmask for the specified TCP/IP address
  is used.
- [=IDT_IDPBS_CONFIGMORETCPIP]
= allows the [.IDPNL_PROFILEPROPERTIES_CONFIGMORETCPIP]
.el
.. ---------------

.. ----------------------------------------
.4 [=IDT_IDDLG_PROFILE_PAGEAUTOSTART]
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES_PAGEAUTOSTART
.res 305
.
This page of the properties notebook for a
connection profile of the [=TITLE]
determines the Autostart properties:
.pl [=PARMLIST_PARMS]
- [=IDT_IDCHB_LAUNCHBROWSER]
= select this option to let the [=TITLE] automatically
  start the standard web browser configured
  for your system.

.. ----------------------------------------
.5 Configuration of more TCP/IP options
.. ----------------------------------------
.an IDPNL_PROFILEPROPERTIES_CONFIGMORETCPIP
.res 401
.
This dialog allows to configure more options for TCP/IP configuration
for a connection profile:
.pl [=PARMLIST_PARMS]
- [=IDT_IDTXT_GATEWAY]
= specifies the TCP/IP address of the default gateway
.
  If no default gateway address is specified, an existing default
  route is not deleted.
- [=IDT_IDCHB_CONFIGDNS]
= select this option to let [=TITLE] configure the
  Domain Name Service for the Wireless LAN
- [=IDT_IDTXT_DOMAIN]
= specifies the name of the TCP/IP domain of the Wireless LAN
- [=IDT_IDTXT_DNS]
= specifies the TCP/IP address of the Domain Name Server
- [=IDT_IDTXT_MTU]
= determines the size of the Maximum Transmission Unit (MTU)
.. ------------
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_MTUTYPE_ETHERNETMAX]
= select this option to set the MTU to the default value of 1500 bytes for Ethernet networks
- [=IDT_IDSTR_MTUTYPE_DSL]
= select this option to set the MTU to the optimized value of 1492 bytes for the
  network protocol *PPP over Ethernet*, which is used for DSL connections
- [=IDT_IDSTR_MTUTYPE_USERDEFINED]
= select this option to set a user-defined value for the MTU in the range of 128 to 1500 bytes
.. ------------

.. ----------------------------------------
.3 Detecting public Wireless LANs
.. ----------------------------------------
.an IDPNL_HOTSPOT
.res 150
.
In order to detect a public Wireless LAN access point (hotspot), select
the menu item *[=IDT_IDMEN_HOTSPOT]*.

Depending on the type of the device driver (either GenPrism or GenMac) handling
your currently selected Wireless LAN device, this menu contains either one
or both of the following menu entries:
.pl [=PARMLIST_PARMS]
- [=IDT_IDMEN_HOTSPOT_SCAN]
= the GenMac driver supports to scan for all hotspots in range. The [=TITLE]
  launches a [.IDPNL_HOTSPOT_SCAN Dialog], which displays all public (and
  optionally all private) wireless networks in range and allows to connect
  to any public access point/hotspot in range. This menu entry is not
  available for GenPrism style drivers.
- [=IDT_IDMEN_HOTSPOT_CONNECT]
= the GenPrism driver and some other drivers being compatible to it
  do not provide a feature to scan for hotspots, but instead only
  to connect to any public Wireless LAN in range.
.
  If more than one hotspot is in range, you cannot influence which hotspot
  a connection is established to. Which hotspot is used depends on the
  Wireless LAN device (either strongest signal or due to the send channel).
  This menu entry is available for both driver types.

In order to find out to which public Wireless LAN you are currently connected
with that profile, move the mouse over the [=TITLE]. The *SSID* of the
Wireless LAN you are connected to is displayed within the third line of the
tooltip text.

If [=TITLE] established a connection to a public access point/hotspot, a new
[.IDPNL_HOTSPOT_NEWPROFILE connection profile can be created] from
this connection by selecting the menu item
*[=IDT_IDMEN_HOTSPOT]* - *[=IDT_IDMEN_HOTSPOT_COPYPRF]*.

In order to ease opening a web browser that may be required for registration
at a public access point/hotspot that is charged for, this menu contains the item
*[=IDT_IDMEN_HOTSPOT_BROWSER]*. It starts the standard web browser configured
for your system.

.. ----------------------------------------
.4 [=IDT_IDDLG_NEWPROFILE]
.. ----------------------------------------
.an IDPNL_HOTSPOT_NEWPROFILE
.res 151
.
This dialog allows to give a name to the profile, which is to be created
from a current connection to a public Wireless LAN.

The new profile will be activated after having been created successfully.

.. ----------------------------------------
.4 [=IDT_IDDLG_SCANHOTSPOT]
.. ----------------------------------------
.an IDPNL_HOTSPOT_SCAN
.res 152
.
This dialog displays all public and/or private access points
of Wireless LANs in range and allows to connect to
either public access points (also called hotspots)
or known private access points. More than one access point may
exist for a given network.

In order to connect, select a network/an access point in
the list and press the pushbutton *[=IDT_IDPBS_CONNECT]* or double-click on
a network, if it is
.ul compact
- a public and thus unprotected network
- a private and thus protected network for which one or more
  matching connection profiles exist

The pushbutton *[=IDT_IDPBS_CONNECT]* is deactivated if
you select a network
.ul compact
- that your system is already connected to, including all entries
  with the same network name (same SSID)
- which is hidden

The list of networks provide the following data in columns:
.pl [=PARMLIST_PARMS]
- [=IDT_IDSTR_TITLE_TYPE]
= This column displays a type identifier for the network:
.pl break=none tsize=3
..-
...bi 80211a11.bmp
..= 11 MBit network on 5 Ghz according to the IEEE 802.11a standard
-
.bi 80211a54.bmp
= 54 MBit network on 5 Ghz according to the IEEE 802.11a standard
-
.bi 80211b11.bmp
= 11 MBit network on 2.4 Ghz according to the IEEE 802.11b standard
-
.bi 80211g54.bmp
= 54 MBit network on 2.4 Ghz accoding to the IEEE 802.11g standard
.el
- [=IDT_IDSTR_TITLE_SSID]
= Name of the network (System Service Identifier/SSID).
.
  The following type of entries can be displayed here (using the
  network name *MyNetwork* as a sample here):
.pl [=PARMLIST_PARMS]
- *MyNetwork*
= This is a visible network (the SSID is broadcasted).
  If the network is not protected, it can be connected to.
- *MyNetwork (**)*
= This is the access point the system is connected to.
- *MyNetwork <**>*
= This is an access point using the same SSID as the access point the system is connected to.
- *[=IDT_IDSTR_ITEM_HIDDEN]*
= This network is hidden (the SSID is not broadcasted).
  Since the system never was connected to this access point,
  the [=TITLE] cannot know the network name.
- *(MyNetwork)*
= This network is hidden (the SSID is not broadcasted).
  Since the name was saved from your last connection to
  that access point, it can be displayed.
.el
- [=IDT_IDSTR_TITLE_PROFILES]
= displays all connection profiles matching the SSID and the privacy setting of the network
- [=IDT_IDSTR_TITLE_ACCESSTYPE]
= displays the access type of the network, either
  *[=IDT_IDSTR_ITEM_PUBLIC]* or *[=IDT_IDSTR_ITEM_PRIVATE]*
- [=IDT_IDSTR_TITLE_SIGNAL]
= displays the signal strength in percent
- [=IDT_IDSTR_TITLE_CHANNEL]
= displays the channel on which the access point of the network sends
- [=IDT_IDSTR_TITLE_MACADDRESS]
= displays the MAC address of the access point

.. ----------------------------------------
.5 Profile selection
.. ----------------------------------------
.an IDPNL_HOSTPOT_SELPROFILE
.res 153
.
This dialog allows you to select among the conection profiles which exist
for the wireless network being selected in the [.IDPNL_HOTSPOT_SCAN scan dialog].

.. ----------------------------------------
.3 Changing status symbols
.. ----------------------------------------
.an IDPNL_CHANGEBITMAPS
.
The [=TITLE] allows to modify the images of the [.IDPNL_STATUS status symbols].

For that you need to place one or more
[.IDPNL_APPENDIXOWNBITMAPS bitmap files with certain filenames]
into a folder.

In order to load the bitmap files within this folder
.ul
- drag the folder onto the [=TITLE] window
..
- load the folder via the [.IDPNL_PROPERTIES_PAGEDISPLAY2 second display properties page]

Both actions open the [.IDPNL_CHANGEBITMAPS_DIALOG].

.. ----------------------------------------
.4 Status Image Dialog
.. ----------------------------------------
.an IDPNL_CHANGEBITMAPS_DIALOG
.res 402
.
The Status Image Dialog contains two containers, displaying
the set of status symbols currently used on the left side, and
the status symbols available in the folder being dropped on the [=TITLE] window
on the right side. All symbols on the right side that are not yet active,
are automatically selected.

The following actions can be performed:
.ul
- the status symbols of the left side get active when the dialog is closed
- all status symbols selected in the right container can be applied to the
  left side by pressing the *[=IDT_IDPBS_APPLY]* pushbutton
- the status symbols of the left side can be reset to the default built-in symbols
  by pressing the *[=IDT_IDPBS_DEFAULT]* pushbutton
- both containers can be reset to the current status of the program
  by pressing the *[=IDT_IDPBS_UNDO]* pushbutton

.. ----------------------------------------
.3 Additional options for the standalone [=BASETITLE]
.. ----------------------------------------
.an IDPNL_EXEOPTIONS
.in __standalone
.
The [=TITLE] is available both as XCenter Widget as well as a standalone program.
For the standalone program the following, additional options are available via the
context menu *[=IDT_IDMEN_WINDOWCFG]* that are not required for the XCenter Widget:
.pl [=PARMLIST_PARMS]
- [=IDT_IDMEN_STAYONTOP]
= select this option, if the window of the [=TITLE] is to stay on top of all others,
  so that it is not hidden by any other window
- [=IDT_IDMEN_HIDETLENTRY]
= select this option, if the entry of the [=TITLE] is to be hidden within the window list
- [=IDT_IDMEN_LARGESIZE]
= select this option, if the window of the [=TITLE] is to be displayed in larger size

In addition to that the window of the standalone program
can be moved with mouse button one.

.. ----------------------------------------
.2 Configuration
.. ----------------------------------------
.an IDPNL_CONFIG
.
[=TOPICS]
.su V30 u 1

.. ----------------------------------------
.3 Configure [=BASETITLE]
.. ----------------------------------------
.an IDPNL_CONFIG_CONFIGURE
.
The configuration of the [=TITLE] concerns two parts,
namely the Wireless LAN connection, providing the physical
connection (comparable to a network cable), and the
TCP/IP interface of the Wireless LAN device, providing
the logical connection.

_*Configuring the Wireless LAN connection*_

First of all, you can connect to immobile Wireless LANs
with an access point and mobile *ad-hoc* or *peer* networks.
Immobile, cabled networks provide access to itself
for Wireless LAN clients by one or more access points,
implementing a so-called basic or extended Wireless LAN service set.
A mobile *ad-hoc* network instead consists of two or more
Wireless LAN clients only and connects only these with each other,
without requiring an access point.

Another distinction is to be made between
.ul compact
- [.IDPNL_HOTSPOT public] (and therefore unsecured) networks,
  which acess points are also called [.IDPNL_HOTSPOT hotspots]
- private (and [.IDPNL_CONFIGURE_SECURITY secured]) networks

Within this program [.IDPNL_PROFILEPROPERTIES connection profiles] are used
for setting up Wireless LAN connections. Click onto the [=TITLE]
widget/window with mouse button two and select one of the
following actions
.ul compact
- scan for or connect to a [.IDPNL_HOTSPOT public access point/hotspot] by actions
  provided in the *[=IDT_IDMEN_HOTSPOT]* submenu, using a default
  and built-in connection profile
- create and use as many [.IDPNL_PROFILEPROPERTIES connection profiles]
  as you like, to access specific Wireless LANs, by the following actions
.ul compact
  - create or modify a connection profile by selecting
    *[=IDT_IDMEN_EDITPROFILE]*
  - activate a connection profile by the submenu *[=IDT_IDMEN_SELECTPROFILE]*
  - optionally include self-defined connection profiles in the
    [.IDPNL_CONFIGURE_PROFILESCAN]
.el

_*Configuring the TCP/IP interface*_

After a Wireless LAN connection has been established,
a setup of the required network protocols is required.
Currently, the [=TITLE] supports the configuration of
the *TCP/IP* interface of the Wireless LAN device.
Any other setup may be included by
the user by a [.IDPNL_CONFIGURE_SCRIPT script],
which will be called when (dis)connecting.

Although the NDIS device driver for your Wireless LAN device
will provide a *LAN* interface (Local Area Network), it
nevertheless should be configured just like a *WAN* interface
(Wide Area Network), so like a dial-in connection.

Therefore it is highly recommended to not configure it
within the *TCP/IP configuration program*, but instead only by the
program establishing or closing the WAN connection
(here: by the [=TITLE]).

Within a self-created [.IDPNL_PROFILEPROPERTIES connection profile],
three types of [.IDPNL_PROFILEPROPERTIES_PAGETCPIP TCP/IP configuration]
can be selected:
.ul compact
- [=IDT_IDSTR_CONFIGTYPE_NONE]
- [=IDT_IDSTR_CONFIGTYPE_DHCP]
- [=IDT_IDSTR_CONFIGTYPE_MANUALLY]

When connecting to a hotspot, a default built-in connection profile is being used,
assuming that no security (no encryption) and automatic TCP/IP configuration via DHCP
is provided.

When home networks are extended by Wireless LAN access points, it is often asked
how one can [.IDPNL_CONFIGURE_SWITCH switch between wireless and cabled
connection to the same network].

.. ----------------------------------------
.3 Using encryption in Wireless LANs
.. ----------------------------------------
.an IDPNL_CONFIGURE_SECURITY
.
When taking part in Wireless LANs, you must take countermeasures against
attacks from outside, as your system otherwise can be accessed easily.

This is especially important, if you add a Wireless LAN access point
to your own network, wich has a connection to the internet.
.at fc=red
It is a widely spread mistake to think that a system not holding important data
does not need to be protected. Any system that has connection to the internet
may be misused for illegal actions within the internet, leaving your
TCP/IP address as the only visible trace and with it you under suspect,
having committed those illegal actions. Moreover, if you don't have a flatrate for
internet access, it may cause additional costs for you if somebody uses your
internet connection.
.at

Besides that, clients (notebooks) taking part in a Wireless LAN need extra protection.
Depending on if the Wireless LAN is public or not, the following actions are recommended:

_*Taking part in public Wireless LANs*_

Public Wireless LANs are accessed via so-called hot spots, which are nothing else
than a public and thus unsecured access point. When accessing a hot spot, it
does obviously not make sense to use data encryption at all, as any encryption key would
have necessarily to be publicly available anyway.
.
In this case it is highly recommended to run a firewall sofware on your system to
prevent possible attacks, being configured, to prevent any access to running
.ul compact
- File and Print Services via the network protocol *NetBIOS over TCP/IP*
- any TCP/IP services on your system like Web-, Telnet or FTP servers.

As an alternative to using a firewall sofware, before activating a
Wireless LAN connection the respecive services or programs can be stopped in
order to eliminate attack targets.

_*Taking part in private Wireless LANs*_

When establishing a private Wireless LAN, no matter whether an access point is used
or it is a so-called adhoc network without an access point, it is highly recommended to
use the best encryption standard being available
for all stations taking part. This is important as
.ul compact
- a WPA or better WPA2 secured Wireless LAN is currently secure against known attacks
  that may succeed against WEP secured Wireless LANs.
  WPA/WPA2 encryption is only supported for Wireless LAN devices that are used with the
  [.IDPNL_PREREQUISITES GenMac driver].
- a WEP secured Wireless LAN at least is a less interesting target for attacks compared
  to an unsecured one, especially for attackers that only want to have a quick and free
  access to the internet. Nevertheless it can be hacked.
- in some countries/states it is at least illegal to spy out a Wireless LAN being secured by
  encryption


.. ----------------------------------------
.3 Profile connection scan
.. ----------------------------------------
.an IDPNL_CONFIGURE_PROFILESCAN
.
Self-defined [.IDPNL_PROFILEPROPERTIES connection profiles] can be
included in a profile connection scan. When such a scan is started, the
[=TITLE] loads one included profile after another, and stops, once
a connection could be established with one of the profiles.

This makes sense only for private networks, as for accessing public networks
it would be more useful to manually scan for or connect to a
[.IDPNL_HOTSPOT public access point/hotspot] - for
[.IDPNL_CONFIGURE_SECURITY security reasons] one should connect to a public
hotspot only on purpose, and not accidentally/automatically.

Within the [.IDPNL_PROPERTIES_PAGESCAN] properties notebook page
the connection scan can be configured to start automatically at
program startup and/or on reinsertion of a PCMCIA card.

A common use case for the profile connection scan is to at least
create two connection profiles, let's say one for each Wireless LAN
network in the office and at home.
When the [=TITLE] is configured to scan the included connection
profiles on its startup, it will, at least after some seconds,
always automatically establish a connection to one of the
private networks in question, once the system is started in range
of one of these.

.. ----------------------------------------
.3 Using scripts for (dis)connect events
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT
.
[=TITLE] can execute scripts (plain CMD scripts or REXX type) on connect
and disconnect events in order to process any user defined commands for your
Wireless LAN connections.

This script is executed
.ul compact
- after the TCP/IP interface has been configured  or
- before it is unconfigured

[=TOPICS]
.su H50

.. ----------------------------------------
.4 Script and log filenames
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT_FILES
.
The following files are used by [=TITLE] when
existing within the
[.IDPNL_PROPERTIES_PAGESCRIPT script directory]:
.pl [=PARMLIST_PARMS]
- xwlan.cmd
= either a [.IDPNL_CONFIGURE_SCRIPT_CMD CMD] or
  [.IDPNL_CONFIGURE_SCRIPT_REXX REXX] style script
- xwlan.in
= text file containing the data for
  [.IDPNL_CONFIGURE_SCRIPT_REDIRINPUT keyboard input redirection]

The following files are written by [=TITLE]
within the
[.IDPNL_PROPERTIES_PAGESCRIPT script directory]:
.pl [=PARMLIST_PARMS]
- xwlan.log
= cummulated logfile with the standard output and error output
  of the calls to the xwlan.cmd script
- xwlan.#xxx#
= where #xxx# is a three digit random number: temporary logfile
  with the output of one call to the xwlan.cmd script. In case that
  such a temporary logfile cannot be appended to the cumulated logfile,
  the temporary logfile remains in the script directory

.. ----------------------------------------
.4 Using a CMD script
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT_CMD
.
When using a plain [.IDPNL_APPENDIXSCRIPT_CMD CMD script]
for (dis)connect events,
the following environment variables are passed to it in
order to allow to take appropriate action within the script:
.ul compact
- [.FN_VAR_EVENT WLAN__EVENT]
- [.FN_VAR_PROFILENAME WLAN__PROFILENAME]
- [.FN_VAR_SSID WLAN__SSID]
- [.FN_VAR_IPCONFIG WLAN__IPCONFIG]
- [.FN_VAR_IPINTERFACE WLAN__IPINTERFACE]
- [.FN_VAR_IPADDRESS WLAN__IPADDRESS]
- [.FN_VAR_IPNETMASK WLAN__IPNETMASK]
- [.FN_VAR_DRIVERNAME WLAN__DRIVERNAME]
- [.FN_VAR_DRIVERTITLE WLAN__DRIVERTITLE]
- [.FN_VAR_SCRIPTDIR WLAN__SCRIPTDIR]

.. ----------------------------------------
.4 Using a REXX script
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT_REXX
.
When using a [.IDPNL_APPENDIXSCRIPT_REXX REXX script]
for (dis)connect events,
the following variables are passed to it in
order to allow to take appropriate action within the script:
.ul compact
- [.FN_VAR_EVENT WLan.__EVENT]
- [.FN_VAR_PROFILENAME WLan.__PROFILENAME]
- [.FN_VAR_SSID WLan.__SSID]
- [.FN_VAR_IPCONFIG WLan.__IPCONFIG]
- [.FN_VAR_IPINTERFACE WLan.__IPINTERFACE]
- [.FN_VAR_IPADDRESS WLan.__IPADDRESS]
- [.FN_VAR_IPNETMASK WLan.__IPNETMASK]
- [.FN_VAR_DRIVERNAME WLan.__DRIVERNAME]
- [.FN_VAR_DRIVERTITLE WLan.__DRIVERTITLE]
- [.FN_VAR_SCRIPTDIR WLan.__SCRIPTDIR]

.. ----------------------------------------
.4 running the script asynchronously
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT_ASYNC
.
By default, [=TITLE] waits for the end of the script execution before further
processing a disconnect or connect procedure, so that more actions can only
be taken after a script has ended.

When a script needs much time to execute an event and therefore blocks the
[=TITLE] too long, on the [.IDPNL_PROPERTIES_PAGESCRIPT] properties page
the option *[=IDT_IDCHB_WAITFORSCRIPTS]* can be deselected.

Then the execution of an event will not any longer block the [=TITLE].
In every case only one script will be executed at a time, for that
each call to the script, being started in a separate thread, waits for
the end of the script call currently running.

There will be a problem though if by repeated user interaction the script
is called multiple times and these calls wait together for the end of the
currently running script - in such a case the order of the calls is not
guaranteed.

In order to avoid this problem:
.ul compact
- let the [=TITLE] call the script synchronously again
- take lenghty commands into a separate script, which would be
  launched with the [inf:cmdref START] command from within the
  [=TITLE] script.

.. ----------------------------------------
.4 Using Keyboard Input Redirection
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT_REDIRINPUT
.
In case that any command executed within the script
needs keyboard input, you may use the contents of the
file [.IDPNL_CONFIGURE_SCRIPT_FILES xwlan.in]
within the [.IDPNL_PROPERTIES_PAGESCRIPT script directory]
in place of keyboard input. Otherwise the script may just hang and
never end when executing commands that expect keyboard input.

.at fc=red
[=NOTE]
.ul compact
- this will work only for commands *not flushing the keyboard buffer*
  before accepting the keyboard input. Commands flushing the keyboard
  buffer cannot be used in the xwlan.cmd script.
.at

.. ----------------------------------------
.4 Important Working Directory Considerations
.. ----------------------------------------
.an IDPNL_CONFIGURE_SCRIPT_WORKINGDIR
.
When the widget of the [=TITLE] executes a script,
the root directory of the boot drive of the operating system
is the current directory.

.at fc=red
[=NOTE]
.ul compact
- the script may not change the current directory or at least reset it
  to the previous directory before ending your script, otherwise you
  change the working directory for the complete *Workplace Shell*, this may
  lead to unpredictable results.
- in order to reset the current directory the following methods can be used
.ul
  - in a [.IDPNL_APPENDIXSCRIPT_CMD CMD script]
.ul compact
    - at start execute the [inf:cmdref SETLOCAL] command and
    - at the end execute the [inf:cmdref ENDLOCAL] command
.el
.
    Note however that these commands cannot be nested.
  - in a [.IDPNL_APPENDIXSCRIPT_REXX REXX script]
.ul compact
    - at start call the [inf:rexx SETLOCAL] function and
    - at the end call the [inf:rex ENDLOCAL] function
.el
.el
.at

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_EVENT
.
CMD script variable: WLAN__EVENT
.
REXX script variable: WLan.__EVENT

This variable specifies the event that the script is called on,
and has one of the following values:
.ul compact
- CONNECT
- DISCONNECT
.el

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_PROFILENAME
.
CMD script variable: WLAN__PROFILENAME
.
REXX script variable: WLan.__PROFILENAME

This variable specifies the name of the profile,
as entered on the [.IDPNL_PROFILEPROPERTIES_PAGECONNECTION]
profiles properties page.

If a connection to a [.IDPNL_HOTSPOT hotspot] is active,
this variable is empty.

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_SSID
.
CMD script variable: WLAN__SSID
.
REXX script variable: WLan.__SSID

This variable specifies the [=IDT_IDTXT_SSIDCAPTION] of the access point
connected to.

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_IPCONFIG
.
CMD script variable: WLAN__IPCONFIG
.
REXX script variable: WLan.__IPCONFIG

This variable specifies the type of TCP/IP configuration being taken,
as entered on the [.IDPNL_PROFILEPROPERTIES_PAGETCPIP]
profiles properties page,
and has one of the following values:
.ul compact
- NONE
- MANUALLY
- DHCP
.el

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_IPINTERFACE
.
CMD script variable: WLAN__IPINTERFACE
.
REXX script variable: WLan.__IPINTERFACE

This variable specifies the TCP/IP interface that the
Wireless LAN device is bound to.

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_IPADDRESS
.
CMD script variable: WLAN__IPADDRESS
.
REXX script variable: WLan.__IPADDRESS

This variable specifies the TCP/IP address that the interface
of the Wireless LAN device is currently configured to.

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_IPNETMASK
.
CMD script variable: WLAN__IPNETMASK
.
REXX script variable: WLan.__IPNETMASK

This variable specifies the network mask that the interface of
the Wireless LAN device is currently configured to.

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_DRIVERNAME
.
CMD script variable: WLAN__DRIVERNAME
.
REXX script variable: WLan.__DRIVERNAME

This variable specifies the name of your Wireless LAN device
driver, like e.g.: *PRISMC$*

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_DRIVERTITLE
.
CMD script variable: WLAN__DRIVERTITLE
.
REXX script variable: WLan.__DRIVERTITLE

This variable specifies the title of your Wireless LAN device
driver, like e.g.: *Generic PRISM driver for PCMCIA/PLX cards*

.. + + + + + + + + + + + + + + + + + + + +
.fn
.an FN_VAR_SCRIPTDIR
.
CMD script variable: WLAN__SCRIPTDIR
.
REXX script variable: WLan.__SCRIPTDIR

This variable specifies the script directory
that the script resides in,
as entered on the [.IDPNL_PROPERTIES_PAGESCRIPT]
properties page.

.. ----------------------------------------
.3 Wireless and cabled connection to the same Network
.. ----------------------------------------
.an IDPNL_CONFIGURE_HYBRID
.
It has frequently been asked how a user can connect from a
notebook to the same (home) network twice,
both with a wireless and a cabled connection at the same time.
There was also the expectation that the system would on its own
detect which of the two connections would be available,
and on the fly switch between the two. If both connections
would be available, the system would automatically
choose the faster one.

*Unfortunately this is not possible.*
.
[=TOPICS]
.su 1 H50

.. ----------------------------------------
.4 sample network scenario
.. ----------------------------------------
.an IDPNL_CONFIGURE_HYBRID_SCENARIO
.
Let's take a widely used network setup, consisting of
.ul compact
- a (A)DSL router, also serving as a Wireless LAN access point and DHCP server
- a notebook with a installed and working Wireless LAN device

The following applies to the scenario:
.ul compact
- The example would also apply if no DHCP server, but instead static TCP/IP
  addresses are being used.
- Instead of a DSL router or in addition to that, one
  or more desktop PCs can take part in this scenario. Also in such case
  the problem will be that _any_ of the other network components
  (may it be a router or any other PC) should be reachable by
  cable or wireless at any time.

In our sample scenario the TCP/IP configuration would be:

_*router/access point/DHCP server*_
.fo off
lan0 192.168.1.1/255.255.255.0
.fo on

_*notebook*_
.fo off
  cabled lan0     192.168.1.2/255.255.255.0
wireless lan1     192.168.1.3/255.255.255.0
default route to  192.168.1.1/255.255.255.0
.fo on

[=NOTE]
.ul
- in the notebook both a cabled and a wireless
  TCP/IP interface is configured for the same TCP/IP subnetwork
  (192.168.1), as they get their configuration from the very same
  DHCP server. This needed also to be the case if these interfaces
  would be configured with static TCP/IP addresses, as both are intended
  to reach every other component in the TCP/IP subnetwork
  (here: the router).
- while the OS/2 and eComstation DHCP client
  is restricted to one DHCP configured LAN interface only, it is still possible
  to configure a second interface by DHCP. This can be done by stopping dhcpcd.exe
  first (dhcpmon /t or kill) before calling *dhcpstrt* to request another DHCP lease.
.
  This is exactly the action taken by the [=TITLE].

.. ----------------------------------------
.4 TCP/IP address range conflict
.. ----------------------------------------
.an IDPNL_CONFIGURE_HYBRID_ADDRCONFLICT
.
A limitation of the TCP/IP network protocol is that a
system may have only one network interface configured for
one TCP/IP subnetwork (in our sample scenario: 192.168.1).
If that is not the case, the TCP/IP stack cannot not longer
uniquely decide by the given configuration wich interface
is be used to send TCPIP packets to systems taking part
in that very TCP/IP network (such as the router,
configured to _192.168.1_.1).

If more than one interface is configured for the same subnetwork,
or better, the address range of the subnetwork, these interfaces
are in conflict to each other. In such a case the TP/IP stack will
decide itself which interface to use for the subnetwork. The
interface with the lowest address is preferred, and all conflicting
interfaces are being ignored. The connection to the given network
will work while the preferred interface has a physical connection.

In our [.IDPNL_CONFIGURE_HYBRID_SCENARIO sample] on the notebook all
packets to the network 192.168.1
would be send over the interface lan0, while lan1 would be completely
ignored. If the user would then pull the network cable, the
connection would just be dead. It would not matter that the
wireless connection is still available, as the corresponding
interface would still be ignored.

The same problem would show up if the wireless interface would be
configured to the lower address. Then the connection would not
work any longer if the Wireless LAN connection would fail,
no matter if the cabled interface would still be available or not.

.. ----------------------------------------
.4 Automatic detection of a TCP/IP address range conflict
.. ----------------------------------------
.an IDPNL_CONFIGURE_HYBRID_DETECTCONFLICT
.
A possibly existing [.IDPNL_CONFIGURE_HYBRID_ADDRCONFLICT address range conflict]
described here will be automatically detected, if the configuration
of the TCP/IP interface of the Wireless LAN device has been
performed by the [=TITLE] or by DHCP. In order to resolve the
conflict, the user gets prompted to decide to take back the configuration
of either of the conflicting interfaces, Wireless LAN or cabled.

This is also used when [.IDPNL_CONFIGURE_HYBRID_SOLUTION] on user request.

.. ----------------------------------------
.4 switching between TCP/IP interfaces
.. ----------------------------------------
.an IDPNL_CONFIGURE_HYBRID_SOLUTION
.
In order to avoid the [.IDPNL_CONFIGURE_HYBRID_ADDRCONFLICT]
and possibly dead connection,
it is necessary to explicitly switch back and forth between the cabled
and the wireless interface.

In terms of the TCP/IP stack this would be accomplished by
deleting one interface and configuring the other one, so that
only one interface is configured for the same TCP/IP subnetwork
at a time.

When switching, it would also be necessary to delete
the default route before switching, and to reestablish the default route
after the switch, as this definition is bound to the currently
active interface. Also the contents of the ARP cache must be flushed
in order to rebuild all connection information, now using the
default route over the newly configured interface.

This switch mechanism to a certain extent is supported by
the [=TITLE]. If that feature is required, configure
this program following the instructions in:
.sl compact
- [.IDPNL_CONFIGURE_SWITCH]

.. ----------------------------------------
.3 Switching between wireless and cabled connections
.. ----------------------------------------
.an IDPNL_CONFIGURE_SWITCH
.
Perform the following configuration steps in order
to be able to switch between wireless and cabled
connection to one given network:
.ul
- within the *TCP/IP configuration program*
.ul compact
  - configure the TCP/IP interface for the cabled network interface card
  - _don't_ configure the TCP/IP interface for your Wireless LAN device
..
- create a connection profile for the Wireless LAN network
  (see [.IDPNL_CONFIG_CONFIGURE] for details)
.ul compact
  - on the properties notebook [.IDPNL_PROFILEPROPERTIES_PAGETCPIP]
    for this connection profile select either:
    - *[=IDT_IDSTR_CONFIGTYPE_DHCP]* or
    - *[=IDT_IDSTR_CONFIGTYPE_MANUALLY]*
    for the TCP/IP interface of the Wireless LAN device. If you choose manual
    configuration, don't forget to configue the TCP/IP address of the
    router component of your network providing internet access as the
    default gateway address
..
- on the properties notebook page [.IDPNL_PROPERTIES_PAGETCPIP]
  select the option *[=IDT_IDCHB_EXECSETUP]*, which executes a part of
  the *TCP/IP LAN configuration* (setup.cmd) when a
  Wireless LAN connection is disconnected from.
  This will reset the configuration of TCP/IP interfaces and routes
  to the state after system startup, so that the TCP/IP interface
  of the cabled network interface is properly reconfigured.

When the system is configured like this, after startup
it will first configure the cabled connection. The switch
between cabled and wireless interface takes place as follows:

_*Switching to Wireless LAN connection*_

When the [=TITLE] establishes a connection to the access
point of your Wireless LAN, it will automatically configure
the TCP/IP interface of your Wireless LAN device.
It then will detect the [.IDPNL_CONFIGURE_HYBRID_ADDRCONFLICT] and
bring up a prompt for the user. Here it can be selected whether
the configuration of the TCP/IP interface of the wireless or cabled
network interface card should be kept.
Press *Yes* to keep the configuration of the wireless interface,
and to discard the configuration of the cabled interface. With this
the switch to the wireless interface has finished.

[=NOTE]
.ul
- in order to make sure that the [=TITLE] does not accidentally
  configure the Wireless LAN interface, and with it possibly disturb
  a running TCP/IP data transfer (such as a FTP download etc.), you may
  want to disable the radio by deselecting *[=IDT_IDMEN_ENABLERADIO]*
  within the context menu of the [=TITLE] widget/window.
.
  You can also setup the program to turn off the radio on startup,
  within the properties notebook page [.IDPNL_PROPERTIES_PAGERADIO]
  select the option *[=IDT_IDRBT_RADIOOFF]*.
..
- in order to prevent the [=TITLE] from asking you every time
  about switching to the Wireless LAN device, within the
  properties notebook page [.IDPNL_PROPERTIES_PAGETCPIP]
  set the value for the option *[=IDT_IDTXT_CONFLRESOLVE]* to
  *[=IDT_IDSTR_CONFLRESOLVE_AUTO]*.

_*Switching to cabled connection*_

In order to switch back to the cabled connection, from the context menu
of the [=TITLE] widget/window either:
.ul compact
- select *[=IDT_IDMEN_ENABLERADIO]* to turn the radio on
- select *[=IDT_IDMEN_IPCFG]* - *[=IDT_IDMEN_IPCFG_UNCONFIG]*

If after that you want to switch back to the wireless connection, select:
.ul compact
- deselect *[=IDT_IDMEN_ENABLERADIO]* to turn the radio off
- *[=IDT_IDMEN_IPCFG]* - *[=IDT_IDMEN_IPCFG_CONFIG]*

To ease this step, within the properties notebook page [.IDPNL_PROPERTIES_PAGEMOUSE]
set the value for the option *[=IDT_IDTXT_MB1DBLCLICK]* to either
.ul compact
- *[=IDT_IDSTR_MB1DBL_ENABLERADIO]*
- *[=IDT_IDSTR_MB1DBL_DISABLETCPIP]*

After this a simple doubleclick onto the [=TITLE] widget/window
will switch between cabled and wireless interface.

[=NOTE]
.ul compact
- Make sure to stick to one method, either (de)activating the radio or
  deactivating and reconfiguring the TCP/IP interface. If you mix the methods,
  switching back and forth will not work in all cases.

.. ----------------------------------------
.3 Configuring the DHCP Client
.. ----------------------------------------
.an IDPNL_CONFIGURE_DHCP
.
The DHCP client is configured by the [=TITLE],
when
.ol compact
- configuration of the DHCP client is activated
  in the [.IDPNL_PROPERTIES_PAGETCPIP2 properties] of the program and
- the corresponding options are selected within the
  [.IDPNL_PROFILEPROPERTIES_PAGETCPIP connection profile]

[=TOPICS]
.su H50

.. ----------------------------------------
.4 DHCP Options
.. ----------------------------------------
.an IDPNL_CONFIGURE_DHCP_OPTIONS
.
The following DHCP options are configured by
the [=TITLE], when the configuration of the
DHCP Client is activated in the
[.IDPNL_PROPERTIES_PAGETCPIP2 TCP/IP Properties].

Always requested are the following options:
.fo off
option 1          ## request Subnet Mask
option 3          ## request Router (Gateway)
option 26         ## request MTU size
option 28         ## request Broadcast Address
.fo on

The following options are either requested with
the statement *option*, or rejected with the statement
*reject*, depending on the value of the respective
TCP/IP property of the
[.IDPNL_PROFILEPROPERTIES_PAGETCPIP connection profile]:

*[=IDT_IDCHB_OPTIONDNS]*
.fo off
option 6          ## request Domain Name Server
option 15         ## request Domain Name
.fo on
..
*[=IDT_IDCHB_OPTIONSTATICROUTES]*
.fo off
option 33         ## request Static Routes
.fo on

*[=IDT_IDCHB_OPTIONHOSTNAME]*
.fo off
option 12 "hostname" ## provide hostname
.fo on
where #hostname# is replaced with the value of the
evironment variable HOSTNAME. As this option is only
provided to the DHCP Server, and never returned to the
client, it is either requested, or does not appear at all
in the configuration file.

.. ----------------------------------------
.4 writing the DHCP client configuration file
.. ----------------------------------------
.an IDPNL_CONFIGURE_DHCP_WRITE
.
Before every request of a DHCP lease, the [=TITLE] restarts
the DHCP Client Daemon.

Before that, and if the configuration of the DHCP client is
enabled in the properties of the [=TITLE], the DHCP client
configuration file *%etc%\dhcpcd.cfg* is checked and,
if not containing the exact required content,
gets overwritten. All changes that may have been applied
before manually, get lost by that.

When writing the file, the [=TITLE] attaches an extended attribute
named *XWLAN.DHCPCFG* to it so it can determine whether creating
a backup is required before overwriting it.
.
On the first write of the file, the file will not carry the extended
attribute. Then a backup copy is stored under the name of
*%etc%\dhcpcd.bak*, overwriting an existing file with that name.

.at fc=red
[=NOTE]
.ul compact
- if the configuration of the DHCP client is not enabled,
  the DHCP client is used with the currently existing
  configuration file.
- the backup file is not restored automatically, if the
  configuration by the [=TITLE] was activated and then
  is deactivated.
.at

.... ----------------------------------------
...2 Limitations
.... ----------------------------------------
...an IDPNL_LIMITATIONS
...
..The current version of [=TITLE] has the following limitations:
...ul

.. ################
.include history.eng
.. ################

.. ################
.. #.. ----------------------------------------
.. #.3 Unverffentlichte Version
.. #.. ----------------------------------------
.. #.an IDPNL_REVISION_UNRELEASED
.. #.
.. ################

.. ----------------------------------------
.3 Version 3.13
.. ----------------------------------------
.an IDPNL_REVISION_313
.
_*New:*_
.ul

_*Fixed:*_
.ul
- Ticket ##46, ##37, ##34
- Ticket ##31

.. ----------------------------------------
.3 Version 3.12
.. ----------------------------------------
.an IDPNL_REVISION_312
.
_*New:*_
.ul
- Now uses 'Internet Systems Consortium DHCP Distribution Version 3.1-ESV-R3' dhcp client
  instead OS/2 dhcp daemon (yum install dhclient)
- Tested with WPA supplicant v2.0 and v2.2 (wpa__supplicant v2.2 (eCS-v1) included)
- Check for installed version of dhclient.exe and wpa__supplicant.exe. This are also shown at the
  corresponding pages in the settings dialog
- Beep when connection is established and with DHCP problems can be suppressed ([.IDT_IDCHB_DHCLIENTBEEP Audible alerts from DHCLIENT])
- dhclient.exe can write to log file if selected instead VIO window only ([.IDPNL_PROPERTIES_PAGETCPIP2])
- Unlock files during installation (fixed unlock.exe included)
- Readme.txt and ifc2.cmd script added
- Path info for wpa__supplicant is shown in property dialog now (##23)
- Option to override lan interface number for dhclient (Genmac bug when fxwrap.sys and switch.os2 are installed)
- 'wpa__supplicant reassociate' after connection drop (experimental feature)

_*Fixed:*_
.ul
- Empty connection listbox when too many connections are available
- Deleting routes and adding afterwards when switching between WLAN and LAN works reliable now and
  is independant from dhcp daemon timing
- Sporadic crash when deleting routes
- Crash with damaged profile data (Name of damaged profile will be marked as 'damaged')
- DHCP now works even with more than one DHCP server (thanks ISC dhclient)
- Blocking xcenter/WPS in some situations by dhclient.exe process
- Locked files are automatically unlocked during installation
- Logging setting for dhclient not saved (##14)
- Various dialogs are made bigger to prevent text cropping with systems using big default fonts
- wpa__supplicant starts now in wider window

.. ----------------------------------------
.3 Version 3.11 (limited user group)
.. ----------------------------------------
.an IDPNL_REVISION_311
.
_*New:*_
.ul
- modified code to not check for a TCP/IP address range conflict,
  while the TCP/IP interface of the Wireless LAN device is set to
  a LLA compliant address (169.254/16)
- added [.IDPNL_MOUSEACTIONS mouse actions] for opening the
  properties notebook, the scan or the profile dialog.
- added [.IDPNL_PROPERTIES_PAGEMOUSE mouse properties], determining
  the mouse actions for double-click events when Shift-, Ctrl- or
  Alt-Key is pressed
- added new [.IDPNL_PROPERTIES_PAGETCPIP2 global] and
  [.IDPNL_PROFILEPROPERTIES_PAGETCPIP profile] properties for
  configuration of the [.IDPNL_CONFIGURE_DHCP DHCP client]
- fixed error in GenMac module preventing from using WPA encryption
  with certain drivers
- added new [.IDPNL_PROFILEPROPERTIES_PAGEAUTOSTART] page for the
  connection profile
- fixed bug that took a lot of time to add the router name to long
  host files

_*Online Help:*_
.ul compact
- [.IDPNL_PROPERTIES_PAGEMOUSE]: added information on new mouse properties and actions
- [.IDPNL_PROPERTIES_PAGETCPIP2]: added new panel for DHCP properties
- [.IDPNL_PROFILEPROPERTIES_PAGETCPIP]: added new panel for DHCP properties
- [.IDPNL_CONFIGURE_DHCP]: added panel on DHCP configuration
- [.IDPNL_PROFILEPROPERTIES_PAGEAUTOSTART]: added panel for new autostart properties of the
  connection profile
- [.IDPNL_CONFIGURE_SCRIPT_CMD]: added missing link to [.FN_VAR_IPADDRESS WLAN__IPADDRESS]
- [.IDPNL_CONFIGURE_SCRIPT_REXX]: added missing link to [.FN_VAR_IPADDRESS WLan.__IPADDRESS]

.. ----------------------------------------
.3 Version 3.10
.. ----------------------------------------
.an IDPNL_REVISION_310
.
_*New:*_
.ul
- added code to set a LLA compliant address (169.254/16) for the TCP/IP
  interface of the wireless network interface, when a Wireless LAN
  connection is disconnected from. This prevents from problems when
  using the network protocol *NetBIOS over TCP/IP*. This feature can be
  turned off on the [.IDPNL_PROPERTIES_PAGETCPIP] properties page.
- added new [.IDPNL_MOUSEACTIONS], holding one or more shift keys
  while double-clicking the widget with mouse button one launches certain
  dialogs or performs certain actions
- added new properties page [.IDPNL_PROPERTIES_PAGEWPASUPP] and a corresponding
  submenu *[=IDT_IDMEN_WPASUPP]*, allowing to make the WPA Supplicant visible
  and to determine the debug output level of it.
- Priority for WPA Supplicant is raised to "Foreground Server", so that the
  periodic WPA key exchange works in most cases even while CPU-intensive
  applications are active.
  The item *[=IDT_IDMEN_WPASUPP_RECFG]* in the *[=IDT_IDMEN_WPASUPP]* menu
  allows to reconnect to the WPA Supplicant, in case that the key exchange
  still has broken down.
- added item *[=IDT_IDMEN_IPCFG_PING]* to menu *[=IDT_IDMEN_IPCFG]*
- added [.IDPNL_PROPERTIES_PAGETCPIP TCP/IP properties]
  *[=IDT_IDCHB_GATEWAYNAME]* and *[=IDT_IDTXT_GATEWAYNAME]*
  to allow addition of the Wireless LAN router to the %ETC%\hosts file,
  so that it can always be reached under the same name.
- renamed and reworked dialog [.IDPNL_PROFILE], now a connection profile
  can be selected from within this dialog.
- extended the [.IDPNL_HOTSPOT_SCAN Scan-Dialog] so that it can be
  closed with the Escape key

_*Fixed:*_
.ul
- fixed an error in the GenMac Driver Interface Module, sometimes reporting more
  than 100% signal strength
- fixed an error in the WPA Supplicant that would delay the
  connection to an accesspoint, when using certain GenMac drivers
- fixed error preventing to connect to an access point with the GenPrism driver,
  when using no encryption
- the DHCP client daemon is now stopped when radio is turned
  off and the TCP/IP interface of the Wireless LAN device was
  configured by DHCP. This allows proper [.IDPNL_CONFIGURE_SWITCH].
- [.IDPNL_PROFILEPROPERTIES_PAGESECURITY WEP keys] entered in hexadecimal format
  may now also begin with *0X* (upercase x character)
- the [=TITLE] will not abort anymore if the property [=IDT_IDTXT_WPAPSK]
  specified on the [.IDPNL_PROFILEPROPERTIES_PAGESECURITY] page
  for *[=IDT_IDSTR_WEPMODE_WPA_PSK]* or *[=IDT_IDSTR_WEPMODE_WPA2_PSK]*
  is longer than 43 characters (maximum allowed are 63 characters)
- reworked DHCP handling, preventing from issuing DHCP requests twice
- fixed error preventing to connect to an access point without encryption using
  the GenPrism driver interface under certain circumstances

_*Online Help:*_
.ul compact
- [.IDPNL_MOUSEACTIONS]: added information on new mouse actions
- [.IDPNL_PROPERTIES_PAGETCPIP]: added information about new properties
  *[=IDT_IDCHB_GATEWAYNAME]* and *[=IDT_IDTXT_GATEWAYNAME]*
- [.IDPNL_PROPERTIES_PAGEWPASUPP]: added new properties page
- [.IDPNL_PROFILE]: reworked panel and added information on new
  pushbutton *[=IDT_IDPBS_SELECTPROFILE]*

.. ----------------------------------------
.3 Version 3.00
.. ----------------------------------------
.an IDPNL_REVISION_300
.
_*New:*_
.ul
- WPA- and WPA2 encryption is now supported for [.IDPNL_PREREQUISITES GenMac]
  compatible Wireless LAN devices
- the TCP/IP interface of the WLAN device is now unconfigured on startup
  when radio is being disabled automatically on startup and the TCP/IP
  interface is configured at that point of time
- when the TCP/IP interface of the Wireless LAN device is determined
  [.IDPNL_PROFILEPROPERTIES_PAGETCPIP manually], within the dialog for
  [.IDPNL_PROFILEPROPERTIES_CONFIGMORETCPIP more TCP/IP options] the size
  of the MTU can be configured, especially for DSL connections
- new [.IDPNL_PROPERTIES_PAGETCPIP TCP/IP property] *[=IDT_IDCHB_TRIGGERWAN]* was added
- new value *[=IDT_IDSTR_CONFLRESOLVE_AUTO]* was added for the
  [.IDPNL_PROPERTIES_PAGETCPIP TCP/IP property] *[=IDT_IDTXT_CONFLRESOLVE]*.
  This was required for [.IDPNL_CONFIGURE_SWITCH]

_*Fixed:*_
.ul
- the TCP/IP interface of the WLAN device is now properly resumed for static
  configuration when radio is reenabled
- the [.IDPNL_CONFIGURE_SCRIPT script call on connect event]
  is now called after the TCP/IP interface is available
- the calculation scheme of signal strength in percent
  in the GenMac Driver Interface Module (DIM) has been corrected
- when TCP/IP address range conflicts occurr during a
  [.IDPNL_CONFIGURE_HYBRID switch from a wireless to a cabled connection to the same network or vice versa],
  the existing routes for the TCP/IP interface to be deconfigured
  will now be deleted and afterwards be reconfigured for the
  remaining TCP/IP interface.

_*Online Help:*_
.ul compact
- [.IDPNL_MAIN]: added note on WPA supplicant
- [.IDPNL_PREREQUISITES]: added information requirements for WPA encryption
- [.IDPNL_PROFILEPROPERTIES_PAGESECURITY]: added information on WPA encryption
- [.IDPNL_PROPERTIES_PAGETCPIP]: added information about new property *[=IDT_IDCHB_TRIGGERWAN]*
- [.IDPNL_PROPERTIES_PAGETCPIP]: added information about property *[=IDT_IDTXT_CONFLRESOLVE]*
- [.IDPNL_CONFIGURE_SECURITY]: added information on WPA encryption
- [.IDPNL_PROFILEPROPERTIES_PAGETCPIP]: added information on configuration of MTU
- [.IDPNL_CONFIGURE_SCRIPT]: corrected information on execution of scripts
- [.IDPNL_CONFIGURE_SWITCH]: changed recommendation to set property *[=IDT_IDTXT_CONFLRESOLVE]*
  from *[=IDT_IDSTR_CONFLRESOLVE_KEEPOTHER]* to *[=IDT_IDSTR_CONFLRESOLVE_AUTO]*
- [.IDPNL_LIMITATIONS]: reworked
- [.IDPNL_CREDITS_GENERAL]: added several credits

.. ----------------------------------------
.3 Version 2.14
.. ----------------------------------------
.an IDPNL_REVISION_214
.
_*New:*_
.ul
- added [.IDPNL_CREDITS_TRANSLATORS language support] for swedish
- the [.IDPNL_HOTSPOT_SCAN hotspot scan dialog] now can be sized and stores
  position and size.
- the new property *[=IDT_IDCHB_RADIOSTOP]* on the properties page
  [.IDPNL_PROPERTIES_PAGERADIO] deactivates the radio automatically,
  if the connection gets lost or cannot be obtained on program startup
- added *setlang.cmd* to the [.IDPNL_INSTALL_WIDGET installation package],
  allowing to [.IDPNL_INSTALL_NLS determine the language used]

_*Online Help:*_
.ul compact
- [.IDPNL_PROPERTIES_PAGERADIO]: added new property *[=IDT_IDCHB_RADIOSTOP]*

.. ----------------------------------------
.3 Version 2.13
.. ----------------------------------------
.an IDPNL_REVISION_213
.
_*New:*_
.ul
- modified [.IDPNL_PROPERTIES_PAGERADIO] properties page:
  the property for (de)activating radio on program startup
  is now selectable by a combobox instead of radio buttons.
- implemented new [.IDPNL_PROPERTIES_PAGERADIO]
  property *[=IDT_IDCHB_RADIOSHUTDOWN]*
- added support for MPTS configuration hack of installation
  program of Injoy Firewall

_*Fixed:*_
.ul
- implemented missing code to store property
  *[=IDT_IDCHB_BEEPRANGE]* of the [.IDPNL_PROPERTIES_PAGEERROR]
  page of the [=TITLE] properties notebook
- fixed error in GenMac module preventing from using a WLAN driver
  if it was not the first and only one
- fixed error in the [.IDPNL_HOTSPOT_SCAN hotspot scan dialog] preventing from
  activating a public hostspot without a corresponding connection profile

.. ----------------------------------------
.3 Version 2.12
.. ----------------------------------------
.an IDPNL_REVISION_212
.
_*Fixed:*_
.ul
- fixed error which sporadically prevented the program from
  querying the TCP/IP interface and lead to the status
  *[=IDT_IDSTR_STATUS_IPDISABLED]*
- added code to reconfigue the TP/IP interface with DHCP when
  radio is turned on again and no default route is set any longer
  for the given interface.
.
.
  This likely happens if the option *[=IDT_IDCHB_EXECSETUP]*
  is selected on the [.IDPNL_PROPERTIES_PAGETCPIP] properties
  page, and the radio was turned off before and therefore a
  DISCONNECT event took place. The LAN configuration script
  then is called and normally deletes the default route.

.... ----------------------------------------
.3 Version 2.11
.. ----------------------------------------
.an IDPNL_REVISION_211
.
_*New:*_
.ul
- reinvented [.IDPNL_PROPERTIES_PAGETCPIP] properties page
  with new properties

_*Fixed:*_
.ul
- fixed an error of V2.10
.ul compact
  - lead to overwrite existing profiles when copying or
    renaming connection profiles
  - prevented connection scan from starting

_*Online Help:*_
.ul compact
- new help panels:
  - [.IDPNL_CONFIG]
    - [.IDPNL_CONFIG_CONFIGURE]
    - [.IDPNL_CONFIGURE_PROFILESCAN]
    - [.IDPNL_CONFIGURE_HYBRID]
    - [.IDPNL_CONFIGURE_SWITCH]
- [.IDPNL_PROPERTIES_PAGETCPIP]: readded help panel for properties page

.. ----------------------------------------
.3 Version 2.10
.. ----------------------------------------
.an IDPNL_REVISION_210
.
_*New:*_
.ul
- new [.IDPNL_PROPERTIES_PAGEMOUSE action] *[=IDT_IDSTR_MB1DBL_DISABLETCPIP]*
  added for mouse double-click
- removed code to import connection profiles of an old format, previously exported
  by [=TITLE] V1.02.
- added additional stream format for storage of connection profiles
  that can be extended by more profile properties in the future, while such
  a stored stream profile remains downwards compatible.
.
  The previous format will still be supported for the next versions and profiles will
  additionally be stored in that format as well, so that older versions
  can still read profiles stored by this or newer versions.
- Modification of TCP/IP configuration so that with static configuration of the TCP/IP
  interface an existing default route is not deleted when within the dialog
  [.IDPNL_PROFILEPROPERTIES_CONFIGMORETCPIP] no default gateway address is specified.
- extended the [.IDPNL_PROPERTIES_PAGESCRIPT] properties page by the pushbuttons
.ul compact
  - [=IDT_IDPBS_OPEN] - opens the script directory
  - [=IDT_IDPBS_EDITSCRIPT] - loads the scriptfile into the System Editor.
  - [=IDT_IDPBS_VIEWLOG] - loads the logfile into the System Editor.
.el
- implemented second profile page for
  [.IDPNL_PROFILEPROPERTIES_PAGECONNECTION2 connection properties]

_*Fixed:*_
.ul
- when deactivating a connection profile with manual TCP/IP configuration the
  TCP/IP interface will be unconfigured before e.g. another profile gets activated
- added code to properly call the [.IDPNL_PROPERTIES_PAGESCRIPT script] for the
  CONNECT event when radio is reenabled
- fixed error, which sometimes left the [.FN_VAR_SSID SSID variable] empty, when the
  [.IDPNL_PROPERTIES_PAGESCRIPT script] was called on the [.FN_VAR_EVENT CONNECT event].
- fixed the following errors when on the [.IDPNL_PROPERTIES_PAGESCRIPT script properties page]
  a new directory is selected via the *[=IDT_IDPBS_BROWSE]* pushbutton:
.ul compact
  - the page gets updated correctly
  - the [=TITLE] does not turn into the status [.IDPNL_STATUS "no WLAN card inserted"]
- fixed error in GenMac Driver Interface Module preventing from connection to adhoc networks
- fixed error in GenPrism Driver Interface Module preventing from setting up a connection
  using the driver *IBM miniPCI Prism V2.5 Wireless Card*
- fixed errors in [.IDPNL_HOTSPOT_SCAN Scan dialog]
.ul compact
  - public access points/hotspots could not be selected
  - networks with matching connection profiles could not be selected properly
  - on refresh of a list with multiple items the selection jumped to first entry
  - under certain circumstances the current profile would be reset to
    *[=IDT_IDSTR_HOTSPOT_PRFNAME]* when the dialog was cancelled
.el
- fixed error in [.IDPNL_CONFIGURE_SCRIPT_ASYNC asynchronous call] of the [=TITLE] script,
  leading to loss of log data.
  From now on only one call to the script is being executed at a time.
  All following calls each wait in a separate thread for the end of the
  currently executing call. Currently the order or processing for
  the calls waiting in the background is not guaranteed.
- modified mnemonics in context menu to avoid conflicts

_*Online Help:*_
.ul compact
- [.IDPNL_PROPERTIES_PAGEMOUSE]: added information on new action *[=IDT_IDSTR_MB1DBL_DISABLETCPIP]*
  for mouse double-click
- [.IDPNL_PROFILEPROPERTIES_CONFIGMORETCPIP]: added information on not deleting default gateway
- [.IDPNL_PROPERTIES_PAGESCRIPT]: added information about added pushbuttons
- [.IDPNL_PROFILEPROPERTIES_PAGECONNECTION2]: added information about new profile property page
- [.IDPNL_CONFIGURE_SCRIPT_ASYNC]: adapted to new behaviour when calling the script asynchrously

.. ----------------------------------------
.3 Version 2.02
.. ----------------------------------------
.an IDPNL_REVISION_202
.
_*New:*_
.ul
- extended installation programms *instwgt.cmd* and *instexe.cmd*, so that
  TCP/IP binding information is checked that may have been previously stored
- extended [.IDPNL_HOTSPOT_SCAN scan dialog]
.ul compact
  - column *Protected*
    - changed title to *Access type*
    - changed items from *0* or *1* to *private* and *public*
  - added column for *Matching Profiles*
  - if a network is selected, which matches an existing connection profile
    with its SSID and access type, this profile is activated.
    If more than one matching connection profile
    exists, a dialog comes up to select the profile to use
- for GenMac driver readded item *[=IDT_IDMEN_HOTSPOT_CONNECT]* to menu *[=IDT_IDMEN_HOTSPOT]*

_*Fixed:*_
.ul
- fixed trap in [.IDPNL_HOTSPOT_SCAN scan dialog]

_*Online Help:*_
.ul compact
- [.IDPNL_HOTSPOT_SCAN]: added information about changes to the scan dialog
- [.IDPNL_HOTSPOT]: added information about readded menu item *[=IDT_IDMEN_HOTSPOT_CONNECT]*
- [.IDPNL_HOTSPOT]: added information about menu item *[=IDT_IDMEN_HOTSPOT_BROWSER]* added in V2.01

.. ----------------------------------------
.3 Version 2.01
.. ----------------------------------------
.an IDPNL_REVISION_201
.
_*New:*_
.ul
- added item *[=IDT_IDMEN_HOTSPOT_LAUNCHBROWSER]* to menu *[=IDT_IDMEN_HOTSPOT]*
- modified the [.IDPNL_HOTSPOT_SCAN scan dialog] to display
  all SSIDs of the network connected to with a tag

_*Fixed:*_
.ul
- corrected error handling in GenMac Driver Interface Module, so that
  Intel cards can be used
- fixed error in main module and DIM modules, preventing from configuring
  the TCP/IP interface

_*Online Help:*_
.ul compact
- [.IDPNL_PROPERTIES_PAGESCRIPT]: added link to [.IDPNL_CONFIGURE_SCRIPT_FILES]
- [.IDPNL_HOTSPOT_SCAN]: added information about changes to the scan dialog

.. ----------------------------------------
.3 Version 2.00
.. ----------------------------------------
.an IDPNL_REVISION_200
.
_*New:*_
.ul
- Implementation of the driver access with the new Driver Interface
  Modules (DIM), with integration of the GenMac driver of Willibald Meyer.
- on disconnect the route to the default gateways is deleted
- configuration of the TCP/IP interface per driver is not longer required

_*Fixed:*_
.ul
- adapted size of text fields in welcome dialog
- when starting the profile selection dialog, the profile being currently
  active is being preselected
- the hotspot menu is disabled when radio is deactivated
- when selecting the menu item *[=IDT_IDMEN_SCANCONNECTION]* after the hotspot mode was
  activated with *[=IDT_IDMEN_HOTSPOT_CONNECT]*, the [=TITLE] fell into an endless loop
  using 100% CPU, if no connection profile was activated for the
  [.IDPNL_CONFIGURE_PROFILESCAN connection scan]. This has been fixed.

_*Online Help:*_
.ul compact
- TCP/IP: added comments on automatic TCP/IP interface selection

.. ----------------------------------------
.3 Version 1.20
.. ----------------------------------------
.an IDPNL_REVISION_120
.
_*New:*_
.ul
- basic skin support
  - added a [.IDPNL_PROPERTIES_PAGEDISPLAY2 display] properties page, which shows
    the currently used status symbols and allows loading a new set of bitmaps
  - added Drag&Drop support to [.IDPNL_CHANGEBITMAPS replace the status symbols] with user provided ones. For that
    a folder containing the bitmap files can be dropped onto the window of the [=TITLE]
- extensions to status symbol handling
  - when a user provided bitmap file for a  status symbol does not contain a bitmap in the
    [.IDPNL_PROPERTIES_PAGEDISPLAY configured size] (16x16 or 20x20 pixel), the existing
    bitmap will be scaled to the configured size.
  - the status symbols now can be rotated by determining the rotation on the
    first [.IDPNL_PROPERTIES_PAGEDISPLAY display] properties page.
- TCP/IP configuration
  - modified handling for TCP/IP interfaces configured via DHCP. When radio is disabled
    or the Wireless LAN device is unplugged, the TCP/IP interface is only disabled instead
    of being unconfigured. This avoids unnecessary and lengthy reconfiguation of the TCP/IP
    interface via DHCP when radio is enabled or the Wireless LAN device is plugged again.
- added pushbutton *[=IDT_IDPBS_BROWSE]* to [.IDPNL_PROPERTIES_PAGESCRIPT Script]
  properties page for selection of a script directory
- now on first start of a new version of the standalone executable the welcome dialog is launched.
  Before, this was only done on the very first start of the program on a given system.
- the [.IDPNL_INSTALL_WIDGET installation script] *instexe.cmd*
  for the standalone executable now creates a subfolder within the
  WPS folder of the [=TITLE], containing a shadow of the supplied status symol
  set *Smiley*. An additional help icon refers to the online help for to
  configure the status symbols with Drag&Drop.

_*Fixed:*_
.ul
- the modified size of the [.IDPNL_STATUS status symbols] was not correctly read
  on restart
- implemented a workaround for a possible trap in Script-Engine, caused by a
  damaged environment variable C1, being modified by either the Scitech Display Doctor,
  Scitech Snap driver or any other installed GRADD module in the original CONFIG.SYS
  environment (it is not yet clear which driver is guilty). This could only
  happen when more than the default GRADD module was installed, like e.g. an
  additional WarpOverlay.
.
  In the CONFIG.SYS multiple GRADD module names in the value of the C1 variable are still
  separated by commas, but in the running system they are separated by invalid (!) zero bytes.
  This had an unexpected impact on the code manipulating the einvironment variables for the
  script engine.

_*Online Help:*_
.ul compact
- [.IDPNL_PROPERTIES_PAGEDISPLAY]: added rotation of the status symbols
- [.IDPNL_PROPERTIES_PAGEDISPLAY2]: new help panel on new properties page
- [.IDPNL_CHANGEBITMAPS]: new panel on Drag&Drop feature
- [.IDPNL_CHANGEBITMAPS_DIALOG]: help panel for new dialog
- [.IDPNL_PROPERTIES_PAGESCRIPT]: added note for pushbutton *[=IDT_IDPBS_BROWSE]*

.. ----------------------------------------
.3 Version 1.12
.. ----------------------------------------
.an IDPNL_REVISION_112
.
_*New:*_
.ul
- for [.IDPNL_PROFILEPROPERTIES_PAGETCPIP manual TCP/IP configuration]
  within a connection profile [.IDPNL_PROFILEPROPERTIES_CONFIGMORETCPIP more TCP/IP options]
  can be set to configure the default gateway and Domain Name service
- the [.IDPNL_STATUS status symbols] is now
  - displayed in the size of the mini icons/system icons of 16x16 or 20x20 pixels,
    according to the screen resolution (96dpi or 120 dpi), this can also be
    [.IDPNL_PROPERTIES_PAGEDISPLAY overridden] by the user.
  - (vertically centered also within the XCenter widget
- on first start of the standalone executable a welcome dialog is launched, and
  the program window blinks until it is clicked with the mouse. This eases spotting
  the small program window for beginners.

_*Online Help:*_
.ul compact
- [.IDPNL_PROFILEPROPERTIES_CONFIGMORETCPIP]: new configuration dialog
- [.IDPNL_PROPERTIES_PAGEDISPLAY]: new properties page

.. ----------------------------------------
.3 Version 1.11
.. ----------------------------------------
.an IDPNL_REVISION_111
.
_*New:*_
.ul
- IP address range conflicts are now also dectected,
  when any other interfaces is configured to a TCP/IP address
  of the same range of the interface of the Wireless LAN device
.
  (before range was checked only at that point of time when
  TCP/IP interface of the Wireless LAN device got configured)

_*Fixed:*_
.ul
- The configuration via DHCP did not work if another TCP/IP interface was previously
  configured with a *dhcpstrt* command. In such cases the TCP/IP interface of the
  Wireless LAN device remained deactivated.


.. ----------------------------------------
.3 Version 1.10
.. ----------------------------------------
.an IDPNL_REVISION_110
.
_*New:*_
.ul
- added [.IDPNL_HOTSPOT hotspot mode] and a feature to create a
  [.IDPNL_HOTSPOT_NEWPROFILE new profile] from a connection to a hotspot
- added feature to un- or reconfigure the TCP/IP interface
- added feature to call a script on disconnect and connect events
- added TCP/IP address range conflict detection for cases, where the TCP/IP
  interface of the Wireless LAN device is to be configured for the same
  address range like one of the other TCP/IP interfaces in the system
- added new property settings:
.ul compact
  - new page for [.IDPNL_PROPERTIES_PAGERADIO] settings
  - new page for [.IDPNL_PROPERTIES_PAGESCRIPT] settings
  - new property *[=IDT_IDCHB_BEEPRANGE]* on page [.IDPNL_PROPERTIES_PAGEERROR]
- added new [.IDPNL_STATUS status codes]
.ul compact
  -
.bi wlan-ipdisabled.bmp
  TCP/IP interface disabled
  -
.bi wlan-script.bmp
  script executing
- added new menu items
.ul compact
  - [=IDT_IDMEN_HOTSPOT]
  - [=IDT_IDMEN_IPCFG]
  - [=IDT_IDMEN_SELECTDEVICE]
- connection profiles can now be [.IDPNL_PROFILE copied]
- [=TITLE] now appends the default extension ***.wlp* to the names of the files,
  to which connection profiles are [.IDPNL_PROFILE exported], if no filename extension
  has been specified. In order to store to a file without a filename extension, specify
  a dot at the end of the filename.
- adds Wireless LAN driver title to tooltip text if no card is detected

_*Fixed:*_
.ul
- in order to replace the XCenter Widget DLL it is now sufficient to
  close all XCenter instances. Before, it was required to restart the Workplace Shell.
- encryption data is now being sent to the Wireless LAN driver only if it reported to support
  encryption. If it was sent anyway before, this would
  leave the [=TITLE] in an indefinite state
- switching between Wireless LAN drivers will now properly work
- fixed undo error on the properties page [.IDPNL_PROPERTIES_PAGEDEVSELECT]
- when configuring the TCP/IP interface of the Wireless LAN device, the ARP cache
  will now be flushed
- the [.IDPNL_PROFILE connection profile selection dialog] does not anymore allow
  deletion of the currently active connection profile
- tooltip text will not longer be modified if mouse pointer is not over widget
- handling of DHCP configuration and release of DHCP lease reworked and optimized
- storage of properties data redesigned, preventing incompatibilities between future
  versions
- [=TITLE] will now also load status strings in other language than english
- reworked notificaton beeps on events when getting in range or out of range

_*Online Help:*_
.ul compact
- [.IDPNL_STATUS]: added information on new status symbols
- [.IDPNL_PROPERTIES_PAGERADIO]: new property page
- [.IDPNL_PROPERTIES_PAGEERROR]: added new property for range beeps
- [.IDPNL_PROPERTIES_PAGESCRIPT]: new property page
- [.IDPNL_HOTSPOT]: new page on hotspot mode
- [.IDPNL_MOUSEACTIONS] and
.
  [.IDPNL_EXEOPTIONS]: added information on moving the standalone program with mouse button one
- [.IDPNL_LIMITATIONS]: removed information concerning problems when replacing
  the XCenter Widget DLL

.. ----------------------------------------
.3 Version 1.03
.. ----------------------------------------
.an IDPNL_REVISION_103
.
_*New:*_
.ul
- the [=TITLE] now can handle more than four connection profiles.
.at fc=red
  Connection profiles read and stored with the [=TITLE] therefore are not anylonger
  downwards compatible to those of the older application *WifiState*,
  being part of some Wireless LAN driver packages.
.at
- the [=TITLE] executes DHCP configuration only if the TCP/IP interface does
  not have the same IP address as after the last successful DHCP configuration.
- the standalone version of the [=TITLE] can now be displayed [.IDPNL_EXEOPTIONS in larger size]
- the tooltip text has been reworked and now also includes the System Service
  Identifier (SSID) of the WLAN partner as well as the transfer rate
- the DCHP request handling has been reworked, so that no DHCP request is being put
  if the last requested address is still configured for the TCP/IP interface

_*Fixed:*_
.ul
- the [.IDPNL_INSTALL_WIDGET installation scripts]
  instwgt.cmd and instexe.cmd load the REXXUTIL functions properly

_*Online Help:*_
.ul compact
- [.IDPNL_PROFILE]: modified to reflect the new handling of connection profiles
- [.IDPNL_STATUS]: added status symbol for the [=TITLE] being already active
- [.IDPNL_INSTALL_WIDGET]: Added note on TCP/IP configuration using the [=TITLE]
- [.IDPNL_PROFILEPROPERTIES_PAGETCPIP]: Added note on the new conditional DHCP configuration
- [.IDPNL_EXEOPTIONS]: Added note about new feature to display the [=TITLE] in larger size
- [.IDPNL_HOTSPOT]: Added information on detection of public Wireless LANs

.. ----------------------------------------
.3 Version 1.02
.. ----------------------------------------
.an IDPNL_REVISION_102
.
First public release


.. ################
.include trademarks.eng
.. ################

.. =============================================================================
.2 Credits
.. =============================================================================
.an IDPNL_CREDITS
.
[=TOPICS]
.su V30

.. ----------------------------------------
.3 General credits
.. ----------------------------------------
.an IDPNL_CREDITS_GENERAL
.
Credits go to:
.ul
- Jouni Malinen [mailto:jkmaline@cc.hut.fi] for creation of the
.sl
  - [http://hostap.epitest.fi WPA Supplicant]
.el
- Jonas Buys for proof-testing the [=TITLE]
- Robert Lalla for help in correcting the calculation scheme
  of signal strength in percent in the GenMac Driver Interface Module (DIM)
- Hermann Ulrichsktter for testing the GenMac Driver Interface Module
  and fixing a bug in it, as well as providing suggestions for extension of
  the online help
- Thorolf Godawa for testing the GenMac Driver Interface Module and
  bug reports

.. ----------------------------------------
.3 Credits to translators
.. ----------------------------------------
.an IDPNL_CREDITS_TRANSLATORS
.
The following people supported [=TITLE] by translating sources
into the respective language:

.pl tsize=15 break=none
- *Language*
= *Translator*
- German
= Christian Langanke [mailto:cla@clanganke.de]
- Swedish
= Bjrn Sderstrm [mailto:bjorso@bjorso.com]
.. - French
.. = Guillaume Gay [mailto:guillaume.gay@bigfoot.com]
- Italian
= Gabriele Gamba [mailto:ggamba@tiscali.it]
- Dutch
= Jan van der Heide [mailto:j.van.der.heide@hccnet.nl]

.. =============================================================================
.2 Appendix: Sample scripts
.. =============================================================================
.an IDPNL_APPENDIXSCRIPT
.
[=TOPICS]
.su V30

.. ----------------------------------------
.3 Sample CMD Script
.. ----------------------------------------
.an IDPNL_APPENDIXSCRIPT_CMD
.fo off
.textinclude xwlancmd.cmd
.fo on


.. ----------------------------------------
.3 Sample REXX Script
.. ----------------------------------------
.an IDPNL_APPENDIXSCRIPT_REXX
.fo off
.textinclude xwlanrx.cmd
.fo on

.. =============================================================================
.2 Appendix: using self-defined status symbols
.. =============================================================================
.an IDPNL_APPENDIXOWNBITMAPS
.in __dragdrop
.
User-defined status bitmaps must be provided in bitmap files within a folder,
where these files need to follow a certain naming scheme. Then this folder
is to be [.IDPNL_CHANGEBITMAPS loaded] into the [=TITLE].

It is not absolutely necessary to provide a bitmap file for all of the status symbols
in such a directory. In that case the symbols corresponding to the missing files
are not modified.

The files in the folder must include bitmaps in 16x16 and/or 20x20 pixels, where the
bitmap being used for display of a symbol is determined by
.ul compact
- the bitmap(s) provided in the file  and
- the [.IDPNL_PROPERTIES_PAGEDISPLAY configured size] (16x16 or 20x20 pixel)

When a user-provided bitmap file for a  status symbol does not contain a bitmap in the
configured size, (one of) the existing bitmap(s) will be scaled to the configured size.
As the built-in Presentation Manager function is used for that, this may look ugly,
so it most likely will be a better option to provide a bitmap with the desired size.

Moreover, the bitmap files must have the following filenames in order to be used
.
(for better orientation, the standard symbols are displayed here):
.pl break=none tsize=5
-
.bi wlan-nocard.bmp
= NoCard.bmp
-
.bi wlan-nodriver.bmp
= NoDriver.bmp
-
.bi wlan-disabled.bmp
= Disabled.bmp
-
.bi wlan-ipdisabled.bmp
= IpDisabled.bmp
-
.bi wlan-nonet.bmp
= NotConnected.bmp
-
.bi wlan-searching.bmp
= Searching.bmp
-
.bi wlan-scanning.bmp
= Scanning.bmp
-
.bi wlan-configuring.bmp
= Configuring.bmp
-
.bi wlan-script.bmp
= Script.bmp
-
.bi wlan-100.bmp
= Connected100.bmp
-
.bi wlan-80.bmp
= Connected80.bmp
-
.bi wlan-60.bmp
= Connected60.bmp
-
.bi wlan-40.bmp
= Connected40.bmp
-
.bi wlan-20.bmp
= Connected20.bmp
-
.bi wlan-nodataaccess.bmp
= NoDataAccess.bmp

