/* this code is adapted from Roman Stangle's APM/2 package */
/* for use with wvgui           fbakan@gmx.net  2006 02 16 */

#include    "apmoff.h"


int main(void)
{
   OpenAPM();

   DosSleep(1000);

   DisableAPM();

   DosSleep(1000);

   EnableAPM();

   DosSleep(1000);

   CloseAPM();
}


int OpenAPM(void)
                                        /* Open APM.SYS */
{
    APIRET          apiretRc=NO_ERROR;
    ULONG           ulAction=0;
    ulAction=0;
    UCHAR  uchFileName[20]  = "\\DEV\\APM$";

    apiretRc = DosOpen(uchFileName,
                     &hfileAPM,
                     &ulAction,
                     0,
                     FILE_NORMAL,
                     OPEN_ACTION_OPEN_IF_EXISTS,
                     OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE,
                     NULL);

    if(apiretRc!=NO_ERROR)
        {
        printf("error open APM rc = %d \n",apiretRc);
        return -1;
        }
    printf("open APM success\n");
    return 0;
}


int CloseAPM(void)
                                        /* Close APM.SYS */
{
    APIRET          apiretRc=NO_ERROR;

    if(hfileAPM!=0)
        DosClose(hfileAPM);

    if(apiretRc!=NO_ERROR)
        {
        printf("error closing APM rc = %d \n",apiretRc);
        return -1;
        }
    printf("close APM success\n");
    return 0;
}



int EnableAPM(void)
{
    APIRET          apiretRc=NO_ERROR;
    ULONG           ulPacketSize;
    ULONG           ulDataSize;
                                        /* APM diagnostics */
    struct POWERRETURNCODE powerRC;
                                        /* Just be sure and enable APM */
    struct SENDPOWEREVENT  sendpowereventAPM;
 
                                        /* Enable APM */
    memset(&sendpowereventAPM, 0, sizeof(sendpowereventAPM));
    powerRC.usReturnCode=0;
                                    /* Enable PWR MGMT function */
    sendpowereventAPM.usSubID=SUBID_ENABLE_POWER_MANAGEMENT;   
    ulPacketSize=sizeof(sendpowereventAPM);
    ulDataSize=sizeof(powerRC);
    apiretRc=DosDevIOCtl(hfileAPM,
                         IOCTL_POWER,
                         POWER_SENDPOWEREVENT,
                         &sendpowereventAPM,
                         ulPacketSize,
                         &ulPacketSize,
                         &powerRC,
                         ulDataSize,
                         &ulDataSize);
    if((apiretRc!=NO_ERROR) || (powerRC.usReturnCode!=POWER_NOERROR))
        {
        printf("error apiretRc = %d powerRc.usReturnCode = %d\n",apiretRc, powerRC.usReturnCode);
        return -1;
        }
    printf("APM enabled\n");
    return 0;
}


int DisableAPM(void)
                                        /* Disable APM */
{
    APIRET          apiretRc=NO_ERROR;
    ULONG           ulPacketSize;
    ULONG           ulDataSize;
                                        /* APM diagnostics */
    struct POWERRETURNCODE powerRC;

    struct SENDPOWEREVENT  sendpowereventAPM;
 

    memset(&sendpowereventAPM, 0, sizeof(sendpowereventAPM));
    powerRC.usReturnCode=0;
                                    /* Disable PWR MGMT function */
    sendpowereventAPM.usSubID=SUBID_DISABLE_POWER_MANAGEMENT;   
    ulPacketSize=sizeof(sendpowereventAPM);
    ulDataSize=sizeof(powerRC);

    apiretRc=DosDevIOCtl(hfileAPM,
                         IOCTL_POWER,
                         POWER_SENDPOWEREVENT,
                         &sendpowereventAPM,
                         ulPacketSize,
                         &ulPacketSize,
                         &powerRC,
                         ulDataSize,
                         &ulDataSize);

    if((apiretRc!=NO_ERROR) || (powerRC.usReturnCode!=POWER_NOERROR))
        {
        printf("error apiretRc = %d powerRc.usReturnCode = %d\n",apiretRc, powerRC.usReturnCode);
        return -1;
        }
    printf("APM disabled\n");
    return 0;
}
