#! /bin/sh
#
# configure wrapper
# start as: `ash ./cfg.sh'
# 

# the sources prefix
cwd=`pwd`
# watcom root
WATCOM=f:/dev/watcom
# gcc root (leave empty for system-wide installed C/C++ compiler)
GCCDIR=f:/dev/gcc/v3.3.5-csd6
# GCCDIR=
# QT dir
# QT4DIR=f:/dev/qt/trunk
QT4DIR="l:/usr l:/usr/lib/qt4"
# GCC includes
CINC=l:/usr/include
# GCC libs
CLIB=l:/usr/lib

# OS name
OS=`uname -s | sed -e 's|/||g' | tr '[:upper:]' '[:lower:]'`
# CPU arch
CPU=`uname -m`

case "$CPU" in
  i[3456789]86|x86|i86pc|BePC)
    arch='x86'
    ;;
  x86_64|amd64)
    arch='amd64'
    ;;
  *)
    echo "Cannot determine system"
    exit 1
    ;;
esac

case "$OS" in
  os2|dos|win*|nt)
    EXT=".exe"
    ;;
  *)
    EXT=""
esac

# PATH_ADD="${cwd}/tools/${OS}.${arch}/bin;${WATCOM}/binp;${WATCOM}/binw"
PATH_ADD="${cwd}/tools/${OS}.${arch}/bin"
tools_bin=`echo "${PATH_ADD}" | sed -e 's,/,\\\\,g'`
PATH="${tools_bin};$PATH"
# BEGINLIBPATH="${WATCOM}/binp/dll"
LIBSDL2="${cwd}/tools/${OS}.${arch}/libsdl/v1.2.10-20060602"

export LIBSDL2 PATH # BEGINLIBPATH WATCOM watcom="${WATCOM}"

VBOX_OSE=1 \
EMXOMFLD_TYPE=wlink \
EMXOMFLD_LINKER=wl${EXT} \
MKISOFS=f:/ux2/usr/bin/mkisofs${EXT} \
GCC_DIR=${GCCDIR} \
LIBRARY_PATH=${CLIB} \
C_INCLUDE_PATH=${CINC} \
CPLUS_INCLUDE_PATH=${CINC} \
INCLUDE=${INCLUDE} \
LIB=${LIB} \
GLIBIDL2=${cwd}/tools/${OS}.${arch}/glibidl/gcc335 \
 \
./configure --disable-opengl --disable-java --disable-alsa \
            --disable-pulse --disable-dbus --disable-libvpx --disable-devmapper --disable-hardening \
            --disable-docs --with-iasl=${cwd}/tools/${OS}.${arch}/bin/iasl${EXT} \
	    --with-gcc=${GCCDIR}/usr/bin/gcc${EXT} --with-g++=${GCCDIR}/usr/bin/g++${EXT} \
	    --with-ow-dir=${WATCOM} --with-qt-dir="${QT4DIR}" # --build-headless --enable-vnc --enable-webservice

# --with-kbuild=l:/usr/share/kbuild
# --enable-vnc --enable-webservice --disable-xpcom --build-libxml2
# SDL: ${cwd}/tools/${OS}.${arch}/libsdl/v1.2.10-20060602
# EMXOMFLD_LINKER=${WATCOM}/binp/wlink${EXT}
