/* this is a REXX script */

trace O

numeric digits 20


signal on error   name cleanup
signal on failure name cleanup
signal on syntax  name cleanup

indent         = '   '

rc = RxFuncAdd('UsbLoadFuncs','USBCALLS','UsbLoadFuncs')
rc = UsbLoadFuncs()

rc = RxUsbQueryVersion(DLLMajor,DLLMinor,USBMajor,USBMinor)
say 'USBRESMG.SYS and USBCALLS.DLL Version info:'
say 'USBCALLS Major Version:'DLLMajor
say 'USBCALLS Minor Version:'DLLMinor
say 'USBRESMG Major Version:'USBMajor
say 'USBRESMG Minor Version:'USBMinor
say

/* Creative SB Headset */
idVendor  = x2d(041e)
idProduct = x2d(0403)
/* query the feature unit */
bInterfaceNumber    = 0
bFeatureUnit        = 2

drop Handle
EnumDevice=0
rc = RxUsbOpen(Handle,EnumDevice,idVendor,idProduct)
if rc <> 0 then do
  say 'Could not open device with idVendor 'idVendor' and idProduct 'idProduct
  signal bailout
end

say 'Reporting info for device with idVendor 'd2x(idVendor)' and idProduct 'd2x(idProduct)

rc = RxUsbDeviceGetConfiguration(Handle,Config)
say 'Chosen configuration:'Config


GET_CUR               = x2d(81)
GET_MIN               = x2d(82)
GET_MAX               = x2d(83)
GET_RES               = x2d(84)
SET_CUR               = x2d(01)

VOLUME_CONTROL        = x2d(02)
ALL_CHANNELS          = x2d(FF)


VolumeVal    = x2d(7FFF)
bRequestType = x2d(b2x('00100001'))
bRequest     = SET_CUR
wValue       = SetWord(VOLUME_CONTROL,ALL_CHANNELS)
wIndex       = SetWord(bFeatureUnit,bInterfaceNumber)
drop           wLength
Data         = SetBinDWord(VolumeVal,VolumeVal)
rc = RxUsbCtrlMessage(Handle,bRequestType,bRequest,wValue,wIndex,wLength,Data,500)
if rc = 0 then
  say 'Successfully set Volume'
else
  say 'Cannot set Volume,rc:'d2x(rc)


bRequestType = x2d(b2x('10100001'))
bRequest     = GET_CUR
wValue       = SetWord(VOLUME_CONTROL,ALL_CHANNELS)
wIndex       = SetWord(bFeatureUnit,bInterfaceNumber)
wLength      = 2*2
drop           Data
rc = RxUsbCtrlMessage(Handle,bRequestType,bRequest,wValue,wIndex,wLength,Data,500)
if rc = 0 then do
   do i=1 to 2
     say 'Current Volume for channel 'i':'d2x(GetBinWord(Data,1+(i-1)*2),4)
   end
end
else
  say 'Cannot query Current Volume, rc:'d2x(rc)


bRequestType = x2d(b2x('10100001'))
bRequest     = GET_MIN
wValue       = SetWord(VOLUME_CONTROL,ALL_CHANNELS)
wIndex       = SetWord(bFeatureUnit,bInterfaceNumber)
wLength      = 2*2
drop           Data
rc = RxUsbCtrlMessage(Handle,bRequestType,bRequest,wValue,wIndex,wLength,Data,500)
if rc = 0 then do
   do i=1 to 2
     say 'Min Volume for channel 'i':'d2x(GetBinWord(Data,1+(i-1)*2),4)
   end
end
else
  say 'Cannot query Min Volume, rc:'d2x(rc)


bRequestType = x2d(b2x('10100001'))
bRequest     = GET_MAX
wValue       = SetWord(VOLUME_CONTROL,ALL_CHANNELS)
wIndex       = SetWord(bFeatureUnit,bInterfaceNumber)
wLength      = 2*2
drop           Data
rc = RxUsbCtrlMessage(Handle,bRequestType,bRequest,wValue,wIndex,wLength,Data,500)
if rc = 0 then do
   do i=1 to 2
     say 'Max Volume for channel 'i':'d2x(GetBinWord(Data,1+(i-1)*2),4)
   end
end
else
  say 'Cannot query Max Volume, rc:'d2x(rc)


bailout:
if DataType(Handle) = 'NUM' then do
  rc = RxUsbClose(Handle)
end
return 0

cleanup:
say 'Error, from source line:'sigl
say sourceline(sigl)
if DataType(Handle) = 'NUM' then do
  rc = RxUsbClose(Handle)
end
exit 1

GetBinWord: procedure
parse arg buffer,offset .
return c2d(reverse(substr(buffer,offset,2)),4)

SetWord: procedure
parse arg highByte,lowByte .
return highByte*256+lowByte

SetBinDWord: procedure
parse arg highWord,lowWord .
return reverse(d2c(highWord*65536+lowWord,4))





