/* this is a REXX script */

trace O

numeric digits 20

parse arg idVendor idProduct .
if idVendor='' || idProduct='' then do
  say 'Specify Vendor and Product ID as hexadecimal numbers !'
  return 1
end

signal on error   name cleanup
signal on failure name cleanup
signal on syntax  name cleanup

indent         = '   '

rc = RxFuncAdd('UsbLoadFuncs','USBCALLS','UsbLoadFuncs')
rc = UsbLoadFuncs()

rc = RxUsbQueryVersion(DLLMajor,DLLMinor,USBMajor,USBMinor)
say 'USBRESMG.SYS and USBCALLS.DLL Version info:'
say 'USBCALLS Major Version:'DLLMajor
say 'USBCALLS Minor Version:'DLLMinor
say 'USBRESMG Major Version:'USBMajor
say 'USBRESMG Minor Version:'USBMinor
say

Vendor  = translate(idVendor)
Product = translate(idProduct)
i = pos('0X',Vendor)
if i>0 then
  Vendor = substr(Vendor,3)
i = pos('0X',Product)
if i>0 then
  Product = substr(Product,3)
Vendor  = x2d(Vendor)
Product = x2d(Product)

drop Handle
EnumDevice=0
rc = RxUsbOpen(Handle,EnumDevice,Vendor,Product)
if rc <> 0 then do
  say 'Could not open device with idVendor 'idVendor' and idProduct 'idProduct
  signal bailout
end

rc = RxUsbConfigurationGetDescriptor(Handle,0,ConfigDescriptor)
if rc <> 0 then do
  say 'Could not read descriptors, aborting ...'
  signal bailout
end

say 'Reporting info for device with idVendor 'idVendor' and idProduct 'idProduct

rc = RxUsbDeviceGetConfiguration(Handle,Config)
say 'Chosen configuration:'Config



CONFIG_DESC    = x2d(2)
CS_CONFIG_DESC = x2d(22)
INTF_DESC      = x2d(4)
CSINTF_DESC    = x2d(24)
ENDP_DESC      = x2d(5)
CSENDP_DESC    = x2d(25)

ASSOC_DESC     = x2d(B)
HID_DESC       = x2d(21)


/* main loop */
i = 1
bLength             = GetByte(ConfigDescriptor,i)
bDescriptorType     = GetByte(ConfigDescriptor,i+1)
overallLength       = GetWord(ConfigDescriptor,i+2)

do while (i<=overallLength)
  select
    when bDescriptorType = CONFIG_DESC then do
      bNumInterfaces      = GetByte(ConfigDescriptor,i+4)
      bConfigurationValue = GetByte(ConfigDescriptor,i+5)
      iConfiguration      = GetByte(ConfigDescriptor,i+6)
    end


    when bDescriptorType = ASSOC_DESC then do
      bFirstInterface = GetByte(ConfigDescriptor,i+2)
      bInterfaceCount = GetByte(ConfigDescriptor,i+3)
      bFunctionClass  = GetByte(ConfigDescriptor,i+4)
      bFunctionSubClass = GetByte(ConfigDescriptor,i+5)
      bFunctionProtocol = GetByte(ConfigDescriptor,i+6)
      iFunction         = GetByte(ConfigDescriptor,i+7)
      say 'Interface association:'
      do j=1 to bInterfaceCount
         say indent'baInterfaceNr:'bFirstInterface+j-1
      end
    end


    when bDescriptorType = INTF_DESC then do
      bInterfaceNumber = GetByte(ConfigDescriptor,i+2)
      bAlternateSetting = GetByte(ConfigDescriptor,i+3)
      bNumEndpoints     = GetByte(ConfigDescriptor,i+4)
      bInterfaceClass   = GetByte(ConfigDescriptor,i+5)
      bInterfaceSubClass = GetByte(ConfigDescriptor,i+6)
      bInterfaceProtocol = GetByte(ConfigDescriptor,i+7)
      iInterface         = GetByte(ConfigDescriptor,i+8)
    end


    when bDescriptorType = CSINTF_DESC then do
      AUDIO           = x2d(01)
      AUDIOCONTROL    = x2d(01)
      AUDIOSTREAMING  = x2d(02)
      HEADER          = x2d(01)
      INPUT_TERMINAL  = x2d(02)
      CLOCK_SOURCE    = x2d(0A)
      AS_GENERAL      = x2d(01)
      FORMAT_TYPE     = x2d(02)
      if bInterfaceClass = AUDIO & bInterfaceSubClass = AUDIOCONTROL then do
         bDescriptorSubType = GetByte(ConfigDescriptor,i+2)

         select
            when bDescriptorSubType = HEADER then do
               bcdADC             = GetWord(ConfigDescriptor,i+3)

               if bcdADC \= x2d(200) then do
                  say 'This is not an Audio 2.0 compatible device !'
                  signal bailout
               end

               bCategory          = GetByte(ConfigDescriptor,i+5)
               wTotalLength       = GetWord(ConfigDescriptor,i+6)
               bmControls         = GetByte(ConfigDescriptor,i+8)
               say 'Class Specific AudioControl Interface Header Descriptor Info:'
               say indent'bLength:'bLength
               say indent'bDescriptorType:'bDescriptorType
               say indent'bDescriptorSubType:'bDescriptorSubType
               say indent'bcdADC:0x'd2x(bcdADC)
               say indent'bCategory:'bCategory
               say indent'wTotalLength:'wTotalLength
               say indent'bmControls (bits):'x2b(d2x(bmControls))
            end

            when bDescriptorSubType = INPUT_TERMINAL then do
              bTerminalID = GetByte(ConfigDescriptor,i+3)
              wTerminalType = GetWord(ConfigDescriptor,i+4)
              bAssocTerminal = GetByte(ConfigDescriptor,i+6)
              bCSourceID     = GetByte(ConfigDescriptor,i+7)
              bNrChannels = GetByte(ConfigDescriptor,i+8)
              bmChannelConfig = GetDWord(ConfigDescriptor,i+9)
              iChannelNames = GetByte(ConfigDescriptor,i+13)
              bmControls = GetWord(ConfigDescriptor,i+14)
              iTerminal = GetByte(ConfigDescriptor,i+15)

              say 'Class Specific AudioContol Interface Input Terminal Descriptor Info:'
              say indent||bNrChannels' Channels, Channel Config is (bits):'x2b(d2x(bmChannelConfig))
            end

            when bDescriptorSubType = CLOCK_SOURCE then do
              CS_SAM_FREQ_CONTROL = x2d(01)
              CUR   = x2d(01)
              RANGE = x2d(02)

              bClockID = GetByte(ConfigDescriptor,i+3)
              bmAttributes = GetByte(ConfigDescriptor,i+4)
              bmControls = GetByte(ConfigDescriptor,i+5)
              bAssocTerminal = GetByte(ConfigDescriptor,i+6)
              iClockSource = GetByte(ConfigDescriptor,i+7)

              RequestType = x2d(b2x(10100001))
              Value = x2d(d2x(CS_SAM_FREQ_CONTROL,2)||d2x(0,2))
              Index = x2d(d2x(bClockID,2)||d2x(bInterfaceNumber,2))
              NumBytes = 258

              Request     = RANGE
              drop Data
              rc = RxUsbCtrlMessage(Handle,RequestType,Request,Value,Index,NumBytes,Data,500)
              if rc \= 0 then do
                 say 'rc:'d2x(rc)',cannot query min/max/resolution for sampling rate, abort ...'
                 signal bailout
              end
              say 'Class Specific AudioContol Interface Clock Source Descriptor Info:'
              wNumSubRanges = GetWord(Data,1)
              do j=1 to wNumSubRanges
                say indent'Minimum Sampling Freq['j']:'GetDWord(Data,3+(j-1)*12)' Hz'
                say indent'Maximum Sampling Freq['j']:'GetDWord(Data,7+(j-1)*12)' Hz'
                say indent'Sampling Freq resolution['j']:'GetDWord(Data,11+(j-1)*12)' Hz'
              end
            end

            otherwise
         end
      end

      if bInterfaceClass = AUDIO & bInterfaceSubClass = AUDIOSTREAMING then do
         bDescriptorSubType = GetByte(ConfigDescriptor,i+2)
         select
            when bDescriptorSubType = AS_GENERAL then do
               FORMAT_TYPE_I = 1
               bTerminalLink = GetByte(ConfigDescriptor,i+3)
               bmControls    = GetByte(ConfigDescriptor,i+4)
               bFormatType   = GetByte(ConfigDescriptor,i+5)
               bmFormats     = GetDWord(ConfigDescriptor,i+6)
               bNrChannels   = GetByte(ConfigDescriptor,i+10)
               bmChannelConfig = GetDWord(ConfigDescriptor,i+11)
               iChannelNames   = GetByte(ConfigDescriptor,i+15)

               if bFormatType = FORMAT_TYPE_I then do
                 say 'Class Specific AudioStreaming Interface General Descriptor Info:'
                 say indent'Format Type and Format Bitfield proposed by general descriptor:'
                 say indent||indent||GetFormatType(bFormatType)',(bits) 'x2b(d2x(bmFormats))
                 say indent'Number of Channels proposed by general descriptor:'
                 say indent||indent||bNrChannels' Channels, Channel Config is (bits):'x2b(d2x(bmChannelConfig))
               end
            end /* do */
            when bDescriptorSubType = FORMAT_TYPE then do
               FORMAT_TYPE_I = 1
               bFormatType = GetByte(ConfigDescriptor,i+3)
               if bFormatType = FORMAT_TYPE_I then do
                 bSubSlotSize = GetByte(ConfigDescriptor,i+4)
                 bBitResolution  = GetByte(ConfigDescriptor,i+5)
                 say 'Class Specific AudioStreaming Interface Format Type Descriptor Info:'
                 say indent'SubframeSize and Bit Resolution proposed by format type descriptor:'
                 say indent||indent||bSubSlotSize' Bytes Per Sample,'bBitResolution' bits Per Sample'
               end
            end /* do */
            otherwise
         end  /* select */
      end /* do */
    end


    when bDescriptorType = ENDP_DESC then do
      bEndPointAddress = GetByte(ConfigDescriptor,i+2)
      bmAttributes     = GetByte(ConfigDescriptor,i+3)
      wMaxPacketSize   = GetWord(ConfigDescriptor,i+4)
      bInterval        = GetByte(ConfigDescriptor,i+6)
      if bEndPointAddress >= x2d(80) then
         say 'Endpoint (device-to-host) Descriptor Info:'
      else
         say 'Endpoint (host-to-device) Descriptor Info:'
      say indent'bEndPointAddress:0x'd2x(bEndPointAddress)
      say indent'bmAttributes (bits):'x2b(d2x(bmAttributes))
      say indent'wMaxPacketSize:'wMaxPacketSize
      say indent'bInterval:'bInterval
    end


    when bDescriptorType = CSENDP_DESC then do
       bDescriptorSubType = GetByte(ConfigDescriptor,i+2)
       bmAttributes       = GetByte(ConfigDescriptor,i+3)
       bmControls         = GetByte(ConfigDescriptor,i+4)
       bLockDelayUnits    = GetByte(ConfigDescriptor,i+5)
       wLockDelay         = GetWord(ConfigDescriptor,i+6)
    end

    otherwise do
    end
  end

  i = i + bLength
  if i >= overallLength then
    leave

  bLength             = GetByte(ConfigDescriptor,i)
  bDescriptorType     = GetByte(ConfigDescriptor,i+1)
end

bailout:
if DataType(Handle) = 'NUM' then do
  rc = RxUsbClose(Handle)
end
return 0

cleanup:
say 'Error, from source line:'sigl
say sourceline(sigl)
if DataType(Handle) = 'NUM' then do
  rc = RxUsbClose(Handle)
end
exit 1




GetByte: procedure
parse arg buffer,offset .
return c2d(substr(buffer,offset,1))

GetWord: procedure
parse arg buffer,offset .
return c2d(reverse(substr(buffer,offset,2)))

GetDWord: procedure
parse arg buffer,offset .
return c2d(reverse(substr(buffer,offset,4)))

GetFormatType: procedure
parse arg type .

  select
    when type = x2d(0) then do
      return 'FORMAT_TYPE_UNDEFINED'
    end

    when type = x2d(1) then do
      return 'FORMAT_TYPE_I'
    end

    when type = x2d(2) then do
      return 'FORMAT_TYPE_II'
    end

    when type = x2d(3) then do
      return 'FORMAT_TYPE_III'
    end

    when type = x2d(4) then do
      return 'FORMAT_TYPE_IV'
    end

    when type = x2d(81) then do
      return 'EXT_FORMAT_TYPE_I'
    end

    when type = x2d(82) then do
      return 'EXT_FORMAT_TYPE_II'
    end

    when type = x2d(83) then do
      return 'EXT_FORMAT_TYPE_III'
    end

    otherwise do
      return 'Unknown Type'
    end
  end
return 'Unknown Type'

