/* this is a REXX script */

trace O

numeric digits 20

parse arg idVendor idProduct .
if idVendor='' || idProduct='' then do
  say 'Specify Vendor and Product ID as hexadecimal numbers !'
  return 1
end

signal on error   name cleanup
signal on failure name cleanup
signal on syntax  name cleanup

indent         = '   '

rc = RxFuncAdd('UsbLoadFuncs','USBCALLS','UsbLoadFuncs')
rc = UsbLoadFuncs()

rc = RxUsbQueryVersion(DLLMajor,DLLMinor,USBMajor,USBMinor)
say 'USBRESMG.SYS and USBCALLS.DLL Version info:'
say 'USBCALLS Major Version:'DLLMajor
say 'USBCALLS Minor Version:'DLLMinor
say 'USBRESMG Major Version:'USBMajor
say 'USBRESMG Minor Version:'USBMinor
say

Vendor  = translate(idVendor)
Product = translate(idProduct)
i = pos('0X',Vendor)
if i>0 then
  Vendor = substr(Vendor,3)
i = pos('0X',Product)
if i>0 then
  Product = substr(Product,3)
Vendor  = x2d(Vendor)
Product = x2d(Product)

drop Handle
EnumDevice=0
rc = RxUsbOpen(Handle,EnumDevice,Vendor,Product)
if rc <> 0 then do
  say 'Could not open device with idVendor 'idVendor' and idProduct 'idProduct
  signal bailout
end

rc = RxUsbConfigurationGetDescriptor(Handle,0,ConfigDescriptor)
if rc <> 0 then do
  say 'Could not read descriptors, aborting ...'
  signal bailout
end

say 'Reporting info for device with idVendor 'idVendor' and idProduct 'idProduct

rc = RxUsbDeviceGetConfiguration(Handle,Config)
say 'Chosen configuration:'Config



CONFIG_DESC    = x2d(2)
CS_CONFIG_DESC = x2d(22)
INTF_DESC      = x2d(4)
CSINTF_DESC    = x2d(24)
ENDP_DESC      = x2d(5)
CSENDP_DESC    = x2d(25)

ASSOC_DESC     = x2d(B)
HID_DESC       = x2d(21)


/* main loop */
i = 1
bLength             = GetByte(ConfigDescriptor,i)
bDescriptorType     = GetByte(ConfigDescriptor,i+1)
overallLength       = GetWord(ConfigDescriptor,i+2)

do while (i<=overallLength)
  select
    when bDescriptorType = CONFIG_DESC then do
      bNumInterfaces      = GetByte(ConfigDescriptor,i+4)
      bConfigurationValue = GetByte(ConfigDescriptor,i+5)
      iConfiguration      = GetByte(ConfigDescriptor,i+6)
    end


    when bDescriptorType = ASSOC_DESC then do
      bFirstInterface = GetByte(ConfigDescriptor,i+2)
      bInterfaceCount = GetByte(ConfigDescriptor,i+3)
      bFunctionClass  = GetByte(ConfigDescriptor,i+4)
      bFunctionSubClass = GetByte(ConfigDescriptor,i+5)
      bFunctionProtocol = GetByte(ConfigDescriptor,i+6)
      iFunction         = GetByte(ConfigDescriptor,i+7)
    end


    when bDescriptorType = INTF_DESC then do
      bInterfaceNumber = GetByte(ConfigDescriptor,i+2)
      bAlternateSetting = GetByte(ConfigDescriptor,i+3)
      bNumEndpoints     = GetByte(ConfigDescriptor,i+4)
      bInterfaceClass   = GetByte(ConfigDescriptor,i+5)
      bInterfaceSubClass = GetByte(ConfigDescriptor,i+6)
      bInterfaceProtocol = GetByte(ConfigDescriptor,i+7)
      iInterface         = GetByte(ConfigDescriptor,i+8)
    end


    when bDescriptorType = CSINTF_DESC then do
      AUDIO           = x2d(01)
      AUDIOCONTROL    = x2d(01)
      AUDIOSTREAMING  = x2d(02)
      HEADER          = x2d(01)
      INPUT_TERMINAL  = x2d(02)
      AS_GENERAL      = x2d(01)
      FORMAT_TYPE     = x2d(02)
      FORMAT_SPECIFIC = x2d(03)
      if bInterfaceClass = AUDIO & bInterfaceSubClass = AUDIOCONTROL then do
         bDescriptorSubType = GetByte(ConfigDescriptor,i+2)

         select
            when bDescriptorSubType = HEADER then do
               bcdADC             = GetWord(ConfigDescriptor,i+3)

               if bcdADC \= x2d(100) then do
                  say 'This is not an Audio 1.0 compatible device !'
                  signal bailout
               end

               wTotalLength       = GetWord(ConfigDescriptor,i+5)
               bInCollection      = GetByte(ConfigDescriptor,i+7)
               do j=1 to bInCollection
                  baInterfaceNr.j  = GetByte(ConfigDescriptor,i+8+j-1)
               end
               say 'Class Specific AudioControl Interface Header Descriptor Info:'
               say indent'bLength:'bLength
               say indent'bDescriptorType:'bDescriptorType
               say indent'bDescriptorSubType:'bDescriptorSubType
               say indent'bcdADC:0x'd2x(bcdADC)
               say indent'wTotalLength:'wTotalLength
               say indent'bInCollection:'bInCollection
               do j=1 to bInCollection
                  say indent||indent'baInterfaceNr['j']:'baInterfaceNr.j
               end
            end

            when bDescriptorSubType = INPUT_TERMINAL then do
              bTerminalID = GetByte(ConfigDescriptor,i+3)
              wTerminalType = GetWord(ConfigDescriptor,i+4)
              bAssocTerminal = GetByte(ConfigDescriptor,i+6)
              bNrChannels = GetByte(ConfigDescriptor,i+7)
              wChannelConfig = GetWord(ConfigDescriptor,i+8)
              iChannelNames = GetByte(ConfigDescriptor,i+10)
              iTerminal = GetByte(ConfigDescriptor,i+11)

              say 'Class Specific AudioContol Interface Input Terminal Descriptor Info:'
              say indent||bNrChannels' Channels, Channel Config is (bits):'x2b(d2x(wChannelConfig))
            end

            otherwise
         end
      end

      if bInterfaceClass = AUDIO & bInterfaceSubClass = AUDIOSTREAMING then do
         bDescriptorSubType = GetByte(ConfigDescriptor,i+2)
         select
            when bDescriptorSubType = AS_GENERAL then do
               bTerminalLink = GetByte(ConfigDescriptor,i+3)
               bDelay        = GetByte(ConfigDescriptor,i+4)
               wFormatTag    = GetWord(ConfigDescriptor,i+5)
            end /* do */
            when bDescriptorSubType = FORMAT_TYPE then do
               bFormatType = GetByte(ConfigDescriptor,i+3)
               bNrChannels = GetByte(ConfigDescriptor,i+4)
               bSubframeSize = GetByte(ConfigDescriptor,i+5)
               bBitResolution  = GetByte(ConfigDescriptor,i+6)
               bSamFreqType = GetByte(ConfigDescriptor,i+7)
               say 'Class Specific AudioStreaming Interface Format Type Descriptor Info:'
               say indent'Format Type and Format tag proposed by format type descriptor:'
               say indent||indent||GetFormatType(bFormatType)','GetFormatTag(wFormatTag)
               say indent'Number of Channels proposed by format type descriptor:'
               say indent||indent||bNrChannels' Channels'
               say indent'SubframeSize and Bit Resolution proposed by format type descriptor:'
               say indent||indent||bSubframeSize' Bytes Per Sample,'bBitResolution' bits Per Sample'
               say indent'Sampling Frequencies proposed by format type descriptor:'
               if bSamFreqType = 0 then do
                  tLowerSamFreq = FormatFrequency(ConfigDescriptor,i+8)
                  tUpperSamFreq = FormatFrequency(ConfigDescriptor,i+11)
                  say indent||indent'Minimum Sampling Frequency:'tLowerSamFreq' Hz'
                  say indent||indent'Maximum Sampling Frequency:'tUpperSamFreq' Hz'
               end /* do */
               else do
                  do j=1 to bSamFreqType
                     tSamFreq.j = FormatFrequency(ConfigDescriptor,i+8+(j-1)*3)
                     say indent||indent'Discrete Sampling Frequency:'tSamFreq.j' Hz'
                  end /* do */
               end /* do */
            end /* do */
            otherwise
         end  /* select */
      end /* do */
    end


    when bDescriptorType = ENDP_DESC then do
      AUDIO          = x2d(01)
      AUDIOSTREAMING = x2d(02)

      bEndPointAddress = GetByte(ConfigDescriptor,i+2)
      bmAttributes     = GetByte(ConfigDescriptor,i+3)
      wMaxPacketSize   = GetWord(ConfigDescriptor,i+4)
      bInterval        = GetByte(ConfigDescriptor,i+6)
      if bEndPointAddress >= x2d(80) then
         say 'Endpoint (device-to-host) Descriptor Info:'
      else
         say 'Endpoint (host-to-device) Descriptor Info:'
      say indent'bEndPointAddress:0x'd2x(bEndPointAddress)
      say indent'bmAttributes (bits):'x2b(d2x(bmAttributes))
      say indent'wMaxPacketSize:'wMaxPacketSize
      say indent'bInterval:'bInterval

      if bInterfaceClass = AUDIO & bInterfaceSubClass = AUDIOSTREAMING then do
         if GetSyncType(bmAttributes) \= 0 then do
            /* program the correct alternate setting first ... */
            rc = RxUsbInterfaceSetAltSetting(Handle,bInterfaceNumber,bAlternateSetting);
            if rc \= 0 then do
               say 'rc:'d2x(rc)',cannot set alternate interface, abort ...'
               signal bailout
            end

            SAMPLING_FREQ_CONTROL = x2d(1)
            PITCH_CONTROL         = x2d(2)
            GET_CUR               = x2d(81)
            GET_MIN               = x2d(82)
            GET_MAX               = x2d(83)
            GET_RES               = x2d(84)

            RequestType = x2d(b2x('10100010'))
            Value = x2d(d2x(SAMPLING_FREQ_CONTROL,2)||d2x(0,2))
            Index = bEndPointAddress
            NumBytes = 3

            Request = GET_MIN
            drop Data
            rc1 = RxUsbCtrlMessage(Handle,RequestType,Request,Value,Index,NumBytes,Data,500)
            if rc1 = 0 then
               minfreq = FormatFrequency(Data,1)

            Request = GET_MAX
            drop Data
            rc2 = RxUsbCtrlMessage(Handle,RequestType,Request,Value,Index,NumBytes,Data,500)
            if rc2 = 0 then
               maxfreq = FormatFrequency(Data,1)

            Request = GET_RES
            drop Data
            rc3 = RxUsbCtrlMessage(Handle,RequestType,Request,Value,Index,NumBytes,Data,500)
            if rc3 = 0 then
               resfreq = FormatFrequency(Data,1)

            if rc1=0 & rc2=0 & rc3=0 then do
              say indent||indent'Supported Minimum Sampling Frequency:'minfreq' Hz'
              say indent||indent'Supported Maximum Sampling Frequency:'maxfreq' Hz'
              say indent||indent'Sampling Frequency resolution       :'resfreq' Hz'
            end
            else do
              say indent||indent'Device does not allow to query min/max/res for Sampling Frequency'
            end
         end
         else do
            say indent||indent'Synch Endpoint'
         end
      end
    end


    when bDescriptorType = CSENDP_DESC then do
       bDescriptorSubType = GetByte(ConfigDescriptor,i+2)
       bmAttributes       = GetByte(ConfigDescriptor,i+3)
       bLockDelayUnits    = GetByte(ConfigDescriptor,i+4)
       wLockDelay         = GetWord(ConfigDescriptor,i+5)
    end

    otherwise do
    end
  end

  i = i + bLength
  if i >= overallLength then
    leave

  bLength             = GetByte(ConfigDescriptor,i)
  bDescriptorType     = GetByte(ConfigDescriptor,i+1)
end

bailout:
if DataType(Handle) = 'NUM' then do
  rc = RxUsbClose(Handle)
end
return 0

cleanup:
say 'Error, from source line:'sigl
say sourceline(sigl)
if DataType(Handle) = 'NUM' then do
  rc = RxUsbClose(Handle)
end
exit 1




GetByte: procedure
parse arg buffer,offset .
return c2d(substr(buffer,offset,1))

GetWord: procedure
parse arg buffer,offset .
return c2d(reverse(substr(buffer,offset,2)))

GetDWord: procedure
parse arg buffer,offset .
return c2d(reverse(substr(buffer,offset,4)))

FormatFrequency: procedure
parse arg buffer,offset .
return c2d(reverse(substr(buffer,offset,3)))

GetFormatType: procedure
parse arg type .

  select
    when type = 0 then do
      return 'FORMAT_TYPE_UNDEFINED'
    end

    when type = 1 then do
      return 'FORMAT_TYPE_I'
    end

    when type = 2 then do
      return 'FORMAT_TYPE_II'
    end

    when type = 3 then do
      return 'FORMAT_TYPE_III'
    end

    otherwise do
      return 'Unknown Type'
    end
  end
return 'Unknown Type'

GetFormatTag: procedure
parse arg tag .
  select
    when tag = x2d(0) then do
      return 'TYPE_I_UNDEFINED'
    end
    when tag = x2d(1) then do
      return 'PCM'
    end
    when tag = x2d(2) then do
      return 'PCM8'
    end
    when tag = x2d(3) then do
      return 'IEEE_FLOAT'
    end
    when tag = x2d(4) then do
      return 'ALAW'
    end
    when tag = x2d(5) then do
      return 'MULAW'
    end
    when tag=x2d(1000) then do
      return 'TYPE_II_UNDEFINED'
    end
    when tag=x2d(1001) then do
      return 'MPEG'
    end
    when tag=x2d(1002) then do
      return 'AC-3'
    end
    when tag=x2d(2000) then do
      return 'TYPE_III_UNDEFINED'
    end
    when tag=x2d(2001) then do
      return 'IEC1937_AC-3'
    end
    when tag=x2d(2002) then do
      return 'IEC1937_MPEG-1_Layer1'
    end
    when tag=x2d(2003) then do
      return 'IEC1937_MPEG-1_Layer2/3 or IEC1937_MPEG-2_NOEXT'
    end
    when tag=x2d(2004) then do
      return 'IEC1937_MPEG-2_EXT'
    end
    when tag=x2d(2005) then do
      return 'IEC1937_MPEG-2_Layer1_LS'
    end
    when tag=x2d(2006) then do
      return 'IEC1937_MPEG-2_Layer2/3_LS'
    end
    otherwise
      return 'Unknown Tag'
  end
return 'Unknown Tag'

GetSyncType:procedure
parse arg bmAttributes .
return c2d(bitand(bmAttributes,x2c(b2x('00001100'))))/4




<<< Device Description >>>
 Type            : 01
 USB Rev         : 110
 Class           : Reserved (0)
 Subclass        : Reserved (0)
 Protocol        : Reserved (0)
  Device Information is defined at interface Level
 Max. packetsize : 08
 Vendor  ID      : 0CCD
 Product ID      : 0077
 Device Release# : 0100


<<< Device Description >>>
 Type            : 01
 USB Rev         : 110
 Class           : Reserved (0)
 Subclass        : Reserved (0)
 Protocol        : Reserved (0)
  Device Information is defined at interface Level
 Max. packetsize : 40
 Vendor  ID      : 0D8C
 Product ID      : 0008
 Device Release# : 0100
