/**
 * @#D Azarewicz:2.6#@##1## 30 Sep 2013              DAZAR1    ::::::@@TestLog.Cmd (c) David Azarewicz 2013
 * V1.7 16-Sep-2011 changed APM.SYS to APM.ADD for ACPI log
 * V1.8 31-Dec-2011 Added current directory to search path
 * V1.9 02-Jan-2012 Added dsl file to log, fixed some errors
 * V2.0 29-Jan-2012 Added test for debug PSD in acpi log
 * V2.1 29-Feb-2012 Added Multimac r8110 logging
 * V2.2 20-Mar-2012 Added Multimac r8169, e1000e, nveth logging, removed r8110
 * V2.3 07-Sep-2012 Fixed search for PCI.EXE
 * V2.4 11-Nov-2012 Added support for Panorama
 * V2.5 16-Jul-2013 Addes support for USB
 * V2.6 29-Jul-2013 Addes support for AHCI
 * Written by David Azarewicz http://88watts.net
 */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

PARSE ARG TestId Arg2;

PARSE SOURCE Junk Junk CmdName;
CmdName=TRANSLATE(FILESPEC('name', CmdName));
select;
  when (CmdName='ACPILOG.CMD') then SysId='acpi';
  when (CmdName='UNIAUDLOG.CMD') then SysId='uniaud';
  when (CmdName='GENMACLOG.CMD') then SysId='genmac';
  when (CmdName='SANELOG.CMD') then SysId='sane';
  when (CmdName='PANORAMALOG.CMD') then SysId='panorama';
  when (CmdName='USBLOG.CMD') then SysId='usb';
  when (CmdName='AHCILOG.CMD') then SysId='ahci';
  otherwise do;
    SysId=TestId;
    TestId=Arg2;
  end;
end;

SysId=TRANSLATE(SysId);

ENV='OS2ENVIRONMENT';
Host=VALUE('HOSTNAME',,ENV);
if (Host = '') then Host = "Unknown";
MyDate=DATE('S');
HostDate=Host||'-'||MyDate;
BreakLine='----- Output of: ';
HeaderLine='File created '||DATE('N')||' '||TIME('N')||' by TESTLOG.CMD V2.6 available at http://88watts.net';
BootDrive=SysBootDrive();
TmpDirSlash = STRIP(value('TMP',,ENV),'T','\') || '\';
EtcDir = STRIP(value('ETC',,ENV),'T','\');
LogFilesDir = STRIP(value('LOGFILES',,ENV),'T','\');
if (LogFilesDir = '') then LogFilesDir=BootDrive||'\var\log';
CurDir=Directory();
rc=VALUE('PATH', CurDir||';'||VALUE('PATH',,ENV), ENV);
/* find PCI.EXE */
PCIEXE=SysSearchPath('PATH', 'PCI.EXE');
if (PCIEXE='') then do;
  PCIEXE=BootDrive||'\ecs\install\DETECTEI\PCI.EXE';
  if (stream(PCIEXE,'c','query exists')='') then do;
    say "PCI.EXE not found";
    exit;
  end;
end;

'@echo off'
do while (QUEUED() <> 0); PULL; end;

select
  when (SysId="UNIAUD") then do
    say "Please type a short description of the test result (1 line):";
    PARSE PULL TestResult;
    MMBase = STRIP(value('MMBASE',,'OS2ENVIRONMENT'),'T',';');
    PkgVer = PkgVersion(MMBase||'\uniaud32.sys');
    if (TestId <> "") then PkgVer = PkgVer || "-" || TestId;
    LogFile = TmpDirSlash || HostDate || '-uniaud-' || PkgVer || '.log';
    ZipFile = TmpDirSlash || HostDate || '-uniaud-' || PkgVer || '.zip';
    rc=SysFileDelete(LogFile);
    rc=LINEOUT(LogFile, HeaderLine);
    rc=LINEOUT(LogFile, "Test result: " || TestResult);
    rc=LINEOUT(LogFile);
    rc = DoCommand('bldlevel '||BootDrive||'\os2krnl');
    rc = DoCommand('bldlevel '||MMBase||'\uniaud32.sys');
    rc = DoCommand('bldlevel '||MMBase||'\uniaud16.sys');
    rc = DoCommand('unimix -card');
    rc = DoCommand('unimix -list');
    rc = DoCommand('unimix -pcms');
    rc = DoCommand('unimix -powerget');
    rc = DoCommand('type alsahlp$');
    rc = DoCommand(PCIEXE);
    rc = DoCommand('rmview -irq');
    say LogFile||" has been created.";
  end
  when (SysId = "GENMAC") then do
    PARSE VALUE SysIni( , 'Generic MAC Wrapper Driver', 'Path') WITH GMBase'0'x;
    IF ((GMBase = '') | (GMBase = 'ERROR:')) THEN DO
       SAY 'error: cannot find GenMac Installation.';
       exit;
    END
    say "Please type a short description of the test result (1 line):";
    PARSE PULL TestResult;
    PkgVer = PkgVersion(GMBase||'\driver\genm32w.os2');
    if (TestId <> "") then PkgVer = PkgVer || "-" || TestId;
    LogFile = TmpDirSlash || HostDate || '-genmac-' || PkgVer || '.log';
    ZipFile = TmpDirSlash || HostDate || '-genmac-' || PkgVer || '.zip';
    rc=SysFileDelete(LogFile);
    rc=LINEOUT(LogFile, HeaderLine);
    rc=LINEOUT(LogFile, "Test result: " || TestResult);
    rc=LINEOUT(LogFile);
    rc = DoCommand('bldlevel '||BootDrive||'\os2krnl');
    rc = DoCommand('bldlevel '||GMBase||'\driver\genm32w.os2');
    rc = DoCommand('type wrnddb$');
    rc = DoCommand(PCIEXE);
    say LogFile||" has been created.";
    'zip -j -q 'ZipFile' 'LogFile
    say ZipFile||" has been created.";
  end
  when (SysId="SANE") then do
    say "Please type a short description of the test result (1 line):";
    PARSE PULL TestResult;
    SaneBase = 'e:\programs\tame';
    PkgVer = 'V';
    if (TestId <> "") then PkgVer = PkgVer || "-" || TestId;
    LogFile = TmpDirSlash || HostDate || '-sane-' || PkgVer || '.log';
    ZipFile = TmpDirSlash || HostDate || '-sane-' || PkgVer || '.zip';
    rc=SysFileDelete(LogFile);
    rc=LINEOUT(LogFile, HeaderLine);
    rc=LINEOUT(LogFile, "Test result: " || TestResult);
    rc=LINEOUT(LogFile);
    rc = DoCommand('bldlevel '||BootDrive||'\os2krnl');
    'set SANE_DEBUG_microtek2=255';
    'set SANE_DEBUG_SANEI_USB=255';
    'set SANE_DEBUG_DLL=255';
    rc = DoCommand('scanimage -L');
    'set SANE_DEBUG_microtek2=';
    'set SANE_DEBUG_SANEI_USB=';
    'set SANE_DEBUG_DLL=';
    say LogFile||" has been created.";
  end
  when (SysId = "ACPI") then do
    address CMD 'acpistat CheckDebugPSD >NUL 2>&1';
    if (rc > 0) then do;
      say "The debug version of the PSD is not running.";
      say "Please install the debug version of ACPI.PSD, reboot, and try again.";
      say "Press enter when ready...";
      pull Answer;
      exit;
    end;
    say "Please type a short description of the test result (1 line):";
    PARSE PULL TestResult;
    PkgVer = PkgVersion(BootDrive||'\os2\boot\acpi.psd');
    if (TestId <> "") then PkgVer = PkgVer || "-" || TestId;
    LogDir = TmpDirSlash || 'acpilog.tmp';
    if (BootDrive='Z:') then do
      LogName = 'acpi.log';
      LogFile = LogDir ||'\'|| LogName;
      ZipFile = TmpDirSlash || 'acpi.zip';
    end
    else do
      LogName = HostDate || '-acpi-' || PkgVer || '.log';
      LogFile = LogDir ||'\'|| LogName;
      ZipFile = TmpDirSlash || HostDate || '-acpi-' || PkgVer || '.zip';
    end
    rc=SysMkDir(LogDir);
    call SysFileTree LogDir||'\*', 'file', 'FO'
    do i=1 to file.0
      call SysFileDelete file.i
    end
    rc=Directory(LogDir);
    rc=LINEOUT(LogFile, HeaderLine);
    rc=LINEOUT(LogFile, "Test result: " || TestResult);
    rc=LINEOUT(LogFile);
    rc = DoCommand('dir /A '||BootDrive||'\os2*');
    rc = DoCommand('bldlevel '||BootDrive||'\os2krnl');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\acpi.psd');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\dll\acpi32.dll');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\apm.add');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\acpidaemon.exe');
    rc = DoCommand('type acpica$');
    rc = DoCommand(PCIEXE||' -N');
    rc = DoCommand('rmview -irq');
    rc = DoCommand('iasl -g');
    rc=AddFileToLog(EtcDir||'\acpid.cfg', LogFile);
    rc=AddFileToLog(LogFilesDir||'\acpidaemon.log', LogFile);
    call SysFileTree LogDir||'\*.dsl', 'file', 'FO'
    if (file.0 <> 0) then rc=AddFileToLog(file.1, LogFile);
    address CMD 'zip -j -q '||ZipFile||' '||LogDir||'\*';
    say ZipFile||" has been created.";
    address CMD 'copy '||LogFile||' '||TmpDirSlash||LogName||' >null 2>&1';
    say TmpDirSlash||LogName||" has been created.";
    rc=Directory(CurDir);
    call SysFileTree LogDir||'\*', 'file', 'FO'
    do i=1 to file.0
      call SysFileDelete file.i
    end
    rc=SysRmDir(LogDir);
    do while (QUEUED() <> 0); PULL; end;
    say "Please attach the above ZIP file to your ticket. (See the ACPI readme).";
    say "Press enter when ready...";
    pull Answer;
  end
  when (SysId="R8169") | (SysId="E1000E") | (SysId="NVETH") then do
    say "Please type a short description of the test result (1 line):";
    PARSE PULL TestResult;
    PkgVer = PkgVersion(BootDrive||'\ibmcom\macs\'||SysId||'.os2');
    if (TestId <> "") then PkgVer = PkgVer || "-" || TestId;
    LogFile = TmpDirSlash || HostDate || '-'||SysId||'-' || PkgVer || '.log';
    ZipFile = TmpDirSlash || HostDate || '-'||SysId||'-' || PkgVer || '.zip';
    rc=SysFileDelete(LogFile);
    rc=LINEOUT(LogFile, HeaderLine);
    rc=LINEOUT(LogFile, "Test result: " || TestResult);
    rc=LINEOUT(LogFile);
    rc = DoCommand('bldlevel '||BootDrive||'\os2krnl');
    rc = DoCommand('bldlevel '||BootDrive||'\ibmcom\macs\'||SysId||'.os2');
    rc = DoCommand('type '||SysId||'$');
    /* rc = DoCommand(PCIEXE); */
    rc = DoCommand('rmview -irq');
    rc=AddFileToLog(BootDrive||'\ibmcom\protocol.ini', LogFile);
    say LogFile||" has been created.";
  end
  when (SysId = "PANORAMA") then do
    say "Please type a short description of the test result (1 line):";
    PARSE PULL TestResult;
    PkgVer = PkgVersion(BootDrive||'\os2\dll\vbe2grad.dll');
    if (TestId <> "") then PkgVer = PkgVer || "-" || TestId;
    LogFile = TmpDirSlash || HostDate || '-panorama-' || PkgVer || '.log';
    ZipFile = TmpDirSlash || HostDate || '-panorama-' || PkgVer || '.zip';
    rc=SysFileDelete(LogFile);
    rc=LINEOUT(LogFile, HeaderLine);
    rc=LINEOUT(LogFile, "Test result: " || TestResult);
    rc=LINEOUT(LogFile);
    rc = DoCommand('bldlevel '||BootDrive||'\os2\dll\vbe2grad.dll');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\dll\panogrex.dll');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\gradd.sys');
    rc = DoCommand('PanoUtil -q -i -v -s');
    rc = DoCommand(PCIEXE||' -N');
    rc=AddFileToLog(LogFilesDir||'\vbe2grad.log', LogFile);
    say LogFile||" has been created.";
  end
  when (SysId = "USB") then do
    say "Please type a short description of the test result (1 line):";
    PARSE PULL TestResult;
    PkgVer = PkgVersion(BootDrive||'\os2\boot\usbehcd.sys');
    if (TestId <> "") then PkgVer = PkgVer || "-" || TestId;
    LogFile = TmpDirSlash || HostDate || '-usb-' || PkgVer || '.log';
    ZipFile = TmpDirSlash || HostDate || '-usb-' || PkgVer || '.zip';
    rc=SysFileDelete(LogFile);
    rc=LINEOUT(LogFile, HeaderLine);
    rc=LINEOUT(LogFile, "Test result: " || TestResult);
    rc=LINEOUT(LogFile);
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\usbehcd.sys');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\usbohcd.sys');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\usbuhcd.sys');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\usbd.sys');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\usbhid.sys');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\usbcom.sys');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\usbkbd.sys');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\usbprt.sys');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\usbmsd.add');
    rc = DoCommand('bldlevel '||FileFromConfigSys('usbmouse.sys'));
    rc = DoCommand('bldlevel '||FileFromConfigSys('amouse.sys'));
    rc = DoCommand(PCIEXE||' -N');
    say LogFile||" has been created.";
  end
  when (SysId = "AHCI") then do
    say "Please type a short description of the test result (1 line):";
    PARSE PULL TestResult;
    PkgVer = PkgVersion(BootDrive||'\os2\boot\os2ahci.add');
    if (TestId <> "") then PkgVer = PkgVer || "-" || TestId;
    LogFile = TmpDirSlash || HostDate || '-ahci-' || PkgVer || '.log';
    ZipFile = TmpDirSlash || HostDate || '-ahci-' || PkgVer || '.zip';
    rc=SysFileDelete(LogFile);
    rc=LINEOUT(LogFile, HeaderLine);
    rc=LINEOUT(LogFile, "Test result: " || TestResult);
    rc=LINEOUT(LogFile);
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\os2ahci.add');
    rc = DoCommand('bldlevel '||BootDrive||'\os2\boot\danis506.add');
    rc = DoCommand('type os2ahci$');
    rc = DoCommand('type ibms506$');
    rc = DoCommand(PCIEXE||' -N');
    say LogFile||" has been created.";
  end
  otherwise do
    say "Usage: testlog uniaud|genmac|sane|acpi|r8169|nveth|e1000e|panorama|usb [testid]";
  end
end

rc=Directory(CurDir);
exit;

DoCommand:
  Cmd = ARG(1);
  Line = OVERLAY(Cmd||' ', BreakLine, 18, 80, '-');
  rc=LINEOUT(LogFile, Line); rc=LINEOUT(LogFile);
  address CMD Cmd || ' 1>>'||LogFile||' 2>&1';
  RETURN(0);

PkgVersion:
  File = ARG(1);
  '@bldlevel 'File' 2>&1 | rxqueue'
  do while (QUEUED() > 0)
    PARSE PULL Line1':'Line2
    if (Line1 = "Revision") then leave;
    if (Line1 = "File Version") then leave;
    Line2 = "";
  end
  do while (QUEUED() <> 0); PULL; end;
  Return(STRIP(Line2,'B'));

CheckDebugVersion:
  File = ARG(1);
  address CMD '@bldlevel '||File||' 2>&1 | rxqueue'
  do while (QUEUED() > 0)
    PARSE PULL Line1':'Line2
    if (Line1 = "Signature") then leave;
    Line2 = "";
  end
  do while (QUEUED() <> 0); PULL; end;
  Return(POS("Debug", Line2));

AddFileToLog:
  parse arg FileName, LogFile;
  Line = OVERLAY(FileName||' ', BreakLine, 18, 80, '-');
  rc=LINEOUT(LogFile, Line);
  do while LINES(FileName) <> 0;
    rc=LINEOUT(LogFile, LINEIN(FileName));
  end;
  rc=LINEOUT(LogFile);
  rc=stream(FileName,'c','close');
  return 0;

FileFromConfigSys:
  parse upper arg SearchString;
  ConfigSys=BootDrive||'\config.sys';
  do while LINES(ConfigSys) <> 0;
    Line=STRIP(TRANSLATE(LINEIN(ConfigSys)));
    if (LEFT(Line,3)='REM') then iterate;
    if (POS(SearchString, Line) > 0) then leave;
  end;
  rc=stream(configSys,'c','close');
  FileName = STRIP(SUBSTR(Line, POS('=',Line)+1));
  return FileName;

