#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_LONGLONG
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

typedef long long	LLONG;

int main(int argc, char *argv[])
{
  LLONG		llUnit;
  LLONG		llSize;
  LLONG		llFree;
  PCHAR		pcSize;
  PCHAR		pcUI;
  BOOL		fInvert;
  ULONG		ulRC = NO_ERROR;
  HFILE		hFile;
  ULONG		ulAction;
  PSZ		pszError;
  ULONG		ulDiskNum;
  PSZ		pszFName;
  FSALLOCATE	sFSAlloc;

  do
  {
    if ( argc != 3 )
      break;

    pcSize = argv[2];

    fInvert = *pcSize == '-';
    if ( fInvert )
      pcSize++;

    llSize = strtoll( pcSize, &pcUI, 10 ); 
    if ( ( pcUI == pcSize ) || ( llSize < 0 ) )
      break;

    pszFName = argv[1];

    if ( pszFName[1] == ':' )
    {
      ulDiskNum = ( tolower( *pszFName ) - 'a' ) + 1;
    }
    else
      ulDiskNum = 0;

    ulRC = DosQueryFSInfo( ulDiskNum, FSIL_ALLOC, &sFSAlloc,
                           sizeof(FSALLOCATE) );

    if ( ulRC != NO_ERROR )
    {
      if ( ulRC == ERROR_INVALID_DRIVE )
      {
        printf( "Drive is not valid\n" );
      }
      else
        printf( "DosQueryFSInfo(), rc=%u\n", ulRC );

      return 1;
    }

    llUnit = (LLONG)sFSAlloc.cSectorUnit * (LLONG)sFSAlloc.cbSector;
    llFree = (LLONG)sFSAlloc.cUnitAvail * llUnit;

    printf( "%lld bytes free on ", llFree );
    if ( ulDiskNum != 0 )
    {
      printf( "drive %c:\n", llFree, 'A' + ulDiskNum - 1 );
    }
    else
      printf( "current drive.\n" );

    switch( tolower( *pcUI ) )
    {
      case 'k':
        llSize *= 1024;
        break;
      case 'm':
        llSize *= (1024 * 1024);
        break;
      case 'u':
        llSize *= llUnit;
        break;
    }

    if ( fInvert )
    {
      llSize = llFree - llSize;
      if ( llSize < 0 )
      {
        printf( "Invalid size.\n" );
        return 1;
      }

    }
    printf( "Allocating %lld bytes.\n", llSize );

    ulRC = DosOpenL( pszFName, &hFile, &ulAction, *(PLONGLONG)&llSize,
                     FILE_NORMAL,
                     OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_FAIL_IF_EXISTS,
                     OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYNONE |
                     OPEN_ACCESS_READWRITE, NULL );

    switch( ulRC )
    {
      case NO_ERROR:
        pszError = "Ok";
        DosClose( hFile );
        break;
      case ERROR_PATH_NOT_FOUND:
        pszError = "Path not found";
        break;
      case ERROR_TOO_MANY_OPEN_FILES: 
        pszError = "Too many open files (no handles left)";
        break;
      case ERROR_ACCESS_DENIED:
        pszError = "Access denied";
        break;
      case ERROR_NOT_DOS_DISK:
        pszError = "Unknown media type";
        break;
      case ERROR_SHARING_VIOLATION:
        pszError = "Sharing violation";
        break;
      case ERROR_SHARING_BUFFER_EXCEEDED:
        pszError = "Sharing buffer overflow";
        break;
      case ERROR_DEVICE_IN_USE:
        pszError = "Device in use";
        break;
      case ERROR_DRIVE_LOCKED:
        pszError = "Drive locked by another process";
        break;
      case ERROR_OPEN_FAILED:
        pszError = "Open/create failed due to explicit fail command";
        break;
      case ERROR_DISK_FULL:
        pszError = "Not enough space on the disk";
        break;
      default:
        pszError = NULL;
    }

    printf( "RC=%u", ulRC );
    if ( pszError != NULL )
      printf( ", %s.\n", pszError );

    return ulRC == NO_ERROR ? 0 : 1;
  }
  while( FALSE );

  printf( "\nUsage: bladder.exe <file> <size>[bkmu]\n\n" );
  printf( "  size\t\tfile size\n" );
  printf( "  -size\t\tfile size = free space - size\n" );
  printf( "  b/k/m/u\tbytes (default)/Kb/Mb/units\n" );
  return 1;
}
