#! /usr/bin/python -tt

import os
import sys
import yum

yb = yum.YumBase()
yb.setCacheDir()
yb.conf.cache = os.geteuid() != 1

try:
    if len(sys.argv) > 1 and sys.argv[1] in ['all',
                                             'installed',
                                             'available',
                                             'updates',
                                             'recent',
                                             'obsoletes',
                                             'extras']:
        what = sys.argv[1]
        if len(sys.argv) < 3:
            pl = yb.doPackageLists(pkgnarrow=what)
        else:
            pl = yb.doPackageLists(pkgnarrow=what, patterns=sys.argv[2:])
    else:
        what = ''
        if len(sys.argv) < 2:
            pl = yb.doPackageLists()
        else:
            pl = yb.doPackageLists(patterns=sys.argv[1:])
except yum.Errors.YumBaseError as exc:
    what, why, other = exc.value
    print 'Error:', what, why

if pl.installed:
    print "Installed Packages"
    for pkg in sorted(pl.installed):
        print pkg.name, pkg.version + "-" + pkg.release, pkg.repoid, pkg.summary
    print
if pl.available:
    print "Available Packages"
    for pkg in sorted(pl.available):
        print pkg.name, pkg.version + "-" + pkg.release, pkg.repo, pkg.summary
    print

if what == '':
    pl = yb.doPackageLists(pkgnarrow='updates',patterns=sys.argv[1:])
if pl.updates:
    print "Updated Packages"
    for pkg in sorted(pl.updates):
        print pkg.name, pkg.version + "-" + pkg.release, pkg.repo
    print

if what == '':
    pl = yb.doPackageLists(pkgnarrow='recent',patterns=sys.argv[1:])
if pl.recent:
    print "Recently Added Packages"
    for pkg in sorted(pl.recent):
        print pkg.name, pkg.version + "-" + pkg.release, pkg.repo
    print

if pl.obsoletes:
    print "Obsolete Packages"
    for pkg in sorted(pl.obsoletes):
        print pkg.name, pkg.version + "-" + pkg.release, pkg.repo, pkg.summary
    print

if pl.extras:
    print "Extra Packages"
    for pkg in sorted(pl.extras):
        print pkg.name, pkg.version + "-" + pkg.release, pkg.repo, pkg.summary
    print

