/* REXX */
echo on

/*
   WPS info for IBM Developer's Toolkit is at e:\var\toolkit.objects.classes
   WPS info for Desktop is at g:\var\Desktop.objects.classes
*/

Call rxfuncadd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs'

Call SysIni 'BOTH','FolderWorkareaRunningObjects','ALL:','DESK'
trace ?i
CRLF ='0D0A'X
Desktop = desk.1

NewBoot = SysBootDrive()
parse upper arg OldBoot .
if OldBoot = '' then OldBoot = G
Oldboot = left(Oldboot,2,':')

ETC = value('ETC',,'OS2ENVIRONMENT')

/* copy definitions of cloned repositories */
copy oldboot'\etc\yum\repos.d\\*-clone.repo' newboot'\etc\yum\repos.d\'

/* Install from cloned repository */
'yum --disablerepo=*-rel install aspell'                   ,
                                'bind-utils'               ,
                                'bison'                    ,
                                'bison-runtime'            ,
                                'clamav'                   ,
                                'createrepo'               ,
                                'diffutils'                ,
                                'flex'                     ,
                                'gawk'                     ,
                                'gcc'                      ,
                                'gcc-stdc++-shared-lib'    ,
                                'highmem'                  ,
                                'm4'                       ,
                                'openssh-clients'          ,
                                'os2-rpm-build'            ,
                                'os2tk45'                  ,
                                'os2tk45-books'            ,
                                'os2tk45-headers'          ,
                                'os2tk45-ipfc'             ,
                                'os2tk45-libs'             ,
                                'os2tk45-libs'             ,
                                'os2tk45-rc'               ,
                                'os2tk45-readme'           ,
                                'os2tk45-utils'            ,
                                'patch'                    ,
                                'perl-CGI'                 ,
                                'perl-core'                ,
                                'perl-CPAN'                ,
                                'perl-CPANPLUS'            ,
                                'perl-datadump'            ,
                                'perl-datadumper'          ,
                                'perl-devel'               ,
                                'perl-Digest-HMAC'         ,
                                'perl-Digest-SHA'          ,
                                'perl-Error'               ,
                                'perl-ExtUtils-MakeMaker'  ,
                                'perl-ExtUtils-ParseXS'    ,
                                'perl-HTML-Tagset'         ,
                                'perl-IO-String'           ,
                                'perl-Params-Util'         ,
                                'perl-Regexp-Common'       ,
                                'perl-Test-Pod'            ,
                                'perl-TimeDate'            ,
                                'perl-URI'                 ,
                                'perl-version'             ,
                                'RXU'                      ,
                                'tar'                      ,
                                'watcom-wipfc'             ,
                                'watcom-wlink-hll'         ,
                                'watcom-wrc'               ,
                                'whois'

/* Copy INI data */

if SysIni(OldBoot'\OS2\OS2.INI', 'Fax', 'ALL:', 'FAX.') = 'ERROR:' then
   say 'Unable to find application Fax in' OldBoot'\OS2\OS2.INI'
else do i=1 to Fax.0
   value = SysIni(OldBoot'\OS2\OS2.INI', 'Fax', Fax.i)
   call SysIni USER, 'Fax', Fax.i, value
   end

if SysIni(OldBoot'\OS2\OS2.INI', 'GFC', 'ALL:', 'GFC.') = 'ERROR:' then
   say 'Unable to find application GFC in' OldBoot'\OS2\OS2.INI'
else do i=1 to GFC.0
   value = SysIni(OldBoot'\OS2\OS2.INI', 'GFC', GFC.i)
   call SysIni USER, 'GFC', GFC.i, value
   end

if SysIni(OldBoot'\OS2\OS2.INI', 'GTU.GLOBAL', 'ALL:', 'GTU.') = 'ERROR:' then
   say 'Unable to find application GTU.GLOBAL in' OldBoot'\OS2\OS2.INI'
else do i=1 to GTU.0
   value = SysIni(OldBoot'\OS2\OS2.INI', 'GTU.GLOBAL', GTU.i)
   call SysIni USER, 'GTU.GLOBAL', GTU.i, value
   end

if SysIni(OldBoot'\OS2\OS2.INI', 'GTU.OPTIMIZE', 'ALL:', 'GTU.') = 'ERROR:' then
   say 'Unable to find application GTU.OPTIMIZE in' OldBoot'\OS2\OS2.INI'
else do i=1 to GTU.0
   value = SysIni(OldBoot'\OS2\OS2.INI', 'GTU.OPTIMIZE', GTU.i)
   call SysIni USER, 'GTU.OPTIMIZE', GTU.i, value
   end

if SysIni(OldBoot'\OS2\OS2.INI', 'GTU.SENTRY', 'ALL:', 'GTU.') = 'ERROR:' then
   say 'Unable to find application GTU.SENTRY in' OldBoot'\OS2\OS2.INI'
else do i=1 to GTU.0
   value = SysIni(OldBoot'\OS2\OS2.INI', 'GTU.SENTRY', GTU.i)
   call SysIni USER, 'GTU.SENTRY', GTU.i, value
   end


if SysIni(OldBoot'\OS2\OS2.INI', 'VIEWALL', 'ALL:', 'VIEWALL.') = 'ERROR:' then
   say 'Unable to find application VIEWALL in' OldBoot'\OS2\OS2.INI'
else do i=1 to VIEWALL.0
   value = SysIni(OldBoot'\OS2\OS2.INI', 'VIEWALL', VIEWALL.i)
   call SysIni USER, 'VIEWALL', VIEWALL.i, value
   end

backupdir = SysIni(OldBoot'\OS2\OS2.INI', 'Uni Maintenance', 'Port Backup Default Directory')
call SysIni USER,'Uni Maintenance', 'Port Backup Default Directory', backupdir

/* Set kLIBC path mappings
call SysIni ETC'\KLIBCFG.INI', REWRITE, alias, truepath
*/
call SysIni ETC'\KLIBCFG.INI', REWRITE, '/drives/H', 'H:\'
call SysIni ETC'\KLIBCFG.INI', REWRITE, '/drives/J', 'J:\'
call SysIni ETC'\KLIBCFG.INI', REWRITE, '/drives/K', 'K:\'

/* Install 3rd party software */
SET BEGINLIBPATH'='NewBoot'\sys\install\WARPIN'
NewBoot'\sys\install\WARPIN\warpin H:\Vendors\JAREAD\Filestar\fs_30500.wpi'
'H:\Vendors\GammaTech\GTU40\GTINST.EXE'
NewBoot'\sys\install\WARPIN\warpin H:\Vendors\Bitwise\AOO-4130-GA-base-en-US.wpi'
NewBoot'\sys\install\WARPIN\warpin H:\Vendors\JAREAD\Unimaint\um_51032.wpi'

/* call 'h:\Vendors\STARDOCK\GC2\INSTALL.CMD' */

copy OldBoot'\MPTN\ETC\TCPOS2.INI'                  ETC'\TCPOS2.INI'
md   ETC'\WHOIS'
copy OldBoot'\MPTN\ETC\WHOIS\*'                     ETC'\WHOIS'

Object      = '<WP_OS2WIN>'
SetupString = 'PARAMETERS=/k mode 80,100;'                             || ,
              'STARTUPDIR=H:\;'
call SetObjectData

Object      = '<WP_4OS2WIN>'
SetupString = 'PARAMETERS=/k mode 80,100;'                             || ,
              'STARTUPDIR=H:\;'
call SetObjectData

'H:\Vendors\DFSEE\dfsee_os2_wpi'
copy OldBoot'\SYS\APPS\DFSEE\BIN\DFSEE.KEY'       NewBoot'\SYS\APPS\DFSEE\BIN\DFSEE.KEY'

Location    = '<WP_DESKTOP>'
Title       = 'Family Tree 1.2f'
Class       = 'XWPProgram'
SetupString =  'OBJECTID=<FTREE>;'                                     || ,
               'PROGTYPE=PM;'                                          || ,
               'EXENAME=H:\UTILITY\FTREE\FTREE.EXE;'                   || ,
               'PARAMETERS=metz.fam;'                                  || ,
               'STARTUPDIR=H:\UTILITY\FTREE;'                          || ,
               'ASSOCFILTER=*.FAM;'
call CreateObject


Location    = '<WP_DESKTOP>'
Title       = 'Galactic Civilizations 2'
Class       = 'WPPngFolder'
SetupString = 'OBJECTID=<GCFOLDER>;'                                   || ,
              'ICONRESOURCE=1,H:\GAMES\GALCIV\GALCIV.EXE'

if CreateObject() then do
   Location    = '<GCFOLDER>'
   Title       = 'Galactic Civilizations'
   Class       = 'XWPProgram'
   SetupString = 'OBJECTID=<GCPROGRAM>;'                               || ,
                 'PROGTYPE=PM;'                                        || ,
                 'EXENAME=H:\GAMES\GALCIV\GALCIV.EXE;'                 || ,
                 'STARTUPDIR=H:\GAMES\GALCIV;'                         || ,
                 'ICONRESOURCE=1,H:\GAMES\GALCIV\GALCIV.EXE'
   call CreateObject

   Location    = '<GCFOLDER>'
   Title       = 'GalCiv: The Movie'
   Class       = 'XWPProgram'
   SetupString = 'PROGTYPE=PM;'                                        || ,
                 'EXENAME=MPPM.EXE;'                                   || ,
                 'PARAMETERS=H:\Vendors\STARDOCK\GC2\GCMOVIE.AVI;'     || ,
                 'ICONRESOURCE=1,H:\GAMES\GALCIV\GALCIV.EXE'
   call CreateObject

   Location    = '<WP_GAMES>'
   Object      = '<GCPROGRAM>'
   call CreateShadow
   end


Location    = '<WP_DESKTOP>'
Title       = 'GFC'
Class       = 'XWPProgram'
SetupString = 'PROGTYPE=PM;'                                           || ,
              'EXENAME=H:\PRODTOOL\OS2GFC\GFC.EXE;'                    || ,
              'STARTUPDIR=H:\PRODTOOL\OS2GFC;'
call CreateObject


Object      = '<gtu 4.0>'
SetupString = 'ICONFILE='NewBoot'\GTU40\GAMMA.ICO;'
call SetObjectData

tk:
/* IBM Developer's Toolkit */

Location    = '<WP_PROGRAMSFOLDER>'
Title       = 'Development'
Class       = 'WPPngFolder'
SetupString = 'OBJECTID=<WP_DEVFLDR>;'

Location    = '<WP_DEVFLDR>'
Title       = "IBM Developer's Toolkit!!version 4.5"
Class       = 'WPPngFolder'
SetupString = 'OBJECTID=<TOOLKIT>;'

Location    = '<WP_DEVFLDR>'
Title       = "IBM Developer's Toolkit^version 4.5"
Class       = 'WPPngFolder'
SetupString = 'ICONVIEW=FLOWED,VISIBLE,NORMAL;'                        || ,
              'TREEVIEW=LINES,VISIBLE,MINI;'                           || ,
              'DEFAULTSORT=1;'                                         || ,
              'ALWAYSSORT=YES;'                                        || ,
              "TITLE=IBM Developer's Toolkit^version 4.5;"             || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT>;'
call CreateObject

Location    = '<TOOLKIT>'
Title       = 'Development Tools'
Class       = 'WPPngFolder'
SetupString = 'ICONVIEW=NONGRID,NORMAL;'                               || ,
              'TREEVIEW=LINES,VISIBLE,MINI;'                           || ,
              'DEFAULTSORT=1;'                                         || ,
              'ALWAYSSORT=YES;'                                        || ,
              'TITLE=Development Tools;'                               || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_DEVTOOLS>;'
call CreateObject

/*
copy oldboot'\OS2TK45\bin\kwikinf.exe' newboot'\usr\bin\'
copy oldboot'\OS2TK45\dll\kiutil.dll'  newboot'\usr\lib\'
Location    = '<TOOLKIT_DEVTOOLS>'
Title       = 'KwikInf'
Class       = 'XWPProgram'
SetupString = 'EXENAME='newboot'\usr\bin\KWIKINF.EXE;'                 ||;
              'STARTUPDIR='newboot'\usr\bin;'                          ||;
              'PROGTYPE=PM;'                                           ||;
              'TITLE=KwikInf;'                                         ||;
              'NOPRINT=YES;'                                           ||;
              'HIDEBUTTON=DEFAULT;'                                    ||;
              'MINWIN=DEFAULT;'                                        ||;
              'CCVIEW=DEFAULT;'                                        ||;
              'DEFAULTVIEW=DEFAULT;'                                   ||;
              'OBJECTID=<TOOLKIT_DEVTOOLS_BASE_KWIKINF>;'
call CreateObject
*/

Location    = '<TOOLKIT>'
Title       = 'Toolkit Information'
Class       = 'WPPngFolder'
SetupString = 'ICONVIEW=FLOWED,VISIBLE,NORMAL;'                        || ,
              'TREEVIEW=LINES,VISIBLE,MINI;'                           || ,
              'DEFAULTSORT=1;'                                         || ,
              'ALWAYSSORT=YES;'                                        || ,
              'TITLE=Toolkit Information;'                             || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Legacy Resource Compiler^(RC16) Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=rc16.inf;'                                   || ,
              'TITLE=Legacy Resource Compiler^(RC16) Reference;'       || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_RC16>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'NMAKE32 Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=nmake32.inf;'                                || ,
              'TITLE=NMAKE32 Reference;'                               || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_NMAKE32>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'C Library Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=xpg4ref.inf;'                                || ,
              'TITLE=C Library Reference;'                             || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_CLIBREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'SOM Programming Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=somref.inf;'                                 || ,
              'TITLE=SOM Programming Reference;'                       || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_SOMREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'SOM Programming Guide'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=somguide.inf;'                               || ,
              'TITLE=SOM Programming Guide;'                           || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_SOMGDE>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'TCP/IP Programming Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=tcppr.inf;'                                  || ,
              'TITLE=TCP/IP Programming Reference;'                    || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_TCPIPREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'OS/2 Debugging Handbook'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'TITLE=OS/2 Debugging Handbook;'                         || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_DEBUGREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'OS/2 Programming^Guide and Reference Addendum'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=addendum.inf;'                               || ,
              'TITLE=OS/2 Programming^Guide and Reference Addendum;'   || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_ADDENDUM>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Workplace Shell^Programming Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=WPS1.INF+WPS2.INF+WPS3.INF;'                 || ,
              'TITLE=Workplace Shell^Programming Reference;'           || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_WPSREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Workplace Shell^Programming Guide'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=wpsguide.inf;'                               || ,
              'TITLE=Workplace Shell^Programming Guide;'               || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_WPSGDE>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Multimedia Subsystem^Programming Guide'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=mmsspg.inf;'                                 || ,
              'TITLE=Multimedia Subsystem^Programming Guide;'          || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_MMSUBGDE>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Multimedia Programming^Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=MMREF1.INF+MMREF2.INF+MMREF3.INF;'           || ,
              'TITLE=Multimedia Programming^Reference;'                || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_MMREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Multimedia Application^Programming Guide'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=mmapg.inf;'                                  || ,
              'TITLE=Multimedia Application^Programming Guide;'        || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_MMAPPGDE>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'IPF Programming^Guide and Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=ipfref.inf;'                                 || ,
              'TITLE=IPF Programming^Guide and Reference;'             || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_IPFGDEREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Bidirectional Language^Programming Guide'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=pmbdtech.inf;'                               || ,
              'TITLE=Bidirectional Language^Programming Guide;'        || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_BIDIGDE>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'rxstring.doc'
Class       = 'WPShadow'
SetupString = 'SHADOWID='newboot'\usr\share\os2\book\RXSTRING.DOC;'    || ,
              'TITLE=rxstring.doc;'                                    || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_RXSTRING>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Control Program Programming^Guide and Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=CP1.INF+CP2.INF+CP3.INF;'                    || ,
              'TITLE=Control Program Programming^Guide and Reference;' || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_CPGDEREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Windows Sockets'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=winsoc11.inf;'                               || ,
              'TITLE=Windows Sockets;'                                 || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_WINSOCK>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Presentation Manager Programming^Guide and Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                           || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'                    || ,
              'PROGTYPE=PM;'                                                || ,
              'PARAMETERS=PM1.INF+PM2.INF+PM3.INF+PM4.INF+PM5.INF;'         || ,
              'TITLE=Presentation Manager Programming^Guide and Reference;' || ,
              'NOPRINT=YES;'                                                || ,
              'HIDEBUTTON=DEFAULT;'                                         || ,
              'MINWIN=DEFAULT;'                                             || ,
              'CCVIEW=DEFAULT;'                                             || ,
              'DEFAULTVIEW=DEFAULT;'                                        || ,
              'OBJECTID=<TOOLKIT_INFO_PMGDEREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'OpenGL Programming^Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=oglbase.inf;'                                || ,
              'TITLE=OpenGL Programming^Reference;'                    || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_OGLBASE>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Open32 Programming Guide^and Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=open32.inf;'                                 || ,
              'TITLE=Open32 Programming Guide^and Reference;'          || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_DAXPROG>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Object REXX Programming Guide'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=rexxpg.inf;'                                 || ,
              'TITLE=Object REXX Programming Guide;'                   || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_REXXPG>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Tools Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=toolsref.inf;'                               || ,
              'TITLE=Tools Reference;'                                 || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_TOOLSREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'IBM OS/2 Server Family^Programming Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=srvfpgr.inf;'                                || ,
              'TITLE=IBM OS/2 Server Family^Programming Reference;'    || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_LANSERVREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'GPI Guide^and Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=GPI1.INF+GPI2.INF+GPI3.INF+GPI4.INF;'        || ,
              'TITLE=GPI Guide^and Reference;'                         || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_GPIGDEREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = "DPI Programmer's Guide"
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=dpil1mst.inf;'                               || ,
              "TITLE=DPI Programmer's Guide;"                          || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_DPIGUIDE>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = "DMI Programmer's Guide"
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=dnal1mst.inf;'                               || ,
              "TITLE=DMI Programmer's Guide;"                          || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_DMIGUIDE>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'ALP Programming^Guide and Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=alpref.inf;'                                 || ,
              'TITLE=ALP Programming^Guide and Reference;'             || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_ALPREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Problem Determination^Guide and Reference'
Class       = 'XWPProgram'
SetupString = 'EXENAME=VIEW.EXE;'                                      || ,
              'STARTUPDIR='newboot'\usr\share\os2\book;'               || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=pdguide.inf;'                                || ,
              'TITLE=Problem Determination^Guide and Reference;'       || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<TOOLKIT_INFO_PROBDET>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'LX Module Format Specification'
Class       = 'WPUrl'
SetupString = 'TITLE=LX Module Format Specification;'                    || ,
              'URL=file:///'newboot'\OS2TK45\book\lxref.htm;'            || ,
              'DEFAULTBROWSER='newboot'\PROGRAMS\Firefox\firefox!k.exe;' || ,
              'DEFAULTWORKINGDIR='newboot'\PROGRAMS\Firefox;'            || ,
              'HIDEBUTTON=DEFAULT;'                                      || ,
              'MINWIN=DEFAULT;'                                          || ,
              'CCVIEW=DEFAULT;'                                          || ,
              'DEFAULTVIEW=ICON;'                                        || ,
              'OBJECTID=<TOOLKIT_INFO_LXREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Object Module Format Specification'
Class       = 'WPUrl'
SetupString = 'TITLE=Object Module Format Specification;'                || ,
              'URL=file:///'newboot'\OS2TK45\book\omfref.htm;'           || ,
              'DEFAULTBROWSER='newboot'\PROGRAMS\Firefox\firefox!k.exe;' || ,
              'DEFAULTWORKINGDIR='newboot'\PROGRAMS\Firefox;'            || ,
              'HIDEBUTTON=DEFAULT;'                                      || ,
              'MINWIN=DEFAULT;'                                          || ,
              'CCVIEW=DEFAULT;'                                          || ,
              'DEFAULTVIEW=ICON;'                                        || ,
              'OBJECTID=<TOOLKIT_INFO_OMFREF>;'
call CreateObject

Location    = '<TOOLKIT_INFO>'
Title       = 'Unicode Programming Reference'
Class       = 'WPUrl'
SetupString = 'TITLE=Unicode Programming Reference;'                     || ,
              'URL=file:///'newboot'\OS2TK45\book\uniapi.htm;'           || ,
              'DEFAULTBROWSER='newboot'\PROGRAMS\Firefox\firefox!k.exe;' || ,
              'DEFAULTWORKINGDIR='newboot'\PROGRAMS\Firefox;'            || ,
              'HIDEBUTTON=DEFAULT;'                                      || ,
              'MINWIN=DEFAULT;'                                          || ,
              'CCVIEW=DEFAULT;'                                          || ,
              'DEFAULTVIEW=ICON;'                                        || ,
              'OBJECTID=<TOOLKIT_INFO_UNICODE>;'
call CreateObject

/* Install IBMWORKS */

/*
cdd 'H:\vendors\IBM\BONTRIAL\IBMBON'
PATH '%PATH'NewBoot'\OS2\INSTALL;'
SET BEGINLIBPATH'='NewBoot'\OS2\INSTALL'
MD '/s' Newboot':\ECS\INSTALL\RSP'
ibmworks
*/

/* Copy                     */
xcopy '/h /o /t /s /e /r /v'              OldBoot'\PROGRAMS\ibmworks' ,
                                          NewBoot'\PROGRAMS\ibmworks\'
copy                                      OldBoot'\OS2\DLL\fpw*'      ,
                                          NewBoot'\OS2\DLL\'
copy                                      OldBoot'\OS2\DLL\ien*'      ,
                                          NewBoot'\OS2\DLL\'

Location    = "<WP_READMEFOLDER>"
Title       = "IBM Works^ReadMe"
Class       = "WPProgram"
SetupString = 'EXENAME='newboot'\PROGRAMS\IBMWORKS\IBMWORKS.EXE;'      || ,
              'PARAMETERS='newboot'\PROGRAMS\ibmworks\readme;'         || ,
              'TITLE=IBM Works^ReadMe;'                                || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<WP_FPWO_README>;'
call CreateObject

Location    = "<WP_APPSFOLDER>"
Title       = "IBM Works"
Class       = "WPFolder"
SetupString = 'ICONVIEW=NONGRID,NORMAL;'                               || ,
              'TREEVIEW=LINES,VISIBLE,MINI;'                           || ,
              'DEFAULTSORT=-2;'                                        || ,
              'ALWAYSSORT=YES;'                                        || ,
              'TITLE=IBM Works;'                                       || ,
              'ICONVIEWPOS=14,59,80,14;'                               || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<WP_FPWO_FOLD>;'
call CreateObject

Location    = "<WP_FPWO_FOLD>"
Title       = "FootPrint Catalyst"
Class       = "FpwCatalyst"
SetupString = 'TITLE=FootPrint Catalyst;'                              || ,
              'NOPRINT=YES;'                                           || ,
              'NOTVISIBLE=YES;'                                        || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<FPW_CATALYST>;'
call CreateObject

Location    = "<WP_FPWO_FOLD>"
Title       = "Appointments"
Class       = "WPProgram"
SetupString = 'EXENAME='newboot'\PROGRAMS\IBMWORKS\FPWPIM.EXE;'        || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=-M;'                                         || ,
              'TITLE=Appointments;'                                    || ,
              'NOPRINT=YES;'                                           || ,
              'HELPPANEL=12000;'                                       || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=YES;'                                            || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<WP_FPWPIMA_EXE>;'
call CreateObject

Location    = "<WP_FPWO_FOLD>"
Title       = "Phone/Address Book"
Class       = "WPProgram"
SetupString = 'EXENAME='newboot'\PROGRAMS\IBMWORKS\FPWPIM.EXE;'        || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=-P;'                                         || ,
              'TITLE=Phone/Address Book;'                              || ,
              'NOPRINT=YES;'                                           || ,
              'HELPPANEL=13000;'                                       || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=YES;'                                            || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<WP_FPWPIMP_EXE>;'
call CreateObject

Location    = "<WP_FPWO_FOLD>"
Title       = "Notepad"
Class       = "WPProgram"
SetupString = 'EXENAME='newboot'\PROGRAMS\IBMWORKS\FPWPIM.EXE;'        || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=-N;'                                         || ,
              'TITLE=Notepad;'                                         || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=YES;'                                            || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<WP_FPWPIMN_EXE>;'
call CreateObject

Location    = "<WP_FPWO_FOLD>"
Title       = "Planner"
Class       = "WPProgram"
SetupString = 'EXENAME='newboot'\PROGRAMS\IBMWORKS\FPWPIM.EXE;'        || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=-G;'                                         || ,
              'TITLE=Planner;'                                         || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=YES;'                                            || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<WP_FPWPIMG_EXE>;'
call CreateObject

Location    = "<WP_FPWO_FOLD>"
Title       = "To Do List"
Class       = "WPProgram"
SetupString = 'EXENAME='newboot'\PROGRAMS\IBMWORKS\FPWPIM.EXE;'        || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=-T;'                                         || ,
              'TITLE=To Do List;'                                      || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=YES;'                                            || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<WP_FPWPIMT_EXE>;'
call CreateObject

Location    = "<WP_FPWO_FOLD>"
Title       = "Year Calendar"
Class       = "WPProgram"
SetupString = 'EXENAME='newboot'\PROGRAMS\IBMWORKS\FPWPIM.EXE;'        || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=-Y;'                                         || ,
              'TITLE=Year Calendar;'                                   || ,
              'NOPRINT=YES;'                                           || ,
              'HELPPANEL=11210;'                                       || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=YES;'                                            || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<WP_FPWPIMY_EXE>;'
call CreateObject

Location    = "<WP_FPWO_FOLD>"
Title       = "Event Monitor"
Class       = "WPProgram"
SetupString = 'EXENAME='newboot'\PROGRAMS\IBMWORKS\FPWMON.EXE;'        || ,
              'PROGTYPE=PM;'                                           || ,
              'TITLE=Event Monitor;'                                   || ,
              'NOPRINT=YES;'                                           || ,
              'HELPPANEL=10100;'                                       || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=YES;'                                            || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<WP_FPWPIME_EXE>;'
call CreateObject

Location    = "<WP_FPWO_FOLD>"
Title       = "PIM Preference"
Class       = "WPProgram"
SetupString = 'EXENAME='newboot'\PROGRAMS\IBMWORKS\FPWPIM.EXE;'        || ,
              'PROGTYPE=PM;'                                           || ,
              'PARAMETERS=-S;'                                         || ,
              'TITLE=PIM Preference;'                                  || ,
              'NOPRINT=YES;'                                           || ,
              'HELPPANEL=17000;'                                       || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=YES;'                                            || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<WP_FPWPIMS_EXE>;'
call CreateObject

Location    = "<WP_FPWO_FOLD>"
Title       = "Samples"
Class       = "WPShadow"
SetupString = 'SHADOWID='newboot'\PROGRAMS\IBMWORKS\SAMPLES;'          || ,
              'TITLE=Samples;'                                         || ,
              'NOPRINT=YES;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=DEFAULT;'                                        || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<WP_FPWO_SAMP_FOLD>;'
call CreateObject

Location    = "<WP_FPWO_FOLD>"
Title       = "IBM Works"
Class       = "WPProgram"
SetupString = 'EXENAME='newboot'\PROGRAMS\IBMWORKS\IBMWORKS.EXE;'      || ,
              'PROGTYPE=PM;'                                           || ,
              'TITLE=IBM Works;'                                       || ,
              'NOPRINT=YES;'                                           || ,
              'HELPPANEL=1;'                                           || ,
              'HIDEBUTTON=DEFAULT;'                                    || ,
              'MINWIN=DEFAULT;'                                        || ,
              'CCVIEW=YES;'                                            || ,
              'DEFAULTVIEW=DEFAULT;'                                   || ,
              'OBJECTID=<WP_FPWO_EXE>;'
call CreateObject

/* Create shadow of IBMWORKS Appointments in Startup folder */
Location    = '<WP_START>'
Object      = '<WP_FPWPIMA_EXE>'
call CreateShadow

/* Copy IBMWORKS data files */
/*
copy OldBoot'\PROGRAMS\ibmworks\DATA\ /B' NewBoot'\PROGRAMS\ibmworks\DATA\'
*/

incharge:
Location    = '<WP_PROGRAMSFOLDER>'
Title       = 'In Charge'
Class       = 'XWPProgram'
SetupString = 'OBJECTID=<WP_HINCHARGESFF>;'                            || ,
              'PROGTYPE=PM;'                                           || ,
              'EXENAME=H:\INCHARGE\SFF.EXE;'                           || ,
              'STARTUPDIR=H:\INCHARGE;'                                || ,
              'ICONFILE=H:\INCHARGE\DOLLR01.ICO;'
call CreateObject


Location    = '<WP_DESKTOP>'
Title       = 'Library Reader/2'
Class       = 'WPPngFolder'
SetupString = 'OBJECTID=<EPALRFOLDER-ENU>;'                            || ,
              'ICONFILE=H:\READIBM2\EPAREAD2.ICO;'
if CreateObject() then do
   Location    = '<EPALRFOLDER-ENU>'
   Title       = 'BookManager Library Reader/2 User Guide'
   Class       = 'XWPProgram'
   SetupString = 'OBJECTID=<EPALRPUB2-ENU>;'                           || ,
                 'PROGTYPE=PM;'                                        || ,
                 'EXENAME=H:\READIBM2\EPAIBM0.EXE;'                    || ,
                 'PARAMETERS=M:\BOOKS\EPA3LM03.BOO;'                   || ,
                 'STARTUPDIR=H:\READIBM2;'                             || ,
                 'ICONFILE=H:\READIBM2\PRODMANU.ICO;'
   call CreateObject

   Location    = '<EPALRFOLDER-ENU>'
   Title       = 'Installation Utility'
   Class       = 'XWPProgram'
   SetupString = 'OBJECTID=<EPALRINSTS-ENU>;'                                                   || ,
                 'PROGTYPE=PM;'                                                                 || ,
                 'EXENAME=CMD.EXE;'                                                             || ,
                 'PARAMETERS=/C H:\readibm2\EPFINSTS.EXE /C:H:\readibm2\epal2enu.icf /O:DRIVE;' || ,
                 'STARTUPDIR=H:\READIBM2;'                                                      || ,
                 'ICONFILE=H:\READIBM2\epfiicis.ico;'
   call CreateObject

   /* READIBM2.CMD will isolate the SET statements in order to
      not mess up VIEWALL                                        */
   Location    = '<EPALRFOLDER-ENU>'
   Title       = 'Library Reader/2'
   Class       = 'XWPProgram'
   SetupString = 'OBJECTID=<EPALREXE-ENU>;'                                                     || ,
                 'PROGTYPE=PM;'                                                                 || ,
                 'EXENAME=CMD.EXE;'                                                             || ,
                 'PARAMETERS=/C H:\readibm2\EPFINSTS.EXE /C:H:\readibm2\epal2enu.icf /O:DRIVE;' || ,
                 'STARTUPDIR=H:\READIBM2;'                                                      || ,
                 'ICONRESOURCE=1,H:\READIBM2\READIBM.EXE;'
   call CreateObject
   end


Location    = '<WP_DESKTOP>'
Title       = 'MR/2 ICE Beta 10'
Class       = 'WPPngFolder'
SetupString = 'OBJECTID=<MR2_BETA_FOLDER>;'                            || ,
              'ICONRESOURCE=1,I:\COMM\MAIL\MR2ICE\MR2I.EXE;'

if CreateObject() then do
   Location    = '<MR2_BETA_FOLDER>'
   Title       = 'MR/2 ICE Beta 10'
   Class       = 'XWPProgram'
   SetupString = 'OBJECTID=<MR2_BETA_EXE>;'                            || ,
                 'PROGTYPE=PM;'                                        || ,
                 'EXENAME=I:\COMM\MAIL\MR2ICE\MR2I.EXE;'               || ,
                 'PARAMETERS=/s /sn;'                                  || ,
                 'STARTUPDIR=I:\COMM\MAIL\MR2ICE;'
   call CreateObject

   Location    = '<WP_START>'
   Object      = '<MR2_BETA_EXE>'
   call CreateShadow

   Location    = '<WP_PROMPTS>'
   Title       = 'MR/2 ICE beta window'
   Class       = 'XWPProgram'
   SetupString =  'PROGTYPE=WINDOWABLEVIO;'                            || ,
                  'EXENAME=*;'                                         || ,
                  'PARAMETERS=/K MODE 80,25 & mr2idump c;'             || ,
                  'STARTUPDIR=I:\COMM\MAIL\MR2ICE;'                    || ,
                  'ICONRESOURCE=1,I:\COMM\MAIL\MR2ICE\MR2I.EXE;'
   call CreateObject
   end

/*
NewBoot'\programs\OpenOffice.org.3\associations.cmd [boot]' NewBoot'\programs\OpenOffice.org.3'
NewBoot'\programs\OpenOffice.org.3\program\register.cmd [boot]' NewBoot'\programs\OpenOffice.org.3'
*/
Location    = '<WP_START>'
Object      = '<AOO_QUICKSTART>'
call CreateShadow


copy OldBoot'\PROGRAMS\PERL\Perl.ico'            NewBoot'\PROGRAMS\PERL\Perl.ico'
copy OldBoot'\PROGRAMS\PERL\lib\5.10.0\perl.inf' NewBoot'\PROGRAMS\PERL\lib\5.10.0\perl.inf'

Object      = '<PERLFOLDER>'
SetupString = 'ICONFILE='NewBoot'\PROGRAMS\PERL\Perl.ico;'
call SetObjectData

Location    = '<PERLFOLDER>'
Object      = NewBoot'\PROGRAMS\PERL\lib\5.10.0\perl.inf'
call CreateShadow

Location    = '<WP_PROGRAMSFOLDER>'
Title       = 'PMfax for OS/2'
Class       = 'XWPProgram'
SetupString = 'PROGTYPE=PM;'                                       || ,
              'EXENAME=I:\COMM\FAXWORKS\PMFAX.EXE;'                || ,
              'PARAMETERS=I:\comm\FaxWorks\nstall;'                || ,
              'STARTUPDIR=I:\COMM\FAXWORKS;'                       || ,
              'ASSOCFILTER=*.FAX;'                                 || ,
              'ASSOCTYPE=FxFile;'
call CreateObject

/* READIBM2.CMD will isolate the SET statements in order to
   not mess up VIEWALL                                        */
Location    = '<WP_DESKTOP>'
Title       = 'READIBM - Invoke IBM Library Reader'CRLF 'with proper environment'
Class       = 'XWPProgram'
SetupString = 'PROGTYPE=WINDOWABLEVIO;'                                || ,
              'EXENAME=H:\UTILITY\READIBM2.CMD;'                       || ,
              'STARTUPDIR=H:\READIBM2;'                                || ,
              'ICONRESOURCE=1,H:\READIBM2\READIBM.EXE;'                || ,
              'ASSOCFILTER=*.BOO;'
call CreateObject

Location    = '<WP_DIALUPTOOLS>'
Title       = 'IBM Dial-in Program (SLIPPM)'
Class       = 'XWPProgram'
SetupString = 'PROGTYPE=PM;'                                           || ,
              'EXENAME=slippm.exe;'                                    || ,
              'PARAMETERS=ppp0;'
call CreateObject

/* Not needed in eCS 2.1 or 2.2b2
Location    = '<WP_DRIVES>'
Object      = '<LVMREFRESH>'
call CreateShadow
*/

/* Shutdown settings */
Location    = '<<WP_CONFIG>'
Title       = 'Shutdown settings'
Class       = 'XWPProgram'
SetupString = ';'
call CreateObject

Location    = '<WP_START>'
Object      = 'H:\Utility\substsetup.cmd'
call CreateShadow

/* Not needed in ArcaOS
Location    = '<WP_DESKTOP>'
Title       = 'TIME868'
Class       = 'XWPProgram'
SetupString = 'PROGTYPE=PM;'                                           || ,
              'EXENAME=H:\INTERNET\TIME868\TIME868.EXE;'               || ,
              'STARTUPDIR=H:\INTERNET\TIME868;'
call CreateObject
*/

Location    = '<WP_DESKTOP>'
Title       = 'TSPF'
Class       = 'XWPProgram'
SetupString = 'PROGTYPE=WINDOWABLEVIO;'                                || ,
              'EXENAME=*;'                                             || ,
              'PARAMETERS=/c mode 132,50 & H:\TSPF12\TSPF32.EXE;'      || ,
              'STARTUPDIR=H:\TSPF12;'                                  || ,
              'ICONFILE=H:\TSPF12\TSPF32.ICO;'
call CreateObject



Location    = '<WP_DESKTOP>'
Title       = 'VIEWALL^Online books'
Class       = 'XWPProgram'
SetupString = 'PROGTYPE=PM;'                                           || ,
              'EXENAME=H:\PRODTOOL\VIEWALL\VIEWALL.EXE;'               || ,
              'STARTUPDIR=H:\PRODTOOL\VIEWALL;'
call CreateObject



/*
Object      = '<XWP_XCENTER>'
SetupString = 'REDUCEDESKTOP=YES;'                                     || ,
              'ADDWIDGETS=classname(setup),
call SetObjectData
*/


return

CreateObject:
   Say Copies('',75)
   Say 'Creating' Title 'at' location 'as' Class
   stat = SysCreateObject(Class,Title,Location,SetupString,'fail')
   if stat \= 1 then
      Say 'SysCreateObject returned ' stat
   Return stat

CreateShadow:
   Say Copies('',75)
   Say 'Creating shadow of' Object 'in' Location
   stat = SysCreateShadow(Object,Location)
   if stat \= 1 then
      Say 'SysCreateShadow returned ' stat
   Return stat

SetObjectData:
   Say Copies('',75)
   Say 'Updating WPS data of' Object 'with' SetupString
   stat = SysSetObjectData(Object,SetupString)
   if stat \= 1 then
      Say 'SysSetObjectData returned ' stat
   Return stat

/*      Dump of Folder : Desktop        */
Location = '<WP_DESKTOP>'
Title = 'Perl'
Class = 'CWFolder'
/* FldrattrContents = 300004 */
/* FldrattrDetails = 308028 */
/* FldrattrHelp = 0000 */
/* FldrattrTree = 500064 */
SetupString = 'NOPRINT=YES;'
SetupString =  SetupString || 'OBJECTID=<PERLFOLDER>;'
SetupString =  SetupString || 'HELPPANEL=154;'
SetupString =  SetupString || 'HELPLIBRARY=F:\ECS\SYSTEM\EWPS\help\xfldr001.hlp;'
SetupString =  SetupString || 'DETAILSVIEW=MINI;'
SetupString =  SetupString || 'TREEVIEW=MINI^,LINES;'
SetupString =  SetupString || 'DETAILSFONT=9.WarpSans;'
SetupString =  SetupString || 'TREEFONT=9.WarpSans;'

Call MakeObj

Location = '<WP_DESKTOP>'
Title = 'PMfax for OS/2'
Class = 'XWPProgram'
SetupString = 'NOPRINT=YES;'
SetupString =  SetupString || 'OBJECTID=<Keller Fax>;'
SetupString =  SetupString || 'HELPPANEL=4083;'
SetupString =  SetupString || 'PROGTYPE=PM;'
SetupString =  SetupString || 'EXENAME=H:\VENDORS\CDS\PMFAX.EXE;'
SetupString =  SetupString || 'STARTUPDIR=H:\VENDORS\CDS;'
SetupString =  SetupString || 'ASSOCFILTER=*.FAX;'
SetupString =  SetupString || 'ASSOCTYPE=FxFile;'

Call MakeObj

/* --- end of objects in folder --- */

        /* Creation of subfolders */

        Call Fldr1.Cmd ObjMode          /* Folder : 'Local System' */
        Call Fldr2.Cmd ObjMode          /* Folder : 'CD-Writing Utilities' */
        Call Fldr3.Cmd ObjMode          /* Folder : 'DFSee' */
        Call Fldr4.Cmd ObjMode          /* Folder : 'FileStar/2' */
        Call Fldr5.Cmd ObjMode          /* Folder : 'Galactic Civilizations 2' */
        Call Fldr6.Cmd ObjMode          /* Folder : 'Generic Installer' */
        Call Fldr7.Cmd ObjMode          /* Folder : 'GTU 4.0' */
        Call Fldr8.Cmd ObjMode          /* Folder : 'IBM Online Library' */
        Call Fldr9.Cmd ObjMode          /* Folder : 'Internet' */
        Call Fldr10.Cmd ObjMode         /* Folder : 'Local Network' */
        Call Fldr11.Cmd ObjMode         /* Folder : 'MR/2 ICE Beta 10' */
        Call Fldr12.Cmd ObjMode         /* Folder : 'Open Watcom C/C++' */
        Call Fldr13.Cmd ObjMode         /* Folder : 'Perl' */
        Call Fldr14.Cmd ObjMode         /* Folder : 'Postgres SQL Server V7.3.2' */
        Call Fldr15.Cmd ObjMode         /* Folder : 'Programs' */
        Call Fldr16.Cmd ObjMode         /* Folder : 'SciTech SNAP^Graphics/eCS' */
        Call Fldr17.Cmd ObjMode         /* Folder : 'StarOffice 5.1' */
        Call Fldr18.Cmd ObjMode         /* Folder : 'Templates' */
        Call Fldr19.Cmd ObjMode         /* Folder : 'Trash Can' */
        Call Fldr20.Cmd ObjMode         /* Folder : 'UniTools' */
        Call Fldr21.Cmd ObjMode         /* Folder : 'VyperHelp' */
        Call Fldr22.Cmd ObjMode         /* Folder : 'WPS-Wizard' */
        Call Fldr23.Cmd ObjMode         /* Folder : 'WPS2Rexx/2' */
        Call Fldr24.Cmd ObjMode         /* Folder : 'ZOC 4.15' */
return
/*      Dump of Folder : Local System   */

/* --- end of objects in folder --- */

        /* Creation of subfolders */

        Call Fldr25.Cmd ObjMode         /* Folder : 'Printers' */
        Call Fldr26.Cmd ObjMode         /* Folder : 'External System Extensions' */
        Call Fldr27.Cmd ObjMode         /* Folder : 'Startup' */
        Call Fldr28.Cmd ObjMode         /* Folder : 'Drives' */
        Call Fldr29.Cmd ObjMode         /* Folder : 'Command Prompts' */
        Call Fldr30.Cmd ObjMode         /* Folder : 'System Setup' */
        Call Fldr31.Cmd ObjMode         /* Folder : 'Help Center' */
        Call Fldr32.Cmd ObjMode         /* Folder : 'Install/Remove' */

/*      Dump of Folder : Startup        */

Location = "<WP_START>"
Title = "TCP/IP Startup"
Class = "XWPProgram"
SetupString = "NOPRINT=YES;"
SetupString =  SetupString || "OBJECTID=<TCP/IP50>;"
SetupString =  SetupString || "HELPPANEL=4083;"
SetupString =  SetupString || "PROGTYPE=WINDOWABLEVIO;"
SetupString =  SetupString || "EXENAME=TCPSTART.CMD;"

Call MakeObj

Location = "<WP_START>"
Title = "MMOS2 UPDATER"
Class = "XWPProgram"
SetupString = "NOPRINT=YES;"
SetupString =  SetupString || "OBJECTID=<MMPM2_UPDATER>;"
SetupString =  SetupString || "HELPPANEL=4083;"
SetupString =  SetupString || "PROGTYPE=PM;"
SetupString =  SetupString || "EXENAME=F:\MMOS2\MMECSUPD.EXE;"

Call MakeObj

Location = "<WP_START>"
Title = "Removable Device Monitor V1.2"
Class = "XWPProgram"
SetupString = "NOPRINT=YES;"
SetupString =  SetupString || "OBJECTID=<USB_MON>;"
SetupString =  SetupString || "HELPPANEL=4083;"
SetupString =  SetupString || "PROGTYPE=PM;"
SetupString =  SetupString || "EXENAME=F:\ECS\BOOT\USBMSDD.EXE;"
SetupString =  SetupString || "STARTUPDIR=F:\ECS\BOOT;"

Call MakeObj

Location = "<WP_START>"
Title = "CAD-Popup"
Class = "XWPProgram"
SetupString = "NOTDEFAULTICON=YES;"
SetupString =  SetupString || "NOPRINT=YES;"
SetupString =  SetupString || "OBJECTID=<CAD_POPUP>;"
SetupString =  SetupString || "HELPPANEL=4083;"
SetupString =  SetupString || "PROGTYPE=FULLSCREEN;"
SetupString =  SetupString || "EXENAME=F:\ECS\BIN\CAD_POP.EXE;"
SetupString =  SetupString || "STARTUPDIR=F:\ECS\BIN;"

Call MakeObj

Location = "<WP_START>"
Title = "eCenter"
Class = "WPShadow"
SetupString = "NOPRINT=YES;"
SetupString =  SetupString || "OBJECTID=<eCenter>;"
SetupString =  SetupString || "HELPPANEL=97;"
SetupString =  SetupString || "HELPLIBRARY=F:\ECS\SYSTEM\EWPS\help\xfldr001.hlp;"
SetupString =  SetupString || "ICONRESOURCE=44^,F:\OS2\DLL\PMWP.DLL;"
SetupString =  SetupString || "SHADOWID=<XWP_XCENTER>;"

Call MakeObj

/* --- end of objects in folder --- */

Location = "<WP_PROMPTS>"
Title = "Command Prompt (Window)"
Class = "XWPProgram"
SetupString = "NOTDEFAULTICON=YES;"
SetupString =  SetupString || "NOPRINT=YES;"
SetupString =  SetupString || "OBJECTID=<WP_OS2WIN>;"
SetupString =  SetupString || "HELPPANEL=8010;"
SetupString =  SetupString || "PROGTYPE=WINDOWABLEVIO;"
SetupString =  SetupString || "EXENAME=*;"
SetupString =  SetupString || "PARAMETERS=/k mode 80,100;"
SetupString =  SetupString || "STARTUPDIR=H:\;"

Call MakeObj

Location = "<WP_PROMPTS>"
Title = "Command Prompt (Full Screen)"
Class = "XWPProgram"
SetupString = "NOTDEFAULTICON=YES;"
SetupString =  SetupString || "NOPRINT=YES;"
SetupString =  SetupString || "OBJECTID=<WP_OS2FS>;"
SetupString =  SetupString || "HELPPANEL=8009;"
SetupString =  SetupString || "PROGTYPE=FULLSCREEN;"
SetupString =  SetupString || "EXENAME=*;"
SetupString =  SetupString || "PARAMETERS=/k cls;"

Call MakeObj

Location = "<WP_PROMPTS>"
Title = "DOS Session (Full Screen)"
Class = "XWPProgram"
SetupString = "NOTDEFAULTICON=YES;"
SetupString =  SetupString || "NOPRINT=YES;"
SetupString =  SetupString || "OBJECTID=<WP_DOSFS>;"
SetupString =  SetupString || "HELPPANEL=8011;"
SetupString =  SetupString || "PROGTYPE=VDM;"
SetupString =  SetupString || "EXENAME=*;"
SetupString =  SetupString || "PARAMETERS=%;"

Call MakeObj

Location = "<WP_PROMPTS>"
Title = "DOS Session (Window)"
Class = "XWPProgram"
SetupString = "NOTDEFAULTICON=YES;"
SetupString =  SetupString || "NOPRINT=YES;"
SetupString =  SetupString || "OBJECTID=<WP_DOSWIN>;"
SetupString =  SetupString || "HELPPANEL=8012;"
SetupString =  SetupString || "PROGTYPE=WINDOWEDVDM;"
SetupString =  SetupString || "EXENAME=*;"
SetupString =  SetupString || "PARAMETERS=%;"

Call MakeObj

Location = "<WP_PROMPTS>"
Title = "Run DOS from Floppy Drive"
Class = "XWPProgram"
SetupString = "NOTDEFAULTICON=YES;"
SetupString =  SetupString || "NOPRINT=YES;"
SetupString =  SetupString || "OBJECTID=<WP_DOS_DRV_A>;"
SetupString =  SetupString || "HELPPANEL=8529;"
SetupString =  SetupString || "PROGTYPE=VDM;"
SetupString =  SetupString || "EXENAME=*;"
SetupString =  SetupString || "SET DOS_STARTUP_DRIVE=A:;"

Call MakeObj

Location = "<WP_PROMPTS>"
Title = "Win16 Session (Full Screen)"
Class = "XWPProgram"
SetupString = "NOTDEFAULTICON=YES;"
SetupString =  SetupString || "NOPRINT=YES;"
SetupString =  SetupString || "OBJECTID=<WP_WINFS>;"
SetupString =  SetupString || "HELPPANEL=8022;"
SetupString =  SetupString || "PROGTYPE=ENH;"
SetupString =  SetupString || "EXENAME=*;"
SetupString =  SetupString || "SET KBD_ALTHOME_BYPASS=1;"
SetupString =  SetupString || "SET KBD_CTRL_BYPASS=CTRL_ESC;"
SetupString =  SetupString || "SET VIDEO_SWITCH_NOTIFICATION=1;"
SetupString =  SetupString || "SET VIDEO_8514A_XGA_IOTRAP=0;"
SetupString =  SetupString || "SET DPMI_MEMORY_LIMIT=64;"
SetupString =  SetupString || "SET WIN_DDE=0;"
SetupString =  SetupString || "SET WIN_CLIPBOARD=1;"

Call MakeObj

Location = "<WP_PROMPTS>"
Title = "Win16 Session (Window)"
Class = "XWPProgram"
SetupString = "NOTDEFAULTICON=YES;"
SetupString =  SetupString || "NOPRINT=YES;"
SetupString =  SetupString || "OBJECTID=<WP_WIN2WIN>;"
SetupString =  SetupString || "HELPPANEL=8022;"
SetupString =  SetupString || "PROGTYPE=ENHSEAMLESSCOMMON;"
SetupString =  SetupString || "EXENAME=PROGMAN.EXE;"
SetupString =  SetupString || "SET KBD_ALTHOME_BYPASS=1;"
SetupString =  SetupString || "SET KBD_CTRL_BYPASS=CTRL_ESC;"
SetupString =  SetupString || "SET VIDEO_SWITCH_NOTIFICATION=1;"
SetupString =  SetupString || "SET VIDEO_8514A_XGA_IOTRAP=0;"
SetupString =  SetupString || "SET DPMI_MEMORY_LIMIT=64;"
SetupString =  SetupString || "SET WIN_DDE=0;"
SetupString =  SetupString || "SET WIN_CLIPBOARD=1;"

Call MakeObj

/* --- end of objects in folder --- */

return
