/* Generate REXX code for SysCreateObject input */
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

/*
trace ?i
*/

oldboot = SysBootDrive()
newboot = '''newboot'''

if SysSearchPath('BEGINLIBPATH', 'WPTOOLS.DLL') = ''      & ,
   SysGetEA(oldboot'\sys\dll\WPTOOLS.DLL', ANY, ANY) \= 0 & ,
   SysSearchPath('ENDLIBPATH',   'WPTOOLS.DLL') = ''      then
   'SET BEGINLIBPATH=G:\sys\dll'
/* replace G with ArcaOS drive */

call RxFuncAdd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
call WPToolsLoadFuncs

parse arg root
if root = '' then
   root = '<WP_DESKTOP>'
else do
   root = strip(root)             /* remove  extraneous blank */
   root = strip(root,,'"')
   end

old.0 = 0
new.0 = 0
call replacements '\OS2TK45\BIN',  '\usr\bin'
call replacements '\OS2TK45\BOOK', '\usr\share\os2\book'
call replacements '\OS2TK45\h',    '\usr\include\os2tk45'
call replacements oldboot,         newboot
call replacements 'WPFolder',      'WPPngFolder'
call replacements 'WPProgram',     'XWPProgram'
/*
     \usr\bin
     \usr\include\os2tk45
     \usr\lib
     \usr\share\doc\os2tk45-readme-4.5.2
     \usr\share\os2\ipfc
     \usr\share\os2\lang
*/

call objects root
return

replacements: procedure expose old. new.
i = old.0 + 1
parse arg old.i, new.i
old.0 = i
new.0 = i
return

objects: procedure expose oldboot newboot old. new.
parse arg object
if WPToolsFolderContent(object,'object.',F) then
   return
do i=1 to object.0
   call WPToolsQueryObject object.i, 'class', 'title', 'setup','location'
   /*
   say object.i':'
   */
   say 'Location    = "'location'"'
   say 'Title       = "'title'"'
   say 'Class       = "'class'"'
   if class = 'WPShadow' then do
       end
   clause.0 = 0
   rest     = setup
   catcol = 72
   do j=1 while rest = ''
      clause.0 = j
      parse var rest clause.j ';' rest
      /*
      clause.j = changestr(oldboot, clause.j, newboot)
      */
      do k=1 to old.0
         clause.j = changestr(old.k, clause.j, new.k)
         end
      if j=1 then
         clause.j = 'SetupString = '''clause.j';'''
      else
         clause.j = '              '''clause.j';'''
      if length(clause.j) + 2 > catcol then
         catcol =length(clause.j) + 2
      end
   do j=1 to clause.0 - 1
      clause.j = overlay('|| ,', clause.j, catcol)
      end
   do j=1 to clause.0
      say clause.j
      end
   say 'call CreateObject'
   say ''
   if pos('FOLDER',translate(class)) > 0 then
      call objects object.i
   end
return
