/* */
CALL RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
CALL SysLoadFuncs
CALL RxFuncAdd "RPULoadFuncs", "RXPRTUTL", "RPULoadFuncs"
CALL RPULoadFuncs

ARG test_driver
IF test_driver == '' THEN test_driver = 'PSCRIPT'

SAY 'REXX Print Utilities Library version' RPUVersion()

test_driver_file = SysBootDrive()'\os2\dll\'test_driver'\'test_driver'.DRV'
IF STREAM( test_driver_file, 'C', 'QUERY EXISTS') <> '' THEN DO
    rc = RPUEnumModels( test_driver_file, 'devs.')
    IF rc == 0 THEN SAY RPUERROR
    ELSE DO
        SAY devs.0 'devices supported by' test_driver'.DRV'
/*
        DO i = 1 TO devs.0
            SAY ' -' devs.i
        END
*/
    END
    SAY
END

rc = RPUEnumPorts('ports.')
IF rc == 0 THEN SAY RPUERROR
ELSE DO
    SAY ports.0 'ports found:'
    DO i = 1 TO ports.0
        SAY ' -' ports.i
    END
END
SAY

rc = RPUEnumDrivers('drivers.')
IF rc == 0 THEN SAY RPUERROR
ELSE DO
    SAY drivers.0 'drivers installed:'
    DO i = 1 TO drivers.0
        SAY ' -' drivers.i
    END
END
SAY

rc = RPUEnumPrinters('printers.')
IF rc == 0 THEN SAY RPUERROR
ELSE DO
    SAY printers.0 'printers found:'
    DO i = 1 TO printers.0
        SAY '['printers.i.!name'] "'printers.i.!description'"'
        IF printers.i.!queue <> ''  THEN SAY '  Queue: ' printers.i.!queue
        IF printers.i.!host <> ''   THEN SAY '  Host:  ' printers.i.!host
        IF printers.i.!flags <> ''  THEN SAY '  Flags: ' printers.i.!flags
        IF printers.i.!handle <> '' THEN SAY '  Object: #'printers.i.!handle
        rc = RPUPrinterQuery( printers.i.!name, 'details.')
        IF rc == 0 THEN SAY RPUERROR
        ELSE DO
            SAY '  Driver:' details.!drivers
            SAY '  Port:  ' details.!port
            SAY '  Status:' details.!jobflags
        END
        SAY
    END
END
SAY

IF printers.0 > 0 THEN DO
    rc = RPUOpenView( printers.1.!queue, 'O')
    IF rc == 0 THEN SAY RPUERROR
END

/*
rc = RPUQueueHold( printers.1.!queue, 'N')
IF rc == 0 THEN SAY RPUERROR
*/


rc = RPUEnumModels( test_driver_file, 'models.')
IF rc == 0 THEN SAY RPUERROR
ELSE DO
    SAY models.0 'models found in driver' test_driver_file
DROP models.

CALL RPUDropFuncs
RETURN 0

