#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

static int bail (const char *msg)
{
    fprintf (stderr, "CHILD ERROR: %s: %s (%d)\n", msg, strerror(errno), errno);
    return errno;
}

int main(int argc, const char **argv)
{
    int rc;

    int fd = 0;
    if (argc > 1)
        fd = atoi(argv[1]);
    if (fd <= 0)
        fd = fileno(stdout);

    char buf[10];
    for (int i = 0; i < 256; ++ i)
    {
        if (i % 16 == 15)
            sprintf(buf, "%d\n", i);
        else
            sprintf(buf, "%d ", i);
        rc = write(fd, buf, strlen(buf));
        if (rc == -1)
            bail("write");
    }

    rc = write(fd, "***\n", 4);
    if (rc == -1)
        bail("write");

    return 123456;
}

