/*
 *
 * Demostrates failure when piping a large ( +100KB ) file to a child process
 *
 */


#include <QDebug>
#include <QFile>
#include <QProcess>


int main( int argc, char *argv[] )
{
    if( argc > 1 )
    {
        QProcess p;
        QFile f( argv[1] );

        if( f.open( QIODevice::ReadOnly ) )
        {
            p.start( "../child",
                     QStringList() << "0" << "output.fil",
                     QIODevice::WriteOnly );

            if( p.waitForStarted() )
            {
                while( !f.atEnd() )
                {
                  QByteArray ba = f.read( 2048 );

                  p.write( ba );

                  p.waitForBytesWritten( -1 );
                }

                p.close();
                p.waitForFinished();
            }
            else
                qDebug() << "waitForStarted() failed !";

            f.close();
        }
        else
            qDebug() << "Can't open input file";
    }
    else
        qDebug() << "Usage: testcase <filename>";

    return 0;
}


