#include <QFile>
#include <QDebug>
#include <QProcess>
#include <QXmlStreamReader>


#include "FileCrypter.h"



int main( int argc, char *argv[] )
{
    FileCrypter c;
    QString     tool;
    QStringList archDir;
//    QString   archName("test.7z");
    QString     archName("all.7z");

    if (c.getToolVersion(tool))
    {
        qDebug() << tool;

        c.setPassword("MyPassword");

        if (c.listFiles( archName, QStringList() << "ui" << "xml", archDir) )
        {
            qDebug() << archDir;

            foreach (const QString &fileName, archDir)
            {
                QProcess        worker;

                if( c.open( archName, fileName, true, false, worker ) )
                {
                   QXmlStreamReader     r(&worker);
                   int                  tokenCount = 0;

                   while (!r.atEnd())
                   {
                      if( !worker.bytesAvailable() )
                          worker.waitForReadyRead(-1);

                      r.readNext();

                      tokenCount++;
                   }

                   qDebug() << "File:" << fileName << tokenCount;

                   c.close(worker);
                }
            }
        }
    }

    return 0;
}



