/*  
    create_psi_packages.cmd:

    This script will create the PSI packages for distribution.
    *.wpi
    *.exe
    *.zip

    (c) 2006 - Juergen Ulbts
*/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

CURRENT_DIR = DIRECTORY()

/* ========================================================= */
/*  Application specific information - NEEDS MODIFICATION    */
/* ========================================================= */
ARCHIVE_NAME='PSI_0-10-0a1_os2_2006-07-25'   /* Target archive name without extension */
WARPIN_SCRIPT_NAME='psi_0-10-0a1.wis'        /* WarpIN *.wis script name  */
BINARY_DIRECTORY='psi_0-10-0a1'              /* Subdirectory of version where the build application can be found */


/* ========================================================= */
/*  Set the package creation application and settings        */
/* ========================================================= */
WARPIN_CREATOR='wic.exe'                     /* WarpIN application the create WarpIN achives */
ARCHIVE_CREATOR='zip.exe'                    /* Packer */
ARCHIVE_CREATOR_PARAMETER='-9rS'             /* Packer parameters */       

 
/* ========================================================= */
/*  Delete old package with the same name as 'ARCHIVE_NAME'  */
/* ========================================================= */
'del .\Build_Packages\'||ARCHIVE_NAME||'.* > NUL'

/* ========================================================= */
/*  Create WarpIN packages                                   */
/* ========================================================= */
''||WARPIN_CREATOR||' .\Build_Packages\'||ARCHIVE_NAME||'.wpi -a 1 -c.\Version\'||BINARY_DIRECTORY||' -r * -s ".\Scripts\'||WARPIN_SCRIPT_NAME||'" > .\Build_Packages\'||ARCHIVE_NAME||'.wpi_log'
''||WARPIN_CREATOR||' .\Build_Packages\'||ARCHIVE_NAME||'.exe -a 1 -c.\Version\'||BINARY_DIRECTORY||' -U -r * -s ".\Scripts\'||WARPIN_SCRIPT_NAME||'" > .\Build_Packages\'||ARCHIVE_NAME||'.exe_log'

/* ========================================================= */
/*  Create ZIP archive                                       */
/* ========================================================= */
'cd Version'
''||ARCHIVE_CREATOR||' '||ARCHIVE_CREATOR_PARAMETER||' ..\Build_Packages\'||ARCHIVE_NAME||'.zip .\'||BINARY_DIRECTORY
CALL DIRECTORY CURRENT_DIR

exit;
