/**
 *  This program illustrates the bug of the GpiBox() API call:
 *  GpiBox() draws the rectangle 1 pixel taller when
 *  rounded corners and (DRO_FILL or DRO_OUTLINEFILL) are specified.
 *
 *  The bug is definitely present on:
 *      Aurora + XR_E002 and GeForce2 MX + SNAP 2.0.0
 *      Aurora + XR_E002 and GeForce4 Ti + SNAP 2.2.0
 *
 *  dmik@go.ru
 *  13-Apr-2003
 */

#define INCL_BASE
#define INCL_PM
#include <os2.h>

#define WNDCLASS "GpiBoxBug"
#define WNDTITLE "GpiBox Bug"

/**
 *
 */
void DrawBox (HPS hps, int x, int y, int width, int height, int rndx, int rndy, int style)
{
    POINTL pnt;
    pnt.x = x, pnt.y = y;
    GpiMove (hps, &pnt);
    pnt.x += width; pnt.y += height;
    GpiBox (hps, style, &pnt, rndx, rndy);
}

/**
 *
 */
MRESULT WMPaint (HWND hwnd, HPS ahps)
{
    HPS hps;

    hps = WinBeginPaint (hwnd, ahps, NULL);

    DrawBox (hps, 10, 10, 49, 49, 0, 0, DRO_OUTLINE);
    DrawBox (hps, 31, 10, 49, 49, 0, 0, DRO_FILL);
    DrawBox (hps, 52, 10, 49, 49, 0, 0, DRO_OUTLINEFILL);

    DrawBox (hps, 10, 70, 49, 49, 0, 0, DRO_OUTLINE);
    DrawBox (hps, 10, 91, 49, 49, 0, 0, DRO_FILL);
    DrawBox (hps, 10, 112, 49, 49, 0, 0, DRO_OUTLINEFILL);

    DrawBox (hps, 110, 10, 49, 49, 10, 10, DRO_OUTLINE);
    DrawBox (hps, 131, 10, 49, 49, 10, 10, DRO_FILL);
    DrawBox (hps, 152, 10, 49, 49, 10, 10, DRO_OUTLINEFILL);

    DrawBox (hps, 110, 70, 49, 49, 10, 10, DRO_OUTLINE);
    DrawBox (hps, 110, 91, 49, 49, 10, 10, DRO_FILL);
    DrawBox (hps, 110, 112, 49, 49, 10, 10, DRO_OUTLINEFILL);

    WinEndPaint (hps);

    return 0;
}

/**
 *
 */
MRESULT EXPENTRY WindowProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    static HPS hps = 0;

    switch (msg) {

        case WM_CREATE:
            hps = WinGetPS (hwnd);
            GpiSetColor (hps, CLR_RED);
            GpiSetBackColor (hps, CLR_BLACK);
            GpiSetBackMix (hps, BM_OVERPAINT);
            GpiSetPattern (hps, PATSYM_BLANK);
            return (MRESULT)FALSE;

        case WM_ERASEBACKGROUND:
            WinFillRect ((HPS)mp1, (PRECTL)mp2, SYSCLR_DIALOGBACKGROUND);
            return FALSE;

        case WM_CALCVALIDRECTS:
            return (MPARAM)(CVR_ALIGNLEFT | CVR_ALIGNBOTTOM);

        case WM_PAINT:
            return WMPaint (hwnd, hps);

        case WM_DESTROY:
            WinReleasePS (hps);
            return 0;
    }

    return WinDefWindowProc (hwnd, msg, mp1, mp2);
}

/**
 *  ENTRY POINT
 */
void main()
{
    HAB     hab;
    HMQ     hmq;
    QMSG    qmsg;
    HWND    hwnd, hwndC;
    ULONG   fcflags;

    hab = WinInitialize (0);
    hmq = WinCreateMsgQueue (hab, 0 );

    if (hmq) {
        WinRegisterClass (hab, WNDCLASS, (PFNWP)WindowProc, 0 /*CS_SIZEREDRAW*/, 0 );

        fcflags = FCF_TITLEBAR | FCF_SIZEBORDER | FCF_SYSMENU | FCF_MINBUTTON | FCF_MAXBUTTON;
        hwnd = WinCreateStdWindow (
            HWND_DESKTOP,
            FS_TASKLIST | FS_SHELLPOSITION,
            &fcflags,
            WNDCLASS,
            WNDTITLE,
            0,
            0,
            0,
            &hwndC
        );

        if (hwnd && hwndC) {
            WinSetWindowPos (hwnd, HWND_TOP, 0, 0, 250, 250,
                SWP_ACTIVATE | SWP_ZORDER | SWP_SHOW | SWP_SIZE);
            while (WinGetMsg (hab, &qmsg, 0, 0, 0))
                WinDispatchMsg (hab, &qmsg);
            WinDestroyWindow (hwnd);
        }
        WinDestroyMsgQueue (hmq);
    }

    WinTerminate (hab);
}

