#include <qapplication.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpaintdevice.h>

#define PRINT_PM_INFO(pm) \
    qDebug (#pm ": hasAlpha=%d hasAlphaChannel=%d mask=%p", \
            pm.hasAlpha(), pm.hasAlphaChannel(), pm.mask());

class MyWidget : public QWidget
{
    Q_OBJECT

public:

MyWidget()
{
    setPaletteBackgroundPixmap (QPixmap ("marble.png"));
    
    resize (800, 400);
}

~MyWidget()
{
}

void blitTest (QPainter &p, const QPixmap &pm1, const QPixmap &pm2,
               int x, int y, RasterOp rop)
{
    // bitBlt pm2 to pm1
    QPixmap temp = pm1;
    bitBlt (&temp, 0, 0, &pm2, 0, 0, -1, -1, rop);
    p.drawPixmap (x, y, temp);

    // bitBlt pm1 to pm2
    temp = pm2;
    bitBlt (&temp, 0, 0, &pm1, 0, 0, -1, -1, rop);
    p.drawPixmap (x + 50, y, temp);
    
    // do the same as above, but using QImage for mixing
    QImage i1 = pm1.convertToImage();
    QImage i2 = pm2.convertToImage();
    bitBlt (&i1, 0, 0, &i2, 0, 0);
    p.drawImage (x + 120, y, i1);
    i1 = pm1.convertToImage();
    bitBlt (&i2, 0, 0, &i1, 0, 0);
    p.drawImage (x + 170, y, i2);
}

void copyTest (QPainter &p, const QPixmap &pm1, const QPixmap &pm2, int x, int y)
{
    // copyBlt pm2 to pm1

    QPixmap temp = pm1;
    copyBlt (&temp, 0, 0, &pm2, 0, 0);
    p.drawPixmap (x, y, temp);
    
    // copyBlt pm1 to pm2
    temp = pm2;
    copyBlt (&temp, 0, 0, &pm1, 0, 0);
    p.drawPixmap (x + 50, y, temp);
    
    // copyBlt part of pm2 to pm1
    temp = pm1;
    copyBlt (&temp, 8, 8, &pm2, 8, 8, 32, 32);
    p.drawPixmap (x + 120, y, temp);
    
    // copyBlt part of pm1 to pm2
    temp = pm2;
    copyBlt (&temp, 8, 8, &pm1, 8, 8, 32, 32);
    p.drawPixmap (x + 170, y, temp);
}

void paintEvent (QPaintEvent *ev)
{
    Q_UNUSED( ev );
    
    QPainter painter (this);

    QPixmap normal = QPixmap ("normal.png");
    QPixmap masked = QPixmap ("masked.xpm");
    QPixmap masked2 = QPixmap ("masked2.xpm");
    QPixmap alpha = QPixmap ("alpha.png");

    PRINT_PM_INFO (normal);
    PRINT_PM_INFO (masked);
    PRINT_PM_INFO (masked2);
    PRINT_PM_INFO (alpha);
    
    // simple blits
    painter.drawPixmap (10, 10, normal);
    painter.drawPixmap (26, 26, masked);
    painter.drawPixmap (42, 10, masked2);
    painter.drawPixmap (10, 10, alpha);

    QPixmap temp1, temp2;

    // alpha to pixmap at some offset 
    temp1 = QPixmap (64, 64);
    temp1.fill (white);
    bitBlt (&temp1, -8, -8, &alpha, 0, 0);
    painter.drawPixmap (510, 10, temp1);
    
    // scale all to alpha size
    normal = QPixmap (normal.convertToImage().scale (48, 48));
    masked = QPixmap (masked.convertToImage().scale (48, 48));
    masked2 = QPixmap (masked2.convertToImage().scale (48, 48));
    // create alpha2
    QPixmap alpha2 = QPixmap (masked.convertToImage().smoothScale (8, 8));
    alpha2 = QPixmap (alpha2.convertToImage().smoothScale (48, 48));

    PRINT_PM_INFO (normal);
    PRINT_PM_INFO (masked);
    PRINT_PM_INFO (masked2);
    PRINT_PM_INFO (alpha);
    PRINT_PM_INFO (alpha2);
    
    int y = 10 + 50;
    
    // simple blits again after scaling
    painter.drawPixmap (10, y, normal);
    painter.drawPixmap (60, y, masked);
    painter.drawPixmap (110, y, masked2);
    painter.drawPixmap (160, y, alpha);
    painter.drawPixmap (210, y, alpha2);

    y += 70;
    
    blitTest (painter, masked, masked2, 10, y, CopyROP);
    blitTest (painter, masked, masked2, 260, y, XorROP);
    copyTest (painter, masked, masked2, 510, y);

    y += 50;
    
    blitTest (painter, masked, normal, 10, y, CopyROP);
    blitTest (painter, masked, normal, 260, y, XorROP);
    copyTest (painter, masked, normal, 510, y);
    
    y += 50;
    
    blitTest (painter, alpha, alpha2, 10, y, CopyROP);
    blitTest (painter, alpha, alpha2, 260, y, XorROP);
    copyTest (painter, alpha, alpha2, 510, y);

    y += 50;
    
    blitTest (painter, alpha, normal, 10, y, CopyROP);
    blitTest (painter, alpha, normal, 260, y, XorROP);
    copyTest (painter, alpha, normal, 510, y);

    y += 50;
    
    blitTest (painter, alpha, masked, 10, y, CopyROP);
    blitTest (painter, alpha, masked, 260, y, XorROP);
    copyTest (painter, alpha, masked, 510, y);

    // some masked pixmap tests, not relevant to alpha, left here just in case 
//
//    QPixmap masked = QPixmap ("masked.xpm");
//    QPixmap pm (16, 16);
//    
//    bitBlt (this, 10, 10, &masked, 0, 0, -1, -1, CopyROP);
//    bitBlt (this, 30, 10, &masked, 0, 0, -1, -1, XorROP);
//    bitBlt (this, 50, 10, &masked, 0, 0, -1, -1, AndROP);
//    bitBlt (this, 70, 10, &masked, 0, 0, -1, -1, OrROP);
//    
//    pm.fill (white);
//    pm.fill (this, 10, 10);
//    bitBlt (&pm, 0, 0, &masked, 0, 0, -1, -1, CopyROP);
//    bitBlt (this, 10, 10, &pm, 0, 0, -1, -1, CopyROP);
//    pm.fill (white);
//    pm.fill (this, 30, 10);
//    bitBlt (&pm, 0, 0, &masked, 0, 0, -1, -1, XorROP);
//    bitBlt (this, 30, 10, &pm, 0, 0, -1, -1, CopyROP);
//    pm.fill (white);
//    pm.fill (this, 50, 10);
//    bitBlt (&pm, 0, 0, &masked, 0, 0, -1, -1, AndROP);
//    bitBlt (this, 50, 10, &pm, 0, 0, -1, -1, CopyROP);
//    pm.fill (white);
//    pm.fill (this, 70, 10);
//    bitBlt (&pm, 0, 0, &masked, 0, 0, -1, -1, OrROP);
//    bitBlt (this, 70, 10, &pm, 0, 0, -1, -1, CopyROP);
}

public slots:
    
private:

};

////////////////////////////////////////////////////////////////////////////////

int main (int argc, char **argv)
{
    QApplication a (argc, argv);

    MyWidget myWidget;
    a.setMainWidget (&myWidget);
    myWidget.show();
    return a.exec();
}

#include "alpha.moc"

