#
# Simple performance test for POSIX-compliant shells
#
# Usage: time env -i <shell> shell-perf.sh [<num subshells>]
#
# Written by Mathias Lafeldt <mathias.lafeldt@gmail.com>

# for linux OS 
#shell="$(ps -o pid,command | awk "\$1 == $$ { print \$2 }")"

# for OS/2
xpid=$(printf %X $$)
shell="$(pstat /p:$xpid | grep ^$xpid | awk "{ print \$4 }")"

forks=${1:-1000}
 
echo -n "Forking $forks $shell subshells"
 
for i in $(seq 1 $forks); do
    "$shell" -c 'echo -n .; j=1; while [ $j -le 1000 ]; do j=$(($j+1)); done'
done
 
echo ""
