/* Concatenate pieces of split zip file */
/*
trace ?i
*/

parse upper arg zipfile workdir opts
if right(zipfile,4) = '.ZIP' then
   zipfile = delstr(zipfile, length(zipfile)-3, 4)
if right(workdir,1) = '\' then
   workdir = workdir'\'

Call rxfuncadd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs'

if SysFileTree(zipfile'.Z??', found., FO) = 2 then do
   say 'Not enough memory for SysFileTree'
   exit 2
   end

lastfile = ''
splitfile = .array~new
do i=1 to found.0
   file = found.i
   ext=translate(right(file,4))
   if abbrev(ext,'.Z') then
      iterate
   if ext = '.ZIP' then do
      lastfile = file
      l = lastpos('\',file)
      select
         when l>0 then
            catfile = substr(zipfile,l+1)
         when substr(zipfile,2,2) = ':' then
            catfile = delstr(zipfile,1,2)
         otherwise
            catfile = zipfile
         end
      iterate
      end
   j = right(ext,2)
   if verify(j,'1234567890') = 0 then do
      if j = 0 then
         iterate
      splitfile[j] = found.i
      end
   end
if lastfile = '' then do
   say zipfile'.ZIP' missing
   exit 4
   end

copy = 'COPY'
do i=1 to splitfile~size
   if splitfile~hasindex(i) then
      copy = copy splitfile[i] '/B +'
   else
      say 'Split Z'right(i,2,'0') 'missing'
   end

time = time(R)
copy lastfile '/B' workdir||catfile'.zip'
time=trunc(time(E))
say 'Concatenation of' workdir||catfile'.z?? took' time(N,time,S)
unzip '-t -v' workdir||catfile'.zip >' workdir||catfile'.tlog 2>&1'
