/* REXX */
echo on
/*
trace ?i
*/

Call rxfuncadd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs'

parse upper arg adrive opts
adrive = backupdrive(adrive)
Jdrive = backupdrive(J)
Kdrive = backupdrive(K)
select
   when adrive = '' then
      drive = adrive
   when Jdrive = '' then
      drive = Jdrive
   when Kdrive = '' then
      drive = Kdrive
   otherwise do
      say 'No backup USB data key found'
      exit 2
      end
   end


diropt   = ''
redirect = ''
v        = 'q'
do while opts = ''
   parse var opts opt opts
   select
      when abbrev(DIRECTORY,translate(opt)) then
         diropt = Y
      when abbrev(LOG,translate(opt)) then
         /* log only, no display */
         redirect = '>'
      when abbrev(TEE,translate(opt)) then
         /* log and display */
         redirect = '|tee'
      when abbrev(VERBOSE,translate(opt)) then do
         v = 'v'
         end
      otherwise do
         say 'Invalid log option' opt
         exit 2
         end
      end
   end

'DEL W:\Z*'
'DEL' drive'\?.DIR'
'DEL' drive'\?.LOG'
'DEL' drive'\?.ZIP'
'ZIP -v >' drive'\zipver'

zipopt = '-9rSu'v '-b W:\ --display-counts'
noEA   = '-x "?? ????. sf"'
noswap = '-x "*\SWAPPER.DAT"'

prompt '[$p]$s$t$s'
call dozip C, drive, noEA,   redirect
call dozip D, drive, noEA,   redirect
call dozip E, drive, noswap, redirect
call dozip F, drive, noswap, redirect
call dozip G, drive, noswap, redirect
call dozip H, drive, ,       redirect
call dozip I, drive, ,       redirect
call dozip M, drive, ,       redirect
call dozip P, drive, noea,   redirect
call dozip Q, drive, noswap, redirect
call dozip U, drive, ,       redirect
call dozip W, drive, noswap, redirect
dir drive
exit

dozip: procedure expose zipopt diropt
parse arg indrive, archdrive, optt, redirect
if diropt = Y then
   DIR indrive':\ /f /s >'archdrive'\'indrive'.dir'
if redirect = '' then
   redirect = redirect archdrive'\'indrive'.log 2>&1'
zip zipopt archdrive'\'indrive'.zip' indrive':\' optt redirect
say 'zip of' indrive 'completed with rc='rc
return rc

backupdrive: procedure
parse upper arg drive
select
   when drive = '' then
      return ''
   when length(drive) = 1 then
      drive = drive':'
   when length(drive) > 2 then
      return ''
   otherwise
      nop
   end

parse value SysDriveInfo(drive) with . . . label
if abbrev(translate(label),'BACKUP') then
   return ''
if SysFileSystemType(drive) = JFS then
   return drive
return ''
