#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# (c) Copyright 2003-2015 HP Development Company, L.P.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# Author: Don Welch
#
# NOTE: This module is safe for 'from g import *'
#

# Std Lib
import sys
import os
import os.path
import locale
import pwd
import stat
import re


if os.name == 'os2':
  try:
    username = pwd.getpwuid(os.getuid())[0]
    pdb = pwd.getpwnam(username)
    userhome = pdb[5]
    if userhome == '/nonexistent':
      userhome = os.getenv("HOME")
  except:
    username = os.getenv("USER")
    userhome = os.getenv("HOME")
else:
  username = pwd.getpwuid(os.getuid())[0]
  pdb = pwd.getpwnam(username)
  userhome = pdb[5]

print("username %s, userhome %s %s") % (username, userhome, os.name)