/*
 * interlocked functions
 *
 * Copyright 1996 Alexandre Julliard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "windef.h"
extern __int64 interlocked_cmpxchg64( __int64 *dest, __int64 xchg, __int64 compare );

__int64 interlocked_cmpxchg64( __int64 *dest, __int64 xchg, __int64 compare) {
 __asm(
                   "push %ebx\n\t"
                   "push %esi\n\t"
                   "movl 12(%esp),%esi\n\t"
                   "movl 16(%esp),%ebx\n\t"
                   "movl 20(%esp),%ecx\n\t"
                   "movl 24(%esp),%eax\n\t"
                   "movl 28(%esp),%edx\n\t"
                   "lock; cmpxchg8b (%esi)\n\t"
                   "pop %esi\n\t"
                   "pop %ebx\n\t"
                   "ret");
}
