:userdoc.
:docprof toc=123456.
:title.NewView Help
.nameit symbol=prod text='NewView'
.nameit symbol=os2 text='OS/2'
.nameit symbol=ecs text='eComStation'
.nameit symbol=aos text='ArcaOS'
.* ************************************************************
.* Subject: Help for NewView
.* Version: 2020070501
.* Copyright: Copyright 2004-2005 Aaron Lawrence
.* Copyright: Copyright 2006-2019 Ronald Brill
.* Copyright: Copyright 2019-2020 Alexander Taylor
.* Copyright: Copyright 2020 Lewis Rosenthal
.* Author: Aaron Lawrence
.* Author: Ronald Brill
.* Author: Lewis Rosenthal
.* ************************************************************
.*
.*
.* ----------------------------------------------------------------------------
:h1 res=30000 id='Introduction'.Introduction
:i1 id=30001.support
:p.:artwork runin name='images\NewView.bmp'.
:hp2.Welcome to NewView!:ehp2.
:p.
:p.NewView is a program for reading OS/2, &ecs., and &aos. Help
Files.
:p.:link reftype=hd refid='Support'.Support and Licensing:elink.
:p.:link reftype=hd refid='Using'.Using NewView:elink.
:p.:hp1.To stop this file appearing when you start NewView without specifying a
help file, see Tools - Options - General tab.:ehp1.
:p.:hp2.History:ehp2.
:p.NewView replaces the original IBM program supplied with OS/2.
:p.It improves upon many aspects of View, with a modern, easy to use
interface, more options, and new features that View simply
didn't have.

.* ----------------------------------------------------------------------------
:h2 res=1 id='Support'.Support and Licensing
:i1 id=30002.license
:i2 refid=30001.Support and Licensing
:i2 refid=30001.Introduction
:i1 id=30003.bugs
:i1 id=30004.source code
:p.NewView is Copyright 1999-2006 Aaron Lawrence. It is also licensed
under the GNU Public License, which means you have the right to obtain the
source code.
:p.Ronald Brill has been the project maintainer since 2006, and additional
improvements have been added by Alexander Taylor.
.br
NewView is a Netlabs project.
:p.See the Readme.txt for more technical details.
:p.See the Changes.txt file for a history of changes to NewView.
:p.If you find NewView helpful, please let us know and/or make a
donation to support further development. It's nice to hear from you!
:ul.
:li.Suggestions, compliments or bug reports https&colon.//trac.netlabs.org/newview
:li.Translate NewView to your language.
:li.A donation to Netlabs https&colon.//www.arcanoae.com/shop/netlabs/
:eul.
:p.:hp2.Reporting Bugs:ehp2.
:p.If you need to report a crash or other problem, then be as specific as
possible about what files were being used, what you were doing,
etc. If one is available, PLEASE include the newview.log. The
log file will be EITHER
.br
 - in the same directory as NewView itself
.br
 - in the folder set by LOGFILES environment variable (typically eCS
1.1&plus. and &aos.)
.br
If it is specific to a particular help file, then please attach that
file to your ticket, unless it is too large.
:p.Most of the following information is in the newview.log file, but
it would be helpful if you could include it for verification&colon.
:ul.
:li.NewView version (Help - Product Information)
:li.The filenames of the help files.
:li.A screenshot may be useful, if the problem is an incorrect or corrupt
display.
:eul.
:p.:hp2.Why doesn't my help file work properly?:ehp2.
:p.Some of the less used features of the original View program are not
implemented. This is either because I have not got around to it, or
because they are simply not worth the time. Examples include
metafiles, index synonyms, the entire application control API,
and so on.
:p.Unfortunately, it seems that at least one developer has used every one
of these features, so you may find an occasional file that doesn't
load or doesn't work properly.

.* ----------------------------------------------------------------------------
:h1 res=2 id='Using'.Using NewView
:p.Once you have :link reftype=hd refid='OpeningFiles'.opened a
file:elink., you can read it in various ways.
:p.You can read the :link reftype=hd refid='contents'.table of
contents:elink., use the :link reftype=hd refid='Index'.alphabetical
index:elink., or :link reftype=hd refid='search'.search:elink.&per.
:p.To simply read the help file like a paper book, use the &odq.Previous&cdq.
:artwork runin name='images\previous.bmp'.
 and &odq.Next&cdq.
:artwork runin name='images\next.bmp'.
 buttons to work your way through all the topics.
:p.You can also use the help file like web pages, using &odq.Back&cdq.
:artwork runin name='images\back.bmp'.
 and &odq.Forward&cdq.
:artwork runin name='images\forward.bmp'.
 buttons to go back to wherever you were before, or to retread your
steps.
:p.Colors and some of the behavior of NewView can be adjusted from the Tools
- Options menu.
:p.You can also :link reftype=hd refid='notes'.annotate:elink. or :link
reftype=hd refid='bookmarks'.bookmark:elink. topics.

.* ----------------------------------------------------------------------------
:h1 res=3 id='OpeningFiles'.Opening Files
:i1 id=30005.open
:p.To open a help file, you can use any of the following&colon.
:p.- Double-click a :link reftype=hd refid='HelpIcons'.help
icon:elink. that is already set up
:p.- Type &odq.view :hp1.filename:ehp1.&cdq. from the :link reftype=hd
refid='CommandLine'.command line:elink.
:p.- Click the Open button
:artwork runin name='images\open.bmp'.
 from within NewView
:p.- Reload a recently viewed file from the &odq.File&cdq. menu
:p.- Drag and drop a Help file from the desktop
:p.Once the file is loaded, you should see the :link reftype=hd
refid='contents'.table of contents:elink. and the first topic.
:note.This assumes you installed NewView as a replacement
for original View. If you didn't then existing help icons and the
command line may behave differently.
:p.:hp2.Loading Multiple Files Together:ehp2.
:p.NewView can load multiple files at once, presenting them as if they
were one book, and read environment variables for filenames.
:p.For example, with the OS/2 Developer's Toolkit
documentation&colon.
.br
  NewView cpref
.br
loads the &odq.Control Program Guide and Reference&cdq.&per. CPREF is an environment
variable set in config.sys, consisting of &odq.CP1&plus.CP2&plus.CP3&cdq.
which tells NewView (or View) to load the help files CP1, CP2
and CP3. The files are searched for in the path specified by two :link
reftype=hd refid='L_EnvironmentVariables'.environment
variables:elink.&per.&asterisk.
:p.The files are all loaded and effectively appended to each other.
:p.Being able to load multiple files like this can be helpful for various
reasons. For example, 4OS/2 (a CMD.EXE
replacement) uses it to add it's own help on top of the original CMD
help. You can do it yourself with any files you like.
:p.You can load multiple files in the Open File dialog by using Ctrl or Shift to
select multiple files.
:p.When you click a link to a different help file, NewView loads the other
file without closing your current files.
:p.At any time, you can find out what files are open by using File
- Information.
:p.:hp2.Loading Additional Files:ehp2.
:p.You can tick the &odq.Keep current files open&cdq. checkbox in the Open File
dialog, and NewView will open the files you have selected without closing
the currently opened files.
:p.:hp2.Drag and Drop:ehp2.
:p.You can drag and drop .INF or .HLP files onto NewView and they will
be opened. If you hold down the Shift key, they will be opened without
closing the current files.
:p.You can drop files onto any of the main content areas, such as the
Contents or Index windows, or an existing topic window.
:note.Some links that go across files, will only work if the correct set of
files is loaded.

.* ----------------------------------------------------------------------------
:h2 res=17 id='HelpIcons'.Help Icons
:p.Help Icons on the desktop are usually &odq.program objects&cdq. with the program name
set to &odq.view.exe&cdq. and the parameters set to the name of the help files.
:p.Some programs create these icons automatically at install time.
:p.You can create these icons yourself by using the desktop program
template. See desktop help for more information.
:p.If you create icons by dragging help files to the desktop, then you
cannot give them a meaningful title, because that would change the name of
the file, which might prevent programs from finding the help file.
Therefore program objects are currently the recommended means of creating help
icons.

.* ----------------------------------------------------------------------------
:h1 res=200 id='NavigationPanel'.Navigation Panel Tabs
:p.The left hand panel contains several tabs for moving through the current help
file in different ways&colon.
:p.

:artwork runin name='images\tabs.bmp'.

:p.:ul compact.
:li.:link reftype=hd refid='contents'.Contents:elink.
:li.:link reftype=hd refid='index'.Index:elink.
:li.:link reftype=hd refid='search'.Search:elink.
:li.:link reftype=hd refid='notes'.Notes:elink.
:eul.

:p.You can turn this panel off to get more space, with the button
:artwork runin name='images\navigator.bmp'. or by selecting View
- Show Left Panel from the menu, or pressing Alt&plus.P. Do the
same to turn it on again.
:p.You can stop the navigation panel from appearing when a help file is opened
in Tools - Options - General tab.
:note.Many programs choose to show the table of contents when they open their
help files; in this case, the panel is automatically shown, overriding your
setting.

.* ----------------------------------------------------------------------------
:h2 res=4 id='contents'.Contents
:i1 id=30006.Table of Contents
:p.Most help files have a table of contents that shows you the topics in the
file, in a hierarchy or &odq.tree&cdq.&per. This is usually the first view you see
when you open a file.
:p.You can expand or collapse branches on the tree by clicking the &plus. or
- buttons, or using the space bar.
:p.To view a topic from the contents, just click on it. You can also
move through the contents by using the arrow keys.
:p.To move through :hp2.all:ehp2. topics in the contents tree, in
order, you can use Ctrl &plus. Up and Ctrl &plus. Down, or the
&odq.Previous&cdq.
:artwork runin name='images\previous.bmp'.
 and &odq.Next&cdq.
:artwork runin name='images\next.bmp'.
 buttons. This is one way to treat the file as a normal book, reading
through each page.
:p.You can also review the whole table of contents by using &odq.Expand All&cdq. in the
&odq.View&cdq. menu. This expands all the branches of the contents table so you can
quickly look through it. However, it's usually easier to use
:link reftype=hd refid='search'.Search:elink. or :link reftype=hd
refid='Index'.Index:elink. for this purpose.

.* ----------------------------------------------------------------------------
:h2 res=5 id='index'.Index
:p.The Index tab contains an alphabetical listing of topics or keywords in the
help file. You can quickly search through it just by typing the first few
characters of the word you want to look up. NewView jumps to the first match
in the index automatically. To view the highlighted topic, press
enter.
:nt.Help files may or may not include an &odq.official&cdq. index. The index is
manually created by the author, so (for original View) it's
usefulness is strictly dependent on how much work the author put into it.
There may not even be one.
:p.However, a useful index can be provided simply by listing the titles of
each topic alphabetically, and this is what NewView does. It then
merges the original index (if any) with the list of topic titles.
:p.If for some reason you don't like this, you can turn it off in
Tools - Options - Index tab.
:ent.

.* ----------------------------------------------------------------------------
:h2 res=6 id='search'.Search
:p.Searching is a quick way to find information, when you don't know
where to start. Simply go to the Search tab, type some related words
and click the Search button.
You'll see a listing of all topics containing that word, or words
like it, with the best matches at the top. The best match will be
displayed automatically.
:p.Words that matches your search are highlighted in the topic.
:p.:hp2.Global search:ehp2.
:p.You can also search all help files on your system using the :link reftype=hd
refid='GlobalSearch'.global search:elink. in Tools - Search all Help
Files.
:p.:hp2.Phrase search:ehp2.
:p.If you want to search for a phrase made up of more than one word, put
double quotes around it, for example &odq.os/2 warp&cdq.&per.
:p.:hp2.Matching features:ehp2.
:p.NewView allows you finer control of searching.
:p.&plus. indicates a word that :hp2.must:ehp2. be matched
:p.- indicates a word that must :hp2.not:ehp2. be matched
:p.NewView always does partial word matches. That is, if you search
for &odq.win&cdq. NewView will also find &odq.window&cdq. and &odq.showing&cdq.&per. However, the
better the match is the higher the rank will be.
:p.:hp2.How NewView ranks results:ehp2.
:p.NewView ranks matching topics by various means&colon.
:p.- a closer match to a full word
:p.- number of matching words in a topic
:p.- matches within the title
:p.- matches within an index entry

.* ----------------------------------------------------------------------------
:h2 res=7 id='notes'.Notes
:p.NewView allows you to add notes (annotations) to your help
files.
:p.To add a note, simply click where you want to make a note and click the
&odq.Note&cdq. button
:artwork runin name='images\note.bmp'.
, then type your text and click OK. The text will be inserted into the
help topic with a different color (default is green; you can change
this in Tools - Options - Colors).
:p.To edit or delete a note, click on the colored note text; you can
then edit the note text, or click on delete to get rid of it.
:p.You can also review all the notes that you've made in the current help
file(s) by going to the Notes tab; this allows you to add,
edit, and delete, and also jump to the topics containing your notes.
:p.Notes are saved in a single file with the extension :hp1.&per.nte:ehp1., in
the same directory as the help file to which they refer.
:note.If a help file is changed (for example a program is
upgraded) then notes will no longer appear in the correct place;
however, you can still read them from the Notes tab.

.* ----------------------------------------------------------------------------
:h1 res=18 id='GlobalSearch'.Global Search
:p.You can search all help files on your system, by clicking the Search
All button
:artwork runin name='images\search.bmp'.
, using Tools - Search all Help Files in the menu, or
pressing Ctrl&plus.S.
:p.This search works similarly to :link reftype=hd refid='search'.searching
within a file:elink., but it also tells you what help file the results
were found in.
:p.These searches may take some time, depending on what you search
for. You can stop the search at any time.
:p.:hp2.Where NewView searches:ehp2.
:p.The default is to search for help files in the help paths, which are
specified by the BOOKSHELF and HELP :link reftype=hd
refid='L_EnvironmentVariables'.environment variables:elink.&per.
:p.You can choose other places to search by choosing from the drop-down
list, or customize the list by clicking the Select button.
:p.:hp2.Search in&colon. Standard Help Paths:ehp2.
:p.This is the default and will search BOOKSHELF and HELP as specified
above.
:p.Clicking the select button will allow you to choose which of the directories
in the help paths will be used. Click each item in the list to select or
de-select it. After you choose this, the location will show as
&odq.Selected Help Paths&cdq.
:p.:hp2.Search in&colon. All Hard Drives:ehp2.
:p.This option will search all hard (non-removable) drives on
your system. You can click &odq.Select...&cdq. to customize the
location.
:p.Searching drives can find more help files, but might be much slower
than just the help paths.
:p.:hp2.Search in&colon. Selected Help Paths:ehp2.
:p.If you have already selected particular help paths to search., you can
click &odq.Select...&cdq. to customize again.
:p.:hp2.Search in&colon. Directory List:ehp2.
:p.In the &odq.Select Directories&cdq. dialog, clicking the &odq.Add....&cdq.
button will allow you to add one or more directories to the search list.
:p.Select the drive and directory using the controls that appear, then
click &odq.&lt. Add Directory&cdq. to add the chosen directory. You can do this as
many times as you like. Choose &odq.With sub-directories&cdq. if you want
sub-directories of the selected directory to be searched as well. In
this case, ... will show on the end of the directory.
:p.After you add a custom directory like this, the location for searching
will show as &odq.Directory List&cdq.&per.
:note.If you add a custom directory to standard or selected help
paths, then the list will become a custom list, and you can no
longer re-select help paths. To get back to the original help
paths, choose &odq.Standard Help Paths&cdq. then click &odq.Select...&cdq.
again.
:p.:hp2.Search in&colon. Typing a location:ehp2.
:p.You can type a drive or directory into the &odq.Search in&colon.&cdq. entry
field. Add &odq...&per.&cdq. on the end of the directory if you want to
search subdirectories as well.
:p.Example&colon.
:p. Search in&colon. &lbracket. E&colon.&bsl.mydocs&bsl...&per.
 &rbracket.
:p.This will search help files in E&colon.&bsl.mydocs&bsl. and any
subdirectories.

.* ----------------------------------------------------------------------------
:h1 res=8 id='bookmarks'.Bookmarks
:p.NewView allows you to bookmark particular topics within the current help
file. Simply click the bookmark button
:artwork runin name='images\bookmark.bmp'.
 to add the current topic as a bookmark.
:p.To jump to a bookmark, go to the &odq.Bookmarks&cdq. menu, and click on
the bookmark you want to open.
:p.You can view or delete all your bookmarks by clicking on &odq.Edit.&per.&cdq. in
the &odq.Bookmarks&cdq. menu. This window can remain open while you read, so
that you can quickly look through your bookmarks.

:note.NewView bookmarks remember all the topic windows that are open, if there
is more than one.
:p.Bookmarks are saved in a file with the extension .bmk, in the same
directory as the help file they are for.

.* ----------------------------------------------------------------------------
:h1 res=100 id='InternetLinks'.Internet Links
:p.When you click a web URL such as
https&colon.//www.google.com, NewView launches your
default web browser.
:p.This web browser is specified by operating system settings, not NewView
itself. To configure it, you can open a URL object on the
desktop, edit the browser path in the :hp2.Browser:ehp2. tab, then
click Set Default. Both &ecs. and &aos. include utilities for setting the
default browser, the latter of which uses the ConfigApps utility, also available
from the Hobbes archive&colon.
:p.
https&colon.//hobbes.nmsu.edu/?dir&eq.&percent.2F&amp.stype&eq.all&amp.sort&eq.type_name&amp.search&eq.configapps
.br
:p.Browsers may also have the ability to make themselves the default,
either at install time or in preferences.
:p.NewView takes care of the setup done by Internet-Application-Integration (IAI). Email, Newsgroups and FTP
links are passed to the program you have configured. If there is no program for a specific url type,
then the links are passed to the web browser.
:p.:hp2.Note to help file authors:ehp2.
:p.The original View had no understanding of URL or email links, so the
only way to implement them was a link to, for example,
&odq.netscape.exe&cdq. with the correct parameters.
:p.NewView translates program links to &odq.netscape&cdq., &odq.explore&cdq. or &odq.mozilla&cdq.
into links to the default browser.
:p.It also auto-detects URLs in the forms&colon.
:p. http&colon.//x  https&colon.//x
 ftp&colon.//x
:p. mailto&colon.x  news&colon.x
:p.Things that look like URLs are also detected, even without the protocol
prefix&colon.
:p. www.a.b - browser
:p. ftp.a.b - ftp
:p. a&atsign.b.c - email
:p.where a, b and c are any alphanumeric string.
:p.You don't need to do anything for NewView to recognize these.

.* ----------------------------------------------------------------------------
:h1 res=300 id='SaveIPF'.Exporting as IPF
:p.Another &prod. feature is the ability to save the current document as an IPF
(Information Presentation Facility) source file. For more information concerning
IPF, see :link reftype=hd refid='WritingHelpFiles'.Writing Help Files:elink.
later in this document.

:p.The source code generated from the current document is generally accurate,
and subsitutes many codes for existing symbols. Usually, the resulting file
may be used as-is to recompile to an identical document.

:p.To save the current document as IPF, select Tools - Save as IPF from
the menu or press Ctrl+I. The default filename is derived from the current
document, but may be edited to suit. Simply browse to the directory where the
file is to be saved and click OK.

:p.It is also important to note that any embedded images will also be saved to
the same location, but with generic names (img0.bmp, img1.bmp, etc.). These will
need to be reviewed and their names (and possibly locations) adjusted. The IPF
source will refer to them by these generic names, however.

.* ----------------------------------------------------------------------------
:h1 res=9 id='CommandLine'.Command Line Parameters
:p.When you run NewView from the command line you can supply various
parameters. None of them are required.
:p.:hp2.NewView &lbracket.options&rbracket. &lbracket.&lt.filename&gt.
&lbracket.&lt.search text&gt.&rbracket.&rbracket.:ehp2.
:p.If NewView is installed as a replacement for view, then the command
starts with view instead of newview.
:p.:link reftype=hd refid='CommandLineExamples'.Examples:elink.

:p.:hp2.&lt.filename&gt.:ehp2.
:p.The file for NewView to load. You can load multiple files at once by
using filename1&plus.filename2 etc.

:p.If a path isn't specified, then the files are searched for in the
:link reftype=hd refid='L_EnvironmentVariables'.BOOKSHELF and HELP
paths:elink.&per.

:p.If the path and/or filename contains special characters (like blank) then
you have to enclose the filename in double qoutes.

:p.:hp2.&lt.search text&gt.:ehp2.
:p.Search topic titles and index entries for this text. This is
:hp2.not:ehp2. the same as a normal search, for compatibility with
original View. To do a proper search use the /s option (see
below). For more details, see :link reftype=hd
refid='CommandLineTopicSearch'.Command Line Topic Search:elink.&per.
:p.:hp2.Options:ehp2.
:p.:hp2./s:ehp2.
:p.After opening the file, performs a :link reftype=hd
refid='search'.search:elink. for the given text (do a real full text search intead of
the default topic titles search). The result is the same as performing the search from
the :link reftype=hd
refid='search'.serach navigation panel:elink.&per.
:p.Example&colon.
.br
To search for copy in the whole cmdref document you can call
:cgraphic.
newview /s cmdref copy
:ecgraphic.
NewView is clever enough to handle multiple words (like the :link reftype=hd
refid='search'.serach navigation panel:elink.). This is a OR search.
:cgraphic.
newview /s cmdref net access
:ecgraphic.
To perform a AND search enclose the search phrase in double quotes.
:cgraphic.
newview /s cmdref &odq.net access&cdq.
:ecgraphic.

:p.:hp2./g:ehp2.
:p.Performs a :link reftype=hd refid='GlobalSearch'.global search:elink. for the
given text, on all the help files in your system.
:p.Example&colon.
.br
To search for copy in all help files use
:cgraphic.
newview /g copy
:ecgraphic.
Provide the file name as first parameter if you like to open a help file
before the search starts.
:cgraphic.
newview /g cmdref copy
:ecgraphic.

:p.:hp2./?:ehp2. or :hp2./h:ehp2. or :hp2./help:ehp2.
:p.Show command line help
:p.See also&colon. :link reftype=hd refid='AdvancedParameters'.Advanced
Parameters:elink.

.* ----------------------------------------------------------------------------
:h2 res=13 id='CommandLineTopicSearch'.Command Line Topic Search
:p. view &lt.filename&gt. &lt.topic&gt.
:p.The topic search parameter specified on the command line, copies the
behavior of old view.
:p.Text within topics is not searched, only titles and index entries.
This makes it less useful to humans, but is used by some programs to
reference help topics in a predictable way.
:p.You can use multiple words here.
:p.The search performed is&colon.
:p.- topic title starts with search text
:p.- index entry starts with search text
:p.- topic title contains search text
:p.- index entry contains search text.
:p.Developers should make sure that the expected document will be found if using
this technique to identify topics when starting New or Old view.

.* ----------------------------------------------------------------------------
:h2 res=14 id='AdvancedParameters'.Advanced Parameters
:p.The following command line parameters are intended mainly for software
developers, but can be used for any purpose.
:p.:hp2./lang&colon.&lt.language spec&gt.:ehp2.
:p.Loads the specified language. Overrides the default chosen based on the
LANG environment variable. For example,
:cgraphic.
newview cmdref /lang&colon.en
:ecgraphic.
loads English. See readme.txt for more information.
:p.:hp2./pos&colon.&lt.left&gt.,&lt.bottom&gt.,&lt.width&gt.,&lt.height&gt.:ehp2.
:p.Set the main program window to the given position and size. All values
must be given. Put a :hp2.P:ehp2. after a number to specify a
percentage. For example&colon.
:cgraphic.
newview /pos&colon.10P,10P,80P,80P
:ecgraphic.
makes the window centered and 80&percent. of the screen size.
:p.:hp2./title&colon.&lt.window title&gt.:ehp2.
:p.Sets the title of the NewView window to the specified text, overriding
whatever appears in the help file. The text &odq.Help -  &cdq. will always be
inserted in front of the specified text, unless the specified text is
&odq.help&cdq., in which case the title will simply become &odq.Help&cdq.&per. This is to
make sure that help windows are always obvious as such in the window list.
:p.If you need to specify multiple words, surround the entire option with
quotes, for example&colon.
:cgraphic.
newview cmdref &odq./title&colon.Command Line Help&cdq.
:ecgraphic.

.* ----------------------------------------------------------------------------
:h2 res=15 id='CommandLineExamples'.Command Line Examples
:p.The following examples assume that &prod. is installed as a complete
replacement and therefore view is actually &prod.&per.
:p.:hp2.view cmdref:ehp2.
:p.Open the file cmdref.inf (OS/2 Command Reference) from
the help path.

:p.:hp2.view cmdref&plus.os2ug:ehp2.
:p.Open two files, cmdref.inf and os2ug.inf (OS/2 User
Guide), in the same window.
:p.The table of contents from os2ug.inf is added to the end of the contents
from cmdref.inf. The indexes are combined alphabetically.

:p.:hp2.view c&colon.&bsl.os2&bsl.book&bsl.os2ug.inf:ehp2.
:p.Open the file os2ug.inf in the c&colon.&bsl.os2&bsl.book directory.

:p.:hp2.view &odq.c&colon.&bsl.os2 book&bsl.os2ug.inf&cdq.:ehp2.
:p.Surround a path&bsl.filename with double quotes if it contains any special
characters, such as one or more whitespaces.

:p.:hp2.view cmdref dir:ehp2.
:p.Open the file cmdref (OS/2 command reference) and look in
titles and index for the word &odq.dir&cdq.&per. Will show the help page for the DIR
command.

:p.:hp2.view /s os2ug desktop:ehp2.
:p.Open the file os2ug.inf and search for the word &odq.desktop&cdq.&per. The best
match is shown.

:p.:hp2.view /g permissions:ehp2.
:p.Performs a search of all help files for the word &odq.permissions&cdq.&per.

:p.:hp2.set myhelp&eq.cmdref&plus.os2ug&plus.rexx:ehp2.
.br
:hp2.view myhelp:ehp2.
:p.The first line sets an environment variable MYHELP to contain the names of
three help files. The second line opens the three files.

.* ----------------------------------------------------------------------------
:h1 res=10 id='KeyboardShortcuts'.Keyboard Shortcuts
:p.Most keyboard shortcuts are visible in the menu, but a few are not.
The additional shortcuts are&colon.
:p.:hp2.Alt&plus.F4:ehp2. Exit
:p.:hp2.Ctrl&plus.C:ehp2. Copy selected text to clipboard
:p.:hp2.F7:ehp2. Back
:p.:hp2.F8:ehp2. Forward
:p.:hp2.Ctrl&plus.Left:ehp2. Back
:p.:hp2.F11:ehp2. Previous in contents
:p.:hp2.F12:ehp2. Next in contents
:p.
:p.:hp2.Shortcuts visible in the menu:ehp2.
:p.:hp2.Ctrl&plus.O:ehp2. Open files
:p.:hp2.Ctrl&plus.E:ehp2. Open files from help paths
:p.:hp2.Ctrl&plus.N:ehp2. Open a new window
:p.:hp2.Ctrl&plus.P:ehp2. Print topic
:p.:hp2.F3:ehp2. Exit
:p.
:p.
:p.:hp2.Ctrl&plus.A:ehp2. Select all text in topic
:p.:hp2.Ctrl&plus.Ins:ehp2. Copy selected text to clipboard
:p.
:p.:hp2.Ctrl&plus.F:ehp2. Find within current topic
:p.:hp2.Ctrl&plus.G:ehp2. Repeat last find
:p.
:p.:hp2.Ctrl&plus.S:ehp2. Open global search tool
:p.
:p.:hp2.Alt&plus.C:ehp2. Change to the contents tab
:p.:hp2.Alt&plus.I:ehp2. Change to the index tab
:p.:hp2.Alt&plus.S:ehp2. Change to the search tab
:p.:hp2.Alt&plus.N:ehp2. Change to the notes tab
:p.:hp2.Alt&plus.P:ehp2. Toggle the left panel (tabs) on and off
:p.:hp2.F5:ehp2. Expand all contents
:p.:hp2.F6:ehp2. Collapse all contents
:p.
:p.:hp2.Esc:ehp2. Back
:p.:hp2.Ctrl&plus.Right:ehp2. Forward
:p.:hp2.Ctrl&plus.Up:ehp2. Previous topic in contents
:p.:hp2.Ctrl&plus.Down:ehp2. Next topic in contents
:p.
:p.:hp2.Ctrl&plus.D:ehp2. Edit bookmarks
:p.:hp2.Ctrl&plus.B:ehp2. Bookmark current topic
:p.
:p.:hp2.Ctrl&plus.M:ehp2. Add note at cursor position
:p.:hp2.Ctrl&plus.I:ehp2. Save current document as IPF source file
:p.
:p.:hp2.F1:ehp2. Help for NewView

.* ----------------------------------------------------------------------------
:h1 res=11 id='L_EnvironmentVariables'.Environment Variables
:p.Both the :hp2.BOOKSHELF:ehp2. and :hp2.HELP:ehp2. environment variables
define paths (lists of directories) for searching for help files.
NewView uses both paths without distinction.
:p.These paths are searched when you&colon.
:ul.
:li.specify a help file without a path on the command line
:li.use the File - Open Special... menu item
:li.do a :link reftype=hd refid='GlobalSearch'.global search:elink.
:eul.
:p.You can permanently add directories of help files to the :hp2.HELP:ehp2. or
:hp2.BOOKSHELF:ehp2. paths by modifying the CONFIG.SYS file. Add to both
paths, if you also want old view to be able to find the files.
:p.:hp2.Other environment variables:ehp2.
:p.The :hp2.LANG:ehp2. environment variable is examined to decide the default
language that NewView will be displayed in. (Overridden by the
/lang :link reftype=hd refid='AdvancedParameters'.command line
parameter:elink.&per.) See the newview readme.txt for more information
about languages.
:p.The directory defined in :hp2.LOGFILES:ehp2. is used for logging crashes or
other information.
:p.The subdirectory &odq.lang&cdq. under the directory defined by :hp2.OSDIR:ehp2. is
searched for language files at startup.
:p.The path :hp2.ULSPATH:ehp2. is also searched for language files.

.* ----------------------------------------------------------------------------
:h1 res=20 id='ForAuthors'.For Authors and Developers
:p.This section contains some notes for document authors and software
developers.
:p.Also see the section about URL recognition in the :link reftype=hd
refid='InternetLinks'.Internet Links :elink.topic.

.* ----------------------------------------------------------------------------
:h2 res=12 id='WritingHelpFiles'.Writing Help Files
:p.OS/2 Help Files are produced using the IPF Compiler. IPF stands for
Information Presentation Facility.
:p.The IPF Compiler takes a text file written in a language that tells it about
things like headings, links, text and images, and produces
either a .INF or .HLP file.
:p.The official way to obtain the IPF compiler (ipfc.exe) is from
the OS/2 Developers Toolkit, which may be installed as a series of
RPM packages from the Netlabs YUM repositories, either from the command
line or using Arca Noae Package Manager
(https&colon.//www.arcanoae.com/resources/downloadables/arca-noae-package-manager/).
:p.Since the language for IPFC is tedious (for example all punctuation must
be typed as special keywords, like &amp.comma.) many people use
other tools besides the IPF compiler itself.
:p.Some use VyperHelp (http&colon.//vyperhelp.netlabs.org/)
as it is simple and graphical. VyperHelp can also export to Windows
Help, HTML, and others, though it only runs on &os2.&per.
:p.Some other popular options are&colon.
:ul.
:li.HyperText/2 IPF Preprocessor
(https&colon.//hobbes.nmsu.edu/?dir=&percent.2F&amp.stype=all&amp.sort=type_name&amp.search=htext)
- preprocesses a simpler starting language into the very difficult IPF format.
Free, with full source code.
:li.HyperMake (http&colon.//www.hypermake.com).
Similar, but can also produce Windows Help and HTML.
:li.Sibyl (used to create NewView) comes with an IPF preprocessor.
:eul.

:note.NewView may not support everything these editors can produce.
:p.In the past there were many other options. Those listed should still be
available and have some support.

.* ----------------------------------------------------------------------------
:h2 res=16 id='TopicResourceIDs'.Topic Resource IDs
:p.Resource IDs are used by authors of online help for applications, to
identify help topics. Applications call the Help Manager specifying a
resource ID, either directly using the HM&us.DISPLAY&us.HELP
message, or indirectly via help tables added to their resources,
which PM automatically handles. The resource ID is stored in a table inside
the help file.
:p.For document authors, NewView offers the ability to see and find
resource IDs.
:p.:hp2.Finding by Resource ID:ehp2.
:p.Use Tools - Find Resource ID to search for a specified resource ID in
all opened files.
:p.:hp2.Displaying Resource IDs:ehp2.
:p.Use topic properties (right mouse click - Properties) to see
which resource IDs are associated with a topic.

.* ----------------------------------------------------------------------------
:h2 res=19 id='TopicNames'.Topic Names
:p.Like resource IDs, topic names can be used by developers to link to
help topics from within their application, using the HM&us.DISPLAY&us.HELP
message with parameter 2 being HM&us.PANELNAME.
:p.These are not so often used.
:p.NewView can find a particular topic name, using Tools - Find
Topic Name.
:euserdoc.
