:userdoc.
:docprof toc=12.
:title.Testcase for subpanels
:h1 id=1 x=0% y=0% width=40% height=100% clear.Panel 1
:link reftype=hd auto viewport dependent refid=2.
:p.
Select one of the following topics&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=2.First subpanel:elink.
:li.:link reftype=hd viewport dependent refid=3.Second subpanel:elink.
:eul.
:p.
Selecting a subpanel via a link in the list above works correct.
:p.
Selecting a subpanel via the contents page or via Previous/Next
closes all other panels.
:h2 id=2 x=40% y=0% width=60% height=100%.First subpanel
:i1.First subpanel
:p.
This is text in the first subpanel.
:h2 id=3 x=40% y=0% width=60% height=100%.Second subpanel
:i1.Second subpanel
:p.
This is text in the second subpanel.
:h1 id=4 clear.IPF source code for the lines above
:xmp.
   &colon.userdoc.
   &colon.docprof toc=12.
   &colon.title.Testcase for subpanels
   &colon.h1 id=1 x=0% y=0% width=40% height=100% clear.Panel 1
   &colon.link reftype=hd auto viewport dependent refid=2.
   &colon.p.
   Select one of the following topics&amp.colon.
   &colon.ul compact.
   &colon.li.&colon.link reftype=hd viewport dependent refid=2.First subpanel&colon.elink.
   &colon.li.&colon.link reftype=hd viewport dependent refid=3.Second subpanel&colon.elink.
   &colon.eul.
   &colon.p.
   Selecting a subpanel via a link in the list above works correct.
   &colon.p.
   Selecting a subpanel via the contents page or via Previous/Next
   closes all other panels.
   &colon.h2 id=2 x=40% y=0% width=60% height=100%.First subpanel
   &colon.i1.First subpanel
   &colon.p.
   This is text in the first subpanel.
   &colon.h2 id=3 x=40% y=0% width=60% height=100%.Second subpanel
   &colon.i1.Second subpanel
   &colon.p.
   This is text in the second subpanel.
:exmp.
:h1 id=5 clear.Possible solutions
:parml break=none tsize=5.
:pt.:hp2.Solution 1&colon.:ehp2.
:pd.Always open a panel with its page properties determined from
the parent panel as well. (Opening a panel from the contents should
give the same result as opening it from another panel.)
:pt.:hp2.Solution 2&colon.:ehp2.
:pd.Don't simply close all panels when opening a panel from the
contents page. To avoid a crowded presentation space, close other
panels when another panel with the same or higher level is opened.
:eparml.
:p.
Even better IMO would be Solution 3, even when it probably doesn't fully
comply to the IPF principals&colon.
:parml break=none tsize=5.
:pt.:hp2.Solution 3&colon.:ehp2.
:pd.When opening a panel, always open a more top level panel
with it, but only until the left edge of the workarea is reached.
:eparml.
:euserdoc.
