:userdoc.
:docprof toc=12.
:title.Testcases for issues with empty lines
:h1 id=10 x=0% y=0% width=40% height=100% clear.1  Line breaks or par breaks at the top
:p.
:link reftype=hd auto viewport dependent refid=11.
Select one of the following topics&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=11.&colon.p. at the top (ok):elink.
:li.:link reftype=hd viewport dependent refid=12.No &colon.p. at the top (ok):elink.
:li.:link reftype=hd viewport dependent refid=13.Additional line at the top caused by .br (not ok):elink.
:eul.
:h2 id=11 x=40% y=0% width=60% height=100%.1.1  &colon.p. at the top (ok)
:p.
This line starts correctly at the top.
:h2 id=12 x=40% y=0% width=60% height=100%.1.2  No &colon.p. at the top (ok)
This line starts correctly at the top.
:p.
IBM's viewer has problems with that: The text comes directly after the
header and is indented by -1.
:p.
NewView handles that really good.
:h2 id=13 x=40% y=0% width=60% height=100%.1.3  Additional line at the top caused by .br (not ok)
.br
This line starts 1 line below the top.
:p.
A line break should better be handled like a par break, when there's no
line to break, because it comes in col 1.
:h1 id=20 x=0% y=0% width=40% height=100% clear.2  Additional empty line at the top caused by &colon.link.
:p.
:link reftype=hd auto viewport dependent refid=21.
Select one of the following topics&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=21.&colon.link. before &colon.p. (not ok):elink.
:li.:link reftype=hd viewport dependent refid=22.&colon.link. before &colon.i1. and &colon.p. (not ok):elink.
:li.:link reftype=hd viewport dependent refid=23.&colon.link. after &colon.p. (ok):elink.
:eul.
:h2 id=21 x=40% y=0% width=60% height=100%.2.1  &colon.link. before &colon.p. (not ok)
:i1.First subpanel
:link reftype=hd auto viewport dependent refid=21.
:p.
This line starts 1 line below the top.
:p.
The &colon.i1. line doesn't influence the topmost line.
:p.
The &colon.link. line confuses the empty line handling, when it
comes before the &colon.p. for the following text. Moving the
&colon.link. after the &colon.p. (as shown on the
:link reftype=hd viewport refid=23.Third subpanel:elink.) works correct.
:p.
(The link on the top of this panel doesn't make sense, because it
refers to the panel itself.)
:h2 id=22 x=40% y=0% width=60% height=100%.2.2  &colon.link. before &colon.i1. and &colon.p. (not ok)
:link reftype=hd auto viewport dependent refid=22.
:i1.Second subpanel
:p.
This line starts 1 line below the top.
:p.
The &colon.i1. line doesn't influence the topmost line.
:p.
The &colon.link. line confuses the empty line handling, when it
comes before the &colon.p. for the following text. Moving the
&colon.link. after the &colon.p. (as shown on the
:link reftype=hd viewport refid=23.Third subpanel:elink.) works correct.
:p.
(The link on the top of this panel doesn't make sense, because it
refers to the panel itself.)
:h2 id=23 x=40% y=0% width=60% height=100%.2.3  &colon.link. after &colon.p. (ok)
:i1.Third subpanel
:p.
:link reftype=hd auto viewport dependent refid=23.
This line starts correctly at the top.
:p.
(The link on the top of this panel doesn't make sense, because it
refers to the panel itself.)
:h1 id=30 x=0% y=0% width=40% height=100% clear.3  Additional empty line at the top caused by lists and &colon.xmp.
:p.
:link reftype=hd auto viewport dependent refid=31.
Select one of the following topics&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=31.List at the top of a panel (not ok):elink.
:li.:link reftype=hd viewport dependent refid=32.&colon.xmp. at the top of a panel (not ok):elink.
:li.:link reftype=hd viewport dependent refid=33.&colon.nt. at the top of a panel (ok):elink.
:li.:link reftype=hd viewport dependent refid=34.&colon.note. at the top of a panel (ok):elink.
:li.:link reftype=hd viewport dependent refid=35.&colon.table. at the top of a panel (not ok):elink.
:li.:link reftype=hd viewport dependent refid=36.&colon.cgraphic. at the top of a panel (not ok):elink.
:eul.
:h2 id=31 x=40% y=0% width=60% height=100%.3.1  List at the top of a panel (not ok)
:ul compact.
:li.First item
:li.Second item
:eul.
:p.
The list starts 1 line below the top.
:h2 id=32 x=40% y=0% width=60% height=100%.3.2  &colon.xmp. at the top of a panel (not ok)
:xmp.
This line starts even 2 lines below the top.
This is the second line.
:exmp.
:h2 id=33 x=40% y=0% width=60% height=100%.3.3  &colon.nt. at the top of a panel (ok)
:nt.
This is the first par.
:p.
This is the second par.
:ent.
:h2 id=34 x=40% y=0% width=60% height=100%.3.4  &colon.note. at the top of a panel (ok)
:note.
This is a note.
:h2 id=35 x=40% y=0% width=60% height=100%.3.5  &colon.table. at the top of a panel (not ok)
:table cols='15 20 25' rules=horiz frame=rules.
:row.
:c.Row 1 Col 1
:c.Row 1 Col 2
:c.Row 1 Col 3
:row.
:c.Row 2 Col 1
:c.Row 2 Col 2
:c.Row 2 Col 3
:etable.
This table starts even 2 lines below the top.
:h2 id=36 x=40% y=0% width=60% height=100%.3.6  &colon.cgraphic. at the top of a panel (not ok)
:cgraphic.
First line of a character graphic.
Second line of a character graphic.
:ecgraphic.
Normal text.
:cgraphic.
First line of a character graphic.
Second line of a character graphic.
:ecgraphic.
:cgraphic.
First line of a character graphic.
Second line of a character graphic.
:ecgraphic.
Moreover, it shows that the current NewView version still has minor
issues with the spacing before &colon.cgraphic.
:h1 id=40 x=0% y=0% width=40% height=100% clear.4  Multiple environvents and &colon.lines..xmp.
:p.
:link reftype=hd auto viewport dependent refid=41.
Select one of the following topics&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=41.List followed by a list (ok):elink.
:li.:link reftype=hd viewport dependent refid=42.&colon.xmp. followed by &colon.xmp. (not ok):elink.
:li.:link reftype=hd viewport dependent refid=43.List and &colon.xmp. (not ok):elink.
:li.:link reftype=hd viewport dependent refid=44.Missing empty line before &colon.lines. (not ok):elink.
:eul.
:h2 id=41 x=40% y=0% width=60% height=100%.4.1  List followed by a list (ok)
:p.
Here come two lists&colon.
:ul compact.
:li.First item
:li.Second item
:eul.
:ul compact.
:li.First item
:li.Second item
:eul.
:p.
The list spacing is ok. Adding a &colon.p. before a list would cause an
additional empty line. That's the same for IBM's viewer.
:h2 id=42 x=40% y=0% width=60% height=100%.4.2  &colon.xmp. followed by &colon.xmp. (not ok)
:p.
Here come two &colon.xmp. environmonts&colon.
:xmp.
This is the first line.
This is the second line.
:exmp.
:xmp.
This is the first line.
This is the second line.
:exmp.
An &colon.xmp. always adds an empty line before. An &colon.exmp. always
adds an empty line thereafter. IBM's viewer corrects that spacing when
two &colon.xmp. environments follow each other or when they come at the
top. As shown above in :link reftype=hd viewport refid=32.this example:elink.,
apparently the header also adds an empty line itself in NewView. That could
explain the two additional empty lines in that example at the top.
:h2 id=43 x=40% y=0% width=60% height=100%.4.3  List and &colon.xmp. (not ok)
:p.
Here come three environmonts&colon.
:ul compact.
:li.First item
:li.Second item
:eul.
:xmp.
This is the first line.
This is the second line.
:exmp.
:ul compact.
:li.First item
:li.Second item
:eul.
:h2 id=44 x=40% y=0% width=60% height=100%.4.4  Missing empty line before &colon.lines. (not ok)
:p.
Here comes a &colon.lines. environment&colon.
:lines.
This is the first line.
This is the second line.
:elines.
:p.
The first line in the &colon.lines. environment comes directly after
the text above. The IBM viewer adds there an empty line.
:h1 id=50.5  Overview&colon. Some tags add empty lines themselves
:p.
As several tests showed, a normal par should always start with a &colon.p.
tag. Some environment tags add a &colon.p. tag themselves&colon.
:ul compact.
:li.&colon.sl. (simple list environment start)
:li.&colon.ol. (ordered list environment start)
:li.&colon.ul. (unordered list environment start)
:li.&colon.dl. (definition list environment start)
:li.&colon.parml. (parameter list environment start)
:li.&colon.lines. (lines environment start)
:li.&colon.note. (note paragraph start, NewView handles this correct)
:li.&colon.nt. (note environment start, NewView handles this correct)
:li.&colon.xmp. (example environment start)
:li.&colon.exmp. (example environment end)
:li.&colon.table. (table environment start)
:li.&colon.etable. (table environment end)
:eul.
:p.
Apparently NewView doesn't correct the additional empty lines at the
start of such an environment (if not mentioned otherwise) at the top
of a panel.
:euserdoc.
