#define INCL_DOS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void main( int argc, char* argv[])
{
   APIRET rc;
   int    ordinal;
   HMODULE hmod;
   PFN    pfn;
   char   buffer[ 256];

   if (argc<2) {
      puts( "Usage: LoadMod filename  [procname/ordinal]");
      exit( 1);
   }
   strcpy( buffer, "");

   rc = DosLoadModule( buffer, sizeof( buffer), argv[1], &hmod);
   if (rc) {
      printf( "can't load module: rc=%d, reason is '%s'.\n", rc, buffer);
   } else {
      printf( "module loaded correctly as hmod=%x.\n", hmod);
   }
   if (!argv[2]) 
      exit(0);

   ordinal = atoi( argv[2]);

   rc = DosQueryProcAddr( hmod, ordinal, argv[2], &pfn);
   if (rc) {
      printf( "can't query '%s': rc=%d\n", argv[2], rc);
   } else {
      printf( "query '%s': at %x\n", argv[2], pfn);
   }

   rc = DosFreeModule( hmod);
   if (rc) 
      printf( "can't free module: rc=%d\n", rc);

}
