/*
   Quick test.

   Function pthread_rwlock_unlock() will block the thread.
*/

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>

pthread_rwlock_t rwlock;


static void *_start_routine(void *arg)
{
  puts( "[Thread] start, wait..." );
  usleep( 200 * 1000 );

  puts( "[Thread] call pthread_rwlock_wrlock()" );
  pthread_rwlock_wrlock( &rwlock );
  puts( "[Thread] pthread_rwlock_wrlock() - done" );

  usleep( 100 * 1000 );

  puts( "[Thread] call pthread_rwlock_unlock()" );
  // pthread_rwlock_unlock() may block the thread here.
  pthread_rwlock_unlock( &rwlock );
  puts( "[Thread] pthread_rwlock_unlock() - done, exit thread" );

  return NULL;
}

int main()
{
  pthread_t thread;
  int idx;

  pthread_rwlock_init( &rwlock, NULL );

  if ( pthread_create( &thread, NULL, _start_routine, NULL ) != 0 )
  {
    puts( "pthread_create() failed" );
    return 1;
  }


  for( idx = 0; idx < 100; idx++ )
  {
    printf( "[main] Iteration: %d, call pthread_rwlock_rdlock()\n", idx );
    pthread_rwlock_rdlock( &rwlock );
    printf( "[main] Iteration: %d, pthread_rwlock_rdlock() - done\n", idx );

    usleep( 1000 );

    printf( "[main] Iteration: %d, call pthread_rwlock_unlock()\n", idx );
    // pthread_rwlock_unlock() may block the thread here.
    pthread_rwlock_unlock( &rwlock );
    printf( "[main] Iteration: %d, pthread_rwlock_unlock() - done\n", idx );
  }


  puts( "[main] Exit" );
  pthread_rwlock_destroy( &rwlock );

  return 0;
}
