/* ioctl( SIOCGIFCONF ) test with TCPV40HDRS */

#define TCPV40HDRS

#include <stdio.h>
#include <string.h>

#include <types.h>
#include <sys/socket.h> /* socket() */
#include <unistd.h>     /* soclose() */
#include <sys/ioctl.h>  /* ioctl(), SIOCGIFCONF */
#include <net/if.h>     /* struct ifreq */


#define MAX_NICS    IFMIB_ENTRIES

int main( void )
{
    struct ifconf ifconf;
    struct ifreq if_list[ MAX_NICS ];
    int s;
    int rc;

    printf("Testing ioctl( SIOCGIFCONF ) with TCPV40HDRS...\n");

    s = socket( PF_INET, SOCK_RAW, 0 );

    memset( if_list, 0, sizeof( if_list ));

    ifconf.ifc_len = sizeof( if_list );
    ifconf.ifc_req = if_list;
    rc = ioctl( s, SIOCGIFCONF, &ifconf );

    soclose( s );

    printf("%s: rc = %d(0)\n", rc == 0 ? "PASSED" : "FAILED", rc );

    return rc == -1;
}
