#include <stdio.h>
#include <string.h>
#include <process.h>

#define LINE_LENGTH ( 1000 * 1000 )

#define RESPONSE_NAME "_response.rsp"

static void spawn( const char *prog )
{
    FILE *f;
    int i;

    f = fopen( RESPONSE_NAME, "wt");

    for( i = 0; i < LINE_LENGTH - 1; i++ )
        fputc('X', f );
    fputc('0', f );
    fputc('\n', f );

    for( i = 0; i < LINE_LENGTH - 1; i++ )
        fputc('X', f );
    fputc('1', f );

    fclose( f );

    spawnlp( P_WAIT, prog, prog, "@" RESPONSE_NAME, NULL );

    remove( RESPONSE_NAME );
}

int main( int argc, char *argv[])
{
    _response( &argc, &argv );

    if( argc > 1 )
    {
        int i;

        for( i = 0; i < argc; i++ )
            printf("a length of argv[%d] = %d, the last char = %c\n",
                   i, strlen( argv[ i ]), argv[ i ][ strlen( argv[ i ]) - 1 ]);

        return 0;
    }

    spawn( argv[ 0 ]);

    return 0;
}
