#include <stdio.h>
#include <errno.h>
#include <io.h>
#include <fcntl.h>

int main( void )
{
    char buffer[ 512 ];

    FILE *fp;

    fp = fopen("freopen.c", "rt");
    printf("original fp = %p\n", fp );
    printf("freopen() = %p\n", freopen( NULL, "rb", fp ));
    perror("freopen()");
    printf("new fp = %p\n", fp );

    printf("fcntl() = %x, O_BINARY = %x\n",
           fcntl( fileno( fp ), F_GETFL ), O_BINARY );
    printf("-----\n");

    getchar();

    printf("original stdin = %p\n", stdin );
    printf("freopen() = %p\n", freopen( NULL, "rb", stdin ));
    perror("freopen()");
    printf("new stdin = %p\n", stdin);

    printf("fcntl() = %x, O_BINARY = %x\n",
           fcntl( fileno( stdin ), F_GETFL ), O_BINARY );
    printf("-----\n");

    printf("original stdout = %p\n", stdout );
    printf("freopen() = %p\n", freopen( NULL, "wb", stdout ));
    perror("freopen()");
    printf("new stdout = %p\n", stdout);

    printf("fcntl() = %x, O_BINARY = %x\n",
           fcntl( fileno( stdout ), F_GETFL ), O_BINARY );
    printf("-----\n");

    printf("original stderr = %p\n", stderr );
    printf("freopen() = %p\n", freopen( NULL, "wb", stderr ));
    perror("freopen()");
    printf("new stderr = %p\n", stderr);

    printf("fcntl() = %x, O_BINARY = %x\n",
           fcntl( fileno( stderr ), F_GETFL ), O_BINARY );
    printf("-----\n");

    printf("buffer = %s\n", fgets( buffer, sizeof( buffer ), stdin ));

    fclose( fp );

    return 0;
}
