#include <stdio.h>
#include <stdlib.h>

void foo()
{
	void *p1, *p2, *p3;
	int rc1 = posix_memalign(&p1, 16, 32);
	int rc2 = posix_memalign(&p2, 64 * 1024, 64 * 1024 * 2);
	//int rc3 = posix_memalign(&p3, 256 * 1024, 256 * 1024 * 2);
 
    printf("rc1 %d p1 %p\n", rc1, p1);
    printf("rc2 %d p2 %p\n", rc2, p2);
    //printf("rc3 %d p3 %p\n", rc3, p3);
}

void posix_memalign_test (size_t align)
{
	int rc = 0;
	void *p;
	size_t sz = align * 2;
	size_t total_sz = 0;
	
	while (!rc)
	{
		rc = posix_memalign(&p, align, sz);
		if (!rc)
		{
			total_sz += sz;
			if (((int) p) & (align - 1))
			{
				printf ("ERROR: Returned pointer %p violates requested alignment 0x%x.\n",
						p, align);
				break;
			}
			
			printf ("Allocated next %d bytes at %p.\n", sz, p);
		}
		else
		{
			printf ("ERROR: Could not allocate next %d bytes. Error %d (%s).\n",
					sz, errno, strerror(errno));
		}
	}
			
	printf ("Total allocated size is %d bytes.\n", total_sz);
}

int main()
{
	//foo();
	//foo();
	posix_memalign_test(256 * 1024);
    return 0;
}
