#define INCL_DOS
#include <os2.h>

#include <stdio.h>

#include "lvm/lvm_intr.h"

static void (* _System _Open_LVM_Engine)( BOOLEAN Ignore_CHS, CARDINAL32 * Error_Code );
static Volume_Control_Array (* _System _Get_Volume_Control_Data)( CARDINAL32 * Error_Code );
static Volume_Information_Record (* _System _Get_Volume_Information)( ADDRESS Volume_Handle, CARDINAL32 * Error_Code );
static void (* _System _Free_Engine_Memory)( ADDRESS Object );
static void (* _System _Close_LVM_Engine)( void );

int main(void)
{
		HMODULE hLVM;
		UCHAR 	LoadError[256];
		APIRET	rc;
    Volume_Control_Array vca;
    Volume_Information_Record volinfo;
	CARDINAL32 	Error_Code = 1;
	int index;

		rc = DosLoadModule((PSZ)LoadError, sizeof(LoadError), (PCSZ)"LVM.DLL", &hLVM);
		if (rc == 0) {
			rc = DosQueryProcAddr(hLVM, 0, (PCSZ)"Open_LVM_Engine", (PFN*)&_Open_LVM_Engine);
			rc = DosQueryProcAddr(hLVM, 0, (PCSZ)"Get_Volume_Control_Data", (PFN*)&_Get_Volume_Control_Data);
			rc = DosQueryProcAddr(hLVM, 0, (PCSZ)"Get_Volume_Information", (PFN*)&_Get_Volume_Information);
			rc = DosQueryProcAddr(hLVM, 0, (PCSZ)"Free_Engine_Memory", (PFN*)&_Free_Engine_Memory);
			rc = DosQueryProcAddr(hLVM, 0, (PCSZ)"Close_LVM_Engine", (PFN*)&_Close_LVM_Engine);
		}

	// Open the LVM engine
    _Open_LVM_Engine( TRUE, &Error_Code );
    if ( Error_Code != LVM_ENGINE_NO_ERROR ) {
		// lvm engine cannot be opened, probably another instance using it
		// since drive is existing, map to fixed disk
		return 1 ;    
    }

	// Get the array of volume handles
    vca = _Get_Volume_Control_Data( &Error_Code );
    printf( "_Get_Volume_Control_Data error code %d (should be 0)\n", Error_Code);
    if ( Error_Code != LVM_ENGINE_NO_ERROR ) {
		_Close_LVM_Engine();
		// lvm engine cannot be opened, probably another instance using it
		// since drive is existing, map to fixed disk
		return 1;    
    }

	// get the volume information for each one
	for (  index = 0; index < vca.Count; index++ ) {
		volinfo = _Get_Volume_Information( vca.Volume_Control_Data[ index ].Volume_Handle,
										  &Error_Code);
				printf( "Found device#%d\n", index);
				switch( vca.Volume_Control_Data[ index ].Device_Type ) {
				case LVM_HARD_DRIVE:  
					break;
				case LVM_PRM:  
					break;
				case NON_LVM_CDROM:
					break;
				case NETWORK_DRIVE:
					break;
				default:
					// map unknown devices to fixed disks
					break;
				}
			_Free_Engine_Memory( vca.Volume_Control_Data );
			_Close_LVM_Engine();
			return 1;    
		}

	// no lvm info found
	_Free_Engine_Memory( vca.Volume_Control_Data );
	_Close_LVM_Engine();

}
