/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.comm;

import com.ibm.comm.OS2NotifyParallelThread;
import com.ibm.comm.OS2ParallelInputStream;
import com.ibm.comm.OS2ParallelOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.ParallelPort;
import javax.comm.ParallelPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class OS2ParallelPort
extends ParallelPort {
    private int handle;
    private String Portname;
    private ParallelPortEventListener listener;
    private OS2NotifyParallelThread notifyThread = null;
    private OS2ParallelInputStream is = null;
    private OS2ParallelOutputStream os = null;
    private boolean bNewData = true;
    public static final int ON_ERROR = 1;
    public static final int ON_BUFFER = 2;

    public OS2ParallelPort(String string) {
        super(string);
        this.Portname = string;
        this.handle = this._OpenParallelPort(string);
    }

    public void addEventListener(ParallelPortEventListener parallelPortEventListener) throws TooManyListenersException {
        if (this.listener == null) {
            this.listener = parallelPortEventListener;
            this.notifyThread = new OS2NotifyParallelThread(this, this.handle, parallelPortEventListener);
            this.notifyThread.setPriority(1);
            this.notifyThread.start();
        } else if (this.listener != parallelPortEventListener) {
            throw new TooManyListenersException();
        }
    }

    public void removeEventListener() {
        this.listener = null;
        if (this.notifyThread != null) {
            this.notifyThread.setStopFlag();
            this.notifyThread.stop();
            this.notifyThread = null;
        }
    }

    public void notifyOnError(boolean bl) {
        if (this.listener != null) {
            this.notifyThread.AddNotify(1, bl);
        }
    }

    public void notifyOnBuffer(boolean bl) {
        if (this.listener != null) {
            this.notifyThread.AddNotify(2, bl);
        }
    }

    public int getOutputBufferFree() {
        return -1;
    }

    public boolean isPaperOut() {
        return this._isPaperOut(this.handle);
    }

    public boolean isPrinterBusy() {
        return this._isPrinterBusy(this.handle);
    }

    public boolean isPrinterSelected() {
        return this._isPrinterSelected(this.handle);
    }

    public boolean isPrinterTimedOut() {
        return this._isPrinterTimedOut(this.handle);
    }

    public boolean isPrinterError() {
        return this._isPrinterError(this.handle);
    }

    public void restart() {
    }

    public void suspend() {
    }

    public int getMode() {
        return this._getMode(this.handle);
    }

    public int setMode(int n) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public void SetNewData(boolean bl) {
        this.bNewData = bl;
    }

    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.is = new OS2ParallelInputStream(this, this.handle);
        }
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            this.os = new OS2ParallelOutputStream(this.handle);
        }
        return this.os;
    }

    public void enableReceiveThreshold(int n) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public void disableReceiveThreshold() {
    }

    public boolean isReceiveThresholdEnabled() {
        return false;
    }

    public int getReceiveThreshold() {
        return -1;
    }

    public void enableReceiveTimeout(int n) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public void disableReceiveTimeout() {
    }

    public boolean isReceiveTimeoutEnabled() {
        return false;
    }

    public int getReceiveTimeout() {
        return -1;
    }

    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public void disableReceiveFraming() {
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return -1;
    }

    public void setInputBufferSize(int n) {
    }

    public int getInputBufferSize() {
        return -1;
    }

    public void setOutputBufferSize(int n) {
    }

    public int getOutputBufferSize() {
        return -1;
    }

    public void close() {
        this._close(this.handle);
        if (this.os != null) {
            try {
                this.os.close();
                this.os = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.is != null) {
            try {
                this.is.close();
                this.is = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.notifyThread != null) {
            this.notifyThread.setStopFlag();
            this.notifyThread.stop();
        }
        super.close();
    }

    private native int _OpenParallelPort(String var1);

    private native boolean _isPaperOut(int var1);

    private native boolean _isPrinterBusy(int var1);

    private native boolean _isPrinterSelected(int var1);

    private native boolean _isPrinterTimedOut(int var1);

    private native boolean _isPrinterError(int var1);

    private native int _getMode(int var1);

    private native void _close(int var1);
}

