/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import com.ibm.comm.OS2ContentionThread;
import com.ibm.comm.OS2SleepTime;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortEnumerator;
import javax.comm.CommPortOwnershipListener;
import javax.comm.CpoList;
import javax.comm.NoSuchPortException;
import javax.comm.OwnershipEventThread;
import javax.comm.PortInUseException;
import javax.comm.UnsupportedCommOperationException;

public class CommPortIdentifier {
    String name;
    private int portType;
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    private boolean maskOwnershipEvents;
    OwnershipEventThread oeThread;
    CpoList cpoList = new CpoList();
    CommPortIdentifier next;
    private CommPort port;
    private CommDriver driver;
    private OS2ContentionThread contentionThread;
    private boolean portInUse;
    static Object lock;
    static String propfilename;
    static CommPortIdentifier masterIdList;
    boolean owned;
    String owner;

    public static Enumeration getPortIdentifiers() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(propfilename);
        }
        return new CommPortEnumerator();
    }

    public static CommPortIdentifier getPortIdentifier(String string) throws NoSuchPortException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(propfilename);
        }
        CommPortIdentifier commPortIdentifier = null;
        Object object = lock;
        synchronized (object) {
            commPortIdentifier = masterIdList;
            while (commPortIdentifier != null) {
                if (commPortIdentifier.name.equals(string)) break;
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        throw new NoSuchPortException();
    }

    public static CommPortIdentifier getPortIdentifier(CommPort commPort) throws NoSuchPortException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(propfilename);
        }
        CommPortIdentifier commPortIdentifier = null;
        Object object = lock;
        synchronized (object) {
            commPortIdentifier = masterIdList;
            while (commPortIdentifier != null) {
                if (commPortIdentifier.port == commPort) break;
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        throw new NoSuchPortException();
    }

    private static void addPort(CommPort commPort, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(propfilename);
        }
        CommPortIdentifier commPortIdentifier = new CommPortIdentifier(commPort.getName(), commPort, n, null);
        CommPortIdentifier commPortIdentifier2 = masterIdList;
        CommPortIdentifier commPortIdentifier3 = null;
        Object object = lock;
        synchronized (object) {
            while (commPortIdentifier2 != null) {
                commPortIdentifier3 = commPortIdentifier2;
                commPortIdentifier2 = commPortIdentifier2.next;
            }
            if (commPortIdentifier3 != null) {
                commPortIdentifier3.next = commPortIdentifier;
            } else {
                masterIdList = commPortIdentifier;
            }
        }
    }

    public static void addPortName(String string, int n, CommDriver commDriver) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(propfilename);
        }
        CommPortIdentifier commPortIdentifier = new CommPortIdentifier(string, null, n, commDriver);
        CommPortIdentifier commPortIdentifier2 = masterIdList;
        CommPortIdentifier commPortIdentifier3 = null;
        Object object = lock;
        synchronized (object) {
            while (commPortIdentifier2 != null) {
                commPortIdentifier3 = commPortIdentifier2;
                commPortIdentifier2 = commPortIdentifier2.next;
            }
            if (commPortIdentifier3 != null) {
                commPortIdentifier3.next = commPortIdentifier;
            } else {
                masterIdList = commPortIdentifier;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPortType() {
        return this.portType;
    }

    public synchronized CommPort open(String string, int n) throws PortInUseException {
        int n2;
        if (this.owned) {
            this.maskOwnershipEvents = true;
            this.fireOwnershipEvent(3);
            this.maskOwnershipEvents = false;
            if (this.owned) {
                throw new PortInUseException(this.owner);
            }
        }
        OS2SleepTime oS2SleepTime = new OS2SleepTime();
        int n3 = oS2SleepTime.GetSleepTime();
        this._Sleep(n3);
        int n4 = this._QuerySharedMem(this.name);
        this.port = n4 == 0 ? null : this.driver.getCommPort(this.name, this.portType);
        if (this.port == null) {
            n2 = this._QueryQueue(this.name);
            if (n2 != 0) {
                this._AddQueueRequest(this.name, string);
                this.portInUse = true;
                this._Sleep(n);
                int n5 = this._QuerySharedMem(this.name);
                this.port = n5 == 0 ? null : this.driver.getCommPort(this.name, this.portType);
            }
            if (this.port == null) {
                throw new PortInUseException("Unknown Application");
            }
        }
        this.owned = true;
        this.owner = string;
        n2 = this._CreatePortQueue(this.name);
        this.portInUse = false;
        this._Sleep(n3);
        this._CreateSharedMem(this.name);
        this.contentionThread = new OS2ContentionThread(this, this.name);
        this.contentionThread.setPriority(1);
        this.contentionThread.start();
        if (!this.maskOwnershipEvents) {
            this.fireOwnershipEvent(1);
        }
        return this.port;
    }

    public String getCurrentOwner() {
        if (this.owned) {
            return this.owner;
        }
        return " ";
    }

    public boolean isCurrentlyOwned() {
        return this.owned;
    }

    public void addPortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        this.cpoList.add(commPortOwnershipListener);
        if (this.oeThread == null) {
            this.oeThread = new OwnershipEventThread(this);
            this.oeThread.start();
        }
    }

    public void removePortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        this.cpoList.remove(commPortOwnershipListener);
    }

    public void ownershipThreadWaiter() {
        boolean bl;
        if (this.contentionThread != null && (bl = this.contentionThread.QueryRequest())) {
            this.contentionThread.ReSetRequest(false);
            this.fireOwnershipEvent(3);
        }
        if (this.portInUse && (bl = this._CheckSharedMem(this.name))) {
            this.fireOwnershipEvent(2);
            this.portInUse = false;
        }
    }

    synchronized void InternalClosePort() {
        this.owned = false;
        this.owner = null;
        this.port = null;
        this.contentionThread.StopCThread();
        this.contentionThread.stop();
        this.contentionThread = null;
        this._ClosePortQueue(this.name);
        this._ChangeToUnowned(this.name);
        OS2SleepTime oS2SleepTime = new OS2SleepTime();
        int n = oS2SleepTime.GetSleepTime();
        this._Sleep(n);
        this.fireOwnershipEvent(2);
        this._FreeSharedMem(this.name);
        if (!this.maskOwnershipEvents) {
            this.fireOwnershipEvent(2);
        }
    }

    CommPortIdentifier(String string, CommPort commPort, int n, CommDriver commDriver) {
        this.name = string;
        this.port = commPort;
        this.portType = n;
        this.next = null;
        this.driver = commDriver;
        this.portInUse = false;
    }

    void fireOwnershipEvent(int n) {
        CpoList cpoList = this.cpoList.clonelist();
        cpoList.fireOwnershipEvent(n);
    }

    private static String[] parsePropsFile(InputStream inputStream) {
        int n;
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            int n2;
            objectArray = new byte[4096];
            n = 0;
            boolean bl = false;
            block7: while ((n2 = inputStream.read()) != -1) {
                switch (n2) {
                    case 9: 
                    case 32: {
                        break;
                    }
                    case 10: 
                    case 13: {
                        String string;
                        if (n > 0) {
                            string = new String((byte[])objectArray, 0, 0, n);
                            vector.addElement(string);
                        }
                        n = 0;
                        bl = false;
                        break;
                    }
                    case 35: {
                        String string;
                        bl = true;
                        if (n > 0) {
                            string = new String((byte[])objectArray, 0, 0, n);
                            vector.addElement(string);
                        }
                        n = 0;
                        break;
                    }
                    default: {
                        if (bl || n >= 4096) continue block7;
                        objectArray[n++] = (byte)n2;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("Caught " + throwable + " parsing prop file.");
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            n = 0;
            while (n < vector.size()) {
                objectArray[n] = (byte)((String)vector.elementAt(n));
                ++n;
            }
            return objectArray;
        }
        return null;
    }

    public CommPort open(FileDescriptor fileDescriptor) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    private native boolean _QueryQueue(String var1);

    private native void _Sleep(int var1);

    private native int _CreatePortQueue(String var1);

    private native void _ClosePortQueue(String var1);

    private native void _AddQueueRequest(String var1, String var2);

    private native void _CreateSharedMem(String var1);

    private native int _QuerySharedMem(String var1);

    private native boolean _CheckSharedMem(String var1);

    private native void _ChangeToUnowned(String var1);

    private native void _FreeSharedMem(String var1);

    static {
        block7: {
            lock = new Object();
            String string = System.getProperty("javacomm.prp");
            if (string != null) {
                System.err.println("Comm Drivers: " + string);
            }
            propfilename = System.getProperty("java.home") + File.separator + "lib" + File.separator + "javacomm.prp";
            File file = new File(propfilename);
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                String[] stringArray = CommPortIdentifier.parsePropsFile(bufferedInputStream);
                if (stringArray == null) break block7;
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].regionMatches(true, 0, "driver=", 0, 7)) {
                        String string2 = stringArray[n].substring(7);
                        string2.trim();
                        try {
                            CommDriver commDriver = (CommDriver)Class.forName(string2).newInstance();
                            commDriver.initialize();
                        }
                        catch (Throwable throwable) {
                            System.err.println("Caught " + throwable + " while loading driver " + string2);
                        }
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                System.err.println(throwable);
            }
        }
    }
}

