#define dllexport _System
#define dllimport _System

#define INCL_DOSMISC
#define INCL_DOSERRORS
#include <os2.h>
#include <stdio.h>
#include <ctype.h>
#include <jni.h>
#include <libgen.h>

char* stristr( const char* haystack, const char* needle ) {
  do {
    const char* h = haystack;
    const char* n = needle;
    while( toupper( (unsigned char) *h ) == toupper( (unsigned char) *n ) && *n ) {
      h++;
      n++;
    }
    if ( *n == 0 )
      return (char *) haystack;
  } while( *haystack++ );
  return 0;
}

JNIEnv* create_vm() {

  UCHAR   uchLIBPATH[512] = "";
  PSZ       pszJAVAHome      = "";       /* Environment variable to JAVA   */
  UCHAR   SearchResult[256] = "";          /* Result of PATH search        */
  APIRET   rc                = NO_ERROR;   /* Return code                  */

  JavaVM* jvm;
  JNIEnv* env;
  JavaVMInitArgs args;
  JavaVMOption options[1];

  int counter = 0;
  rc = DosQueryExtLIBPATH( uchLIBPATH, BEGIN_LIBPATH );   /* Query the BeginLIBPATH */

  if( stristr( uchLIBPATH, "\\bin\\client" ) ==  NULL ) {
    rc = DosQueryExtLIBPATH( uchLIBPATH, END_LIBPATH );   /* Query the EndLIBPATH */
    if( stristr( uchLIBPATH, "\\bin\\client" ) ==  NULL ) {
      for( ; counter < 2; counter++ ) {
	if( rc != NO_ERROR ) {
	  rc = DosSearchPath( SEARCH_CUR_DIRECTORY | SEARCH_IGNORENETERRS,
			     pszJAVAHome,             /* Path value just obtained */
			     "JAVA.EXE",                /* Name of file to look for */
			     SearchResult,              /* Result of the search     */
			     sizeof( SearchResult ) ); /* Length of search buffer  */
	}
	if( rc != NO_ERROR ) {
	  if( counter < 1 )
	    rc = DosScanEnv( "JAVA_HOME", &pszJAVAHome );  /* Get contents of environment variable */
	  else
	    rc = DosScanEnv( "PATH", &pszJAVAHome );  /* Get contents of PATH environment */
	} else
	  break;
      }
      rc = DosSetExtLIBPATH( dirname( SearchResult ),
			    BEGIN_LIBPATH );    /* Add to beginning of LIBPATH */
    }
  }
  if( rc == NO_ERROR ) {
    /* There is a new JNI_VERSION_1_4, but it doesn't add anything for the purposes of our example. */
    args.version = JNI_VERSION_1_6;
    args.nOptions = 1;
    options[0].optionString = "-Djava.class.path=D:\\Programs\\vxrexx\\projects\\ODBCADMN\\j4o\\j4o.class";
    args.options = options;
    args.ignoreUnrecognized = JNI_FALSE;

    JNI_CreateJavaVM( &jvm, (void**)env, &args );
  }
  return env;
}

void invoke_class(JNIEnv* env) {
  jclass helloWorldClass;
  jmethodID mainMethod;
  jobjectArray applicationArgs;
  jstring applicationArg0;

  helloWorldClass = (*env)->FindClass(env, "HelloWorld");

  mainMethod = (*env)->GetStaticMethodID(env, helloWorldClass, "main", "([Ljava/lang/String;)V");

  applicationArgs = (*env)->NewObjectArray(env, 1, (*env)->FindClass(env, "java/lang/String"), NULL);
  applicationArg0 = (*env)->NewStringUTF(env, "From-C-program");
  (*env)->SetObjectArrayElement(env, applicationArgs, 0, applicationArg0);

  (*env)->CallStaticVoidMethod(env, helloWorldClass, mainMethod, applicationArgs);
}


int main(int argc, char **argv) {
  JNIEnv* env = create_vm();
  invoke_class( env );
  return 0;
}