//#define dllexport _System
//#define dllimport _System

#define INCL_DOS
#define INCL_DOSMODULEMGR
#define INCL_DOSMISC
#define INCL_DOSERRORS
#include <os2.h>
#include <stdio.h>
#include <ctype.h>
#include <jni.h>
#include <stdlib.h>
#include <iostream>
#include "var.hpp"


//Ensure to add "APIRET rc = NO_ERROR;" to every function that call INITPROC as it set rc
#ifdef __WATCOMC__
  #define INITPROC( h, r, f, p ) r( __syscall *f)p; rc = DosQueryProcAddr( h, NULL, #f, (PFN *) &f ); if( rc != NO_ERROR ) cerr << "Unable to load " << #f;
#else
  #define INITPROC( h, r, f, p ) r(*f)p; rc = DosQueryProcAddr( h, NULL, ( PCSZ )#f, (PFN *) &f ); if( rc != NO_ERROR ) cerr << "Unable to load " << #f;
#endif
HMODULE hmod;

APIRET loadLibrary() {

    var static_variable;
    var szFailName( _MAX_PATH, Grow );
    var LIBPATH( 1024, Grow );
    var SearchPath( _MAX_PATH, Grow );
    var JAVAHome( _MAX_PATH, Grow );                       /* Environment variable to JAVA   */
    APIRET rc = NO_ERROR;                                  /* Return code                  */
    int i = 0;

    int counter = 0;
    rc = DosQueryExtLIBPATH( LIBPATH, BEGIN_LIBPATH );     /* Query the BeginLIBPATH */

    if( !LIBPATH.contains( "\\bin\\client" ) ) {
        rc = DosQueryExtLIBPATH( LIBPATH, END_LIBPATH );   /* Query the EndLIBPATH */
        if( !LIBPATH.contains( "\\bin\\client" ) ) {
            for( ; counter < 3; counter++ ) {
                rc = DosSearchPath( SEARCH_CUR_DIRECTORY | SEARCH_IGNORENETERRS,
                                   LIBPATH,                /* Path value just obtained */
                                   static_variable.cpy( "JAVA.EXE" ),        /* Name of file to look for */
                                   JAVAHome,               /* Result of the search     */
                                   _MAX_PATH ); /* Length of search buffer  */

                cout << "LibPath: " << LIBPATH << " rc: " << rc << " JAVAHome: " << JAVAHome << endl;

                if( rc != NO_ERROR ) {
                    if( counter < 1 ) {
                        rc = DosScanEnv( static_variable.cpy( "JAVA_HOME" ), LIBPATH ); /* Get contents of environment variable */
                    } else {
                        rc = DosScanEnv( static_variable.cpy( "PATH" ), LIBPATH );      /* Get contents of PATH environment */
                    }
                } else {
                    break;
                }
            }
        }
        cout << "JAVAHome: " << JAVAHome << endl;
        JAVAHome.reSize().before( '\\', true ).reSize(); /* To last \ */
        cout << "JAVAHome: " << JAVAHome << endl;
        JAVAHome.cpy( "D:\\PROGRAMS\\OPENJDK\\BIN" );
        cout << "JAVAHome: " << JAVAHome << endl;
        LIBPATH.reSize( 0 ).flush().cat( JAVAHome, ';', JAVAHome, "\\client;%PATH%" );
        rc = DosSetExtLIBPATH( LIBPATH,
                              BEGIN_LIBPATH );             /* Add to beginning of LIBPATH */
    }

    rc = DosLoadModule( szFailName,                        /* Failed module name */
                       sizeof( szFailName ),               /* Size of buffer     */
                       static_variable.cpy( "jvm.dll" ),                          /* Name of DLL        */
                       &hmod );                            /* Module handle here */
    if( rc != NO_ERROR ) {
        DosFreeModule( hmod );                             /* Frees the DLL module */
        return ERROR_FILE_NOT_FOUND;
    }
    return NO_ERROR;
}

JNIEnv* create_vm() {
    APIRET rc = loadLibrary();
    if( rc == NO_ERROR ) {
        JavaVM* jvm;
        JNIEnv* env;
        JavaVMInitArgs args;
        //memset(&args, 0, sizeof(args));
        //memset(options, 0, sizeof(options));
        JavaVMOption options[] = {
            { "-Xmx512m", NULL },
            { "-XX:+TraceClassLoading", NULL },//To see the origin of the problem class
            { "-Djava.class.path=.", NULL },  //D:\\Programs\\vxrexx\\projects\\ODBCADMN\\j4o";
            { "-Djava.library.path=.", NULL },// set native library path
            { "-Djava.compiler=NONE", NULL }, // disable JIT
            { "-verbose:gc", NULL },          // print gc messages
            { "-verbose:jni", NULL },         // print JNI-related messages
            { "-verbose:class", NULL }        // print class loading messages
        };

        args.version = JNI_VERSION_1_6;
        args.nOptions = sizeof( options ) / sizeof( JavaVMOption );
        args.options = options;
        args.ignoreUnrecognized = JNI_FALSE;

        INITPROC( hmod, jint, JNI_CreateJavaVM, ( JavaVM **p_vm, void **p_env, void *vm_args ) );
        jint jrc = JNI_CreateJavaVM( &jvm, (void**)&env, &args );
//#ifdef __WATCOMC__
        if( jrc != JNI_OK )
            cerr << "Problems loading JVM" << endl;
        else
            cout << "JVM has been loaded sucessfully" << endl;
//#endif
        //delete options;
        return env;
    }
    return NULL;
}

void invoke_class( JNIEnv* env ) {
  jclass helloWorldClass;
  jmethodID mainMethod;
  jobjectArray applicationArgs;
  jstring applicationArg0;

  helloWorldClass = env->FindClass( "HelloWorld" );

  mainMethod = env->GetStaticMethodID( helloWorldClass, "main", "([Ljava/lang/String;)V" );

  applicationArgs = env->NewObjectArray( 1, env->FindClass( "java/lang/String" ), NULL );
  applicationArg0 = env->NewStringUTF( "From-C-program" );
  env->SetObjectArrayElement( applicationArgs, 0, applicationArg0 );

  env->CallStaticVoidMethod( helloWorldClass, mainMethod, applicationArgs);
}

int main( int argc, char **argv ) {
    JNIEnv* env = create_vm();
    if( env )
        invoke_class( env );
    else
        return 1;
  return 0;
}