/**/
'@echo off'

/* Set up prog to be the path of this script, including following symlinks,
   and set up progdir to be the fully-qualified pathname of its directory. */
PARSE SOURCE . . prog

/* Grab current directory before we change it */
work_dir = DIRECTORY()

/* Change current directory and drive to where the script is, to avoid
 issues with directories containing whitespaces. */
PARSE VALUE REVERSE( prog ) WITH fname'\'this
this = REVERSE( this )
CALL DIRECTORY this

/* Check we have a valid Java.exe in the path.*/
java_exe = rxFind( 'JAVA.EXE', ' -version', 'VERSION "1.' )
IF LENGTH( java_exe ) = 0 THEN RETURN 1

jar_path = 'lib\sdkmanager.jar;lib\swtmenubar.jar'

/* Set SWT.Jar path based on current architecture (x86 or x86_64)*/
swt_path = ''
DO WHILE LENGTH( swt_path ) = 0
   DO WHILE QUEUED() > 0; PARSE PULL; END
   '@'java_exe'\java.exe -jar lib\archquery.jar|rxqueue'
   PARSE PULL swt_path
END

MkTempCopy:
    /* Copy android.bat and its required libs to a temp dir.
       This avoids locking the tool dir in case the user is trying to update it.*/

   tmp_dir = VALUE( 'TEMP',,'OS2ENVIRONMENT' )'\temp-android-tool'
   cpy = swt_path'\* common.jar commons-codec* commons-compress* commons-logging dvlib.jag gson* guava* httpclient* httpcore* httpmime* layoutlib-api.jar org-eclipse-* sdk* swtmenubar.jar'
   DO i = 1 TO WORDS( cpy )
      cpyfile = 'lib\'SUBWORD( cpy, i, 1 )
      IF POS( '*', cpyfile ) > 0 THEN
      DO
         CALL SysFileTree this'\'cpyfile, 'file.', 'SFO'
         DO j = 1 TO file.0
            CALL rxCpyFile this, file.j, tmp_dir
         END
      END
      ELSE CALL rxCpyFile this, this'\'cpyfile, tmp_dir
   END

   /* jar_path and swt_path are relative to PWD so we don't need to adjust them, just change dirs.*/
   tools_dir = DIRECTORY()
   CALL DIRECTORY tmp_dir

EndTempCopy:

   /* The global ANDROID_SWT always override the SWT.Jar path */
   IF VALUE( 'ANDROID_SWT',,'OS2ENVIRONMENT' ) <> '' THEN
      swt_path = VALUE( 'ANDROID_SWT',,'OS2ENVIRONMENT' )

   IF DIRECTORY( this'\lib\'swt_path ) = '' THEN
   DO
      CALL LINEOUT 'STDERR', 'ERROR: SWT folder "'swt_path'" does not exist.'
      CALL LINEOUT 'STDERR', 'Please set ANDROID_SWT to point to the folder containing swt.jar for your platform.'
      RETURN 2
   END

SetPath:
/* Finally exec the java program and end here.
 REMOTE_DEBUG=-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=8000*/
   CALL VALUE 'PATH', VALUE( 'PATH',,'OS2ENVIRONMENT' )';'java_exe, 'OS2ENVIRONMENT'
   CALL DIRECTORY work_dir
   '@java "-Dcom.android.sdkmanager.toolsdir='work_dir'" "-Dcom.android.sdkmanager.workdir='work_dir'" -classpath "'jar_path';lib\'swt_path'\swt.jar" com.android.sdkmanager.Main 'ARG(1)
RETURN rc
   
rxCpyFile: PROCEDURE
   PARSE VALUE REVERSE( SUBSTR( ARG(2), LENGTH( ARG(1) ) + 1 ) ) WITH fname'\'fpath
   fpath = REVERSE( fpath )
   rc = rxMkDir( ARG(3)fpath )
   IF rc = 0 THEN
      rc = SysCopyObject( ARG(2), ARG(3)fpath )
RETURN rc
   
rxChk: PROCEDURE
   DO WHILE QUEUED() > 0; PARSE PULL; END;
   '@'||ARG(1)||ARG(2)||' 2>>&1 | RXQUEUE'
   DO WHILE QUEUED() > 0
      IF POS( TRANSLATE( ARG(3) ), TRANSLATE( LINEIN( 'QUEUE:' ) ) ) > 0 THEN
         IF LENGTH( ARG(4) ) > 0 THEN RETURN ARG(4)
   END
RETURN ''

rxFind: PROCEDURE EXPOSE !_msg_!.
   PARSE VALUE REVERSE( SysSearchPath( 'PATH', ARG(1) ) ) WITH .'\'fpath
   fpath = REVERSE( fpath )
   IF ARG() > 1 & LENGTH( fpath ) > 0 THEN
      fspec = rxChk( fpath'\'ARG(1), ARG(2), ARG(3), fpath )
   ELSE IF STREAM( fpath'\'ARG(1), 'C', 'QUERY EXISTS' ) <> '' THEN
      fspec = fpath
   ELSE fspec = ''
   IF LENGTH( fspec ) > 0 THEN RETURN fspec
   CALL LINEOUT 'STDERR', VALUE( 'PROGRAMS',,'OS2ENVIRONMENT' )
   CALL SysFileTree VALUE( 'PROGRAMS',,'OS2ENVIRONMENT' )||'\*'||ARG(1), 'file.', 'SFO'
   DO i = 1 TO file.0
      PARSE VALUE REVERSE( file.i ) WITH .'\'fspec
      IF ARG() > 1 THEN
         fspec = rxChk( file.i, ARG(2), ARG(3), REVERSE( fspec ) )
      ELSE
         fspec = REVERSE( fspec )
      IF LENGTH( fspec ) > 0 THEN RETURN fspec
   END
   drives = SysDriveMap( 'C:', 'USED' )
   DO j = 1 TO WORDS( drives )
      CALL LINEOUT 'STDERR', SUBWORD( drives, j, 1 )
      CALL SysFileTree SUBWORD( drives, j, 1 )||'\*'||ARG(1), 'file.', 'SFO'
      DO i = 1 TO file.0
         PARSE VALUE REVERSE( file.i ) WITH .'\'fspec
         IF ARG() > 1 THEN
            fspec = rxChk( file.i, ARG(2), ARG(3), REVERSE( fspec ) )
         ELSE
            fspec = REVERSE( fspec )
         IF LENGTH( fspec ) > 0 THEN RETURN fspec
      END
   END
RETURN ''
   
rxMkDir: PROCEDURE
    rc = ( DIRECTORY( ARG(1) ) = '' )
    IF rc = 1 THEN
        IF \rxMkDir( STRIP( FILESPEC( 'D', ARG(1) )FILESPEC( 'P', ARG(1) ), 'T', '\' ) ) THEN
           rc = SysMkDir( ARG(1) )
Return rc