/* Rexx wrapper to start Java apps */

/* Load RexxUtil Library */
IF RxFuncQuery( 'SysLoadFuncs' ) THEN
DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END

debug = 1

PARSE SOURCE . . myRexxScript
java_dir = STRIP( FILESPEC( 'D', myRexxScript )||FILESPEC( 'P', myRexxScript ), 'T', '\' )
PARSE VALUE REVERSE( myRexxScript ) WITH .'.'nls
nls = REVERSE( nls )
CALL rxLoadNLS nls

IF wpsObjectExist( '<RUN_OPENJDK>' ) = 0 THEN
DO
    IF \rxFileExist( java_dir||'\java.exe' ) THEN
    DO
        java_2_dir = rxFind( 'JAVA.EXE', ' -version', 'OPENJDK VERSION "1.' )
        DO WHILE QUEUED() > 0; PARSE PULL; END;
        IF rxFileExist( java_2_dir||'\java.exe' ) THEN
        DO
            CALL SysFileTree java_dir||'\'||nls||'*.*', 'file.', 'FO'
            DO i = 1 TO file.0
                CALL SysCopyObject file.i, java_2_dir
            END
            CALL SysCopyObject java_dir||'\Java6.ico', java_2_dir
            java_dir = java_2_dir
            myRexxScript = java_2_dir||'\'||nls||'.cmd'
            DROP java_2_dir
        END
        ELSE
            RETURN 1
    END
    CALL LINEOUT 'STDERR', RxGetMsg( 'CREATING_ICON', 'OpenJDK' )
    rc = SysCreateObject( "WPProgram", "OpenJDK", "<WP_PROMPTS>", "OBJECTID=<RUN_OPENJDK>;EXENAME="||myRexxScript||';PARAMETERS=-Xmx512m -jar "%**P\%**F";ICONFILE='||java_dir||'\java6.ico;ASSOCFILTER=*.jar;' )
END

PARSE VALUE REVERSE( ARG(1) ) WITH '"'ext'.'app'\'app_path'" raj-'.
IF LENGTH( app ) > 0 THEN
DO
    app = REVERSE( app )
    app_path = REVERSE( app_path )
    objID = TRANSLATE( app )
    IF wpsObjectExist( '<WP_'||objID||'>' ) = 0 THEN
    DO
        CALL CHAROUT 'STDERR', RxGetMsg( 'CREATE_OBJECT', app )
        PARSE UPPER PULL answer
        IF answer <> RxGetMsg( 'NO' ) THEN
        DO
            CALL LINEOUT 'STDERR', RxGetMsg( 'CREATING_ICON', app )
            rc = SysCreateObject( "WPProgram", app, "<WP_DESKTOP>", "EXENAME="||myRexxScript||";PROGTYPE=PROG_WINDOWABLEVIO;PARAMETERS="||ARG(1)||";STARTUPDIR="||TRANSLATE( app_path )||";MINIMIZED=YES;OBJECTID=<WP_"||objID||">;ICONFILE="||app_path||"\"||app||".ico;" )
        END
    END
END

CALL VALUE 'PATH', java_dir||';'||VALUE( 'PATH',, 'OS2ENVIRONMENT' ), 'OS2ENVIRONMENT'
IF RxFuncQuery( 'SysSetExtLibPath ' ) Then
    '@SET BEGINLIBPATH='||java_dir||';%BEGINLIBPATH%'
ELSE
    CALL SysSetExtLibPath java_dir||';'||SysQueryExtLIBPATH( 'B' ), 'B'
IF debug = 1 THEN
DO
  err_file = SysTempFileName( 'Error_???.err' )
  out_file = SysTempFileName( 'Message_???.out' )
  '@JAVA '||ARG(1)||' 2>'||err_file||' 1>'||out_file
END
ELSE
  '@JAVA '||ARG(1)
RETURN rc

/* Code borrowed from REXX Tips & Tricks v3.60 */
wpsObjectExist: PROCEDURE /* parameter: '<new_wps_object_id>', return: 1 exist, 0 doesn't exist, 43 error */
  PARSE ARG objID
  rc = 43               /* init return/error code 43 = routine not found */
  SIGNAL ON SYNTAX NAME ObjectExistError

  IF SUBSTR( objID, 2, 1 ) <> ":" THEN
    IF LEFT( objID, 1 ) <> "<" & RIGHT( objID, 1 ) <> ">" THEN
      objID = "<" || objID || ">"

  /* create the object and see if it fail */
  tempRC = SysCreateObject( "WPFolder", "TestObject", "<WP_NOWHERE>", "OBJECTID=" || objID || ";", "FAIL" )

  IF tempRC = 1 THEN
  DO
    CALL SysDestroyObject objID
    rc = 0
  END
  ELSE
    rc = 1

ObjectExistError:

RETURN rc

rxChk: PROCEDURE
 DO WHILE QUEUED() > 0; PARSE PULL; END;
 '@'||ARG(1)||ARG(2)||' 2>>&1 | RXQUEUE'
 DO WHILE QUEUED() > 0
    IF POS( TRANSLATE( ARG(3) ), TRANSLATE( LINEIN( 'QUEUE:' ) ) ) > 0 THEN
       IF LENGTH( ARG(4) ) > 0 THEN RETURN ARG(4)
 END
RETURN ''

rxFind: PROCEDURE EXPOSE !_msg_!.
 CALL LINEOUT 'STDERR', rxGetMsg( 'searching_for', 'PATH' )
 PARSE VALUE REVERSE( SysSearchPath( 'PATH', ARG(1) ) ) WITH .'\'fpath
 fpath = REVERSE( fpath )
 fspec = rxChk( ARG(1), ARG(2), ARG(3), fpath )
 IF LENGTH( fspec ) > 0 THEN RETURN fspec
 CALL LINEOUT 'STDERR', rxGetMsg( 'searching_for', VALUE 'PROGRAMS',,'OS2ENVIRONMENT' ) )
 CALL SysFileTree VALUE 'PROGRAMS',,'OS2ENVIRONMENT' )||'\*'||ARG(1), 'file.', 'SFO'
 DO i = 1 TO file.0
    CALL DIRECTORY STRIP( FILESPEC( 'D', file.i )||FILESPEC( 'P', file.i ), 'T', '\' )
    fspec = rxChk( ARG(1), ARG(2), ARG(3), DIRECTORY() )
    IF LENGTH( fspec ) > 0 THEN RETURN fspec
 END
 drives = SysDriveMap( 'C:', 'USED' )
 DO j = 1 TO WORDS( drives )
   CALL LINEOUT 'STDERR', rxGetMsg( 'searching_for',  SUBWORD( drives, j, 1 ) )
   CALL SysFileTree SUBWORD( drives, j, 1 )||'\*'||ARG(1), 'file.', 'SFO'
   DO i = 1 TO file.0
      CALL DIRECTORY STRIP( FILESPEC( 'D', file.i )||FILESPEC( 'P', file.i ), 'T', '\' )
      fspec = rxChk( ARG(1), ARG(2), ARG(3), DIRECTORY() )
      IF LENGTH( fspec ) > 0 THEN RETURN fspec
   END
 END
 CALL CHAROUT 'STDERR', rxGetMsg( 'not_found' )
 PARSE PULL fspec
RETURN fspec

rxLoadNLS: PROCEDURE EXPOSE !_msg_!.
    PARSE ARG !_nls_!, !_lang_!
    IF !_nls_! = '' THEN
        !_nls_! = 'NLS.'
    !_nls_! = STRIP( ARG(1), 'T', '.' )||'.'
    IF !_lang_! = '' THEN
        !_lang_! = VALUE( 'LANG',, 'OS2ENVIRONMENT' )
    IF \rxFileExist( !_nls_!||!_lang_! ) THEN
        !_lang_! = 'EN_US'
    tot_size = STREAM( !_nls_!||!_lang_!, 'C', 'QUERY SIZE' )
    !_input_! = ''
    DO WHILE LINES( !_nls_!||!_lang_! ) > 0
        !_input_! = !_input_!||LINEIN( !_nls_!||!_lang_! )
        IF RIGHT( !_input_!, 1 ) = ',' THEN
            !_input_! = LEFT( !_input_!, LENGTH( !_input_! ) - 1 )||'||'
        ELSE
        DO
            PARSE VALUE !_input_! WITH !_pre_!' = '!_post_!
            !_input_! = ''
        END
        IF LENGTH( !_pre_! ) > 0 THEN
            INTERPRET '!_msg_!.!_'!_pre_!'_! = !_post_!'
    END
    CALL STREAM !_nls_!||!_lang_!, 'C', 'CLOSE'
RETURN 0

RxGetMsg: PROCEDURE EXPOSE !_msg_!.
    INTERPRET 'retval = '||VALUE( '!_msg_!.!_'||ARG(1)||'_!' )
RETURN retval

rxFileExist: PROCEDURE
RETURN STREAM( ARG(1), 'C','QUERY EXISTS') <> ''
