package printing;

import java.awt.*;
import java.awt.print.*;
import java.io.*;
class PrintPainter implements Printable {
	private java.io.RandomAccessFile raf = null;
	private String fileName, title;
	private boolean wrap = false;
	private Font fnt = null;
	private int rememberedPageIndex = -1;
	private long rememberedFilePointer = -1;
	private boolean rememberedEOF = false;
	int[] pratr = {12, 24, 60};
/**
 * Insert the method's description here.
 * Creation date: (11-04-14 6:46:24 am)
 * @param file java.lang.String
 * @param title java.lang.String
 * @param wrap boolean
 * @param prfont java.lang.String
 */
public PrintPainter(String file, String title, boolean wrap, String prfont) {
	fileName = file;
	this.title = title;
	this.wrap = wrap;
	if (prfont.equals("6")) {
		fnt = new Font("Courier", Font.PLAIN, 6);
		pratr[0] = 6;
		pratr[1] = 12;
		pratr[2] = 120;
	} else
		if (prfont.equals("8")) {
			fnt = new Font("Courier", Font.PLAIN, 8);
			pratr[0] = 8;
			pratr[1] = 16;
			pratr[2] = 90;
		} else
			if (prfont.equals("10")) {
				fnt = new Font("Courier", Font.PLAIN, 10);
				pratr[0] = 10;
				pratr[1] = 20;
				pratr[2] = 75;
			} else
				if (prfont.equals("14")) {
					fnt = new Font("Courier", Font.PLAIN, 14);
					pratr[0] = 14;
					pratr[1] = 28;
					pratr[2] = 52;
				} else {
					fnt = new Font("Courier", Font.PLAIN, 12);
					pratr[0] = 12;
					pratr[1] = 24;
					pratr[2] = 60;
				}
}
public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
	FileInputStream fs = null;
	if (title.length() > pratr[2])
		title = title.substring(0, pratr[2]);
	try {
		if (raf == null) {
			try {
				raf = new java.io.RandomAccessFile(fileName, "r");
			} catch (Exception e) {
				rememberedEOF = true;
			}
		}
		if (pageIndex != rememberedPageIndex) {
			rememberedPageIndex = pageIndex;
			if (rememberedEOF) {
				try {
					raf.close();
				} catch (Exception ee) {
				}
				return Printable.NO_SUCH_PAGE;
			}
			rememberedFilePointer = raf.getFilePointer();
		} else {
			raf.seek(rememberedFilePointer);
		}
		g.setColor(Color.black);
		g.setFont(fnt);
		int x = (int) pf.getImageableX();
		int y = (int) pf.getImageableY() + pratr[0];
		g.drawString(title + ", page: " + (pageIndex + 1), x, y);
		y += pratr[1];
		while (y + pratr[0] < pf.getImageableY() + pf.getImageableHeight()) {
			String line = read();
			if (line == null) {
				rememberedEOF = true;
				break;
			}
			g.drawString(line, x, y);
			y += pratr[0];
		}
		return Printable.PAGE_EXISTS;
	} catch (Exception e) {
		return Printable.NO_SUCH_PAGE;
	}
}
/**
 * Insert the method's description here.
 * Creation date: (11-04-13 6:38:25 pm)
 * @return java.lang.String
 */
public String read() {
	boolean data = false;
	String s = "";
	boolean more = true;
	int w = 0;
	try {
		long len = raf.length();
		while (more) {
			long pos = raf.getFilePointer();
			if (pos + 1 < len) {
				data = true;
				byte[] b = new byte[1];
				b[0] = raf.readByte();
				if (b[0] == '\n') {
					more = false;
				} else
					if (b[0] != '\r') {
						s = s + new String(b);
						w++;
					}
			} else {
				more = false;
			}
			if (wrap && w > pratr[2])
				more = false;
		}
	} catch (Exception e) {
	}
	if (!data)
		return null;
	return s;
}
}
