/*
	FM/2 installation utility
	
	Deletes obsolete files (eventually), INI file entries and icons (eventually)

	Usage:
		cleanup [FM/2 version]
		
	**Not yet supported**
	If a properly formed FM/2 version is not supplied on the command line:
		1) Interactive mode is used (to deter curious users from
		   doing damaged unintendedly)
		2) The version is retrieved from the Warpin database
	**Not yet supported**
		
*/

signal on novalue
i = 0

/*
 * Ini deletions: How to add
 * 	1) Copy one of the following lines
 * 	2) Change the portion between the pair of single quotes. There should be two space-delimited
 * 		strings following INIDEL
 * 		a) The first string is for the INI file application name
 * 		b) The second string is for the INI file key name
 * 		c) Both strings support a trailing '*' for a mask
 * Examples:
 * 	INIDEL appname keyname		<-- delete key named keyname in application named appname
 * 	INIDEL appname *				<-- delete application named appname
 * 	INIDEL * keyname				<-- delete key named keyname in ALL applications
 * 	INIDEL appname keymask* 	<-- delete keys starting with keymask in application named appname
 * 	INIDEL appmask* keyname 	<-- delete keys named keyname in all applications starting with appmask
 * 	INIDEL appmask* keymask*	<-- delete keys starting with keymask in all applications starting with appmask
 * 	INIDEL * *                 <-- THIS DELETES the entire file!!
 */
i=i+1;actionlist.i='INIDEL * ShutdownState.*';
i=i+1;actionlist.i='INIDEL * FM2_Temp.*';
i=i+1;actionlist.i='INIDEL * LastClose.*';

/*
 * Ini key renaming/moving
 * 	1) Copy one of the following lines
 * 	2) Change the portion between the pair of single quotes. There should be three space-delimited
 * 		strings following INIRENAME
 * 		b) The first string is for the INI file application name
 * 		c) The second string is for the INI file key name
 * 		d) The third string is for the new INI file key name
 * 		e) The second and third strings support a trailing '*' for a mask. If one has a '*' then
 *          the other must also have a '*'.
 * Examples:
 * 	INIRENAME appname keyname newkeyname		<-- rename/move appname/keyname to appname/newkeyname
 * 	INIRENAME appname oldprefix* newprefix*   <-- rename/move all keys starting with oldprefix under
 * 	                                              appname to new keys starting with newprefix (under appname)
 */
i=i+1;actionlist.i='INIRENAME * Details* DirCnr.Details*';
i=i+1;actionlist.i='INIRENAME * Subject* DirCnr.Subject*';

actionlist.0 = i
call SysStemSort 'actionlist.'

globals = 'actionlist. fm2. interactive'

parse arg args
call Init strip(args)
call ProcessIniActions
return

Init: procedure expose (globals)
   call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
   call SysLoadFuncs

   parse arg ver
   if ver == '' then
      call ErrorExit 5
   ver = translate(ver, '\', '-')
	
	interactive = 1
	interactive = 0 /* debug */

   warpin_path = strip(SysIni(, 'WarpIN', 'Path'), 'T', '00'x)
   if warpin_path = 'ERROR:' then
      call ErrorExit 1
   database_file = warpin_path || '\DATBAS_' || left(SysBootDrive(), 1) || '.INI'
   if stream(database_file, 'c', 'query exists') == '' then
      call ErrorExit 2
   do 4
     parse var ver '\' major '\' minor '\' sublevel '\' revision
     if revision = '' then
       ver = ver || '\0'
     else
       leave
   end
   fm2_base_prefix = 'Netlabs\FM2\Base'
   fm2_base_app = fm2_base_prefix || ver
   fm2.directory = strip(SysIni(database_file, fm2_base_app, 'TargetPath'), 'T', '0'x)
   if fm2.directory == 'ERROR:' then
      call ErrorExit 3
	fm2.ini.filename = fm2.directory || '\fm3.ini'
   fm2.version = ver
return

ProcessIniActions: procedure expose (globals)
	retval = 0
   AppMask = ''
   AppMaskLen = 0
   KeyMask = ''
   KeyMaskLen = 0
   NewKey = ''
	call LoadIni
   do i = 1 to actionlist.0
      parse upper var actionlist.i type app key .
      select
         when type = 'INIDEL' then
            do
            	if app = '*' & key = '*' then
            		do
            			'del 'fm2.ini.filefilename
            			if rc \= 0 then
            				retval = -1
            			else
            				retval = 1
            			return retval	
            		end
        		end
         when type = 'INIRENAME' then
            do
	            parse var actionlist.i . . . newkey
	         end
      	otherwise
      		nop
      end
   	pAppStar = pos('*', app)
   	if pAppStar \= 0 then
   		do
   			AppMaskLen = pAppStar - 1
   			if AppMaskLen > 1 then
   				AppMask = left(app, AppMaskLen)
   		end
   	pKeyStar = pos('*', key)
   	if pKeyStar \= 0 then
   		do
   			KeyMaskLen = pKeyStar - 1
   			if KeyMaskLen > 1 then
   				KeyMask = left(key, KeyMaskLen)
   		end			
   	do a = 1 to fm2.ini.apps.0
   		if MatchFound(fm2.ini.apps.a.upper, app, pAppStar, AppMaskLen, AppMask) = 1 then
   			if pKeyStar \= 0 & KeyMaskLen = 0 then
   				if type = 'INIDEL' then
   					do
   						call ReportAction key
   						call SysIni fm2.ini.filename, fm2.ini.apps.a, 'DELETE:'
   					end
   				else
         			do k = 1 to fm2.ini.apps.a.keys.0
        					call IniAction
         			end
   			else
      			do k = 1 to fm2.ini.apps.a.keys.0
      				match = MatchFound(fm2.ini.apps.a.keys.k.upper, key, pKeyStar, KeyMaskLen, KeyMask)
      				if match = 0 then
      					leave
      				else
      					if match = 1 then
      						call IniAction
      			end
   	end
   end
return

IniAction: /* NOT a procedure so it has access to calloing routines variables! */	
	call ReportAction fm2.ini.apps.a.keys.k
   select
      when type = 'INIDEL' then
         do
            retval = SysIni(fm2.ini.filename, fm2.ini.apps.a, fm2.ini.apps.a.keys.k, 'DELETE:')
         end
      when type = 'INIRENAME' then
         do
            keyval = SysIni(fm2.ini.filename, fm2.ini.apps.a, fm2.ini.apps.a.keys.k)
            pNewKeyStar = pos('*', newkey)
            if pNewKeyStar \= 0 then
               if pKeyStar \= 0 then
                  do
                     fullnewkey = left(newkey, pNewKeyStar - 1) || substr(fm2.ini.apps.a.keys.k, pKeyStar)
                  end
               else
                  call ErrorExit 4
            else
               if pKeyStar \= 0 then
                  call ErrorExit 4
               else
                  fullnewkey = newkey
            retval = SysIni(fm2.ini.filename, fm2.ini.apps.a, fm2.ini.apps.a.keys.k, 'DELETE:')
            retval = SysIni(fm2.ini.filename, fm2.ini.apps.a, fullnewkey, keyval)
         end
      otherwise
         say i': Invalid type encountered: 'actionlist.i.type
   end
return
	
LoadIni: procedure expose (globals)
	call SysIni fm2.ini.filename, 'ALL:', 'fm2.ini.apps.'
	do i = 1 to fm2.ini.apps.0
		fm2.ini.apps.i.upper = translate(fm2.ini.apps.i)
		call SysIni fm2.ini.filename, fm2.ini.apps.i, 'ALL:', 'keylist.'
		call SysStemSort 'keylist.'
		do j = 1 to keylist.0
			fm2.ini.apps.i.keys.j = keylist.j
			fm2.ini.apps.i.keys.j.upper = translate(keylist.j)
		end
		fm2.ini.apps.i.keys.0 = keylist.0
	end
return

MatchFound: procedure
	parse arg matchto, matchwith, usemask, masklen, mask
	if usemask \= 0 then 						/* if there's a mask */
		if masklen = 0 then						/* mask is '*' */
			return 1
		else											/* mask is not '*' */
			if left(matchto, masklen) = mask then
				return 1
			else
				if left(matchto, masklen) < mask then
					return -1
				else
					return 0
	else
		if matchto = matchwith then
			return 1
		else
			if matchto < matchwith then
				return -1
			else
				return 0

ReportAction: /* NOT a procedure! */
	parse arg reportkey
	say 'Action :' actionlist.i
	say '  App:' fm2.ini.apps.a
	say '  Key:' reportkey
return

ErrorExit: procedure expose (globals)
	parse arg errcode
	if interactive = 0 then
   	select
   		when errcode = 1 then
  				say 'Warpin is no longer installed1'
   		when errcode = 2 then
  				say 'Unable to find Warpin database!'
   		when errcode = 3 then
  				say 'Unable to find Warpin-installed FM/2!'
   		when errcode = 4 then
				say 'INIRENAME with mismatched wildcards!!'
   		when errcode = 5 then
				say 'Interactive mode not yet supported...'
			otherwise
   			say 'Unknown error.'
   	end
	say 'Aborting cleanup...'
exit errcode

novalue:
	say 'No value encountered on line: 'sigl
	say 'Text: 'sourceline(sigl)
	exit

