#define INCL_BASE
#define INCL_DOSDEVIOCTL
#include <os2.h>

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


USHORT GetSectorSize(UCHAR ucDrive)
{
    FSALLOCATE fs={0};
    APIRET rc;
    int uDrive;

    uDrive = toupper(ucDrive) - 'A' + 1;
    rc = DosQueryFSInfo(uDrive,FSIL_ALLOC,&fs,sizeof(fs));
    if (rc == NO_ERROR)
    {
        return fs.cbSector;
    }
    else
    {
        return 0;
    }
}

ULONG LockDrive(HFILE hDrive)
{
    UCHAR cmd=0;
    UCHAR data=0;
    ULONG ulp = sizeof(cmd);
    ULONG uld = sizeof(data);

    return DosDevIOCtl(
                        hDrive,
                        IOCTL_DISK,
                        DSK_LOCKDRIVE,
                        &cmd,
                        ulp,
                        &ulp,
                        &data,
                        uld,
                        &uld);
}

ULONG UnlockDrive(HFILE hDrive)
{
    UCHAR cmd=0;
    UCHAR data=0;
    ULONG ulp = sizeof(cmd);
    ULONG uld = sizeof(data);

    return DosDevIOCtl(
                        hDrive,
                        IOCTL_DISK,
                        DSK_UNLOCKDRIVE,
                        &cmd,
                        ulp,
                        &ulp,
                        &data,
                        uld,
                        &uld);
}

PCHAR AllocDataBuffer(UCHAR ucDrive,ULONG ulEntities,PULONG pulFactor,ULONG ulFlag)
{
    APIRET rc= NO_ERROR;
    PVOID pBuf=NULL;

    if (ulFlag)
    {
        *pulFactor = GetSectorSize(ucDrive);
    }
    else
    {
        *pulFactor = 1;
    }

    printf("Allocating %d bytes of memory\n",*pulFactor * ulEntities);
    rc = DosAllocMem(&pBuf,*pulFactor * ulEntities,PAG_COMMIT|PAG_READ|PAG_WRITE);
    if (rc == NO_ERROR)
    {
        memset(pBuf,0xFF,*pulFactor * ulEntities);
        return (PCHAR)pBuf;
    }
    else
    {
        return NULL;
    }
}

VOID DeallocDataBuffer(PCHAR pBuf)
{
    if (pBuf)
    {
        DosFreeMem(pBuf);
    }
}

APIRET MyDosOpen(PSZ pszDrive,PHFILE phDrive,BOOL fFlag)
{
    APIRET  rc;
    ULONG   ulAction;

    rc = DosOpen(
                    pszDrive,
                    phDrive,
                    &ulAction,
                    0UL,
                    FILE_NORMAL,
                    OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_FAIL_IF_NEW,
                    OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE | OPEN_FLAGS_DASD,
                    NULL);

    if ((rc == NO_ERROR) && fFlag)
    {
#define FSCTL_SECTORIO 0x00009014
#define MAGIC_SECTORIO 0xDEADFACE

        ULONG pwd   = MAGIC_SECTORIO;
        PBYTE ppwd  = (PBYTE)&pwd;
        ULONG rdl   = 0UL;
        ULONG lpwd  = sizeof(ppwd);

        rc = DosFSCtl(
                        NULL,
                        0UL,
                        &rdl,
                        ppwd,
                        sizeof(ppwd),
                        &lpwd,
                        FSCTL_SECTORIO,
                        NULL,
                        *phDrive,
                        FSCTL_HANDLE);
    }
    return rc;
}

APIRET MyDosClose(HFILE hDrive)
{
    return DosClose(hDrive);
}

int main(int argc,char *argv[])
{
    HFILE hDrive = NULLHANDLE;
    ULONG ulAction = 0UL;
    APIRET rc = NO_ERROR;
    int aDrive = 0;
    int aFlag  = 0;
    int aEntities = 0;
    ULONG ulEntities;
    BOOL ulFlag;
    UCHAR ucDrive;

    if (argc != 4)
    {
        printf("Usage: %s [Drive:] [NumEntities] [SectorIOFlag]\n",argv[0]);
        return 1;
    }

    aDrive = sscanf(argv[1],"%c:",&ucDrive);
    aEntities = sscanf(argv[2],"%d",&ulEntities);
    aFlag  = sscanf(argv[3],"%d",&ulFlag);

    if (aDrive && aFlag && aEntities)
    {
        rc = MyDosOpen(
                    argv[1],
                    &hDrive,
                    ulFlag
                    );

        if (rc == NO_ERROR)
        {
            ULONG ulRead = 0UL;
            PCHAR pBuf=NULL;
            ULONG ulFactor = 0UL;

            pBuf = AllocDataBuffer(ucDrive,ulEntities,&ulFactor,ulFlag);

            if (pBuf)
            {
                rc = LockDrive(hDrive);

                rc = DosRead(hDrive,pBuf,ulEntities,&ulRead);

                if (rc == NO_ERROR && ulRead)
                {
                    printf("Successfully read %d Bytes\n",ulRead*ulFactor);
                    if ((ulRead * ulFactor) >= sizeof(ULONG))
                    {
                        printf("Start DWORD:%#.8x, End DWORD:%#.8x\n",*(PULONG)pBuf,*(PULONG)(pBuf+ulRead*ulFactor-sizeof(ULONG)));
                    }
                }
                else
                {
                    printf("DosRead returned with rc=%d\n",rc);
                }

                rc = UnlockDrive(hDrive);

            }

            DeallocDataBuffer(pBuf);

            rc = MyDosClose(hDrive);
        }
        return 0;
    }
    return 1;
}
