/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20131115-32 [Nov 28 2013]
 * Copyright (c) 2000 - 2013 Intel Corporation
 * 
 * Disassembly of , Mon May 19 20:47:48 2014
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x00008F1C (36636)
 *     Revision         0x02
 *     Checksum         0x80
 *     OEM ID           "ALASKA"
 *     OEM Table ID     "A M I"
 *     OEM Revision     0x00000000 (0)
 *     Compiler ID      "INTL"
 *     Compiler Version 0x20051117 (537202967)
 */
DefinitionBlock ("DSDT.aml", "DSDT", 2, "ALASKA", "A M I", 0x00000000)
{
    Name (SP1O, 0x2E)
    Name (IO1B, 0x0290)
    Name (IO1L, 0x10)
    Name (IOCB, 0x0230)
    Name (IOCL, 0x10)
    Name (IOWB, 0x0240)
    Name (IOWL, 0x10)
    Name (IOES, 0xFF)
    Name (SL2P, Zero)
    Name (SMBB, 0x0B20)
    Name (SMBL, 0x20)
    Name (SMB0, 0x0B00)
    Name (SMBM, 0x10)
    Name (PMBS, 0x0800)
    Name (PMLN, 0xA0)
    Name (SMIO, 0xB2)
    Name (GPBS, Zero)
    Name (GPLN, Zero)
    Name (APCB, 0xFEC00000)
    Name (APCL, 0x1000)
    Name (SPIB, 0xFEC10000)
    Name (SPIL, 0x1000)
    Name (HPTB, 0xFED00000)
    Name (HPTL, 0x1000)
    Name (GIOB, 0xFED80100)
    Name (IOMB, 0xFED80D00)
    Name (SMIB, 0xFED80200)
    Name (ACPH, 0xDE)
    Name (ASSB, Zero)
    Name (AOTB, Zero)
    Name (AAXB, Zero)
    Name (PEHP, Zero)
    Name (SHPC, Zero)
    Name (PEPM, One)
    Name (PEER, One)
    Name (PECS, One)
    Name (ITKE, Zero)
    Name (MBEC, 0xFFFF)
    Name (PEBS, 0xE0000000)
    Name (PEBL, 0x10000000)
    Name (SRSI, 0xB2)
    Name (CSMI, 0x61)
    Name (SBA1, 0x0B00)
    Name (SBA2, 0x0B20)
    Name (SIOP, 0x2E)
    Name (AODS, 0xF5)
    Name (SMIP, 0xB2)
    Name (HIDK, 0x0303D041)
    Name (HIDM, 0x030FD041)
    Name (CIDK, 0x0B03D041)
    Name (CIDM, 0x130FD041)
    Name (PICM, Zero)
    Method (_PIC, 1, NotSerialized)  // _PIC: Interrupt Model
    {
        If (Arg0)
        {
            Store (0xAA, DBG8)
            \_SB.IRQC ()
        }
        Else
        {
            Store (0xAC, DBG8)
        }

        Store (Arg0, PICM)
    }

    Name (OSVR, Ones)
    Method (OSFL, 0, NotSerialized)
    {
        If (LNotEqual (OSVR, Ones))
        {
            Return (OSVR)
        }

        If (LEqual (PICM, Zero))
        {
            Store (0xAC, DBG8)
        }

        Store (One, OSVR)
        If (CondRefOf (_OSI, Local0))
        {
            If (_OSI ("Linux"))
            {
                Store (0x03, OSVR)
            }

            If (_OSI ("Windows 2001"))
            {
                Store (0x04, OSVR)
            }

            If (_OSI ("Windows 2001.1"))
            {
                Store (0x05, OSVR)
            }

            If (_OSI ("FreeBSD"))
            {
                Store (0x06, OSVR)
            }

            If (_OSI ("HP-UX"))
            {
                Store (0x07, OSVR)
            }

            If (_OSI ("OpenVMS"))
            {
                Store (0x08, OSVR)
            }

            If (_OSI ("Windows 2001 SP1"))
            {
                Store (0x09, OSVR)
            }

            If (_OSI ("Windows 2001 SP2"))
            {
                Store (0x0A, OSVR)
            }

            If (_OSI ("Windows 2001 SP3"))
            {
                Store (0x0B, OSVR)
            }

            If (_OSI ("Windows 2006"))
            {
                Store (0x0C, OSVR)
            }

            If (_OSI ("Windows 2006 SP1"))
            {
                Store (0x0D, OSVR)
            }

            If (_OSI ("Windows 2009"))
            {
                Store (0x0E, OSVR)
            }

            If (_OSI ("Windows 2012"))
            {
                Store (0x0F, OSVR)
            }
        }
        Else
        {
            If (MCTH (_OS, "Microsoft Windows NT"))
            {
                Store (Zero, OSVR)
            }

            If (MCTH (_OS, "Microsoft Windows"))
            {
                Store (One, OSVR)
            }

            If (MCTH (_OS, "Microsoft WindowsME: Millennium Edition"))
            {
                Store (0x02, OSVR)
            }

            If (MCTH (_OS, "Linux"))
            {
                Store (0x03, OSVR)
            }

            If (MCTH (_OS, "FreeBSD"))
            {
                Store (0x06, OSVR)
            }

            If (MCTH (_OS, "HP-UX"))
            {
                Store (0x07, OSVR)
            }

            If (MCTH (_OS, "OpenVMS"))
            {
                Store (0x08, OSVR)
            }
        }

        Return (OSVR)
    }

    Method (MCTH, 2, NotSerialized)
    {
        If (LLess (SizeOf (Arg0), SizeOf (Arg1)))
        {
            Return (Zero)
        }

        Add (SizeOf (Arg0), One, Local0)
        Name (BUF0, Buffer (Local0) {})
        Name (BUF1, Buffer (Local0) {})
        Store (Arg0, BUF0)
        Store (Arg1, BUF1)
        While (Local0)
        {
            Decrement (Local0)
            If (LNotEqual (DerefOf (Index (BUF0, Local0)), DerefOf (Index (
                BUF1, Local0))))
            {
                Return (Zero)
            }
        }

        Return (One)
    }

    Name (PRWP, Package (0x02)
    {
        Zero, 
        Zero
    })
    Method (GPRW, 2, NotSerialized)
    {
        Store (Arg0, Index (PRWP, Zero))
        Store (ShiftLeft (SS1, One), Local0)
        Or (Local0, ShiftLeft (SS2, 0x02), Local0)
        Or (Local0, ShiftLeft (SS3, 0x03), Local0)
        Or (Local0, ShiftLeft (SS4, 0x04), Local0)
        If (And (ShiftLeft (One, Arg1), Local0))
        {
            Store (Arg1, Index (PRWP, One))
        }
        Else
        {
            ShiftRight (Local0, One, Local0)
            If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
            {
                FindSetLeftBit (Local0, Index (PRWP, One))
            }
            Else
            {
                FindSetRightBit (Local0, Index (PRWP, One))
            }
        }

        Return (PRWP)
    }

    Name (WAKP, Package (0x02)
    {
        Zero, 
        Zero
    })
    OperationRegion (DEB0, SystemIO, 0x80, One)
    Field (DEB0, ByteAcc, NoLock, Preserve)
    {
        DBG8,   8
    }

    OperationRegion (DEB1, SystemIO, 0x90, 0x02)
    Field (DEB1, WordAcc, NoLock, Preserve)
    {
        DBG9,   16
    }

    Name (SS1, Zero)
    Name (SS2, Zero)
    Name (SS3, One)
    Name (SS4, One)
    Name (IOST, 0x0001)
    Name (TOPM, 0x00000000)
    Name (ROMS, 0xFFE00000)
    Name (VGAF, One)
    Name (OSTY, Ones)
    OperationRegion (ACMS, SystemIO, 0x72, 0x10)
    Field (ACMS, ByteAcc, NoLock, Preserve)
    {
        ICMS,   8, 
        DCMS,   8, 
        Offset (0x0E), 
        P80,    8
    }

    IndexField (ICMS, DCMS, ByteAcc, NoLock, Preserve)
    {
        Offset (0x08), 
        BS_A,   32
    }

    OperationRegion (CFGS, SystemMemory, BS_A, 0x0100)
    Field (CFGS, AnyAcc, NoLock, Preserve)
    {
        Offset (0x0C), 
        PCIE,   32, 
        Offset (0x7F), 
            ,   5, 
        GGN2,   1, 
        Offset (0x87), 
        GECE,   1, 
        IR_E,   1, 
        Offset (0x93), 
            ,   5, 
        OSCF,   1, 
        Offset (0x9E), 
        PRS0,   1, 
        DET0,   1, 
        Offset (0xA2), 
        PRS1,   1, 
        DET1,   1, 
        Offset (0xA6), 
        PRS2,   1, 
        DET2,   1, 
        Offset (0xAA), 
        PRS3,   1, 
        DET3,   1, 
        Offset (0xB2), 
            ,   6, 
        ABPS,   1, 
            ,   3, 
        GPPS,   1
    }

    OperationRegion (CMPT, SystemIO, 0x0C50, 0x03)
    Field (CMPT, ByteAcc, NoLock, Preserve)
    {
        CMID,   8, 
            ,   6, 
        GPCT,   2, 
        GP0I,   1, 
        GP1I,   1, 
        GP2I,   1, 
        GP3I,   1, 
        GP4I,   1, 
        GP5I,   1, 
        GP6I,   1, 
        GP7I,   1
    }

    OperationRegion (PCFG, SystemMemory, PCIE, 0x02000000)
    Field (PCFG, AnyAcc, NoLock, Preserve)
    {
        Offset (0x20078), 
        Offset (0x2007A), 
        PMSA,   1, 
        Offset (0x28078), 
        Offset (0x2807A), 
        PMSB,   1, 
        Offset (0x48078), 
        Offset (0x4807A), 
        PMSC,   1, 
        Offset (0x8800A), 
        STCL,   16, 
        Offset (0xA0004), 
        SMIE,   1, 
        SMME,   1, 
        Offset (0xA0008), 
        RVID,   8, 
        Offset (0xA0014), 
        SMB1,   32, 
        Offset (0xA0082), 
            ,   2, 
        G31O,   1, 
        Offset (0xA00E1), 
            ,   6, 
        ACIR,   1, 
        Offset (0xA4004), 
        PCMD,   2, 
        Offset (0xA807A), 
        PMS0,   1, 
        Offset (0xA8088), 
        TLS0,   4, 
        Offset (0xA907A), 
        PMS1,   1, 
        Offset (0xA9088), 
        TLS1,   4, 
        Offset (0xAA07A), 
        PMS2,   1, 
        Offset (0xAA088), 
        TLS2,   4, 
        Offset (0xAB07A), 
        PMS3,   1, 
        Offset (0xAB088), 
        TLS3,   4
    }

    OperationRegion (PMIO, SystemIO, 0x0CD6, 0x02)
    Field (PMIO, ByteAcc, NoLock, Preserve)
    {
        INPM,   8, 
        DAPM,   8
    }

    IndexField (INPM, DAPM, ByteAcc, NoLock, Preserve)
    {
        Offset (0x24), 
        MMSO,   32, 
        Offset (0x60), 
        P1EB,   16
    }

    OperationRegion (ERMM, SystemMemory, MMSO, 0x1000)
    Field (ERMM, AnyAcc, NoLock, Preserve)
    {
        Offset (0x132), 
            ,   7, 
        GP51,   1, 
        Offset (0x136), 
            ,   7, 
        GP55,   1, 
        Offset (0x13A), 
            ,   7, 
        GP59,   1, 
        Offset (0x13D), 
        GP62,   8, 
        Offset (0x13F), 
            ,   7, 
        GP64,   1, 
        Offset (0x16A), 
            ,   7, 
        GE11,   1, 
            ,   7, 
        GE12,   1, 
        Offset (0x16E), 
            ,   7, 
        BATS,   1, 
        Offset (0x287), 
            ,   1, 
        CLPS,   1, 
        Offset (0x298), 
            ,   7, 
        G15A,   1, 
        Offset (0x2AF), 
            ,   2, 
        SLPS,   2, 
        Offset (0x376), 
        EPNM,   1, 
        DPPF,   1, 
        Offset (0x3BA), 
            ,   6, 
        PWDE,   1, 
        Offset (0x3BD), 
            ,   5, 
        ALLS,   1, 
        Offset (0x3EF), 
        PHYD,   1, 
            ,   1, 
            ,   1, 
        US5R,   1, 
        Offset (0x3F5), 
        GECD,   1
    }

    OperationRegion (ABIO, SystemIO, 0x0CD8, 0x08)
    Field (ABIO, DWordAcc, NoLock, Preserve)
    {
        INAB,   32, 
        DAAB,   32
    }

    Method (RDAB, 1, NotSerialized)
    {
        Store (Arg0, INAB)
        Return (DAAB)
    }

    Method (WTAB, 2, NotSerialized)
    {
        Store (Arg0, INAB)
        Store (Arg1, DAAB)
    }

    Method (RWAB, 3, NotSerialized)
    {
        And (RDAB (Arg0), Arg1, Local0)
        Or (Local0, Arg2, Local1)
        WTAB (Arg0, Local1)
    }

    Method (CABR, 3, NotSerialized)
    {
        ShiftLeft (Arg0, 0x05, Local0)
        Add (Local0, Arg1, Local1)
        ShiftLeft (Local1, 0x18, Local2)
        Add (Local2, Arg2, Local3)
        Return (Local3)
    }

    Method (GENC, 0, NotSerialized)
    {
        Store (Zero, Local0)
        While (LLess (Local0, 0x04))
        {
            Store (RDAB (CABR (0x03, Local0, 0xA4)), Local1)
            And (Local1, 0x0800, Local1)
            If (LNotEqual (Local1, Zero))
            {
                Return (0x0F)
            }

            Increment (Local0)
            Stall (0xC8)
        }

        Return (Zero)
    }

    Method (GHPS, 2, NotSerialized)
    {
        If (LEqual (Arg0, Zero))
        {
            If (LEqual (Arg1, Zero))
            {
                RWAB (CABR (0x06, Zero, 0xC0), 0xFFFFEFFF, Zero)
                RWAB (CABR (One, Zero, 0x65), 0xFFFFFEFE, Zero)
                Store (One, DET0)
            }

            If (LEqual (Arg1, 0x02))
            {
                RWAB (CABR (0x06, Zero, 0xC0), 0xFFFFBFFF, Zero)
                RWAB (CABR (One, Zero, 0x65), 0xFFFFFBFB, Zero)
                Store (One, DET2)
            }

            Stall (0xC8)
        }

        If (LEqual (Arg0, One))
        {
            RWAB (CABR (0x03, Arg1, 0xA2), 0xFFFDFFFF, 0x00020000)
            RWAB (CABR (0x03, Arg1, 0xA2), 0xFFFFFEFF, 0x0100)
            If (LEqual (Arg1, Zero))
            {
                RWAB (CABR (0x06, Zero, 0xC0), 0xFFFFEFFF, 0x1000)
                RWAB (CABR (One, Zero, 0x65), 0xFFFFFEFE, 0x0101)
                Store (Zero, DET0)
            }

            If (LEqual (Arg1, 0x02))
            {
                RWAB (CABR (0x06, Zero, 0xC0), 0xFFFFBFFF, 0x4000)
                RWAB (CABR (One, Zero, 0x65), 0xFFFFFBFB, 0x0404)
                Store (Zero, DET2)
            }

            RWAB (CABR (0x03, Arg1, 0xA2), 0xFFFDFFFF, Zero)
            Stall (0xC8)
        }

        If (GGN2)
        {
            If (LEqual (Arg0, Zero))
            {
                GEN2 ()
                Store (RDAB (CABR (0x03, 0x02, 0xA5)), Local0)
                And (Local0, 0xFF, Local0)
                Store (0x01F4, Local1)
                While (LAnd (LGreater (Local1, Zero), LNotEqual (Local0, 0x10)))
                {
                    Store (RDAB (CABR (0x03, 0x02, 0xA5)), Local0)
                    And (Local0, 0xFF, Local0)
                    Decrement (Local1)
                    Stall (0xC8)
                    Stall (0xC8)
                }

                If (LNotEqual (Local0, 0x10))
                {
                    GEN1 ()
                }
            }

            If (LEqual (GENC (), Zero))
            {
                RWAB (CABR (One, Zero, 0x40), 0xFFFFFFF7, 0x08)
            }
            Else
            {
                RWAB (CABR (One, Zero, 0x40), 0xFFFFFFF7, Zero)
            }

            Stall (0xC8)
        }
    }

    Method (GEN2, 0, NotSerialized)
    {
        Store (0x02, TLS2)
        RWAB (CABR (0x03, 0x02, 0xA4), 0xFFFFFFFE, One)
        RWAB (CABR (0x03, 0x02, 0xA2), 0xFFFFDFFF, 0x2000)
        RWAB (CABR (0x03, 0x02, 0xC0), 0xFFFF7FFF, 0x8000)
        RWAB (CABR (0x03, 0x02, 0xA4), 0xDFFFFFFF, 0x20000000)
        Stall (0xC8)
        Stall (0xC8)
    }

    Method (GEN1, 0, NotSerialized)
    {
        Store (One, TLS2)
        RWAB (CABR (0x03, 0x02, 0xA4), 0xFFFFFFFE, Zero)
        RWAB (CABR (0x03, 0x02, 0xA2), 0xFFFFDFFF, 0x2000)
        Stall (0xC8)
        Stall (0xC8)
    }

    OperationRegion (P1E0, SystemIO, P1EB, 0x04)
    Field (P1E0, ByteAcc, NoLock, Preserve)
    {
            ,   10, 
        RTCS,   1, 
            ,   3, 
        PEWS,   1, 
        WSTA,   1, 
            ,   14, 
        PEWD,   1
    }

    Method (SPTS, 1, NotSerialized)
    {
        Store (One, PCMD)
        Store (Arg0, P80)
        CPMS ()
        CPMS ()
        Store (One, PEWS)
    }

    Method (SWAK, 1, NotSerialized)
    {
        CPMS ()
        CPMS ()
        If (RTCS)
        {
            If (PEWS)
            {
                Notify (\_SB.PWRB, 0x02)
            }
        }
        Else
        {
            Notify (\_SB.PWRB, 0x02)
        }

        Store (One, PEWS)
    }

    Method (TRMD, 1, NotSerialized)
    {
    }

    Method (CPMS, 0, NotSerialized)
    {
        If (LEqual (EPNM, Zero))
        {
            Store (One, PMSA)
            Store (One, PMSB)
            Store (One, PMSC)
            Store (One, PMS0)
            Store (One, PMS1)
            Store (One, PMS2)
            Store (One, PMS3)
        }
    }

    Scope (_GPE)
    {
    }

    OperationRegion (S4NV, SystemMemory, 0xBE8D9D18, 0x03)
    Field (S4NV, AnyAcc, Lock, Preserve)
    {
        OSTP,   16, 
        SXTP,   8
    }

    Method (S4RS, 1, NotSerialized)
    {
        Store (Arg0, SXTP)
        Store (0x07D0, OSTP)
        If (CondRefOf (_OSI, Local0))
        {
            If (_OSI ("Windows 2001"))
            {
                Store (0x07D1, OSTP)
            }

            If (_OSI ("Windows 2001.1"))
            {
                Store (0x07D3, OSTP)
            }

            If (_OSI ("Windows 2006"))
            {
                Store (0x07D6, OSTP)
            }

            If (_OSI ("Windows 2009"))
            {
                Store (0x07D9, OSTP)
            }

            If (_OSI ("Windows 2012"))
            {
                Store (0x07DC, OSTP)
            }
        }
    }

    Scope (_SB)
    {
        Name (PR00, Package (0x34)
        {
            Package (0x04)
            {
                0x0011FFFF, 
                Zero, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x02, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x03, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                Zero, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                One, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x02, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x03, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                Zero, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                One, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                0x02, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                0x03, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                Zero, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                One, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x02, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x03, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                Zero, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                One, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                0x02, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                0x03, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                Zero, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                One, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x02, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x03, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                Zero, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                0x02, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                0x03, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                Zero, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x02, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x03, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                Zero, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                0x02, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                0x03, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x0014FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0014FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0014FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0014FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0012FFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0012FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0013FFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0013FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0016FFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0016FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0015FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0015FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0015FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0015FFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR00, Package (0x34)
        {
            Package (0x04)
            {
                0x0011FFFF, 
                Zero, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x37
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                One, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x02, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x03, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                Zero, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                One, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x02, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x03, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                Zero, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                One, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                0x02, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                0x03, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                Zero, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                One, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x02, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x03, 
                Zero, 
                0x34
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                Zero, 
                Zero, 
                0x35
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                One, 
                Zero, 
                0x35
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                0x02, 
                Zero, 
                0x35
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                0x03, 
                Zero, 
                0x35
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                Zero, 
                Zero, 
                0x35
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                One, 
                Zero, 
                0x35
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x02, 
                Zero, 
                0x35
            }, 

            Package (0x04)
            {
                0x0009FFFF, 
                0x03, 
                Zero, 
                0x35
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                Zero, 
                Zero, 
                0x36
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                One, 
                Zero, 
                0x36
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                0x02, 
                Zero, 
                0x36
            }, 

            Package (0x04)
            {
                0x000AFFFF, 
                0x03, 
                Zero, 
                0x36
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                Zero, 
                Zero, 
                0x36
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                One, 
                Zero, 
                0x36
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x02, 
                Zero, 
                0x36
            }, 

            Package (0x04)
            {
                0x000BFFFF, 
                0x03, 
                Zero, 
                0x36
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                Zero, 
                Zero, 
                0x36
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                One, 
                Zero, 
                0x36
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                0x02, 
                Zero, 
                0x36
            }, 

            Package (0x04)
            {
                0x000DFFFF, 
                0x03, 
                Zero, 
                0x36
            }, 

            Package (0x04)
            {
                0x0014FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0014FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0014FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0014FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0012FFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0012FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0013FFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0013FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0016FFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0016FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0015FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0015FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0015FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0015FFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR12, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR12, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x18
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x19
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x1A
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x1B
            }
        })
        Name (PR13, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKH, 
                Zero
            }
        })
        Name (AR13, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x1C
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x1D
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x1E
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x1F
            }
        })
        Name (PR14, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKH, 
                Zero
            }
        })
        Name (AR14, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x2C
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x2D
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x2E
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x2F
            }
        })
        Name (PR15, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKF, 
                Zero
            }
        })
        Name (AR15, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x2E
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x2F
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x2C
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x2D
            }
        })
        Name (PR16, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKC, 
                Zero
            }
        })
        Name (AR16, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x33
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x30
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x31
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x32
            }
        })
        Name (PR19, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR19, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x30
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x31
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x32
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x33
            }
        })
        Name (PR1A, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR1A, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x2F
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x2C
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x2D
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x2E
            }
        })
        Name (PR1B, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR1B, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x20
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x21
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x22
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x23
            }
        })
        Name (PR1D, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR1D, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x28
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x29
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x2A
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x2B
            }
        })
        Name (PR22, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKB, 
                Zero
            }
        })
        Name (AR22, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x11
            }
        })
        Name (PR23, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKC, 
                Zero
            }
        })
        Name (AR23, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x12
            }
        })
        Name (PR20, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR20, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR21, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR21, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x10
            }
        })
        Name (PR0C, Package (0x08)
        {
            Package (0x04)
            {
                0x0005FFFF, 
                Zero, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                One, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x02, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x03, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                Zero, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                One, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                0x02, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                0x03, 
                LNKE, 
                Zero
            }
        })
        Name (AR0C, Package (0x08)
        {
            Package (0x04)
            {
                0x0005FFFF, 
                Zero, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                One, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x02, 
                Zero, 
                0x16
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x03, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                Zero, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                One, 
                Zero, 
                0x16
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                0x02, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                0x03, 
                Zero, 
                0x14
            }
        })
        Name (PRSA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {10,11,14,15}
        })
        Alias (PRSA, PRSB)
        Alias (PRSA, PRSC)
        Alias (PRSA, PRSD)
        Alias (PRSA, PRSE)
        Alias (PRSA, PRSF)
        Alias (PRSA, PRSG)
        Alias (PRSA, PRSH)
        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A03"))  // _HID: Hardware ID
            Name (_ADR, 0x00180000)  // _ADR: Address
            Method (^BN00, 0, NotSerialized)
            {
                Return (Zero)
            }

            Method (_BBN, 0, NotSerialized)  // _BBN: BIOS Bus Number
            {
                Return (BN00 ())
            }

            Name (_UID, Zero)  // _UID: Unique ID
            Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
            {
                If (PICM)
                {
                    Return (AR00)
                }

                Return (PR00)
            }

            Name (CPRB, One)
            Name (LVGA, 0x01)
            Name (STAV, 0x0F)
            Name (BRB, 0x0000)
            Name (BRL, 0x0100)
            Name (IOB, 0x1000)
            Name (IOL, 0xF000)
            Name (MBB, 0xC0000000)
            Name (MBL, 0x40000000)
            Name (MABL, 0x00000000)
            Name (MABH, 0x00000000)
            Name (MALL, 0x00000000)
            Name (MALH, 0x00000000)
            Name (MAML, 0x00000000)
            Name (MAMH, 0x00000000)
            Name (CRS1, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x007F,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0080,             // Length
                    ,, _Y00)
                IO (Decode16,
                    0x0CF8,             // Range Minimum
                    0x0CF8,             // Range Maximum
                    0x01,               // Alignment
                    0x08,               // Length
                    )
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x03AF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x03B0,             // Length
                    ,, , TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x03E0,             // Range Minimum
                    0x0CF7,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0918,             // Length
                    ,, , TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x0000,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0000,             // Length
                    ,, _Y02, TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0D00,             // Range Minimum
                    0x0FFF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0300,             // Length
                    ,, _Y01, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, _Y03, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, NonCacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C0000,         // Range Minimum
                    0x000DFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x02000000,         // Range Minimum
                    0xFFDFFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0xFDFC0000,         // Length
                    ,, _Y04, AddressRangeMemory, TypeStatic)
                QWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x0000000000000000, // Granularity
                    0x0000000000000000, // Range Minimum
                    0x0000000000000000, // Range Maximum
                    0x0000000000000000, // Translation Offset
                    0x0000000000000000, // Length
                    ,, _Y05, AddressRangeMemory, TypeStatic)
            })
            Name (CRS2, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0080,             // Range Minimum
                    0x00FF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0080,             // Length
                    ,, _Y06)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x0000,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0000,             // Length
                    ,, _Y08, TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x0000,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0000,             // Length
                    ,, _Y07, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, _Y09, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x80000000,         // Range Minimum
                    0xFFFFFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x80000000,         // Length
                    ,, _Y0A, AddressRangeMemory, TypeStatic)
                QWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x0000000000000000, // Granularity
                    0x0000000000000000, // Range Minimum
                    0x0000000000000000, // Range Maximum
                    0x0000000000000000, // Translation Offset
                    0x0000000000000000, // Length
                    ,, _Y0B, AddressRangeMemory, TypeStatic)
            })
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                Return (STAV)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                If (CPRB)
                {
                    CreateWordField (CRS1, \_SB.PCI0._Y00._MIN, MIN0)  // _MIN: Minimum Base Address
                    CreateWordField (CRS1, \_SB.PCI0._Y00._MAX, MAX0)  // _MAX: Maximum Base Address
                    CreateWordField (CRS1, \_SB.PCI0._Y00._LEN, LEN0)  // _LEN: Length
                    Store (BRB, MIN0)
                    Store (BRL, LEN0)
                    Store (LEN0, Local0)
                    Add (MIN0, Decrement (Local0), MAX0)
                    CreateWordField (CRS1, \_SB.PCI0._Y01._MIN, MIN1)  // _MIN: Minimum Base Address
                    CreateWordField (CRS1, \_SB.PCI0._Y01._MAX, MAX1)  // _MAX: Maximum Base Address
                    CreateWordField (CRS1, \_SB.PCI0._Y01._LEN, LEN1)  // _LEN: Length
                    If (LEqual (IOB, 0x1000))
                    {
                        Store (IOL, Local0)
                        Add (IOB, Decrement (Local0), MAX1)
                        Subtract (MAX1, MIN1, Local0)
                        Add (Local0, One, LEN1)
                    }
                    Else
                    {
                        Store (IOB, MIN1)
                        Store (IOL, LEN1)
                        Store (LEN1, Local0)
                        Add (MIN1, Decrement (Local0), MAX1)
                    }

                    If (LOr (LEqual (LVGA, One), LEqual (LVGA, 0x55)))
                    {
                        If (VGAF)
                        {
                            CreateWordField (CRS1, \_SB.PCI0._Y02._MIN, IMN1)  // _MIN: Minimum Base Address
                            CreateWordField (CRS1, \_SB.PCI0._Y02._MAX, IMX1)  // _MAX: Maximum Base Address
                            CreateWordField (CRS1, \_SB.PCI0._Y02._LEN, ILN1)  // _LEN: Length
                            Store (0x03B0, IMN1)
                            Store (0x03DF, IMX1)
                            Store (0x30, ILN1)
                            CreateDWordField (CRS1, \_SB.PCI0._Y03._MIN, VMN1)  // _MIN: Minimum Base Address
                            CreateDWordField (CRS1, \_SB.PCI0._Y03._MAX, VMX1)  // _MAX: Maximum Base Address
                            CreateDWordField (CRS1, \_SB.PCI0._Y03._LEN, VLN1)  // _LEN: Length
                            Store (0x000A0000, VMN1)
                            Store (0x000BFFFF, VMX1)
                            Store (0x00020000, VLN1)
                            Store (Zero, VGAF)
                        }
                    }

                    CreateDWordField (CRS1, \_SB.PCI0._Y04._MIN, MIN3)  // _MIN: Minimum Base Address
                    CreateDWordField (CRS1, \_SB.PCI0._Y04._MAX, MAX3)  // _MAX: Maximum Base Address
                    CreateDWordField (CRS1, \_SB.PCI0._Y04._LEN, LEN3)  // _LEN: Length
                    Store (MBB, MIN3)
                    Store (MBL, LEN3)
                    Store (LEN3, Local0)
                    Add (MIN3, Decrement (Local0), MAX3)
                    If (LOr (MALH, MALL))
                    {
                        CreateDWordField (CRS1, \_SB.PCI0._Y05._MIN, MN8L)  // _MIN: Minimum Base Address
                        Add (0xB4, 0x04, Local0)
                        CreateDWordField (CRS1, Local0, MN8H)
                        Store (MABL, MN8L)
                        Store (MABH, MN8H)
                        CreateDWordField (CRS1, \_SB.PCI0._Y05._MAX, MX8L)  // _MAX: Maximum Base Address
                        Add (0xBC, 0x04, Local1)
                        CreateDWordField (CRS1, Local1, MX8H)
                        CreateDWordField (CRS1, \_SB.PCI0._Y05._LEN, LN8L)  // _LEN: Length
                        Add (0xCC, 0x04, Local2)
                        CreateDWordField (CRS1, Local2, LN8H)
                        Store (MABL, MN8L)
                        Store (MABH, MN8H)
                        Store (MALL, LN8L)
                        Store (MALH, LN8H)
                        Store (MAML, MX8L)
                        Store (MAMH, MX8H)
                    }

                    Return (CRS1)
                }
                Else
                {
                    CreateWordField (CRS2, \_SB.PCI0._Y06._MIN, MIN2)  // _MIN: Minimum Base Address
                    CreateWordField (CRS2, \_SB.PCI0._Y06._MAX, MAX2)  // _MAX: Maximum Base Address
                    CreateWordField (CRS2, \_SB.PCI0._Y06._LEN, LEN2)  // _LEN: Length
                    Store (BRB, MIN2)
                    Store (BRL, LEN2)
                    Store (LEN2, Local1)
                    Add (MIN2, Decrement (Local1), MAX2)
                    CreateWordField (CRS2, \_SB.PCI0._Y07._MIN, MIN4)  // _MIN: Minimum Base Address
                    CreateWordField (CRS2, \_SB.PCI0._Y07._MAX, MAX4)  // _MAX: Maximum Base Address
                    CreateWordField (CRS2, \_SB.PCI0._Y07._LEN, LEN4)  // _LEN: Length
                    Store (IOB, MIN4)
                    Store (IOL, LEN4)
                    Store (LEN4, Local1)
                    Add (MIN4, Decrement (Local1), MAX4)
                    If (LVGA)
                    {
                        CreateWordField (CRS2, \_SB.PCI0._Y08._MIN, IMN2)  // _MIN: Minimum Base Address
                        CreateWordField (CRS2, \_SB.PCI0._Y08._MAX, IMX2)  // _MAX: Maximum Base Address
                        CreateWordField (CRS2, \_SB.PCI0._Y08._LEN, ILN2)  // _LEN: Length
                        Store (0x03B0, IMN2)
                        Store (0x03DF, IMX2)
                        Store (0x30, ILN2)
                        CreateDWordField (CRS2, \_SB.PCI0._Y09._MIN, VMN2)  // _MIN: Minimum Base Address
                        CreateDWordField (CRS2, \_SB.PCI0._Y09._MAX, VMX2)  // _MAX: Maximum Base Address
                        CreateDWordField (CRS2, \_SB.PCI0._Y09._LEN, VLN2)  // _LEN: Length
                        Store (0x000A0000, VMN2)
                        Store (0x000BFFFF, VMX2)
                        Store (0x00020000, VLN2)
                    }

                    CreateDWordField (CRS2, \_SB.PCI0._Y0A._MIN, MIN5)  // _MIN: Minimum Base Address
                    CreateDWordField (CRS2, \_SB.PCI0._Y0A._MAX, MAX5)  // _MAX: Maximum Base Address
                    CreateDWordField (CRS2, \_SB.PCI0._Y0A._LEN, LEN5)  // _LEN: Length
                    Store (MBB, MIN5)
                    Store (MBL, LEN5)
                    Store (LEN5, Local1)
                    Add (MIN5, Decrement (Local1), MAX5)
                    If (LOr (MALH, MALL))
                    {
                        CreateDWordField (CRS2, \_SB.PCI0._Y0B._MIN, MN9L)  // _MIN: Minimum Base Address
                        Add (0x72, 0x04, Local0)
                        CreateDWordField (CRS2, Local0, MN9H)
                        CreateDWordField (CRS2, \_SB.PCI0._Y0B._MAX, MX9L)  // _MAX: Maximum Base Address
                        Add (0x7A, 0x04, Local1)
                        CreateDWordField (CRS2, Local1, MX9H)
                        CreateDWordField (CRS2, \_SB.PCI0._Y0B._LEN, LN9L)  // _LEN: Length
                        Add (0x8A, 0x04, Local2)
                        CreateDWordField (CRS2, Local2, LN9H)
                        Store (MABL, MN9L)
                        Store (MABH, MN9H)
                        Store (MALL, LN9L)
                        Store (MALH, LN9H)
                        Store (MAML, MX9L)
                        Store (MAMH, MX9H)
                    }

                    Return (CRS2)
                }
            }

            Scope (\_SB)
            {
                Scope (PCI0)
                {
                    Device (AMDN)
                    {
                        Name (_HID, EisaId ("PNP0C01"))  // _HID: Hardware ID
                        Name (_UID, 0xC8)  // _UID: Unique ID
                        Name (_STA, 0x0F)  // _STA: Status
                        Name (NPTR, ResourceTemplate ()
                        {
                            Memory32Fixed (ReadWrite,
                                0x00000000,         // Address Base
                                0x00000000,         // Address Length
                                _Y0C)
                        })
                        Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                        {
                            CreateDWordField (NPTR, \_SB.PCI0.AMDN._Y0C._LEN, PL)  // _LEN: Length
                            CreateDWordField (NPTR, \_SB.PCI0.AMDN._Y0C._BAS, PB)  // _BAS: Base Address
                            Store (PEBS, PB)
                            Store (PEBL, PL)
                            Return (NPTR)
                        }
                    }
                }
            }

            Method (NPTS, 1, NotSerialized)
            {
            }

            Method (NWAK, 1, NotSerialized)
            {
            }

            Device (RD8A)
            {
                Name (_ADR, Zero)  // _ADR: Address
                OperationRegion (NB2, PCI_Config, Zero, 0x0100)
                Field (NB2, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x60), 
                    MI,     32, 
                    MD,     32, 
                    Offset (0x94), 
                    HI,     32, 
                    HD,     32, 
                    Offset (0xF8), 
                    API,    32, 
                    APD,    32
                }

                Device (NMEM)
                {
                    Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                    Name (_UID, 0x14)  // _UID: Unique ID
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0D)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0E)
                    })
                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CreateDWordField (CRS, \_SB.PCI0.RD8A.NMEM._Y0D._BAS, BAS1)  // _BAS: Base Address
                        CreateDWordField (CRS, \_SB.PCI0.RD8A.NMEM._Y0D._LEN, LEN1)  // _LEN: Length
                        Store (0x3C, MI)
                        Store (MD, Local0)
                        If (And (Local0, 0x40))
                        {
                            Store (0x3A, MI)
                            And (MD, 0xFFFFFF00, BAS1)
                            ShiftLeft (And (MD, 0xFF), 0x17, LEN1)
                        }

                        CreateDWordField (CRS, \_SB.PCI0.RD8A.NMEM._Y0E._BAS, BAS2)  // _BAS: Base Address
                        CreateDWordField (CRS, \_SB.PCI0.RD8A.NMEM._Y0E._LEN, LEN2)  // _LEN: Length
                        Store (Zero, API)
                        Store (APD, Local1)
                        If (And (Local1, One))
                        {
                            Store (0x0100, LEN2)
                            Store (One, API)
                            And (APD, 0xFFFFFF00, BAS2)
                        }

                        Return (CRS)
                    }
                }
            }

            Device (IOMA)
            {
                Name (_ADR, 0x02)  // _ADR: Address
                OperationRegion (NBF2, PCI_Config, Zero, 0x0100)
                Field (NBF2, AnyAcc, NoLock, Preserve)
                {
                    DID,    32, 
                    Offset (0x44), 
                    MBAS,   32
                }

                Device (UMEM)
                {
                    Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                    Name (_UID, 0x15)  // _UID: Unique ID
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0F)
                    })
                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CreateDWordField (CRS, \_SB.PCI0.IOMA.UMEM._Y0F._BAS, BAS3)  // _BAS: Base Address
                        CreateDWordField (CRS, \_SB.PCI0.IOMA.UMEM._Y0F._LEN, LEN3)  // _LEN: Length
                        If (LNotEqual (DID, 0xFFFFFFFF))
                        {
                            Store (0x4000, LEN3)
                            And (MBAS, 0xFFFFFF00, BAS3)
                        }

                        Return (CRS)
                    }
                }
            }

            Device (PC02)
            {
                Name (_ADR, 0x00020000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x18, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR12)
                    }

                    Return (PR12)
                }
            }

            Device (PC03)
            {
                Name (_ADR, 0x00030000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x18, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR13)
                    }

                    Return (PR13)
                }
            }

            Device (PC04)
            {
                Name (_ADR, 0x00040000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x18, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR14)
                    }

                    Return (PR14)
                }
            }

            Device (PC05)
            {
                Name (_ADR, 0x00050000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x18, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR15)
                    }

                    Return (PR15)
                }
            }

            Device (PC06)
            {
                Name (_ADR, 0x00060000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x18, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR16)
                    }

                    Return (PR16)
                }
            }

            Device (PC09)
            {
                Name (_ADR, 0x00090000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x18, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR19)
                    }

                    Return (PR19)
                }
            }

            Device (PC0A)
            {
                Name (_ADR, 0x000A0000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x18, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR1A)
                    }

                    Return (PR1A)
                }
            }

            Device (PC0B)
            {
                Name (_ADR, 0x000B0000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x18, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR1B)
                    }

                    Return (PR1B)
                }
            }

            Device (PC0D)
            {
                Name (_ADR, 0x000D0000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x18, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR1D)
                    }

                    Return (PR1D)
                }
            }

            Device (SMBS)
            {
                Name (_ADR, 0x00140000)  // _ADR: Address
                OperationRegion (SMBS, PCI_Config, Zero, 0x0100)
                Field (SMBS, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x08), 
                    REV,    8, 
                    Offset (0x62), 
                    I1F,    1, 
                    I12F,   1, 
                        ,   2, 
                    MT3A,   1, 
                    Offset (0xF8), 
                    EIDX,   8, 
                    Offset (0xFC), 
                    EDAT,   32
                }

                IndexField (EIDX, EDAT, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x04), 
                    Offset (0x05), 
                        ,   3, 
                    G39E,   1, 
                    G41E,   1, 
                    Offset (0x06), 
                    Offset (0x07), 
                        ,   3, 
                    G39O,   1, 
                    G41O,   1
                }

                OperationRegion (WIDE, PCI_Config, 0xAD, One)
                Field (WIDE, AnyAcc, NoLock, Preserve)
                {
                    DUM1,   4, 
                    SOPT,   1
                }

                OperationRegion (GPIO, SystemMemory, GIOB, 0x0100)
                Field (GPIO, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x06), 
                        ,   5, 
                    G06E,   1, 
                    G06O,   1, 
                    G06I,   1, 
                    G07B,   8, 
                    Offset (0x0B), 
                    G0BB,   8, 
                    Offset (0x0E), 
                    G0EB,   8, 
                    Offset (0x14), 
                        ,   5, 
                    G14E,   1, 
                    G14O,   1, 
                    G14I,   1, 
                        ,   5, 
                    G15E,   1, 
                    G15O,   1, 
                    G15I,   1, 
                    Offset (0x1C), 
                        ,   7, 
                    G1CI,   1, 
                    Offset (0x2D), 
                        ,   5, 
                    G2DE,   1, 
                    G2DO,   1, 
                    G2DI,   1, 
                    Offset (0x35), 
                        ,   5, 
                    G35E,   1, 
                    G35O,   1, 
                    Offset (0x37), 
                        ,   5, 
                    G37E,   1, 
                    G37O,   1, 
                    G37I,   1, 
                    Offset (0x65), 
                        ,   7, 
                    GE05,   1, 
                    Offset (0x6F), 
                        ,   7, 
                    GE15,   1, 
                        ,   7, 
                    GE16,   1, 
                    Offset (0x76), 
                        ,   7, 
                    GE22,   1, 
                    Offset (0xAA), 
                        ,   5, 
                    GAAE,   1, 
                    GAAO,   1, 
                    GAAI,   1, 
                    Offset (0xAF), 
                    GAFB,   8, 
                    GB0B,   8
                }

                OperationRegion (GPMX, SystemMemory, IOMB, 0x0100)
                Field (GPMX, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x06), 
                    G06M,   8, 
                    G07M,   8, 
                    Offset (0x0B), 
                    G0BM,   8, 
                    Offset (0x0E), 
                    G0EM,   8, 
                    Offset (0x14), 
                    G14M,   8, 
                    G15M,   8, 
                    Offset (0x1C), 
                    G1CM,   8, 
                    Offset (0x2D), 
                    G2DM,   8, 
                    Offset (0x37), 
                    G37M,   8, 
                    Offset (0x70), 
                    G70M,   8, 
                    Offset (0x76), 
                    G76M,   8, 
                    Offset (0xAF), 
                    GAFM,   8, 
                    GB0M,   8
                }
            }

            Device (IDEC)
            {
                Name (_ADR, 0x00140001)  // _ADR: Address
                Name (UDMT, Package (0x08)
                {
                    0x78, 
                    0x5A, 
                    0x3C, 
                    0x2D, 
                    0x1E, 
                    0x14, 
                    0x0F, 
                    Zero
                })
                Name (PIOT, Package (0x06)
                {
                    0x0258, 
                    0x0186, 
                    0x010E, 
                    0xB4, 
                    0x78, 
                    Zero
                })
                Name (PITR, Package (0x06)
                {
                    0x99, 
                    0x47, 
                    0x34, 
                    0x22, 
                    0x20, 
                    0x99
                })
                Name (MDMT, Package (0x04)
                {
                    0x01E0, 
                    0x96, 
                    0x78, 
                    Zero
                })
                Name (MDTR, Package (0x04)
                {
                    0x77, 
                    0x21, 
                    0x20, 
                    0xFF
                })
                OperationRegion (IDE, PCI_Config, 0x40, 0x20)
                Field (IDE, AnyAcc, NoLock, Preserve)
                {
                    PPIT,   16, 
                    SPIT,   16, 
                    PMDT,   16, 
                    SMDT,   16, 
                    PPIC,   8, 
                    SPIC,   8, 
                    PPIM,   8, 
                    SPIM,   8, 
                    Offset (0x14), 
                    PUDC,   2, 
                    SUDC,   2, 
                    Offset (0x16), 
                    PUDM,   8, 
                    SUDM,   8
                }

                Method (GETT, 1, NotSerialized)
                {
                    Store (And (Arg0, 0x0F), Local0)
                    Store (ShiftRight (Arg0, 0x04), Local1)
                    Return (Multiply (0x1E, Add (Add (Local0, One), Add (Local1, 
                        One))))
                }

                Method (GTM, 1, NotSerialized)
                {
                    CreateByteField (Arg0, Zero, PIT1)
                    CreateByteField (Arg0, One, PIT0)
                    CreateByteField (Arg0, 0x02, MDT1)
                    CreateByteField (Arg0, 0x03, MDT0)
                    CreateByteField (Arg0, 0x04, PICX)
                    CreateByteField (Arg0, 0x05, UDCX)
                    CreateByteField (Arg0, 0x06, UDMX)
                    Name (BUF, Buffer (0x14)
                    {
                        /* 0000 */   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                        /* 0008 */   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                        /* 0010 */   0x00, 0x00, 0x00, 0x00
                    })
                    CreateDWordField (BUF, Zero, PIO0)
                    CreateDWordField (BUF, 0x04, DMA0)
                    CreateDWordField (BUF, 0x08, PIO1)
                    CreateDWordField (BUF, 0x0C, DMA1)
                    CreateDWordField (BUF, 0x10, FLAG)
                    If (And (PICX, One))
                    {
                        Return (BUF)
                    }

                    Store (GETT (PIT0), PIO0)
                    Store (GETT (PIT1), PIO1)
                    If (And (UDCX, One))
                    {
                        Or (FLAG, One, FLAG)
                        Store (DerefOf (Index (UDMT, And (UDMX, 0x0F))), DMA0)
                    }
                    Else
                    {
                        Store (GETT (MDT0), DMA0)
                    }

                    If (And (UDCX, 0x02))
                    {
                        Or (FLAG, 0x04, FLAG)
                        Store (DerefOf (Index (UDMT, ShiftRight (UDMX, 0x04))), DMA1)
                    }
                    Else
                    {
                        Store (GETT (MDT1), DMA1)
                    }

                    Or (FLAG, 0x1A, FLAG)
                    Return (BUF)
                }

                Method (STM, 3, NotSerialized)
                {
                    CreateDWordField (Arg0, Zero, PIO0)
                    CreateDWordField (Arg0, 0x04, DMA0)
                    CreateDWordField (Arg0, 0x08, PIO1)
                    CreateDWordField (Arg0, 0x0C, DMA1)
                    CreateDWordField (Arg0, 0x10, FLAG)
                    Name (BUF, Buffer (0x07)
                    {
                         0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00
                    })
                    CreateByteField (BUF, Zero, PIT1)
                    CreateByteField (BUF, One, PIT0)
                    CreateByteField (BUF, 0x02, MDT1)
                    CreateByteField (BUF, 0x03, MDT0)
                    CreateByteField (BUF, 0x04, PIMX)
                    CreateByteField (BUF, 0x05, UDCX)
                    CreateByteField (BUF, 0x06, UDMX)
                    Store (Match (PIOT, MLE, PIO0, MTR, Zero, Zero), Local0)
                    Divide (Local0, 0x05, Local0)
                    Store (Match (PIOT, MLE, PIO1, MTR, Zero, Zero), Local1)
                    Divide (Local1, 0x05, Local1)
                    Store (Or (ShiftLeft (Local1, 0x04), Local0), PIMX)
                    Store (DerefOf (Index (PITR, Local0)), PIT0)
                    Store (DerefOf (Index (PITR, Local1)), PIT1)
                    If (And (FLAG, One))
                    {
                        Store (Match (UDMT, MLE, DMA0, MTR, Zero, Zero), Local0)
                        Divide (Local0, 0x07, Local0)
                        Or (UDMX, Local0, UDMX)
                        Or (UDCX, One, UDCX)
                    }
                    Else
                    {
                        If (LNotEqual (DMA0, 0xFFFFFFFF))
                        {
                            Store (Match (MDMT, MLE, DMA0, MTR, Zero, Zero), Local0)
                            Store (DerefOf (Index (MDTR, Local0)), MDT0)
                        }
                    }

                    If (And (FLAG, 0x04))
                    {
                        Store (Match (UDMT, MLE, DMA1, MTR, Zero, Zero), Local0)
                        Divide (Local0, 0x07, Local0)
                        Or (UDMX, ShiftLeft (Local0, 0x04), UDMX)
                        Or (UDCX, 0x02, UDCX)
                    }
                    Else
                    {
                        If (LNotEqual (DMA1, 0xFFFFFFFF))
                        {
                            Store (Match (MDMT, MLE, DMA1, MTR, Zero, Zero), Local0)
                            Store (DerefOf (Index (MDTR, Local0)), MDT1)
                        }
                    }

                    Return (BUF)
                }

                Method (GTF, 2, NotSerialized)
                {
                    CreateByteField (Arg1, Zero, MDT1)
                    CreateByteField (Arg1, One, MDT0)
                    CreateByteField (Arg1, 0x02, PIMX)
                    CreateByteField (Arg1, 0x03, UDCX)
                    CreateByteField (Arg1, 0x04, UDMX)
                    If (LEqual (Arg0, 0xA0))
                    {
                        Store (And (PIMX, 0x0F), Local0)
                        Store (MDT0, Local1)
                        And (UDCX, One, Local2)
                        Store (And (UDMX, 0x0F), Local3)
                    }
                    Else
                    {
                        Store (ShiftRight (PIMX, 0x04), Local0)
                        Store (MDT1, Local1)
                        And (UDCX, 0x02, Local2)
                        Store (ShiftRight (UDMX, 0x04), Local3)
                    }

                    Name (BUF, Buffer (0x15)
                    {
                        /* 0000 */   0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xEF, 0x03,
                        /* 0008 */   0x00, 0x00, 0x00, 0x00, 0xFF, 0xEF, 0x00, 0x00,
                        /* 0010 */   0x00, 0x00, 0x00, 0x00, 0xF5
                    })
                    CreateByteField (BUF, One, PMOD)
                    CreateByteField (BUF, 0x08, DMOD)
                    CreateByteField (BUF, 0x05, CMDA)
                    CreateByteField (BUF, 0x0C, CMDB)
                    CreateByteField (BUF, 0x13, CMDC)
                    Store (Arg0, CMDA)
                    Store (Arg0, CMDB)
                    Store (Arg0, CMDC)
                    Or (Local0, 0x08, PMOD)
                    If (Local2)
                    {
                        Or (Local3, 0x40, DMOD)
                    }
                    Else
                    {
                        Store (Match (MDMT, MLE, GETT (Local1), MTR, Zero, Zero), Local4)
                        If (LLess (Local4, 0x03))
                        {
                            Or (0x20, Local4, DMOD)
                        }
                    }

                    Return (BUF)
                }

                Device (PRID)
                {
                    Name (_ADR, Zero)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Name (BUF, Buffer (0x07)
                        {
                             0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00
                        })
                        CreateWordField (BUF, Zero, VPIT)
                        CreateWordField (BUF, 0x02, VMDT)
                        CreateByteField (BUF, 0x04, VPIC)
                        CreateByteField (BUF, 0x05, VUDC)
                        CreateByteField (BUF, 0x06, VUDM)
                        If (LOr (LGreaterEqual (^^^SMBS.REV, 0x3A), ^^^SMBS.SOPT))
                        {
                            Store (PPIT, VPIT)
                            Store (PMDT, VMDT)
                            Store (PPIC, VPIC)
                            Store (PUDC, VUDC)
                            Store (PUDM, VUDM)
                        }
                        Else
                        {
                            Store (SPIT, VPIT)
                            Store (SMDT, VMDT)
                            Store (SPIC, VPIC)
                            Store (SUDC, VUDC)
                            Store (SUDM, VUDM)
                        }

                        Return (GTM (BUF))
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Name (BUF, Buffer (0x07)
                        {
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        CreateWordField (BUF, Zero, VPIT)
                        CreateWordField (BUF, 0x02, VMDT)
                        CreateByteField (BUF, 0x04, VPIM)
                        CreateByteField (BUF, 0x05, VUDC)
                        CreateByteField (BUF, 0x06, VUDM)
                        Store (STM (Arg0, Arg1, Arg2), BUF)
                        If (LOr (LGreaterEqual (^^^SMBS.REV, 0x3A), ^^^SMBS.SOPT))
                        {
                            Store (VPIT, PPIT)
                            Store (VMDT, PMDT)
                            Store (VPIM, PPIM)
                            Store (VUDC, PUDC)
                            Store (VUDM, PUDM)
                        }
                        Else
                        {
                            Store (VPIT, SPIT)
                            Store (VMDT, SMDT)
                            Store (VPIM, SPIM)
                            Store (VUDC, SUDC)
                            Store (VUDM, SUDM)
                        }
                    }

                    Device (P_D0)
                    {
                        Name (_ADR, Zero)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Name (BUF, Buffer (0x05)
                            {
                                 0x00, 0x00, 0x00, 0x00, 0x00
                            })
                            CreateWordField (BUF, Zero, VMDT)
                            CreateByteField (BUF, 0x02, VPIM)
                            CreateByteField (BUF, 0x03, VUDC)
                            CreateByteField (BUF, 0x04, VUDM)
                            If (LOr (LGreaterEqual (^^^^SMBS.REV, 0x3A), ^^^^SMBS.SOPT))
                            {
                                Store (PMDT, VMDT)
                                Store (PPIM, VPIM)
                                Store (PUDC, VUDC)
                                Store (PUDM, VUDM)
                            }
                            Else
                            {
                                Store (SMDT, VMDT)
                                Store (SPIM, VPIM)
                                Store (SUDC, VUDC)
                                Store (SUDM, VUDM)
                            }

                            Return (GTF (0xA0, BUF))
                        }
                    }

                    Device (P_D1)
                    {
                        Name (_ADR, One)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Name (BUF, Buffer (0x05)
                            {
                                 0x00, 0x00, 0x00, 0x00, 0x00
                            })
                            CreateWordField (BUF, Zero, VMDT)
                            CreateByteField (BUF, 0x02, VPIM)
                            CreateByteField (BUF, 0x03, VUDC)
                            CreateByteField (BUF, 0x04, VUDM)
                            If (LOr (LGreaterEqual (^^^^SMBS.REV, 0x3A), ^^^^SMBS.SOPT))
                            {
                                Store (PMDT, VMDT)
                                Store (PPIM, VPIM)
                                Store (PUDC, VUDC)
                                Store (PUDM, VUDM)
                            }
                            Else
                            {
                                Store (SMDT, VMDT)
                                Store (SPIM, VPIM)
                                Store (SUDC, VUDC)
                                Store (SUDM, VUDM)
                            }

                            Return (GTF (0xB0, BUF))
                        }
                    }
                }

                Device (SECD)
                {
                    Name (_ADR, One)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Name (BUF, Buffer (0x07)
                        {
                             0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00
                        })
                        CreateWordField (BUF, Zero, VPIT)
                        CreateWordField (BUF, 0x02, VMDT)
                        CreateByteField (BUF, 0x04, VPIC)
                        CreateByteField (BUF, 0x05, VUDC)
                        CreateByteField (BUF, 0x06, VUDM)
                        If (LOr (LGreaterEqual (^^^SMBS.REV, 0x3A), ^^^SMBS.SOPT))
                        {
                            Store (SPIT, VPIT)
                            Store (SMDT, VMDT)
                            Store (SPIC, VPIC)
                            Store (SUDC, VUDC)
                            Store (SUDM, VUDM)
                        }
                        Else
                        {
                            Store (PPIT, VPIT)
                            Store (PMDT, VMDT)
                            Store (PPIC, VPIC)
                            Store (PUDC, VUDC)
                            Store (PUDM, VUDM)
                        }

                        Return (GTM (BUF))
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Name (BUF, Buffer (0x07)
                        {
                             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                        CreateWordField (BUF, Zero, VPIT)
                        CreateWordField (BUF, 0x02, VMDT)
                        CreateByteField (BUF, 0x04, VPIM)
                        CreateByteField (BUF, 0x05, VUDC)
                        CreateByteField (BUF, 0x06, VUDM)
                        Store (STM (Arg0, Arg1, Arg2), BUF)
                        If (LOr (LGreaterEqual (^^^SMBS.REV, 0x3A), ^^^SMBS.SOPT))
                        {
                            Store (VPIT, SPIT)
                            Store (VMDT, SMDT)
                            Store (VPIM, SPIM)
                            Store (VUDC, SUDC)
                            Store (VUDM, SUDM)
                        }
                        Else
                        {
                            Store (VPIT, PPIT)
                            Store (VMDT, PMDT)
                            Store (VPIM, PPIM)
                            Store (VUDC, PUDC)
                            Store (VUDM, PUDM)
                        }
                    }

                    Device (S_D0)
                    {
                        Name (_ADR, Zero)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Name (BUF, Buffer (0x05)
                            {
                                 0x00, 0x00, 0x00, 0x00, 0x00
                            })
                            CreateWordField (BUF, Zero, VMDT)
                            CreateByteField (BUF, 0x02, VPIM)
                            CreateByteField (BUF, 0x03, VUDC)
                            CreateByteField (BUF, 0x04, VUDM)
                            If (LOr (LGreaterEqual (^^^^SMBS.REV, 0x3A), ^^^^SMBS.SOPT))
                            {
                                Store (SMDT, VMDT)
                                Store (SPIM, VPIM)
                                Store (SUDC, VUDC)
                                Store (SUDM, VUDM)
                            }
                            Else
                            {
                                Store (PMDT, VMDT)
                                Store (PPIM, VPIM)
                                Store (PUDC, VUDC)
                                Store (PUDM, VUDM)
                            }

                            Return (GTF (0xA0, BUF))
                        }
                    }

                    Device (S_D1)
                    {
                        Name (_ADR, One)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Name (BUF, Buffer (0x05)
                            {
                                 0x00, 0x00, 0x00, 0x00, 0x00
                            })
                            CreateWordField (BUF, Zero, VMDT)
                            CreateByteField (BUF, 0x02, VPIM)
                            CreateByteField (BUF, 0x03, VUDC)
                            CreateByteField (BUF, 0x04, VUDM)
                            If (LOr (LGreaterEqual (^^^^SMBS.REV, 0x3A), ^^^^SMBS.SOPT))
                            {
                                Store (SMDT, VMDT)
                                Store (SPIM, VPIM)
                                Store (SUDC, VUDC)
                                Store (SUDM, VUDM)
                            }
                            Else
                            {
                                Store (PMDT, VMDT)
                                Store (PPIM, VPIM)
                                Store (PUDC, VUDC)
                                Store (PUDM, VUDM)
                            }

                            Return (GTF (0xB0, BUF))
                        }
                    }
                }
            }

            Device (SBAZ)
            {
                Name (_ADR, 0x00140002)  // _ADR: Address
                OperationRegion (PCI, PCI_Config, Zero, 0x0100)
                Field (PCI, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x42), 
                    DNSP,   1, 
                    DNSO,   1, 
                    ENSR,   1
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x1B, 0x04))
                }
            }

            Device (SBRG)
            {
                Name (_ADR, 0x00140003)  // _ADR: Address
                OperationRegion (RMBS, PCI_Config, Zero, 0x0100)
                Field (RMBS, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x4A), 
                    IOPD,   8, 
                    Offset (0x6C), 
                    LR2S,   16, 
                    LR2E,   16
                }

                OperationRegion (SMIP, SystemIO, SMIO, One)
                Field (SMIP, ByteAcc, NoLock, Preserve)
                {
                    SMIC,   8
                }

                OperationRegion (GPIO, SystemMemory, SMIB, 0x0200)
                Field (GPIO, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x88), 
                        ,   1, 
                    CLPS,   1, 
                    Offset (0xB0), 
                        ,   2, 
                    SLPS,   2, 
                    Offset (0x10B), 
                    FSCR,   1, 
                    FSSR,   1, 
                    Offset (0x1BE), 
                        ,   5, 
                    ALLS,   1
                }

                Method (SPTS, 1, NotSerialized)
                {
                }

                Method (SWAK, 1, NotSerialized)
                {
                }

                Method (IPTS, 1, NotSerialized)
                {
                    Store (One, CLPS)
                    Store (One, SLPS)
                    Store (Zero, ALLS)
                    Store (Zero, FSCR)
                    Store (One, FSSR)
                }

                Device (S800)
                {
                    Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                    Name (_UID, 0x0700)  // _UID: Unique ID
                    Name (_STA, 0x0F)  // _STA: Status
                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x040B,             // Range Minimum
                            0x040B,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x04D6,             // Range Minimum
                            0x04D6,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0C00,             // Range Minimum
                            0x0C00,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0C14,             // Range Minimum
                            0x0C14,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0C50,             // Range Minimum
                            0x0C50,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0C52,             // Range Minimum
                            0x0C52,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0C6C,             // Range Minimum
                            0x0C6C,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0C6F,             // Range Minimum
                            0x0C6F,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0CD0,             // Range Minimum
                            0x0CD0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0CD2,             // Range Minimum
                            0x0CD2,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0CD4,             // Range Minimum
                            0x0CD4,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0CD6,             // Range Minimum
                            0x0CD6,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0CD8,             // Range Minimum
                            0x0CD8,             // Range Maximum
                            0x00,               // Alignment
                            0x08,               // Length
                            )
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y10)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y13)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y12)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y11)
                        IO (Decode16,
                            0x0900,             // Range Minimum
                            0x0900,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0910,             // Range Minimum
                            0x0910,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0xFE00,             // Range Minimum
                            0xFE00,             // Range Maximum
                            0x00,               // Alignment
                            0xFF,               // Length
                            )
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            )
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y14)
                        Memory32Fixed (ReadWrite,
                            0xFEE00000,         // Address Base
                            0x00001000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED80000,         // Address Base
                            0x00010000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED61000,         // Address Base
                            0x00010000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y15)
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y16)
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y17)
                    })
                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CreateWordField (CRS, \_SB.PCI0.SBRG.S800._Y10._MIN, PBB)  // _MIN: Minimum Base Address
                        CreateWordField (CRS, \_SB.PCI0.SBRG.S800._Y10._MAX, PBH)  // _MAX: Maximum Base Address
                        CreateByteField (CRS, \_SB.PCI0.SBRG.S800._Y10._LEN, PML)  // _LEN: Length
                        Store (PMBS, PBB)
                        Store (PMBS, PBH)
                        Store (PMLN, PML)
                        If (SMBB)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.S800._Y11._MIN, SMB1)  // _MIN: Minimum Base Address
                            CreateWordField (CRS, \_SB.PCI0.SBRG.S800._Y11._MAX, SMH1)  // _MAX: Maximum Base Address
                            CreateByteField (CRS, \_SB.PCI0.SBRG.S800._Y11._LEN, SML1)  // _LEN: Length
                            Store (SMBB, SMB1)
                            Store (SMBB, SMH1)
                            Store (SMBL, SML1)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.S800._Y12._MIN, SMB0)  // _MIN: Minimum Base Address
                            CreateWordField (CRS, \_SB.PCI0.SBRG.S800._Y12._MAX, SMH0)  // _MAX: Maximum Base Address
                            CreateByteField (CRS, \_SB.PCI0.SBRG.S800._Y12._LEN, SML0)  // _LEN: Length
                            Store (SMB0, SMB0)
                            Store (SMB0, SMH0)
                            Store (SMBM, SML0)
                        }

                        If (GPBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.S800._Y13._MIN, IGB)  // _MIN: Minimum Base Address
                            CreateWordField (CRS, \_SB.PCI0.SBRG.S800._Y13._MAX, IGH)  // _MAX: Maximum Base Address
                            CreateByteField (CRS, \_SB.PCI0.SBRG.S800._Y13._LEN, IGL)  // _LEN: Length
                            Store (GPBS, IGB)
                            Store (GPBS, IGH)
                            Store (GPLN, IGL)
                        }

                        If (APCB)
                        {
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.S800._Y14._BAS, APB)  // _BAS: Base Address
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.S800._Y14._LEN, APL)  // _LEN: Length
                            Store (APCB, APB)
                            Store (APCL, APL)
                        }

                        If (SPIB)
                        {
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.S800._Y15._BAS, SPIB)  // _BAS: Base Address
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.S800._Y15._LEN, SPIL)  // _LEN: Length
                            Store (\SPIB, SPIB)
                            Store (\SPIL, SPIL)
                        }

                        If (HPTB)
                        {
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.S800._Y16._BAS, HXTB)  // _BAS: Base Address
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.S800._Y16._LEN, HXTL)  // _LEN: Length
                            Store (HPTB, HXTB)
                            Store (HPTL, HXTL)
                        }

                        CreateDWordField (CRS, \_SB.PCI0.SBRG.S800._Y17._BAS, ROMB)  // _BAS: Base Address
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.S800._Y17._LEN, ROML)  // _LEN: Length
                        If (LR2S)
                        {
                            Store (ShiftLeft (LR2S, 0x10), ROMB)
                            Store (ShiftLeft (Add (Subtract (LR2E, LR2S), One), 0x10
                                ), ROML)
                        }
                        Else
                        {
                            Store (ROMS, ROMB)
                            Subtract (Zero, ROMS, ROML)
                        }

                        Return (CRS)
                    }
                }

                Device (SIO1)
                {
                    Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                    Name (_UID, 0x0111)  // _UID: Unique ID
                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y18)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y19)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        If (LAnd (LLess (SP1O, 0x03F0), LGreater (SP1O, 0xF0)))
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIO1._Y18._MIN, GPI0)  // _MIN: Minimum Base Address
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIO1._Y18._MAX, GPI1)  // _MAX: Maximum Base Address
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIO1._Y18._LEN, GPIL)  // _LEN: Length
                            Store (SP1O, GPI0)
                            Store (SP1O, GPI1)
                            Store (0x02, GPIL)
                        }

                        If (IO1B)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIO1._Y19._MIN, GP10)  // _MIN: Minimum Base Address
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIO1._Y19._MAX, GP11)  // _MAX: Maximum Base Address
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIO1._Y19._LEN, GPL1)  // _LEN: Length
                            Store (IO1B, GP10)
                            Store (IO1B, GP11)
                            Store (IO1L, GPL1)
                        }

                        Return (CRS)
                    }

                    Name (DCAT, Package (0x15)
                    {
                        0x02, 
                        0x03, 
                        One, 
                        Zero, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0x05, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0x06, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF
                    })
                    Mutex (MUT0, 0x00)
                    Method (ENFG, 1, NotSerialized)
                    {
                        Acquire (MUT0, 0x0FFF)
                        Store (0x87, INDX)
                        Store (0x87, INDX)
                        Store (Arg0, LDN)
                    }

                    Method (EXFG, 0, NotSerialized)
                    {
                        Store (0xAA, INDX)
                        Release (MUT0)
                    }

                    Method (LPTM, 1, NotSerialized)
                    {
                        ENFG (CGLD (Arg0))
                        And (OPT0, 0x02, Local0)
                        EXFG ()
                        Return (Local0)
                    }

                    Method (UHID, 1, NotSerialized)
                    {
                        If (LEqual (Arg0, One))
                        {
                            Return (0x1005D041)
                        }

                        Return (0x0105D041)
                    }

                    OperationRegion (IOID, SystemIO, SP1O, 0x02)
                    Field (IOID, ByteAcc, NoLock, Preserve)
                    {
                        INDX,   8, 
                        DATA,   8
                    }

                    IndexField (INDX, DATA, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0x07), 
                        LDN,    8, 
                        Offset (0x21), 
                        SCF1,   8, 
                        SCF2,   8, 
                        SCF3,   8, 
                        SCF4,   8, 
                        SCF5,   8, 
                        SCF6,   8, 
                        SCF7,   8, 
                        Offset (0x29), 
                        CKCF,   8, 
                        Offset (0x30), 
                        ACTR,   8, 
                        Offset (0x60), 
                        IOAH,   8, 
                        IOAL,   8, 
                        IOH2,   8, 
                        IOL2,   8, 
                        Offset (0x70), 
                        INTR,   8, 
                        Offset (0x74), 
                        DMCH,   8, 
                        Offset (0xE0), 
                        RGE0,   8, 
                        RGE1,   8, 
                        RGE2,   8, 
                        RGE3,   8, 
                        RGE4,   8, 
                        RGE5,   8, 
                        RGE6,   8, 
                        RGE7,   8, 
                        RGE8,   8, 
                        Offset (0xF0), 
                        OPT0,   8, 
                        OPT1,   8, 
                        OPT2,   8, 
                        OPT3,   8, 
                        OPT4,   8, 
                        OPT5,   8, 
                        OPT6,   8, 
                        OPT7,   8
                    }

                    Method (CGLD, 1, NotSerialized)
                    {
                        Return (DerefOf (Index (DCAT, Arg0)))
                    }

                    Method (DSTA, 1, NotSerialized)
                    {
                        ENFG (CGLD (Arg0))
                        Store (ACTR, Local0)
                        EXFG ()
                        If (LEqual (Local0, 0xFF))
                        {
                            Return (Zero)
                        }

                        And (Local0, One, Local0)
                        Or (IOST, ShiftLeft (Local0, Arg0), IOST)
                        If (Local0)
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            If (And (ShiftLeft (One, Arg0), IOST))
                            {
                                Return (0x0D)
                            }
                            Else
                            {
                                Return (Zero)
                            }
                        }
                    }

                    Method (DCNT, 2, NotSerialized)
                    {
                        ENFG (CGLD (Arg0))
                        If (LAnd (LLess (DMCH, 0x04), LNotEqual (And (DMCH, 0x03, 
                            Local1), Zero)))
                        {
                            RDMA (Arg0, Arg1, Increment (Local1))
                        }

                        Store (Arg1, ACTR)
                        ShiftLeft (IOAH, 0x08, Local1)
                        Or (IOAL, Local1, Local1)
                        RRIO (Arg0, Arg1, Local1, 0x08)
                        EXFG ()
                    }

                    Name (CRS1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x00,               // Length
                            _Y1C)
                        IRQNoFlags (_Y1A)
                            {}
                        DMA (Compatibility, NotBusMaster, Transfer8, _Y1B)
                            {}
                    })
                    CreateWordField (CRS1, \_SB.PCI0.SBRG.SIO1._Y1A._INT, IRQM)  // _INT: Interrupts
                    CreateByteField (CRS1, \_SB.PCI0.SBRG.SIO1._Y1B._DMA, DMAM)  // _DMA: Direct Memory Access
                    CreateWordField (CRS1, \_SB.PCI0.SBRG.SIO1._Y1C._MIN, IO11)  // _MIN: Minimum Base Address
                    CreateWordField (CRS1, \_SB.PCI0.SBRG.SIO1._Y1C._MAX, IO12)  // _MAX: Maximum Base Address
                    CreateByteField (CRS1, \_SB.PCI0.SBRG.SIO1._Y1C._LEN, LEN1)  // _LEN: Length
                    Name (CRS2, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x00,               // Length
                            _Y1F)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x00,               // Length
                            _Y20)
                        IRQNoFlags (_Y1D)
                            {}
                        DMA (Compatibility, NotBusMaster, Transfer8, _Y1E)
                            {2}
                    })
                    CreateWordField (CRS2, \_SB.PCI0.SBRG.SIO1._Y1D._INT, IRQE)  // _INT: Interrupts
                    CreateByteField (CRS2, \_SB.PCI0.SBRG.SIO1._Y1E._DMA, DMAE)  // _DMA: Direct Memory Access
                    CreateWordField (CRS2, \_SB.PCI0.SBRG.SIO1._Y1F._MIN, IO21)  // _MIN: Minimum Base Address
                    CreateWordField (CRS2, \_SB.PCI0.SBRG.SIO1._Y1F._MAX, IO22)  // _MAX: Maximum Base Address
                    CreateByteField (CRS2, \_SB.PCI0.SBRG.SIO1._Y1F._LEN, LEN2)  // _LEN: Length
                    CreateWordField (CRS2, \_SB.PCI0.SBRG.SIO1._Y20._MIN, IO31)  // _MIN: Minimum Base Address
                    CreateWordField (CRS2, \_SB.PCI0.SBRG.SIO1._Y20._MAX, IO32)  // _MAX: Maximum Base Address
                    CreateByteField (CRS2, \_SB.PCI0.SBRG.SIO1._Y20._LEN, LEN3)  // _LEN: Length
                    Name (CRS4, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x00,               // Length
                            _Y22)
                        IRQ (Edge, ActiveLow, Shared, _Y21)
                            {}
                    })
                    CreateWordField (CRS4, \_SB.PCI0.SBRG.SIO1._Y21._INT, IRQL)  // _INT: Interrupts
                    CreateWordField (CRS4, \_SB.PCI0.SBRG.SIO1._Y22._MIN, IOHL)  // _MIN: Minimum Base Address
                    CreateWordField (CRS4, \_SB.PCI0.SBRG.SIO1._Y22._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (CRS4, \_SB.PCI0.SBRG.SIO1._Y22._ALN, ALMN)  // _ALN: Alignment
                    CreateByteField (CRS4, \_SB.PCI0.SBRG.SIO1._Y22._LEN, LENG)  // _LEN: Length
                    Method (DCRS, 2, NotSerialized)
                    {
                        ENFG (CGLD (Arg0))
                        ShiftLeft (IOAH, 0x08, IO11)
                        Or (IOAL, IO11, IO11)
                        Store (IO11, IO12)
                        Subtract (FindSetRightBit (IO11), One, Local0)
                        ShiftLeft (One, Local0, LEN1)
                        If (INTR)
                        {
                            ShiftLeft (One, INTR, IRQM)
                        }
                        Else
                        {
                            Store (Zero, IRQM)
                        }

                        If (LOr (LGreater (DMCH, 0x03), LEqual (Arg1, Zero)))
                        {
                            Store (Zero, DMAM)
                        }
                        Else
                        {
                            And (DMCH, 0x03, Local1)
                            ShiftLeft (One, Local1, DMAM)
                        }

                        EXFG ()
                        Return (CRS1)
                    }

                    Method (DSRS, 2, NotSerialized)
                    {
                        If (LEqual (Arg1, 0x02))
                        {
                            If (LPTM (0x02))
                            {
                                DSR2 (Arg0, Arg1)
                            }
                        }
                        Else
                        {
                            CreateWordField (Arg0, 0x09, IRQM)
                            CreateByteField (Arg0, 0x0C, DMAM)
                            CreateWordField (Arg0, 0x02, IO11)
                            ENFG (CGLD (Arg1))
                            And (IO11, 0xFF, IOAL)
                            ShiftRight (IO11, 0x08, IOAH)
                            If (IRQM)
                            {
                                FindSetRightBit (IRQM, Local0)
                                Subtract (Local0, One, INTR)
                            }
                            Else
                            {
                                Store (Zero, INTR)
                            }

                            If (DMAM)
                            {
                                FindSetRightBit (DMAM, Local0)
                                Subtract (Local0, One, DMCH)
                            }
                            Else
                            {
                                Store (0x04, DMCH)
                            }

                            EXFG ()
                            DCNT (Arg1, One)
                            Store (Arg1, Local2)
                            If (LGreater (Local2, Zero))
                            {
                                Subtract (Local2, One, Local2)
                            }
                        }
                    }

                    Method (DSR2, 2, NotSerialized)
                    {
                        CreateWordField (Arg0, 0x11, IRQT)
                        CreateByteField (Arg0, 0x14, DMAT)
                        CreateWordField (Arg0, 0x02, IOT1)
                        CreateWordField (Arg0, 0x0A, IOT2)
                        ENFG (CGLD (Arg1))
                        And (IOT1, 0xFF, IOAL)
                        ShiftRight (IOT1, 0x08, IOAH)
                        And (IOT2, 0xFF, IOL2)
                        ShiftRight (IOT2, 0x08, IOH2)
                        If (IRQT)
                        {
                            FindSetRightBit (IRQT, Local0)
                            Subtract (Local0, One, INTR)
                        }
                        Else
                        {
                            Store (Zero, INTR)
                        }

                        If (DMAT)
                        {
                            FindSetRightBit (DMAT, Local0)
                            Subtract (Local0, One, DMCH)
                        }
                        Else
                        {
                            Store (0x04, DMCH)
                        }

                        EXFG ()
                        DCNT (Arg1, One)
                        Store (Arg1, Local2)
                        If (LGreater (Local2, Zero))
                        {
                            Subtract (Local2, One, Local2)
                        }
                    }

                    Method (SIOK, 1, NotSerialized)
                    {
                        ENFG (0x0A)
                        While (OPT3)
                        {
                            Stall (0x80)
                            Store (0xFF, OPT3)
                        }

                        And (Arg0, One, Local0)
                        And (OPT2, 0xFE, Local1)
                        Or (Local0, Local1, OPT2)
                        Store (And (Arg0, One), ACTR)
                        EXFG ()
                    }

                    Method (SLED, 1, NotSerialized)
                    {
                        ENFG (0x0B)
                        If (Arg0)
                        {
                            If (LEqual (OPT7, 0x87))
                            {
                                Store (0x45, OPT7)
                            }
                        }
                        Else
                        {
                            If (LNotEqual (OPT7, Zero))
                            {
                                Store (0x87, OPT7)
                            }
                        }

                        EXFG ()
                    }
                }

                Name (PMFG, Zero)
                Method (SIOS, 1, NotSerialized)
                {
                    Store ("SIOS", Debug)
                    ^SIO1.ENFG (0x0A)
                    OperationRegion (KBIO, SystemIO, 0x60, 0x05)
                    Field (KBIO, ByteAcc, NoLock, Preserve)
                    {
                        KBDT,   8, 
                        Offset (0x02), 
                        Offset (0x03), 
                        Offset (0x04), 
                        KBST,   8
                    }

                    If (LNotEqual (Arg0, 0x05))
                    {
                        Sleep (0xC8)
                        And (KBST, One, Local0)
                        While (Local0)
                        {
                            Store (KBDT, Local0)
                            Sleep (0xC8)
                            And (KBST, One, Local0)
                        }
                    }

                    If (LEqual (Arg0, One))
                    {
                        ^SIO1.SIOK (Ones)
                        ^SIO1.ENFG (0x0A)
                        If (KBFG)
                        {
                            Or (^SIO1.OPT6, 0x10, ^SIO1.OPT6)
                        }

                        If (MSFG)
                        {
                            Or (^SIO1.OPT6, 0x20, ^SIO1.OPT6)
                        }

                        If (LOr (LOr (LEqual (OSFL (), 0x04), LEqual (OSFL (), 0x09)), LOr (
                            LEqual (OSFL (), 0x0A), LEqual (OSFL (), 0x0B))))
                        {
                            And (^SIO1.RGE0, 0xF7, ^SIO1.RGE0)
                            If (CRFG)
                            {
                                Or (^SIO1.RGE0, 0x08, ^SIO1.RGE0)
                            }

                            If (CRFG)
                            {
                                Or (^SIO1.OPT2, One, ^SIO1.OPT2)
                            }

                            If (CRFG)
                            {
                                And (^SIO1.RGE8, 0x3F, ^SIO1.RGE8)
                            }

                            If (CRFG)
                            {
                                Or (^SIO1.OPT7, 0x10, ^SIO1.OPT7)
                            }

                            If (CRFG)
                            {
                                And (^SIO1.RGE8, 0x3F, ^SIO1.RGE8)
                            }

                            If (CRFG)
                            {
                                Or (^SIO1.RGE8, 0xC0, ^SIO1.RGE8)
                            }
                        }
                        Else
                        {
                            Or (^SIO1.OPT2, One, ^SIO1.OPT2)
                            And (^SIO1.RGE8, 0x3F, ^SIO1.RGE8)
                            Or (^SIO1.OPT7, 0x10, ^SIO1.OPT7)
                            And (^SIO1.RGE8, 0x3F, ^SIO1.RGE8)
                            Or (^SIO1.RGE8, 0xC0, ^SIO1.RGE8)
                        }
                    }

                    If (LGreaterEqual (Arg0, 0x03))
                    {
                        And (^SIO1.RGE0, 0x9F, ^SIO1.RGE0)
                        Store (Zero, ^SIO1.RGE1)
                        Store (Zero, ^SIO1.RGE2)
                        Store (^SIO1.RGE3, Local0)
                        Sleep (0xC8)
                        If (KBFG)
                        {
                            Or (^SIO1.RGE0, 0x41, ^SIO1.RGE0)
                        }

                        If (MSFG)
                        {
                            Or (^SIO1.RGE0, 0x22, ^SIO1.RGE0)
                        }

                        If (LOr (LOr (LEqual (OSFL (), 0x04), LEqual (OSFL (), 0x09)), LOr (
                            LEqual (OSFL (), 0x0A), LEqual (OSFL (), 0x0B))))
                        {
                            And (^SIO1.RGE0, 0xF7, ^SIO1.RGE0)
                            If (CRFG)
                            {
                                Or (^SIO1.RGE0, 0x08, ^SIO1.RGE0)
                            }

                            If (CRFG)
                            {
                                And (^SIO1.RGE8, 0x3F, ^SIO1.RGE8)
                            }

                            If (CRFG)
                            {
                                And (^SIO1.OPT7, 0xEF, ^SIO1.OPT7)
                            }
                        }
                        Else
                        {
                            And (^SIO1.RGE8, 0x3F, ^SIO1.RGE8)
                            And (^SIO1.OPT7, 0xEF, ^SIO1.OPT7)
                        }
                    }

                    If (Or (LEqual (Arg0, One), LEqual (Arg0, 0x03)))
                    {
                        ^SIO1.SLED (Ones)
                    }

                    ^SIO1.EXFG ()
                }

                Method (SIOW, 1, NotSerialized)
                {
                    Store ("SIOW", Debug)
                    ^SIO1.ENFG (0x0A)
                    ^SIO1.SIOK (Zero)
                    ^SIO1.ENFG (0x0A)
                    While (^SIO1.OPT3)
                    {
                        Stall (0x80)
                        Store (0xFF, ^SIO1.OPT3)
                    }

                    And (^SIO1.RGE0, 0x9F, ^SIO1.RGE0)
                    And (^SIO1.OPT6, 0xCF, ^SIO1.OPT6)
                    And (^SIO1.OPT2, 0xFE, ^SIO1.OPT2)
                    ^SIO1.SLED (Zero)
                    ^SIO1.EXFG ()
                    ^SIO1.ENFG (0x0B)
                    Or (^SIO1.ACTR, 0xE0, ^SIO1.ACTR)
                    ^SIO1.EXFG ()
                }

                Device (UAR2)
                {
                    Name (_UID, 0x02)  // _UID: Unique ID
                    Method (_HID, 0, NotSerialized)  // _HID: Hardware ID
                    {
                        Return (^^SIO1.UHID (One))
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        Return (^^SIO1.DSTA (One))
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        ^^SIO1.DCNT (One, Zero)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Return (^^SIO1.DCRS (One, Zero))
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        ^^SIO1.DSRS (Arg0, One)
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x02F8,             // Range Minimum
                                0x02F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02F8,             // Range Minimum
                                0x02F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03E8,             // Range Minimum
                                0x03E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02E8,             // Range Minimum
                                0x02E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        EndDependentFn ()
                    })
                }

                OperationRegion (WIN2, SystemIO, 0x2E, 0x02)
                Field (WIN2, ByteAcc, NoLock, Preserve)
                {
                    IND1,   8, 
                    DAT1,   8
                }

                IndexField (IND1, DAT1, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x07), 
                    LDN1,   8, 
                    Offset (0x1B), 
                    MFP1,   8, 
                    Offset (0x24), 
                    MFP2,   8, 
                    Offset (0x26), 
                    GLO1,   8, 
                    GLO2,   8, 
                    Offset (0x2A), 
                    MFP3,   8, 
                    Offset (0x30), 
                    ACT1,   8, 
                    Offset (0x60), 
                    IOH1,   8, 
                    IOL1,   8, 
                    Offset (0x70), 
                    INT1,   8, 
                    Offset (0xE0), 
                    VBAT,   8
                }

                Method (ENF1, 0, NotSerialized)
                {
                    Store (0x87, IND1)
                    Store (0x87, IND1)
                }

                Method (EXF1, 0, NotSerialized)
                {
                    Store (0xAA, IND1)
                }

                Device (CIR)
                {
                    Name (_HID, EisaId ("NTN0530"))  // _HID: Hardware ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        Return (IRST (0x10))
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        ENF1 ()
                        Store (0x06, LDN1)
                        Store (Zero, ACT1)
                        Store (0x0E, LDN1)
                        Store (Zero, ACT1)
                        EXF1 ()
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (BUF1, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0230,             // Range Minimum
                                0x0230,             // Range Maximum
                                0x00,               // Alignment
                                0x10,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Shared, )
                                {3}
                            IO (Decode16,
                                0x0240,             // Range Minimum
                                0x0240,             // Range Maximum
                                0x00,               // Alignment
                                0x10,               // Length
                                )
                        })
                        Return (BUF1)
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        ENF1 ()
                        Store (0x06, LDN1)
                        CreateWordField (Arg0, 0x09, IRQE)
                        If (IRQE)
                        {
                            FindSetRightBit (IRQE, Local0)
                            Subtract (Local0, One, INT1)
                        }
                        Else
                        {
                            Store (Zero, INT1)
                        }

                        Store (One, ACT1)
                        Store (0x0E, LDN1)
                        Store (One, ACT1)
                        EXF1 ()
                    }

                    Method (IRST, 1, NotSerialized)
                    {
                        ^^SIO1.ENFG (^^SIO1.CGLD (Arg0))
                        If (^^SIO1.ACTR)
                        {
                            Store (0x0A, LDN1)
                            Store (VBAT, Local0)
                            Or (Local0, 0x08, Local0)
                            Store (Local0, VBAT)
                            Store (0x0F, Local0)
                        }
                        Else
                        {
                            If (^^SIO1.IOAH)
                            {
                                If (And (MFP1, 0x10))
                                {
                                    Store (0x0D, Local0)
                                }
                                Else
                                {
                                    Store (Zero, Local0)
                                }
                            }
                            Else
                            {
                                Store (Zero, Local0)
                            }
                        }

                        ^^SIO1.EXFG ()
                        Return (Local0)
                    }

                    Method (NCAP, 0, NotSerialized)
                    {
                        Store (0x02, Local0)
                        Or (0xF0000000, Local0, Local0)
                        Return (Local0)
                    }

                    Method (NRXL, 0, NotSerialized)
                    {
                        Store (Zero, Local0)
                        ShiftLeft (Local0, 0x08, Local0)
                        Or (Local0, 0x80, Local0)
                        ShiftLeft (Local0, 0x08, Local0)
                        Or (Local0, 0xF5, Local0)
                        ShiftLeft (Local0, 0x08, Local0)
                        Or (Local0, 0x09, Local0)
                        Return (Local0)
                    }

                    Method (NTXP, 1, NotSerialized)
                    {
                        ENF1 ()
                        Store (MFP3, Local0)
                        And (Local0, 0xF7, Local0)
                        Store (Local0, MFP3)
                        Store (MFP2, Local1)
                        Or (Local0, 0x40, Local1)
                        Store (Local1, MFP2)
                        If (LEqual (Arg0, One))
                        {
                            Or (Local0, 0x08, Local0)
                        }
                        Else
                        {
                            If (LEqual (Arg0, 0x02))
                            {
                                And (Local1, 0xBF, Local1)
                            }
                            Else
                            {
                                If (LEqual (Arg0, 0x03))
                                {
                                    Or (Local0, 0x08, Local0)
                                    And (Local1, 0xBF, Local1)
                                }
                            }
                        }

                        Store (Local0, MFP3)
                        Store (Local1, MFP2)
                        EXF1 ()
                    }

                    Method (NLED, 0, NotSerialized)
                    {
                        ENF1 ()
                        Store (0x09, LDN1)
                        Store (0x0A, Local1)
                        While (Local1)
                        {
                            Sleep (0x32)
                            Sleep (0x32)
                            Decrement (Local1)
                        }

                        EXF1 ()
                    }

                    Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                    {
                        Store (Arg0, CRFG)
                    }
                }

                Scope (\)
                {
                    Name (CRFG, One)
                }

                Method (CIR._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x1D, 0x03))
                }

                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0020,             // Range Minimum
                            0x0020,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A0,             // Range Minimum
                            0x00A0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {2}
                    })
                }

                Device (DMAD)
                {
                    Name (_HID, EisaId ("PNP0200"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        DMA (Compatibility, BusMaster, Transfer8, )
                            {4}
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0081,             // Range Minimum
                            0x0081,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0087,             // Range Minimum
                            0x0087,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0089,             // Range Minimum
                            0x0089,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x008F,             // Range Minimum
                            0x008F,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x00C0,             // Range Minimum
                            0x00C0,             // Range Maximum
                            0x00,               // Alignment
                            0x20,               // Length
                            )
                    })
                }

                Device (TMR)
                {
                    Name (_HID, EisaId ("PNP0100"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {0}
                    })
                }

                Device (RTC0)
                {
                    Name (_HID, EisaId ("PNP0B00"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {8}
                    })
                }

                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0061,             // Range Minimum
                            0x0061,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                    })
                }

                Scope (\_SB)
                {
                    Scope (PCI0)
                    {
                        Scope (SBRG)
                        {
                            Method (RRIO, 4, NotSerialized)
                            {
                                Store ("RRIO", Debug)
                            }

                            Method (RDMA, 3, NotSerialized)
                            {
                                Store ("rDMA", Debug)
                            }
                        }
                    }
                }

                Device (RMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                    Name (_UID, 0x10)  // _UID: Unique ID
                    Name (CRS1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0010,             // Range Minimum
                            0x0010,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0022,             // Range Minimum
                            0x0022,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x0044,             // Range Minimum
                            0x0044,             // Range Maximum
                            0x00,               // Alignment
                            0x1C,               // Length
                            )
                        IO (Decode16,
                            0x0062,             // Range Minimum
                            0x0062,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0065,             // Range Minimum
                            0x0065,             // Range Maximum
                            0x00,               // Alignment
                            0x0B,               // Length
                            )
                        IO (Decode16,
                            0x0072,             // Range Minimum
                            0x0072,             // Range Maximum
                            0x00,               // Alignment
                            0x0E,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0084,             // Range Minimum
                            0x0084,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0088,             // Range Minimum
                            0x0088,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x008C,             // Range Minimum
                            0x008C,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0090,             // Range Minimum
                            0x0090,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x00A2,             // Range Minimum
                            0x00A2,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x00E0,             // Range Minimum
                            0x00E0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                    })
                    Name (CRS2, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0010,             // Range Minimum
                            0x0010,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0022,             // Range Minimum
                            0x0022,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x0044,             // Range Minimum
                            0x0044,             // Range Maximum
                            0x00,               // Alignment
                            0x1C,               // Length
                            )
                        IO (Decode16,
                            0x0072,             // Range Minimum
                            0x0072,             // Range Maximum
                            0x00,               // Alignment
                            0x0E,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0084,             // Range Minimum
                            0x0084,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0088,             // Range Minimum
                            0x0088,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x008C,             // Range Minimum
                            0x008C,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0090,             // Range Minimum
                            0x0090,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x00A2,             // Range Minimum
                            0x00A2,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x00E0,             // Range Minimum
                            0x00E0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        If (And (MBEC, 0xFFFF))
                        {
                            Return (CRS1)
                        }
                        Else
                        {
                            Return (CRS2)
                        }
                    }
                }

                Device (COPR)
                {
                    Name (_HID, EisaId ("PNP0C04"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x00F0,             // Range Minimum
                            0x00F0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IRQNoFlags ()
                            {13}
                    })
                }

                Device (NBRM)
                {
                    Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                    Name (_UID, 0x99)  // _UID: Unique ID
                    Name (CRS, ResourceTemplate ()
                    {
                    })
                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Return (CRS)
                    }
                }

                Device (PS2K)
                {
                    Name (_HID, EisaId ("PNP0303"))  // _HID: Hardware ID
                    Name (_CID, EisaId ("PNP030B"))  // _CID: Compatible ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (And (IOST, 0x0400))
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }

                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {1}
                    })
                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            FixedIO (
                                0x0060,             // Address
                                0x01,               // Length
                                )
                            FixedIO (
                                0x0064,             // Address
                                0x01,               // Length
                                )
                            IRQNoFlags ()
                                {1}
                        }
                        EndDependentFn ()
                    })
                    Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                    {
                        Store (Arg0, KBFG)
                    }
                }

                Scope (\)
                {
                    Name (KBFG, One)
                }

                Method (PS2K._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x03, 0x04))
                }

                Device (PS2M)
                {
                    Name (_HID, EisaId ("PNP0F03"))  // _HID: Hardware ID
                    Name (_CID, EisaId ("PNP0F13"))  // _CID: Compatible ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (And (IOST, 0x4000))
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }

                    Name (CRS1, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {12}
                    })
                    Name (CRS2, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {12}
                    })
                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        If (And (IOST, 0x0400))
                        {
                            Return (CRS1)
                        }
                        Else
                        {
                            Return (CRS2)
                        }
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IRQNoFlags ()
                                {12}
                        }
                        EndDependentFn ()
                    })
                    Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                    {
                        Store (Arg0, MSFG)
                    }
                }

                Scope (\)
                {
                    Name (MSFG, One)
                }

                Method (PS2M._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x03, 0x04))
                }

                Device (UAR1)
                {
                    Name (_UID, One)  // _UID: Unique ID
                    Method (_HID, 0, NotSerialized)  // _HID: Hardware ID
                    {
                        Return (^^SIO1.UHID (Zero))
                    }

                    Method (_STA, 0, Serialized)  // _STA: Status
                    {
                        If (And (IOST, One))
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        ^^SIO1.DCNT (Zero, Zero)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Return (^^SIO1.DCRS (Zero, Zero))
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        ^^SIO1.DSRS (Arg0, Zero)
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02F8,             // Range Minimum
                                0x02F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03E8,             // Range Minimum
                                0x03E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02E8,             // Range Minimum
                                0x02E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        EndDependentFn ()
                    })
                }

                Method (UAR1._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x16, 0x04))
                }
            }

            Device (P0PC)
            {
                Name (_ADR, 0x00140004)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x04, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR0C)
                    }

                    Return (PR0C)
                }
            }

            Device (UHC1)
            {
                Name (_ADR, 0x00120000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0B, 0x04))
                }
            }

            Device (UHC2)
            {
                Name (_ADR, 0x00120002)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0B, 0x04))
                }
            }

            Device (USB3)
            {
                Name (_ADR, 0x00130000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0B, 0x04))
                }
            }

            Device (UHC4)
            {
                Name (_ADR, 0x00130002)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0B, 0x04))
                }
            }

            Device (USB5)
            {
                Name (_ADR, 0x00160000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0B, 0x04))
                }
            }

            Device (UHC6)
            {
                Name (_ADR, 0x00160002)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0B, 0x04))
                }
            }

            Device (UHC7)
            {
                Name (_ADR, 0x00140005)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0B, 0x04))
                }
            }

            Device (SATA)
            {
                Name (_ADR, 0x00110000)  // _ADR: Address
                If (LEqual (STCL, 0x0101))
                {
                    Method (_INI, 0, NotSerialized)  // _INI: Initialize
                    {
                    }

                    OperationRegion (SACS, PCI_Config, Zero, 0x40)
                    Field (SACS, AnyAcc, NoLock, Preserve)
                    {
                        Offset (0x24), 
                        STB5,   32
                    }

                    Name (SPTM, Buffer (0x14)
                    {
                        /* 0000 */   0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
                        /* 0008 */   0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
                        /* 0010 */   0x1F, 0x00, 0x00, 0x00
                    })
                    Device (PRID)
                    {
                        Name (_ADR, Zero)  // _ADR: Address
                        Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                        {
                            Return (SPTM)
                        }

                        Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                        {
                        }

                        Name (PRIS, Zero)
                        Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                        {
                            OperationRegion (BAR, SystemMemory, STB5, 0x0400)
                            Field (BAR, AnyAcc, NoLock, Preserve)
                            {
                                Offset (0x120), 
                                    ,   7, 
                                PMBY,   1, 
                                Offset (0x128), 
                                PMS0,   4, 
                                Offset (0x129), 
                                PMS1,   4, 
                                Offset (0x220), 
                                    ,   7, 
                                PSBY,   1, 
                                Offset (0x228), 
                                PSS0,   4, 
                                Offset (0x229), 
                                PSS1,   4, 
                                Offset (0x2A0), 
                                    ,   7
                            }

                            If (LOr (LEqual (OSTY, 0x06), LEqual (OSTY, 0x04)))
                            {
                                If (PMS1)
                                {
                                    Store (0x32, Local0)
                                    While (LAnd (LEqual (PMBY, One), Local0))
                                    {
                                        Sleep (0xFA)
                                        Decrement (Local0)
                                    }
                                }

                                If (PSS1)
                                {
                                    Store (0x32, Local0)
                                    While (LAnd (LEqual (PSBY, One), Local0))
                                    {
                                        Sleep (0xFA)
                                        Decrement (Local0)
                                    }
                                }
                            }

                            Store (Zero, PRIS)
                        }

                        Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                        {
                            Store (0x03, PRIS)
                        }

                        Method (_PSC, 0, NotSerialized)  // _PSC: Power State Current
                        {
                            Return (PRIS)
                        }

                        Device (P_D0)
                        {
                            Name (_ADR, Zero)  // _ADR: Address
                            Method (_STA, 0, NotSerialized)  // _STA: Status
                            {
                                OperationRegion (BAR, SystemMemory, STB5, 0x0400)
                                Field (BAR, AnyAcc, NoLock, Preserve)
                                {
                                    Offset (0x128), 
                                    PMS0,   4, 
                                    Offset (0x129), 
                                    PMS1,   4
                                }

                                If (Not (LEqual (PMS1, Zero)))
                                {
                                    Return (0x0F)
                                }
                                Else
                                {
                                    Return (Zero)
                                }
                            }

                            Name (S12P, Zero)
                            Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                            {
                                OperationRegion (BAR, SystemMemory, STB5, 0x0400)
                                Field (BAR, AnyAcc, NoLock, Preserve)
                                {
                                    Offset (0x120), 
                                        ,   7, 
                                    PMBY,   1
                                }

                                Store (0x32, Local0)
                                While (LAnd (LEqual (PMBY, One), Local0))
                                {
                                    Sleep (0xFA)
                                    Decrement (Local0)
                                }

                                Store (Zero, S12P)
                            }

                            Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                            {
                                Store (0x03, S12P)
                            }

                            Method (_PSC, 0, NotSerialized)  // _PSC: Power State Current
                            {
                                Return (S12P)
                            }
                        }

                        Device (P_D1)
                        {
                            Name (_ADR, One)  // _ADR: Address
                            Method (_STA, 0, NotSerialized)  // _STA: Status
                            {
                                OperationRegion (BAR, SystemMemory, STB5, 0x0400)
                                Field (BAR, AnyAcc, NoLock, Preserve)
                                {
                                    Offset (0x228), 
                                    PSS0,   4, 
                                    Offset (0x229), 
                                    PSS1,   4
                                }

                                If (Not (LEqual (PSS1, Zero)))
                                {
                                    Return (0x0F)
                                }
                                Else
                                {
                                    Return (Zero)
                                }
                            }

                            Name (S12P, Zero)
                            Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                            {
                                OperationRegion (BAR, SystemMemory, STB5, 0x0400)
                                Field (BAR, AnyAcc, NoLock, Preserve)
                                {
                                    Offset (0x220), 
                                        ,   7, 
                                    PSBY,   1
                                }

                                Store (0x32, Local0)
                                While (LAnd (LEqual (PSBY, One), Local0))
                                {
                                    Sleep (0xFA)
                                    Decrement (Local0)
                                }

                                Store (Zero, S12P)
                            }

                            Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                            {
                                Store (0x03, S12P)
                            }

                            Method (_PSC, 0, NotSerialized)  // _PSC: Power State Current
                            {
                                Return (S12P)
                            }
                        }
                    }

                    Device (SECD)
                    {
                        Name (_ADR, One)  // _ADR: Address
                        Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                        {
                            Return (SPTM)
                        }

                        Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                        {
                        }

                        Name (SECS, Zero)
                        Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                        {
                            OperationRegion (BAR, SystemMemory, STB5, 0x0400)
                            Field (BAR, AnyAcc, NoLock, Preserve)
                            {
                                Offset (0x1A0), 
                                    ,   7, 
                                SMBY,   1, 
                                Offset (0x1A8), 
                                SMS0,   4, 
                                Offset (0x1A9), 
                                SMS1,   4, 
                                Offset (0x2A0), 
                                    ,   7, 
                                SSBY,   1, 
                                Offset (0x2A8), 
                                SSS0,   4, 
                                Offset (0x2A9), 
                                SSS1,   4, 
                                Offset (0x2AC)
                            }

                            If (LOr (LEqual (OSTY, 0x06), LEqual (OSTY, 0x04)))
                            {
                                If (SMS1)
                                {
                                    Store (0x32, Local0)
                                    While (LAnd (LEqual (SMBY, One), Local0))
                                    {
                                        Sleep (0xFA)
                                        Decrement (Local0)
                                    }
                                }

                                If (SSS1)
                                {
                                    Store (0x32, Local0)
                                    While (LAnd (LEqual (SSBY, One), Local0))
                                    {
                                        Sleep (0xFA)
                                        Decrement (Local0)
                                    }
                                }
                            }

                            Store (Zero, SECS)
                        }

                        Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                        {
                            Store (0x03, SECS)
                        }

                        Method (_PSC, 0, NotSerialized)  // _PSC: Power State Current
                        {
                            Return (SECS)
                        }

                        Device (S_D0)
                        {
                            Name (_ADR, Zero)  // _ADR: Address
                            Method (_STA, 0, NotSerialized)  // _STA: Status
                            {
                                OperationRegion (BAR, SystemMemory, STB5, 0x0400)
                                Field (BAR, AnyAcc, NoLock, Preserve)
                                {
                                    Offset (0x1A8), 
                                    SMS0,   4, 
                                    Offset (0x1A9), 
                                    SMS1,   4
                                }

                                If (Not (LEqual (SMS1, Zero)))
                                {
                                    Return (0x0F)
                                }
                                Else
                                {
                                    Return (Zero)
                                }
                            }

                            Name (S12P, Zero)
                            Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                            {
                                OperationRegion (BAR, SystemMemory, STB5, 0x1000)
                                Field (BAR, AnyAcc, NoLock, Preserve)
                                {
                                    Offset (0x1A0), 
                                        ,   7, 
                                    SMBY,   1
                                }

                                Store (0x32, Local0)
                                While (LAnd (LEqual (SMBY, One), Local0))
                                {
                                    Sleep (0xFA)
                                    Decrement (Local0)
                                }

                                Store (Zero, S12P)
                            }

                            Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                            {
                                Store (0x03, S12P)
                            }

                            Method (_PSC, 0, NotSerialized)  // _PSC: Power State Current
                            {
                                Return (S12P)
                            }
                        }

                        Device (S_D1)
                        {
                            Name (_ADR, One)  // _ADR: Address
                            Method (_STA, 0, NotSerialized)  // _STA: Status
                            {
                                OperationRegion (BAR, SystemMemory, STB5, 0x0400)
                                Field (BAR, AnyAcc, NoLock, Preserve)
                                {
                                    Offset (0x2A8), 
                                    SSS0,   4, 
                                    Offset (0x2A9), 
                                    SSS1,   4
                                }

                                If (Not (LEqual (SSS1, Zero)))
                                {
                                    Return (0x0F)
                                }
                                Else
                                {
                                    Return (Zero)
                                }
                            }

                            Name (S12P, Zero)
                            Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                            {
                                OperationRegion (BAR, SystemMemory, STB5, 0x0400)
                                Field (BAR, AnyAcc, NoLock, Preserve)
                                {
                                    Offset (0x2A0), 
                                        ,   7, 
                                    SSBY,   1
                                }

                                Store (0x32, Local0)
                                While (LAnd (LEqual (SSBY, One), Local0))
                                {
                                    Sleep (0xFA)
                                    Decrement (Local0)
                                }

                                Store (Zero, S12P)
                            }

                            Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                            {
                                Store (0x03, S12P)
                            }

                            Method (_PSC, 0, NotSerialized)  // _PSC: Power State Current
                            {
                                Return (S12P)
                            }
                        }
                    }
                }
            }

            Device (PE20)
            {
                Name (_ADR, 0x00150000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0F, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR20)
                    }

                    Return (PR20)
                }
            }

            Device (PE21)
            {
                Name (_ADR, 0x00150001)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x10, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR21)
                    }

                    Return (PR21)
                }
            }

            Device (PE22)
            {
                Name (_ADR, 0x00150002)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x11, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR22)
                    }

                    Return (PR22)
                }
            }

            Device (PE23)
            {
                Name (_ADR, 0x00150003)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x12, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR23)
                    }

                    Return (PR23)
                }
            }
        }

        Scope (\_GPE)
        {
            Method (_L18, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.PC02, 0x02)
                Notify (\_SB.PCI0.PC03, 0x02)
                Notify (\_SB.PCI0.PC04, 0x02)
                Notify (\_SB.PCI0.PC05, 0x02)
                Notify (\_SB.PCI0.PC06, 0x02)
                Notify (\_SB.PCI0.PC09, 0x02)
                Notify (\_SB.PCI0.PC0A, 0x02)
                Notify (\_SB.PCI0.PC0B, 0x02)
                Notify (\_SB.PCI0.PC0D, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L1B, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.SBAZ, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L1D, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                \_SB.PCI0.SBRG.SIOH ()
            }

            Method (_L03, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                \_SB.PCI0.SBRG.SIOH ()
            }

            Method (_L16, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                \_SB.PCI0.SBRG.SIOH ()
            }

            Method (_L04, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.P0PC, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0B, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.UHC1, 0x02)
                Notify (\_SB.PCI0.UHC2, 0x02)
                Notify (\_SB.PCI0.USB3, 0x02)
                Notify (\_SB.PCI0.UHC4, 0x02)
                Notify (\_SB.PCI0.USB5, 0x02)
                Notify (\_SB.PCI0.UHC6, 0x02)
                Notify (\_SB.PCI0.UHC7, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0F, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.PE20, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L10, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.PE21, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L11, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.PE22, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L12, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.PE23, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
        }

        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))  // _HID: Hardware ID
            Name (_UID, 0xAA)  // _UID: Unique ID
            Name (_STA, 0x0B)  // _STA: Status
        }
    }

    Scope (_SB)
    {
        OperationRegion (PIRQ, SystemIO, 0x0C00, 0x02)
        Field (PIRQ, ByteAcc, NoLock, Preserve)
        {
            PIDX,   8, 
            PDAT,   8
        }

        IndexField (PIDX, PDAT, ByteAcc, NoLock, Preserve)
        {
            PIRA,   8, 
            PIRB,   8, 
            PIRC,   8, 
            PIRD,   8, 
            PIRE,   8, 
            PIRF,   8, 
            PIRG,   8, 
            PIRH,   8, 
            Offset (0x10), 
            PIRS,   8, 
            Offset (0x13), 
            HDAD,   8, 
            Offset (0x15), 
            GEC,    8, 
            Offset (0x30), 
            USB1,   8, 
            USB2,   8, 
            USB3,   8, 
            USB4,   8, 
            USB5,   8, 
            USB6,   8, 
            USB7,   8, 
            Offset (0x40), 
            IDE,    8, 
            SATA,   8, 
            Offset (0x50), 
            GPP0,   8, 
            GPP1,   8, 
            GPP2,   8, 
            GPP3,   8
        }

        OperationRegion (KBDD, SystemIO, 0x64, One)
        Field (KBDD, ByteAcc, NoLock, Preserve)
        {
            PD64,   8
        }

        Method (IRQC, 0, NotSerialized)
        {
            INTA (0x1F)
            INTB (0x1F)
            INTC (0x1F)
            INTD (0x1F)
            Store (PD64, Local1)
            Store (0x1F, PIRE)
            Store (0x1F, PIRF)
            Store (0x1F, PIRG)
            Store (0x1F, PIRH)
        }

        Method (INTA, 1, NotSerialized)
        {
            Store (Arg0, PIRA)
            Store (Arg0, HDAD)
            Store (Arg0, GEC)
            Store (Arg0, GPP0)
            Store (Arg0, GPP0)
        }

        Method (INTB, 1, NotSerialized)
        {
            Store (Arg0, PIRB)
            Store (Arg0, USB2)
            Store (Arg0, USB4)
            Store (Arg0, USB6)
            Store (Arg0, GPP1)
            Store (Arg0, IDE)
        }

        Method (INTC, 1, NotSerialized)
        {
            Store (Arg0, PIRC)
            Store (Arg0, USB1)
            Store (Arg0, USB3)
            Store (Arg0, USB5)
            Store (Arg0, USB7)
            Store (Arg0, GPP2)
        }

        Method (INTD, 1, NotSerialized)
        {
            Store (Arg0, PIRD)
            Store (Arg0, SATA)
            Store (Arg0, GPP3)
        }

        Name (BUFA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {15}
        })
        Name (IPRA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {5,10,11}
        })
        Name (IPRB, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {5,10,11}
        })
        Name (IPRC, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {5,10,11}
        })
        Name (IPRD, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {5,10,11}
        })
        Device (LNKA)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, One)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                If (PIRA)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSA)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                INTA (0x1F)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                CreateWordField (BUFA, One, IRQX)
                ShiftLeft (One, PIRA, IRQX)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                INTA (Local0)
            }
        }

        Device (LNKB)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x02)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                If (PIRB)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSB)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                INTB (0x1F)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                CreateWordField (BUFA, One, IRQX)
                ShiftLeft (One, PIRB, IRQX)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                INTB (Local0)
            }
        }

        Device (LNKC)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x03)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                If (PIRC)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSC)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                INTC (0x1F)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                CreateWordField (BUFA, One, IRQX)
                ShiftLeft (One, PIRC, IRQX)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                INTC (Local0)
            }
        }

        Device (LNKD)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x04)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                If (PIRD)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSD)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                INTD (0x1F)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                CreateWordField (BUFA, One, IRQX)
                ShiftLeft (One, PIRD, IRQX)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                INTD (Local0)
            }
        }

        Device (LNKE)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x05)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                If (PIRE)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSE)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                Store (0x1F, PIRE)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                CreateWordField (BUFA, One, IRQX)
                ShiftLeft (One, PIRE, IRQX)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (PIRE, Local0)
                Decrement (Local0)
                Store (Local0, PIRE)
            }
        }

        Device (LNKF)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x02)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                If (PIRF)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSF)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                Store (0x1F, PIRF)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                CreateWordField (BUFA, One, IRQX)
                ShiftLeft (One, PIRF, IRQX)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRF)
            }
        }

        Device (LNKG)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x03)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                If (PIRG)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSG)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                Store (0x1F, PIRG)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                CreateWordField (BUFA, One, IRQX)
                ShiftLeft (One, PIRG, IRQX)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRG)
            }
        }

        Device (LNKH)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x04)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                If (PIRH)
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (0x09)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSH)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                Store (0x1F, PIRH)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                CreateWordField (BUFA, One, IRQX)
                ShiftLeft (One, PIRH, IRQX)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRH)
            }
        }
    }

    Scope (_SB.PCI0.SBRG)
    {
        Method (SIOH, 0, NotSerialized)
        {
            Notify (PWRB, 0x02)
        }
    }

    Scope (_PR)
    {
        OperationRegion (SSDT, SystemMemory, 0xFFFF0000, 0xFFFF)
        Name (DCOR, 0x02)
        Name (TBLD, 0x04)
        Name (NPSS, 0x05)
        Name (HNDL, 0x80000000)
        Name (APSS, Package (0x0A)
        {
            Package (0x06)
            {
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF
            }, 

            Package (0x06)
            {
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF
            }, 

            Package (0x06)
            {
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF
            }, 

            Package (0x06)
            {
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF
            }, 

            Package (0x06)
            {
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF
            }, 

            Package (0x06)
            {
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF
            }, 

            Package (0x06)
            {
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF
            }, 

            Package (0x06)
            {
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF
            }, 

            Package (0x06)
            {
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF
            }, 

            Package (0x06)
            {
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF, 
                0xFFFF
            }
        })
        Processor (P001, 0x01, 0x00000810, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LAnd (LEqual (TBLD, Zero), LNotEqual (NPSS, Zero)))
                {
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        Store (One, TBLD)
                        Load (SSDT, HNDL)
                    }
                }
            }
        }

        Processor (P002, 0x02, 0x00000810, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LAnd (LEqual (TBLD, Zero), LNotEqual (NPSS, Zero)))
                {
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        Store (One, TBLD)
                        Load (SSDT, HNDL)
                    }
                }
            }
        }

        Processor (P003, 0x03, 0x00000810, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LAnd (LEqual (TBLD, Zero), LNotEqual (NPSS, Zero)))
                {
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        Store (One, TBLD)
                        Load (SSDT, HNDL)
                    }
                }
            }
        }

        Processor (P004, 0x04, 0x00000810, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LAnd (LEqual (TBLD, Zero), LNotEqual (NPSS, Zero)))
                {
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        Store (One, TBLD)
                        Load (SSDT, HNDL)
                    }
                }
            }
        }

        Processor (P005, 0x05, 0x00000810, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LAnd (LEqual (TBLD, Zero), LNotEqual (NPSS, Zero)))
                {
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        Store (One, TBLD)
                        Load (SSDT, HNDL)
                    }
                }
            }
        }

        Processor (P006, 0x06, 0x00000810, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LAnd (LEqual (TBLD, Zero), LNotEqual (NPSS, Zero)))
                {
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        Store (One, TBLD)
                        Load (SSDT, HNDL)
                    }
                }
            }
        }

        Processor (P007, 0x07, 0x00000810, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LAnd (LEqual (TBLD, Zero), LNotEqual (NPSS, Zero)))
                {
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        Store (One, TBLD)
                        Load (SSDT, HNDL)
                    }
                }
            }
        }

        Processor (P008, 0x08, 0x00000810, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LAnd (LEqual (TBLD, Zero), LNotEqual (NPSS, Zero)))
                {
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        Store (One, TBLD)
                        Load (SSDT, HNDL)
                    }
                }
            }
        }
    }

    Scope (_SB.PCI0)
    {
        Method (_INI, 0, NotSerialized)  // _INI: Initialize
        {
            If (LLessEqual (RVID, 0x13)) {}
        }
    }

    Device (HPET)
    {
        Name (_HID, EisaId ("PNP0103"))  // _HID: Hardware ID
        Name (CRS, ResourceTemplate ()
        {
            Memory32Fixed (ReadOnly,
                0xFED00000,         // Address Base
                0x00000400,         // Address Length
                _Y23)
        })
        Method (_STA, 0, NotSerialized)  // _STA: Status
        {
            Return (0x0F)
        }

        Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
        {
            CreateDWordField (CRS, \HPET._Y23._BAS, HPT)  // _BAS: Base Address
            Store (0xFED00000, HPT)
            Return (CRS)
        }
    }

    Name (WOTB, Zero)
    Name (WSSB, Zero)
    Name (WAXB, Zero)
    Method (_PTS, 1, NotSerialized)  // _PTS: Prepare To Sleep
    {
        Store (Arg0, DBG8)
        If (LAnd (LEqual (Arg0, 0x04), LEqual (OSFL (), 0x02)))
        {
            Sleep (0x0BB8)
        }

        PTS (Arg0)
        Store (Zero, Index (WAKP, Zero))
        Store (Zero, Index (WAKP, One))
        Store (ASSB, WSSB)
        Store (AOTB, WOTB)
        Store (AAXB, WAXB)
        Store (Arg0, ASSB)
        Store (OSFL (), AOTB)
        Store (Zero, AAXB)
    }

    Method (_WAK, 1, NotSerialized)  // _WAK: Wake
    {
        ShiftLeft (Arg0, 0x04, DBG8)
        WAK (Arg0)
        If (ASSB)
        {
            Store (WSSB, ASSB)
            Store (WOTB, AOTB)
            Store (WAXB, AAXB)
        }

        If (DerefOf (Index (WAKP, Zero)))
        {
            Store (Zero, Index (WAKP, One))
        }
        Else
        {
            Store (Arg0, Index (WAKP, One))
        }

        Return (WAKP)
    }

    Device (OMSC)
    {
        Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
        Name (_UID, 0x0E11)  // _UID: Unique ID
    }

    Device (_SB.RMEM)
    {
        Name (_HID, EisaId ("PNP0C01"))  // _HID: Hardware ID
        Name (_UID, One)  // _UID: Unique ID
    }

    If (OSCF)
    {
        Scope (_SB.PCI0)
        {
            Method (_OSC, 4, NotSerialized)  // _OSC: Operating System Capabilities
            {
                Name (SUPP, Zero)
                Name (CTRL, Zero)
                If (LEqual (Arg0, Buffer (0x10)
                        {
                            /* 0000 */   0x5B, 0x4D, 0xDB, 0x33, 0xF7, 0x1F, 0x1C, 0x40,
                            /* 0008 */   0x96, 0x57, 0x74, 0x41, 0xC0, 0x3D, 0xD7, 0x66
                        }))
                {
                    CreateDWordField (Arg3, Zero, CDW1)
                    CreateDWordField (Arg3, 0x04, CDW2)
                    CreateDWordField (Arg3, 0x08, CDW3)
                    Store (CDW2, SUPP)
                    Store (CDW3, CTRL)
                    If (LNotEqual (And (SUPP, 0x16), 0x16))
                    {
                        And (CTRL, 0x1E)
                    }

                    And (CTRL, 0x1D, CTRL)
                    If (Not (And (CDW1, One)))
                    {
                        If (And (CTRL, One)) {}
                        If (And (CTRL, 0x04))
                        {
                            Store (One, EPNM)
                        }
                        Else
                        {
                            Store (Zero, EPNM)
                        }

                        If (And (CTRL, 0x10)) {}
                    }

                    If (LNotEqual (Arg1, One))
                    {
                        Or (CDW1, 0x08, CDW1)
                    }

                    If (LNotEqual (CDW3, CTRL))
                    {
                        Or (CDW1, 0x10, CDW1)
                    }

                    Store (CTRL, CDW3)
                    Return (Arg3)
                }
                Else
                {
                    Or (CDW1, 0x04, CDW1)
                    Return (Arg3)
                }
            }
        }
    }

    Scope (\)
    {
        OperationRegion (NCLK, SystemMemory, PCIE, 0x02000000)
        Field (NCLK, AnyAcc, NoLock, Preserve)
        {
            Offset (0x4C), 
            CLKE,   1, 
            Offset (0x1048), 
            P3HH,   12, 
                ,   19, 
            P3EE,   1, 
            P4EN,   1, 
            P4NM,   12, 
            P4HI,   12, 
            P4IO,   1, 
            Offset (0x1050), 
            P5EN,   1, 
            P5NM,   12, 
            P5HI,   12, 
            P5IO,   1, 
            Offset (0x1054), 
            P6EN,   1, 
            P6NM,   12, 
            P6HI,   12, 
            P6IO,   1, 
            Offset (0x10B0), 
            P1NM,   12, 
            P1HI,   12, 
            P1EN,   1, 
            P1IO,   1, 
            Offset (0x10B4), 
            P2NM,   12, 
            P2HI,   12, 
            P2EN,   1, 
            P2IO,   1, 
            Offset (0x10CC), 
            P3EN,   1, 
            P3NM,   12, 
            P3HI,   12, 
            P3IO,   1
        }

        OperationRegion (SOR1, SystemIO, SBA1, 0x10)
        Field (SOR1, ByteAcc, NoLock, Preserve)
        {
            SMSA,   8, 
            SSSA,   8, 
            SBCA,   8, 
            SHCA,   8, 
            SBAA,   8, 
            SD0A,   8, 
            SD1A,   8, 
            SBDA,   8, 
            SSCA,   8, 
            SMCA,   8, 
            SSEA,   16, 
            SSDA,   16, 
            SMTA,   8
        }

        OperationRegion (SOR2, SystemIO, SBA2, 0x10)
        Field (SOR2, ByteAcc, NoLock, Preserve)
        {
            SMSB,   8, 
            SSSB,   8, 
            SBCB,   8, 
            SHCB,   8, 
            SBAB,   8, 
            SD0B,   8, 
            SD1B,   8, 
            SBDB,   8, 
            SSCB,   8, 
            SMCB,   8, 
            SSEB,   16, 
            SSDB,   16, 
            SMTB,   8
        }

        Mutex (MSMB, 0x00)
        Method (RWBK, 5, NotSerialized)
        {
            Acquire (MSMB, 0xFFFF)
            If (LEqual (Arg0, Zero))
            {
                Store (SMSA, Local0)
                And (Local0, Zero, Local0)
                Or (Local0, 0xFF, Local0)
                Store (Local0, SMSA)
                Sleep (0x02)
                Store (SBAA, Local0)
                And (Local0, Zero, Local0)
                Or (Local0, Arg1, Local0)
                Store (Local0, SBAA)
                Sleep (0x02)
                Store (SHCA, Local0)
                And (Local0, Zero, Local0)
                Or (Local0, Arg2, Local0)
                Store (Local0, SHCA)
                Sleep (0x02)
                Store (SBCA, Local0)
                And (Local0, Zero, Local0)
                Or (Local0, 0x14, Local0)
                Store (Local0, SBCA)
                Sleep (0x02)
                Store (SD0A, Local0)
                And (Local0, Zero, Local0)
                Or (Local0, Arg3, Local0)
                Store (Local0, SD0A)
                Sleep (0x02)
                And (Arg1, One, Local1)
                If (LEqual (Local1, Zero))
                {
                    Store (Arg3, Local2)
                    Store (Arg2, Local3)
                    While (Local2)
                    {
                        Store (DerefOf (Index (Arg4, Local3)), Local4)
                        Store (Local4, SBDA)
                        Sleep (0x02)
                        Decrement (Local2)
                        Increment (Local3)
                    }
                }

                Store (SBCA, Local0)
                And (Local0, Zero, Local0)
                Or (Local0, 0x54, Local0)
                Store (Local0, SBCA)
                Sleep (0x02)
                Store (SMSA, Local1)
                While (LNot (And (Local1, One)))
                {
                    Store (SMSA, Local1)
                    If (And (Local1, 0x1C))
                    {
                        Release (MSMB)
                        Return (One)
                    }

                    If (And (Local1, 0x02))
                    {
                        Break
                    }

                    Sleep (0x02)
                }

                Store (SMSA, Local1)
                While (And (Local1, One))
                {
                    Store (SMSA, Local1)
                    Sleep (0x02)
                }

                And (Arg1, One, Local1)
                If (Local1)
                {
                    Store (Arg2, Local1)
                    Store (Arg3, Local2)
                    While (Local2)
                    {
                        Store (SBDA, Index (Arg4, Local1))
                        Sleep (0x02)
                        Increment (Local1)
                        Decrement (Local2)
                    }
                }
            }

            If (LEqual (Arg0, One)) {}
            Release (MSMB)
            Return (Zero)
        }

        OperationRegion (IOOR, SystemIO, SIOP, 0x02)
        Field (IOOR, ByteAcc, NoLock, Preserve)
        {
            IOID,   8, 
            IODT,   8
        }

        Method (RSIO, 1, NotSerialized)
        {
            Store (Arg0, IOID)
            Return (IODT)
        }

        Method (WSIO, 2, NotSerialized)
        {
            Store (Arg0, IOID)
            Store (Arg1, IODT)
        }

        Method (RWIO, 3, NotSerialized)
        {
            WSIO (Arg0, Or (And (RSIO (Arg0), Arg1), Arg2))
        }

        Name (IPSW, Package (0x02)
        {
            Package (0x02)
            {
                0x87, 
                0x87
            }, 

            Package (0x02)
            {
                0x87, 
                0x87
            }
        })
        Method (SLDN, 1, NotSerialized)
        {
            Store (Zero, Local1)
            If (LEqual (SIOP, 0x2E))
            {
                Store (Zero, Local1)
            }

            If (LEqual (SIOP, 0x4E))
            {
                Store (One, Local1)
            }

            Store (Zero, Local0)
            While (LNotEqual (Local0, 0x02))
            {
                Store (DerefOf (Index (DerefOf (Index (IPSW, Local1)), Local0)), 
                    IOID)
                Increment (Local0)
            }

            WSIO (0x07, Arg0)
        }

        Method (APTS, 1, NotSerialized)
        {
            \AOD.APTS (Arg0)
        }

        Method (AWAK, 1, NotSerialized)
        {
            \AOD.AWAK (Arg0)
        }

        Device (AOD)
        {
            Name (DBG, One)
            Name (OBID, Package (0x1C)
            {
                0x03, 
                0x01010000, 
                0x01020000, 
                0x01030000, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                One, 
                One, 
                One, 
                0xFF, 
                0xFF, 
                0xFF, 
                0xFF, 
                0xFF, 
                0xFF, 
                "CPU Clock", 
                "PCIE Clock", 
                "South Bridge Clock", 
                "", 
                "", 
                "", 
                "", 
                "", 
                ""
            })
            Name (OBIT, Package (0x2B)
            {
                0x01010000, 
                0x000249F0, 
                0x00061A80, 
                Zero, 
                0x03E8, 
                Zero, 
                0x01020000, 
                0x000124F8, 
                0x00030D40, 
                Zero, 
                0x03E8, 
                Zero, 
                0x01030000, 
                0x00015F90, 
                0x000249F0, 
                Zero, 
                0x03E8, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero
            })
            Name (OBDT, Package (0x13)
            {
                0x02010000, 
                0x10, 
                0x0002BF20, 
                0x0002D2A8, 
                0x0002E630, 
                0x0002F9B8, 
                0x00030D40, 
                0x000320C8, 
                0x000347D8, 
                0x00035B60, 
                0x00038270, 
                0x000395F8, 
                0x0003A980, 
                0x0003BD08, 
                0x0003E418, 
                0x0003F7A0, 
                0x00040B28, 
                0x00041EB0, 
                Zero
            })
            Method (BM01, 0, NotSerialized)
            {
            }

            Method (XINI, 0, NotSerialized)
            {
            }

            Method (EM01, 0, NotSerialized)
            {
            }

            Method (BM05, 1, NotSerialized)
            {
            }

            Method (EM05, 1, NotSerialized)
            {
            }

            Method (HM06, 0, NotSerialized)
            {
            }

            Method (HM07, 1, NotSerialized)
            {
            }

            Name (PWMT, Package (0x0A)
            {
                One, 
                0x3F, 
                Package (0x3F)
                {
                    Package (0x02)
                    {
                        0x0001D4C0, 
                        Zero
                    }, 

                    Package (0x02)
                    {
                        0x0001D8A8, 
                        One
                    }, 

                    Package (0x02)
                    {
                        0x0001DC90, 
                        0x02
                    }, 

                    Package (0x02)
                    {
                        0x0001E078, 
                        0x03
                    }, 

                    Package (0x02)
                    {
                        0x0001E460, 
                        0x04
                    }, 

                    Package (0x02)
                    {
                        0x0001E848, 
                        0x05
                    }, 

                    Package (0x02)
                    {
                        0x0001EC30, 
                        0x06
                    }, 

                    Package (0x02)
                    {
                        0x0001F018, 
                        0x07
                    }, 

                    Package (0x02)
                    {
                        0x0001F400, 
                        0x08
                    }, 

                    Package (0x02)
                    {
                        0x0001F7E8, 
                        0x09
                    }, 

                    Package (0x02)
                    {
                        0x0001FBD0, 
                        0x0A
                    }, 

                    Package (0x02)
                    {
                        0x0001FFB8, 
                        0x0B
                    }, 

                    Package (0x02)
                    {
                        0x000203A0, 
                        0x0C
                    }, 

                    Package (0x02)
                    {
                        0x00020788, 
                        0x0D
                    }, 

                    Package (0x02)
                    {
                        0x00020B70, 
                        0x0E
                    }, 

                    Package (0x02)
                    {
                        0x00020F58, 
                        0x0F
                    }, 

                    Package (0x02)
                    {
                        0x00021340, 
                        0x10
                    }, 

                    Package (0x02)
                    {
                        0x00021728, 
                        0x11
                    }, 

                    Package (0x02)
                    {
                        0x00021B10, 
                        0x12
                    }, 

                    Package (0x02)
                    {
                        0x00021EF8, 
                        0x13
                    }, 

                    Package (0x02)
                    {
                        0x000222E0, 
                        0x14
                    }, 

                    Package (0x02)
                    {
                        0x000226C8, 
                        0x15
                    }, 

                    Package (0x02)
                    {
                        0x00022AB0, 
                        0x16
                    }, 

                    Package (0x02)
                    {
                        0x00022E98, 
                        0x17
                    }, 

                    Package (0x02)
                    {
                        0x00023280, 
                        0x18
                    }, 

                    Package (0x02)
                    {
                        0x00023668, 
                        0x19
                    }, 

                    Package (0x02)
                    {
                        0x00023A50, 
                        0x1A
                    }, 

                    Package (0x02)
                    {
                        0x00023E38, 
                        0x1B
                    }, 

                    Package (0x02)
                    {
                        0x00024220, 
                        0x1C
                    }, 

                    Package (0x02)
                    {
                        0x00024608, 
                        0x1D
                    }, 

                    Package (0x02)
                    {
                        0x000249F0, 
                        0x1E
                    }, 

                    Package (0x02)
                    {
                        0x00024DD8, 
                        0x1F
                    }, 

                    Package (0x02)
                    {
                        0x000251C0, 
                        0x20
                    }, 

                    Package (0x02)
                    {
                        0x000255A8, 
                        0x21
                    }, 

                    Package (0x02)
                    {
                        0x00025990, 
                        0x22
                    }, 

                    Package (0x02)
                    {
                        0x00025D78, 
                        0x23
                    }, 

                    Package (0x02)
                    {
                        0x00026160, 
                        0x24
                    }, 

                    Package (0x02)
                    {
                        0x00026548, 
                        0x25
                    }, 

                    Package (0x02)
                    {
                        0x00026930, 
                        0x26
                    }, 

                    Package (0x02)
                    {
                        0x00026D18, 
                        0x27
                    }, 

                    Package (0x02)
                    {
                        0x00027100, 
                        0x28
                    }, 

                    Package (0x02)
                    {
                        0x000274E8, 
                        0x29
                    }, 

                    Package (0x02)
                    {
                        0x000278D0, 
                        0x2A
                    }, 

                    Package (0x02)
                    {
                        0x00027CB8, 
                        0x2B
                    }, 

                    Package (0x02)
                    {
                        0x000280A0, 
                        0x2C
                    }, 

                    Package (0x02)
                    {
                        0x00028488, 
                        0x2D
                    }, 

                    Package (0x02)
                    {
                        0x00028870, 
                        0x2E
                    }, 

                    Package (0x02)
                    {
                        0x00028C58, 
                        0x2F
                    }, 

                    Package (0x02)
                    {
                        0x00029040, 
                        0x30
                    }, 

                    Package (0x02)
                    {
                        0x00029428, 
                        0x31
                    }, 

                    Package (0x02)
                    {
                        0x00029810, 
                        0x32
                    }, 

                    Package (0x02)
                    {
                        0x00029BF8, 
                        0x33
                    }, 

                    Package (0x02)
                    {
                        0x00029FE0, 
                        0x34
                    }, 

                    Package (0x02)
                    {
                        0x0002A3C8, 
                        0x35
                    }, 

                    Package (0x02)
                    {
                        0x0002A7B0, 
                        0x36
                    }, 

                    Package (0x02)
                    {
                        0x0002AB98, 
                        0x37
                    }, 

                    Package (0x02)
                    {
                        0x0002AF80, 
                        0x38
                    }, 

                    Package (0x02)
                    {
                        0x0002B368, 
                        0x39
                    }, 

                    Package (0x02)
                    {
                        0x0002B750, 
                        0x3A
                    }, 

                    Package (0x02)
                    {
                        0x0002BB38, 
                        0x3B
                    }, 

                    Package (0x02)
                    {
                        0x0002BF20, 
                        0x3C
                    }, 

                    Package (0x02)
                    {
                        0x0002C308, 
                        0x3D
                    }, 

                    Package (0x02)
                    {
                        0x0002C6F0, 
                        0x3E
                    }
                }, 

                0x02, 
                0x37, 
                Package (0x37)
                {
                    Package (0x02)
                    {
                        0x0001B0D0, 
                        Zero
                    }, 

                    Package (0x02)
                    {
                        0x0001B5E4, 
                        One
                    }, 

                    Package (0x02)
                    {
                        0x0001BA94, 
                        0x02
                    }, 

                    Package (0x02)
                    {
                        0x0001BFA8, 
                        0x03
                    }, 

                    Package (0x02)
                    {
                        0x0001C4BC, 
                        0x04
                    }, 

                    Package (0x02)
                    {
                        0x0001C96C, 
                        0x05
                    }, 

                    Package (0x02)
                    {
                        0x0001CE80, 
                        0x06
                    }, 

                    Package (0x02)
                    {
                        0x0001D394, 
                        0x07
                    }, 

                    Package (0x02)
                    {
                        0x0001D844, 
                        0x08
                    }, 

                    Package (0x02)
                    {
                        0x0001DD58, 
                        0x09
                    }, 

                    Package (0x02)
                    {
                        0x0001E26C, 
                        0x0A
                    }, 

                    Package (0x02)
                    {
                        0x0001E780, 
                        0x0B
                    }, 

                    Package (0x02)
                    {
                        0x0001EC30, 
                        0x0C
                    }, 

                    Package (0x02)
                    {
                        0x0001F144, 
                        0x0D
                    }, 

                    Package (0x02)
                    {
                        0x0001F658, 
                        0x0E
                    }, 

                    Package (0x02)
                    {
                        0x0001FB08, 
                        0x0F
                    }, 

                    Package (0x02)
                    {
                        0x0002001C, 
                        0x10
                    }, 

                    Package (0x02)
                    {
                        0x00020530, 
                        0x11
                    }, 

                    Package (0x02)
                    {
                        0x000209E0, 
                        0x12
                    }, 

                    Package (0x02)
                    {
                        0x00020EF4, 
                        0x13
                    }, 

                    Package (0x02)
                    {
                        0x00021408, 
                        0x14
                    }, 

                    Package (0x02)
                    {
                        0x0002191C, 
                        0x15
                    }, 

                    Package (0x02)
                    {
                        0x00021DCC, 
                        0x16
                    }, 

                    Package (0x02)
                    {
                        0x000222E0, 
                        0x17
                    }, 

                    Package (0x02)
                    {
                        0x000227F4, 
                        0x18
                    }, 

                    Package (0x02)
                    {
                        0x00022CA4, 
                        0x19
                    }, 

                    Package (0x02)
                    {
                        0x000231B8, 
                        0x1A
                    }, 

                    Package (0x02)
                    {
                        0x000236CC, 
                        0x1B
                    }, 

                    Package (0x02)
                    {
                        0x00023B7C, 
                        0x1C
                    }, 

                    Package (0x02)
                    {
                        0x00024090, 
                        0x1D
                    }, 

                    Package (0x02)
                    {
                        0x000245A4, 
                        0x1E
                    }, 

                    Package (0x02)
                    {
                        0x00024AB8, 
                        0x1F
                    }, 

                    Package (0x02)
                    {
                        0x00024F68, 
                        0x20
                    }, 

                    Package (0x02)
                    {
                        0x0002547C, 
                        0x21
                    }, 

                    Package (0x02)
                    {
                        0x00025990, 
                        0x22
                    }, 

                    Package (0x02)
                    {
                        0x00025E40, 
                        0x23
                    }, 

                    Package (0x02)
                    {
                        0x00026354, 
                        0x24
                    }, 

                    Package (0x02)
                    {
                        0x00026868, 
                        0x25
                    }, 

                    Package (0x02)
                    {
                        0x00026D18, 
                        0x26
                    }, 

                    Package (0x02)
                    {
                        0x0002722C, 
                        0x27
                    }, 

                    Package (0x02)
                    {
                        0x00027740, 
                        0x28
                    }, 

                    Package (0x02)
                    {
                        0x00027C54, 
                        0x29
                    }, 

                    Package (0x02)
                    {
                        0x00028104, 
                        0x2A
                    }, 

                    Package (0x02)
                    {
                        0x00028618, 
                        0x2B
                    }, 

                    Package (0x02)
                    {
                        0x00028B2C, 
                        0x2C
                    }, 

                    Package (0x02)
                    {
                        0x00028FDC, 
                        0x2D
                    }, 

                    Package (0x02)
                    {
                        0x000294F0, 
                        0x2E
                    }, 

                    Package (0x02)
                    {
                        0x00029A04, 
                        0x2F
                    }, 

                    Package (0x02)
                    {
                        0x00029EB4, 
                        0x30
                    }, 

                    Package (0x02)
                    {
                        0x0002A3C8, 
                        0x31
                    }, 

                    Package (0x02)
                    {
                        0x0002A8DC, 
                        0x32
                    }, 

                    Package (0x02)
                    {
                        0x0002ADF0, 
                        0x33
                    }, 

                    Package (0x02)
                    {
                        0x0002B2A0, 
                        0x34
                    }, 

                    Package (0x02)
                    {
                        0x0002B7B4, 
                        0x35
                    }, 

                    Package (0x02)
                    {
                        0x0002BCC8, 
                        0x36
                    }
                }, 

                0x03, 
                0x24, 
                Package (0x24)
                {
                    Package (0x02)
                    {
                        0x00020A44, 
                        0x43
                    }, 

                    Package (0x02)
                    {
                        0x0002259C, 
                        0x42
                    }, 

                    Package (0x02)
                    {
                        0x000240F4, 
                        0x41
                    }, 

                    Package (0x02)
                    {
                        0x00025C4C, 
                        Zero
                    }, 

                    Package (0x02)
                    {
                        0x000261C4, 
                        One
                    }, 

                    Package (0x02)
                    {
                        0x0002673C, 
                        0x02
                    }, 

                    Package (0x02)
                    {
                        0x00026CB4, 
                        0x03
                    }, 

                    Package (0x02)
                    {
                        0x0002722C, 
                        0x04
                    }, 

                    Package (0x02)
                    {
                        0x000277A4, 
                        0x05
                    }, 

                    Package (0x02)
                    {
                        0x00027D1C, 
                        0x06
                    }, 

                    Package (0x02)
                    {
                        0x00028294, 
                        0x07
                    }, 

                    Package (0x02)
                    {
                        0x0002880C, 
                        0x08
                    }, 

                    Package (0x02)
                    {
                        0x00028D84, 
                        0x09
                    }, 

                    Package (0x02)
                    {
                        0x000292FC, 
                        0x0A
                    }, 

                    Package (0x02)
                    {
                        0x00029874, 
                        0x0B
                    }, 

                    Package (0x02)
                    {
                        0x00029DEC, 
                        0x0C
                    }, 

                    Package (0x02)
                    {
                        0x0002A364, 
                        0x0D
                    }, 

                    Package (0x02)
                    {
                        0x0002A8DC, 
                        0x0E
                    }, 

                    Package (0x02)
                    {
                        0x0002AE54, 
                        0x0F
                    }, 

                    Package (0x02)
                    {
                        0x0002B3CC, 
                        0x10
                    }, 

                    Package (0x02)
                    {
                        0x0002B944, 
                        0x11
                    }, 

                    Package (0x02)
                    {
                        0x0002BEBC, 
                        0x12
                    }, 

                    Package (0x02)
                    {
                        0x0002C434, 
                        0x13
                    }, 

                    Package (0x02)
                    {
                        0x0002C9AC, 
                        0x14
                    }, 

                    Package (0x02)
                    {
                        0x0002CF24, 
                        0x15
                    }, 

                    Package (0x02)
                    {
                        0x0002D49C, 
                        0x16
                    }, 

                    Package (0x02)
                    {
                        0x0002DA14, 
                        0x17
                    }, 

                    Package (0x02)
                    {
                        0x0002DF8C, 
                        0x18
                    }, 

                    Package (0x02)
                    {
                        0x0002E504, 
                        0x19
                    }, 

                    Package (0x02)
                    {
                        0x0002EA7C, 
                        0x1A
                    }, 

                    Package (0x02)
                    {
                        0x0002EFF4, 
                        0x1B
                    }, 

                    Package (0x02)
                    {
                        0x0002F56C, 
                        0x1C
                    }, 

                    Package (0x02)
                    {
                        0x0002FAE4, 
                        0x1D
                    }, 

                    Package (0x02)
                    {
                        0x0003005C, 
                        0x1E
                    }, 

                    Package (0x02)
                    {
                        0x000305D4, 
                        0x1F
                    }, 

                    Package (0x02)
                    {
                        0x00030B4C, 
                        0x20
                    }
                }, 

                0xFF
            })
            Name (ID01, Zero)
            Name (ID02, Zero)
            Method (SOID, 1, NotSerialized)
            {
                ShiftRight (Arg0, 0x18, ID01)
                ShiftRight (And (Arg0, 0x00FF0000), 0x10, ID02)
                Return (Zero)
            }

            Method (WROW, 4, NotSerialized)
            {
                Name (IFPK, Package (0x06)
                {
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero
                })
                CreateDWordField (Arg0, Zero, BUF0)
                CreateDWordField (Arg0, 0x04, BUF1)
                CreateDWordField (Arg0, 0x08, BUF2)
                CreateDWordField (Arg0, 0x0C, BUF3)
                CreateDWordField (Arg0, 0x10, BUF4)
                CreateDWordField (Arg0, 0x14, BUF5)
                Store (BUF0, Index (IFPK, Zero))
                Store (BUF1, Index (IFPK, One))
                Store (BUF2, Index (IFPK, 0x02))
                Store (BUF3, Index (IFPK, 0x03))
                Store (BUF4, Index (IFPK, 0x04))
                Store (BUF5, Index (IFPK, 0x05))
                Store (Arg3, Local0)
                Store (Zero, Local1)
                While (Local0)
                {
                    Store (DerefOf (Index (IFPK, Local1)), Index (Arg1, Add (Multiply (
                        Arg2, Arg3), Local1)))
                    Increment (Local1)
                    Decrement (Local0)
                }
            }

            Method (GROW, 4, NotSerialized)
            {
                Name (IFPK, Package (0x06)
                {
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero
                })
                Store (Arg3, Local0)
                Store (Zero, Local1)
                While (Local0)
                {
                    Store (DerefOf (Index (Arg0, Add (Multiply (Arg2, Arg3), Local1
                        ))), Index (IFPK, Local1))
                    Increment (Local1)
                    Decrement (Local0)
                }

                CreateDWordField (Arg1, Zero, BUF0)
                CreateDWordField (Arg1, 0x04, BUF1)
                CreateDWordField (Arg1, 0x08, BUF2)
                CreateDWordField (Arg1, 0x0C, BUF3)
                CreateDWordField (Arg1, 0x10, BUF4)
                CreateDWordField (Arg1, 0x14, BUF5)
                Store (DerefOf (Index (IFPK, Zero)), BUF0)
                Store (DerefOf (Index (IFPK, One)), BUF1)
                Store (DerefOf (Index (IFPK, 0x02)), BUF2)
                Store (DerefOf (Index (IFPK, 0x03)), BUF3)
                Store (DerefOf (Index (IFPK, 0x04)), BUF4)
                Store (DerefOf (Index (IFPK, 0x05)), BUF5)
            }

            Method (CPTB, 2, NotSerialized)
            {
                Name (LOID, Zero)
                CreateDWordField (Arg1, Zero, BUF0)
                CreateDWordField (Arg1, 0x04, BUF1)
                CreateDWordField (Arg1, 0x08, BUF2)
                CreateDWordField (Arg1, 0x0C, BUF3)
                CreateDWordField (Arg1, 0x10, BUF4)
                Store (Zero, Local0)
                Store (DerefOf (Index (OBIT, Local0)), LOID)
                While (LOID)
                {
                    If (LEqual (LOID, Arg0))
                    {
                        Store (DerefOf (Index (OBIT, Add (Local0, Zero))), BUF0)
                        Store (DerefOf (Index (OBIT, Add (Local0, One))), BUF1)
                        Store (DerefOf (Index (OBIT, Add (Local0, 0x02))), BUF2)
                        Store (DerefOf (Index (OBIT, Add (Local0, 0x03))), BUF3)
                        Store (DerefOf (Index (OBIT, Add (Local0, 0x04))), BUF4)
                        Break
                    }

                    Add (Local0, 0x06, Local0)
                    Store (DerefOf (Index (OBIT, Local0)), LOID)
                }

                If (LEqual (LOID, Zero))
                {
                    Return (0xFF)
                }

                Return (Zero)
            }

            Method (CBTP, 1, NotSerialized)
            {
                Name (LOID, Zero)
                CreateDWordField (Arg0, Zero, BUF0)
                CreateDWordField (Arg0, 0x04, BUF1)
                CreateDWordField (Arg0, 0x08, BUF2)
                CreateDWordField (Arg0, 0x0C, BUF3)
                CreateDWordField (Arg0, 0x10, BUF4)
                CreateDWordField (Arg0, 0x14, BUF5)
                Store (Zero, Local0)
                Store (DerefOf (Index (OBIT, Local0)), LOID)
                While (LOID)
                {
                    If (LEqual (LOID, BUF0))
                    {
                        Store (BUF0, Index (OBIT, Add (Local0, Zero)))
                        Store (BUF1, Index (OBIT, Add (Local0, One)))
                        Store (BUF2, Index (OBIT, Add (Local0, 0x02)))
                        Store (BUF3, Index (OBIT, Add (Local0, 0x03)))
                        Store (BUF4, Index (OBIT, Add (Local0, 0x04)))
                        Store (BUF5, Index (OBIT, Add (Local0, 0x05)))
                        Break
                    }

                    Add (Local0, 0x06, Local0)
                    Store (DerefOf (Index (OBIT, Local0)), LOID)
                }

                If (LEqual (LOID, Zero))
                {
                    Return (0xFF)
                }

                Return (Zero)
            }

            Method (ABS, 2, NotSerialized)
            {
                If (LLess (Arg0, Arg1))
                {
                    Return (Subtract (Arg1, Arg0))
                }
                Else
                {
                    Return (Subtract (Arg0, Arg1))
                }
            }

            Name (CPUD, Zero)
            Name (GFXD, Zero)
            Name (SBCD, Zero)
            Method (GETC, 1, NotSerialized)
            {
                Store ("getc", Debug)
                If (RWBK (Zero, 0xD3, Zero, 0x20, TSBF))
                {
                    Store (TSBF, Debug)
                    Store (One, GVB2)
                    Store (Zero, GVB1)
                    Return (GVBF)
                }

                Store (TSBF, Debug)
                Store (Zero, GVB2)
                Store (CCLK (Arg0), GVB1)
                Return (GVBF)
            }

            Method (SETC, 2, NotSerialized)
            {
                If (RWBK (Zero, 0xD3, Zero, 0x20, TSBF))
                {
                    Return (One)
                }

                If (LEqual (Arg0, One))
                {
                    Store (GDIV (0x14), Local0)
                    Store (GCCX (0x10, 0x11, 0x14, 0xC350), Local1)
                    Store (Multiply (Arg1, Local0), Local2)
                }
                Else
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (GDIV (0x1C), Local0)
                        Store (GCCX (0x1A, 0x1B, 0x1C, 0x37EE), Local1)
                        Store (Multiply (Arg1, Local0), Local2)
                    }
                    Else
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            Store (GDIV (0x1F), Local0)
                            Store (GCCX (0x1D, 0x1E, 0x1F, 0x37EE), Local1)
                            Store (Multiply (Arg1, Local0), Local2)
                        }
                    }
                }

                Store ("current target clkid", Debug)
                Store (Local1, Debug)
                Store (Local2, Debug)
                Store (Arg0, Debug)
                Store (WTCX (Arg0, Local1, Local2), Local3)
                If (Local3)
                {
                    Return (Local3)
                }

                Return (Zero)
            }

            Method (CINI, 0, NotSerialized)
            {
                If (RWBK (Zero, 0xD3, 0x07, 0x09, TSBF))
                {
                    Return (One)
                }

                If (LOr (LNotEqual (And (DerefOf (Index (TSBF, 0x08)), 
                    0x0F), One), LNotEqual (DerefOf (Index (TSBF, 0x07)), 0x71)))
                {
                    Store ("VID", Debug)
                    Store (DerefOf (Index (TSBF, 0x07)), Debug)
                    Store ("DID check fail invalid clockgen", Debug)
                    Return (0x03)
                }

                Store (0x20, Index (TSBF, 0x0B))
                Or (DerefOf (Index (TSBF, 0x0C)), 0xB0, Index (TSBF, 0x0C
                    ))
                If (RWBK (Zero, 0xD2, 0x0B, 0x02, TSBF))
                {
                    Return (One)
                }

                Return (Zero)
            }

            Method (GCCX, 4, NotSerialized)
            {
                And (DerefOf (Index (TSBF, Arg2)), 0x80, Local0)
                ShiftRight (Local0, 0x07, Local0)
                And (DerefOf (Index (TSBF, Arg0)), 0xC0, Local1)
                ShiftRight (Local1, 0x05, Local1)
                And (DerefOf (Index (TSBF, Arg1)), 0xFF, Local2)
                ShiftLeft (Local2, 0x03, Local2)
                Add (Local0, Local1, Local0)
                Add (Local0, Local2, Local0)
                And (DerefOf (Index (TSBF, Arg0)), 0x3F, Local1)
                Multiply (Arg3, Local0, Local2)
                Divide (Local2, Local1, , Local3)
                Return (Local3)
            }

            Method (CCLK, 1, NotSerialized)
            {
                Name (VCOV, Zero)
                Name (VCOD, Zero)
                If (LEqual (Arg0, One))
                {
                    If (LEqual (CPUD, Zero))
                    {
                        Store (GDIV (0x14), CPUD)
                    }

                    Store (CPUD, VCOD)
                    Store (GCCX (0x10, 0x11, 0x14, 0xC350), VCOV)
                }
                Else
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        If (LEqual (GFXD, Zero))
                        {
                            Store (GDIV (0x1C), GFXD)
                        }

                        Store (GFXD, VCOD)
                        Store (GCCX (0x1A, 0x1B, 0x1C, 0x37EE), VCOV)
                    }
                    Else
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            If (LEqual (SBCD, Zero))
                            {
                                Store (GDIV (0x1F), SBCD)
                            }

                            Store (SBCD, VCOD)
                            Store (GCCX (0x1D, 0x1E, 0x1F, 0x37EE), VCOV)
                        }
                    }
                }

                Return (Divide (VCOV, VCOD, ))
            }

            Method (GETM, 1, NotSerialized)
            {
                And (DerefOf (Index (TSBF, Arg0)), 0x3F, Local1)
                Return (Local1)
            }

            Method (GETN, 3, NotSerialized)
            {
                And (DerefOf (Index (TSBF, Arg2)), 0x80, Local0)
                ShiftRight (Local0, 0x07, Local0)
                And (DerefOf (Index (TSBF, Arg0)), 0xC0, Local1)
                ShiftRight (Local1, 0x05, Local1)
                And (DerefOf (Index (TSBF, Arg1)), 0xFF, Local2)
                ShiftLeft (Local2, 0x03, Local2)
                Add (Local0, Local1, Local0)
                Add (Local0, Local2, Local0)
                Return (Local0)
            }

            Method (SETM, 2, NotSerialized)
            {
                Store (Or (And (DerefOf (Index (TSBF, Arg1)), 0xC0), 
                    Arg0), Index (TSBF, Arg1))
            }

            Method (SETN, 4, NotSerialized)
            {
                Store (Or (And (ShiftLeft (Arg0, 0x05), 0xC0), And (
                    DerefOf (Index (TSBF, Arg1)), 0x3F)), Index (TSBF, Arg1
                    ))
                Store (And (ShiftRight (Arg0, 0x03), 0xFF), Index (TSBF, 
                    Arg2))
                Or (And (DerefOf (Index (TSBF, Arg3)), 0x7F), And (
                    ShiftLeft (Arg0, 0x07), 0x80), Index (TSBF, Arg3))
            }

            Method (SCCX, 6, NotSerialized)
            {
                Name (MAXC, Zero)
                Name (NNNN, Zero)
                Name (MMMM, Zero)
                Name (CURC, Zero)
                Name (TARC, Zero)
                Name (REFC, Zero)
                Name (OFF0, Zero)
                Name (OFF1, Zero)
                Name (OFF2, Zero)
                Store (Arg0, CURC)
                Store (Arg1, TARC)
                Store (Arg2, OFF0)
                Store (Arg3, OFF1)
                Store (Arg4, OFF2)
                Store (Arg5, REFC)
                Store (GETM (OFF0), MMMM)
                Store (GETN (OFF0, OFF1, OFF2), NNNN)
                Store (Divide (Multiply (REFC, 0x07FF), MMMM, ), MAXC)
                While (LLess (MAXC, TARC))
                {
                    Store ("MAXC", Debug)
                    Store (MAXC, Debug)
                    Decrement (MMMM)
                    SETM (MMMM, OFF0)
                    Store (TSBF, Debug)
                    If (RWBK (Zero, 0xD2, Arg1, Add (Subtract (OFF2, OFF0), 
                        One), TSBF))
                    {
                        Return (One)
                    }

                    Store (GETM (OFF0), MMMM)
                    Store (Divide (Multiply (REFC, 0x07FF), MMMM, ), MAXC)
                }

                Store (GCCX (OFF0, OFF1, OFF2, REFC), CURC)
                If (LGreater (CURC, TARC))
                {
                    While (LGreater (CURC, TARC))
                    {
                        Decrement (NNNN)
                        SETN (NNNN, OFF0, OFF1, OFF2)
                        If (RWBK (Zero, 0xD2, OFF0, Add (Subtract (OFF2, OFF0), 
                            One), TSBF))
                        {
                            Return (One)
                        }

                        Store ("M/N", Debug)
                        Store (MMMM, Debug)
                        Store (NNNN, Debug)
                        Store (GCCX (OFF0, OFF1, OFF2, REFC), CURC)
                        Store ("CURC", Debug)
                        Store (CURC, Debug)
                    }
                }
                Else
                {
                    If (LLess (CURC, TARC))
                    {
                        While (LLess (CURC, TARC))
                        {
                            Increment (NNNN)
                            SETN (NNNN, OFF0, OFF1, OFF2)
                            If (RWBK (Zero, 0xD2, OFF0, Add (Subtract (OFF2, OFF0), 
                                One), TSBF))
                            {
                                Return (One)
                            }

                            Store ("M/N", Debug)
                            Store (MMMM, Debug)
                            Store (NNNN, Debug)
                            Store (GCCX (OFF0, OFF1, OFF2, REFC), CURC)
                            Store ("CURC", Debug)
                            Store (CURC, Debug)
                        }
                    }
                }

                Return (Zero)
            }

            Name (DIVD, Buffer (0x10)
            {
                /* 0000 */   0x02, 0x03, 0x05, 0x09, 0x04, 0x06, 0x0A, 0x12,
                /* 0008 */   0x08, 0x0C, 0x14, 0x24, 0x10, 0x18, 0x28, 0x48
            })
            Method (GDIV, 1, NotSerialized)
            {
                Return (DerefOf (Index (DIVD, And (DerefOf (Index (TSBF, Arg0)), 
                    0x0F))))
            }

            Method (WTCX, 3, NotSerialized)
            {
                Store (Arg1, Local0)
                Store (Arg2, Local1)
                If (LEqual (Arg0, One))
                {
                    Return (SCCX (Local0, Local1, 0x10, 0x11, 0x14, 0xC350))
                }
                Else
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Return (SCCX (Local0, Local1, 0x1A, 0x1B, 0x1C, 0x37EE))
                    }
                    Else
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            Return (SCCX (Local0, Local1, 0x1D, 0x1E, 0x1F, 0x37EE))
                        }
                    }
                }

                Return (0x04)
            }

            Method (VINI, 0, NotSerialized)
            {
            }

            Method (SETV, 2, NotSerialized)
            {
                Store (Zero, Local0)
                While (LNotEqual (DerefOf (Index (PWMT, Local0)), 0xFF))
                {
                    If (LEqual (DerefOf (Index (PWMT, Local0)), Arg0))
                    {
                        If (LLess (Arg0, 0x04))
                        {
                            Store (Zero, Local1)
                            Store (DerefOf (Index (PWMT, Add (Local0, 0x02))), Local2)
                            While (LLess (Local1, DerefOf (Index (PWMT, Add (Local0, One)
                                ))))
                            {
                                Store (DerefOf (Index (Local2, Local1)), Local3)
                                Store (DerefOf (Index (Local3, One)), Local4)
                                If (LLessEqual (Arg1, DerefOf (Index (Local3, Zero))))
                                {
                                    If (LLess (Arg1, DerefOf (Index (Local3, Zero))))
                                    {
                                        Decrement (Local1)
                                        Store (DerefOf (Index (Local2, Local1)), Local3)
                                        Store (DerefOf (Index (Local3, One)), Local4)
                                    }

                                    RWSM (0x60, Arg0, Local4, 0x48)
                                    Store (0xFF, Local1)
                                    Return (One)
                                }

                                Increment (Local1)
                            }
                        }
                        Else
                        {
                            Store (Zero, Local1)
                            Store (DerefOf (Index (PWMT, Add (Local0, 0x02))), Local2)
                            GETV (Arg0)
                            Store (GVB1, Local5)
                            While (LLess (Local1, DerefOf (Index (PWMT, Add (Local0, One)
                                ))))
                            {
                                Store (DerefOf (Index (Local2, Local1)), Local3)
                                If (LLessEqual (DerefOf (Index (Local3, Zero)), Arg1))
                                {
                                    If (LAnd (LLess (Local5, Arg1), LLess (DerefOf (Index (Local3, Zero
                                        )), Local5)))
                                    {
                                        Increment (Local1)
                                    }
                                    Else
                                    {
                                        Store (One, Local4)
                                        While (LNotEqual (DerefOf (Index (Local3, Local4)), 0xFF))
                                        {
                                            SLDN (DerefOf (Index (Local3, Local4)))
                                            RWIO (DerefOf (Index (Local3, Add (Local4, One))), Not (
                                                DerefOf (Index (Local3, Add (Local4, 0x02)))), DerefOf (Index (
                                                Local3, Add (Local4, 0x03))))
                                            Add (Local4, 0x04, Local4)
                                        }

                                        Sleep (0x64)
                                        Increment (Local1)
                                    }
                                }
                                Else
                                {
                                    Return (One)
                                }
                            }
                        }
                    }

                    Add (Local0, 0x03, Local0)
                }
            }

            Method (GETV, 1, NotSerialized)
            {
                Store (Zero, Local0)
                While (LNotEqual (DerefOf (Index (PWMT, Local0)), 0xFF))
                {
                    If (LEqual (DerefOf (Index (PWMT, Local0)), Arg0))
                    {
                        If (LLess (Arg0, 0x04))
                        {
                            Store (Zero, Local1)
                            Store (DerefOf (Index (PWMT, Add (Local0, 0x02))), Local2)
                            While (LLess (Local1, DerefOf (Index (PWMT, Add (Local0, One)
                                ))))
                            {
                                Store (DerefOf (Index (Local2, Local1)), Local3)
                                Store (RWSM (0x61, Arg0, Zero, 0x48), Local4)
                                If (LEqual (DerefOf (Index (Local3, One)), Local4))
                                {
                                    Store (DerefOf (Index (Local3, Zero)), GVB1)
                                    Store (Zero, GVB2)
                                    Return (GVBF)
                                }

                                Increment (Local1)
                            }
                        }
                        Else
                        {
                            Store (Zero, Local1)
                            Store (DerefOf (Index (PWMT, Add (Local0, 0x02))), Local2)
                            While (LLess (Local1, DerefOf (Index (PWMT, Add (Local0, One)
                                ))))
                            {
                                Store (One, Local4)
                                Store (DerefOf (Index (Local2, Local1)), Local3)
                                While (LNotEqual (DerefOf (Index (Local3, Local4)), 0xFF))
                                {
                                    SLDN (DerefOf (Index (Local3, Local4)))
                                    If (LEqual (And (RSIO (DerefOf (Index (Local3, Add (Local4, One
                                        )))), DerefOf (Index (Local3, Add (Local4, 0x02)))), 
                                        DerefOf (Index (Local3, Add (Local4, 0x03)))))
                                    {
                                        Add (Local4, 0x04, Local4)
                                        If (LEqual (DerefOf (Index (Local3, Local4)), 0xFF))
                                        {
                                            Store (DerefOf (Index (Local3, Zero)), GVB1)
                                            Store (Zero, GVB2)
                                            Return (GVBF)
                                        }
                                    }
                                    Else
                                    {
                                        Break
                                    }
                                }

                                Increment (Local1)
                            }
                        }
                    }

                    Add (Local0, 0x03, Local0)
                }

                Store (Zero, GVB1)
                Store (0x04, GVB2)
                Return (GVBF)
            }

            Method (RWSM, 4, NotSerialized)
            {
                OperationRegion (SMBS, SystemIO, SMB0, 0x10)
                Field (SMBS, ByteAcc, NoLock, Preserve)
                {
                    HSTS,   8, 
                    SSTS,   8, 
                    HSTC,   8, 
                    HCMD,   8, 
                    HADR,   8, 
                    HDT0,   8, 
                    HDT1,   8, 
                    BLKD,   8
                }

                Field (SMBS, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x05), 
                    HDTW,   16
                }

                Store (0x05, Local0)
                While (Local0)
                {
                    Store (Arg0, HADR)
                    Store (Arg1, HCMD)
                    Store (Arg2, HDTW)
                    Store (0xFF, HSTS)
                    Store (Arg3, HSTC)
                    Store (0xFF, Local7)
                    While (Local7)
                    {
                        Decrement (Local7)
                        If (And (HSTS, 0x02))
                        {
                            Store (Zero, Local7)
                            Store (One, Local0)
                        }
                    }

                    Decrement (Local0)
                }

                If (And (HSTS, 0x02))
                {
                    Return (HDTW)
                }
                Else
                {
                    Return (Ones)
                }
            }

            Name (GF01, Zero)
            Name (OVFL, One)
            Name (OCFL, One)
            Name (TSBF, Buffer (0x20)
            {
                /* 0000 */   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                /* 0008 */   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                /* 0010 */   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                /* 0018 */   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
            })
            Name (GVBF, Buffer (0x05)
            {
                 0x00, 0x00, 0x00, 0x00, 0x00
            })
            CreateDWordField (GVBF, Zero, GVB1)
            CreateByteField (GVBF, 0x04, GVB2)
            Method (AM01, 0, NotSerialized)
            {
                If (DBG)
                {
                    Store ("AM01", Debug)
                }

                If (LNot (GF01))
                {
                    BM01 ()
                    If (OCFL)
                    {
                        CINI ()
                    }

                    If (OVFL)
                    {
                        VINI ()
                    }

                    XINI ()
                    EM01 ()
                    Store (One, GF01)
                }

                Return (Zero)
            }

            Method (AM02, 0, NotSerialized)
            {
                If (DBG)
                {
                    Store ("AM02", Debug)
                    Store (OBID, Debug)
                }

                Return (OBID)
            }

            Method (AM03, 1, NotSerialized)
            {
                If (DBG)
                {
                    Store ("AM03", Debug)
                }

                SOID (Arg0)
                If (LAnd (LEqual (ID01, One), OCFL))
                {
                    Store (GETC (ID02), Local0)
                }
                Else
                {
                    If (LAnd (LEqual (ID01, 0x02), OVFL))
                    {
                        Store (GETV (ID02), Local0)
                    }
                    Else
                    {
                        Store (Zero, GVB1)
                        Store (0x04, GVB2)
                        Store (GVBF, Local0)
                    }
                }

                If (DBG)
                {
                    Store ("GVBF", Debug)
                    Store (Local0, Debug)
                }

                Return (Local0)
            }

            Method (AM04, 2, NotSerialized)
            {
                If (DBG)
                {
                    Store ("AM04", Debug)
                }

                SOID (Arg0)
                If (LAnd (LEqual (ID01, One), OCFL))
                {
                    SETC (ID02, Arg1)
                }
                Else
                {
                    If (LAnd (LEqual (ID01, 0x02), OVFL))
                    {
                        SETV (ID02, Arg1)
                    }
                    Else
                    {
                        Return (0x04)
                    }
                }

                Return (Zero)
            }

            Method (AM05, 1, NotSerialized)
            {
                Name (INFO, Buffer (0x14)
                {
                    /* 0000 */   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    /* 0008 */   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    /* 0010 */   0x00, 0x00, 0x00, 0x00
                })
                CreateDWordField (INFO, Zero, IFID)
                CreateDWordField (INFO, 0x04, IFMI)
                CreateDWordField (INFO, 0x08, IFMX)
                CreateDWordField (INFO, 0x0C, IFSP)
                CreateField (INFO, 0x80, 0x03, IFST)
                If (DBG)
                {
                    Store ("AM05", Debug)
                    Store (OBIT, Debug)
                }

                SOID (Arg0)
                If (DBG)
                {
                    Store ("ID", Debug)
                    Store (ID01, Debug)
                    Store (ID02, Debug)
                }

                BM05 (Arg0)
                If (DBG)
                {
                    Store ("OBIT", Debug)
                    Store (OBIT, Debug)
                }

                CPTB (Arg0, INFO)
                EM05 (Arg0)
                If (DBG)
                {
                    Store ("info", Debug)
                    Store (INFO, Debug)
                }

                Return (INFO)
            }

            Method (AM06, 0, NotSerialized)
            {
                HM06 ()
                Return (Zero)
            }

            Method (AM07, 1, NotSerialized)
            {
                HM07 (Arg0)
                Return (Zero)
            }

            Method (AM08, 1, NotSerialized)
            {
                Name (LODT, Package (0x34)
                {
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero
                })
                Store (Zero, Local0)
                While (One)
                {
                    If (LEqual (DerefOf (Index (OBDT, Local0)), Arg0))
                    {
                        Store (Zero, Local4)
                        Break
                    }

                    If (LEqual (DerefOf (Index (OBDT, Local0)), Zero))
                    {
                        Store (0x04, Local4)
                        Break
                    }

                    Add (Local0, DerefOf (Index (OBDT, Add (Local0, One))), 
                        Local0)
                    Add (Local0, 0x02, Local0)
                }

                If (Local4) {}
                Else
                {
                    Store (DerefOf (Index (OBDT, Add (Local0, One))), Local1)
                    Add (Local1, 0x02, Local1)
                    Store (Zero, Local2)
                    While (Local1)
                    {
                        Store (DerefOf (Index (OBDT, Local0)), Index (LODT, Local2))
                        Decrement (Local1)
                        Increment (Local0)
                        Increment (Local2)
                    }
                }

                Return (LODT)
            }

            Name (OBSV, Package (0x09)
            {
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero
            })
            Method (APTS, 1, NotSerialized)
            {
                If (LAnd (GF01, LOr (LEqual (Arg0, 0x04), LEqual (Arg0, 0x03))))
                {
                    Store (DerefOf (Index (OBID, Zero)), Local0)
                    Store (One, Local1)
                    Store (Zero, Local2)
                    While (Local0)
                    {
                        SOID (DerefOf (Index (OBID, Local1)))
                        If (LAnd (LEqual (ID01, One), OCFL))
                        {
                            GETC (ID02)
                            Store (GVB1, Local3)
                        }
                        Else
                        {
                            If (LAnd (LEqual (ID01, 0x02), OVFL))
                            {
                                GETV (ID02)
                                Store (GVB1, Local3)
                            }
                            Else
                            {
                                Store (Zero, Local3)
                            }
                        }

                        Store (Local3, Index (OBSV, Local2))
                        Decrement (Local0)
                        Increment (Local1)
                        Increment (Local2)
                    }
                }
            }

            Method (AWAK, 1, NotSerialized)
            {
                If (LAnd (GF01, LOr (LEqual (Arg0, 0x04), LEqual (Arg0, 0x03))))
                {
                    Store (DerefOf (Index (OBID, Zero)), Local0)
                    Store (One, Local1)
                    Store (Zero, Local2)
                    While (Local0)
                    {
                        Store (DerefOf (Index (OBSV, Local2)), Local3)
                        SOID (DerefOf (Index (OBID, Local1)))
                        If (LAnd (LEqual (ID01, One), OCFL))
                        {
                            SETC (ID02, Local3)
                        }
                        Else
                        {
                            If (LAnd (LEqual (ID01, 0x02), OVFL))
                            {
                                SETV (ID02, Local3)
                            }
                            Else
                            {
                            }
                        }

                        Decrement (Local0)
                        Increment (Local1)
                        Increment (Local2)
                    }
                }
            }

            Name (CMDV, Zero)
            Method (AM09, 0, NotSerialized)
            {
                Return (CMDV)
            }

            Name (OBUF, Buffer (0x0200) {})
            Method (AM10, 1, NotSerialized)
            {
                CreateDWordField (Arg0, Zero, ACMD)
                CreateField (OBUF, Zero, 0x1000, TEMP)
                Store (Zero, TEMP)
                If (LEqual (ACMD, 0x00040001))
                {
                    R401 (Arg0)
                }
                Else
                {
                    If (LEqual (ACMD, 0x00040002))
                    {
                        R402 (Arg0)
                    }
                    Else
                    {
                        CreateDWordField (OBUF, Zero, CMDS)
                        Store (0x00010000, CMDS)
                    }
                }

                Store (OBUF, Debug)
                Return (OBUF)
            }

            Name (CMDL, Buffer (0x54) {})
            Method (AM11, 0, NotSerialized)
            {
                Name (TEMP, Zero)
                CreateDWordField (CMDL, Zero, CMDC)
                Add (TEMP, 0x04, TEMP)
                CreateDWordField (CMDL, TEMP, CMD5)
                Add (TEMP, 0x04, TEMP)
                Store (0x00040001, CMD5)
                CreateDWordField (CMDL, TEMP, CMD6)
                Add (TEMP, 0x04, TEMP)
                Store (0x00040002, CMD6)
                Subtract (TEMP, 0x04, TEMP)
                Divide (TEMP, 0x04, , TEMP)
                Store (TEMP, CMDC)
                Return (CMDL)
            }

            OperationRegion (AODT, SystemMemory, 0xBE8C6D98, 0x0100)
            Field (AODT, AnyAcc, NoLock, Preserve)
            {
                ASCD,   16, 
                ASTS,   32, 
                Offset (0x08), 
                ASBF,   960, 
                GFXO,   1, 
                GMOD,   2
            }

            OperationRegion (SMIX, SystemIO, SMIP, One)
            Field (SMIX, ByteAcc, NoLock, Preserve)
            {
                SMIC,   8
            }

            Name (EXBF, Buffer (0x78) {})
            Name (VEND, Buffer (0x07)
            {
                "ASRock"
            })
            Method (R401, 1, NotSerialized)
            {
                CreateField (OBUF, 0x20, 0x0200, TMP2)
                Store (VEND, TMP2)
                Return (Zero)
            }

            Method (R402, 1, NotSerialized)
            {
                CreateField (OBUF, 0x20, 0x08, TMP1)
                CreateField (OBUF, 0x28, 0x08, TMP2)
                Store (GMOD, TMP1)
                Store (GFXO, TMP2)
                Return (Zero)
            }

            Name (WQBA, Buffer (0x0BBB)
            {
                /* 0000 */   0x46, 0x4F, 0x4D, 0x42, 0x01, 0x00, 0x00, 0x00,
                /* 0008 */   0xAB, 0x0B, 0x00, 0x00, 0x20, 0x4A, 0x00, 0x00,
                /* 0010 */   0x44, 0x53, 0x00, 0x01, 0x1A, 0x7D, 0xDA, 0x54,
                /* 0018 */   0x28, 0x5B, 0xA4, 0x00, 0x01, 0x06, 0x18, 0x42,
                /* 0020 */   0x10, 0x15, 0x10, 0x22, 0x21, 0x04, 0x12, 0x01,
                /* 0028 */   0xA1, 0xC8, 0x2C, 0x0C, 0x86, 0x10, 0x38, 0x2E,
                /* 0030 */   0x84, 0x1C, 0x40, 0x48, 0x1C, 0x14, 0x4A, 0x08,
                /* 0038 */   0x84, 0xFA, 0x13, 0xC8, 0xAF, 0x00, 0x84, 0x0E,
                /* 0040 */   0x05, 0xC8, 0x14, 0x60, 0x50, 0x80, 0x53, 0x04,
                /* 0048 */   0x11, 0xF4, 0x2A, 0xC0, 0xA6, 0x00, 0x93, 0x02,
                /* 0050 */   0x2C, 0x0A, 0xD0, 0x2E, 0xC0, 0xB2, 0x00, 0xDD,
                /* 0058 */   0x02, 0xA4, 0xC3, 0x92, 0xAD, 0x08, 0x1C, 0x21,
                /* 0060 */   0x06, 0x1C, 0xA5, 0x13, 0x5B, 0xB8, 0x61, 0x83,
                /* 0068 */   0x17, 0x8A, 0xA2, 0x19, 0x44, 0x49, 0x50, 0xB9,
                /* 0070 */   0x00, 0xDF, 0x08, 0x02, 0x2F, 0x57, 0x80, 0xE4,
                /* 0078 */   0x09, 0x48, 0xB3, 0x00, 0xC3, 0x02, 0xAC, 0x0B,
                /* 0080 */   0x90, 0x3D, 0x04, 0x2A, 0x75, 0x08, 0x28, 0x39,
                /* 0088 */   0x43, 0x40, 0x0D, 0xA0, 0xD5, 0x09, 0x08, 0xBF,
                /* 0090 */   0xD2, 0x29, 0x21, 0x09, 0xC2, 0x19, 0xAB, 0x78,
                /* 0098 */   0x7C, 0xCD, 0xA2, 0xE9, 0x39, 0xC9, 0x39, 0x86,
                /* 00A0 */   0x1C, 0x8F, 0x0B, 0x3D, 0x08, 0x1E, 0x47, 0x03,
                /* 00A8 */   0x08, 0x93, 0x3F, 0x64, 0x05, 0x80, 0x41, 0x49,
                /* 00B0 */   0x18, 0x0B, 0x75, 0x31, 0x6A, 0xD4, 0x48, 0xD9,
                /* 00B8 */   0x80, 0x0C, 0x51, 0xDA, 0xA8, 0xD1, 0x03, 0x3A,
                /* 00C0 */   0xBF, 0x23, 0x39, 0xBB, 0xA3, 0x3B, 0x92, 0x04,
                /* 00C8 */   0x46, 0x3D, 0xA6, 0x63, 0x2C, 0x6C, 0x46, 0x42,
                /* 00D0 */   0x8D, 0xD1, 0x1C, 0x14, 0x09, 0x37, 0x68, 0xB4,
                /* 00D8 */   0x44, 0x58, 0x8D, 0x2B, 0xF6, 0x99, 0x59, 0xF8,
                /* 00E0 */   0xB0, 0x84, 0x71, 0x04, 0x07, 0x76, 0xB0, 0x16,
                /* 00E8 */   0x0D, 0x23, 0xB4, 0x82, 0xE0, 0x34, 0x88, 0xA3,
                /* 00F0 */   0x88, 0x12, 0x86, 0xE1, 0x19, 0x33, 0xD0, 0x51,
                /* 00F8 */   0x32, 0xA4, 0x30, 0x41, 0x4F, 0x20, 0xC8, 0xC9,
                /* 0100 */   0x33, 0x2C, 0x43, 0x9C, 0x01, 0xC7, 0x8A, 0x11,
                /* 0108 */   0x2A, 0x24, 0x66, 0x20, 0xC1, 0xFF, 0xFF, 0x27,
                /* 0110 */   0xD0, 0x35, 0x86, 0x3C, 0x03, 0x91, 0x7B, 0xC0,
                /* 0118 */   0x09, 0x04, 0x89, 0x1E, 0x25, 0xB8, 0x71, 0x8D,
                /* 0120 */   0xCA, 0xC6, 0x74, 0x36, 0xB8, 0x81, 0x99, 0x20,
                /* 0128 */   0xCE, 0xE1, 0x61, 0x64, 0x40, 0x68, 0x02, 0xF1,
                /* 0130 */   0x63, 0x87, 0x4F, 0x60, 0xF7, 0xC7, 0x01, 0x29,
                /* 0138 */   0x44, 0xD0, 0x85, 0xE0, 0x4C, 0x6B, 0x14, 0x60,
                /* 0140 */   0xED, 0xEC, 0x20, 0x5B, 0x10, 0x3A, 0x0B, 0xC4,
                /* 0148 */   0x6A, 0x0C, 0x45, 0x10, 0x11, 0x82, 0x46, 0x31,
                /* 0150 */   0x5E, 0x84, 0x50, 0x21, 0xA2, 0x44, 0x3D, 0xE7,
                /* 0158 */   0x20, 0xB5, 0x09, 0x50, 0x06, 0x22, 0xB4, 0x60,
                /* 0160 */   0x46, 0x60, 0xF6, 0x07, 0x41, 0x24, 0x58, 0x80,
                /* 0168 */   0xF8, 0x23, 0xB0, 0x84, 0x13, 0x81, 0x8C, 0x8C,
                /* 0170 */   0x86, 0x1E, 0x16, 0x7C, 0x12, 0x60, 0x07, 0x04,
                /* 0178 */   0xCF, 0xE7, 0xD4, 0x4C, 0xE0, 0xC0, 0x10, 0xE2,
                /* 0180 */   0x95, 0x00, 0x51, 0x47, 0x0B, 0x4A, 0x60, 0x29,
                /* 0188 */   0x47, 0x03, 0x62, 0x7B, 0x60, 0xBA, 0x07, 0x1C,
                /* 0190 */   0xE1, 0xB9, 0xFB, 0x72, 0x70, 0x6A, 0xFE, 0x69,
                /* 0198 */   0x78, 0x9A, 0x0F, 0x09, 0x98, 0x21, 0x7A, 0xAC,
                /* 01A0 */   0x07, 0x11, 0xF0, 0x10, 0xD9, 0x29, 0xC1, 0x80,
                /* 01A8 */   0x78, 0xEF, 0xD7, 0x02, 0x32, 0x82, 0x97, 0x04,
                /* 01B0 */   0x03, 0x7A, 0x12, 0x0F, 0x08, 0x60, 0x39, 0x68,
                /* 01B8 */   0x1C, 0xF8, 0x09, 0x55, 0x7C, 0x07, 0xA0, 0x47,
                /* 01C0 */   0x02, 0x36, 0xA3, 0xF8, 0x26, 0x28, 0xEB, 0xF8,
                /* 01C8 */   0x80, 0x9E, 0x73, 0xB4, 0x67, 0x87, 0x97, 0x85,
                /* 01D0 */   0x66, 0xAF, 0x18, 0x84, 0xE0, 0x35, 0xC0, 0x37,
                /* 01D8 */   0x05, 0x9F, 0x46, 0x2C, 0x69, 0x75, 0x72, 0xB2,
                /* 01E0 */   0x2A, 0x8F, 0x98, 0x82, 0x7B, 0x08, 0x5C, 0x04,
                /* 01E8 */   0x9C, 0x86, 0xEE, 0xF1, 0x82, 0x43, 0xC1, 0x78,
                /* 01F0 */   0xE9, 0xFF, 0x7F, 0xBC, 0xE0, 0x3E, 0x0F, 0x1C,
                /* 01F8 */   0x2F, 0x58, 0x4E, 0x09, 0x55, 0x5D, 0x36, 0x34,
                /* 0200 */   0x87, 0xF3, 0x6D, 0x1E, 0x9F, 0x1C, 0x2D, 0x3C,
                /* 0208 */   0x61, 0x36, 0x96, 0xA3, 0x62, 0xC7, 0x10, 0x36,
                /* 0210 */   0x3A, 0x3E, 0x0A, 0x0F, 0xF8, 0xB5, 0xA1, 0x58,
                /* 0218 */   0x10, 0x99, 0x80, 0xD0, 0x91, 0xE1, 0xC0, 0xC1,
                /* 0220 */   0xE2, 0xEC, 0x00, 0x21, 0x02, 0x0B, 0x1B, 0x39,
                /* 0228 */   0x7A, 0xC4, 0x1E, 0xD4, 0x3B, 0x8C, 0x31, 0x1E,
                /* 0230 */   0x08, 0x8C, 0x7A, 0x48, 0x07, 0x0F, 0x3E, 0x40,
                /* 0238 */   0x0F, 0x1E, 0x70, 0xFA, 0xFF, 0x27, 0xB0, 0xA0,
                /* 0240 */   0x21, 0x4B, 0xC4, 0xE0, 0xD1, 0xA7, 0x08, 0x0F,
                /* 0248 */   0xE7, 0xDD, 0x87, 0x1F, 0x44, 0x12, 0x38, 0x3C,
                /* 0250 */   0x84, 0x06, 0x0F, 0x9E, 0xB3, 0x8F, 0x07, 0x0F,
                /* 0258 */   0x7E, 0x79, 0x83, 0x07, 0xD1, 0x14, 0x8E, 0x0D,
                /* 0260 */   0x77, 0xB0, 0xF1, 0xC0, 0xC1, 0x3D, 0x5C, 0xFC,
                /* 0268 */   0x90, 0x70, 0x67, 0x2D, 0x78, 0x3E, 0x27, 0x4F,
                /* 0270 */   0x06, 0xF0, 0x12, 0x84, 0x3B, 0x6C, 0x01, 0x97,
                /* 0278 */   0x11, 0x70, 0x99, 0xAB, 0xA4, 0x87, 0x2A, 0x0B,
                /* 0280 */   0x83, 0x41, 0x9D, 0xAB, 0xC0, 0xFB, 0xFF, 0x3F,
                /* 0288 */   0x57, 0x01, 0xF6, 0x2F, 0x53, 0xEF, 0x53, 0x3E,
                /* 0290 */   0x57, 0x81, 0x3B, 0xDA, 0x79, 0x40, 0xE7, 0x16,
                /* 0298 */   0x72, 0x9A, 0x41, 0x1F, 0x0A, 0x7C, 0x06, 0x78,
                /* 02A0 */   0x92, 0x01, 0xDB, 0xA1, 0x0A, 0x38, 0x9C, 0x64,
                /* 02A8 */   0xC0, 0x73, 0x2B, 0x7B, 0x92, 0x61, 0xFF, 0xFF,
                /* 02B0 */   0x93, 0x0C, 0x38, 0x0F, 0x62, 0x3E, 0xC9, 0x80,
                /* 02B8 */   0xEF, 0xE8, 0x85, 0x3B, 0x81, 0xC0, 0xF3, 0x38,
                /* 02C0 */   0x24, 0x21, 0x1F, 0x42, 0xF0, 0x43, 0x3A, 0xA6,
                /* 02C8 */   0x67, 0x10, 0x60, 0x28, 0xE4, 0x65, 0xE0, 0x03,
                /* 02D0 */   0x08, 0x8D, 0x7E, 0x06, 0x01, 0xB4, 0xFF, 0xFF,
                /* 02D8 */   0xCF, 0x20, 0xC0, 0xE5, 0xAC, 0xF0, 0x0C, 0x02,
                /* 02E0 */   0x76, 0xF1, 0xAF, 0x3A, 0x9D, 0x07, 0x1C, 0x1C,
                /* 02E8 */   0x42, 0x4E, 0x8E, 0x8A, 0xA8, 0xE1, 0x58, 0xEB,
                /* 02F0 */   0x41, 0x80, 0x8C, 0xE7, 0x45, 0xC0, 0x41, 0x4F,
                /* 02F8 */   0x8A, 0x40, 0xF7, 0xAC, 0x81, 0x3B, 0x1F, 0xC0,
                /* 0300 */   0x3D, 0x12, 0xF2, 0x73, 0x07, 0xF8, 0xA2, 0x43,
                /* 0308 */   0xE8, 0x98, 0x89, 0x3F, 0x51, 0x79, 0x88, 0x3E,
                /* 0310 */   0x1B, 0x98, 0xC0, 0xA3, 0x05, 0xD7, 0x39, 0x11,
                /* 0318 */   0x5C, 0xFF, 0xFF, 0xD1, 0xC2, 0x3B, 0x69, 0xE0,
                /* 0320 */   0x46, 0x0B, 0xF7, 0x00, 0xFC, 0x58, 0x80, 0x39,
                /* 0328 */   0x62, 0x82, 0xEB, 0xD0, 0x02, 0xA6, 0xEB, 0x02,
                /* 0330 */   0xE6, 0xD2, 0x82, 0x3F, 0xB4, 0x00, 0x1F, 0xA1,
                /* 0338 */   0x27, 0x16, 0x94, 0xB4, 0x43, 0x0B, 0xA0, 0xF9,
                /* 0340 */   0xFF, 0x7F, 0x68, 0x01, 0x6E, 0x73, 0x7D, 0x68,
                /* 0348 */   0x01, 0x7B, 0xB8, 0x73, 0x18, 0x95, 0x73, 0x0E,
                /* 0350 */   0x83, 0x76, 0x68, 0xF6, 0x39, 0x0C, 0xB8, 0x1E,
                /* 0358 */   0x26, 0xF0, 0x87, 0x4A, 0xB8, 0xB3, 0x88, 0x1F,
                /* 0360 */   0x27, 0xDA, 0x5B, 0x80, 0xCF, 0xA7, 0xC0, 0xED,
                /* 0368 */   0xB0, 0x86, 0x3B, 0x82, 0xC0, 0xBB, 0x14, 0x9C,
                /* 0370 */   0x96, 0xA7, 0xF6, 0xD4, 0x7F, 0x70, 0x8D, 0x5F,
                /* 0378 */   0x41, 0xC8, 0x3D, 0xC6, 0x77, 0x10, 0xF6, 0xFF,
                /* 0380 */   0x3F, 0x88, 0x01, 0x37, 0x19, 0x07, 0x31, 0x54,
                /* 0388 */   0xF0, 0x43, 0x08, 0x40, 0xA1, 0xCB, 0xC2, 0x43,
                /* 0390 */   0x08, 0xD8, 0xA5, 0x1F, 0xC4, 0x68, 0xEC, 0x83,
                /* 0398 */   0x18, 0xEA, 0xFF, 0x7F, 0x82, 0xC7, 0x9F, 0xC3,
                /* 03A0 */   0x00, 0xA7, 0x67, 0x38, 0xB8, 0x51, 0x8F, 0x61,
                /* 03A8 */   0x80, 0xA2, 0xB3, 0x28, 0x70, 0x82, 0x78, 0x0E,
                /* 03B0 */   0x63, 0xFF, 0xFF, 0x73, 0x18, 0xF0, 0x14, 0xFC,
                /* 03B8 */   0x12, 0xF0, 0x81, 0x85, 0x4A, 0x84, 0x41, 0x9D,
                /* 03C0 */   0x59, 0x00, 0xDE, 0x1C, 0x90, 0x9F, 0x59, 0xC0,
                /* 03C8 */   0x1E, 0xF2, 0xAD, 0xA1, 0x1F, 0x81, 0xFF, 0xFF,
                /* 03D0 */   0x67, 0x16, 0xC0, 0xF5, 0x99, 0xDC, 0x63, 0xC5,
                /* 03D8 */   0x1D, 0x22, 0xD8, 0x48, 0x42, 0xBE, 0x0A, 0xBC,
                /* 03E0 */   0x15, 0x98, 0xC0, 0x91, 0x0F, 0x2D, 0x40, 0xF7,
                /* 03E8 */   0x6C, 0x82, 0x1B, 0x2D, 0xDC, 0xE3, 0xC8, 0x39,
                /* 03F0 */   0x9E, 0xD0, 0xBB, 0xF9, 0xEB, 0x03, 0x3B, 0x4D,
                /* 03F8 */   0xB0, 0x21, 0x83, 0x57, 0xDE, 0x21, 0x10, 0xF5,
                /* 0400 */   0xFF, 0x1F, 0xB2, 0x0F, 0x24, 0x9E, 0xC2, 0xCB,
                /* 0408 */   0x0C, 0x66, 0x26, 0x31, 0x0E, 0x24, 0xC2, 0xB1,
                /* 0410 */   0x78, 0x78, 0xE4, 0x28, 0x08, 0xAA, 0x33, 0x3F,
                /* 0418 */   0x19, 0x35, 0xE8, 0x67, 0xF7, 0x84, 0x0F, 0x9E,
                /* 0420 */   0xE9, 0xBE, 0xE1, 0x83, 0xE1, 0x30, 0x08, 0x73,
                /* 0428 */   0xCE, 0x1E, 0x3F, 0xF8, 0x8E, 0x3D, 0xB8, 0x73,
                /* 0430 */   0x10, 0xBC, 0xEB, 0x8A, 0x91, 0x4F, 0xE8, 0x25,
                /* 0438 */   0x00, 0x73, 0x6B, 0xC1, 0x9E, 0x05, 0x81, 0x93,
                /* 0440 */   0xAC, 0x83, 0x20, 0x4A, 0xC8, 0x59, 0x10, 0x54,
                /* 0448 */   0xFF, 0xFF, 0x83, 0x10, 0xC0, 0x04, 0x6F, 0xF7,
                /* 0450 */   0x20, 0x5D, 0x83, 0x7C, 0x1B, 0x78, 0x1A, 0x78,
                /* 0458 */   0xF8, 0x89, 0xF2, 0x20, 0xE4, 0x8B, 0xC4, 0x0B,
                /* 0460 */   0x41, 0x84, 0x28, 0xC7, 0x7B, 0x02, 0x11, 0x9E,
                /* 0468 */   0x86, 0x3C, 0xE1, 0x30, 0xE1, 0x4E, 0x36, 0xCA,
                /* 0470 */   0x4B, 0x43, 0x18, 0x43, 0xC7, 0x0A, 0x14, 0x39,
                /* 0478 */   0x7E, 0x08, 0x1F, 0x85, 0x7C, 0x10, 0x62, 0x51,
                /* 0480 */   0xCE, 0xB7, 0xF4, 0xFC, 0x61, 0x23, 0x67, 0x11,
                /* 0488 */   0xD4, 0x49, 0xC0, 0x87, 0x0E, 0x0F, 0xEA, 0x09,
                /* 0490 */   0x01, 0x13, 0x1A, 0x42, 0x47, 0x5C, 0xE0, 0x7A,
                /* 0498 */   0xDA, 0xC0, 0xFD, 0xFF, 0x8F, 0x42, 0xE0, 0x38,
                /* 04A0 */   0x80, 0xC0, 0x7B, 0xF0, 0xF8, 0xB4, 0x0E, 0x2E,
                /* 04A8 */   0x08, 0x9F, 0x3F, 0xE0, 0xFB, 0x44, 0x16, 0xEE,
                /* 04B0 */   0x5B, 0xC0, 0x0B, 0x0D, 0xEE, 0xEC, 0x01, 0x7C,
                /* 04B8 */   0xE4, 0x1E, 0x6B, 0x51, 0x02, 0x61, 0x50, 0x67,
                /* 04C0 */   0x0F, 0xC0, 0xF9, 0xFF, 0xFF, 0xEC, 0x01, 0xD6,
                /* 04C8 */   0x81, 0x3E, 0x7A, 0x1C, 0xE8, 0x31, 0x06, 0x89,
                /* 04D0 */   0x11, 0xC4, 0x77, 0x0E, 0x1F, 0x7C, 0xE2, 0xBC,
                /* 04D8 */   0x11, 0x3C, 0x7B, 0xF8, 0xC8, 0x71, 0x5C, 0x3E,
                /* 04E0 */   0x80, 0xF8, 0xEC, 0xE1, 0x2B, 0x88, 0xF1, 0xC2,
                /* 04E8 */   0xC4, 0x7C, 0x38, 0xF2, 0x35, 0x21, 0x5E, 0xE4,
                /* 04F0 */   0xB0, 0x61, 0x22, 0xFB, 0xEC, 0xC1, 0x22, 0x1E,
                /* 04F8 */   0x6B, 0xA9, 0x94, 0x83, 0x19, 0xFA, 0x4C, 0xE0,
                /* 0500 */   0x5B, 0xC2, 0x99, 0xBD, 0x71, 0x44, 0x38, 0xAE,
                /* 0508 */   0x93, 0x3B, 0x9F, 0x38, 0x1E, 0xD2, 0x49, 0xFB,
                /* 0510 */   0x6C, 0x06, 0xBE, 0xE3, 0x07, 0x70, 0x38, 0x9B,
                /* 0518 */   0x81, 0x67, 0x74, 0x70, 0x0F, 0x53, 0xE0, 0x93,
                /* 0520 */   0x75, 0x36, 0x43, 0x0F, 0xCB, 0xE7, 0x82, 0x57,
                /* 0528 */   0x07, 0x0F, 0x82, 0x9D, 0xCB, 0xC0, 0x75, 0xB8,
                /* 0530 */   0x83, 0xF3, 0xFF, 0x3F, 0x97, 0x01, 0xAF, 0x73,
                /* 0538 */   0xC7, 0x91, 0xB1, 0x53, 0x05, 0x47, 0x3C, 0xA8,
                /* 0540 */   0x33, 0x79, 0x77, 0x39, 0x6B, 0x1F, 0x3C, 0x02,
                /* 0548 */   0x9D, 0xE7, 0x29, 0xFB, 0x1C, 0x03, 0x73, 0x84,
                /* 0550 */   0x1E, 0x3B, 0xF8, 0x0E, 0x26, 0xF8, 0x83, 0x0C,
                /* 0558 */   0x1C, 0x98, 0x13, 0x38, 0xBA, 0x40, 0xA7, 0x10,
                /* 0560 */   0xE7, 0x14, 0x9E, 0x63, 0x80, 0x91, 0x1C, 0x4B,
                /* 0568 */   0x20, 0x2C, 0xC0, 0xB1, 0x40, 0xA2, 0x96, 0x49,
                /* 0570 */   0x61, 0x7C, 0x32, 0xF0, 0x39, 0x06, 0xAE, 0x24,
                /* 0578 */   0x38, 0xD4, 0xF8, 0x3C, 0xB2, 0x97, 0xBC, 0xE3,
                /* 0580 */   0x3C, 0x91, 0x37, 0x04, 0x8F, 0xFF, 0x81, 0x06,
                /* 0588 */   0xC6, 0xC0, 0x3D, 0xAD, 0x93, 0xF2, 0x4D, 0xEE,
                /* 0590 */   0xB1, 0xC4, 0x67, 0x43, 0x7E, 0x5C, 0x60, 0x68,
                /* 0598 */   0xFC, 0x74, 0x03, 0x86, 0xFF, 0xFF, 0xE9, 0x06,
                /* 05A0 */   0xCE, 0x9D, 0xC1, 0x47, 0x0D, 0xB0, 0x5C, 0x6D,
                /* 05A8 */   0x30, 0x58, 0xA1, 0x62, 0x34, 0x7A, 0xD7, 0x23,
                /* 05B0 */   0xA0, 0xC7, 0xD7, 0xD7, 0x45, 0x9A, 0x42, 0x45,
                /* 05B8 */   0x0C, 0xF1, 0x42, 0x60, 0x97, 0xC7, 0x71, 0xE4,
                /* 05C0 */   0x59, 0x17, 0x5C, 0xD8, 0xCF, 0xBA, 0x60, 0x0F,
                /* 05C8 */   0x75, 0x4E, 0xA2, 0x91, 0x46, 0x83, 0x3A, 0xC8,
                /* 05D0 */   0xF0, 0x03, 0xC1, 0x63, 0x90, 0x4F, 0x1E, 0x06,
                /* 05D8 */   0x39, 0xD1, 0xD3, 0x7A, 0x5C, 0x78, 0x1A, 0xF0,
                /* 05E0 */   0xB8, 0xD9, 0x35, 0xC1, 0x1F, 0x04, 0x1F, 0x0F,
                /* 05E8 */   0xF0, 0x97, 0xA0, 0x80, 0x27, 0xFA, 0xF0, 0x01,
                /* 05F0 */   0xEB, 0x10, 0x82, 0x3F, 0x61, 0xC0, 0x1F, 0x8F,
                /* 05F8 */   0x8F, 0x01, 0x3E, 0xD1, 0xFA, 0x48, 0x45, 0x06,
                /* 0600 */   0x81, 0x3A, 0xBC, 0xF1, 0x91, 0x9E, 0xD6, 0xDB,
                /* 0608 */   0x80, 0x0F, 0x09, 0x87, 0xC5, 0x0E, 0x1E, 0x3E,
                /* 0610 */   0xA3, 0x80, 0x63, 0x3C, 0xF0, 0x6F, 0x9F, 0x4F,
                /* 0618 */   0x07, 0xFF, 0xFF, 0x08, 0xAF, 0x0C, 0x9E, 0xAF,
                /* 0620 */   0x0F, 0x66, 0x60, 0xB9, 0x75, 0xF8, 0xD0, 0x10,
                /* 0628 */   0xEA, 0xA9, 0xC3, 0x33, 0x78, 0xBF, 0xF0, 0x09,
                /* 0630 */   0x04, 0x98, 0x04, 0x36, 0x34, 0x48, 0x26, 0x73,
                /* 0638 */   0x9D, 0xB2, 0x71, 0xDA, 0xA1, 0xC3, 0xB4, 0xC8,
                /* 0640 */   0x03, 0x82, 0x8E, 0x06, 0x3E, 0xD2, 0xF8, 0x80,
                /* 0648 */   0xCB, 0x0F, 0x49, 0x86, 0xB0, 0x30, 0x0A, 0x9D,
                /* 0650 */   0x7C, 0x3C, 0x1A, 0x0F, 0x8F, 0xC0, 0x51, 0x10,
                /* 0658 */   0x8F, 0xDC, 0x21, 0x21, 0x64, 0xE4, 0x10, 0x80,
                /* 0660 */   0x3E, 0x2C, 0x30, 0x88, 0x87, 0x2E, 0x13, 0xF8,
                /* 0668 */   0xD8, 0xE0, 0xF3, 0x1A, 0x9C, 0xE3, 0x91, 0x27,
                /* 0670 */   0xE3, 0x69, 0x78, 0xDC, 0xB8, 0x53, 0x07, 0xDC,
                /* 0678 */   0x71, 0xE0, 0x0F, 0x3A, 0xF8, 0x53, 0x20, 0x3F,
                /* 0680 */   0x27, 0x91, 0xF3, 0x1F, 0xA8, 0x04, 0x9E, 0x0B,
                /* 0688 */   0x40, 0x01, 0xE4, 0xAB, 0x80, 0x95, 0x1E, 0x07,
                /* 0690 */   0xE8, 0x14, 0x42, 0x84, 0x89, 0x66, 0x78, 0x4C,
                /* 0698 */   0xF0, 0xD3, 0x17, 0x1D, 0x8F, 0x87, 0xE5, 0xFF,
                /* 06A0 */   0xFF, 0x20, 0xF9, 0xF1, 0x85, 0x61, 0x3F, 0x9D,
                /* 06A8 */   0xF8, 0xD4, 0x76, 0x8C, 0xEF, 0x05, 0x8F, 0x5F,
                /* 06B0 */   0x18, 0x58, 0x0F, 0x9B, 0xC3, 0x1A, 0x2D, 0xEC,
                /* 06B8 */   0xD1, 0x3E, 0x3E, 0xF8, 0xEA, 0xE1, 0x89, 0xF9,
                /* 06C0 */   0x16, 0xE7, 0x43, 0x07, 0x58, 0x0E, 0x52, 0xC0,
                /* 06C8 */   0xE3, 0xFC, 0xC3, 0xE6, 0xF0, 0x02, 0xF1, 0x1C,
                /* 06D0 */   0xE6, 0x83, 0x07, 0x3B, 0xF1, 0xB1, 0x53, 0x1F,
                /* 06D8 */   0xD7, 0x75, 0x8E, 0x43, 0x9C, 0x21, 0xF8, 0x20,
                /* 06E0 */   0x1C, 0x67, 0x91, 0xF2, 0x38, 0x53, 0x72, 0x95,
                /* 06E8 */   0x7C, 0xE0, 0xA8, 0x1A, 0x45, 0xF0, 0xBE, 0x15,
                /* 06F0 */   0xB0, 0x08, 0xC7, 0x08, 0x94, 0x78, 0x0A, 0x49,
                /* 06F8 */   0x3F, 0x46, 0xA0, 0xC4, 0xC2, 0x51, 0x10, 0x1F,
                /* 0700 */   0x23, 0x7C, 0x90, 0xB0, 0x8D, 0x63, 0x04, 0x6A,
                /* 0708 */   0x8C, 0x3E, 0x0C, 0xF2, 0xA3, 0x00, 0x3F, 0x45,
                /* 0710 */   0xC0, 0x3F, 0xF1, 0xE0, 0xC6, 0x0A, 0x77, 0x70,
                /* 0718 */   0x6C, 0x85, 0x2F, 0x3D, 0x87, 0x76, 0x76, 0x0F,
                /* 0720 */   0x09, 0x51, 0xDE, 0x5F, 0x8D, 0x18, 0x21, 0x60,
                /* 0728 */   0xD8, 0x68, 0x1E, 0x23, 0xEE, 0xD8, 0xCE, 0x2E,
                /* 0730 */   0x45, 0x9E, 0x53, 0xAC, 0x47, 0x25, 0x7E, 0xA4,
                /* 0738 */   0x80, 0xF7, 0xFF, 0x27, 0xF0, 0x31, 0x0F, 0x77,
                /* 0740 */   0xA4, 0x80, 0x33, 0x93, 0xF3, 0xC0, 0xA8, 0x1B,
                /* 0748 */   0x8B, 0xE0, 0x8D, 0xF6, 0x92, 0x8D, 0x3D, 0x58,
                /* 0750 */   0x00, 0x8F, 0x13, 0xA3, 0x0F, 0x16, 0xE0, 0x3A,
                /* 0758 */   0x13, 0xF8, 0x60, 0x01, 0x5C, 0xCF, 0x07, 0x3E,
                /* 0760 */   0x1D, 0x80, 0xF5, 0xF2, 0xC3, 0xEF, 0x07, 0x30,
                /* 0768 */   0x4E, 0x18, 0x30, 0xCE, 0x07, 0x98, 0x1B, 0x86,
                /* 0770 */   0xC3, 0x2C, 0x59, 0x27, 0x0C, 0x7E, 0x5C, 0x73,
                /* 0778 */   0xA4, 0xD5, 0x6A, 0x20, 0xEC, 0x12, 0x86, 0x23,
                /* 0780 */   0x18, 0x04, 0x4C, 0x27, 0x0B, 0x8F, 0xDA, 0x11,
                /* 0788 */   0x28, 0x24, 0xED, 0x80, 0x81, 0x12, 0x73, 0xC0,
                /* 0790 */   0xA0, 0x20, 0x06, 0x74, 0x52, 0x08, 0x9D, 0x45,
                /* 0798 */   0xFD, 0xFF, 0x3F, 0x60, 0xF0, 0x83, 0x9D, 0x4F,
                /* 07A0 */   0x0D, 0xEC, 0x72, 0xEB, 0xEB, 0x85, 0xE7, 0xE9,
                /* 07A8 */   0x29, 0x73, 0x3C, 0x1F, 0x43, 0x0C, 0xEB, 0x8B,
                /* 07B0 */   0x09, 0x78, 0x6E, 0x14, 0xEC, 0x34, 0x8B, 0xB9,
                /* 07B8 */   0xB8, 0xB1, 0xB3, 0x1D, 0x3B, 0x15, 0x18, 0xE5,
                /* 07C0 */   0x70, 0xDF, 0xC0, 0xAC, 0xE6, 0xAA, 0x80, 0x9A,
                /* 07C8 */   0x11, 0x86, 0xC0, 0xE3, 0xF5, 0x81, 0x11, 0x4C,
                /* 07D0 */   0xFA, 0x2E, 0x14, 0x20, 0x47, 0xE7, 0x32, 0x47,
                /* 07D8 */   0x8F, 0x3A, 0x47, 0xF9, 0x24, 0xC5, 0x47, 0xEF,
                /* 07E0 */   0xA3, 0xB9, 0x4F, 0x2B, 0x70, 0xCF, 0x52, 0x3E,
                /* 07E8 */   0x42, 0x01, 0xDF, 0x81, 0xF9, 0x52, 0x80, 0x3B,
                /* 07F0 */   0xA0, 0x80, 0xE1, 0xFA, 0x80, 0xFD, 0xFF, 0xC3,
                /* 07F8 */   0xBC, 0xA2, 0xE0, 0xCF, 0x28, 0xC0, 0x24, 0xF0,
                /* 0800 */   0x59, 0x0A, 0x74, 0x90, 0x3E, 0xA3, 0x00, 0xD7,
                /* 0808 */   0xA1, 0xE2, 0xCE, 0x28, 0xE0, 0x38, 0x10, 0x1E,
                /* 0810 */   0x3D, 0x3F, 0x47, 0xB1, 0x38, 0xC7, 0x12, 0x74,
                /* 0818 */   0xA8, 0x97, 0x83, 0x6E, 0x9B, 0xEC, 0x58, 0x82,
                /* 0820 */   0x8D, 0x72, 0x2C, 0x41, 0x85, 0xA0, 0xD0, 0x09,
                /* 0828 */   0xCA, 0x27, 0x09, 0x7E, 0xC6, 0xE3, 0x20, 0x06,
                /* 0830 */   0x74, 0xF6, 0x93, 0x04, 0x5A, 0xC5, 0x49, 0x02,
                /* 0838 */   0x19, 0xF6, 0x5C, 0x02, 0x84, 0xFE, 0xFF, 0xE7,
                /* 0840 */   0x12, 0xF0, 0x9E, 0x13, 0x9F, 0x26, 0xC0, 0x35,
                /* 0848 */   0x6B, 0xFC, 0x69, 0x02, 0x7F, 0x3E, 0x01, 0x16,
                /* 0850 */   0x47, 0x46, 0xC0, 0xD9, 0x41, 0x90, 0x1F, 0x19,
                /* 0858 */   0x81, 0xEF, 0xB9, 0x84, 0xFF, 0xFF, 0xCF, 0x25,
                /* 0860 */   0xE0, 0x19, 0xB6, 0xCF, 0x25, 0x80, 0x93, 0x9B,
                /* 0868 */   0x34, 0x3F, 0x97, 0xC0, 0x1D, 0xBA, 0xE3, 0x9C,
                /* 0870 */   0xBE, 0x10, 0x57, 0x58, 0xDF, 0x33, 0xE2, 0x27,
                /* 0878 */   0x18, 0xE3, 0x58, 0x82, 0x0A, 0x70, 0xF8, 0x02,
                /* 0880 */   0xB4, 0xFF, 0xFF, 0x4F, 0x23, 0xE0, 0x3F, 0x17,
                /* 0888 */   0x7B, 0xF4, 0xFC, 0x40, 0xE2, 0x43, 0x06, 0x19,
                /* 0890 */   0x3D, 0x8D, 0x7C, 0xF8, 0x82, 0x1E, 0xF1, 0x30,
                /* 0898 */   0x02, 0xB4, 0x07, 0xFA, 0xF0, 0x05, 0xC6, 0xDB,
                /* 08A0 */   0x03, 0x3F, 0x6E, 0x02, 0xAF, 0xD8, 0x87, 0x12,
                /* 08A8 */   0xD0, 0xC1, 0xF2, 0x43, 0x09, 0xF8, 0xFF, 0xFF,
                /* 08B0 */   0x87, 0x12, 0xF0, 0x8C, 0x1E, 0x77, 0xF6, 0x02,
                /* 08B8 */   0xC7, 0x55, 0xC2, 0x83, 0x37, 0xE0, 0x31, 0x3D,
                /* 08C0 */   0x16, 0x18, 0x90, 0x9D, 0x4B, 0x98, 0xEC, 0x73,
                /* 08C8 */   0x09, 0xFA, 0x3C, 0x62, 0xAB, 0xB7, 0x63, 0x72,
                /* 08D0 */   0x52, 0xC7, 0x08, 0x3F, 0x97, 0xA0, 0x24, 0x9F,
                /* 08D8 */   0x4B, 0x00, 0xDA, 0x1C, 0xBA, 0xC0, 0xF1, 0xFF,
                /* 08E0 */   0x3F, 0x74, 0x01, 0x3C, 0xB8, 0x06, 0xFA, 0x40,
                /* 08E8 */   0x02, 0xAE, 0x7B, 0x82, 0x0F, 0x24, 0xC0, 0xF5,
                /* 08F0 */   0x28, 0x00, 0x9E, 0x23, 0x08, 0xFE, 0xC8, 0xEC,
                /* 08F8 */   0x03, 0x3F, 0xEE, 0xA4, 0xEF, 0x53, 0x75, 0x5C,
                /* 0900 */   0xE3, 0x1F, 0xF1, 0x11, 0xFC, 0xFF, 0x1B, 0x3F,
                /* 0908 */   0x7D, 0x91, 0x7B, 0x81, 0x8F, 0x25, 0x3A, 0xF0,
                /* 0910 */   0xA3, 0x04, 0x53, 0x48, 0xEE, 0x01, 0x02, 0x25,
                /* 0918 */   0x10, 0x8E, 0x82, 0xF8, 0x00, 0xE1, 0xF0, 0xE7,
                /* 0920 */   0x24, 0xE8, 0x57, 0x4B, 0x7E, 0x7E, 0xC0, 0x5F,
                /* 0928 */   0x47, 0xD8, 0x28, 0xD9, 0x71, 0x1E, 0x37, 0x4A,
                /* 0930 */   0xB8, 0x60, 0xAF, 0x0F, 0x86, 0xB8, 0xC3, 0x13,
                /* 0938 */   0xE1, 0x67, 0x5B, 0xCC, 0x31, 0x1F, 0xEE, 0x51,
                /* 0940 */   0xE1, 0x51, 0x09, 0x5C, 0xB3, 0x86, 0x75, 0x58,
                /* 0948 */   0x02, 0x3C, 0x78, 0x38, 0x4C, 0x00, 0xAD, 0xFF,
                /* 0950 */   0xFF, 0x61, 0x09, 0xFC, 0xB3, 0xE7, 0x83, 0x38,
                /* 0958 */   0x11, 0x0F, 0x1F, 0x03, 0x74, 0x2C, 0x6F, 0x07,
                /* 0960 */   0xEC, 0xD8, 0xAB, 0xC3, 0x12, 0x6A, 0x0C, 0x3E,
                /* 0968 */   0xFA, 0xFA, 0xE8, 0xC4, 0x20, 0x1F, 0x0F, 0x31,
                /* 0970 */   0xC7, 0x16, 0x76, 0xC2, 0x07, 0xF8, 0xF6, 0xFF,
                /* 0978 */   0x3F, 0xE1, 0x03, 0xD6, 0xCE, 0x24, 0xBE, 0x3F,
                /* 0980 */   0x60, 0xAF, 0x2D, 0xF8, 0xA3, 0x09, 0xF0, 0x06,
                /* 0988 */   0xF7, 0xD1, 0x04, 0x70, 0xF5, 0xFF, 0x3F, 0x9A,
                /* 0990 */   0xE0, 0x84, 0x9E, 0x9D, 0x50, 0x67, 0x03, 0x1F,
                /* 0998 */   0x98, 0x6C, 0x14, 0x95, 0x40, 0xBF, 0x69, 0xBC,
                /* 09A0 */   0x9F, 0x07, 0x31, 0xF4, 0x49, 0xF0, 0x53, 0x13,
                /* 09A8 */   0x06, 0xC2, 0x47, 0x13, 0x9F, 0x24, 0x7C, 0x9C,
                /* 09B0 */   0xE0, 0x52, 0xE0, 0x28, 0x88, 0x8F, 0x13, 0x8E,
                /* 09B8 */   0x79, 0x36, 0x41, 0x9F, 0x0A, 0x7C, 0x3F, 0x38,
                /* 09C0 */   0x09, 0x6C, 0xA8, 0xF3, 0x04, 0x50, 0x19, 0x07,
                /* 09C8 */   0xFE, 0xE8, 0x04, 0x57, 0xD8, 0xC9, 0x04, 0x64,
                /* 09D0 */   0x27, 0x72, 0x60, 0x6E, 0xE2, 0x1C, 0x01, 0x94,
                /* 09D8 */   0xFE, 0xFF, 0x27, 0x72, 0xE0, 0x70, 0x5A, 0xE5,
                /* 09E0 */   0xA7, 0x01, 0x7C, 0xA0, 0xA3, 0x2A, 0x3A, 0xD6,
                /* 09E8 */   0x93, 0x41, 0x23, 0x7E, 0x07, 0x08, 0x77, 0xEA,
                /* 09F0 */   0xE7, 0xF9, 0x40, 0xC0, 0x8E, 0xE5, 0x3E, 0x2C,
                /* 09F8 */   0xF1, 0xF3, 0x92, 0x4F, 0x11, 0x3E, 0x41, 0x70,
                /* 0A00 */   0x49, 0x27, 0x08, 0x0A, 0x62, 0x40, 0xE7, 0x3D,
                /* 0A08 */   0x5D, 0x7A, 0x10, 0xF4, 0x7C, 0xC3, 0x8F, 0xC5,
                /* 0A10 */   0xBE, 0xB6, 0x1C, 0xC5, 0x23, 0x51, 0x82, 0xF9,
                /* 0A18 */   0x0E, 0x01, 0xF4, 0xB6, 0x04, 0x4F, 0xDE, 0x6D,
                /* 0A20 */   0x09, 0x44, 0x18, 0x77, 0x72, 0x16, 0x0C, 0xE1,
                /* 0A28 */   0x28, 0x7D, 0x80, 0x80, 0x31, 0xC0, 0xC7, 0x84,
                /* 0A30 */   0x62, 0xDF, 0x37, 0xF4, 0xBE, 0x04, 0xF3, 0x8A,
                /* 0A38 */   0x09, 0xAE, 0xF3, 0x12, 0x30, 0x9E, 0x89, 0xFF,
                /* 0A40 */   0xFF, 0x3E, 0xCF, 0x21, 0xE4, 0x02, 0xC0, 0x4F,
                /* 0A48 */   0xE5, 0x60, 0x39, 0x36, 0x80, 0x67, 0x1C, 0xEC,
                /* 0A50 */   0x0A, 0x80, 0x3F, 0x32, 0xC1, 0x3E, 0x35, 0xE2,
                /* 0A58 */   0x8E, 0x4C, 0x60, 0x98, 0x08, 0x3B, 0xE7, 0x1C,
                /* 0A60 */   0x08, 0xF6, 0x60, 0x02, 0xBC, 0x55, 0x1C, 0x4C,
                /* 0A68 */   0x00, 0x2D, 0xC3, 0x0D, 0x72, 0x3E, 0x8F, 0xE4,
                /* 0A70 */   0xC6, 0x79, 0xC3, 0xF3, 0x89, 0x84, 0x9D, 0xC4,
                /* 0A78 */   0xD9, 0xFF, 0xFF, 0x60, 0xC2, 0x25, 0x41, 0x48,
                /* 0A80 */   0xFE, 0x61, 0x09, 0x89, 0x8D, 0x9D, 0xFE, 0x39,
                /* 0A88 */   0xBC, 0xB9, 0x32, 0x82, 0x62, 0x8F, 0x4B, 0xA8,
                /* 0A90 */   0xC3, 0x84, 0x45, 0x9E, 0x26, 0x50, 0xA7, 0x69,
                /* 0A98 */   0x9F, 0x90, 0xC9, 0x69, 0x82, 0x46, 0x3E, 0x4D,
                /* 0AA0 */   0xA0, 0x87, 0xE6, 0x89, 0x9D, 0x06, 0x6E, 0xDC,
                /* 0AA8 */   0xA7, 0xC1, 0x6F, 0x87, 0xFC, 0xC0, 0x04, 0x7C,
                /* 0AB0 */   0x0F, 0x0F, 0xF8, 0xD3, 0x04, 0xEC, 0xF3, 0x0D,
                /* 0AB8 */   0x1B, 0x74, 0xC8, 0x77, 0x87, 0x17, 0x59, 0x1F,
                /* 0AC0 */   0x26, 0x80, 0xF9, 0xC8, 0x7D, 0x98, 0x00, 0xFF,
                /* 0AC8 */   0xFF, 0xFF, 0xD0, 0x04, 0x5C, 0x15, 0xDA, 0xF4,
                /* 0AD0 */   0xA9, 0xD1, 0xA8, 0x55, 0x83, 0x32, 0x35, 0xCA,
                /* 0AD8 */   0x34, 0xA8, 0xD5, 0xA7, 0x52, 0x63, 0xC6, 0xA4,
                /* 0AE0 */   0x9D, 0x54, 0xBD, 0x54, 0x8D, 0xD5, 0x91, 0x9E,
                /* 0AE8 */   0x0B, 0x02, 0x71, 0xD4, 0x05, 0x0B, 0xC4, 0xD1,
                /* 0AF0 */   0x9F, 0x40, 0x02, 0xB1, 0xB8, 0x57, 0x88, 0x40,
                /* 0AF8 */   0x2C, 0xF5, 0x05, 0x21, 0x10, 0xCB, 0xD4, 0x01,
                /* 0B00 */   0xC2, 0x82, 0xBC, 0xEF, 0x05, 0xE2, 0x60, 0x52,
                /* 0B08 */   0x06, 0x40, 0xAD, 0x80, 0xB0, 0x78, 0xCB, 0x12,
                /* 0B10 */   0x88, 0x23, 0x9A, 0x39, 0x01, 0x50, 0x37, 0x20,
                /* 0B18 */   0x4C, 0xA0, 0x1E, 0x10, 0x26, 0xDC, 0x10, 0x08,
                /* 0B20 */   0x8B, 0xA3, 0x08, 0x84, 0x09, 0xB6, 0x04, 0xC2,
                /* 0B28 */   0xE2, 0x82, 0x50, 0xC1, 0x9E, 0x8E, 0xFD, 0x4C,
                /* 0B30 */   0x3E, 0x88, 0x80, 0x1C, 0xDA, 0x14, 0x10, 0x93,
                /* 0B38 */   0xA0, 0x0A, 0x88, 0x25, 0x78, 0x0C, 0x08, 0xC8,
                /* 0B40 */   0x71, 0x40, 0x04, 0xE4, 0x50, 0xB6, 0x80, 0x58,
                /* 0B48 */   0x44, 0x10, 0x01, 0x59, 0xCF, 0x1B, 0x4E, 0x40,
                /* 0B50 */   0x16, 0x07, 0x22, 0x20, 0x8B, 0x36, 0x06, 0xC4,
                /* 0B58 */   0x22, 0x80, 0x08, 0xC8, 0xC9, 0x5E, 0x70, 0x81,
                /* 0B60 */   0x48, 0x4C, 0x10, 0x01, 0x39, 0xEC, 0x8A, 0x05,
                /* 0B68 */   0xE4, 0xE8, 0x20, 0x02, 0xB2, 0x4E, 0x6F, 0x40,
                /* 0B70 */   0x4C, 0x34, 0x88, 0x80, 0x2C, 0xFE, 0xB1, 0x21,
                /* 0B78 */   0x20, 0x47, 0x01, 0x11, 0x90, 0x03, 0x3E, 0x28,
                /* 0B80 */   0x02, 0x91, 0xB8, 0x20, 0x02, 0xB2, 0x46, 0x7B,
                /* 0B88 */   0x40, 0x4C, 0x30, 0x88, 0x80, 0x2C, 0xFB, 0x07,
                /* 0B90 */   0x25, 0x20, 0x87, 0x00, 0xD1, 0x00, 0xC9, 0xEB,
                /* 0B98 */   0x40, 0x03, 0x24, 0xBF, 0x89, 0x40, 0x44, 0xE2,
                /* 0BA0 */   0xAB, 0x22, 0x10, 0xD1, 0x0B, 0x22, 0x20, 0xFF,
                /* 0BA8 */   0xFF, 0xA5, 0xFF, 0x38, 0x04, 0xE4, 0x20, 0x20,
                /* 0BB0 */   0x02, 0x26, 0x1A, 0x81, 0xE9, 0x0B, 0x21, 0x10,
                /* 0BB8 */   0xF9, 0xFF, 0x03
            })
            Name (_HID, EisaId ("PNP0C14"))  // _HID: Hardware ID
            Name (_UID, Zero)  // _UID: Unique ID
            Name (_WDG, Buffer (0x28)
            {
                /* 0000 */   0x6A, 0x0F, 0xBC, 0xAB, 0xA1, 0x8E, 0xD1, 0x11,
                /* 0008 */   0x00, 0xA0, 0xC9, 0x06, 0x29, 0x10, 0x00, 0x00,
                /* 0010 */   0x41, 0x41, 0x01, 0x02, 0x21, 0x12, 0x90, 0x05,
                /* 0018 */   0x66, 0xD5, 0xD1, 0x11, 0xB2, 0xF0, 0x00, 0xA0,
                /* 0020 */   0xC9, 0x06, 0x29, 0x10, 0x42, 0x41, 0x01, 0x00
            })
            Method (WMAA, 3, NotSerialized)
            {
                If (LEqual (Arg0, Zero))
                {
                    If (LOr (LOr (LNotEqual (Arg1, One), LNotEqual (Arg1, 
                        0x02)), LNotEqual (Arg1, 0x06)))
                    {
                        CreateDWordField (Arg2, Zero, WIID)
                    }

                    If (LEqual (Arg1, One))
                    {
                        Return (AM01 ())
                    }
                    Else
                    {
                        If (LEqual (Arg1, 0x02))
                        {
                            Return (AM02 ())
                        }
                        Else
                        {
                            If (LEqual (Arg1, 0x03))
                            {
                                Return (AM03 (WIID))
                            }
                            Else
                            {
                                If (LEqual (Arg1, 0x04))
                                {
                                    CreateDWordField (Arg2, 0x04, IVAL)
                                    Return (AM04 (WIID, IVAL))
                                }
                                Else
                                {
                                    If (LEqual (Arg1, 0x05))
                                    {
                                        Return (AM05 (WIID))
                                    }
                                    Else
                                    {
                                        If (LEqual (Arg1, 0x06))
                                        {
                                            Return (AM06 ())
                                        }
                                        Else
                                        {
                                            If (LEqual (Arg1, 0x07))
                                            {
                                                AM07 (Arg2)
                                            }
                                            Else
                                            {
                                                If (LEqual (Arg1, 0x08))
                                                {
                                                    AM08 (WIID)
                                                }
                                                Else
                                                {
                                                    If (LEqual (Arg1, 0x09))
                                                    {
                                                        Return (AM09 ())
                                                    }
                                                    Else
                                                    {
                                                        If (LEqual (Arg1, 0x0A))
                                                        {
                                                            Return (AM10 (Arg2))
                                                        }
                                                        Else
                                                        {
                                                            If (LEqual (Arg1, 0x0B))
                                                            {
                                                                Return (AM11 ())
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    Name (GNLD, 0x02)
    Name (OBDP, 0x02)
    Method (DBGL, 1, NotSerialized)
    {
        If (LEqual (Arg0, One))
        {
            Or (\_SB.PCI0.SBRG.IOPD, 0x20, \_SB.PCI0.SBRG.IOPD)
            \_SB.PCI0.SBRG.SIO1.ENFG (0x08)
            And (\_SB.PCI0.SBRG.SIO1.SCF7, 0xEF, \_SB.PCI0.SBRG.SIO1.SCF7)
            \_SB.PCI0.SBRG.SIO1.EXFG ()
        }
        Else
        {
            And (\_SB.PCI0.SBRG.IOPD, 0xDF, \_SB.PCI0.SBRG.IOPD)
            \_SB.PCI0.SBRG.SIO1.ENFG (0x08)
            Or (\_SB.PCI0.SBRG.SIO1.SCF7, 0x10, \_SB.PCI0.SBRG.SIO1.SCF7)
            \_SB.PCI0.SBRG.SIO1.EXFG ()
        }
    }

    Method (SYSL, 1, NotSerialized)
    {
        If (LEqual (Arg0, One))
        {
            \_SB.PCI0.SBRG.SIO1.ENFG (0x08)
            And (\_SB.PCI0.SBRG.SIO1.OPT0, 0x7F, \_SB.PCI0.SBRG.SIO1.OPT0)
            \_SB.PCI0.SBRG.SIO1.EXFG ()
        }
        Else
        {
            \_SB.PCI0.SBRG.SIO1.ENFG (0x08)
            Or (\_SB.PCI0.SBRG.SIO1.OPT0, 0x80, \_SB.PCI0.SBRG.SIO1.OPT0)
            \_SB.PCI0.SBRG.SIO1.EXFG ()
        }
    }

    Method (LEDS, 1, NotSerialized)
    {
        If (LEqual (OBDP, 0x02))
        {
            DBGL (One)
            Store (Arg0, DBG8)
        }

        If (LEqual (GNLD, One))
        {
            \_SB.PCI0.SBRG.SIO1.ENFG (0x0B)
            And (\_SB.PCI0.SBRG.SIO1.OPT7, Zero, \_SB.PCI0.SBRG.SIO1.OPT7)
            \_SB.PCI0.SBRG.SIO1.EXFG ()
        }
    }

    Method (LEDW, 1, NotSerialized)
    {
        If (LEqual (OBDP, 0x02))
        {
            DBGL (Zero)
            ShiftLeft (Arg0, 0x04, DBG8)
        }

        If (LEqual (GNLD, 0x02))
        {
            SYSL (Zero)
        }

        If (LEqual (GNLD, One))
        {
            \_SB.PCI0.SBRG.SIO1.ENFG (0x0B)
            And (\_SB.PCI0.SBRG.SIO1.OPT7, Zero, \_SB.PCI0.SBRG.SIO1.OPT7)
            \_SB.PCI0.SBRG.SIO1.EXFG ()
        }
    }

    Scope (_SB.PCI0)
    {
        Name (SLIC, Buffer (0x9E)
        {
            "439354872812Genuine NVIDIA Certified SLI Ready Motherboard for ASROCK 970 EXTREME4 648a-Copyright 2011 NVIDIA Corporation All Rights Reserved-495802635467(R)"
        })
        Device (WMI1)
        {
            Name (_HID, "pnp0c14")  // _HID: Hardware ID
            Name (_UID, "MXM2")  // _UID: Unique ID
            Name (_WDG, Buffer (0x14)
            {
                /* 0000 */   0x3C, 0x5C, 0xCB, 0xF6, 0xAE, 0x9C, 0xBD, 0x4E,
                /* 0008 */   0xB5, 0x77, 0x93, 0x1E, 0xA3, 0x2A, 0x2C, 0xC0,
                /* 0010 */   0x4D, 0x58, 0x01, 0x02
            })
            Method (WMMX, 3, NotSerialized)
            {
                CreateDWordField (Arg2, Zero, FUNC)
                If (LEqual (FUNC, 0x41494C53))
                {
                    Return (SLIC)
                }

                Return (Zero)
            }
        }
    }

    Name (_S0, Package (0x04)  // _S0_: S0 System State
    {
        Zero, 
        Zero, 
        Zero, 
        Zero
    })
    If (SS1)
    {
        Name (_S1, Package (0x04)  // _S1_: S1 System State
        {
            One, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS3)
    {
        Name (_S3, Package (0x04)  // _S3_: S3 System State
        {
            0x03, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS4)
    {
        Name (_S4, Package (0x04)  // _S4_: S4 System State
        {
            0x04, 
            Zero, 
            Zero, 
            Zero
        })
    }

    Name (_S5, Package (0x04)  // _S5_: S5 System State
    {
        0x05, 
        Zero, 
        Zero, 
        Zero
    })
    Method (PTS, 1, NotSerialized)
    {
        If (Arg0)
        {
            SPTS (Arg0)
            \_SB.PCI0.SBRG.IPTS (Arg0)
            \_SB.PCI0.NPTS (Arg0)
            S4RS (Arg0)
            LEDS (Arg0)
            \_SB.PCI0.SBRG.SIOS (Arg0)
        }
    }

    Method (WAK, 1, NotSerialized)
    {
        SWAK (Arg0)
        \_SB.PCI0.NWAK (Arg0)
        LEDW (Arg0)
        \_SB.PCI0.SBRG.SIOW (Arg0)
    }
}

