/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20050902
 *
 * Disassembly of , Sat Nov 10 12:03:39 2007
 */
DefinitionBlock ("DSDT.aml", "DSDT", 1, "IBM   ", "TP-1S   ", 4400)
{
    Scope (_PR)
    {
        Processor (CPU, 0x01, 0x00008010, 0x06)
        {
            Method (_INI, 0, NotSerialized)
            {
                Store (\P0FQ, Index (DerefOf (Index (_PSS, 0x00)), 0x00))
                Store (\P0PW, Index (DerefOf (Index (_PSS, 0x00)), 0x01))
                Store (\P1FQ, Index (DerefOf (Index (_PSS, 0x01)), 0x00))
                Store (\P1PW, Index (DerefOf (Index (_PSS, 0x01)), 0x01))
                If (LNot (\SPEN))
                {
                    Store (0x99, Index (DerefOf (Index (_PSS, 0x00)), 0x04))
                    Store (0x99, Index (DerefOf (Index (_PSS, 0x01)), 0x04))
                }
            }

            Name (_PCT, Package (0x02)
            {
                ResourceTemplate ()
                {
                    Register (SystemIO, 0x08, 0x00, 0x00000000000000B1)
                }, 

                ResourceTemplate ()
                {
                    Register (SystemIO, 0x08, 0x00, 0x000000000000802F)
                }
            })
            Name (_PSS, Package (0x02)
            {
                Package (0x06)
                {
                    0x00, 
                    0x00, 
                    0x01F4, 
                    0x00, 
                    0xF6, 
                    0x00
                }, 

                Package (0x06)
                {
                    0x00, 
                    0x00, 
                    0x01F4, 
                    0x00, 
                    0xF7, 
                    0x01
                }
            })
            Method (_PPC, 0, NotSerialized)
            {
                If (LNot (\SPEN))
                {
                    Return (0x01)
                }

                If (\_SB.PCI0.LPC.EC.HPLO)
                {
                    Return (0x01)
                }
                Else
                {
                    If (LOr (\_SB.PCI0.LPC.EC.HT00, \_SB.PCI0.LPC.EC.HT10))
                    {
                        Return (0x01)
                    }
                    Else
                    {
                        Return (0x00)
                    }
                }
            }

            Name (CST1, Package (0x02)
            {
                0x01, 
                Package (0x04)
                {
                    ResourceTemplate ()
                    {
                        Register (FFixedHW, 0x08, 0x00, 0x0000000000000000)
                    }, 

                    0x01, 
                    0x01, 
                    0x03E8
                }
            })
            Name (CST2, Package (0x03)
            {
                0x02, 
                Package (0x04)
                {
                    ResourceTemplate ()
                    {
                        Register (FFixedHW, 0x08, 0x00, 0x0000000000000000)
                    }, 

                    0x01, 
                    0x01, 
                    0x03E8
                }, 

                Package (0x04)
                {
                    ResourceTemplate ()
                    {
                        Register (SystemIO, 0x08, 0x00, 0x0000000000008014)
                    }, 

                    0x02, 
                    0x03, 
                    0x01F4
                }
            })
            Name (CST3, Package (0x04)
            {
                0x03, 
                Package (0x04)
                {
                    ResourceTemplate ()
                    {
                        Register (FFixedHW, 0x08, 0x00, 0x0000000000000000)
                    }, 

                    0x01, 
                    0x01, 
                    0x03E8
                }, 

                Package (0x04)
                {
                    ResourceTemplate ()
                    {
                        Register (SystemIO, 0x08, 0x00, 0x0000000000008014)
                    }, 

                    0x02, 
                    0x03, 
                    0x01F4
                }, 

                Package (0x04)
                {
                    ResourceTemplate ()
                    {
                        Register (SystemIO, 0x08, 0x00, 0x0000000000008015)
                    }, 

                    0x03, 
                    0xFA, 
                    0xFA
                }
            })
            Name (CST4, Package (0x05)
            {
                0x04, 
                Package (0x04)
                {
                    ResourceTemplate ()
                    {
                        Register (FFixedHW, 0x08, 0x00, 0x0000000000000000)
                    }, 

                    0x01, 
                    0x01, 
                    0x03E8
                }, 

                Package (0x04)
                {
                    ResourceTemplate ()
                    {
                        Register (SystemIO, 0x08, 0x00, 0x0000000000008014)
                    }, 

                    0x02, 
                    0x03, 
                    0x01F4
                }, 

                Package (0x04)
                {
                    ResourceTemplate ()
                    {
                        Register (SystemIO, 0x08, 0x00, 0x0000000000008015)
                    }, 

                    0x03, 
                    0xFA, 
                    0xFA
                }, 

                Package (0x04)
                {
                    ResourceTemplate ()
                    {
                        Register (SystemIO, 0x08, 0x00, 0x0000000000008016)
                    }, 

                    0x03, 
                    0xFA, 
                    0x64
                }
            })
            Method (_CST, 0, NotSerialized)
            {
                If (\C2NA)
                {
                    Return (CST1)
                }

                If (\C3NA)
                {
                    Return (CST2)
                }

                If (\_SB.PCI0.LPC.EC.AC._PSR ())
                {
                    Return (CST3)
                }

                If (\C4NA)
                {
                    Return (CST3)
                }

                If (LNot (\SPEN))
                {
                    Return (CST3)
                }

                Return (CST3)
            }
        }
    }

    Scope (_SB)
    {
        OperationRegion (DBG, SystemIO, 0x80, 0x01)
        Field (DBG, ByteAcc, NoLock, Preserve)
        {
            DEBG,   8
        }

        Method (_INI, 0, NotSerialized)
        {
            If (LEqual (\SCMP (\_OS, "Microsoft Windows"), Zero))
            {
                Store (0x01, \W98F)
            }
            Else
            {
                If (CondRefOf (_OSI, Local0))
                {
                    If (\_OSI ("Windows 2001"))
                    {
                        Store (0x02, \WNTF)
                    }
                }
                Else
                {
                    If (LEqual (\SCMP (\_OS, "Microsoft Windows NT"), Zero))
                    {
                        Store (0x01, \WNTF)
                    }
                    Else
                    {
                        If (LEqual (\SCMP (\_OS, "Microsoft WindowsME: Millennium Edition"), Zero))
                        {
                            Store (0x01, \WMEF)
                            Store (0x01, \W98F)
                        }
                    }
                }
            }

            If (LNot (LLess (\_REV, 0x02)))
            {
                Store (0x01, \H8DR)
            }

            Store (0x01, \OSIF)
        }

        Name (IXLT, Package (0x10)
        {
            0x00, 
            0x0200, 
            0x08, 
            0x0400, 
            0x10, 
            0x20, 
            0x80, 
            0x40, 
            0x02, 
            0x0800, 
            0x00, 
            0x1000, 
            0x00, 
            0x4000, 
            0x00, 
            0x8000
        })
        Device (LNKA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x01)
            Method (_STA, 0, NotSerialized)
            {
                If (LNot (VPIR (\_SB.PCI0.LPC.PIRA)))
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Name (_PRS, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {3,4,5,6,7,10,11}
            })
            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, \_SB.PCI0.LPC.PIRA)
            }

            Name (BUFA, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {}
            })
            CreateWordField (BUFA, 0x01, IRA1)
            Method (_CRS, 0, NotSerialized)
            {
                Store (\_SB.PCI0.LPC.PIRA, Local0)
                If (VPIR (Local0))
                {
                    Store (DerefOf (Index (IXLT, Local0)), IRA1)
                }
                Else
                {
                    Store (0x00, IRA1)
                }

                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRA2)
                Store (Match (IXLT, MEQ, IRA2, MGT, 0x00, 0x00), Local1)
                Store (Local1, \_SB.PCI0.LPC.PIRA)
            }
        }

        Device (LNKB)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x02)
            Method (_STA, 0, NotSerialized)
            {
                If (LNot (VPIR (\_SB.PCI0.LPC.PIRB)))
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Name (_PRS, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {3,4,5,6,7,10,11}
            })
            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, \_SB.PCI0.LPC.PIRB)
            }

            Name (BUFB, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {}
            })
            CreateWordField (BUFB, 0x01, IRB1)
            Method (_CRS, 0, NotSerialized)
            {
                Store (\_SB.PCI0.LPC.PIRB, Local0)
                If (VPIR (Local0))
                {
                    Store (DerefOf (Index (IXLT, Local0)), IRB1)
                }
                Else
                {
                    Store (0x00, IRB1)
                }

                Return (BUFB)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRB2)
                Store (Match (IXLT, MEQ, IRB2, MGT, 0x00, 0x00), Local1)
                Store (Local1, \_SB.PCI0.LPC.PIRB)
            }
        }

        Device (LNKC)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x03)
            Method (_STA, 0, NotSerialized)
            {
                If (LNot (VPIR (\_SB.PCI0.LPC.PIRC)))
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Name (_PRS, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {3,4,5,6,7,10,11}
            })
            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, \_SB.PCI0.LPC.PIRC)
            }

            Name (BUFC, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {}
            })
            CreateWordField (BUFC, 0x01, IRC1)
            Method (_CRS, 0, NotSerialized)
            {
                Store (\_SB.PCI0.LPC.PIRC, Local0)
                If (VPIR (Local0))
                {
                    Store (DerefOf (Index (IXLT, Local0)), IRC1)
                }
                Else
                {
                    Store (0x00, IRC1)
                }

                Return (BUFC)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRC2)
                Store (Match (IXLT, MEQ, IRC2, MGT, 0x00, 0x00), Local1)
                Store (Local1, \_SB.PCI0.LPC.PIRC)
            }
        }

        Device (LNKD)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x04)
            Method (_STA, 0, NotSerialized)
            {
                If (LNot (VPIR (\_SB.PCI0.LPC.PIRD)))
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Name (_PRS, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {3,4,5,6,7,10,11}
            })
            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, \_SB.PCI0.LPC.PIRD)
            }

            Name (BUFD, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {}
            })
            CreateWordField (BUFD, 0x01, IRD1)
            Method (_CRS, 0, NotSerialized)
            {
                Store (\_SB.PCI0.LPC.PIRD, Local0)
                If (VPIR (Local0))
                {
                    Store (DerefOf (Index (IXLT, Local0)), IRD1)
                }
                Else
                {
                    Store (0x00, IRD1)
                }

                Return (BUFD)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRD2)
                Store (Match (IXLT, MEQ, IRD2, MGT, 0x00, 0x00), Local1)
                Store (Local1, \_SB.PCI0.LPC.PIRD)
            }
        }

        Device (LNKE)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x05)
            Method (_STA, 0, NotSerialized)
            {
                If (LNot (VPIR (\_SB.PCI0.LPC.PIRE)))
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Name (_PRS, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {3,4,5,6,7,10,11}
            })
            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, \_SB.PCI0.LPC.PIRE)
            }

            Name (BUFE, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {}
            })
            CreateWordField (BUFE, 0x01, IRE1)
            Method (_CRS, 0, NotSerialized)
            {
                Store (\_SB.PCI0.LPC.PIRE, Local0)
                If (VPIR (Local0))
                {
                    Store (DerefOf (Index (IXLT, Local0)), IRE1)
                }
                Else
                {
                    Store (0x00, IRE1)
                }

                Return (BUFE)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRE2)
                Store (Match (IXLT, MEQ, IRE2, MGT, 0x00, 0x00), Local1)
                Store (Local1, \_SB.PCI0.LPC.PIRE)
            }
        }

        Device (LNKG)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x07)
            Method (_STA, 0, NotSerialized)
            {
                If (LNot (VPIR (\_SB.PCI0.LPC.PIRG)))
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Name (_PRS, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {3,4,5,6,7,10,11}
            })
            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, \_SB.PCI0.LPC.PIRG)
            }

            Name (BUFG, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {}
            })
            CreateWordField (BUFG, 0x01, IRG1)
            Method (_CRS, 0, NotSerialized)
            {
                Store (\_SB.PCI0.LPC.PIRG, Local0)
                If (VPIR (Local0))
                {
                    Store (DerefOf (Index (IXLT, Local0)), IRG1)
                }
                Else
                {
                    Store (0x00, IRG1)
                }

                Return (BUFG)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRG2)
                Store (Match (IXLT, MEQ, IRG2, MGT, 0x00, 0x00), Local1)
                Store (Local1, \_SB.PCI0.LPC.PIRG)
            }
        }

        Device (LNKH)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x08)
            Method (_STA, 0, NotSerialized)
            {
                If (LNot (VPIR (\_SB.PCI0.LPC.PIRH)))
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Name (_PRS, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {3,4,5,6,7,10,11}
            })
            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, \_SB.PCI0.LPC.PIRH)
            }

            Name (BUFH, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {}
            })
            CreateWordField (BUFH, 0x01, IRH1)
            Method (_CRS, 0, NotSerialized)
            {
                Store (\_SB.PCI0.LPC.PIRH, Local0)
                If (VPIR (Local0))
                {
                    Store (DerefOf (Index (IXLT, Local0)), IRH1)
                }
                Else
                {
                    Store (0x00, IRH1)
                }

                Return (BUFH)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRH2)
                Store (Match (IXLT, MEQ, IRH2, MGT, 0x00, 0x00), Local1)
                Store (Local1, \_SB.PCI0.LPC.PIRH)
            }
        }

        Device (LNKI)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x09)
            Method (_STA, 0, NotSerialized)
            {
                If (LNot (VPIR (\_SB.PCI0.LPC.PIRI)))
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Name (_PRS, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {3,4,5,6,7,10,11}
            })
            Method (_DIS, 0, NotSerialized)
            {
                Store (0x00, \_SB.PCI0.LPC.PIRI)
            }

            Name (BUFH, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared) {}
            })
            CreateWordField (BUFH, 0x01, IRI1)
            Method (_CRS, 0, NotSerialized)
            {
                Store (\_SB.PCI0.LPC.PIRI, Local0)
                If (VPIR (Local0))
                {
                    Store (DerefOf (Index (IXLT, Local0)), IRI1)
                }
                Else
                {
                    Store (0x00, IRI1)
                }

                Return (BUFH)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, 0x01, IRI2)
                Store (Match (IXLT, MEQ, IRI2, MGT, 0x00, 0x00), Local1)
                Store (Local1, \_SB.PCI0.LPC.PIRI)
            }
        }

        Method (VPIR, 1, NotSerialized)
        {
            Store (0x01, Local0)
            And (Arg0, 0x0F, Local1)
            If (LEqual (Local1, 0x00))
            {
                Store (0x00, Local0)
            }
            Else
            {
                If (LOr (LEqual (Local1, 0x08), LEqual (Local1, 0x0A)))
                {
                    Store (0x00, Local0)
                }

                If (LOr (LEqual (Local1, 0x0C), LEqual (Local1, 0x0E)))
                {
                    Store (0x00, Local0)
                }
            }

            Return (Local0)
        }

        Device (MEM)
        {
            Name (_HID, EisaId ("PNP0C01"))
            Name (ME98, ResourceTemplate ()
            {
                Memory32Fixed (ReadWrite, 0x00000000, 0x000A0000)
                Memory32Fixed (ReadOnly, 0x000E0000, 0x00020000)
                Memory32Fixed (ReadWrite, 0x00100000, 0x01EE0000)
                Memory32Fixed (ReadOnly, 0xFEC00000, 0x01400000)
            })
            CreateDWordField (ME98, 0x1C, MEB0)
            CreateDWordField (ME98, 0x20, MEL0)
            Name (MGAP, ResourceTemplate ()
            {
                Memory32Fixed (ReadOnly, 0x00000000, 0x00000000)
            })
            CreateDWordField (MGAP, 0x04, MGPB)
            CreateDWordField (MGAP, 0x08, MGPL)
            Name (MEMS, ResourceTemplate ()
            {
                Memory32Fixed (ReadWrite, 0x00000000, 0x000A0000)
                Memory32Fixed (ReadOnly, 0x000C0000, 0x00000000)
                Memory32Fixed (ReadOnly, 0x000C4000, 0x00000000)
                Memory32Fixed (ReadOnly, 0x000C8000, 0x00000000)
                Memory32Fixed (ReadOnly, 0x000CC000, 0x00000000)
                Memory32Fixed (ReadOnly, 0x000D0000, 0x00000000)
                Memory32Fixed (ReadOnly, 0x000D4000, 0x00000000)
                Memory32Fixed (ReadOnly, 0x000D8000, 0x00000000)
                Memory32Fixed (ReadOnly, 0x000DC000, 0x00000000)
                Memory32Fixed (ReadOnly, 0x000E0000, 0x00000000)
                Memory32Fixed (ReadOnly, 0x000E4000, 0x00000000)
                Memory32Fixed (ReadOnly, 0x000E8000, 0x00000000)
                Memory32Fixed (ReadOnly, 0x000EC000, 0x00000000)
                Memory32Fixed (ReadOnly, 0x000F0000, 0x00010000)
                Memory32Fixed (ReadWrite, 0x00100000, 0x01EE0000)
                Memory32Fixed (ReadOnly, 0xFFF00000, 0x00100000)
            })
            CreateDWordField (MEMS, 0x14, MC0L)
            CreateDWordField (MEMS, 0x20, MC4L)
            CreateDWordField (MEMS, 0x2C, MC8L)
            CreateDWordField (MEMS, 0x38, MCCL)
            CreateDWordField (MEMS, 0x44, MD0L)
            CreateDWordField (MEMS, 0x50, MD4L)
            CreateDWordField (MEMS, 0x5C, MD8L)
            CreateDWordField (MEMS, 0x68, MDCL)
            CreateDWordField (MEMS, 0x74, ME0L)
            CreateDWordField (MEMS, 0x80, ME4L)
            CreateDWordField (MEMS, 0x8C, ME8L)
            CreateDWordField (MEMS, 0x98, MECL)
            CreateBitField (MEMS, 0x78, MC0W)
            CreateBitField (MEMS, 0xD8, MC4W)
            CreateBitField (MEMS, 0x0138, MC8W)
            CreateBitField (MEMS, 0x0198, MCCW)
            CreateBitField (MEMS, 0x01F8, MD0W)
            CreateBitField (MEMS, 0x0258, MD4W)
            CreateBitField (MEMS, 0x02B8, MD8W)
            CreateBitField (MEMS, 0x0318, MDCW)
            CreateBitField (MEMS, 0x0378, ME0W)
            CreateBitField (MEMS, 0x03D8, ME4W)
            CreateBitField (MEMS, 0x0438, ME8W)
            CreateBitField (MEMS, 0x0498, MECW)
            CreateDWordField (MEMS, 0xAC, MEB1)
            CreateDWordField (MEMS, 0xB0, MEL1)
            Method (_CRS, 0, NotSerialized)
            {
                If (\W98F)
                {
                    Subtract (\MEMX, MEB0, MEL0)
                    Store (\GAPA, MGPB)
                    Store (\GAPL, MGPL)
                    If (LAnd (MGPB, MGPL))
                    {
                        Subtract (SizeOf (ME98), 0x02, Local0)
                        Name (MBF0, Buffer (Local0) {})
                        Add (Local0, SizeOf (MGAP), Local0)
                        Name (MBF1, Buffer (Local0) {})
                        Store (ME98, MBF0)
                        Concatenate (MBF0, MGAP, MBF1)
                        Return (MBF1)
                    }
                    Else
                    {
                        Return (ME98)
                    }
                }

                And (\_SB.PCI0.PAM1, 0x03, Local0)
                If (Local0)
                {
                    Store (0x4000, MC0L)
                    If (And (Local0, 0x02))
                    {
                        Store (0x01, MC0W)
                    }
                }

                And (\_SB.PCI0.PAM1, 0x30, Local0)
                If (Local0)
                {
                    Store (0x4000, MC4L)
                    If (And (Local0, 0x20))
                    {
                        Store (0x01, MC4W)
                    }
                }

                And (\_SB.PCI0.PAM2, 0x03, Local0)
                If (Local0)
                {
                    Store (0x4000, MC8L)
                    If (And (Local0, 0x02))
                    {
                        Store (0x01, MC8W)
                    }
                }

                And (\_SB.PCI0.PAM2, 0x30, Local0)
                If (Local0)
                {
                    Store (0x4000, MCCL)
                    If (And (Local0, 0x20))
                    {
                        Store (0x01, MCCW)
                    }
                }

                And (\_SB.PCI0.PAM3, 0x03, Local0)
                If (Local0)
                {
                    Store (0x4000, MD0L)
                    If (And (Local0, 0x02))
                    {
                        Store (0x01, MD0W)
                    }
                }

                And (\_SB.PCI0.PAM3, 0x30, Local0)
                If (Local0)
                {
                    Store (0x4000, MD4L)
                    If (And (Local0, 0x20))
                    {
                        Store (0x01, MD4W)
                    }
                }

                And (\_SB.PCI0.PAM4, 0x03, Local0)
                If (Local0)
                {
                    Store (0x4000, MD8L)
                    If (And (Local0, 0x02))
                    {
                        Store (0x01, MD8W)
                    }
                }

                And (\_SB.PCI0.PAM4, 0x30, Local0)
                If (Local0)
                {
                    Store (0x4000, MDCL)
                    If (And (Local0, 0x20))
                    {
                        Store (0x01, MDCW)
                    }
                }

                And (\_SB.PCI0.PAM5, 0x03, Local0)
                If (Local0)
                {
                    Store (0x4000, ME0L)
                    If (And (Local0, 0x02))
                    {
                        Store (0x01, ME0W)
                    }
                }

                And (\_SB.PCI0.PAM5, 0x30, Local0)
                If (Local0)
                {
                    Store (0x4000, ME4L)
                    If (And (Local0, 0x20))
                    {
                        Store (0x01, ME4W)
                    }
                }

                And (\_SB.PCI0.PAM6, 0x03, Local0)
                If (Local0)
                {
                    Store (0x4000, ME8L)
                    If (And (Local0, 0x02))
                    {
                        Store (0x01, ME8W)
                    }
                }

                And (\_SB.PCI0.PAM6, 0x30, Local0)
                If (Local0)
                {
                    Store (0x4000, MECL)
                    If (And (Local0, 0x20))
                    {
                        Store (0x01, MECW)
                    }
                }

                Subtract (\MEMX, MEB1, MEL1)
                Return (MEMS)
            }
        }

        Device (LID)
        {
            Name (_HID, EisaId ("PNP0C0D"))
            Method (_LID, 0, NotSerialized)
            {
                If (\H8DR)
                {
                    Return (\_SB.PCI0.LPC.EC.HPLD)
                }
                Else
                {
                    If (And (\RBEC (0x36), 0x04))
                    {
                        Return (0x01)
                    }
                    Else
                    {
                        Return (0x00)
                    }
                }
            }

            Method (_PRW, 0, NotSerialized)
            {
                If (LAnd (\W98F, LNot (\WMEF)))
                {
                    Return (Package (0x02)
                    {
                        0x03, 
                        0x04
                    })
                }
                Else
                {
                    Return (Package (0x02)
                    {
                        0x03, 
                        0x03
                    })
                }
            }

            Method (_PSW, 1, NotSerialized)
            {
                If (\H8DR)
                {
                    If (Arg0)
                    {
                        Store (0x01, \_SB.PCI0.LPC.EC.HWLO)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI0.LPC.EC.HWLO)
                    }
                }
                Else
                {
                    If (Arg0)
                    {
                        \MBEC (0x32, 0xFF, 0x04)
                    }
                    Else
                    {
                        \MBEC (0x32, 0xFB, 0x00)
                    }
                }
            }
        }

        Device (SLPB)
        {
            Name (_HID, EisaId ("PNP0C0E"))
            Method (_PRW, 0, NotSerialized)
            {
                If (LAnd (\W98F, LNot (\WMEF)))
                {
                    Return (Package (0x02)
                    {
                        0x03, 
                        0x04
                    })
                }
                Else
                {
                    Return (Package (0x02)
                    {
                        0x03, 
                        0x03
                    })
                }
            }

            Method (_PSW, 1, NotSerialized)
            {
                If (\H8DR)
                {
                    If (Arg0)
                    {
                        Store (0x01, \_SB.PCI0.LPC.EC.HWFN)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI0.LPC.EC.HWFN)
                    }
                }
                Else
                {
                    If (Arg0)
                    {
                        \MBEC (0x32, 0xFF, 0x10)
                    }
                    Else
                    {
                        \MBEC (0x32, 0xEF, 0x00)
                    }
                }
            }
        }

        Device (PCI0)
        {
            Device (LPC)
            {
                Name (_ADR, 0x00070000)
                Name (_S3D, 0x03)
                Device (SIO)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x00)
                    Name (MBRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x00B0, 0x00B0, 0x01, 0x04)
                        IO (Decode16, 0x0092, 0x0092, 0x01, 0x01)
                        IO (Decode16, 0x040B, 0x040B, 0x01, 0x01)
                        IO (Decode16, 0x0480, 0x0480, 0x01, 0x10)
                        IO (Decode16, 0x04D0, 0x04D0, 0x01, 0x02)
                        IO (Decode16, 0x04D6, 0x04D6, 0x01, 0x01)
                        IO (Decode16, 0xFE10, 0xFE10, 0x01, 0x02)
                        IO (Decode16, 0x0072, 0x0072, 0x01, 0x06)
                        IO (Decode16, 0x0370, 0x0370, 0x01, 0x02)
                        IO (Decode16, 0x8000, 0x8000, 0x01, 0x80)
                        IO (Decode16, 0x1600, 0x1600, 0x01, 0x80)
                        Memory32Fixed (ReadWrite, 0x00000000, 0x00000000)
                    })
                    CreateDWordField (MBRS, 0x5C, BARX)
                    CreateDWordField (MBRS, 0x60, GALN)
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (\WNTF)
                        {
                            Store (0x1000, GALN)
                            Store (\_SB.PCI0.BAR1, Local0)
                            And (Local0, 0xFFFFFFF0, BARX)
                        }

                        Return (MBRS)
                    }
                }

                OperationRegion (LPCS, PCI_Config, 0x00, 0x0100)
                Field (LPCS, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x48), 
                    PIRA,   4, 
                    PIRB,   4, 
                    PIRC,   4, 
                    PIRD,   4, 
                    PIRE,   4, 
                    PIRF,   4, 
                    PIRG,   4, 
                    PIRH,   4, 
                    Offset (0x70), 
                    SERQ,   8, 
                    Offset (0x74), 
                    PIRI,   4, 
                    Offset (0x75), 
                    Offset (0xB4), 
                    XURA,   8, 
                        ,   14, 
                    XFA,    2, 
                    XPA,    3, 
                        ,   4, 
                    Offset (0xD0), 
                    XG3E,   1, 
                    IOM3,   1, 
                        ,   5, 
                    XG3A,   17, 
                    Offset (0xD4), 
                    XG4E,   1, 
                    IOM4,   1, 
                        ,   5, 
                    XG34,   17
                }

                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0020, 0x0020, 0x01, 0x02)
                        IO (Decode16, 0x00A0, 0x00A0, 0x01, 0x02)
                        IO (Decode16, 0x04D0, 0x04D0, 0x01, 0x02)
                        IRQNoFlags () {2}
                    })
                }

                Device (TIMR)
                {
                    Name (_HID, EisaId ("PNP0100"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0040, 0x0040, 0x01, 0x04)
                        IRQNoFlags () {0}
                    })
                }

                Device (DMAC)
                {
                    Name (_HID, EisaId ("PNP0200"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0000, 0x0000, 0x01, 0x10)
                        IO (Decode16, 0x0080, 0x0080, 0x01, 0x10)
                        IO (Decode16, 0x00C0, 0x00C0, 0x01, 0x20)
                        DMA (Compatibility, BusMaster, Transfer8_16) {4}
                    })
                }

                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0061, 0x0061, 0x01, 0x01)
                    })
                }

                Device (FPU)
                {
                    Name (_HID, EisaId ("PNP0C04"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x00F0, 0x00F0, 0x01, 0x01)
                        IRQNoFlags () {13}
                    })
                }

                Device (RTC)
                {
                    Name (_HID, EisaId ("PNP0B00"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0070, 0x0070, 0x01, 0x02)
                        IRQNoFlags () {8}
                    })
                }

                Device (KBD)
                {
                    Name (_HID, EisaId ("PNP0303"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0060, 0x0060, 0x01, 0x01)
                        IO (Decode16, 0x0064, 0x0064, 0x01, 0x01)
                        IRQNoFlags () {1}
                    })
                }

                Device (MOU)
                {
                    Name (_HID, EisaId ("IBM3780"))
                    Name (_CID, 0x130FD041)
                    Name (_CRS, ResourceTemplate ()
                    {
                        IRQNoFlags () {12}
                    })
                }

                OperationRegion (NCFG, SystemIO, 0x0370, 0x02)
                Field (NCFG, ByteAcc, NoLock, Preserve)
                {
                    INDX,   8, 
                    DATA,   8
                }

                IndexField (INDX, DATA, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x07), 
                    LDN,    8, 
                    Offset (0x20), 
                    Offset (0x21), 
                    Offset (0x22), 
                    DFPD,   1, 
                        ,   2, 
                    DPPD,   1, 
                    DU1D,   1, 
                    DU2D,   1, 
                    DU3D,   1, 
                    Offset (0x23), 
                        ,   3, 
                    APPD,   1, 
                    AU1D,   1, 
                    AU2D,   1, 
                    AU3D,   1, 
                    Offset (0x24), 
                    Offset (0x30), 
                    LDA,    1, 
                    Offset (0x31), 
                    Offset (0x60), 
                    IOHI,   8, 
                    IOLW,   8, 
                    Offset (0x70), 
                    IRQN,   4, 
                    Offset (0x71), 
                    Offset (0x74), 
                    DMA0,   3, 
                    Offset (0x75)
                }

                IndexField (INDX, DATA, ByteAcc, NoLock, Preserve)
                {
                    Offset (0xF0), 
                    PMDS,   3, 
                    Offset (0xF1)
                }

                Method (ECFG, 0, NotSerialized)
                {
                    Store (0x51, INDX)
                    Store (0x23, INDX)
                }

                Method (XCFG, 0, NotSerialized)
                {
                    Store (0xBB, INDX)
                }

                Device (UART)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0xFF)
                    Method (_STA, 0, NotSerialized)
                    {
                        If (LCMA)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x00)
                        }
                    }

                    Name (U1BF, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0000, 0x0000, 0x01, 0x08)
                    })
                    CreateWordField (U1BF, 0x02, U1MN)
                    CreateWordField (U1BF, 0x04, U1MX)
                    Method (_CRS, 0, NotSerialized)
                    {
                        ECFG ()
                        Store (0x04, LDN)
                        Or (ShiftLeft (IOHI, 0x08), IOLW, Local0)
                        Store (Local0, U1MN)
                        Store (Local0, U1MX)
                        XCFG ()
                        Return (U1BF)
                    }
                }

                Device (LPT)
                {
                    Name (_HID, EisaId ("PNP0400"))
                    Method (_STA, 0, NotSerialized)
                    {
                        If (LNot (LEqual (\PMOD, 0x03)))
                        {
                            If (LLPT)
                            {
                                Return (0x0F)
                            }
                            Else
                            {
                                Return (0x0D)
                            }
                        }
                        Else
                        {
                            Return (0x00)
                        }
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        Store (0x00, XPA)
                        ECFG ()
                        Store (0x03, LDN)
                        Store (0x00, IRQN)
                        Store (0x00, LDA)
                        XCFG ()
                    }

                    Name (PPBF, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0000, 0x0000, 0x01, 0x00)
                        IRQNoFlags () {}
                    })
                    CreateWordField (PPBF, 0x02, LPN0)
                    CreateWordField (PPBF, 0x04, LPX0)
                    CreateByteField (PPBF, 0x07, LPL0)
                    CreateWordField (PPBF, 0x09, LPIQ)
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (LEqual (\PMOD, 0x03))
                        {
                            Return (PPBF)
                        }

                        ECFG ()
                        Store (0x03, LDN)
                        Or (ShiftLeft (IOHI, 0x08), IOLW, Local0)
                        Store (Local0, LPN0)
                        Store (Local0, LPX0)
                        If (LEqual (Local0, 0x03BC))
                        {
                            Store (0x03, LPL0)
                        }
                        Else
                        {
                            Store (0x08, LPL0)
                        }

                        Store (IRQN, Local0)
                        If (Local0)
                        {
                            ShiftLeft (0x01, IRQN, LPIQ)
                        }
                        Else
                        {
                            Store (0x00, LPIQ)
                        }

                        XCFG ()
                        Return (PPBF)
                    }

                    Method (_PRS, 0, NotSerialized)
                    {
                        If (\PMOD)
                        {
                            Return (PEPP)
                        }
                        Else
                        {
                            Return (PLPT)
                        }
                    }

                    Name (PLPT, ResourceTemplate ()
                    {
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x03BC, 0x03BC, 0x01, 0x03)
                            IRQNoFlags () {7}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0378, 0x0378, 0x01, 0x08)
                            IRQNoFlags () {7}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0278, 0x0278, 0x01, 0x08)
                            IRQNoFlags () {5}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x03BC, 0x03BC, 0x01, 0x03)
                            IRQNoFlags () {5}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0378, 0x0378, 0x01, 0x08)
                            IRQNoFlags () {5}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0278, 0x0278, 0x01, 0x08)
                            IRQNoFlags () {7}
                        }
                        EndDependentFn ()
                    })
                    Name (PEPP, ResourceTemplate ()
                    {
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0378, 0x0378, 0x01, 0x08)
                            IRQNoFlags () {7}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0278, 0x0278, 0x01, 0x08)
                            IRQNoFlags () {5}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0378, 0x0378, 0x01, 0x08)
                            IRQNoFlags () {5}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0278, 0x0278, 0x01, 0x08)
                            IRQNoFlags () {7}
                        }
                        EndDependentFn ()
                    })
                    Method (_SRS, 1, NotSerialized)
                    {
                        CreateByteField (Arg0, 0x02, RLIL)
                        CreateByteField (Arg0, 0x03, RLIH)
                        CreateWordField (Arg0, 0x02, RLIO)
                        CreateWordField (Arg0, 0x09, RLIQ)
                        ECFG ()
                        Store (0x03, LDN)
                        Store (0x00, LDA)
                        Store (RLIL, IOLW)
                        Store (RLIH, IOHI)
                        If (RLIQ)
                        {
                            FindSetRightBit (RLIQ, Local0)
                            Store (Decrement (Local0), IRQN)
                        }
                        Else
                        {
                            Store (0x00, IRQN)
                        }

                        If (LEqual (\PMOD, 0x00))
                        {
                            If (\PDIR)
                            {
                                Store (0x01, PMDS)
                            }
                            Else
                            {
                                Store (0x00, PMDS)
                            }
                        }
                        Else
                        {
                            If (LEqual (\PMOD, 0x01))
                            {
                                Store (0x02, PMDS)
                            }
                            Else
                            {
                                Store (0x03, PMDS)
                            }
                        }

                        Store (0x01, LDA)
                        XCFG ()
                        If (LEqual (RLIO, 0x0378))
                        {
                            Store (0x00, XPA)
                        }
                        Else
                        {
                            If (LEqual (RLIO, 0x0278))
                            {
                                Store (0x01, XPA)
                            }
                            Else
                            {
                                If (LEqual (RLIO, 0x03BC))
                                {
                                    Store (0x02, XPA)
                                }
                                Else
                                {
                                    Fatal (0x02, 0x90020000, 0x01E1)
                                }
                            }
                        }
                    }

                    Method (_PSC, 0, NotSerialized)
                    {
                        ECFG ()
                        Store (0x03, LDN)
                        If (LDA)
                        {
                            XCFG ()
                            Return (0x00)
                        }
                        Else
                        {
                            XCFG ()
                            Return (0x03)
                        }
                    }

                    Method (_PS0, 0, NotSerialized)
                    {
                        ECFG ()
                        Store (0x03, LDN)
                        Store (0x01, LDA)
                        XCFG ()
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                        ECFG ()
                        Store (0x03, LDN)
                        Store (0x00, LDA)
                        XCFG ()
                    }
                }

                Device (ECP)
                {
                    Name (_HID, EisaId ("PNP0401"))
                    Method (_STA, 0, NotSerialized)
                    {
                        If (LEqual (\PMOD, 0x03))
                        {
                            If (LLPT)
                            {
                                Return (0x0F)
                            }
                            Else
                            {
                                Return (0x0D)
                            }
                        }
                        Else
                        {
                            Return (0x00)
                        }
                    }

                    Method (_DIS, 0, NotSerialized)
                    {
                        Store (0x00, XPA)
                        ECFG ()
                        Store (0x03, LDN)
                        Store (0x00, IRQN)
                        Store (0x00, LDA)
                        XCFG ()
                    }

                    Name (EPBF, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0000, 0x0000, 0x01, 0x00)
                        IO (Decode16, 0x0000, 0x0000, 0x01, 0x00)
                        IRQNoFlags () {}
                        DMA (Compatibility, NotBusMaster, Transfer8) {}
                    })
                    CreateWordField (EPBF, 0x02, ECN0)
                    CreateWordField (EPBF, 0x04, ECX0)
                    CreateByteField (EPBF, 0x07, ECL0)
                    CreateWordField (EPBF, 0x0A, ECN1)
                    CreateWordField (EPBF, 0x0C, ECX1)
                    CreateByteField (EPBF, 0x0F, ECL1)
                    CreateWordField (EPBF, 0x11, ECIQ)
                    CreateWordField (EPBF, 0x14, ECDQ)
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (LNot (LEqual (\PMOD, 0x03)))
                        {
                            Return (EPBF)
                        }

                        ECFG ()
                        Store (0x03, LDN)
                        Or (ShiftLeft (IOHI, 0x08), IOLW, Local0)
                        Store (Local0, ECN0)
                        Store (Local0, ECX0)
                        Add (Local0, 0x0400, ECN1)
                        Add (Local0, 0x0400, ECX1)
                        If (LEqual (Local0, 0x03BC))
                        {
                            Store (0x03, ECL0)
                            Store (0x03, ECL1)
                        }
                        Else
                        {
                            Store (0x08, ECL0)
                            Store (0x08, ECL1)
                        }

                        Store (IRQN, Local0)
                        If (Local0)
                        {
                            ShiftLeft (0x01, IRQN, ECIQ)
                        }
                        Else
                        {
                            Store (0x00, ECIQ)
                        }

                        Store (DMA0, Local0)
                        If (LLess (Local0, 0x04))
                        {
                            ShiftLeft (0x01, Local0, ECDQ)
                        }
                        Else
                        {
                            Store (0x00, ECDQ)
                        }

                        XCFG ()
                        Return (EPBF)
                    }

                    Name (_PRS, ResourceTemplate ()
                    {
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0378, 0x0378, 0x01, 0x08)
                            IO (Decode16, 0x0778, 0x0778, 0x01, 0x08)
                            IRQNoFlags () {7}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0278, 0x0278, 0x01, 0x08)
                            IO (Decode16, 0x0678, 0x0678, 0x01, 0x08)
                            IRQNoFlags () {5}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x03BC, 0x03BC, 0x01, 0x03)
                            IO (Decode16, 0x07BC, 0x07BC, 0x01, 0x03)
                            IRQNoFlags () {7}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0378, 0x0378, 0x01, 0x08)
                            IO (Decode16, 0x0778, 0x0778, 0x01, 0x08)
                            IRQNoFlags () {5}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x0278, 0x0278, 0x01, 0x08)
                            IO (Decode16, 0x0678, 0x0678, 0x01, 0x08)
                            IRQNoFlags () {7}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16, 0x03BC, 0x03BC, 0x01, 0x03)
                            IO (Decode16, 0x07BC, 0x07BC, 0x01, 0x03)
                            IRQNoFlags () {5}
                            DMA (Compatibility, NotBusMaster, Transfer8) {0,1,3}
                        }
                        EndDependentFn ()
                    })
                    Method (_SRS, 1, NotSerialized)
                    {
                        CreateByteField (Arg0, 0x02, RLIL)
                        CreateByteField (Arg0, 0x03, RLIH)
                        CreateWordField (Arg0, 0x02, RLIO)
                        CreateWordField (Arg0, 0x11, RLIQ)
                        CreateByteField (Arg0, 0x14, RLDQ)
                        ECFG ()
                        Store (0x03, LDN)
                        Store (0x00, LDA)
                        Store (0x07, PMDS)
                        Store (RLIL, IOLW)
                        Store (RLIH, IOHI)
                        If (RLIQ)
                        {
                            FindSetRightBit (RLIQ, Local0)
                            Store (Decrement (Local0), IRQN)
                        }
                        Else
                        {
                            Store (0x00, IRQN)
                        }

                        If (And (RLDQ, 0x0F))
                        {
                            FindSetRightBit (RLDQ, Local0)
                            Store (Decrement (Local0), DMA0)
                        }
                        Else
                        {
                            Store (0x04, DMA0)
                        }

                        Store (0x01, LDA)
                        XCFG ()
                        If (LEqual (RLIO, 0x0378))
                        {
                            Store (0x00, XPA)
                        }
                        Else
                        {
                            If (LEqual (RLIO, 0x0278))
                            {
                                Store (0x01, XPA)
                            }
                            Else
                            {
                                If (LEqual (RLIO, 0x03BC))
                                {
                                    Store (0x02, XPA)
                                }
                                Else
                                {
                                    Fatal (0x02, 0x90020000, 0x03CE)
                                }
                            }
                        }
                    }

                    Method (_PSC, 0, NotSerialized)
                    {
                        ECFG ()
                        Store (0x03, LDN)
                        If (LDA)
                        {
                            XCFG ()
                            Return (0x00)
                        }
                        Else
                        {
                            XCFG ()
                            Return (0x03)
                        }
                    }

                    Method (_PS0, 0, NotSerialized)
                    {
                        ECFG ()
                        Store (0x03, LDN)
                        Store (0x01, LDA)
                        XCFG ()
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                        ECFG ()
                        Store (0x03, LDN)
                        Store (0x00, LDA)
                        XCFG ()
                    }
                }

                Device (EC)
                {
                    Name (_HID, EisaId ("PNP0C09"))
                    Name (_UID, 0x00)
                    Name (_GPE, 0x02)
                    Method (_REG, 2, NotSerialized)
                    {
                        If (LEqual (Arg0, 0x03))
                        {
                            Store (Arg1, \H8DR)
                        }
                    }

                    OperationRegion (ECOR, EmbeddedControl, 0x00, 0x0100)
                    Field (ECOR, ByteAcc, NoLock, Preserve)
                    {
                        HDBM,   1, 
                            ,   1, 
                            ,   1, 
                        HFNE,   1, 
                            ,   1, 
                            ,   1, 
                        HLDM,   1, 
                        Offset (0x01), 
                            ,   1, 
                        BTCM,   1, 
                            ,   1, 
                            ,   1, 
                            ,   1, 
                        HBPR,   1, 
                        BTPC,   1, 
                        Offset (0x02), 
                        HDUE,   1, 
                        Offset (0x05), 
                        HSPA,   1, 
                        Offset (0x06), 
                        HSUN,   8, 
                        HSRP,   8, 
                        Offset (0x0C), 
                        HLCL,   8, 
                        Offset (0x0E), 
                        HFNS,   2, 
                        Offset (0x10), 
                        HAM0,   8, 
                        HAM1,   8, 
                        HAM2,   8, 
                        HAM3,   8, 
                        HAM4,   8, 
                        HAM5,   8, 
                        HAM6,   8, 
                        HAM7,   8, 
                        HAM8,   8, 
                        HAM9,   8, 
                        HAMA,   8, 
                        HAMB,   8, 
                        HAMC,   8, 
                        HAMD,   8, 
                        HAME,   8, 
                        HAMF,   8, 
                        HT00,   1, 
                        HT01,   1, 
                        HT02,   1, 
                            ,   1, 
                        HT10,   1, 
                        HT11,   1, 
                        HT12,   1, 
                        Offset (0x2A), 
                        HATR,   8, 
                        HT0H,   8, 
                        HT0L,   8, 
                        HT1H,   8, 
                        HT1L,   8, 
                        HFSP,   8, 
                            ,   6, 
                        HMUT,   1, 
                        Offset (0x32), 
                        HWPM,   1, 
                        HWLB,   1, 
                        HWLO,   1, 
                        HWDK,   1, 
                        HWFN,   1, 
                        HWBT,   1, 
                        HWRI,   1, 
                        HWBU,   1, 
                        HWLU,   1, 
                        Offset (0x34), 
                            ,   7, 
                        HPLO,   1, 
                        Offset (0x36), 
                        Offset (0x38), 
                        HB0S,   7, 
                        HB0A,   1, 
                        HB1S,   7, 
                        HB1A,   1, 
                        HCMU,   1, 
                        EDCP,   1, 
                            ,   1, 
                        COMP,   1, 
                        BTDS,   1, 
                        BDTC,   1, 
                        CBPW,   1, 
                        HB1I,   1, 
                            ,   1, 
                        KBLT,   1, 
                        BTPW,   1, 
                        BTDT,   1, 
                        HUBS,   1, 
                        BDPW,   1, 
                        BDDT,   1, 
                        HUBB,   1, 
                        Offset (0x46), 
                            ,   1, 
                        BTWK,   1, 
                        HPLD,   1, 
                            ,   1, 
                        HPAC,   1, 
                        BTST,   1, 
                        Offset (0x47), 
                        HPBU,   1, 
                            ,   1, 
                        HBID,   4, 
                        HBCS,   1, 
                        HPNF,   1, 
                        HLID,   4, 
                        HLBU,   1, 
                        BDST,   1, 
                        BDWK,   1, 
                        Offset (0x4E), 
                        HWAK,   16, 
                        Offset (0x78), 
                        TMP0,   8, 
                        TMP1,   8, 
                        TMP2,   8, 
                        TMP3,   8, 
                        TMP4,   8, 
                        TMP5,   8, 
                        TMP6,   8, 
                        TMP7,   8, 
                        Offset (0x81), 
                        HIID,   8, 
                        Offset (0x83), 
                        HFNI,   8, 
                        Offset (0x88), 
                        HDEC,   8, 
                        HDEO,   8, 
                        Offset (0x90), 
                        SSTA,   3, 
                            ,   2, 
                        Offset (0x91), 
                        Offset (0xB0), 
                        HDEN,   32, 
                        HDEP,   32, 
                        HDEM,   8, 
                        HDES,   8
                    }

                    Method (_INI, 0, NotSerialized)
                    {
                        If (\H8DR)
                        {
                            Store (0x00, HSPA)
                        }
                        Else
                        {
                            \MBEC (0x05, 0xFE, 0x00)
                        }
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16, 0x0062, 0x0062, 0x01, 0x01)
                        IO (Decode16, 0x0066, 0x0066, 0x01, 0x01)
                    })
                    Method (LED, 2, NotSerialized)
                    {
                        Or (Arg0, Arg1, Local0)
                        If (\H8DR)
                        {
                            Store (Local0, HLCL)
                        }
                        Else
                        {
                            \WBEC (0x0C, Local0)
                        }
                    }

                    Name (BAON, 0x00)
                    Name (WBON, 0x00)
                    Method (BEEP, 1, NotSerialized)
                    {
                        If (LEqual (Arg0, 0x05))
                        {
                            Store (0x00, WBON)
                        }

                        Store (WBON, Local2)
                        If (BAON)
                        {
                            If (LEqual (Arg0, 0x00))
                            {
                                Store (0x00, BAON)
                                If (WBON)
                                {
                                    Store (0x03, Local0)
                                    Store (0x08, Local1)
                                }
                                Else
                                {
                                    Store (0x00, Local0)
                                    Store (0x00, Local1)
                                }
                            }
                            Else
                            {
                                Store (0xFF, Local0)
                                Store (0xFF, Local1)
                                If (LEqual (Arg0, 0x11))
                                {
                                    Store (0x00, WBON)
                                }

                                If (LEqual (Arg0, 0x10))
                                {
                                    Store (0x01, WBON)
                                }
                            }
                        }
                        Else
                        {
                            Store (Arg0, Local0)
                            Store (0xFF, Local1)
                            If (LEqual (Arg0, 0x0F))
                            {
                                Store (Arg0, Local0)
                                Store (0x08, Local1)
                                Store (0x01, BAON)
                            }

                            If (LEqual (Arg0, 0x11))
                            {
                                Store (0x00, Local0)
                                Store (0x00, Local1)
                                Store (0x00, WBON)
                            }

                            If (LEqual (Arg0, 0x10))
                            {
                                Store (0x03, Local0)
                                Store (0x08, Local1)
                                Store (0x01, WBON)
                            }
                        }

                        If (LEqual (Arg0, 0x03))
                        {
                            Store (0x00, WBON)
                            If (Local2)
                            {
                                Store (0x07, Local0)
                                If (LEqual (\SPS, 0x04))
                                {
                                    Store (0x00, Local2)
                                    Store (0xFF, Local0)
                                    Store (0xFF, Local1)
                                }
                            }
                        }

                        If (LEqual (Arg0, 0x07))
                        {
                            If (Local2)
                            {
                                Store (0x00, Local2)
                                Store (0xFF, Local0)
                                Store (0xFF, Local1)
                            }
                        }

                        If (LAnd (\H8DR, LNot (\W98F)))
                        {
                            If (LAnd (Local2, LNot (WBON)))
                            {
                                Store (0x00, HSRP)
                                Store (0x00, HSUN)
                                Sleep (0x64)
                            }

                            If (LNot (LEqual (Local1, 0xFF)))
                            {
                                Store (Local1, HSRP)
                            }

                            If (LNot (LEqual (Local0, 0xFF)))
                            {
                                Store (Local0, HSUN)
                            }
                        }
                        Else
                        {
                            If (LAnd (Local2, LNot (WBON)))
                            {
                                \WBEC (0x07, 0x00)
                                \WBEC (0x06, 0x00)
                                Sleep (0x64)
                            }

                            If (LNot (LEqual (Local1, 0xFF)))
                            {
                                \WBEC (0x07, Local1)
                            }

                            If (LNot (LEqual (Local0, 0xFF)))
                            {
                                \WBEC (0x06, Local0)
                            }
                        }

                        If (LEqual (Arg0, 0x03))
                        {
                            Sleep (0x96)
                        }

                        If (LEqual (Arg0, 0x07))
                        {
                            Sleep (0x01F4)
                        }
                    }

                    Method (EVNT, 1, NotSerialized)
                    {
                        If (\H8DR)
                        {
                            If (Arg0)
                            {
                                Or (HAM5, 0x04, HAM5)
                            }
                            Else
                            {
                                And (HAM5, 0xFB, HAM5)
                            }
                        }
                        Else
                        {
                            If (Arg0)
                            {
                                \MBEC (0x15, 0xFF, 0x04)
                                If (\W98F)
                                {
                                    \WBEC (0x18, 0xFF)
                                }
                            }
                            Else
                            {
                                \MBEC (0x15, 0xFB, 0x00)
                                If (\W98F)
                                {
                                    \WBEC (0x18, 0x00)
                                }
                            }
                        }
                    }

                    PowerResource (PUBS, 0x03, 0x0000)
                    {
                        Method (_STA, 0, NotSerialized)
                        {
                            If (\H8DR)
                            {
                                Store (HUBS, Local0)
                            }
                            Else
                            {
                                And (\RBEC (0x3B), 0x10, Local0)
                            }

                            If (Local0)
                            {
                                Return (0x01)
                            }
                            Else
                            {
                                Return (0x00)
                            }
                        }

                        Method (_ON, 0, NotSerialized)
                        {
                            If (\H8DR)
                            {
                                Store (0x01, HUBS)
                            }
                            Else
                            {
                                \MBEC (0x3B, 0xFF, 0x10)
                            }
                        }

                        Method (_OFF, 0, NotSerialized)
                        {
                            If (\H8DR)
                            {
                                Store (0x00, HUBS)
                            }
                            Else
                            {
                                \MBEC (0x3B, 0xEF, 0x00)
                            }
                        }
                    }

                    Mutex (MCPU, 0x07)
                    Method (_Q12, 0, NotSerialized)
                    {
                        \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x1003)
                    }

                    Method (_Q13, 0, NotSerialized)
                    {
                        If (\_SB.PCI0.LPC.EC.HKEY.DHKC)
                        {
                            \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x1004)
                        }
                        Else
                        {
                            Notify (\_SB.SLPB, 0x80)
                        }
                    }

                    Method (_Q64, 0, NotSerialized)
                    {
                        If (\_SB.PCI0.LPC.EC.HKEY.MHKK (0x10))
                        {
                            \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x1005)
                        }

                        Noop
                    }

                    Method (_Q16, 0, NotSerialized)
                    {
                        If (\_SB.PCI0.LPC.EC.HKEY.MHKK (0x40))
                        {
                            \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x1007)
                        }
                        Else
                        {
                            \_SB.PCI0.AGP.VID.VSWT ()
                        }
                    }

                    Method (_Q17, 0, NotSerialized)
                    {
                        If (\_SB.PCI0.LPC.EC.HKEY.MHKK (0x80))
                        {
                            \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x1008)
                        }
                        Else
                        {
                            If (LNot (\WNTF))
                            {
                                VEXP ()
                            }
                        }
                    }

                    Method (_Q18, 0, NotSerialized)
                    {
                        If (\_SB.PCI0.LPC.EC.HKEY.MHKK (0x0100))
                        {
                            \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x1009)
                        }

                        Noop
                    }

                    Method (_Q1B, 0, NotSerialized)
                    {
                        \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x100C)
                    }

                    Method (_Q1F, 0, NotSerialized)
                    {
                        \CMS (0x0E)
                    }

                    Method (_Q26, 0, NotSerialized)
                    {
                        Sleep (0x01F4)
                        Notify (AC, 0x80)
                        Notify (\_TZ.THM0, 0x80)
                        If (LEqual (\WNTF, 0x02))
                        {
                            Acquire (MCPU, 0xFFFF)
                        }

                        If (\SPEN)
                        {
                            If (\OSPX)
                            {
                                Notify (\_PR.CPU, 0x80)
                            }
                            Else
                            {
                                \STEP (0x00)
                            }
                        }

                        If (LEqual (\WNTF, 0x02))
                        {
                            Sleep (0x64)
                        }

                        If (\OSC4)
                        {
                            Notify (\_PR.CPU, 0x81)
                        }

                        If (LEqual (\WNTF, 0x02))
                        {
                            Release (MCPU)
                        }
                    }

                    Method (_Q27, 0, NotSerialized)
                    {
                        Sleep (0x01F4)
                        Notify (AC, 0x80)
                        Notify (\_TZ.THM0, 0x80)
                        If (LEqual (\WNTF, 0x02))
                        {
                            Acquire (MCPU, 0xFFFF)
                        }

                        If (\SPEN)
                        {
                            If (\OSPX)
                            {
                                Notify (\_PR.CPU, 0x80)
                            }
                            Else
                            {
                                \STEP (0x01)
                            }
                        }

                        If (LEqual (\WNTF, 0x02))
                        {
                            Sleep (0x64)
                        }

                        If (\OSC4)
                        {
                            Notify (\_PR.CPU, 0x81)
                        }

                        If (LEqual (\WNTF, 0x02))
                        {
                            Release (MCPU)
                        }
                    }

                    Method (_Q2A, 0, NotSerialized)
                    {
                        \_SB.PCI0.AGP.VID.VLOC (0x01)
                        \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x5002)
                        Notify (\_SB.LID, 0x80)
                    }

                    Method (_Q2B, 0, NotSerialized)
                    {
                        \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x5001)
                        Notify (\_SB.LID, 0x80)
                    }

                    Method (_Q3D, 0, NotSerialized)
                    {
                    }

                    Method (_Q48, 0, NotSerialized)
                    {
                        If (\SPEN)
                        {
                            If (\OSPX)
                            {
                                Notify (\_PR.CPU, 0x80)
                            }
                            Else
                            {
                                \STEP (0x04)
                            }
                        }
                    }

                    Method (_Q49, 0, NotSerialized)
                    {
                        If (\SPEN)
                        {
                            If (\OSPX)
                            {
                                Notify (\_PR.CPU, 0x80)
                            }
                            Else
                            {
                                \STEP (0x05)
                            }
                        }
                    }

                    Method (_Q7F, 0, NotSerialized)
                    {
                        Fatal (0x01, 0x80010000, 0x01A6)
                    }

                    Method (_Q4E, 0, NotSerialized)
                    {
                        \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x6011)
                    }

                    Method (_Q4F, 0, NotSerialized)
                    {
                        \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x6012)
                    }

                    Method (_Q22, 0, NotSerialized)
                    {
                        If (HB0A)
                        {
                            Notify (BAT0, 0x80)
                        }
                    }

                    Method (_Q4A, 0, NotSerialized)
                    {
                        Notify (BAT0, 0x81)
                    }

                    Method (_Q4B, 0, NotSerialized)
                    {
                        Notify (BAT0, 0x80)
                    }

                    Method (_Q24, 0, NotSerialized)
                    {
                        Notify (BAT0, 0x80)
                    }

                    Field (ECOR, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0xA0), 
                        SBRC,   16, 
                        SBFC,   16, 
                        SBAE,   16, 
                        SBRS,   16, 
                        SBAC,   16, 
                        SBVO,   16, 
                        SBAF,   16, 
                        SBBS,   16
                    }

                    Field (ECOR, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0xA0), 
                            ,   15, 
                        SBCM,   1, 
                        SBMD,   16, 
                        SBCC,   16
                    }

                    Field (ECOR, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0xA0), 
                        SBDC,   16, 
                        SBDV,   16, 
                        SBOM,   16, 
                        SBSI,   16, 
                        SBDT,   16, 
                        SBSN,   16
                    }

                    Field (ECOR, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0xA0), 
                        SBCH,   32
                    }

                    Field (ECOR, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0xA0), 
                        SBMN,   128
                    }

                    Field (ECOR, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0xA0), 
                        SBDN,   128
                    }

                    Mutex (BATM, 0x07)
                    Method (GBIF, 3, NotSerialized)
                    {
                        Acquire (BATM, 0xFFFF)
                        If (Arg2)
                        {
                            Or (Arg0, 0x01, HIID)
                            Store (SBCM, Local7)
                            XOr (Local7, 0x01, Index (Arg1, 0x00))
                            Store (Arg0, HIID)
                            If (Local7)
                            {
                                Multiply (SBFC, 0x0A, Local1)
                            }
                            Else
                            {
                                Store (SBFC, Local1)
                            }

                            Store (Local1, Index (Arg1, 0x02))
                            Or (Arg0, 0x02, HIID)
                            If (Local7)
                            {
                                Multiply (SBDC, 0x0A, Local0)
                            }
                            Else
                            {
                                Store (SBDC, Local0)
                            }

                            Store (Local0, Index (Arg1, 0x01))
                            Divide (Local1, 0x14, Local2, Index (Arg1, 0x05))
                            If (Local7)
                            {
                                Store (0xC8, Index (Arg1, 0x06))
                            }
                            Else
                            {
                                If (SBDV)
                                {
                                    Divide (0x00030D40, SBDV, Local2, Index (Arg1, 0x06))
                                }
                                Else
                                {
                                    Store (0x00, Index (Arg1, 0x06))
                                }
                            }

                            Store (SBDV, Index (Arg1, 0x04))
                            Store (SBSN, Local0)
                            Name (SERN, Buffer (0x06)
                            {
                                "     "
                            })
                            Store (0x04, Local2)
                            While (Local0)
                            {
                                Divide (Local0, 0x0A, Local1, Local0)
                                Add (Local1, 0x30, Index (SERN, Local2))
                                Decrement (Local2)
                            }

                            Store (SERN, Index (Arg1, 0x0A))
                            Or (Arg0, 0x06, HIID)
                            Store (SBDN, Index (Arg1, 0x09))
                            Or (Arg0, 0x04, HIID)
                            Name (BTYP, Buffer (0x05)
                            {
                                0x00, 0x00, 0x00, 0x00, 0x00
                            })
                            Store (SBCH, BTYP)
                            Store (BTYP, Index (Arg1, 0x0B))
                            Or (Arg0, 0x05, HIID)
                            Store (SBMN, Index (Arg1, 0x0C))
                        }
                        Else
                        {
                            Store (0xFFFFFFFF, Index (Arg1, 0x01))
                            Store (0x00, Index (Arg1, 0x05))
                            Store (0x00, Index (Arg1, 0x06))
                            Store (0xFFFFFFFF, Index (Arg1, 0x02))
                        }

                        Release (BATM)
                        Return (Arg1)
                    }

                    Method (GBST, 4, NotSerialized)
                    {
                        Acquire (BATM, 0xFFFF)
                        If (And (Arg1, 0x20))
                        {
                            Store (0x02, Local0)
                        }
                        Else
                        {
                            If (And (Arg1, 0x40))
                            {
                                Store (0x01, Local0)
                            }
                            Else
                            {
                                Store (0x00, Local0)
                            }
                        }

                        If (And (Arg1, 0x0F)) {}
                        Else
                        {
                            Or (Local0, 0x04, Local0)
                        }

                        If (LEqual (And (Arg1, 0x0F), 0x0F))
                        {
                            Store (0x04, Local0)
                            Store (0x00, Local1)
                            Store (0x00, Local2)
                            Store (0x00, Local3)
                        }
                        Else
                        {
                            Store (Arg0, HIID)
                            Store (SBVO, Local3)
                            If (Arg2)
                            {
                                Multiply (SBRC, 0x0A, Local2)
                            }
                            Else
                            {
                                Store (SBRC, Local2)
                            }

                            Store (SBAC, Local1)
                            If (LNot (LLess (Local1, 0x8000)))
                            {
                                If (And (Local0, 0x01))
                                {
                                    Subtract (0x00010000, Local1, Local1)
                                }
                                Else
                                {
                                    Store (0x00, Local1)
                                }
                            }
                            Else
                            {
                                If (LNot (And (Local0, 0x02)))
                                {
                                    Store (0x00, Local1)
                                }
                            }

                            If (Arg2)
                            {
                                Multiply (Local3, Local1, Local1)
                                Divide (Local1, 0x03E8, Local7, Local1)
                            }
                        }

                        Store (Local0, Index (Arg3, 0x00))
                        Store (Local1, Index (Arg3, 0x01))
                        Store (Local2, Index (Arg3, 0x02))
                        Store (Local3, Index (Arg3, 0x03))
                        Release (BATM)
                        Return (Arg3)
                    }

                    Device (BAT0)
                    {
                        Name (_HID, EisaId ("PNP0C0A"))
                        Name (_UID, 0x00)
                        Name (_PCL, Package (0x01)
                        {
                            \_SB
                        })
                        Name (B0ST, 0x00)
                        Name (BT0I, Package (0x0D)
                        {
                            0x00, 
                            0xFFFFFFFF, 
                            0xFFFFFFFF, 
                            0x01, 
                            0x2A30, 
                            0x00, 
                            0x00, 
                            0x01, 
                            0x01, 
                            "", 
                            "", 
                            "", 
                            ""
                        })
                        Name (BT0P, Package (0x04) {})
                        Method (_STA, 0, NotSerialized)
                        {
                            If (\H8DR)
                            {
                                Store (HB0A, B0ST)
                            }
                            Else
                            {
                                If (And (\RBEC (0x38), 0x80))
                                {
                                    Store (0x01, B0ST)
                                }
                                Else
                                {
                                    Store (0x00, B0ST)
                                }
                            }

                            If (B0ST)
                            {
                                Return (0x1F)
                            }
                            Else
                            {
                                Return (0x0F)
                            }
                        }

                        Method (_BIF, 0, NotSerialized)
                        {
                            Store (0x00, Local7)
                            Store (0x0A, Local6)
                            While (LAnd (LNot (Local7), Local6))
                            {
                                If (HB0A)
                                {
                                    If (LEqual (And (HB0S, 0x0F), 0x0F))
                                    {
                                        Sleep (0x03E8)
                                        Decrement (Local6)
                                    }
                                    Else
                                    {
                                        Store (0x01, Local7)
                                    }
                                }
                                Else
                                {
                                    Store (0x00, Local6)
                                }
                            }

                            Return (GBIF (0x00, BT0I, Local7))
                        }

                        Method (_BST, 0, NotSerialized)
                        {
                            XOr (DerefOf (Index (BT0I, 0x00)), 0x01, Local0)
                            Return (GBST (0x00, HB0S, Local0, BT0P))
                        }

                        Method (_BTP, 1, NotSerialized)
                        {
                            And (HAM4, 0xEF, HAM4)
                            If (Arg0)
                            {
                                Store (Arg0, Local1)
                                If (LNot (DerefOf (Index (BT0I, 0x00))))
                                {
                                    Divide (Local1, 0x0A, Local0, Local1)
                                }

                                And (Local1, 0xFF, HT0L)
                                And (ShiftRight (Local1, 0x08), 0xFF, HT0H)
                                Or (HAM4, 0x10, HAM4)
                            }
                        }
                    }

                    Device (AC)
                    {
                        Name (_HID, "ACPI0003")
                        Name (_UID, 0x00)
                        Name (_PCL, Package (0x01)
                        {
                            \_SB
                        })
                        Method (_PSR, 0, NotSerialized)
                        {
                            Return (HPAC)
                        }

                        Method (_STA, 0, NotSerialized)
                        {
                            Return (0x0F)
                        }
                    }

                    Device (HKEY)
                    {
                        Name (_HID, EisaId ("IBM0068"))
                        Method (_STA, 0, NotSerialized)
                        {
                            Return (0x0F)
                        }

                        Method (MHKV, 0, NotSerialized)
                        {
                            Return (0x0100)
                        }

                        Name (DHKC, 0x00)
                        Name (DHKB, 0x01)
                        Mutex (XDHK, 0x07)
                        Name (DHKH, 0x00)
                        Name (DHKW, 0x00)
                        Name (DHKS, 0x00)
                        Name (DHKD, 0x00)
                        Name (DHKN, 0x080C)
                        Name (DHKT, 0x00)
                        Method (MHKA, 0, NotSerialized)
                        {
                            Return (0x09DC)
                        }

                        Method (MHKN, 0, NotSerialized)
                        {
                            Return (DHKN)
                        }

                        Method (MHKK, 1, NotSerialized)
                        {
                            If (DHKC)
                            {
                                Return (And (DHKN, Arg0))
                            }
                            Else
                            {
                                Return (Zero)
                            }
                        }

                        Method (MHKM, 2, NotSerialized)
                        {
                            Acquire (XDHK, 0xFFFF)
                            If (LGreater (Arg0, 0x20))
                            {
                                Noop
                            }
                            Else
                            {
                                ShiftLeft (One, Decrement (Arg0), Local0)
                                If (And (Local0, 0x09DC))
                                {
                                    If (Arg1)
                                    {
                                        Or (Local0, DHKN, DHKN)
                                    }
                                    Else
                                    {
                                        And (DHKN, XOr (Local0, 0xFFFFFFFF), DHKN)
                                    }
                                }
                                Else
                                {
                                    Noop
                                }
                            }

                            Release (XDHK)
                        }

                        Method (MHKS, 0, NotSerialized)
                        {
                            Notify (\_SB.SLPB, 0x80)
                        }

                        Method (MHKC, 1, NotSerialized)
                        {
                            Store (Arg0, DHKC)
                        }

                        Method (MHKP, 0, NotSerialized)
                        {
                            Acquire (XDHK, 0xFFFF)
                            If (DHKW)
                            {
                                Store (DHKW, Local1)
                                Store (Zero, DHKW)
                            }
                            Else
                            {
                                If (DHKD)
                                {
                                    Store (DHKD, Local1)
                                    Store (Zero, DHKD)
                                }
                                Else
                                {
                                    If (DHKS)
                                    {
                                        Store (DHKS, Local1)
                                        Store (Zero, DHKS)
                                    }
                                    Else
                                    {
                                        If (DHKT)
                                        {
                                            Store (DHKT, Local1)
                                            Store (Zero, DHKT)
                                        }
                                        Else
                                        {
                                            Store (DHKH, Local1)
                                            Store (Zero, DHKH)
                                        }
                                    }
                                }
                            }

                            Release (XDHK)
                            Return (Local1)
                        }

                        Method (MHKE, 1, NotSerialized)
                        {
                            Store (Arg0, DHKB)
                            Acquire (XDHK, 0xFFFF)
                            Store (Zero, DHKH)
                            Store (Zero, DHKW)
                            Store (Zero, DHKS)
                            Store (Zero, DHKD)
                            Store (Zero, DHKT)
                            Release (XDHK)
                        }

                        Method (MHKQ, 1, NotSerialized)
                        {
                            If (DHKB)
                            {
                                If (DHKC)
                                {
                                    Acquire (XDHK, 0xFFFF)
                                    If (LLess (Arg0, 0x1000)) {}
                                    Else
                                    {
                                        If (LLess (Arg0, 0x2000))
                                        {
                                            Store (Arg0, DHKH)
                                        }
                                        Else
                                        {
                                            If (LLess (Arg0, 0x3000))
                                            {
                                                Store (Arg0, DHKW)
                                            }
                                            Else
                                            {
                                                If (LLess (Arg0, 0x4000))
                                                {
                                                    Store (Arg0, DHKS)
                                                }
                                                Else
                                                {
                                                    If (LLess (Arg0, 0x5000))
                                                    {
                                                        Store (Arg0, DHKD)
                                                    }
                                                    Else
                                                    {
                                                        If (LLess (Arg0, 0x6000))
                                                        {
                                                            Store (Arg0, DHKH)
                                                        }
                                                        Else
                                                        {
                                                            If (LLess (Arg0, 0x7000))
                                                            {
                                                                Store (Arg0, DHKT)
                                                            }
                                                            Else
                                                            {
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }

                                    Release (XDHK)
                                    If (LEqual (DHKH, 0x1003)) {}
                                    Notify (HKEY, 0x80)
                                }
                                Else
                                {
                                    If (LEqual (Arg0, 0x1004))
                                    {
                                        Notify (\_SB.SLPB, 0x80)
                                    }
                                }
                            }
                        }

                        Method (MHKB, 1, NotSerialized)
                        {
                            If (LEqual (Arg0, 0x00))
                            {
                                \_SB.PCI0.LPC.EC.BEEP (0x11)
                            }
                            Else
                            {
                                If (LEqual (Arg0, 0x01))
                                {
                                    \_SB.PCI0.LPC.EC.BEEP (0x10)
                                }
                                Else
                                {
                                }
                            }
                        }

                        Method (MHKD, 0, NotSerialized)
                        {
                            \_SB.PCI0.AGP.VID.VLOC (0x00)
                        }
                    }
                }
            }

            Name (_ADR, 0x00)
            Name (_S3D, 0x02)
            Name (_PRT, Package (0x09)
            {
                Package (0x04)
                {
                    0x0002FFFF, 
                    0x00, 
                    \_SB.LNKI, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0003FFFF, 
                    0x00, 
                    \_SB.LNKG, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x00, 
                    \_SB.LNKH, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000BFFFF, 
                    0x00, 
                    \_SB.LNKC, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000CFFFF, 
                    0x00, 
                    \_SB.LNKB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000DFFFF, 
                    0x00, 
                    \_SB.LNKC, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000DFFFF, 
                    0x01, 
                    \_SB.LNKD, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000DFFFF, 
                    0x02, 
                    \_SB.LNKA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000DFFFF, 
                    0x03, 
                    \_SB.LNKB, 
                    0x00
                }
            })
            Name (_HID, EisaId ("PNP0A03"))
            Name (_BBN, 0x00)
            OperationRegion (MHCS, PCI_Config, 0x00, 0x0100)
            Field (MHCS, DWordAcc, NoLock, Preserve)
            {
                Offset (0x59), 
                PAM0,   8, 
                PAM1,   8, 
                PAM2,   8, 
                PAM3,   8, 
                PAM4,   8, 
                PAM5,   8, 
                PAM6,   8, 
                Offset (0x90), 
                SIZM,   32
            }

            Field (MHCS, DWordAcc, NoLock, Preserve)
            {
                Offset (0x14), 
                BAR1,   32
            }

            Name (_CRS, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000, // Address Space Granularity
                    0x0000, // Address Range Minimum
                    0x00FF, // Address Range Maximum
                    0x0000, // Address Translation Offset
                    0x0100,,,)
                IO (Decode16, 0x0CF8, 0x0CF8, 0x01, 0x08)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000, // Address Space Granularity
                    0x0000, // Address Range Minimum
                    0x0CF7, // Address Range Maximum
                    0x0000, // Address Translation Offset
                    0x0CF8,,,
                    , TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000, // Address Space Granularity
                    0x0D00, // Address Range Minimum
                    0xFFFF, // Address Range Maximum
                    0x0000, // Address Translation Offset
                    0xF300,,,
                    , TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000A0000, // Address Range Minimum
                    0x000BFFFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00020000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000C0000, // Address Range Minimum
                    0x000C3FFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00004000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000C4000, // Address Range Minimum
                    0x000C7FFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00004000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000C8000, // Address Range Minimum
                    0x000CBFFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00004000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000CC000, // Address Range Minimum
                    0x000CFFFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00004000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000D0000, // Address Range Minimum
                    0x000D3FFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00004000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000D4000, // Address Range Minimum
                    0x000D7FFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00004000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000D8000, // Address Range Minimum
                    0x000DBFFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00004000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000DC000, // Address Range Minimum
                    0x000DFFFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00004000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000E0000, // Address Range Minimum
                    0x000E3FFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00004000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000E4000, // Address Range Minimum
                    0x000E7FFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00004000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000E8000, // Address Range Minimum
                    0x000EBFFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00004000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x000EC000, // Address Range Minimum
                    0x000EFFFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0x00004000,,,
                    , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000, // Address Space Granularity
                    0x00100000, // Address Range Minimum
                    0xFEBFFFFF, // Address Range Maximum
                    0x00000000, // Address Translation Offset
                    0xFEB00000,,,
                    , AddressRangeMemory, TypeStatic)
            })
            CreateDWordField (_CRS, 0x68, C0LN)
            CreateDWordField (_CRS, 0x82, C4LN)
            CreateDWordField (_CRS, 0x9C, C8LN)
            CreateDWordField (_CRS, 0xB6, CCLN)
            CreateDWordField (_CRS, 0xD0, D0LN)
            CreateDWordField (_CRS, 0xEA, D4LN)
            CreateDWordField (_CRS, 0x0104, D8LN)
            CreateDWordField (_CRS, 0x011E, DCLN)
            CreateDWordField (_CRS, 0x0138, E0LN)
            CreateDWordField (_CRS, 0x0152, E4LN)
            CreateDWordField (_CRS, 0x016C, E8LN)
            CreateDWordField (_CRS, 0x0186, ECLN)
            CreateDWordField (_CRS, 0x0194, XXMN)
            CreateDWordField (_CRS, 0x0198, XXMX)
            CreateDWordField (_CRS, 0x01A0, XXLN)
            Method (_INI, 0, Serialized)
            {
                If (LNot (\OSIF))
                {
                    \_SB._INI ()
                }

                Store (SIZM, Local0)
                Store (Local0, \MEMX)
                Store (Local0, XXMN)
                Add (Subtract (XXMX, XXMN), 0x01, XXLN)
                If (And (PAM1, 0x03))
                {
                    Store (0x00, C0LN)
                }

                If (And (PAM1, 0x30))
                {
                    Store (0x00, C4LN)
                }

                If (And (PAM2, 0x03))
                {
                    Store (0x00, C8LN)
                }

                If (And (PAM2, 0x30))
                {
                    Store (0x00, CCLN)
                }

                If (And (PAM3, 0x03))
                {
                    Store (0x00, D0LN)
                }

                If (And (PAM3, 0x30))
                {
                    Store (0x00, D4LN)
                }

                If (And (PAM4, 0x03))
                {
                    Store (0x00, D8LN)
                }

                If (And (PAM4, 0x30))
                {
                    Store (0x00, DCLN)
                }

                If (And (PAM5, 0x03))
                {
                    Store (0x00, E0LN)
                }

                If (And (PAM5, 0x30))
                {
                    Store (0x00, E4LN)
                }

                If (And (PAM6, 0x03))
                {
                    Store (0x00, E8LN)
                }

                If (And (PAM6, 0x30))
                {
                    Store (0x00, ECLN)
                }
            }

            Name (_PRW, Package (0x03)
            {
                0x09, 
                0x04, 
                \_SB.PCI0.LPC.EC.PUBS
            })
            Device (AGP)
            {
                Name (_ADR, 0x00010000)
                Name (_S3D, 0x03)
                Name (_PRT, Package (0x02)
                {
                    Package (0x04)
                    {
                        0x0005FFFF, 
                        0x00, 
                        \_SB.LNKA, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0005FFFF, 
                        0x01, 
                        \_SB.LNKE, 
                        0x00
                    }
                })
                Name (EDX1, Buffer (0x80)
                {
                    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
                    0x24, 0x4D, 0x55, 0x0A, 0x01, 0x01, 0x01, 0x01, 
                    0x23, 0x09, 0x01, 0x02, 0x80, 0x21, 0x18, 0x00, 
                    0xEA, 0x0D, 0xFB, 0xA0, 0x57, 0x47, 0x98, 0x27, 
                    0x12, 0x4D, 0x51, 0xA1, 0x08, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x19, 
                    0x00, 0x40, 0x41, 0x00, 0x26, 0x30, 0x18, 0x88, 
                    0x36, 0x00, 0x0E, 0xCB, 0x10, 0x00, 0x00, 0x1A, 
                    0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x68, 0x69, 
                    0x6E, 0x6B, 0x50, 0x61, 0x64, 0x20, 0x4C, 0x43, 
                    0x44, 0x20, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x31, 
                    0x30, 0x32, 0x34, 0x78, 0x37, 0x36, 0x38, 0x20, 
                    0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33
                })
                Name (EDX2, Buffer (0x0100)
                {
                    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
                    0x24, 0x4D, 0x55, 0x0A, 0x01, 0x01, 0x01, 0x01, 
                    0x23, 0x09, 0x01, 0x02, 0x80, 0x21, 0x18, 0x00, 
                    0xEA, 0x0D, 0xFB, 0xA0, 0x57, 0x47, 0x98, 0x27, 
                    0x12, 0x4D, 0x51, 0xA1, 0x08, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x19, 
                    0x00, 0x40, 0x41, 0x00, 0x26, 0x30, 0x18, 0x88, 
                    0x36, 0x00, 0x0E, 0xCB, 0x10, 0x00, 0x00, 0x1A, 
                    0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x68, 0x69, 
                    0x6E, 0x6B, 0x50, 0x61, 0x64, 0x20, 0x4C, 0x43, 
                    0x44, 0x20, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x31, 
                    0x30, 0x32, 0x34, 0x78, 0x37, 0x36, 0x38, 0x20, 
                    0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                })
                Name (EDL1, Buffer (0x80)
                {
                    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
                    0x24, 0x4D, 0x4D, 0x25, 0x01, 0x01, 0x01, 0x01, 
                    0x23, 0x09, 0x01, 0x02, 0x80, 0x21, 0x18, 0x00, 
                    0xEA, 0x0D, 0xFB, 0xA0, 0x57, 0x47, 0x98, 0x27, 
                    0x12, 0x4D, 0x51, 0xA1, 0x08, 0x00, 0x81, 0x80, 
                    0x90, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x2A, 
                    0x78, 0x20, 0x51, 0x1A, 0x10, 0x40, 0x30, 0x70, 
                    0x13, 0x00, 0x30, 0xE4, 0x10, 0x00, 0x00, 0x1A, 
                    0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x68, 0x69, 
                    0x6E, 0x6B, 0x50, 0x61, 0x64, 0x20, 0x4C, 0x43, 
                    0x44, 0x20, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x31, 
                    0x34, 0x30, 0x30, 0x78, 0x31, 0x30, 0x35, 0x30, 
                    0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF
                })
                Name (EDL2, Buffer (0x0100)
                {
                    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
                    0x24, 0x4D, 0x4D, 0x25, 0x01, 0x01, 0x01, 0x01, 
                    0x23, 0x09, 0x01, 0x02, 0x80, 0x21, 0x18, 0x00, 
                    0xEA, 0x0D, 0xFB, 0xA0, 0x57, 0x47, 0x98, 0x27, 
                    0x12, 0x4D, 0x51, 0xA1, 0x08, 0x00, 0x81, 0x80, 
                    0x90, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x2A, 
                    0x78, 0x20, 0x51, 0x1A, 0x10, 0x40, 0x30, 0x70, 
                    0x13, 0x00, 0x30, 0xE4, 0x10, 0x00, 0x00, 0x1A, 
                    0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x68, 0x69, 
                    0x6E, 0x6B, 0x50, 0x61, 0x64, 0x20, 0x4C, 0x43, 
                    0x44, 0x20, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x31, 
                    0x34, 0x30, 0x30, 0x78, 0x31, 0x30, 0x35, 0x30, 
                    0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                })
                Name (EDL3, Buffer (0x80)
                {
                    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
                    0x24, 0x4D, 0x5E, 0x1A, 0x01, 0x01, 0x01, 0x01, 
                    0x23, 0x09, 0x01, 0x02, 0x80, 0x21, 0x18, 0x00, 
                    0xEA, 0x0D, 0xFB, 0xA0, 0x57, 0x47, 0x98, 0x27, 
                    0x12, 0x4D, 0x51, 0xA1, 0x08, 0x00, 0x81, 0x80, 
                    0x90, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x2A, 
                    0x78, 0x20, 0x51, 0x1A, 0x10, 0x40, 0x30, 0x70, 
                    0x13, 0x00, 0x30, 0xE4, 0x10, 0x00, 0x00, 0x1A, 
                    0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x68, 0x69, 
                    0x6E, 0x6B, 0x50, 0x61, 0x64, 0x20, 0x4C, 0x43, 
                    0x44, 0x20, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x31, 
                    0x34, 0x30, 0x30, 0x78, 0x31, 0x30, 0x35, 0x30, 
                    0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD9
                })
                Name (EDL4, Buffer (0x0100)
                {
                    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
                    0x24, 0x4D, 0x5E, 0x1A, 0x01, 0x01, 0x01, 0x01, 
                    0x23, 0x09, 0x01, 0x02, 0x80, 0x21, 0x18, 0x00, 
                    0xEA, 0x0D, 0xFB, 0xA0, 0x57, 0x47, 0x98, 0x27, 
                    0x12, 0x4D, 0x51, 0xA1, 0x08, 0x00, 0x81, 0x80, 
                    0x90, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x2A, 
                    0x78, 0x20, 0x51, 0x1A, 0x10, 0x40, 0x30, 0x70, 
                    0x13, 0x00, 0x30, 0xE4, 0x10, 0x00, 0x00, 0x1A, 
                    0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x68, 0x69, 
                    0x6E, 0x6B, 0x50, 0x61, 0x64, 0x20, 0x4C, 0x43, 
                    0x44, 0x20, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x31, 
                    0x34, 0x30, 0x30, 0x78, 0x31, 0x30, 0x35, 0x30, 
                    0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD9, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                })
                Name (EDU1, Buffer (0x80)
                {
                    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
                    0x24, 0x4D, 0x54, 0x0A, 0x01, 0x01, 0x01, 0x01, 
                    0x23, 0x09, 0x01, 0x02, 0x80, 0x1E, 0x16, 0x00, 
                    0xEA, 0x0D, 0xFB, 0xA0, 0x57, 0x47, 0x98, 0x27, 
                    0x12, 0x4D, 0x51, 0xA1, 0x08, 0x00, 0x81, 0x80, 
                    0xA9, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x3F, 
                    0x40, 0x30, 0x62, 0xB0, 0x32, 0x40, 0x40, 0xC0, 
                    0x14, 0x00, 0x30, 0xE4, 0x10, 0x00, 0x00, 0x1A, 
                    0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x68, 0x69, 
                    0x6E, 0x6B, 0x50, 0x61, 0x64, 0x20, 0x4C, 0x43, 
                    0x44, 0x20, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x31, 
                    0x36, 0x30, 0x30, 0x78, 0x31, 0x32, 0x30, 0x30, 
                    0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB1
                })
                Name (EDU2, Buffer (0x0100)
                {
                    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
                    0x24, 0x4D, 0x54, 0x0A, 0x01, 0x01, 0x01, 0x01, 
                    0x23, 0x09, 0x01, 0x02, 0x80, 0x1E, 0x16, 0x00, 
                    0xEA, 0x0D, 0xFB, 0xA0, 0x57, 0x47, 0x98, 0x27, 
                    0x12, 0x4D, 0x51, 0xA1, 0x08, 0x00, 0x81, 0x80, 
                    0xA9, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x3F, 
                    0x40, 0x30, 0x62, 0xB0, 0x32, 0x40, 0x40, 0xC0, 
                    0x14, 0x00, 0x30, 0xE4, 0x10, 0x00, 0x00, 0x1A, 
                    0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x68, 0x69, 
                    0x6E, 0x6B, 0x50, 0x61, 0x64, 0x20, 0x4C, 0x43, 
                    0x44, 0x20, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x31, 
                    0x36, 0x30, 0x30, 0x78, 0x31, 0x32, 0x30, 0x30, 
                    0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB1, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                })
                Name (EDU3, Buffer (0x80)
                {
                    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
                    0x24, 0x4D, 0x5D, 0x1A, 0x01, 0x01, 0x01, 0x01, 
                    0x23, 0x09, 0x01, 0x02, 0x80, 0x1E, 0x16, 0x00, 
                    0xEA, 0x0D, 0xFB, 0xA0, 0x57, 0x47, 0x98, 0x27, 
                    0x12, 0x4D, 0x51, 0xA1, 0x08, 0x00, 0x81, 0x80, 
                    0xA9, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x3F, 
                    0x40, 0x30, 0x62, 0xB0, 0x32, 0x40, 0x40, 0xC0, 
                    0x14, 0x00, 0x30, 0xE4, 0x10, 0x00, 0x00, 0x1A, 
                    0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x68, 0x69, 
                    0x6E, 0x6B, 0x50, 0x61, 0x64, 0x20, 0x4C, 0x43, 
                    0x44, 0x20, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x31, 
                    0x36, 0x30, 0x30, 0x78, 0x31, 0x32, 0x30, 0x30, 
                    0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98
                })
                Name (EDU4, Buffer (0x0100)
                {
                    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
                    0x24, 0x4D, 0x5D, 0x1A, 0x01, 0x01, 0x01, 0x01, 
                    0x23, 0x09, 0x01, 0x02, 0x80, 0x1E, 0x16, 0x00, 
                    0xEA, 0x0D, 0xFB, 0xA0, 0x57, 0x47, 0x98, 0x27, 
                    0x12, 0x4D, 0x51, 0xA1, 0x08, 0x00, 0x81, 0x80, 
                    0xA9, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x3F, 
                    0x40, 0x30, 0x62, 0xB0, 0x32, 0x40, 0x40, 0xC0, 
                    0x14, 0x00, 0x30, 0xE4, 0x10, 0x00, 0x00, 0x1A, 
                    0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x68, 0x69, 
                    0x6E, 0x6B, 0x50, 0x61, 0x64, 0x20, 0x4C, 0x43, 
                    0x44, 0x20, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x31, 
                    0x36, 0x30, 0x30, 0x78, 0x31, 0x32, 0x30, 0x30, 
                    0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                })
                Name (EDT1, Buffer (0x80)
                {
                    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
                    0xC1, 0xD0, 0xFE, 0x09, 0x01, 0x01, 0x01, 0x01, 
                    0x23, 0x09, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 
                    0xEA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0xA1, 0x08, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x31, 0x58, 0x1C, 0x20, 0x28, 0x80, 
                    0x01, 0x00, 0xF6, 0xB8, 0x00, 0x00, 0x00, 0x1A, 
                    0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x68, 0x69, 
                    0x6E, 0x6B, 0x50, 0x61, 0x64, 0x20, 0x54, 0x56, 
                    0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59
                })
                Name (EDT2, Buffer (0x0100)
                {
                    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
                    0xC1, 0xD0, 0xFE, 0x09, 0x01, 0x01, 0x01, 0x01, 
                    0x23, 0x09, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 
                    0xEA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0xA1, 0x08, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x31, 0x58, 0x1C, 0x20, 0x28, 0x80, 
                    0x01, 0x00, 0xF6, 0xB8, 0x00, 0x00, 0x00, 0x1A, 
                    0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x68, 0x69, 
                    0x6E, 0x6B, 0x50, 0x61, 0x64, 0x20, 0x54, 0x56, 
                    0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                })
                Mutex (MDGS, 0x07)
                Name (VDEE, 0x01)
                Name (VDDA, Buffer (0x02) {})
                CreateBitField (VDDA, 0x00, VUPC)
                CreateBitField (VDDA, 0x01, VQDL)
                CreateBitField (VDDA, 0x02, VQDC)
                CreateBitField (VDDA, 0x03, VQDT)
                CreateBitField (VDDA, 0x04, VQDD)
                CreateBitField (VDDA, 0x05, VSDL)
                CreateBitField (VDDA, 0x06, VSDC)
                CreateBitField (VDDA, 0x07, VSDT)
                CreateBitField (VDDA, 0x08, VSDD)
                CreateBitField (VDDA, 0x0A, MSWT)
                CreateBitField (VDDA, 0x0B, VWST)
                Device (VID)
                {
                    Name (_ADR, 0x00050000)
                    OperationRegion (VPCG, PCI_Config, 0x00, 0x0100)
                    Field (VPCG, DWordAcc, NoLock, Preserve)
                    {
                        Offset (0x54), 
                        VPWR,   32
                    }

                    Name (_S3D, 0x03)
                    Method (_INI, 0, NotSerialized)
                    {
                        \VUPS (0x02)
                        Store (\VCDL, VQDL)
                        Store (\VCDC, VQDC)
                        Store (\VCDT, VQDT)
                        Store (\VCDD, VQDD)
                    }

                    Method (_PS0, 0, NotSerialized)
                    {
                    }

                    Method (_PS1, 0, NotSerialized)
                    {
                    }

                    Method (_PS2, 0, NotSerialized)
                    {
                    }

                    Method (_PS3, 0, NotSerialized)
                    {
                    }

                    Method (VSWT, 0, NotSerialized)
                    {
                        Store (\VEVT (0x05), Local0)
                        And (0x0F, Local0, Local1)
                        If (Local1)
                        {
                            ASWT (Local1, 0x01)
                        }
                    }

                    Method (VLOC, 1, NotSerialized)
                    {
                        If (LEqual (Arg0, \_SB.LID._LID ()))
                        {
                            \VSLD (Arg0)
                            If (LEqual (VPWR, 0x00))
                            {
                                If (Arg0)
                                {
                                    Store (\VEVT (0x01), Local0)
                                }
                                Else
                                {
                                    Store (\VEVT (0x02), Local0)
                                }

                                And (0x0F, Local0, Local1)
                                If (Local1)
                                {
                                    ASWT (Local1, 0x00)
                                }
                            }
                        }
                    }

                    Method (_DOS, 1, NotSerialized)
                    {
                        If (LEqual (Arg0, 0x02))
                        {
                            Store (0x14, Local0)
                            While (Local0)
                            {
                                Decrement (Local0)
                                Acquire (MDGS, 0xFFFF)
                                If (LEqual (0x00, MSWT))
                                {
                                    Store (0x01, MSWT)
                                    Store (0x00, Local0)
                                    Store (Arg0, VDEE)
                                }

                                Release (MDGS)
                                Sleep (0xC8)
                            }
                        }
                        Else
                        {
                            Acquire (MDGS, 0xFFFF)
                            If (LEqual (VDEE, 0x02))
                            {
                                Store (0x00, MSWT)
                            }

                            If (LGreater (Arg0, 0x02))
                            {
                                Store (0x01, VDEE)
                            }
                            Else
                            {
                                Store (Arg0, VDEE)
                            }

                            Release (MDGS)
                        }
                    }

                    Method (_DOD, 0, NotSerialized)
                    {
                        Return (Package (0x04)
                        {
                            0x0110, 
                            0x0100, 
                            0x0200, 
                            0x0210
                        })
                    }

                    Method (ASWT, 2, NotSerialized)
                    {
                        If (LEqual (0x01, VDEE))
                        {
                            And (0x01, Arg1, Local1)
                            \VSDS (Arg0, Local1)
                        }
                        Else
                        {
                            Store (0x14, Local0)
                            While (Local0)
                            {
                                Decrement (Local0)
                                Acquire (MDGS, 0xFFFF)
                                If (LEqual (0x00, MSWT))
                                {
                                    Store (0x00, Local0)
                                    If (And (0x01, Arg1))
                                    {
                                        Store (0x01, VUPC)
                                    }
                                    Else
                                    {
                                        Store (0x00, VUPC)
                                    }

                                    If (And (0x01, Arg0))
                                    {
                                        Store (0x01, VQDL)
                                    }
                                    Else
                                    {
                                        Store (0x00, VQDL)
                                    }

                                    If (And (0x02, Arg0))
                                    {
                                        Store (0x01, VQDC)
                                    }
                                    Else
                                    {
                                        Store (0x00, VQDC)
                                    }

                                    If (And (0x04, Arg0))
                                    {
                                        Store (0x01, VQDT)
                                    }
                                    Else
                                    {
                                        Store (0x00, VQDT)
                                    }

                                    If (And (0x08, Arg0))
                                    {
                                        Store (0x01, VQDD)
                                    }
                                    Else
                                    {
                                        Store (0x00, VQDD)
                                    }
                                }

                                Release (MDGS)
                                Sleep (0xC8)
                            }

                            If (And (0x02, Arg1))
                            {
                                Notify (VID, 0x81)
                            }
                            Else
                            {
                                Notify (VID, 0x80)
                            }
                        }
                    }

                    Method (VDSW, 1, NotSerialized)
                    {
                        If (LEqual (VPWR, 0x00))
                        {
                            If (Arg0)
                            {
                                Store (\VEVT (0x03), Local0)
                            }
                            Else
                            {
                                Store (\VEVT (0x04), Local0)
                            }

                            And (0x0F, Local0, Local1)
                            If (Local1)
                            {
                                ASWT (Local1, 0x00)
                            }
                        }
                    }

                    Device (LCD0)
                    {
                        Name (_ADR, 0x0110)
                        Method (_DCS, 0, NotSerialized)
                        {
                            \VUPS (0x00)
                            If (\VCDL)
                            {
                                Return (0x1F)
                            }
                            Else
                            {
                                Return (0x1D)
                            }
                        }

                        Method (_DDC, 1, NotSerialized)
                        {
                            If (LEqual (\VLID, 0x02))
                            {
                                If (LEqual (Arg0, 0x01))
                                {
                                    Return (EDX1)
                                }
                                Else
                                {
                                    If (LEqual (Arg0, 0x02))
                                    {
                                        Return (EDX2)
                                    }
                                }
                            }

                            If (LEqual (\VLID, 0x04))
                            {
                                If (LEqual (Arg0, 0x01))
                                {
                                    Return (EDL1)
                                }
                                Else
                                {
                                    If (LEqual (Arg0, 0x02))
                                    {
                                        Return (EDL2)
                                    }
                                }
                            }

                            If (LEqual (\VLID, 0x0C))
                            {
                                If (LEqual (Arg0, 0x01))
                                {
                                    Return (EDL3)
                                }
                                Else
                                {
                                    If (LEqual (Arg0, 0x02))
                                    {
                                        Return (EDL4)
                                    }
                                }
                            }

                            If (LEqual (\VLID, 0x05))
                            {
                                If (LEqual (Arg0, 0x01))
                                {
                                    Return (EDU1)
                                }
                                Else
                                {
                                    If (LEqual (Arg0, 0x02))
                                    {
                                        Return (EDU2)
                                    }
                                }
                            }

                            If (LEqual (\VLID, 0x0D))
                            {
                                If (LEqual (Arg0, 0x01))
                                {
                                    Return (EDU3)
                                }
                                Else
                                {
                                    If (LEqual (Arg0, 0x02))
                                    {
                                        Return (EDU4)
                                    }
                                }
                            }

                            Return (0x00)
                        }

                        Method (_DGS, 0, NotSerialized)
                        {
                            Return (VQDL)
                        }

                        Method (_DSS, 1, NotSerialized)
                        {
                            And (Arg0, 0x01, VSDL)
                            If (And (Arg0, 0x80000000))
                            {
                                If (And (Arg0, 0x40000000))
                                {
                                    DSWT (0x02)
                                }
                                Else
                                {
                                    DSWT (0x01)
                                }
                            }
                        }
                    }

                    Device (CRT0)
                    {
                        Name (_ADR, 0x0100)
                        Method (_DCS, 0, NotSerialized)
                        {
                            \VUPS (0x01)
                            If (\VCSS)
                            {
                                If (\VCDC)
                                {
                                    Return (0x1F)
                                }
                                Else
                                {
                                    Return (0x1D)
                                }
                            }
                            Else
                            {
                                If (\VCDC)
                                {
                                    Return (0x0F)
                                }
                                Else
                                {
                                    Return (0x0D)
                                }
                            }
                        }

                        Method (_DDC, 1, NotSerialized)
                        {
                            \VDDC ()
                            If (LEqual (Arg0, 0x01))
                            {
                                Return (\DDC1)
                            }
                            Else
                            {
                                If (LEqual (Arg0, 0x02))
                                {
                                    Return (\DDC2)
                                }
                                Else
                                {
                                    Return (0x00)
                                }
                            }
                        }

                        Method (_DGS, 0, NotSerialized)
                        {
                            Return (VQDC)
                        }

                        Method (_DSS, 1, NotSerialized)
                        {
                            And (Arg0, 0x01, VSDC)
                            If (And (Arg0, 0x80000000))
                            {
                                If (And (Arg0, 0x40000000))
                                {
                                    DSWT (0x02)
                                }
                                Else
                                {
                                    DSWT (0x01)
                                }
                            }
                        }
                    }

                    Device (TV0)
                    {
                        Name (_ADR, 0x0200)
                        Method (_DCS, 0, NotSerialized)
                        {
                            \VUPS (0x00)
                            If (\VCDT)
                            {
                                Return (0x1F)
                            }
                            Else
                            {
                                Return (0x1D)
                            }
                        }

                        Method (_DDC, 1, NotSerialized)
                        {
                            If (LEqual (Arg0, 0x01))
                            {
                                Return (EDT1)
                            }
                            Else
                            {
                                If (LEqual (Arg0, 0x02))
                                {
                                    Return (EDT2)
                                }
                            }

                            Return (0x00)
                        }

                        Method (_DGS, 0, NotSerialized)
                        {
                            Return (VQDT)
                        }

                        Method (_DSS, 1, NotSerialized)
                        {
                            And (Arg0, 0x01, VSDT)
                            If (And (Arg0, 0x80000000))
                            {
                                If (And (Arg0, 0x40000000))
                                {
                                    DSWT (0x02)
                                }
                                Else
                                {
                                    DSWT (0x01)
                                }
                            }
                        }
                    }

                    Device (DVI0)
                    {
                        Name (_ADR, 0x0210)
                        Method (_DCS, 0, NotSerialized)
                        {
                            \VUPS (0x00)
                            If (\VCDD)
                            {
                                Return (0x1F)
                            }
                            Else
                            {
                                Return (0x1D)
                            }
                        }

                        Method (_DGS, 0, NotSerialized)
                        {
                            Return (VQDD)
                        }

                        Method (_DSS, 1, NotSerialized)
                        {
                            And (Arg0, 0x01, VSDD)
                            If (And (Arg0, 0x80000000))
                            {
                                If (And (Arg0, 0x40000000))
                                {
                                    DSWT (0x02)
                                }
                                Else
                                {
                                    DSWT (0x01)
                                }
                            }
                        }
                    }

                    Method (DSWT, 1, NotSerialized)
                    {
                        If (VSDL)
                        {
                            Store (0x01, Local0)
                        }
                        Else
                        {
                            Store (0x00, Local0)
                        }

                        If (VSDC)
                        {
                            Or (0x02, Local0, Local0)
                        }

                        If (Local0)
                        {
                            If (VUPC)
                            {
                                \VSDS (Local0, Arg0)
                            }
                        }
                        Else
                        {
                            Noop
                        }
                    }
                }
            }

            Device (CBS0)
            {
                Name (_ADR, 0x000C0000)
                Name (_S3D, 0x02)
                Name (_SUN, 0x01)
                OperationRegion (CBUS, PCI_Config, 0x00, 0x0100)
                Field (CBUS, DWordAcc, NoLock, Preserve)
                {
                    Offset (0x44), 
                    LGDC,   32, 
                    Offset (0x80), 
                    SYSC,   32, 
                    Offset (0x8C), 
                    MULR,   32, 
                    RSTS,   8, 
                    CCTL,   8, 
                    DCTL,   8, 
                    DIAG,   8
                }

                Method (_INI, 0, NotSerialized)
                {
                    Or (And (LGDC, 0x00), 0x00, LGDC)
                    Or (And (SYSC, 0x00FFFFFE), 0x08000001, SYSC)
                    Or (And (CCTL, 0x7B), 0x02, CCTL)
                }
            }

            Device (IDE0)
            {
                Name (_ADR, 0x000F0000)
                Name (_S3D, 0x03)
                OperationRegion (IDCS, PCI_Config, 0x00, 0x0100)
                Field (IDCS, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x09), 
                        ,   4, 
                    SCHE,   1, 
                    PCHE,   1, 
                    Offset (0x0A), 
                    Offset (0x0D), 
                    IDLT,   8, 
                    Offset (0x40), 
                    PUM6,   2, 
                    SUM6,   2, 
                    Offset (0x4B), 
                    U66E,   1, 
                    Offset (0x4C), 
                    Offset (0x53), 
                    CDFI,   1, 
                    CDUD,   1, 
                    Offset (0x54), 
                    PFTH,   8, 
                    SFTH,   8, 
                    PUDC,   8, 
                    SUDC,   8, 
                    PAST,   8, 
                    PCBT,   8, 
                    PTM0,   8, 
                    PTM1,   8, 
                    SAST,   8, 
                    SCBT,   8, 
                    STM0,   8, 
                    STM1,   8
                }

                Name (UDMT, Package (0x08)
                {
                    0x1E, 
                    0x2D, 
                    0x3C, 
                    0x5A, 
                    0x78, 
                    0x78, 
                    0x78, 
                    0x14
                })
                Name (PIOT, Package (0x05)
                {
                    0x78, 
                    0xB4, 
                    0xF0, 
                    0x017F, 
                    0x0258
                })
                Name (PIOC, Package (0x05)
                {
                    0x04, 
                    0x06, 
                    0x08, 
                    0x0D, 
                    0x10
                })
                Name (CBCT, Package (0x05)
                {
                    0x31, 
                    0x33, 
                    0x01, 
                    0x03, 
                    0x0A
                })
                Name (DACT, Package (0x05)
                {
                    0x03, 
                    0x03, 
                    0x04, 
                    0x05, 
                    0x08
                })
                Name (DRCT, Package (0x05)
                {
                    0x01, 
                    0x03, 
                    0x04, 
                    0x08, 
                    0x08
                })
                Name (PXLM, Package (0x05)
                {
                    0x02, 
                    0x01, 
                    0x00, 
                    0x00, 
                    0x00
                })
                Method (GTM, 4, NotSerialized)
                {
                    Store (Buffer (0x14) {}, Local0)
                    CreateDWordField (Local0, 0x00, PIO0)
                    CreateDWordField (Local0, 0x04, DMA0)
                    CreateDWordField (Local0, 0x08, PIO1)
                    CreateDWordField (Local0, 0x0C, DMA1)
                    CreateDWordField (Local0, 0x10, FLAG)
                    Store (Zero, PIO0)
                    Store (Zero, DMA0)
                    Store (Zero, PIO1)
                    Store (Zero, DMA1)
                    Store (Zero, FLAG)
                    If (Arg0)
                    {
                        ShiftRight (And (Arg0, 0x70), 0x04, Local1)
                        If (LEqual (Local1, Zero))
                        {
                            Store (0x08, Local1)
                        }

                        Add (And (Arg0, 0x0F, Local2), Local1, Local1)
                        Store (Match (^PIOC, MLE, Local1, MTR, 0x00, 0x00), Local2)
                        Store (DerefOf (Index (^PIOT, Local2)), PIO0)
                        If (LNot (LGreater (PIO0, 0xF0)))
                        {
                            Or (FLAG, 0x02, FLAG)
                        }
                    }

                    If (And (Arg2, 0x08))
                    {
                        Store (DerefOf (Index (^UDMT, And (Arg2, 0x07))), Local1)
                        If (LEqual (Local1, 0x14))
                        {
                            If (LAnd (Arg3, 0x01))
                            {
                                Store (0x0F, Local1)
                            }
                        }

                        Store (Local1, DMA0)
                        Or (FLAG, 0x01, FLAG)
                    }
                    Else
                    {
                        Store (PIO0, DMA0)
                    }

                    If (Arg1)
                    {
                        ShiftRight (And (Arg1, 0x70), 0x04, Local1)
                        If (LEqual (Local1, Zero))
                        {
                            Store (0x08, Local1)
                        }

                        Add (And (Arg1, 0x0F, Local2), Local1, Local1)
                        Store (Match (^PIOC, MLE, Local1, MTR, 0x00, 0x00), Local2)
                        Store (DerefOf (Index (^PIOT, Local2)), PIO1)
                        If (LNot (LGreater (PIO1, 0xF0)))
                        {
                            Or (FLAG, 0x08, FLAG)
                        }
                    }

                    If (And (Arg2, 0x80))
                    {
                        Store (DerefOf (Index (^UDMT, ShiftRight (And (Arg2, 0x70), 0x04))), Local1)
                        If (LEqual (Local1, 0x14))
                        {
                            If (LAnd (Arg3, 0x02))
                            {
                                Store (0x0F, Local1)
                            }
                        }

                        Store (Local1, DMA1)
                        Or (FLAG, 0x04, FLAG)
                    }
                    Else
                    {
                        Store (PIO1, DMA1)
                    }

                    Or (FLAG, 0x10, FLAG)
                    Return (Local0)
                }

                Method (STM, 3, NotSerialized)
                {
                    Store (Buffer (0x07)
                        {
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        }, Local7)
                    CreateByteField (Local7, 0x00, TM0)
                    CreateByteField (Local7, 0x01, TM1)
                    CreateByteField (Local7, 0x02, UDC)
                    CreateByteField (Local7, 0x03, AST)
                    CreateByteField (Local7, 0x04, CBT)
                    CreateByteField (Local7, 0x05, U66)
                    CreateByteField (Local7, 0x06, UM6)
                    CreateDWordField (Arg0, 0x00, PIO0)
                    CreateDWordField (Arg0, 0x04, DMA0)
                    CreateDWordField (Arg0, 0x08, PIO1)
                    CreateDWordField (Arg0, 0x0C, DMA1)
                    CreateDWordField (Arg0, 0x10, FLAG)
                    Store (FLAG, Local6)
                    Store (Ones, Local4)
                    If (LOr (DMA0, PIO0))
                    {
                        If (LAnd (DMA0, LNot (PIO0)))
                        {
                            If (And (Local6, 0x01))
                            {
                                If (LAnd (LLess (DMA0, 0x1E), LNot (LLess (DMA0, 0x0F))))
                                {
                                    Store (0x07, Local0)
                                    If (LAnd (LLess (DMA0, 0x14), LNot (LLess (DMA0, 0x0F))))
                                    {
                                        Or (0x01, UM6, UM6)
                                    }
                                }
                                Else
                                {
                                    Store (Match (^UDMT, MGE, DMA0, MTR, 0x00, 0x00), Local0)
                                }

                                Or (Local0, 0x08, UDC)
                                If (LLess (DMA0, 0x3C))
                                {
                                    Store (One, U66)
                                }
                            }

                            Store (Match (^PIOT, MGE, DMA0, MTR, 0x00, 0x00), Local0)
                            Store (DerefOf (Index (^DACT, Local0)), Local2)
                            Store (DerefOf (Index (^DRCT, Local0)), Local3)
                            Add (Local3, ShiftLeft (Local2, 0x04), TM0)
                            Store (Local0, Local4)
                        }

                        If (LAnd (LNot (DMA0), PIO0))
                        {
                            Store (Match (^PIOT, MGE, PIO0, MTR, 0x00, 0x00), Local0)
                            Store (DerefOf (Index (^DACT, Local0)), Local2)
                            Store (DerefOf (Index (^DRCT, Local0)), Local3)
                            Add (Local3, ShiftLeft (Local2, 0x04), TM0)
                            Store (Local0, Local4)
                        }

                        If (LAnd (DMA0, PIO0))
                        {
                            If (And (Local6, 0x01))
                            {
                                If (LAnd (LLess (DMA0, 0x1E), LNot (LLess (DMA0, 0x0F))))
                                {
                                    Store (0x07, Local0)
                                    If (LAnd (LLess (DMA0, 0x14), LNot (LLess (DMA0, 0x0F))))
                                    {
                                        Or (0x01, UM6, UM6)
                                    }
                                }
                                Else
                                {
                                    Store (Match (^UDMT, MGE, DMA0, MTR, 0x00, 0x00), Local0)
                                }

                                Or (Local0, 0x08, UDC)
                                If (LLess (DMA0, 0x3C))
                                {
                                    Store (One, U66)
                                }
                            }

                            If (LNot (LLess (PIO0, DMA0)))
                            {
                                Store (Match (^PIOT, MGE, PIO0, MTR, 0x00, 0x00), Local0)
                                Store (Local0, Local4)
                            }
                            Else
                            {
                                Store (Match (^PIOT, MGE, DMA0, MTR, 0x00, 0x00), Local0)
                                Store (Local0, Local4)
                            }

                            Store (DerefOf (Index (^DACT, Local0)), Local2)
                            Store (DerefOf (Index (^DRCT, Local0)), Local3)
                            Add (Local3, ShiftLeft (Local2, 0x04), TM0)
                        }
                    }

                    Store (Ones, Local5)
                    If (LOr (DMA1, PIO1))
                    {
                        If (LAnd (DMA1, LNot (PIO1)))
                        {
                            If (And (Local6, 0x04))
                            {
                                If (LAnd (LLess (DMA1, 0x1E), LNot (LLess (DMA1, 0x0F))))
                                {
                                    Store (0x07, Local0)
                                    If (LAnd (LLess (DMA1, 0x14), LNot (LLess (DMA1, 0x0F))))
                                    {
                                        Or (0x02, UM6, UM6)
                                    }
                                }
                                Else
                                {
                                    Store (Match (^UDMT, MGE, DMA1, MTR, 0x00, 0x00), Local0)
                                }

                                Or (ShiftLeft (Or (Local0, 0x08), 0x04), UDC, UDC)
                                If (LLess (DMA1, 0x3C))
                                {
                                    Store (One, U66)
                                }
                            }

                            Store (Match (^PIOT, MGE, DMA1, MTR, 0x00, 0x00), Local0)
                            Store (DerefOf (Index (^DACT, Local0)), Local2)
                            Store (DerefOf (Index (^DRCT, Local0)), Local3)
                            Add (Local3, ShiftLeft (Local2, 0x04), TM1)
                            Store (Local0, Local5)
                        }

                        If (LAnd (LNot (DMA1), PIO1))
                        {
                            Store (Match (^PIOT, MGE, PIO1, MTR, 0x00, 0x00), Local0)
                            Store (DerefOf (Index (^DACT, Local0)), Local2)
                            Store (DerefOf (Index (^DRCT, Local0)), Local3)
                            Add (Local3, ShiftLeft (Local2, 0x04), TM1)
                            Store (Local0, Local5)
                        }

                        If (LAnd (DMA1, PIO1))
                        {
                            If (And (Local6, 0x04))
                            {
                                If (LAnd (LLess (DMA1, 0x1E), LNot (LLess (DMA1, 0x0F))))
                                {
                                    Store (0x07, Local0)
                                    If (LAnd (LLess (DMA1, 0x14), LNot (LLess (DMA1, 0x0F))))
                                    {
                                        Or (0x02, UM6, UM6)
                                    }
                                }
                                Else
                                {
                                    Store (Match (^UDMT, MGE, DMA1, MTR, 0x00, 0x00), Local0)
                                }

                                Or (ShiftLeft (Or (Local0, 0x08), 0x04), UDC, UDC)
                                If (LLess (DMA1, 0x3C))
                                {
                                    Store (One, U66)
                                }
                            }

                            If (LNot (LLess (PIO1, DMA1)))
                            {
                                Store (Match (^PIOT, MGE, PIO1, MTR, 0x00, 0x00), Local0)
                                Store (Local0, Local5)
                            }
                            Else
                            {
                                Store (Match (^PIOT, MGE, DMA1, MTR, 0x00, 0x00), Local0)
                                Store (Local0, Local5)
                            }

                            Store (DerefOf (Index (^DACT, Local0)), Local2)
                            Store (DerefOf (Index (^DRCT, Local0)), Local3)
                            Add (Local3, ShiftLeft (Local2, 0x04), TM1)
                        }
                    }

                    If (LEqual (Local4, Ones))
                    {
                        If (LEqual (Local5, Ones))
                        {
                            Store (Zero, CBT)
                        }
                        Else
                        {
                            Store (DerefOf (Index (^CBCT, Local5)), CBT)
                        }
                    }
                    Else
                    {
                        If (LEqual (Local5, Ones))
                        {
                            Store (DerefOf (Index (^CBCT, Local4)), CBT)
                        }
                        Else
                        {
                            If (LNot (LLess (Local4, Local5)))
                            {
                                Store (DerefOf (Index (^CBCT, Local4)), CBT)
                            }
                            Else
                            {
                                Store (DerefOf (Index (^CBCT, Local5)), CBT)
                            }
                        }
                    }

                    Store (0x02, AST)
                    Return (Local7)
                }

                Method (GTF0, 4, NotSerialized)
                {
                    Store (Buffer (0x07)
                        {
                            0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                        }, Local7)
                    CreateByteField (Local7, 0x01, MODE)
                    If (And (Arg1, 0x08))
                    {
                        And (Arg1, 0x07, Local0)
                        If (LEqual (Local0, 0x07))
                        {
                            If (LAnd (Arg3, 0x01))
                            {
                                Store (0x06, MODE)
                            }
                            Else
                            {
                                Store (0x05, MODE)
                            }
                        }
                        Else
                        {
                            Subtract (0x04, Local0, MODE)
                        }

                        Or (MODE, 0x40, MODE)
                    }
                    Else
                    {
                        And (Arg2, 0x0F, Local0)
                        Store (Match (^DRCT, MEQ, Local0, MTR, 0x00, 0x00), Local1)
                        Store (DerefOf (Index (^PXLM, Local1)), MODE)
                        Or (MODE, 0x20, MODE)
                    }

                    Concatenate (Local7, Local7, Local6)
                    And (Arg2, 0x0F, Local0)
                    Store (Match (^DRCT, MEQ, Local0, MTR, 0x00, 0x00), Local1)
                    Subtract (0x04, Local1, MODE)
                    Or (MODE, 0x08, MODE)
                    Concatenate (Local6, Local7, Local5)
                    Return (Local5)
                }

                Method (GTF1, 4, NotSerialized)
                {
                    Store (Buffer (0x07)
                        {
                            0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                        }, Local7)
                    CreateByteField (Local7, 0x01, MODE)
                    If (And (Arg1, 0x80))
                    {
                        ShiftRight (And (Arg1, 0x70), 0x04, Local0)
                        If (LEqual (Local0, 0x07))
                        {
                            If (LAnd (Arg3, 0x02))
                            {
                                Store (0x06, MODE)
                            }
                            Else
                            {
                                Store (0x05, MODE)
                            }
                        }
                        Else
                        {
                            Subtract (0x04, Local0, MODE)
                        }

                        Or (MODE, 0x40, MODE)
                    }
                    Else
                    {
                        And (Arg2, 0x0F, Local0)
                        Store (Match (^DRCT, MEQ, Local0, MTR, 0x00, 0x00), Local1)
                        Store (DerefOf (Index (^PXLM, Local1)), MODE)
                        Or (MODE, 0x20, MODE)
                    }

                    Concatenate (Local7, Local7, Local6)
                    And (Arg2, 0x0F, Local0)
                    Store (Match (^DRCT, MEQ, Local0, MTR, 0x00, 0x00), Local1)
                    Subtract (0x04, Local1, MODE)
                    Or (MODE, 0x08, MODE)
                    Concatenate (Local6, Local7, Local5)
                    Return (Local5)
                }

                Device (PRIM)
                {
                    Name (_ADR, 0x00)
                    Method (_GTM, 0, NotSerialized)
                    {
                        Store ("GTM - Primary Controller", Debug)
                        Store (^^GTM (^^PTM0, ^^PTM1, ^^PUDC, ^^PUM6), Local0)
                        Return (Local0)
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store ("STM - Primary Controller", Debug)
                        Store (^^STM (Arg0, Arg1, Arg2), Local0)
                        CreateByteField (Local0, 0x00, TM0)
                        CreateByteField (Local0, 0x01, TM1)
                        CreateByteField (Local0, 0x02, UDC)
                        CreateByteField (Local0, 0x03, AST)
                        CreateByteField (Local0, 0x04, CBT)
                        CreateByteField (Local0, 0x05, U66)
                        CreateByteField (Local0, 0x06, UM6)
                        Store (TM0, ^^PTM0)
                        Store (TM1, ^^PTM1)
                        Store (UDC, ^^PUDC)
                        Store (AST, ^^PAST)
                        Store (CBT, ^^PCBT)
                        Store (UM6, ^^PUM6)
                        If (U66)
                        {
                            Store (U66, ^^U66E)
                        }

                        Store (0x55, ^^PFTH)
                    }

                    Device (MSTR)
                    {
                        Name (_ADR, 0x00)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Store ("GTF - Secondary Master", Debug)
                            Store (^^^GTF0 (^^^PCHE, ^^^PUDC, ^^^PTM0, ^^^PUM6), Local0)
                            Return (Local0)
                        }
                    }
                }

                Device (SCND)
                {
                    Name (_ADR, 0x01)
                    Method (_GTM, 0, NotSerialized)
                    {
                        Store ("GTM - Secondary Controller", Debug)
                        Store (^^GTM (^^STM0, ^^STM1, ^^SUDC, ^^SUM6), Local0)
                        Return (Local0)
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store ("STM - Secondary Controller", Debug)
                        Store (^^STM (Arg0, Arg1, Arg2), Local0)
                        CreateByteField (Local0, 0x00, TM0)
                        CreateByteField (Local0, 0x01, TM1)
                        CreateByteField (Local0, 0x02, UDC)
                        CreateByteField (Local0, 0x03, AST)
                        CreateByteField (Local0, 0x04, CBT)
                        CreateByteField (Local0, 0x05, U66)
                        CreateByteField (Local0, 0x06, UM6)
                        Store (TM0, ^^STM0)
                        Store (TM1, ^^STM1)
                        Store (UDC, ^^SUDC)
                        Store (AST, ^^SAST)
                        Store (CBT, ^^SCBT)
                        Store (UM6, ^^SUM6)
                        If (U66)
                        {
                            Store (U66, ^^U66E)
                        }

                        Store (0x55, ^^SFTH)
                    }

                    Device (MSTR)
                    {
                        Name (_ADR, 0x00)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Store ("GTF - Secondary Slave", Debug)
                            Store (^^^GTF0 (^^^SCHE, ^^^SUDC, ^^^STM0, ^^^SUM6), Local0)
                            Return (Local0)
                        }
                    }
                }
            }

            Device (USB0)
            {
                Name (_ADR, 0x00020000)
                Name (_S3D, 0x02)
                Name (_PR0, Package (0x01)
                {
                    \_SB.PCI0.LPC.EC.PUBS
                })
                Name (_PR1, Package (0x01)
                {
                    \_SB.PCI0.LPC.EC.PUBS
                })
                Name (_PR2, Package (0x01)
                {
                    \_SB.PCI0.LPC.EC.PUBS
                })
                Name (_PRW, Package (0x03)
                {
                    0x0B, 
                    0x03, 
                    \_SB.PCI0.LPC.EC.PUBS
                })
                Method (_PSW, 1, NotSerialized)
                {
                    Noop
                }
            }

            Device (AC97)
            {
                Name (_ADR, 0x00030000)
                Name (_S3D, 0x03)
                Name (_PRW, Package (0x02)
                {
                    0x09, 
                    0x04
                })
                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x01, \LAUX)
                    }
                    Else
                    {
                        Store (0x00, \LAUX)
                    }
                }
            }

            Device (LAN)
            {
                Name (_ADR, 0x000B0000)
                Name (_S3D, 0x03)
                Name (_PRW, Package (0x02)
                {
                    0x09, 
                    0x04
                })
                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x02, \LAUX)
                    }
                    Else
                    {
                        Store (0x00, \LAUX)
                    }
                }
            }
        }

        Scope (EC)
        {
            Method (_Q1C, 0, NotSerialized)
            {
                \CMS (0x00)
            }

            Method (_Q1D, 0, NotSerialized)
            {
                \CMS (0x01)
            }

            Method (_Q1E, 0, NotSerialized)
            {
                \CMS (0x02)
            }
        }

        Scope (EC)
        {
            Method (_Q14, 0, NotSerialized)
            {
                \CMS (0x04)
            }

            Method (_Q15, 0, NotSerialized)
            {
                \CMS (0x05)
            }
        }

        Scope (EC)
        {
            Method (_Q19, 0, NotSerialized)
            {
                \CMS (0x03)
            }
        }

        Scope (EC)
        {
            Method (_Q63, 0, NotSerialized)
            {
                \CMS (0x0B)
            }
        }

        Scope (EC)
        {
            Method (_Q70, 0, NotSerialized)
            {
                FNST ()
            }

            Method (_Q72, 0, NotSerialized)
            {
                FNST ()
            }

            Method (_Q73, 0, NotSerialized)
            {
                FNST ()
            }

            Method (FNST, 0, NotSerialized)
            {
                If (\H8DR)
                {
                    Store (HFNS, Local0)
                    Store (HFNE, Local1)
                }
                Else
                {
                    And (\RBEC (0x0E), 0x03, Local0)
                    And (\RBEC (0x00), 0x08, Local1)
                }

                If (Local1)
                {
                    If (LEqual (Local0, 0x00))
                    {
                        \CMS (0x11)
                    }

                    If (LEqual (Local0, 0x01))
                    {
                        \CMS (0x0F)
                    }

                    If (LEqual (Local0, 0x02))
                    {
                        \CMS (0x10)
                    }
                }
            }
        }
    }

    Name (_S0, Package (0x04)
    {
        0x00, 
        0x00, 
        0x00, 
        0x00
    })
    Name (_S3, Package (0x04)
    {
        0x03, 
        0x03, 
        0x00, 
        0x00
    })
    Name (_S4, Package (0x04)
    {
        0x04, 
        0x04, 
        0x00, 
        0x00
    })
    Name (_S5, Package (0x04)
    {
        0x05, 
        0x05, 
        0x00, 
        0x00
    })
    Method (_PTS, 1, NotSerialized)
    {
        Store (0x01, Local0)
        If (LEqual (Arg0, \SPS))
        {
            Store (0x00, Local0)
        }

        If (LOr (LEqual (Arg0, 0x00), LNot (LLess (Arg0, 0x06))))
        {
            Store (0x00, Local0)
        }

        If (Local0)
        {
            Store (Arg0, \SPS)
            \_SB.PCI0.LPC.EC.HKEY.MHKE (0x00)
            If (\_SB.PCI0.LPC.EC.KBLT) {}
            If (LEqual (Arg0, 0x01))
            {
                Store (\_SB.PCI0.LPC.EC.HFNI, \FNID)
                Store (0x00, \_SB.PCI0.LPC.EC.HFNI)
                Store (0x00, \_SB.PCI0.LPC.EC.HFSP)
                If (H8DR)
                {
                    Store (0x02, \_SB.PCI0.LPC.EC.SSTA)
                }
                Else
                {
                    MBEC (0x90, 0xF8, 0x02)
                }
            }

            If (LEqual (Arg0, 0x02))
            {
                If (H8DR)
                {
                    Store (0x03, \_SB.PCI0.LPC.EC.SSTA)
                }
                Else
                {
                    MBEC (0x90, 0xF8, 0x03)
                }
            }

            If (LEqual (Arg0, 0x03))
            {
                If (H8DR)
                {
                    Store (0x04, \_SB.PCI0.LPC.EC.SSTA)
                }
                Else
                {
                    MBEC (0x90, 0xF8, 0x04)
                }
            }

            If (LEqual (Arg0, 0x04))
            {
                \_SB.SLPB._PSW (0x00)
                If (\SPEN)
                {
                    \STEP (0x07)
                }

                If (H8DR)
                {
                    Store (0x05, \_SB.PCI0.LPC.EC.SSTA)
                }
                Else
                {
                    MBEC (0x90, 0xF8, 0x05)
                }

                \TRAP ()
            }

            If (LEqual (Arg0, 0x05)) {}
            If (LNot (LEqual (Arg0, 0x05)))
            {
                Store (0x01, \_SB.PCI0.LPC.EC.HCMU)
                If (\W98F)
                {
                    \CBRI ()
                }
            }
        }
    }

    Name (WAKI, Package (0x02)
    {
        0x00, 
        0x00
    })
    Method (_WAK, 1, NotSerialized)
    {
        If (LOr (LEqual (Arg0, 0x00), LNot (LLess (Arg0, 0x05))))
        {
            Return (WAKI)
        }

        Store (0x00, \SPS)
        Store (0x00, \_SB.PCI0.LPC.EC.HCMU)
        Store (0x80, \_SB.PCI0.LPC.EC.HFSP)
        \_SB.PCI0.LPC.EC.EVNT (0x01)
        \_SB.PCI0.LPC.EC.HKEY.MHKE (0x01)
        \_SB.PCI0.LPC.EC.FNST ()
        If (LEqual (Arg0, 0x01))
        {
            Store (\_SB.PCI0.LPC.EC.HFNI, \FNID)
        }

        If (LEqual (0x01, \WNTF))
        {
            Notify (\_SB.PCI0.USB0, 0x00)
        }

        If (LEqual (Arg0, 0x04))
        {
            If (\W98F)
            {
                Notify (\_SB.SLPB, 0x02)
            }

            If (\WMEF)
            {
                \_SB.PCI0.LPC.EC.BEEP (0x05)
            }

            If (LNot (\W98F))
            {
                Store (0x00, \_SB.PCI0.LPC.EC.HSPA)
            }

            If (\SPEN)
            {
                \STEP (0x08)
            }
        }

        Notify (\_TZ.THM0, 0x80)
        \VSLD (\_SB.LID._LID ())
        If (LAnd (\W98F, LNot (\WMEF)))
        {
            Notify (\_SB.PCI0.USB0, 0x00)
        }

        If (LLess (Arg0, 0x04))
        {
            If (And (\RRBF, 0x02))
            {
                ShiftLeft (Arg0, 0x08, Local0)
                Store (Or (0x2013, Local0), Local0)
                \_SB.PCI0.LPC.EC.HKEY.MHKQ (Local0)
            }
        }

        Store (Zero, \RRBF)
        If (H8DR)
        {
            Store (0x01, \_SB.PCI0.LPC.EC.SSTA)
        }
        Else
        {
            MBEC (0x90, 0xF8, 0x01)
        }

        Return (WAKI)
    }

    Scope (_SI)
    {
        Method (_SST, 1, NotSerialized)
        {
            If (LEqual (Arg0, 0x00))
            {
                \_SB.PCI0.LPC.EC.LED (0x00, 0x00)
                \_SB.PCI0.LPC.EC.LED (0x07, 0x00)
            }

            If (LEqual (Arg0, 0x01))
            {
                If (LOr (\SPS, \WNTF))
                {
                    \_SB.PCI0.LPC.EC.BEEP (0x05)
                }

                \_SB.PCI0.LPC.EC.LED (0x00, 0x80)
                \_SB.PCI0.LPC.EC.LED (0x07, 0x00)
            }

            If (LEqual (Arg0, 0x02))
            {
                \_SB.PCI0.LPC.EC.LED (0x00, 0x80)
                \_SB.PCI0.LPC.EC.LED (0x07, 0xC0)
            }

            If (LEqual (Arg0, 0x03))
            {
                If (LGreater (\SPS, 0x03))
                {
                    \_SB.PCI0.LPC.EC.BEEP (0x07)
                }
                Else
                {
                    If (LEqual (\SPS, 0x03))
                    {
                        \_SB.PCI0.LPC.EC.BEEP (0x03)
                    }
                    Else
                    {
                        \_SB.PCI0.LPC.EC.BEEP (0x04)
                    }
                }

                If (LEqual (\SPS, 0x03))
                {
                    \_SB.PCI0.LPC.EC.LED (0x00, 0x00)
                }
                Else
                {
                    \_SB.PCI0.LPC.EC.LED (0x00, 0x80)
                }

                \_SB.PCI0.LPC.EC.LED (0x07, 0x80)
            }

            If (LEqual (Arg0, 0x04))
            {
                \_SB.PCI0.LPC.EC.BEEP (0x03)
                \_SB.PCI0.LPC.EC.LED (0x07, 0xC0)
            }
        }
    }

    Scope (_GPE)
    {
        Method (_L03, 0, NotSerialized)
        {
            Store (\_SB.PCI0.LPC.EC.HWAK, Local0)
            Store (Local0, \RRBF)
            Sleep (0x0A)
            If (And (Local0, 0x8000))
            {
                Notify (\_SB.SLPB, 0x02)
            }

            If (And (Local0, 0x02)) {}
            If (And (Local0, 0x04))
            {
                If (\W98F)
                {
                    Notify (\_SB.SLPB, 0x02)
                }
                Else
                {
                    Notify (\_SB.LID, 0x02)
                }
            }

            If (And (Local0, 0x08))
            {
                Notify (\_SB.SLPB, 0x02)
            }

            If (And (Local0, 0x10))
            {
                Notify (\_SB.SLPB, 0x02)
            }

            If (And (Local0, 0x40)) {}
            If (And (Local0, 0x80))
            {
                Notify (\_SB.SLPB, 0x02)
            }
        }

        Method (_L09, 0, NotSerialized)
        {
            Notify (\_SB.PCI0, 0x02)
        }
    }

    Scope (_TZ)
    {
        ThermalZone (THM0)
        {
            Name (_PSL, Package (0x01)
            {
                \_PR.CPU
            })
            Method (_CRT, 0, NotSerialized)
            {
                Return (\TCRT)
            }

            Method (_PSV, 0, NotSerialized)
            {
                Return (\TPSV)
            }

            Method (_TC1, 0, NotSerialized)
            {
                Return (\TTC1)
            }

            Method (_TC2, 0, NotSerialized)
            {
                Return (\TTC2)
            }

            Method (_TSP, 0, NotSerialized)
            {
                Return (\TTSP)
            }

            Method (_TMP, 0, NotSerialized)
            {
                If (\H8DR)
                {
                    Store (\_SB.PCI0.LPC.EC.TMP0, Local0)
                    Store (\_SB.PCI0.LPC.EC.HT12, Local1)
                }
                Else
                {
                    Store (\RBEC (0x78), Local0)
                    Store (And (\RBEC (0x20), 0x40), Local1)
                }

                If (Local1)
                {
                    Add (\TCRT, 0x01, Local0)
                    Return (Local0)
                }

                Return (C2K (Local0))
            }
        }

        Method (C2K, 1, NotSerialized)
        {
            Add (Multiply (Arg0, 0x0A), 0x0AAC, Local0)
            If (LNot (LGreater (Local0, 0x0AAC)))
            {
                Store (0x0BB8, Local0)
            }

            If (LNot (LLess (Local0, 0x0FAC)))
            {
                Store (0x0BB8, Local0)
            }

            Return (Local0)
        }
    }

    Scope (EC)
    {
        Method (_Q40, 0, NotSerialized)
        {
            Notify (\_TZ.THM0, 0x80)
            If (\SPEN)
            {
                If (\OSPX)
                {
                    Notify (\_PR.CPU, 0x80)
                }
                Else
                {
                    If (LOr (\_SB.PCI0.LPC.EC.HT00, \_SB.PCI0.LPC.EC.HT10))
                    {
                        \STEP (0x04)
                    }
                    Else
                    {
                        \STEP (0x06)
                    }
                }
            }
        }
    }

    OperationRegion (MNVS, SystemMemory, 0x1EF7D000, 0x1000)
    Field (MNVS, DWordAcc, NoLock, Preserve)
    {
        Offset (0xF00), 
        GAPA,   32, 
        GAPL,   32, 
        DCKI,   32, 
        DCKS,   32, 
        VCDL,   1, 
        VCDC,   1, 
        VCDT,   1, 
        VCDD,   1, 
            ,   1, 
        VCSS,   1, 
        VCDB,   1, 
        VCIN,   1, 
        Offset (0xF12), 
        VLID,   4, 
        Offset (0xF14), 
        CDFL,   8, 
        CDAH,   8, 
        PMOD,   2, 
        PDIR,   1, 
        PDMA,   1, 
        Offset (0xF17), 
        LFDC,   1, 
        LCMA,   1, 
        LCMB,   1, 
        LCMC,   1, 
        LLPT,   1, 
        LAUX,   2, 
        Offset (0xF18), 
        C2NA,   1, 
        C3NA,   1, 
        C4NA,   1, 
        Offset (0xF19), 
        SPEN,   1, 
            ,   1, 
            ,   1, 
            ,   1, 
        Offset (0xF1A), 
        OSPX,   1, 
        OSC4,   1, 
        Offset (0xF1B), 
        UOPT,   8, 
        BTID,   32, 
        P0FQ,   16, 
        P0PW,   16, 
        P1FQ,   16, 
        P1PW,   16, 
        TCRT,   16, 
        TPSV,   16, 
        TTC1,   16, 
        TTC2,   16, 
        TTSP,   16
    }

    Field (MNVS, ByteAcc, NoLock, Preserve)
    {
        Offset (0xE00), 
        DDC1,   1024, 
        Offset (0xF00)
    }

    Field (MNVS, ByteAcc, NoLock, Preserve)
    {
        Offset (0xE00), 
        DDC2,   2048
    }

    OperationRegion (SMI0, SystemIO, 0xB1, 0x01)
    Field (SMI0, ByteAcc, NoLock, Preserve)
    {
        APMC,   8
    }

    Field (MNVS, AnyAcc, NoLock, Preserve)
    {
        Offset (0xFC0), 
        CMD,    8, 
        ERR,    32, 
        PAR0,   32, 
        PAR1,   32, 
        PAR2,   32, 
        PAR3,   32
    }

    Mutex (MSMI, 0x07)
    Method (SMI, 5, NotSerialized)
    {
        Acquire (MSMI, 0xFFFF)
        Store (Arg0, CMD)
        Store (Arg1, PAR0)
        Store (Arg2, PAR1)
        Store (Arg3, PAR2)
        Store (Arg4, PAR3)
        Store (0xF5, APMC)
        While (LEqual (ERR, 0x01))
        {
            Sleep (0x64)
            Store (0xF5, APMC)
        }

        Store (PAR0, Local0)
        Release (MSMI)
        Return (Local0)
    }

    Method (RPCI, 1, NotSerialized)
    {
        Return (SMI (0x00, 0x00, Arg0, 0x00, 0x00))
    }

    Method (WPCI, 2, NotSerialized)
    {
        SMI (0x00, 0x01, Arg0, Arg1, 0x00)
    }

    Method (MPCI, 3, NotSerialized)
    {
        SMI (0x00, 0x02, Arg0, Arg1, Arg2)
    }

    Method (RBEC, 1, NotSerialized)
    {
        Return (SMI (0x00, 0x03, Arg0, 0x00, 0x00))
    }

    Method (WBEC, 2, NotSerialized)
    {
        SMI (0x00, 0x04, Arg0, Arg1, 0x00)
    }

    Method (MBEC, 3, NotSerialized)
    {
        SMI (0x00, 0x05, Arg0, Arg1, Arg2)
    }

    Method (RISA, 1, NotSerialized)
    {
        Return (SMI (0x00, 0x06, Arg0, 0x00, 0x00))
    }

    Method (WISA, 2, NotSerialized)
    {
        SMI (0x00, 0x07, Arg0, Arg1, 0x00)
    }

    Method (MISA, 3, NotSerialized)
    {
        SMI (0x00, 0x08, Arg0, Arg1, Arg2)
    }

    Method (WECC, 1, NotSerialized)
    {
        SMI (0x00, 0x09, Arg0, 0x00, 0x00)
    }

    Method (RECD, 1, NotSerialized)
    {
        Return (SMI (0x00, 0x0A, Arg0, 0x00, 0x00))
    }

    Method (WECD, 2, NotSerialized)
    {
        SMI (0x00, 0x0B, Arg0, Arg1, 0x00)
    }

    Method (MECD, 3, NotSerialized)
    {
        SMI (0x00, 0x0C, Arg0, Arg1, Arg2)
    }

    Method (WEDC, 1, NotSerialized)
    {
        SMI (0x00, 0x0D, Arg0, 0x00, 0x00)
    }

    Method (REDR, 1, NotSerialized)
    {
        Return (SMI (0x00, 0x0E, Arg0, 0x00, 0x00))
    }

    Method (WEDR, 2, NotSerialized)
    {
        SMI (0x00, 0x0F, Arg0, Arg1, 0x00)
    }

    Method (MEDR, 3, NotSerialized)
    {
        SMI (0x00, 0x10, Arg0, Arg1, Arg2)
    }

    Method (VEXP, 0, NotSerialized)
    {
        SMI (0x01, 0x00, 0x00, 0x00, 0x00)
    }

    Method (VUPS, 1, NotSerialized)
    {
        SMI (0x01, 0x01, Arg0, 0x00, 0x00)
    }

    Method (VSDS, 2, NotSerialized)
    {
        SMI (0x01, 0x02, Arg0, Arg1, 0x00)
    }

    Method (VDDC, 0, NotSerialized)
    {
        SMI (0x01, 0x03, 0x00, 0x00, 0x00)
    }

    Method (VVPD, 1, NotSerialized)
    {
        SMI (0x01, 0x04, Arg0, 0x00, 0x00)
    }

    Method (VNRS, 1, NotSerialized)
    {
        SMI (0x01, 0x05, Arg0, 0x00, 0x00)
    }

    Method (GLPW, 0, NotSerialized)
    {
        Return (SMI (0x01, 0x06, 0x00, 0x00, 0x00))
    }

    Method (VSLD, 1, NotSerialized)
    {
        SMI (0x01, 0x07, Arg0, 0x00, 0x00)
    }

    Method (VEVT, 1, NotSerialized)
    {
        Return (SMI (0x01, 0x08, Arg0, 0x00, 0x00))
    }

    Method (CMS, 1, NotSerialized)
    {
        Return (SMI (0x02, Arg0, 0x00, 0x00, 0x00))
    }

    Method (BHDP, 2, NotSerialized)
    {
        Return (SMI (0x03, 0x00, Arg0, Arg1, 0x00))
    }

    Method (DHDP, 1, NotSerialized)
    {
        Return (SMI (0x03, 0x01, Arg0, 0x00, 0x00))
    }

    Method (STEP, 1, NotSerialized)
    {
        SMI (0x04, Arg0, 0x00, 0x00, 0x00)
    }

    Method (TRAP, 0, NotSerialized)
    {
        SMI (0x05, 0x00, 0x00, 0x00, 0x00)
    }

    Method (CBRI, 0, NotSerialized)
    {
        SMI (0x05, 0x01, 0x00, 0x00, 0x00)
    }

    Method (DPIO, 2, NotSerialized)
    {
        If (LNot (Arg0))
        {
            Return (0x00)
        }

        If (LGreater (Arg0, 0xF0))
        {
            Return (0x00)
        }

        If (LGreater (Arg0, 0xB4))
        {
            If (Arg1)
            {
                Return (0x02)
            }
            Else
            {
                Return (0x01)
            }
        }

        If (LGreater (Arg0, 0x78))
        {
            Return (0x03)
        }

        Return (0x04)
    }

    Method (DUDM, 2, NotSerialized)
    {
        If (LNot (Arg1))
        {
            Return (0xFF)
        }

        If (LGreater (Arg0, 0x5A))
        {
            Return (0x00)
        }

        If (LGreater (Arg0, 0x3C))
        {
            Return (0x01)
        }

        If (LGreater (Arg0, 0x2D))
        {
            Return (0x02)
        }

        If (LGreater (Arg0, 0x1E))
        {
            Return (0x03)
        }

        If (LGreater (Arg0, 0x14))
        {
            Return (0x04)
        }

        Return (0x05)
    }

    Method (DMDM, 2, NotSerialized)
    {
        If (Arg1)
        {
            Return (0x00)
        }

        If (LNot (Arg0))
        {
            Return (0x00)
        }

        If (LGreater (Arg0, 0x96))
        {
            Return (0x01)
        }

        If (LGreater (Arg0, 0x78))
        {
            Return (0x02)
        }

        Return (0x03)
    }

    Method (UUDM, 2, NotSerialized)
    {
        If (LNot (And (Arg0, 0x04)))
        {
            Return (0x00)
        }

        If (And (Arg1, 0x20))
        {
            Return (0x14)
        }

        If (And (Arg1, 0x10))
        {
            Return (0x1E)
        }

        If (And (Arg1, 0x08))
        {
            Return (0x2D)
        }

        If (And (Arg1, 0x04))
        {
            Return (0x3C)
        }

        If (And (Arg1, 0x02))
        {
            Return (0x5A)
        }

        If (And (Arg1, 0x01))
        {
            Return (0x78)
        }

        Return (0x00)
    }

    Method (UMDM, 4, NotSerialized)
    {
        If (LNot (And (Arg0, 0x02)))
        {
            Return (0x00)
        }

        If (And (Arg1, 0x04))
        {
            Return (Arg3)
        }

        If (And (Arg1, 0x02))
        {
            If (LNot (LGreater (Arg3, 0x78)))
            {
                Return (0xB4)
            }
            Else
            {
                Return (Arg3)
            }
        }

        If (And (Arg2, 0x04))
        {
            If (LNot (LGreater (Arg3, 0xB4)))
            {
                Return (0xF0)
            }
            Else
            {
                Return (Arg3)
            }
        }

        Return (0x00)
    }

    Method (UPIO, 4, NotSerialized)
    {
        If (LNot (And (Arg0, 0x02)))
        {
            If (LEqual (Arg2, 0x02))
            {
                Return (0xF0)
            }
            Else
            {
                Return (0x0384)
            }
        }

        If (And (Arg1, 0x02))
        {
            Return (Arg3)
        }

        If (And (Arg1, 0x01))
        {
            If (LNot (LGreater (Arg3, 0x78)))
            {
                Return (0xB4)
            }
            Else
            {
                Return (Arg3)
            }
        }

        If (LEqual (Arg2, 0x02))
        {
            Return (0xF0)
        }
        Else
        {
            Return (0x0384)
        }
    }

    Method (FDMA, 2, NotSerialized)
    {
        If (LNot (LEqual (Arg1, 0xFF)))
        {
            Return (Or (Arg1, 0x40))
        }

        If (LNot (LLess (Arg0, 0x03)))
        {
            Return (Or (Subtract (Arg0, 0x02), 0x20))
        }

        If (Arg0)
        {
            Return (0x12)
        }

        Return (0x00)
    }

    Method (FPIO, 1, NotSerialized)
    {
        If (LNot (LLess (Arg0, 0x03)))
        {
            Return (Or (Arg0, 0x08))
        }

        If (LEqual (Arg0, 0x01))
        {
            Return (0x01)
        }

        Return (0x00)
    }

    Method (SCMP, 2, NotSerialized)
    {
        Store (SizeOf (Arg0), Local0)
        If (LNot (LEqual (Local0, SizeOf (Arg1))))
        {
            Return (One)
        }

        Increment (Local0)
        Name (STR1, Buffer (Local0) {})
        Name (STR2, Buffer (Local0) {})
        Store (Arg0, STR1)
        Store (Arg1, STR2)
        Store (Zero, Local1)
        While (LLess (Local1, Local0))
        {
            Store (DerefOf (Index (STR1, Local1)), Local2)
            Store (DerefOf (Index (STR2, Local1)), Local3)
            If (LNot (LEqual (Local2, Local3)))
            {
                Return (One)
            }

            Increment (Local1)
        }

        Return (Zero)
    }

    Name (SPS, 0x00)
    Name (OSIF, 0x00)
    Name (W98F, 0x00)
    Name (WNTF, 0x00)
    Name (WMEF, 0x00)
    Name (LNUX, 0x00)
    Name (H8DR, 0x00)
    Name (MEMX, 0x00)
    Name (FNID, 0x00)
    Name (RRBF, 0x00)
}

