/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20121114-32 [Jan 18 2013]
 * Copyright (c) 2000 - 2012 Intel Corporation
 * 
 * Disassembly of (null), Tue Feb 26 18:06:56 2013
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x000058BE (22718)
 *     Revision         0x01 **** 32-bit table (V1), no 64-bit math support
 *     Checksum         0x86
 *     OEM ID           "NVIDIA"
 *     OEM Table ID     "CK8"
 *     OEM Revision     0x06040000 (100925440)
 *     Compiler ID      "MSFT"
 *     Compiler Version 0x0100000E (16777230)
 */

DefinitionBlock ("DSDT.aml", "DSDT", 1, "NVIDIA", "CK8", 0x06040000)
{
    Name (_S0, Package (0x04)  // _S0_: S0 System State
    {
        0x00, 
        0x00, 
        0x00, 
        0x00
    })
    Name (_S1, Package (0x04)  // _S1_: S1 System State
    {
        0x01, 
        0x01, 
        0x00, 
        0x00
    })
    Name (RZ_X, Package (0x04)
    {
        0x05, 
        0x05, 
        0x00, 
        0x00
    })
    Name (_S4, Package (0x04)  // _S4_: S4 System State
    {
        0x06, 
        0x06, 
        0x00, 
        0x00
    })
    Name (_S5, Package (0x04)  // _S5_: S5 System State
    {
        0x07, 
        0x07, 
        0x00, 
        0x00
    })
    Name (SX, 0x00)
    Method (\_PTS, 1, NotSerialized)  // _PTS: Prepare To Sleep
    {
        Or (Arg0, 0xF0, Local0)
        Store (Local0, DBUG)
        If (LLess (Arg0, 0x04))
        {
            \_SB.PCI0.SIO.ENWK ()
        }
    }

    Method (\_WAK, 1, NotSerialized)  // _WAK: Wake
    {
        Or (Arg0, 0xD0, Local0)
        Store (Local0, DBUG)
        \_SB.PCI0.SIO.DSWK ()
    }

    Scope (\_PR)
    {
        Processor (CPU0, 0x00, 0x00008010, 0x06) {}
        Processor (CPU1, 0x01, 0x00000000, 0x00) {}
        Processor (CPU2, 0x02, 0x00000000, 0x00) {}
        Processor (CPU3, 0x03, 0x00000000, 0x00) {}
    }

    Scope (\_SI)
    {
        Method (_SST, 1, NotSerialized)  // _SST: System Status
        {
            Store ("==== SST Working ====", Debug)
        }

        Method (_MSG, 1, NotSerialized)  // _MSG: Message
        {
        }
    }

    Scope (\_GPE)
    {
        Method (_L00, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PWRB, 0x02)
            Notify (\_SB.PCI0.P2P0, 0x02)
            Notify (\_SB.PCI1.MAC0, 0x02)
        }

        Method (_L05, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.USB2, 0x02)
        }

        Method (_L0B, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PWRB, 0x02)
            Notify (\_SB.PCI0.MAC0, 0x02)
        }

        Method (_L0D, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.USB0, 0x02)
        }

        Method (_L10, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PWRB, 0x02)
            Notify (\_SB.PCI0.PS2K, 0x02)
        }
    }

    Scope (\_SB)
    {
        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))  // _HID: Hardware ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                Return (0x0B)
            }
        }

        Device (MEM0)
        {
            Name (_HID, EisaId ("PNP0C01"))  // _HID: Hardware ID
            Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
            {
                Name (MEMR, ResourceTemplate ()
                {
                    Memory32Fixed (ReadOnly,
                        0xFFC00000,         // Address Base
                        0x00400000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0xFEC00000,         // Address Base
                        0x00001000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0xFEE00000,         // Address Base
                        0x00100000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x00000000,         // Address Length
                        _Y00)
                })
                CreateDWordField (MEMR, \_SB.MEM0._CRS._Y00._BAS, MBAS)  // _BAS: Base Address
                CreateDWordField (MEMR, \_SB.MEM0._CRS._Y00._LEN, MBLE)  // _LEN: Length
                If (\_SB.PCI0.LPC0.MTBA)
                {
                    Store (\_SB.PCI0.LPC0.MTBA, MBAS)
                    Store (0x1000, MBLE)
                }

                Return (MEMR)
            }
        }

        Device (PCI0)
        {
            Name (_ADR, 0x00)  // _ADR: Address
            Name (_HID, EisaId ("PNP0A03"))  // _HID: Hardware ID
            Name (_UID, 0x01)  // _UID: Unique ID
            Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
            {
                Return (0x01)
            }

            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                Return (0x0F)
            }

            Scope (\_SB)
            {
                OperationRegion (ASLD, SystemMemory, 0x7FF91D04, 0x00000100)
                Field (ASLD, AnyAcc, NoLock, Preserve)
                {
                    TOM,    32, 
                    R_ST,   1, 
                        ,   3, 
                    R_P0,   4, 
                    R_S0,   4, 
                    R_S1,   4
                }
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                Name (CBUF, ResourceTemplate ()
                {
                    WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                        0x0000,             // Granularity
                        0x0000,             // Range Minimum
                        0x000F,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x0010,             // Length
                        ,, )
                    IO (Decode16,
                        0x0CF8,             // Range Minimum
                        0x0CF8,             // Range Maximum
                        0x01,               // Alignment
                        0x08,               // Length
                        )
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x0000,             // Range Minimum
                        0x03AF,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x03B0,             // Length
                        0x00,, _Y04, TypeStatic)
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x03E0,             // Range Minimum
                        0x0CF7,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x0918,             // Length
                        0x00,, , TypeStatic)
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x0D00,             // Range Minimum
                        0xFFFF,             // Range Maximum
                        0x0000,             // Translation Offset
                        0xF300,             // Length
                        ,, _Y01, TypeStatic)
                    DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                        0x00000000,         // Granularity
                        0x000A0000,         // Range Minimum
                        0x000DFFFF,         // Range Maximum
                        0x00000000,         // Translation Offset
                        0x00040000,         // Length
                        ,, _Y03, AddressRangeMemory, TypeStatic)
                    DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                        0x00000000,         // Granularity
                        0x00000000,         // Range Minimum
                        0x00000000,         // Range Maximum
                        0x00000000,         // Translation Offset
                        0x00000000,         // Length
                        ,, _Y02, AddressRangeMemory, TypeStatic)
                })
                CreateWordField (CBUF, \_SB.PCI0._CRS._Y01._MIN, PIMN)  // _MIN: Minimum Base Address
                CreateWordField (CBUF, \_SB.PCI0._CRS._Y01._LEN, PILN)  // _LEN: Length
                CreateWordField (CBUF, \_SB.PCI0._CRS._Y01._MAX, PIMX)  // _MAX: Maximum Base Address
                CreateDWordField (CBUF, \_SB.PCI0._CRS._Y02._MIN, PMMN)  // _MIN: Minimum Base Address
                CreateDWordField (CBUF, \_SB.PCI0._CRS._Y02._LEN, PMLN)  // _LEN: Length
                CreateDWordField (CBUF, \_SB.PCI0._CRS._Y02._MAX, PMMX)  // _MAX: Maximum Base Address
                CreateDWordField (CBUF, \_SB.PCI0._CRS._Y03._MIN, VMMN)  // _MIN: Minimum Base Address
                CreateDWordField (CBUF, \_SB.PCI0._CRS._Y03._LEN, VMLN)  // _LEN: Length
                CreateDWordField (CBUF, \_SB.PCI0._CRS._Y03._MAX, VMMX)  // _MAX: Maximum Base Address
                If (LEqual (\_SB.PCI0.K801.PML1, 0x00))
                {
                    And (\_SB.PCI0.K801.PMB0, 0xFFFFFF00, Local0)
                    Multiply (Local0, 0x0100, PMMN)
                    ShiftLeft (\_SB.PCI0.K801.PML0, 0x08, Local0)
                    Or (Local0, 0xFFFF, PMMX)
                    Subtract (PMMX, PMMN, PMLN)
                    Increment (PMLN)
                }
                Else
                {
                    If (LEqual (And (\_SB.PCI0.K801.PML1, 0xFFFFFF00), 0x0B00))
                    {
                        And (\_SB.PCI0.K801.PMB0, 0xFFFFFF00, Local0)
                        Multiply (Local0, 0x0100, PMMN)
                        ShiftLeft (\_SB.PCI0.K801.PML0, 0x08, Local0)
                        Or (Local0, 0xFFFF, PMMX)
                        Subtract (PMMX, PMMN, PMLN)
                        Increment (PMLN)
                    }
                    Else
                    {
                        If (LEqual (And (\_SB.PCI0.K801.PML1, 0xFF), 0x80))
                        {
                            And (\_SB.PCI0.K801.PMB0, 0xFFFFFF00, Local0)
                            Multiply (Local0, 0x0100, PMMN)
                            ShiftLeft (\_SB.PCI0.K801.PML0, 0x08, Local0)
                            Or (Local0, 0xFFFF, PMMX)
                            Subtract (PMMX, PMMN, PMLN)
                            Increment (PMLN)
                        }
                        Else
                        {
                            And (\_SB.PCI0.K801.PMB0, 0xFFFFFF00, Local0)
                            Multiply (Local0, 0x0100, PMMN)
                            ShiftLeft (\_SB.PCI0.K801.PML1, 0x08, Local0)
                            Or (Local0, 0xFFFF, PMMX)
                            Subtract (PMMX, PMMN, PMLN)
                            Increment (PMLN)
                        }
                    }
                }

                If (LNotEqual (\_SB.PCI0.K801.PML4, 0x0B00))
                {
                    Store (0x000C0000, VMMN)
                    Store (0x00020000, VMLN)
                }

                Store (0x0D00, PIMN)
                Or (\_SB.PCI0.K801.PIL0, 0x0FFF, PIMX)
                Subtract (PIMX, PIMN, PILN)
                Increment (PILN)
                CreateWordField (CBUF, \_SB.PCI0._CRS._Y04._MIN, IOMN)  // _MIN: Minimum Base Address
                CreateWordField (CBUF, \_SB.PCI0._CRS._Y04._LEN, IOLN)  // _LEN: Length
                CreateWordField (CBUF, \_SB.PCI0._CRS._Y04._MAX, IOMX)  // _MAX: Maximum Base Address
                If (LEqual (\_SB.PCI0.K801.PML4, 0x0B00))
                {
                    Store (0x03DF, IOMX)
                    Store (0x03E0, IOLN)
                }

                Return (CBUF)
            }

            Name (_PRT, Package (0x0A)  // _PRT: PCI Routing Table
            {
                Package (0x04)
                {
                    0x0001FFFF, 
                    0x00, 
                    \_SB.PCI0.LSMB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0001FFFF, 
                    0x01, 
                    \_SB.PCI0.LSMB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x00, 
                    \_SB.PCI0.LUS0, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x01, 
                    \_SB.PCI0.LUS2, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000AFFFF, 
                    0x00, 
                    \_SB.PCI0.LMAC, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x00, 
                    \_SB.PCI0.LACI, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x01, 
                    \_SB.PCI0.LMCI, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0006FFFF, 
                    0x00, 
                    \_SB.PCI0.LPID, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x00, 
                    \_SB.PCI0.LTID, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0008FFFF, 
                    0x00, 
                    \_SB.PCI0.LSI1, 
                    0x00
                }
            })
            Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
            {
                0x00, 
                0x05
            })
            Device (LPC0)
            {
                Name (_ADR, 0x00010000)  // _ADR: Address
                OperationRegion (P60, PCI_Config, 0x60, 0x02)
                Field (P60, AnyAcc, NoLock, Preserve)
                {
                    PMBR,   16
                }

                OperationRegion (P64, PCI_Config, 0x64, 0x02)
                Field (P64, AnyAcc, NoLock, Preserve)
                {
                    NVSB,   16
                }

                OperationRegion (P68, PCI_Config, 0x68, 0x02)
                Field (P68, AnyAcc, NoLock, Preserve)
                {
                    ANLG,   16
                }

                OperationRegion (P44, PCI_Config, 0x44, 0x04)
                Field (P44, AnyAcc, NoLock, Preserve)
                {
                    MTBA,   32
                }

                Device (PMIO)
                {
                    Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                    Name (_UID, 0x03)  // _UID: Unique ID
                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (IODM, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x00,               // Alignment
                                0x00,               // Length
                                )
                        })
                        Name (IORT, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x80,               // Length
                                _Y05)
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x80,               // Length
                                _Y06)
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x80,               // Length
                                _Y07)
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x80,               // Length
                                _Y08)
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x80,               // Length
                                _Y09)
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x80,               // Length
                                _Y0A)
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x40,               // Length
                                _Y0B)
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x40,               // Length
                                _Y0C)
                        })
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y05._MIN, I1MN)  // _MIN: Minimum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y05._MAX, I1MX)  // _MAX: Maximum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y06._MIN, I2MN)  // _MIN: Minimum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y06._MAX, I2MX)  // _MAX: Maximum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y07._MIN, I3MN)  // _MIN: Minimum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y07._MAX, I3MX)  // _MAX: Maximum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y08._MIN, I4MN)  // _MIN: Minimum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y08._MAX, I4MX)  // _MAX: Maximum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y09._MIN, I5MN)  // _MIN: Minimum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y09._MAX, I5MX)  // _MAX: Maximum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y0A._MIN, I6MN)  // _MIN: Minimum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y0A._MAX, I6MX)  // _MAX: Maximum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y0B._MIN, I7MN)  // _MIN: Minimum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y0B._MAX, I7MX)  // _MAX: Maximum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y0C._MIN, I8MN)  // _MIN: Minimum Base Address
                        CreateWordField (IORT, \_SB.PCI0.LPC0.PMIO._CRS._Y0C._MAX, I8MX)  // _MAX: Maximum Base Address
                        And (PMBR, 0xFFFC, I1MN)
                        Store (I1MN, I1MX)
                        Add (I1MN, 0x80, Local0)
                        Store (Local0, I2MN)
                        Store (Local0, I2MX)
                        And (NVSB, 0xFFFC, I3MN)
                        Store (I3MN, I3MX)
                        Add (I3MN, 0x80, Local0)
                        Store (Local0, I4MN)
                        Store (Local0, I4MX)
                        And (ANLG, 0xFFFC, I5MN)
                        Store (I5MN, I5MX)
                        Add (I5MN, 0x80, Local0)
                        Store (Local0, I6MN)
                        Store (Local0, I6MX)
                        And (\_SB.PCI0.SMB0.SB50, 0xFFFC, I7MN)
                        Store (I7MN, I7MX)
                        And (\_SB.PCI0.SMB0.SB54, 0xFFFC, I8MN)
                        Store (I8MN, I8MX)
                        If (I1MN)
                        {
                            Store (IORT, Local0)
                        }
                        Else
                        {
                            Store (IODM, Local0)
                        }

                        Return (Local0)
                    }
                }
            }

            Device (SYS0)
            {
                Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                Name (_UID, 0x01)  // _UID: Unique ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0010,             // Range Minimum
                        0x0010,             // Range Maximum
                        0x01,               // Alignment
                        0x10,               // Length
                        )
                    IO (Decode16,
                        0x0022,             // Range Minimum
                        0x0022,             // Range Maximum
                        0x01,               // Alignment
                        0x1E,               // Length
                        )
                    IO (Decode16,
                        0x0044,             // Range Minimum
                        0x0044,             // Range Maximum
                        0x01,               // Alignment
                        0x1C,               // Length
                        )
                    IO (Decode16,
                        0x0062,             // Range Minimum
                        0x0062,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x0065,             // Range Minimum
                        0x0065,             // Range Maximum
                        0x01,               // Alignment
                        0x0B,               // Length
                        )
                    IO (Decode16,
                        0x0072,             // Range Minimum
                        0x0072,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x0074,             // Range Minimum
                        0x0074,             // Range Maximum
                        0x01,               // Alignment
                        0x0C,               // Length
                        )
                    IO (Decode16,
                        0x0091,             // Range Minimum
                        0x0091,             // Range Maximum
                        0x01,               // Alignment
                        0x03,               // Length
                        )
                    IO (Decode16,
                        0x0097,             // Range Minimum
                        0x0097,             // Range Maximum
                        0x01,               // Alignment
                        0x09,               // Length
                        )
                    IO (Decode16,
                        0x00A2,             // Range Minimum
                        0x00A2,             // Range Maximum
                        0x01,               // Alignment
                        0x1E,               // Length
                        )
                    IO (Decode16,
                        0x00E0,             // Range Minimum
                        0x00E0,             // Range Maximum
                        0x01,               // Alignment
                        0x10,               // Length
                        )
                    IO (Decode16,
                        0x04D0,             // Range Minimum
                        0x04D0,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x0080,             // Range Minimum
                        0x0080,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x0400,             // Range Minimum
                        0x0400,             // Range Maximum
                        0x01,               // Alignment
                        0x5F,               // Length
                        )
                    IO (Decode16,
                        0x9000,             // Range Minimum
                        0x9000,             // Range Maximum
                        0x01,               // Alignment
                        0x80,               // Length
                        )
                    IO (Decode16,
                        0x9080,             // Range Minimum
                        0x9080,             // Range Maximum
                        0x01,               // Alignment
                        0x80,               // Length
                        )
                    IO (Decode16,
                        0x9200,             // Range Minimum
                        0x9200,             // Range Maximum
                        0x01,               // Alignment
                        0x80,               // Length
                        )
                    IO (Decode16,
                        0x9280,             // Range Minimum
                        0x9280,             // Range Maximum
                        0x01,               // Alignment
                        0x80,               // Length
                        )
                    IO (Decode16,
                        0x9400,             // Range Minimum
                        0x9400,             // Range Maximum
                        0x01,               // Alignment
                        0x80,               // Length
                        )
                    IO (Decode16,
                        0x9480,             // Range Minimum
                        0x9480,             // Range Maximum
                        0x01,               // Alignment
                        0x80,               // Length
                        )
                })
            }

            Device (PIC0)
            {
                Name (_HID, EisaId ("PNP0000"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0020,             // Range Minimum
                        0x0020,             // Range Maximum
                        0x04,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x00A0,             // Range Minimum
                        0x00A0,             // Range Maximum
                        0x04,               // Alignment
                        0x02,               // Length
                        )
                    IRQ (Edge, ActiveHigh, Exclusive, )
                        {2}
                })
            }

            Device (PIT0)
            {
                Name (_HID, EisaId ("PNP0100"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0040,             // Range Minimum
                        0x0040,             // Range Maximum
                        0x10,               // Alignment
                        0x04,               // Length
                        )
                    IRQ (Edge, ActiveHigh, Exclusive, )
                        {0}
                })
            }

            Device (DMA0)
            {
                Name (_HID, EisaId ("PNP0200"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x09,               // Length
                        )
                    IO (Decode16,
                        0x000A,             // Range Minimum
                        0x000A,             // Range Maximum
                        0x01,               // Alignment
                        0x06,               // Length
                        )
                    IO (Decode16,
                        0x0081,             // Range Minimum
                        0x0081,             // Range Maximum
                        0x01,               // Alignment
                        0x03,               // Length
                        )
                    IO (Decode16,
                        0x0087,             // Range Minimum
                        0x0087,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x0089,             // Range Minimum
                        0x0089,             // Range Maximum
                        0x01,               // Alignment
                        0x03,               // Length
                        )
                    IO (Decode16,
                        0x008F,             // Range Minimum
                        0x008F,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x00C0,             // Range Minimum
                        0x00C0,             // Range Maximum
                        0x01,               // Alignment
                        0x12,               // Length
                        )
                    IO (Decode16,
                        0x00D4,             // Range Minimum
                        0x00D4,             // Range Maximum
                        0x01,               // Alignment
                        0x0C,               // Length
                        )
                    DMA (Compatibility, BusMaster, Transfer8, )
                        {4}
                })
            }

            Device (SPK0)
            {
                Name (_HID, EisaId ("PNP0800"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0061,             // Range Minimum
                        0x0061,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                })
            }

            Device (RTC0)
            {
                Name (_HID, EisaId ("PNP0B00"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0070,             // Range Minimum
                        0x0070,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IRQ (Edge, ActiveHigh, Exclusive, )
                        {8}
                })
            }

            Device (MTH0)
            {
                Name (_HID, EisaId ("PNP0C04"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x00F0,             // Range Minimum
                        0x00F0,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IRQ (Edge, ActiveHigh, Exclusive, )
                        {13}
                })
            }

            Device (SIO)
            {
                Name (_HID, EisaId ("PNP0A05"))  // _HID: Hardware ID
                OperationRegion (SIBP, SystemIO, 0x2E, 0x02)
                Field (SIBP, ByteAcc, NoLock, Preserve)
                {
                    BPIO,   8
                }

                OperationRegion (SIIO, SystemIO, 0x2E, 0x02)
                Field (SIIO, ByteAcc, NoLock, Preserve)
                {
                    INDX,   8, 
                    DATA,   8
                }

                OperationRegion (LOGA, SystemIO, 0x0400, 0x50)
                Field (LOGA, ByteAcc, NoLock, Preserve)
                {
                    RUNT,   8, 
                    Offset (0x02), 
                    IOPM,   8, 
                    Offset (0x04), 
                    PSTS,   8, 
                    Offset (0x0A), 
                    PMEN,   8, 
                    Offset (0x4C), 
                        ,   7, 
                    H0PR,   1
                }

                IndexField (INDX, DATA, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x07), 
                    LDN,    8, 
                    Offset (0x22), 
                    POW,    8, 
                    Offset (0x30), 
                    ACT,    1, 
                    Offset (0x60), 
                    IOBH,   8, 
                    IOBL,   8, 
                    IO2H,   8, 
                    IO2L,   8, 
                    Offset (0x70), 
                    INT,    4, 
                    Offset (0x74), 
                    DMAS,   3, 
                    Offset (0xE0), 
                    Z000,   8, 
                    Offset (0xE4), 
                    Z001,   8, 
                    Offset (0xF0), 
                    MODE,   3, 
                    Offset (0xF3), 
                        ,   6, 
                    SLED,   2, 
                    Offset (0xF5), 
                        ,   6, 
                    PLED,   2
                }

                Method (CFG, 1, NotSerialized)
                {
                    Store (0x55, BPIO)
                    Store (Arg0, LDN)
                }

                Method (XCFG, 0, NotSerialized)
                {
                    Store (0xAA, BPIO)
                }

                Method (STA, 1, NotSerialized)
                {
                    CFG (Arg0)
                    Store (0x00, Local1)
                    If (ACT)
                    {
                        Store (0x0F, Local1)
                    }
                    Else
                    {
                        Store (0x0D, Local1)
                    }

                    XCFG ()
                    Return (Local1)
                }

                Method (DIS, 1, NotSerialized)
                {
                    CFG (Arg0)
                    Store (0x00, ACT)
                    XCFG ()
                    Return (0x00)
                }

                Method (PS0, 1, NotSerialized)
                {
                    CFG (Arg0)
                    Store (0x01, ACT)
                    XCFG ()
                    Return (0x00)
                }

                Method (PS3, 1, NotSerialized)
                {
                    CFG (Arg0)
                    Store (0x00, ACT)
                    XCFG ()
                    Return (0x00)
                }

                Device (COM1)
                {
                    Name (_HID, EisaId ("PNP0501"))  // _HID: Hardware ID
                    Name (_UID, 0x01)  // _UID: Unique ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        Store (STA (0x04), Local1)
                        Return (Local1)
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        DIS (0x04)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (RSRC, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                _Y0D)
                            IRQNoFlags (_Y0E)
                                {}
                        })
                        CreateByteField (RSRC, \_SB.PCI0.SIO.COM1._CRS._Y0D._MIN, IO1)  // _MIN: Minimum Base Address
                        CreateByteField (RSRC, 0x03, IO2)
                        CreateByteField (RSRC, \_SB.PCI0.SIO.COM1._CRS._Y0D._MAX, IO3)  // _MAX: Maximum Base Address
                        CreateByteField (RSRC, 0x05, IO4)
                        CreateWordField (RSRC, \_SB.PCI0.SIO.COM1._CRS._Y0E._INT, IRQV)  // _INT: Interrupts
                        CFG (0x04)
                        If (ACT)
                        {
                            Store (IOBL, IO1)
                            Store (IOBH, IO2)
                            Store (IOBL, IO3)
                            Store (IOBH, IO4)
                            Store (0x01, Local0)
                            ShiftLeft (Local0, INT, IRQV)
                        }

                        XCFG ()
                        Return (RSRC)
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {4}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02F8,             // Range Minimum
                                0x02F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03E8,             // Range Minimum
                                0x03E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {4}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02E8,             // Range Minimum
                                0x02E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {3}
                        }
                        StartDependentFn (0x02, 0x02)
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {3}
                        }
                        StartDependentFn (0x02, 0x02)
                        {
                            IO (Decode16,
                                0x02F8,             // Range Minimum
                                0x02F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {4}
                        }
                        StartDependentFn (0x02, 0x02)
                        {
                            IO (Decode16,
                                0x03E8,             // Range Minimum
                                0x03E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {3}
                        }
                        StartDependentFn (0x02, 0x02)
                        {
                            IO (Decode16,
                                0x02E8,             // Range Minimum
                                0x02E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {4}
                        }
                        EndDependentFn ()
                    })
                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateByteField (Arg0, 0x02, IO1)
                        CreateByteField (Arg0, 0x03, IO2)
                        CreateWordField (Arg0, 0x09, IRQV)
                        CFG (0x04)
                        Store (IO1, IOBL)
                        Store (IO2, IOBH)
                        FindSetRightBit (IRQV, Local0)
                        Subtract (Local0, 0x01, INT)
                        Store (0x01, ACT)
                        XCFG ()
                    }

                    Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                    {
                        PS0 (0x04)
                    }

                    Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                    {
                        PS3 (0x04)
                    }

                    Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                    {
                        0x08, 
                        0x04
                    })
                }

                Device (COM2)
                {
                    Name (_HID, EisaId ("PNP0501"))  // _HID: Hardware ID
                    Name (_UID, 0x02)  // _UID: Unique ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        Return (0x00)
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        DIS (0x05)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (RSRC, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                _Y0F)
                            IRQNoFlags (_Y10)
                                {}
                        })
                        CreateByteField (RSRC, \_SB.PCI0.SIO.COM2._CRS._Y0F._MIN, IO1)  // _MIN: Minimum Base Address
                        CreateByteField (RSRC, 0x03, IO2)
                        CreateByteField (RSRC, \_SB.PCI0.SIO.COM2._CRS._Y0F._MAX, IO3)  // _MAX: Maximum Base Address
                        CreateByteField (RSRC, 0x05, IO4)
                        CreateWordField (RSRC, \_SB.PCI0.SIO.COM2._CRS._Y10._INT, IRQV)  // _INT: Interrupts
                        CFG (0x05)
                        If (ACT)
                        {
                            Store (IOBL, IO1)
                            Store (IOBH, IO2)
                            Store (IOBL, IO3)
                            Store (IOBH, IO4)
                            Store (0x01, Local0)
                            ShiftLeft (Local0, INT, IRQV)
                        }

                        XCFG ()
                        Return (RSRC)
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                        }
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x02F8,             // Range Minimum
                                0x02F8,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03E8,             // Range Minimum
                                0x03E8,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02E8,             // Range Minimum
                                0x02E8,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3}
                        }
                        StartDependentFn (0x02, 0x02)
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3}
                        }
                        StartDependentFn (0x02, 0x02)
                        {
                            IO (Decode16,
                                0x02F8,             // Range Minimum
                                0x02F8,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                        }
                        StartDependentFn (0x02, 0x02)
                        {
                            IO (Decode16,
                                0x03E8,             // Range Minimum
                                0x03E8,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3}
                        }
                        StartDependentFn (0x02, 0x02)
                        {
                            IO (Decode16,
                                0x02E8,             // Range Minimum
                                0x02E8,             // Range Maximum
                                0x08,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                        }
                        EndDependentFn ()
                    })
                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateByteField (Arg0, 0x02, IO1)
                        CreateByteField (Arg0, 0x03, IO2)
                        CreateWordField (Arg0, 0x09, IRQV)
                        CFG (0x05)
                        Store (IO1, IOBL)
                        Store (IO2, IOBH)
                        FindSetRightBit (IRQV, Local0)
                        Subtract (Local0, 0x01, INT)
                        Store (0x01, ACT)
                        XCFG ()
                    }

                    Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                    {
                        PS0 (0x05)
                    }

                    Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                    {
                        PS3 (0x05)
                    }

                    Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                    {
                        0x08, 
                        0x04
                    })
                }

                Device (FDC)
                {
                    Name (_HID, EisaId ("PNP0700"))  // _HID: Hardware ID
                    Name (_UID, 0x01)  // _UID: Unique ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        Store (STA (0x00), Local1)
                        Return (Local1)
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        DIS (0x00)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (RSRC, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x06,               // Length
                                _Y11)
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                _Y12)
                            IRQNoFlags (_Y13)
                                {}
                            DMA (Compatibility, NotBusMaster, Transfer8, _Y14)
                                {}
                        })
                        CFG (0x00)
                        If (ACT)
                        {
                            CreateByteField (RSRC, \_SB.PCI0.SIO.FDC._CRS._Y11._MIN, IO1)  // _MIN: Minimum Base Address
                            CreateByteField (RSRC, 0x03, IO2)
                            CreateByteField (RSRC, \_SB.PCI0.SIO.FDC._CRS._Y11._MAX, IO3)  // _MAX: Maximum Base Address
                            CreateByteField (RSRC, 0x05, IO4)
                            CreateByteField (RSRC, \_SB.PCI0.SIO.FDC._CRS._Y12._MIN, IO5)  // _MIN: Minimum Base Address
                            CreateByteField (RSRC, 0x0B, IO6)
                            CreateByteField (RSRC, \_SB.PCI0.SIO.FDC._CRS._Y12._MAX, IO7)  // _MAX: Maximum Base Address
                            CreateByteField (RSRC, 0x0D, IO8)
                            CreateWordField (RSRC, \_SB.PCI0.SIO.FDC._CRS._Y13._INT, IRQV)  // _INT: Interrupts
                            CreateByteField (RSRC, \_SB.PCI0.SIO.FDC._CRS._Y14._DMA, DMAV)  // _DMA: Direct Memory Access
                            Store (IOBL, IO1)
                            Store (IOBH, IO2)
                            Store (IOBL, IO3)
                            Store (IOBH, IO4)
                            Add (IOBL, 0x07, IO5)
                            Store (IOBH, IO6)
                            Add (IOBL, 0x07, IO7)
                            Store (IOBH, IO8)
                            Store (0x01, Local0)
                            ShiftLeft (Local0, INT, IRQV)
                            Store (0x01, Local0)
                            ShiftLeft (Local0, DMAS, DMAV)
                        }

                        XCFG ()
                        Return (RSRC)
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x03F0,             // Range Minimum
                                0x03F0,             // Range Maximum
                                0x01,               // Alignment
                                0x06,               // Length
                                )
                            IO (Decode16,
                                0x03F7,             // Range Minimum
                                0x03F7,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {6}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {2}
                        }
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x0370,             // Range Minimum
                                0x0370,             // Range Maximum
                                0x01,               // Alignment
                                0x06,               // Length
                                )
                            IO (Decode16,
                                0x0377,             // Range Minimum
                                0x0377,             // Range Maximum
                                0x01,               // Alignment
                                0x01,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {6}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {2}
                        }
                        EndDependentFn ()
                    })
                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateByteField (Arg0, 0x02, IO1)
                        CreateByteField (Arg0, 0x03, IO2)
                        CreateWordField (Arg0, 0x11, IRQV)
                        CreateByteField (Arg0, 0x14, DMAV)
                        CFG (0x00)
                        Store (IO1, IOBL)
                        Store (IO2, IOBH)
                        FindSetRightBit (IRQV, Local0)
                        Subtract (Local0, 0x01, INT)
                        FindSetRightBit (DMAV, Local0)
                        Subtract (Local0, 0x01, DMAS)
                        Store (0x01, ACT)
                        XCFG ()
                    }

                    Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                    {
                        PS0 (0x00)
                    }

                    Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                    {
                        PS3 (0x00)
                    }
                }

                Device (PRT)
                {
                    Method (_HID, 0, NotSerialized)  // _HID: Hardware ID
                    {
                        CFG (0x03)
                        If (LEqual (MODE, 0x02))
                        {
                            Store (0x0104D041, Local1)
                        }
                        Else
                        {
                            Store (0x0004D041, Local1)
                        }

                        XCFG ()
                        Return (Local1)
                    }

                    Name (_UID, 0x02)  // _UID: Unique ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        Store (STA (0x03), Local1)
                        Return (0x00)
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        DIS (0x03)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        CFG (0x03)
                        Name (CRSA, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                _Y15)
                            IRQNoFlags (_Y16)
                                {}
                        })
                        CreateByteField (CRSA, \_SB.PCI0.SIO.PRT._CRS._Y15._MIN, IOA1)  // _MIN: Minimum Base Address
                        CreateByteField (CRSA, 0x03, IOA2)
                        CreateByteField (CRSA, \_SB.PCI0.SIO.PRT._CRS._Y15._MAX, IOA3)  // _MAX: Maximum Base Address
                        CreateByteField (CRSA, 0x05, IOA4)
                        CreateByteField (CRSA, \_SB.PCI0.SIO.PRT._CRS._Y15._ALN, ALA1)  // _ALN: Alignment
                        CreateByteField (CRSA, \_SB.PCI0.SIO.PRT._CRS._Y15._LEN, LNA1)  // _LEN: Length
                        CreateWordField (CRSA, \_SB.PCI0.SIO.PRT._CRS._Y16._INT, IRQA)  // _INT: Interrupts
                        Name (CRSB, ResourceTemplate ()
                        {
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                _Y17)
                            IO (Decode16,
                                0x0000,             // Range Minimum
                                0x0000,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                _Y18)
                            IRQNoFlags (_Y19)
                                {}
                            DMA (Compatibility, NotBusMaster, Transfer16, _Y1A)
                                {}
                        })
                        CreateByteField (CRSB, \_SB.PCI0.SIO.PRT._CRS._Y17._MIN, IOB1)  // _MIN: Minimum Base Address
                        CreateByteField (CRSB, 0x03, IOB2)
                        CreateByteField (CRSB, \_SB.PCI0.SIO.PRT._CRS._Y17._MAX, IOB3)  // _MAX: Maximum Base Address
                        CreateByteField (CRSB, 0x05, IOB4)
                        CreateByteField (CRSB, \_SB.PCI0.SIO.PRT._CRS._Y17._ALN, ALB1)  // _ALN: Alignment
                        CreateByteField (CRSB, \_SB.PCI0.SIO.PRT._CRS._Y17._LEN, LNB1)  // _LEN: Length
                        CreateByteField (CRSB, \_SB.PCI0.SIO.PRT._CRS._Y18._MIN, IOB5)  // _MIN: Minimum Base Address
                        CreateByteField (CRSB, 0x0B, IOB6)
                        CreateByteField (CRSB, \_SB.PCI0.SIO.PRT._CRS._Y18._MAX, IOB7)  // _MAX: Maximum Base Address
                        CreateByteField (CRSB, 0x0D, IOB8)
                        CreateByteField (CRSB, \_SB.PCI0.SIO.PRT._CRS._Y18._ALN, ALB2)  // _ALN: Alignment
                        CreateByteField (CRSB, \_SB.PCI0.SIO.PRT._CRS._Y18._LEN, LNB2)  // _LEN: Length
                        CreateWordField (CRSB, \_SB.PCI0.SIO.PRT._CRS._Y19._INT, IRQB)  // _INT: Interrupts
                        CreateWordField (CRSB, \_SB.PCI0.SIO.PRT._CRS._Y1A._DMA, DMAV)  // _DMA: Direct Memory Access
                        If (ACT)
                        {
                            If (LEqual (MODE, 0x02))
                            {
                                Store (IOBL, IOB1)
                                Store (IOBH, IOB2)
                                Store (IOBL, IOB3)
                                Store (IOBH, IOB4)
                                Store (IOBL, IOB5)
                                Add (IOBH, 0x04, IOB6)
                                Store (IOBL, IOB7)
                                Add (IOBH, 0x04, IOB8)
                                If (LEqual (IOBL, 0xBC))
                                {
                                    Store (0x01, ALB1)
                                    Store (0x04, LNB1)
                                    Store (0x01, ALB2)
                                    Store (0x04, LNB2)
                                }

                                Store (0x01, Local0)
                                ShiftLeft (Local0, INT, IRQB)
                                Store (0x01, Local0)
                                ShiftLeft (Local0, DMAS, DMAV)
                                Return (CRSB)
                            }
                            Else
                            {
                                Store (IOBL, IOA1)
                                Store (IOBH, IOA2)
                                Store (IOBL, IOA3)
                                Store (IOBH, IOA4)
                                Store (0x01, Local0)
                                ShiftLeft (Local0, INT, IRQA)
                                If (LEqual (IOBL, 0xBC))
                                {
                                    Store (0x01, ALA1)
                                    Store (0x04, LNA1)
                                }

                                Return (CRSA)
                            }
                        }
                        Else
                        {
                            If (LEqual (MODE, 0x02))
                            {
                                Return (CRSB)
                            }
                            Else
                            {
                                Return (CRSA)
                            }
                        }

                        XCFG ()
                    }

                    Name (PRSA, ResourceTemplate ()
                    {
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {7}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {5}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {7}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {5}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {7}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {5}
                        }
                        EndDependentFn ()
                    })
                    Name (PRSB, ResourceTemplate ()
                    {
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0778,             // Range Minimum
                                0x0778,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {7}
                            DMA (Compatibility, NotBusMaster, Transfer16, )
                                {0,1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0778,             // Range Minimum
                                0x0778,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {5}
                            DMA (Compatibility, NotBusMaster, Transfer16, )
                                {0,1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0678,             // Range Minimum
                                0x0678,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {7}
                            DMA (Compatibility, NotBusMaster, Transfer16, )
                                {0,1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0678,             // Range Minimum
                                0x0678,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {5}
                            DMA (Compatibility, NotBusMaster, Transfer16, )
                                {0,1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IO (Decode16,
                                0x07BC,             // Range Minimum
                                0x07BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {7}
                            DMA (Compatibility, NotBusMaster, Transfer16, )
                                {0,1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IO (Decode16,
                                0x07BC,             // Range Minimum
                                0x07BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQ (Edge, ActiveHigh, Exclusive, )
                                {5}
                            DMA (Compatibility, NotBusMaster, Transfer16, )
                                {0,1,3}
                        }
                        EndDependentFn ()
                    })
                    Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                    {
                        CFG (0x03)
                        If (LEqual (MODE, 0x02))
                        {
                            Store (PRSB, Local0)
                        }
                        Else
                        {
                            Store (PRSA, Local0)
                        }

                        XCFG ()
                        Return (Local0)
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CFG (0x03)
                        If (LEqual (MODE, 0x02))
                        {
                            CreateByteField (Arg0, 0x02, IOB1)
                            CreateByteField (Arg0, 0x03, IOB2)
                            CreateByteField (Arg0, 0x04, IOB3)
                            CreateByteField (Arg0, 0x05, IOB4)
                            CreateByteField (Arg0, 0x06, ALB1)
                            CreateByteField (Arg0, 0x07, LNB1)
                            CreateByteField (Arg0, 0x0A, IOB5)
                            CreateByteField (Arg0, 0x0B, IOB6)
                            CreateByteField (Arg0, 0x0C, IOB7)
                            CreateByteField (Arg0, 0x0D, IOB8)
                            CreateByteField (Arg0, 0x0E, ALB2)
                            CreateByteField (Arg0, 0x0F, LNB2)
                            CreateWordField (Arg0, 0x11, IRQB)
                            CreateWordField (Arg0, 0x14, DMAV)
                            Store (IOB1, IOBL)
                            Store (IOB2, IOBH)
                            FindSetLeftBit (IRQB, Local0)
                            Subtract (Local0, 0x01, INT)
                            FindSetLeftBit (DMAV, Local0)
                            Subtract (Local0, 0x01, DMAS)
                        }
                        Else
                        {
                            CreateByteField (Arg0, 0x02, IOA1)
                            CreateByteField (Arg0, 0x03, IOA2)
                            CreateByteField (Arg0, 0x04, IOA3)
                            CreateByteField (Arg0, 0x05, IOA4)
                            CreateByteField (Arg0, 0x06, ALA1)
                            CreateByteField (Arg0, 0x07, LNA1)
                            CreateWordField (Arg0, 0x09, IRQA)
                            Store (IOA1, IOBL)
                            Store (IOA2, IOBH)
                            FindSetLeftBit (IRQA, Local0)
                            Subtract (Local0, 0x01, INT)
                        }

                        Store (0x01, ACT)
                        XCFG ()
                    }

                    Method (_PS0, 0, NotSerialized)  // _PS0: Power State 0
                    {
                        PS0 (0x03)
                    }

                    Method (_PS3, 0, NotSerialized)  // _PS3: Power State 3
                    {
                        PS3 (0x03)
                    }
                }

                Method (ENWK, 0, NotSerialized)
                {
                    CFG (0x0A)
                    Store (0x01, ACT)
                    Store (0x3F, PSTS)
                    Store (0x01, RUNT)
                    Store (PMEN, Local0)
                    Or (Local0, 0x18, PMEN)
                    Store (0x01, IOPM)
                    XCFG ()
                }

                Method (DSWK, 0, NotSerialized)
                {
                    CFG (0x0A)
                    Store (0x01, ACT)
                    Store (0x3F, PSTS)
                    Store (0x01, RUNT)
                    Store (0x00, IOPM)
                    XCFG ()
                }
            }

            Device (PS2K)
            {
                Name (_HID, EisaId ("PNP0303"))  // _HID: Hardware ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0060,             // Range Minimum
                        0x0060,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x0064,             // Range Minimum
                        0x0064,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IRQ (Edge, ActiveHigh, Exclusive, )
                        {1}
                })
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x10, 
                    0x04
                })
            }

            Device (PS2M)
            {
                Name (_HID, EisaId ("PNP0F13"))  // _HID: Hardware ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IRQ (Edge, ActiveHigh, Exclusive, )
                        {12}
                })
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x10, 
                    0x04
                })
            }

            Device (SMB0)
            {
                Name (_ADR, 0x00010001)  // _ADR: Address
                OperationRegion (SMCF, PCI_Config, 0x48, 0x04)
                Field (SMCF, AnyAcc, NoLock, Preserve)
                {
                    SMPM,   4
                }

                OperationRegion (SBA0, PCI_Config, 0x50, 0x04)
                Field (SBA0, AnyAcc, NoLock, Preserve)
                {
                    SB50,   16
                }

                OperationRegion (SBA1, PCI_Config, 0x54, 0x04)
                Field (SBA1, AnyAcc, NoLock, Preserve)
                {
                    SB54,   16
                }
            }

            Device (USB0)
            {
                Name (_ADR, 0x00020000)  // _ADR: Address
                Method (_S1D, 0, NotSerialized)  // _S1D: S1 Device State
                {
                    Return (0x01)
                }

                Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
                {
                    Return (0x02)
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x0D, 
                    0x03
                })
            }

            Device (USB2)
            {
                Name (_ADR, 0x00020001)  // _ADR: Address
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x05, 
                    0x03
                })
            }

            Device (MAC0)
            {
                Name (_ADR, 0x000A0000)  // _ADR: Address
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x0B, 
                    0x05
                })
            }

            Device (ACI0)
            {
                Name (_ADR, 0x00040000)  // _ADR: Address
            }

            Device (MCI0)
            {
                Name (_ADR, 0x00040001)  // _ADR: Address
            }

            Device (P2P0)
            {
                Name (_ADR, 0x00090000)  // _ADR: Address
                Name (_UID, 0x02)  // _UID: Unique ID
                OperationRegion (A080, PCI_Config, 0x19, 0x01)
                Field (A080, ByteAcc, NoLock, Preserve)
                {
                    SECB,   8
                }

                Method (_BBN, 0, NotSerialized)  // _BBN: BIOS Bus Number
                {
                    Return (SECB)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (_PRT, Package (0x05)  // _PRT: PCI Routing Table
                {
                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x00, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x01, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x02, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x03, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0005FFFF, 
                        0x00, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }
                })
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x00, 
                    0x05
                })
            }

            Name (NATA, Package (0x01)
            {
                0x00060000
            })
            Scope (\_SB.PCI0)
            {
                Device (NVRB)
                {
                    Name (_HID, "_NVRAIDBUS")  // _HID: Hardware ID
                    Name (FNVR, 0xFF)
                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        Store (0x00, FNVR)
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (LEqual (\_SB.R_ST, 0x01))
                        {
                            If (LEqual (FNVR, 0xFF))
                            {
                                Return (0x0F)
                            }
                            Else
                            {
                                Return (0x0D)
                            }
                        }
                        Else
                        {
                            Return (0x00)
                        }
                    }

                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x04D2,             // Range Minimum
                            0x04D2,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                    })
                }
            }

            Device (IDE0)
            {
                Name (SID4, 0x00)
                Name (SID5, 0x00)
                Name (SFLG, 0x00)
                Name (SID0, 0x00)
                Name (SID1, 0x00)
                Name (SID2, 0x00)
                Name (SID3, 0x00)
                Name (_ADR, 0x00060000)  // _ADR: Address
                OperationRegion (A090, PCI_Config, 0x50, 0x18)
                Field (A090, DWordAcc, NoLock, Preserve)
                {
                    ID20,   16, 
                    Offset (0x08), 
                    IDTS,   16, 
                    IDTP,   16, 
                    ID22,   32, 
                    UMSS,   16, 
                    UMSP,   16
                }

                Name (IDEP, Buffer (0x14) {})
                Name (IDES, Buffer (0x14) {})
                Method (GTM, 1, NotSerialized)
                {
                    If (LEqual (Arg0, 0x00))
                    {
                        Store (IDTP, Local0)
                        Store (UMSP, Local1)
                        Store (IDEP, Local2)
                    }
                    Else
                    {
                        Store (IDTS, Local0)
                        Store (UMSS, Local1)
                        Store (IDES, Local2)
                    }

                    CreateDWordField (Local2, 0x00, PIO0)
                    CreateDWordField (Local2, 0x04, DMA0)
                    CreateDWordField (Local2, 0x08, PIO1)
                    CreateDWordField (Local2, 0x0C, DMA1)
                    CreateDWordField (Local2, 0x10, FLAG)
                    Store (0x10, FLAG)
                    And (Local0, 0x0F00, Local3)
                    And (Local0, 0xF000, Local4)
                    ShiftRight (Local3, 0x08, Local3)
                    ShiftRight (Local4, 0x0C, Local4)
                    Add (Local3, Local4, Local3)
                    Multiply (Add (Local3, 0x02), 0x1E, PIO0)
                    If (LLessEqual (PIO0, 0xB4))
                    {
                        Or (FLAG, 0x02, FLAG)
                    }

                    If (And (Local1, 0x4000))
                    {
                        Or (FLAG, 0x01, FLAG)
                        And (Local1, 0x0700, Local3)
                        ShiftRight (Local3, 0x08, Local3)
                        Store (U2T (Local3), DMA0)
                    }
                    Else
                    {
                        Store (PIO0, DMA0)
                    }

                    And (Local0, 0x0F, Local3)
                    And (Local0, 0xF0, Local4)
                    ShiftRight (Local4, 0x04, Local4)
                    Add (Local3, Local4, Local3)
                    Multiply (Add (Local3, 0x02), 0x1E, PIO1)
                    If (LLessEqual (PIO1, 0xB4))
                    {
                        Or (FLAG, 0x08, FLAG)
                    }

                    If (And (Local1, 0x40))
                    {
                        Or (FLAG, 0x04, FLAG)
                        And (Local1, 0x07, Local3)
                        Store (U2T (Local3), DMA1)
                    }
                    Else
                    {
                        Store (PIO1, DMA1)
                    }

                    If (LEqual (Arg0, 0x00))
                    {
                        Store (Local2, IDEP)
                        Return (IDEP)
                    }
                    Else
                    {
                        Store (Local2, IDES)
                        Return (IDES)
                    }
                }

                Method (U2T, 1, NotSerialized)
                {
                    If (LEqual (Arg0, 0x00))
                    {
                        Return (0x3C)
                    }

                    If (LEqual (Arg0, 0x01))
                    {
                        Return (0x5A)
                    }

                    If (LEqual (Arg0, 0x02))
                    {
                        Return (0x78)
                    }

                    If (LEqual (Arg0, 0x03))
                    {
                        Return (0x96)
                    }

                    If (LEqual (Arg0, 0x04))
                    {
                        Return (0x2D)
                    }

                    If (LEqual (Arg0, 0x05))
                    {
                        Return (0x1E)
                    }

                    If (LEqual (Arg0, 0x06))
                    {
                        Return (0x14)
                    }

                    Return (0x0F)
                }

                Method (T2U, 1, NotSerialized)
                {
                    If (LGreater (Arg0, 0x78))
                    {
                        Return (0x03)
                    }

                    If (LGreater (Arg0, 0x5A))
                    {
                        Return (0x02)
                    }

                    If (LGreater (Arg0, 0x3C))
                    {
                        Return (0x01)
                    }

                    If (LGreater (Arg0, 0x2D))
                    {
                        Return (0x00)
                    }

                    If (LGreater (Arg0, 0x1E))
                    {
                        Return (0x04)
                    }

                    If (LGreater (Arg0, 0x14))
                    {
                        Return (0x05)
                    }

                    If (LGreater (Arg0, 0x0F))
                    {
                        Return (0x06)
                    }

                    Return (0x07)
                }

                Method (T2D, 1, NotSerialized)
                {
                    If (LGreater (Arg0, 0x01E0))
                    {
                        Return (0xA8)
                    }

                    If (LGreater (Arg0, 0x0186))
                    {
                        Return (0x77)
                    }

                    If (LGreater (Arg0, 0xF0))
                    {
                        Return (0x47)
                    }

                    If (LGreater (Arg0, 0xB4))
                    {
                        Return (0x33)
                    }

                    If (LGreater (Arg0, 0x96))
                    {
                        Return (0x22)
                    }

                    If (LGreater (Arg0, 0x78))
                    {
                        Return (0x21)
                    }

                    Return (0x20)
                }

                Method (STM, 4, NotSerialized)
                {
                    If (SX)
                    {
                        Store (SID0, ID20)
                        Store (SID1, IDTS)
                        Store (SID2, IDTP)
                        Store (SID3, ID22)
                        Store (SID4, UMSS)
                        Store (SID5, UMSP)
                    }
                    Else
                    {
                        Store (ID20, SID0)
                        Store (IDTS, SID1)
                        Store (IDTP, SID2)
                        Store (ID22, SID3)
                        Store (UMSS, SID4)
                        Store (UMSP, SID5)
                    }

                    Store (0x00, SX)
                    CreateDWordField (Arg0, 0x00, PIO0)
                    CreateDWordField (Arg0, 0x04, DMA0)
                    CreateDWordField (Arg0, 0x08, PIO1)
                    CreateDWordField (Arg0, 0x0C, DMA1)
                    CreateDWordField (Arg0, 0x10, FLAG)
                    If (LEqual (Arg3, 0x00))
                    {
                        Store (SID2, Local0)
                        Store (SID5, Local1)
                    }
                    Else
                    {
                        Store (SID1, Local0)
                        Store (SID4, Local1)
                    }

                    If (LNotEqual (PIO0, 0xFFFFFFFF))
                    {
                        And (Local0, 0xFF, Local0)
                        ShiftLeft (T2D (PIO0), 0x08, Local2)
                        Or (Local0, Local2, Local0)
                    }

                    If (LNotEqual (PIO1, 0xFFFFFFFF))
                    {
                        And (Local0, 0xFF00, Local0)
                        Or (Local0, T2D (PIO1), Local0)
                    }

                    If (And (FLAG, 0x01))
                    {
                        And (Local1, 0xFF, Local1)
                        ShiftLeft (T2U (DMA0), 0x08, Local2)
                        Or (0xC000, Local2, Local2)
                        Or (Local2, Local1, Local1)
                    }
                    Else
                    {
                        If (LNotEqual (DMA0, 0xFFFFFFFF))
                        {
                            And (Local0, 0xFF, Local0)
                            ShiftLeft (T2D (DMA0), 0x08, Local2)
                            Or (Local0, Local2, Local0)
                        }
                    }

                    If (And (FLAG, 0x04))
                    {
                        And (Local1, 0xFF00, Local1)
                        Or (0xC0, T2U (DMA1), Local2)
                        Or (Local2, Local1, Local1)
                    }
                    Else
                    {
                        If (LNotEqual (DMA1, 0xFFFFFFFF))
                        {
                            And (Local0, 0xFF00, Local0)
                            Or (Local0, T2D (DMA1), Local0)
                        }
                    }

                    If (LEqual (Arg3, 0x00))
                    {
                        Store (Local0, IDTP)
                        Store (Local1, UMSP)
                    }
                    Else
                    {
                        Store (Local0, IDTS)
                        Store (Local1, UMSS)
                    }
                }

                Method (GTF, 2, NotSerialized)
                {
                    Store (Buffer (0x07)
                        {
                             0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                        }, Local0)
                    CreateByteField (Local0, 0x01, MODE)
                    CreateByteField (Local0, 0x05, DRIV)
                    Store (Arg1, DRIV)
                    If (LEqual (Arg0, 0x00))
                    {
                        Store (IDEP, Local1)
                    }
                    Else
                    {
                        Store (IDES, Local1)
                    }

                    CreateDWordField (Local1, 0x00, PIO0)
                    CreateDWordField (Local1, 0x04, DMA0)
                    CreateDWordField (Local1, 0x08, PIO1)
                    CreateDWordField (Local1, 0x0C, DMA1)
                    CreateDWordField (Local1, 0x10, FLGX)
                    If (LEqual (Arg1, 0xA0))
                    {
                        Store (PIO0, Local2)
                        Store (DMA0, Local3)
                        And (FLGX, 0x01, FLGX)
                    }
                    Else
                    {
                        Store (PIO1, Local2)
                        Store (DMA1, Local3)
                        And (FLGX, 0x04, FLGX)
                    }

                    Store (FLGX, Local1)
                    If (LGreater (Local2, 0x0186))
                    {
                        Store (0x00, Local2)
                    }
                    Else
                    {
                        If (LGreater (Local2, 0xF0))
                        {
                            Store (0x01, Local2)
                        }
                        Else
                        {
                            If (LGreater (Local2, 0xB4))
                            {
                                Store (0x02, Local2)
                            }
                            Else
                            {
                                If (LGreater (Local2, 0x78))
                                {
                                    Store (0x03, Local2)
                                }
                                Else
                                {
                                    Store (0x04, Local2)
                                }
                            }
                        }
                    }

                    Or (0x08, Local2, MODE)
                    Store (Local0, Local2)
                    If (FLGX)
                    {
                        If (LGreater (Local3, 0x5A))
                        {
                            Store (0x00, Local3)
                        }
                        Else
                        {
                            If (LGreater (Local3, 0x3C))
                            {
                                Store (0x01, Local3)
                            }
                            Else
                            {
                                If (LGreater (Local3, 0x2D))
                                {
                                    Store (0x02, Local3)
                                }
                                Else
                                {
                                    If (LGreater (Local3, 0x1E))
                                    {
                                        Store (0x03, Local3)
                                    }
                                    Else
                                    {
                                        If (LGreater (Local3, 0x14))
                                        {
                                            Store (0x04, Local3)
                                        }
                                        Else
                                        {
                                            If (LGreater (Local3, 0x0F))
                                            {
                                                Store (0x05, Local3)
                                            }
                                            Else
                                            {
                                                Store (0x06, Local3)
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        Or (0x40, Local3, MODE)
                    }
                    Else
                    {
                        If (LEqual (Local3, 0xFFFFFFFF))
                        {
                            Return (Local0)
                        }
                        Else
                        {
                            If (LGreater (Local3, 0x96))
                            {
                                Store (0x00, Local3)
                            }
                            Else
                            {
                                If (LGreater (Local3, 0x78))
                                {
                                    Store (0x01, Local3)
                                }
                                Else
                                {
                                    Store (0x02, Local3)
                                }
                            }

                            Or (0x20, Local3, MODE)
                        }
                    }

                    Concatenate (Local0, Local2, Local1)
                    Return (Local1)
                }

                Device (PRI0)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Return (GTM (0x00))
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        STM (Arg0, Arg1, Arg2, 0x00)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Return (GTF (0x00, 0xA0))
                        }
                    }

                    Device (SLAV)
                    {
                        Name (_ADR, 0x01)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Return (GTF (0x00, 0xB0))
                        }
                    }
                }

                Device (SEC0)
                {
                    Name (_ADR, 0x01)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Return (GTM (0x01))
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        STM (Arg0, Arg1, Arg2, 0x01)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Return (GTF (0x01, 0xA0))
                        }
                    }

                    Device (SLAV)
                    {
                        Name (_ADR, 0x01)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Return (GTF (0x01, 0xB0))
                        }
                    }
                }

                Method (DRMP, 0, NotSerialized)
                {
                    Return (\_SB.R_P0)
                }
            }

            Device (SAT1)
            {
                Name (_ADR, 0x00080000)  // _ADR: Address
                Device (PRI0)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                    Name (SPTM, Buffer (0x14)
                    {
                        /* 0000 */   0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
                        /* 0008 */   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                        /* 0010 */   0x13, 0x00, 0x00, 0x00
                    })
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Return (SPTM)
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Store (Arg0, SPTM)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x46, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Return (Local0)
                        }
                    }
                }

                Device (SEC0)
                {
                    Name (_ADR, 0x01)  // _ADR: Address
                    Name (SSTM, Buffer (0x14)
                    {
                        /* 0000 */   0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
                        /* 0008 */   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                        /* 0010 */   0x13, 0x00, 0x00, 0x00
                    })
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Return (SSTM)
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Store (Arg0, SSTM)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x46, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Return (Local0)
                        }
                    }
                }

                Method (DRMP, 0, NotSerialized)
                {
                    Store (\_SB.R_S1, Local0)
                    Store (Local0, DBUG)
                    Return (\_SB.R_S1)
                    Store (Z002, Local0)
                    Store (Local0, DBUG)
                    And (Local0, 0x05, Local0)
                    Store (Local0, DBUG)
                    Return (Local0)
                }
            }

            Device (SAT0)
            {
                Name (_ADR, 0x00070000)  // _ADR: Address
                Device (PRI0)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                    Name (SPTM, Buffer (0x14)
                    {
                        /* 0000 */   0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
                        /* 0008 */   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                        /* 0010 */   0x13, 0x00, 0x00, 0x00
                    })
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Return (SPTM)
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Store (Arg0, SPTM)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x46, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Return (Local0)
                        }
                    }
                }

                Device (SEC0)
                {
                    Name (_ADR, 0x01)  // _ADR: Address
                    Name (SSTM, Buffer (0x14)
                    {
                        /* 0000 */   0x78, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
                        /* 0008 */   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                        /* 0010 */   0x13, 0x00, 0x00, 0x00
                    })
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Return (SSTM)
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Store (Arg0, SSTM)
                    }

                    Device (MAST)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x46, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Return (Local0)
                        }
                    }
                }

                Method (DRMP, 0, NotSerialized)
                {
                    Store (\_SB.R_S0, Local0)
                    Store (Local0, DBUG)
                    Return (\_SB.R_S0)
                }
            }

            Device (XVR0)
            {
                Name (_ADR, 0x000E0000)  // _ADR: Address
                Name (_UID, 0x03)  // _UID: Unique ID
                OperationRegion (A1E0, PCI_Config, 0x19, 0x01)
                Field (A1E0, ByteAcc, NoLock, Preserve)
                {
                    SECB,   8
                }

                Method (_BBN, 0, NotSerialized)  // _BBN: BIOS Bus Number
                {
                    Return (SECB)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (_PRT, Package (0x04)  // _PRT: PCI Routing Table
                {
                    Package (0x04)
                    {
                        0xFFFF, 
                        0x00, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x01, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x02, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x03, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }
                })
                Device (Z003)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                }
            }

            Device (XVR1)
            {
                Name (_ADR, 0x000D0000)  // _ADR: Address
                Name (_UID, 0x04)  // _UID: Unique ID
                OperationRegion (A1E0, PCI_Config, 0x19, 0x01)
                Field (A1E0, ByteAcc, NoLock, Preserve)
                {
                    SECB,   8
                }

                Method (_BBN, 0, NotSerialized)  // _BBN: BIOS Bus Number
                {
                    Return (SECB)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (_PRT, Package (0x04)  // _PRT: PCI Routing Table
                {
                    Package (0x04)
                    {
                        0xFFFF, 
                        0x00, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x01, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x02, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x03, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }
                })
                Device (Z004)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                }
            }

            Device (XVR2)
            {
                Name (_ADR, 0x000C0000)  // _ADR: Address
                Name (_UID, 0x05)  // _UID: Unique ID
                OperationRegion (A1E0, PCI_Config, 0x19, 0x01)
                Field (A1E0, ByteAcc, NoLock, Preserve)
                {
                    SECB,   8
                }

                Method (_BBN, 0, NotSerialized)  // _BBN: BIOS Bus Number
                {
                    Return (SECB)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (_PRT, Package (0x04)  // _PRT: PCI Routing Table
                {
                    Package (0x04)
                    {
                        0xFFFF, 
                        0x00, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x01, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x02, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x03, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }
                })
                Device (Z005)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                }
            }

            Device (XVR3)
            {
                Name (_ADR, 0x000B0000)  // _ADR: Address
                Name (_UID, 0x06)  // _UID: Unique ID
                OperationRegion (A1E0, PCI_Config, 0x19, 0x01)
                Field (A1E0, ByteAcc, NoLock, Preserve)
                {
                    SECB,   8
                }

                Method (_BBN, 0, NotSerialized)  // _BBN: BIOS Bus Number
                {
                    Return (SECB)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (_PRT, Package (0x04)  // _PRT: PCI Routing Table
                {
                    Package (0x04)
                    {
                        0xFFFF, 
                        0x00, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x01, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x02, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x03, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }
                })
                Device (Z006)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                }
            }

            Device (K801)
            {
                Name (_ADR, 0x00180001)  // _ADR: Address
                OperationRegion (HMM0, PCI_Config, 0x80, 0x30)
                Field (HMM0, ByteAcc, NoLock, Preserve)
                {
                    PMB0,   32, 
                    PML0,   32, 
                    PMB1,   32, 
                    PML1,   32, 
                    PMB2,   32, 
                    PML2,   32, 
                    VGAB,   32, 
                    VGAL,   32, 
                    PMB3,   32, 
                    PML3,   32, 
                    PMB4,   32, 
                    PML4,   32
                }

                OperationRegion (HMM1, PCI_Config, 0xC0, 0x20)
                Field (HMM1, ByteAcc, NoLock, Preserve)
                {
                    PIB0,   32, 
                    PIL0,   32, 
                    PIB1,   32, 
                    PIL1,   32, 
                    PIB2,   32, 
                    PIL2,   32
                }
            }
        }

        Device (PCI2)
        {
            Name (_HID, EisaId ("PNP0A03"))  // _HID: Hardware ID
            Name (_ADR, 0x00)  // _ADR: Address
            Name (_UID, 0x03)  // _UID: Unique ID
            Name (_BBN, 0x10)  // _BBN: BIOS Bus Number
            Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
            {
                Return (0x01)
            }

            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                Return (0x0F)
            }

            Device (G0PA)
            {
                Name (_ADR, 0x000A0000)  // _ADR: Address
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x11, 
                    0x05
                })
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (_BBN, 0x11)  // _BBN: BIOS Bus Number
                Name (APIC, Package (0x04)
                {
                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x00, 
                        0x00, 
                        0x18
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x01, 
                        0x00, 
                        0x19
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x02, 
                        0x00, 
                        0x1A
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x03, 
                        0x00, 
                        0x1B
                    }
                })
                Name (PICM, Package (0x04)
                {
                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x00, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x01, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x02, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x03, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (LNot (PICF))
                    {
                        Return (PICM)
                    }
                    Else
                    {
                        Return (APIC)
                    }
                }
            }

            Device (G0PB)
            {
                Name (_ADR, 0x000B0000)  // _ADR: Address
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x11, 
                    0x05
                })
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (_BBN, 0x12)  // _BBN: BIOS Bus Number
                Name (APIC, Package (0x0A)
                {
                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x00, 
                        0x00, 
                        0x1C
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x01, 
                        0x00, 
                        0x1D
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x02, 
                        0x00, 
                        0x1E
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x03, 
                        0x00, 
                        0x1F
                    }, 

                    Package (0x04)
                    {
                        0x0009FFFF, 
                        0x00, 
                        0x00, 
                        0x1D
                    }, 

                    Package (0x04)
                    {
                        0x0009FFFF, 
                        0x01, 
                        0x00, 
                        0x1E
                    }, 

                    Package (0x04)
                    {
                        0x0009FFFF, 
                        0x02, 
                        0x00, 
                        0x1F
                    }, 

                    Package (0x04)
                    {
                        0x0009FFFF, 
                        0x03, 
                        0x00, 
                        0x1C
                    }, 

                    Package (0x04)
                    {
                        0x0006FFFF, 
                        0x00, 
                        0x00, 
                        0x1E
                    }, 

                    Package (0x04)
                    {
                        0x0006FFFF, 
                        0x01, 
                        0x00, 
                        0x1F
                    }
                })
                Name (PICM, Package (0x0A)
                {
                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x00, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x01, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x02, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0004FFFF, 
                        0x03, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0009FFFF, 
                        0x00, 
                        \_SB.PCI0.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0009FFFF, 
                        0x01, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0009FFFF, 
                        0x02, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0009FFFF, 
                        0x03, 
                        \_SB.PCI0.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0006FFFF, 
                        0x00, 
                        \_SB.PCI0.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0x0006FFFF, 
                        0x01, 
                        \_SB.PCI0.LNK4, 
                        0x00
                    }
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (LNot (PICF))
                    {
                        Return (PICM)
                    }
                    Else
                    {
                        Return (APIC)
                    }
                }
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                Name (CBUF, ResourceTemplate ()
                {
                    WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                        0x0000,             // Granularity
                        0x0010,             // Range Minimum
                        0x007F,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x0078,             // Length
                        ,, )
                    IO (Decode16,
                        0x0CF8,             // Range Minimum
                        0x0CF8,             // Range Maximum
                        0x01,               // Alignment
                        0x08,               // Length
                        )
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x03B0,             // Range Minimum
                        0x03DF,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x0030,             // Length
                        ,, _Y1E, TypeStatic)
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x3000,             // Range Minimum
                        0x3FFF,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x1000,             // Length
                        ,, _Y1B, TypeStatic)
                    DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                        0x00000000,         // Granularity
                        0x000A0000,         // Range Minimum
                        0x000DFFFF,         // Range Maximum
                        0x00000000,         // Translation Offset
                        0x00040000,         // Length
                        ,, _Y1D, AddressRangeMemory, TypeStatic)
                    DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                        0x00000000,         // Granularity
                        0x00000000,         // Range Minimum
                        0x00000000,         // Range Maximum
                        0x00000000,         // Translation Offset
                        0x00000000,         // Length
                        ,, _Y1C, AddressRangeMemory, TypeStatic)
                })
                CreateWordField (CBUF, \_SB.PCI2._CRS._Y1B._MIN, PIMN)  // _MIN: Minimum Base Address
                CreateWordField (CBUF, \_SB.PCI2._CRS._Y1B._LEN, PILN)  // _LEN: Length
                CreateWordField (CBUF, \_SB.PCI2._CRS._Y1B._MAX, PIMX)  // _MAX: Maximum Base Address
                CreateDWordField (CBUF, \_SB.PCI2._CRS._Y1C._MIN, PMMN)  // _MIN: Minimum Base Address
                CreateDWordField (CBUF, \_SB.PCI2._CRS._Y1C._MAX, PMMX)  // _MAX: Maximum Base Address
                CreateDWordField (CBUF, \_SB.PCI2._CRS._Y1C._LEN, PMLN)  // _LEN: Length
                CreateDWordField (CBUF, \_SB.PCI2._CRS._Y1D._MIN, VMMN)  // _MIN: Minimum Base Address
                CreateDWordField (CBUF, \_SB.PCI2._CRS._Y1D._LEN, VMLN)  // _LEN: Length
                CreateDWordField (CBUF, \_SB.PCI2._CRS._Y1D._MAX, VMMX)  // _MAX: Maximum Base Address
                If (LEqual (\_SB.PCI0.K801.VGAL, 0x00))
                {
                    And (\_SB.PCI0.K801.PMB2, 0xFFFFFF00, Local0)
                    Multiply (Local0, 0x0100, PMMN)
                    ShiftLeft (\_SB.PCI0.K801.PML2, 0x08, Local0)
                    Or (Local0, 0xFFFF, PMMX)
                    Subtract (PMMX, PMMN, PMLN)
                    Increment (PMLN)
                }
                Else
                {
                    If (LEqual (And (\_SB.PCI0.K801.VGAL, 0xFF), 0x80))
                    {
                        And (\_SB.PCI0.K801.PMB2, 0xFFFFFF00, Local0)
                        Multiply (Local0, 0x0100, PMMN)
                        ShiftLeft (\_SB.PCI0.K801.PML2, 0x08, Local0)
                        Or (Local0, 0xFFFF, PMMX)
                        Subtract (PMMX, PMMN, PMLN)
                        Increment (PMLN)
                    }
                    Else
                    {
                        And (\_SB.PCI0.K801.PMB2, 0xFFFFFF00, Local0)
                        Multiply (Local0, 0x0100, PMMN)
                        ShiftLeft (\_SB.PCI0.K801.VGAL, 0x08, Local0)
                        Or (Local0, 0xFFFF, PMMX)
                        Subtract (PMMX, PMMN, PMLN)
                        Increment (PMLN)
                    }
                }

                If (LNotEqual (\_SB.PCI0.K801.PML4, 0x0B20))
                {
                    Store (0x000C0000, VMMN)
                    Store (0x00020000, VMLN)
                }

                If (\_SB.PCI0.K801.PIB1)
                {
                    If (LNotEqual (\_SB.PCI0.K801.PIB1, 0x01FFF013))
                    {
                        And (\_SB.PCI0.K801.PIB1, 0xFFFFF000, PIMN)
                        And (\_SB.PCI0.K801.PIL1, 0xFFFFF000, Local0)
                        Or (Local0, 0x0FFF, PIMX)
                        Subtract (PIMX, PIMN, PILN)
                        Increment (PILN)
                    }
                    Else
                    {
                        Store (Zero, PIMN)
                        Store (Zero, PIMX)
                        Store (Zero, PILN)
                    }
                }
                Else
                {
                    Store (Zero, PIMN)
                    Store (Zero, PIMX)
                    Store (Zero, PILN)
                }

                CreateWordField (CBUF, \_SB.PCI2._CRS._Y1E._MIN, VGMN)  // _MIN: Minimum Base Address
                CreateWordField (CBUF, \_SB.PCI2._CRS._Y1E._LEN, VGLN)  // _LEN: Length
                CreateWordField (CBUF, \_SB.PCI2._CRS._Y1E._MAX, VGMX)  // _MAX: Maximum Base Address
                If (LNotEqual (\_SB.PCI0.K801.PML4, 0x0B20))
                {
                    Store (Zero, VGMN)
                    Store (Zero, VGLN)
                    Store (Zero, VGMX)
                }

                Return (CBUF)
            }
        }

        Scope (\)
        {
            Name (PICF, 0x00)
            Method (_PIC, 1, NotSerialized)  // _PIC: Interrupt Model
            {
                Store (Arg0, PICF)
            }

            OperationRegion (\_SB.PCI0.LPC0.PIRQ, PCI_Config, 0x7C, 0x0C)
            Field (\_SB.PCI0.LPC0.PIRQ, AnyAcc, NoLock, Preserve)
            {
                INTW,   4, 
                INTX,   4, 
                INTY,   4, 
                INTZ,   4, 
                INTE,   4, 
                SSI1,   4, 
                SSI0,   4, 
                IPCA,   4, 
                ISCI,   4, 
                ITCO,   4, 
                ISMB,   4, 
                IUS2,   4, 
                INTU,   4, 
                INTS,   4, 
                PSI1,   4, 
                PSI0,   4, 
                IUS0,   4, 
                IUS1,   4, 
                IMAC,   4, 
                Offset (0x0A), 
                IACI,   4, 
                IMCI,   4, 
                IPID,   4, 
                ISID,   4
            }
        }

        Scope (\_SB.PCI0)
        {
            Name (BUFA, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared, )
                    {3,4,5,6,7,10,11,12,14,15}
            })
            Name (BUFB, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared, _Y1F)
                    {}
            })
            CreateWordField (BUFB, \_SB.PCI0._Y1F._INT, IRQV)  // _INT: Interrupts
            Method (CRS, 1, Serialized)
            {
                If (Arg0)
                {
                    ShiftLeft (0x01, Arg0, IRQV)
                }
                Else
                {
                    Store (Zero, IRQV)
                }

                Return (BUFB)
            }

            Method (SRS, 1, Serialized)
            {
                CreateWordField (Arg0, 0x01, IRQ0)
                FindSetRightBit (IRQ0, Local0)
                Decrement (Local0)
                Return (Local0)
            }

            Name (BUFI, ResourceTemplate ()
            {
                Interrupt (ResourceConsumer, Level, ActiveHigh, Shared, ,, )
                {
                    0x00000014,
                    0x00000015,
                    0x00000016,
                    0x00000017,
                }
            })
            Method (CRSI, 1, Serialized)
            {
                Name (IRZ5, ResourceTemplate ()
                {
                    Interrupt (ResourceConsumer, Level, ActiveHigh, Shared, ,, _Y20)
                    {
                        0x00000007,
                    }
                })
                CreateWordField (IRZ5, \_SB.PCI0.CRSI._Y20._INT, INZ5)  // _INT: Interrupts
                Store (0x00, Local0)
                If (LEqual (Arg0, 0x08))
                {
                    Store (0x14, Local0)
                }

                If (LEqual (Arg0, 0x0D))
                {
                    Store (0x15, Local0)
                }

                If (LEqual (Arg0, 0x02))
                {
                    Store (0x16, Local0)
                }

                If (LEqual (Arg0, 0x01))
                {
                    Store (0x17, Local0)
                }

                Store (Local0, INZ5)
                Return (IRZ5)
            }

            Method (SRSI, 1, Serialized)
            {
                CreateWordField (Arg0, 0x05, IRZ6)
                Store (0x00, Local0)
                If (LEqual (IRZ6, 0x14))
                {
                    Store (0x08, Local0)
                }

                If (LEqual (IRZ6, 0x15))
                {
                    Store (0x0D, Local0)
                }

                If (LEqual (IRZ6, 0x16))
                {
                    Store (0x02, Local0)
                }

                If (LEqual (IRZ6, 0x17))
                {
                    Store (0x01, Local0)
                }

                Return (Local0)
            }

            Name (BUFE, ResourceTemplate ()
            {
                Interrupt (ResourceConsumer, Level, ActiveHigh, Shared, ,, )
                {
                    0x00000010,
                    0x00000011,
                    0x00000012,
                    0x00000013,
                }
            })
            Method (CRSE, 1, Serialized)
            {
                Name (IRZ7, ResourceTemplate ()
                {
                    Interrupt (ResourceConsumer, Level, ActiveHigh, Shared, ,, _Y21)
                    {
                        0x00000007,
                    }
                })
                CreateWordField (IRZ7, \_SB.PCI0.CRSE._Y21._INT, INZ7)  // _INT: Interrupts
                Store (0x00, Local0)
                If (LEqual (Arg0, 0x08))
                {
                    Store (0x10, Local0)
                }

                If (LEqual (Arg0, 0x01))
                {
                    Store (0x11, Local0)
                }

                If (LEqual (Arg0, 0x02))
                {
                    Store (0x12, Local0)
                }

                If (LEqual (Arg0, 0x0D))
                {
                    Store (0x13, Local0)
                }

                Store (Local0, INZ7)
                Return (IRZ7)
            }

            Method (SRSE, 1, Serialized)
            {
                CreateWordField (Arg0, 0x05, IRZ8)
                Store (0x00, Local0)
                If (LEqual (IRZ8, 0x10))
                {
                    Store (0x08, Local0)
                }

                If (LEqual (IRZ8, 0x11))
                {
                    Store (0x01, Local0)
                }

                If (LEqual (IRZ8, 0x12))
                {
                    Store (0x02, Local0)
                }

                If (LEqual (IRZ8, 0x13))
                {
                    Store (0x0D, Local0)
                }

                Return (Local0)
            }

            Device (LNK1)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x01)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTW)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTW)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFE)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (INTW))
                    }
                    Else
                    {
                        Return (CRSE (INTW))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), INTW)
                    }
                    Else
                    {
                        Store (SRSE (Arg0), INTW)
                    }
                }
            }

            Device (LNK2)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x02)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTX)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTX)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFE)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (INTX))
                    }
                    Else
                    {
                        Return (CRSE (INTX))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), INTX)
                    }
                    Else
                    {
                        Store (SRSE (Arg0), INTX)
                    }
                }
            }

            Device (LNK3)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x03)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTY)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTY)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFE)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (INTY))
                    }
                    Else
                    {
                        Return (CRSE (INTY))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), INTY)
                    }
                    Else
                    {
                        Store (SRSE (Arg0), INTY)
                    }
                }
            }

            Device (LNK4)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x04)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTZ)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTZ)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFE)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (INTZ))
                    }
                    Else
                    {
                        Return (CRSE (INTZ))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), INTZ)
                    }
                    Else
                    {
                        Store (SRSE (Arg0), INTZ)
                    }
                }
            }

            Device (LNK5)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x05)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (INTE)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, INTE)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFE)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (INTE))
                    }
                    Else
                    {
                        Return (CRSE (INTE))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), INTE)
                    }
                    Else
                    {
                        Store (SRSE (Arg0), INTE)
                    }
                }
            }

            Device (LSMB)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x06)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (ISMB)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, ISMB)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (ISMB))
                    }
                    Else
                    {
                        Return (CRSI (ISMB))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), ISMB)
                    }
                    Else
                    {
                        Store (SRSI (Arg0), ISMB)
                    }
                }
            }

            Device (LUS0)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x07)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (IUS0)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, IUS0)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (IUS0))
                    }
                    Else
                    {
                        Return (CRSI (IUS0))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), IUS0)
                    }
                    Else
                    {
                        Store (SRSI (Arg0), IUS0)
                    }
                }
            }

            Device (LUS2)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x09)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (IUS2)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, IUS2)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (IUS2))
                    }
                    Else
                    {
                        Return (CRSI (IUS2))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), IUS2)
                    }
                    Else
                    {
                        Store (SRSI (Arg0), IUS2)
                    }
                }
            }

            Device (LMAC)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x0A)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (IMAC)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, IMAC)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (IMAC))
                    }
                    Else
                    {
                        Return (CRSI (IMAC))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), IMAC)
                    }
                    Else
                    {
                        Store (SRSI (Arg0), IMAC)
                    }
                }
            }

            Device (LACI)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x0B)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (IACI)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, IACI)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (IACI))
                    }
                    Else
                    {
                        Return (CRSI (IACI))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), IACI)
                    }
                    Else
                    {
                        Store (SRSI (Arg0), IACI)
                    }
                }
            }

            Device (LMCI)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x0C)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (IMCI)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, IMCI)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (IMCI))
                    }
                    Else
                    {
                        Return (CRSI (IMCI))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), IMCI)
                    }
                    Else
                    {
                        Store (SRSI (Arg0), IMCI)
                    }
                }
            }

            Device (LPID)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x0D)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (IPID)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, IPID)
                    Store (0x00, ISID)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (IPID))
                    }
                    Else
                    {
                        Return (CRSI (IPID))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), IPID)
                        Store (SRS (Arg0), ISID)
                    }
                    Else
                    {
                        Store (SRSI (Arg0), IPID)
                        Store (SRSI (Arg0), ISID)
                    }
                }
            }

            Device (LTID)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x0E)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (PSI0)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, PSI0)
                    Store (0x00, SSI0)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (PSI0))
                    }
                    Else
                    {
                        Return (CRSI (PSI0))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), PSI0)
                        Store (SRS (Arg0), SSI0)
                    }
                    Else
                    {
                        Store (SRSI (Arg0), PSI0)
                        Store (SRSI (Arg0), SSI0)
                    }
                }
            }

            Device (LSI1)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x0F)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (PSI0)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, PSI1)
                    Store (0x00, SSI1)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (PSI1))
                    }
                    Else
                    {
                        Return (CRSI (PSI1))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), PSI1)
                        Store (SRS (Arg0), SSI1)
                    }
                    Else
                    {
                        Store (SRSI (Arg0), PSI1)
                        Store (SRSI (Arg0), SSI1)
                    }
                }
            }

            Device (APCP)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x10)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (IPCA)
                    {
                        Return (0x0B)
                    }
                    Else
                    {
                        Return (0x09)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Store (0x00, IPCA)
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (BUFA)
                    }
                    Else
                    {
                        Return (BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (CRS (IPCA))
                    }
                    Else
                    {
                        Return (CRSI (IPCA))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (SRS (Arg0), IPCA)
                    }
                    Else
                    {
                        Store (SRSI (Arg0), IPCA)
                    }
                }
            }
        }

        Device (PCI1)
        {
            Name (_HID, EisaId ("PNP0A03"))  // _HID: Hardware ID
            Name (_ADR, 0x00)  // _ADR: Address
            Name (_UID, 0x02)  // _UID: Unique ID
            Name (_BBN, 0x80)  // _BBN: BIOS Bus Number
            Method (_S1D, 0, NotSerialized)  // _S1D: S1 Device State
            {
                Return (0x00)
            }

            Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
            {
                Return (0x01)
            }

            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                If (\_SB.PCI0.SIO.H0PR)
                {
                    Return (0x00)
                }
                Else
                {
                    Return (0x0F)
                }
            }

            Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
            {
                Return (APIC)
            }

            Name (APIC, Package (0x01)
            {
                Package (0x04)
                {
                    0x000AFFFF, 
                    0x00, 
                    \_SB.PCI1.LMAC, 
                    0x00
                }
            })
            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                Name (CBUF, ResourceTemplate ()
                {
                    WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                        0x0000,             // Granularity
                        0x0080,             // Range Minimum
                        0x00FF,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x0080,             // Length
                        ,, )
                    IO (Decode16,
                        0x0CF8,             // Range Minimum
                        0x0CF8,             // Range Maximum
                        0x01,               // Alignment
                        0x08,               // Length
                        )
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x03B0,             // Range Minimum
                        0x03DF,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x0030,             // Length
                        ,, _Y25, TypeStatic)
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x0D00,             // Range Minimum
                        0xFFFF,             // Range Maximum
                        0x0000,             // Translation Offset
                        0xF300,             // Length
                        ,, _Y22, TypeStatic)
                    DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                        0x00000000,         // Granularity
                        0x000A0000,         // Range Minimum
                        0x000DFFFF,         // Range Maximum
                        0x00000000,         // Translation Offset
                        0x00040000,         // Length
                        ,, _Y24, AddressRangeMemory, TypeStatic)
                    DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                        0x00000000,         // Granularity
                        0xC0B00000,         // Range Minimum
                        0xDFFFFFFF,         // Range Maximum
                        0x00000000,         // Translation Offset
                        0x1F500000,         // Length
                        ,, _Y23, AddressRangeMemory, TypeStatic)
                })
                CreateWordField (CBUF, \_SB.PCI1._CRS._Y22._MIN, PIMN)  // _MIN: Minimum Base Address
                CreateWordField (CBUF, \_SB.PCI1._CRS._Y22._LEN, PILN)  // _LEN: Length
                CreateWordField (CBUF, \_SB.PCI1._CRS._Y22._MAX, PIMX)  // _MAX: Maximum Base Address
                CreateDWordField (CBUF, \_SB.PCI1._CRS._Y23._MIN, PMMN)  // _MIN: Minimum Base Address
                CreateDWordField (CBUF, \_SB.PCI1._CRS._Y23._MAX, PMMX)  // _MAX: Maximum Base Address
                CreateDWordField (CBUF, \_SB.PCI1._CRS._Y23._LEN, PMLN)  // _LEN: Length
                CreateDWordField (CBUF, \_SB.PCI1._CRS._Y24._MIN, VMMN)  // _MIN: Minimum Base Address
                CreateDWordField (CBUF, \_SB.PCI1._CRS._Y24._LEN, VMLN)  // _LEN: Length
                CreateDWordField (CBUF, \_SB.PCI1._CRS._Y24._MAX, VMMX)  // _MAX: Maximum Base Address
                If (LEqual (\_SB.PCI0.K801.PML4, 0x00))
                {
                    And (\_SB.PCI0.K801.PMB3, 0xFFFFFF00, Local0)
                    ShiftRight (Local0, 0x08, Local0)
                    ShiftRight (Local0, 0x08, Local0)
                    Store (Local0, DBUG)
                    Sleep (0x2000)
                    ShiftLeft (Local0, 0x08, Local0)
                    ShiftLeft (Local0, 0x08, Local0)
                    Multiply (Local0, 0x0100, PMMN)
                    ShiftLeft (\_SB.PCI0.K801.PML3, 0x08, Local0)
                    Or (Local0, 0xFFFF, PMMX)
                    ShiftRight (Local0, 0x08, Local0)
                    ShiftRight (Local0, 0x08, Local0)
                    ShiftRight (Local0, 0x08, Local0)
                    Store (Local0, DBUG)
                    Sleep (0x2000)
                    ShiftLeft (Local0, 0x08, Local0)
                    ShiftLeft (Local0, 0x08, Local0)
                    ShiftLeft (Local0, 0x08, Local0)
                    Subtract (PMMX, PMMN, PMLN)
                }
                Else
                {
                    If (LEqual (And (\_SB.PCI0.K801.PML4, 0xFFFFFF00), 0x0B00))
                    {
                        And (\_SB.PCI0.K801.PMB3, 0xFFFFFF00, Local0)
                        Multiply (Local0, 0x0100, PMMN)
                        ShiftLeft (\_SB.PCI0.K801.PML3, 0x08, Local0)
                        Or (Local0, 0xFFFF, PMMX)
                        Subtract (PMMX, PMMN, PMLN)
                        Increment (PMLN)
                    }
                    Else
                    {
                        If (LEqual (And (\_SB.PCI0.K801.PML4, 0xFF), 0x80))
                        {
                            And (\_SB.PCI0.K801.PMB3, 0xFFFFFF00, Local0)
                            Multiply (Local0, 0x0100, PMMN)
                            ShiftLeft (\_SB.PCI0.K801.PML3, 0x08, Local0)
                            Or (Local0, 0xFFFF, PMMX)
                            Subtract (PMMX, PMMN, PMLN)
                            Increment (PMLN)
                        }
                        Else
                        {
                            And (\_SB.PCI0.K801.PMB3, 0xFFFFFF00, Local0)
                            Multiply (Local0, 0x0100, PMMN)
                            ShiftLeft (\_SB.PCI0.K801.PML4, 0x08, Local0)
                            Or (Local0, 0xFFFF, PMMX)
                            Subtract (PMMX, PMMN, PMLN)
                            Increment (PMLN)
                        }
                    }
                }

                If (LNotEqual (\_SB.PCI0.K801.PML1, 0x0B01))
                {
                    Store (0x000C0000, VMMN)
                    Store (0x00020000, VMLN)
                }

                And (\_SB.PCI0.K801.PIB2, 0xFFFFF000, PIMN)
                And (\_SB.PCI0.K801.PIL2, 0xFFFFF000, Local0)
                Or (Local0, 0x0FFF, PIMX)
                Subtract (PIMX, PIMN, PILN)
                Increment (PILN)
                CreateWordField (CBUF, \_SB.PCI1._CRS._Y25._MIN, VGMN)  // _MIN: Minimum Base Address
                CreateWordField (CBUF, \_SB.PCI1._CRS._Y25._LEN, VGLN)  // _LEN: Length
                CreateWordField (CBUF, \_SB.PCI1._CRS._Y25._MAX, VGMX)  // _MAX: Maximum Base Address
                If (LNotEqual (\_SB.PCI0.K801.PML1, 0x0B01))
                {
                    Store (Zero, VGMN)
                    Store (Zero, VGLN)
                    Store (Zero, VGMX)
                }

                Return (CBUF)
            }

            Device (LPC0)
            {
                Name (_ADR, 0x00010000)  // _ADR: Address
            }

            Device (MAC0)
            {
                Name (_ADR, 0x000A0000)  // _ADR: Address
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x00, 
                    0x05
                })
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }
            }

            Device (XVR0)
            {
                Name (_ADR, 0x000E0000)  // _ADR: Address
                Name (_UID, 0x03)  // _UID: Unique ID
                OperationRegion (A1E0, PCI_Config, 0x19, 0x01)
                Field (A1E0, ByteAcc, NoLock, Preserve)
                {
                    SECB,   8
                }

                Method (_BBN, 0, NotSerialized)  // _BBN: BIOS Bus Number
                {
                    Return (SECB)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (P0A1, Package (0x04)
                {
                    Package (0x04)
                    {
                        0xFFFF, 
                        0x00, 
                        \_SB.PCI1.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x01, 
                        \_SB.PCI1.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x02, 
                        \_SB.PCI1.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x03, 
                        \_SB.PCI1.LNK2, 
                        0x00
                    }
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    Return (P0A1)
                }

                Device (Z003)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                }
            }

            Device (XVR1)
            {
                Name (_ADR, 0x000D0000)  // _ADR: Address
                Name (_UID, 0x04)  // _UID: Unique ID
                OperationRegion (A1E0, PCI_Config, 0x19, 0x01)
                Field (A1E0, ByteAcc, NoLock, Preserve)
                {
                    SECB,   8
                }

                Method (_BBN, 0, NotSerialized)  // _BBN: BIOS Bus Number
                {
                    Return (SECB)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (P1A1, Package (0x04)
                {
                    Package (0x04)
                    {
                        0xFFFF, 
                        0x00, 
                        \_SB.PCI1.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x01, 
                        \_SB.PCI1.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x02, 
                        \_SB.PCI1.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x03, 
                        \_SB.PCI1.LNK3, 
                        0x00
                    }
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    Return (P1A1)
                }

                Device (Z004)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                }
            }

            Device (XVR2)
            {
                Name (_ADR, 0x000C0000)  // _ADR: Address
                Name (_UID, 0x05)  // _UID: Unique ID
                OperationRegion (A1E0, PCI_Config, 0x19, 0x01)
                Field (A1E0, ByteAcc, NoLock, Preserve)
                {
                    SECB,   8
                }

                Method (_BBN, 0, NotSerialized)  // _BBN: BIOS Bus Number
                {
                    Return (SECB)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (P2A1, Package (0x04)
                {
                    Package (0x04)
                    {
                        0xFFFF, 
                        0x00, 
                        \_SB.PCI1.LNK1, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x01, 
                        \_SB.PCI1.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x02, 
                        \_SB.PCI1.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x03, 
                        \_SB.PCI1.LNK4, 
                        0x00
                    }
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    Return (P2A1)
                }

                Device (Z005)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                }
            }

            Device (XVR3)
            {
                Name (_ADR, 0x000B0000)  // _ADR: Address
                Name (_UID, 0x06)  // _UID: Unique ID
                OperationRegion (A1E0, PCI_Config, 0x19, 0x01)
                Field (A1E0, ByteAcc, NoLock, Preserve)
                {
                    SECB,   8
                }

                Method (_BBN, 0, NotSerialized)  // _BBN: BIOS Bus Number
                {
                    Return (SECB)
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    Return (0x0F)
                }

                Name (P3A1, Package (0x04)
                {
                    Package (0x04)
                    {
                        0xFFFF, 
                        0x00, 
                        \_SB.PCI1.LNK2, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x01, 
                        \_SB.PCI1.LNK3, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x02, 
                        \_SB.PCI1.LNK4, 
                        0x00
                    }, 

                    Package (0x04)
                    {
                        0xFFFF, 
                        0x03, 
                        \_SB.PCI1.LNK1, 
                        0x00
                    }
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    Return (P3A1)
                }

                Device (Z006)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                }
            }
        }

        Scope (\_SB.PCI1)
        {
            OperationRegion (\_SB.PCI1.LPC0.PIRQ, PCI_Config, 0x7C, 0x0C)
            Field (\_SB.PCI1.LPC0.PIRQ, AnyAcc, NoLock, Preserve)
            {
                INTW,   4, 
                INTX,   4, 
                INTY,   4, 
                INTZ,   4, 
                INTE,   4, 
                SSI1,   4, 
                SSI0,   4, 
                IPCA,   4, 
                ISCI,   4, 
                ITCO,   4, 
                ISMB,   4, 
                IUS2,   4, 
                INTU,   4, 
                INTS,   4, 
                PSI1,   4, 
                PSI0,   4, 
                IUS0,   4, 
                IUS1,   4, 
                IMAC,   4, 
                Offset (0x0A), 
                IACI,   4, 
                IMCI,   4, 
                IPID,   4, 
                ISID,   4
            }
        }

        Scope (\_SB.PCI1)
        {
            Name (BUFA, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared, )
                    {3,4,5,6,7,10,11,12,14,15}
            })
            Name (BUFB, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared, _Y26)
                    {}
            })
            CreateWordField (BUFB, \_SB.PCI1._Y26._INT, IRQV)  // _INT: Interrupts
            Method (CRS, 1, Serialized)
            {
                If (Arg0)
                {
                    ShiftLeft (0x01, Arg0, IRQV)
                }
                Else
                {
                    Store (Zero, IRQV)
                }

                Return (BUFB)
            }

            Method (SRS, 1, Serialized)
            {
                CreateWordField (Arg0, 0x01, IRQ0)
                FindSetRightBit (IRQ0, Local0)
                Decrement (Local0)
                Return (Local0)
            }

            Name (BUFI, ResourceTemplate ()
            {
                Interrupt (ResourceConsumer, Level, ActiveHigh, Shared, ,, )
                {
                    0x00000034,
                    0x00000035,
                    0x00000036,
                    0x00000037,
                }
            })
            Method (CRSI, 1, Serialized)
            {
                Name (IRZ5, ResourceTemplate ()
                {
                    Interrupt (ResourceConsumer, Level, ActiveHigh, Shared, ,, _Y27)
                    {
                        0x00000007,
                    }
                })
                CreateWordField (IRZ5, \_SB.PCI1.CRSI._Y27._INT, INZ5)  // _INT: Interrupts
                Store (0x00, Local0)
                If (LEqual (Arg0, 0x08))
                {
                    Store (0x34, Local0)
                }

                If (LEqual (Arg0, 0x0D))
                {
                    Store (0x35, Local0)
                }

                If (LEqual (Arg0, 0x02))
                {
                    Store (0x36, Local0)
                }

                If (LEqual (Arg0, 0x01))
                {
                    Store (0x37, Local0)
                }

                Store (Local0, INZ5)
                Return (IRZ5)
            }

            Method (SRSI, 1, Serialized)
            {
                CreateWordField (Arg0, 0x05, IRZ6)
                Store (0x00, Local0)
                If (LEqual (IRZ6, 0x34))
                {
                    Store (0x08, Local0)
                }

                If (LEqual (IRZ6, 0x35))
                {
                    Store (0x0D, Local0)
                }

                If (LEqual (IRZ6, 0x36))
                {
                    Store (0x02, Local0)
                }

                If (LEqual (IRZ6, 0x37))
                {
                    Store (0x01, Local0)
                }

                Return (Local0)
            }

            Name (BUFE, ResourceTemplate ()
            {
                Interrupt (ResourceConsumer, Level, ActiveHigh, Shared, ,, )
                {
                    0x00000030,
                    0x00000031,
                    0x00000032,
                    0x00000033,
                }
            })
            Method (CRSE, 1, Serialized)
            {
                Name (IRZ7, ResourceTemplate ()
                {
                    Interrupt (ResourceConsumer, Level, ActiveHigh, Shared, ,, _Y28)
                    {
                        0x00000007,
                    }
                })
                CreateWordField (IRZ7, \_SB.PCI1.CRSE._Y28._INT, INZ7)  // _INT: Interrupts
                Store (0x00, Local0)
                If (LEqual (Arg0, 0x08))
                {
                    Store (0x30, Local0)
                }

                If (LEqual (Arg0, 0x01))
                {
                    Store (0x31, Local0)
                }

                If (LEqual (Arg0, 0x02))
                {
                    Store (0x32, Local0)
                }

                If (LEqual (Arg0, 0x0D))
                {
                    Store (0x33, Local0)
                }

                Store (Local0, INZ7)
                Return (IRZ7)
            }

            Method (SRSE, 1, Serialized)
            {
                CreateWordField (Arg0, 0x05, IRZ8)
                Store (0x00, Local0)
                If (LEqual (IRZ8, 0x30))
                {
                    Store (0x08, Local0)
                }

                If (LEqual (IRZ8, 0x31))
                {
                    Store (0x01, Local0)
                }

                If (LEqual (IRZ8, 0x32))
                {
                    Store (0x02, Local0)
                }

                If (LEqual (IRZ8, 0x33))
                {
                    Store (0x0D, Local0)
                }

                Return (Local0)
            }

            Device (LNK1)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x11)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\INTW)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.INTW)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \INTW)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.INTW)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFE)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\INTW))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSE (\_SB.PCI1.INTW))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), \INTW)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSE (Arg0), \_SB.PCI1.INTW)
                    }
                }
            }

            Device (LNK2)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x12)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\INTX)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.INTX)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \INTX)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.INTX)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFE)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\INTX))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSE (\_SB.PCI1.INTX))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), \INTX)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSE (Arg0), \_SB.PCI1.INTX)
                    }
                }
            }

            Device (LNK3)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x13)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\INTY)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.INTY)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \INTY)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.INTY)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFE)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\INTY))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSE (\_SB.PCI1.INTY))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), \INTY)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSE (Arg0), \_SB.PCI1.INTY)
                    }
                }
            }

            Device (LNK4)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x14)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\INTZ)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.INTZ)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \INTZ)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.INTZ)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFE)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\INTZ))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSE (\_SB.PCI1.INTZ))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), \INTZ)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSE (Arg0), \_SB.PCI1.INTZ)
                    }
                }
            }

            Device (LNK5)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x15)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\INTE)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.INTE)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \INTE)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.INTE)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFE)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\INTE))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSE (\_SB.PCI1.INTE))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), \INTE)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSE (Arg0), \_SB.PCI1.INTE)
                    }
                }
            }

            Device (LUS0)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x17)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\INTY)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.IUS0)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \INTY)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.IUS0)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\INTY))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSI (\_SB.PCI1.IUS0))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), \INTY)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSI (Arg0), \_SB.PCI1.IUS0)
                    }
                }
            }

            Device (LUS2)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x19)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\INTZ)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.IUS2)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \INTZ)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.IUS2)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\INTZ))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSI (\_SB.PCI1.IUS2))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), \INTZ)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSI (Arg0), \_SB.PCI1.IUS2)
                    }
                }
            }

            Device (LMAC)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x1A)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\INTY)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.IMAC)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \INTY)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.IMAC)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\INTY))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSI (\_SB.PCI1.IMAC))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), \INTY)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSI (Arg0), \_SB.PCI1.IMAC)
                    }
                }
            }

            Device (LACI)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x1B)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\IACI)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.IACI)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \IACI)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.IACI)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\IACI))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSI (\_SB.PCI1.IACI))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), IACI)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSI (Arg0), \_SB.PCI1.IACI)
                    }
                }
            }

            Device (LMCI)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x1C)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\IMCI)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.IMCI)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \IMCI)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.IMCI)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\IMCI))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSI (\_SB.PCI1.IMCI))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), \IMCI)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSI (Arg0), \_SB.PCI1.IMCI)
                    }
                }
            }

            Device (LPID)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x1D)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\INTY)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.IPID)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \INTY)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.IPID)
                        Store (0x00, \_SB.PCI1.ISID)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\INTY))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSI (\_SB.PCI1.IPID))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), \INTY)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSI (Arg0), \_SB.PCI1.IPID)
                        Store (\_SB.PCI1.SRSI (Arg0), \_SB.PCI1.ISID)
                    }
                }
            }

            Device (LTID)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x1E)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\INTX)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.PSI0)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \INTX)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.PSI0)
                        Store (0x00, \_SB.PCI1.SSI0)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\INTX))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSI (\_SB.PCI1.PSI0))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), \INTX)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSI (Arg0), \_SB.PCI1.PSI0)
                        Store (\_SB.PCI1.SRSI (Arg0), \_SB.PCI1.SSI0)
                    }
                }
            }

            Device (LSI1)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x1F)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LNot (PICF))
                    {
                        If (\INTW)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                    Else
                    {
                        If (\_SB.PCI1.PSI0)
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (0x09)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    If (LNot (PICF))
                    {
                        Store (0x00, \INTW)
                    }
                    Else
                    {
                        Store (0x00, \_SB.PCI1.PSI1)
                        Store (0x00, \_SB.PCI1.SSI1)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.BUFA)
                    }
                    Else
                    {
                        Return (\_SB.PCI1.BUFI)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Return (\_SB.PCI0.CRS (\INTW))
                    }
                    Else
                    {
                        Return (\_SB.PCI1.CRSI (\_SB.PCI1.PSI1))
                    }
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    If (LNot (PICF))
                    {
                        Store (\_SB.PCI0.SRS (Arg0), \INTW)
                    }
                    Else
                    {
                        Store (\_SB.PCI1.SRSI (Arg0), \_SB.PCI1.PSI1)
                        Store (\_SB.PCI1.SRSI (Arg0), \_SB.PCI1.SSI1)
                    }
                }
            }
        }
    }

    Scope (\_SB.PCI0.LPC0)
    {
        OperationRegion (RGA0, PCI_Config, 0xA0, 0x04)
        Field (RGA0, AnyAcc, NoLock, Preserve)
        {
            COMP,   8, 
            ADIO,   4, 
            MIDS,   4, 
            MSSS,   4, 
            FDCP,   2, 
            ADLB,   1, 
            Offset (0x03), 
            LPTP,   3, 
                ,   1, 
            DVR0,   1, 
            DVR1,   1, 
            DVR2,   1, 
            DVR3,   1
        }

        OperationRegion (RGA1, PCI_Config, 0xA4, 0x04)
        Field (RGA1, AnyAcc, NoLock, Preserve)
        {
            GMPS,   16, 
            Offset (0x04)
        }

        Method (Z007, 1, NotSerialized)
        {
            Store (\_SB.PCI0.LPC0.COMP, Local0)
            If (LEqual (Arg0, 0x03F8))
            {
                Not (0x01, Local2)
                And (Local0, Local2, Local0)
            }
            Else
            {
                If (LEqual (Arg0, 0x02F8))
                {
                    Not (0x02, Local2)
                    And (Local0, Local2, Local0)
                }
                Else
                {
                    If (LEqual (Arg0, 0x03E8))
                    {
                        Not (0x80, Local2)
                        And (Local0, Local2, Local0)
                    }
                    Else
                    {
                        If (LEqual (Arg0, 0x02E8))
                        {
                            Not (0x20, Local2)
                            And (Local0, Local2, Local0)
                        }
                    }
                }
            }

            Store (Local0, \_SB.PCI0.LPC0.COMP)
        }

        Method (Z008, 1, NotSerialized)
        {
            Store (\_SB.PCI0.LPC0.COMP, Local0)
            If (LEqual (Arg0, 0x03F8))
            {
                Or (0x01, Local0, Local0)
            }
            Else
            {
                If (LEqual (Arg0, 0x02F8))
                {
                    Or (0x02, Local0, Local0)
                }
                Else
                {
                    If (LEqual (Arg0, 0x03E8))
                    {
                        Or (0x80, Local0, Local0)
                    }
                    Else
                    {
                        If (LEqual (Arg0, 0x02E8))
                        {
                            Or (0x20, Local0, Local0)
                        }
                    }
                }
            }

            Store (Local0, \_SB.PCI0.LPC0.COMP)
        }

        Method (Z009, 1, NotSerialized)
        {
            Store (\_SB.PCI0.LPC0.LPTP, Local0)
            If (LEqual (Arg0, 0x0378))
            {
                Not (0x01, Local2)
                And (Local0, Local2, Local0)
            }
            Else
            {
                If (LEqual (Arg0, 0x0278))
                {
                    Not (0x02, Local2)
                    And (Local0, Local2, Local0)
                }
                Else
                {
                    If (LEqual (Arg0, 0x03BC))
                    {
                        Not (0x04, Local2)
                        And (Local0, Local2, Local0)
                    }
                }
            }

            Store (Local0, \_SB.PCI0.LPC0.LPTP)
        }

        Method (Z00A, 1, NotSerialized)
        {
            Store (\_SB.PCI0.LPC0.LPTP, Local0)
            If (LEqual (Arg0, 0x0378))
            {
                Or (0x01, Local0, Local0)
            }
            Else
            {
                If (LEqual (Arg0, 0x0278))
                {
                    Or (0x02, Local0, Local0)
                }
                Else
                {
                    If (LEqual (Arg0, 0x03BC))
                    {
                        Or (0x04, Local0, Local0)
                    }
                }
            }

            Store (Local0, \_SB.PCI0.LPC0.LPTP)
        }

        Method (Z00B, 1, NotSerialized)
        {
            Store (\_SB.PCI0.LPC0.FDCP, Local0)
            If (LEqual (Arg0, 0x03F0))
            {
                Not (0x01, Local2)
                And (Local0, Local2, Local0)
            }
            Else
            {
                If (LEqual (Arg0, 0x0370))
                {
                    Not (0x02, Local2)
                    And (Local0, Local2, Local0)
                }
            }

            Store (Local0, \_SB.PCI0.LPC0.FDCP)
        }

        Method (Z00C, 1, NotSerialized)
        {
            Store (\_SB.PCI0.LPC0.FDCP, Local0)
            If (LEqual (Arg0, 0x03F0))
            {
                Or (0x01, Local0, Local0)
            }
            Else
            {
                If (LEqual (Arg0, 0x0370))
                {
                    Or (0x02, Local0, Local0)
                }
            }

            Store (Local0, \_SB.PCI0.LPC0.FDCP)
        }

        Method (Z00D, 1, NotSerialized)
        {
            Store (\_SB.PCI0.LPC0.GMPS, Local0)
            If (LEqual (Arg0, 0x0200))
            {
                Not (0xFF, Local2)
                And (Local0, Local2, Local0)
            }

            If (LEqual (Arg0, 0x0208))
            {
                Not (0xFF00, Local2)
                And (Local0, Local2, Local0)
            }

            Store (Local0, \_SB.PCI0.LPC0.GMPS)
        }

        Method (Z00E, 1, NotSerialized)
        {
            Store (\_SB.PCI0.LPC0.GMPS, Local0)
            If (LEqual (Arg0, 0x0200))
            {
                Or (0xFF, Local0, Local0)
            }

            If (LEqual (Arg0, 0x0208))
            {
                Or (0xFF00, Local0, Local0)
            }

            Store (Local0, \_SB.PCI0.LPC0.GMPS)
        }
    }

    OperationRegion (DBGP, SystemIO, 0x80, 0x01)
    Field (DBGP, ByteAcc, NoLock, Preserve)
    {
        DBUG,   8
    }

    OperationRegion (Z00F, SystemIO, 0x8484, 0x01)
    Field (DBGP, ByteAcc, NoLock, Preserve)
    {
        Z002,   8
    }

    Name (FWSO, "FWSO")
}

