/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20121114-32 [Dec 15 2012]
 * Copyright (c) 2000 - 2012 Intel Corporation
 * 
 * Disassembly of (null), Mon Dec 17 08:25:05 2012
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x000038BB (14523)
 *     Revision         0x01 **** 32-bit table (V1), no 64-bit math support
 *     Checksum         0x39
 *     OEM ID           "AWARD "
 *     OEM Table ID     "AWRDACPI"
 *     OEM Revision     0x00001000 (4096)
 *     Compiler ID      "MSFT"
 *     Compiler Version 0x0100000D (16777229)
 */

DefinitionBlock ("DSDT.aml", "DSDT", 1, "AWARD ", "AWRDACPI", 0x00001000)
{
    Scope (\_PR)
    {
        Processor (\_PR.CPU0, 0x00, 0x00000000, 0x00) {}
    }

    Name (\_S0, Package (0x04)  // _S0_: S0 System State
    {
        0x00, 
        0x00, 
        0x00, 
        0x00
    })
    Name (\_S3, Package (0x04)  // _S3_: S3 System State
    {
        0x03, 
        0x01, 
        0x01, 
        0x01
    })
    Name (\_S4, Package (0x04)  // _S4_: S4 System State
    {
        0x04, 
        0x04, 
        0x04, 
        0x04
    })
    Name (\_S5, Package (0x04)  // _S5_: S5 System State
    {
        0x05, 
        0x05, 
        0x05, 
        0x05
    })
    OperationRegion (\DEBG, SystemIO, 0x80, 0x01)
    Field (\DEBG, ByteAcc, NoLock, Preserve)
    {
        DBG1,   8
    }

    OperationRegion (\P01, SystemIO, 0x1001, 0x01)
    Field (\P01, ByteAcc, NoLock, Preserve)
    {
        P1,     8
    }

    OperationRegion (PR48, SystemIO, 0x1048, 0x01)
    Field (PR48, ByteAcc, NoLock, Preserve)
    {
        P48,    8
    }

    OperationRegion (\PR49, SystemIO, 0x1049, 0x01)
    Field (\PR49, ByteAcc, NoLock, Preserve)
    {
        P49,    8
    }

    OperationRegion (\TRAP, SystemIO, 0x1050, 0x02)
    Field (\TRAP, WordAcc, NoLock, Preserve)
    {
        TRA0,   16
    }

    OperationRegion (EXTM, SystemMemory, 0x000FF830, 0x10)
    Field (EXTM, WordAcc, NoLock, Preserve)
    {
        ROM1,   16, 
        RMS1,   16, 
        ROM2,   16, 
        RMS2,   16, 
        ROM3,   16, 
        RMS3,   16, 
        AMEM,   32
    }

    OperationRegion (\PR20, SystemIO, 0x1020, 0x02)
    Field (\PR20, WordAcc, NoLock, Preserve)
    {
        P20,    16
    }

    OperationRegion (\PR22, SystemIO, 0x1022, 0x02)
    Field (\PR22, WordAcc, NoLock, Preserve)
    {
        P22,    16
    }

    OperationRegion (\PR30, SystemIO, 0x1030, 0x02)
    Field (\PR30, WordAcc, NoLock, Preserve)
    {
        P30,    16
    }

    OperationRegion (\PR40, SystemIO, 0x1040, 0x01)
    Field (\PR40, ByteAcc, NoLock, Preserve)
    {
        P40,    8
    }

    OperationRegion (\PR42, SystemIO, 0x1042, 0x01)
    Field (\PR42, ByteAcc, NoLock, Preserve)
    {
        P42,    8
    }

    OperationRegion (\PR62, SystemIO, 0x1062, 0x02)
    Field (\PR62, ByteAcc, NoLock, Preserve)
    {
        P62,    16
    }

    OperationRegion (\CGPO, SystemIO, 0x103A, 0x03)
    Field (\CGPO, ByteAcc, NoLock, Preserve)
    {
        GP00,   1, 
        GP01,   1, 
        GP02,   1, 
        GP03,   1, 
        GP04,   1, 
        GP05,   1, 
        GP06,   1, 
        GP07,   1, 
        GP08,   1, 
        GP09,   1, 
        GP0A,   1, 
        GP0B,   1, 
        GP0C,   1, 
        GP0D,   1, 
        GP0E,   1, 
        GP0F,   1
    }

    Scope (\)
    {
        Name (PICF, 0x00)
        Method (_PIC, 1, NotSerialized)  // _PIC: Interrupt Model
        {
            Store (Arg0, PICF)
        }
    }

    Name (OSFL, 0x01)
    Method (STRC, 2, NotSerialized)
    {
        If (LNotEqual (SizeOf (Arg0), SizeOf (Arg1)))
        {
            Return (0x00)
        }

        Add (SizeOf (Arg0), 0x01, Local0)
        Name (BUF0, Buffer (Local0) {})
        Name (BUF1, Buffer (Local0) {})
        Store (Arg0, BUF0)
        Store (Arg1, BUF1)
        While (Local0)
        {
            Decrement (Local0)
            If (LNotEqual (DerefOf (Index (BUF0, Local0)), DerefOf (Index (
                BUF1, Local0))))
            {
                Return (Zero)
            }
        }

        Return (One)
    }

    OperationRegion (RTCM, SystemIO, 0x70, 0x02)
    Field (RTCM, ByteAcc, NoLock, Preserve)
    {
        CMIN,   8, 
        CMDA,   8
    }

    IndexField (CMIN, CMDA, ByteAcc, NoLock, Preserve)
    {
        Offset (0x0F), 
        SHUT,   8
    }

    OperationRegion (INFO, SystemMemory, 0x000FF840, 0x01)
    Field (INFO, ByteAcc, NoLock, Preserve)
    {
        KBDI,   1, 
        RTCW,   1, 
        PS2F,   1, 
        IRFL,   2, 
        DISE,   1, 
        SSHU,   1
    }

    OperationRegion (BEEP, SystemIO, 0x61, 0x01)
    Field (BEEP, ByteAcc, NoLock, Preserve)
    {
        S1B,    8
    }

    OperationRegion (CONT, SystemIO, 0x40, 0x04)
    Field (CONT, ByteAcc, NoLock, Preserve)
    {
        CNT0,   8, 
        CNT1,   8, 
        CNT2,   8, 
        CTRL,   8
    }

    Method (SPKR, 1, NotSerialized)
    {
        Store (S1B, Local0)
        Store (0xB6, CTRL)
        Store (0x55, CNT2)
        Store (0x03, CNT2)
        Store (Arg0, Local2)
        While (LGreater (Local2, 0x00))
        {
            Or (S1B, 0x03, S1B)
            Store (0x5FFF, Local3)
            While (LGreater (Local3, 0x00))
            {
                Decrement (Local3)
            }

            And (S1B, 0xFC, S1B)
            Store (0x0EFF, Local3)
            While (LGreater (Local3, 0x00))
            {
                Decrement (Local3)
            }

            Decrement (Local2)
        }

        Store (Local0, S1B)
    }

    Method (\_PTS, 1, NotSerialized)  // _PTS: Prepare To Sleep
    {
        Store (0xFF, P1)
        If (LEqual (Arg0, 0x03))
        {
            Store (Arg0, P48)
        }

        Or (P62, 0x40, P62)
        Store (0xFFFF, P20)
        Store (0xFFFF, P30)
        Or (Arg0, 0xF0, DBG1)
    }

    Method (\_WAK, 1, NotSerialized)  // _WAK: Wake
    {
        If (LEqual (Arg0, 0x04))
        {
            If (LEqual (OSFL, 0x00))
            {
                Store (0x58, P48)
            }

            If (LEqual (OSFL, 0x02))
            {
                Store (0x57, P48)
            }

            If (LEqual (OSFL, 0x01))
            {
                Store (0x56, P48)
            }
        }

        If (LGreaterEqual (Arg0, 0x03))
        {
            Notify (\_SB.PCI0.USB0, 0x00)
            Notify (\_SB.PCI0.USB1, 0x00)
            Notify (\_SB.PCI0.USB0, 0x01)
            Notify (\_SB.PCI0.USB1, 0x01)
        }

        Store (0xFF, DBG1)
        Notify (\_SB.PCI0.UAR1, 0x00)
        And (P62, 0xFFBF, P62)
        Store (P40, Local0)
        Store (Local0, P40)
        If (LEqual (OSFL, 0x01))
        {
            Notify (\_SB.PWRB, 0x02)
        }
        Else
        {
            If (LEqual (Arg0, 0x01))
            {
                And (P1, 0x04, Local0)
                If (LEqual (Local0, 0x00))
                {
                    Notify (\_SB.PWRB, 0x02)
                }
            }

            If (LEqual (Arg0, 0x03))
            {
                If (LEqual (RTCW, Zero))
                {
                    Notify (\_SB.PWRB, 0x02)
                }
            }
        }
    }

    Scope (\_SI)
    {
        Method (_MSG, 1, NotSerialized)  // _MSG: Message
        {
            Store (Local0, Local0)
        }

        Method (_SST, 1, NotSerialized)  // _SST: System Status
        {
            Store (Local0, Local0)
        }
    }

    Scope (\_GPE)
    {
        Method (_L13, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.FUTS, 0x80)
        }

        Method (_L0E, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.USB0, 0x02)
        }

        Method (_L04, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.USB1, 0x02)
        }

        Method (_L07, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.USB2, 0x02)
        }

        Method (_L06, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.USB3, 0x02)
        }

        Method (_L05, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.AMR0, 0x02)
        }

        Method (_L08, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.UAR1, 0x00)
        }

        Method (_L0F, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.PS2K, 0x00)
        }

        Method (_L0D, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.PS2M, 0x00)
        }

        Method (_L0B, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0, 0x02)
            Notify (\_SB.PCI0.PCI1, 0x02)
            Notify (\_SB.PCI0.PCI2, 0x02)
            Notify (\_SB.PCI0.PCI3, 0x02)
            Notify (\_SB.PCI0.PCI4, 0x02)
        }

        Method (_L0C, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.MAC0, 0x02)
        }
    }

    Scope (\_SB)
    {
        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))  // _HID: Hardware ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                Return (0x0B)
            }
        }

        Device (FUTS)
        {
            Name (_HID, EisaId ("PNP0C0E"))  // _HID: Hardware ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                Return (0x0B)
            }
        }

        Device (MEM)
        {
            Name (_HID, EisaId ("PNP0C01"))  // _HID: Hardware ID
            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                Name (BUF0, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0x000F0000,         // Address Base
                        0x00004000,         // Address Length
                        _Y00)
                    Memory32Fixed (ReadWrite,
                        0x000F4000,         // Address Base
                        0x00004000,         // Address Length
                        _Y01)
                    Memory32Fixed (ReadWrite,
                        0x000F8000,         // Address Base
                        0x00004000,         // Address Length
                        _Y02)
                    Memory32Fixed (ReadWrite,
                        0x000FC000,         // Address Base
                        0x00004000,         // Address Length
                        _Y03)
                    Memory32Fixed (ReadWrite,
                        0xFFFF0000,         // Address Base
                        0x00010000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0xFFEE0000,         // Address Base
                        0x00020000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0xFFFE0000,         // Address Base
                        0x00010000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0xFEC00000,         // Address Base
                        0x00100000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0xFEE00000,         // Address Base
                        0x00100000,         // Address Length
                        )
                })
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y00._BAS, RMA1)  // _BAS: Base Address
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y00._LEN, RSS1)  // _LEN: Length
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y01._BAS, RMA2)  // _BAS: Base Address
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y01._LEN, RSS2)  // _LEN: Length
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y02._BAS, RMA3)  // _BAS: Base Address
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y02._LEN, RSS3)  // _LEN: Length
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y03._BAS, RMA4)  // _BAS: Base Address
                CreateDWordField (BUF0, \_SB.MEM._CRS._Y03._LEN, RSS4)  // _LEN: Length
                If (LNotEqual (ROM1, Zero))
                {
                    Store (RMA1, RMA2)
                    ShiftLeft (ROM1, 0x08, Local0)
                    Store (Local0, RMA1)
                    ShiftLeft (RMS1, 0x08, Local0)
                    Store (Local0, RSS1)
                    Store (0x8000, RSS2)
                }

                If (LNotEqual (ROM2, Zero))
                {
                    Store (RMA2, RMA3)
                    ShiftLeft (ROM2, 0x08, Local0)
                    Store (Local0, RMA2)
                    ShiftLeft (RMS2, 0x08, Local0)
                    Store (Local0, RSS2)
                    Store (0xC000, RSS3)
                }

                If (LNotEqual (ROM3, Zero))
                {
                    Store (RMA3, RMA4)
                    ShiftLeft (ROM3, 0x08, Local0)
                    Store (Local0, RMA3)
                    ShiftLeft (RMS3, 0x08, Local0)
                    Store (Local0, RSS3)
                    Store (0x00010000, RSS4)
                }

                Return (BUF0)
            }
        }

        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A03"))  // _HID: Hardware ID
            Name (_ADR, 0x00)  // _ADR: Address
            Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
            {
                If (LEqual (OSFL, 0x02))
                {
                    Return (0x02)
                }
                Else
                {
                    Return (0x03)
                }
            }

            Device (IDEC)
            {
                Name (_ADR, 0x00020005)  // _ADR: Address
                Name (IO5T, Package (0x03)
                {
                    Package (0x07)
                    {
                        0x78, 
                        0xB4, 
                        0x014A, 
                        0x0186, 
                        0x0258, 
                        0x78, 
                        0x96
                    }, 

                    Package (0x07)
                    {
                        0x06, 
                        0x07, 
                        0x1C, 
                        0x1C, 
                        0x1C, 
                        0x06, 
                        0x07
                    }, 

                    Package (0x07)
                    {
                        0x04, 
                        0x09, 
                        0x03, 
                        0x09, 
                        0x1E, 
                        0x04, 
                        0x06
                    }
                })
                Name (IO6T, Package (0x03)
                {
                    Package (0x07)
                    {
                        0x78, 
                        0xB4, 
                        0x014A, 
                        0x0186, 
                        0x0258, 
                        0x78, 
                        0xB4
                    }, 

                    Package (0x07)
                    {
                        0x09, 
                        0x0A, 
                        0x26, 
                        0x26, 
                        0x26, 
                        0x09, 
                        0x0A
                    }, 

                    Package (0x07)
                    {
                        0x05, 
                        0x0C, 
                        0x04, 
                        0x0C, 
                        0x28, 
                        0x05, 
                        0x0C
                    }
                })
                Name (UM5T, Package (0x06)
                {
                    0x0B, 
                    0x07, 
                    0x05, 
                    0x04, 
                    0x02, 
                    0x01
                })
                Name (UM6T, Package (0x07)
                {
                    0x0F, 
                    0x0A, 
                    0x07, 
                    0x05, 
                    0x03, 
                    0x02, 
                    0x01
                })
                Name (PIO5, Package (0x05)
                {
                    0x3A, 
                    0x25, 
                    0x1F, 
                    0x10, 
                    0x0A
                })
                Name (PIO6, Package (0x05)
                {
                    0x4E, 
                    0x32, 
                    0x2A, 
                    0x16, 
                    0x0E
                })
                Name (CRCT, Package (0x07)
                {
                    0x06, 
                    0x04, 
                    0x03, 
                    0x01, 
                    0x01, 
                    0x01, 
                    0x01
                })
                Name (INTT, Package (0x05)
                {
                    0x02, 
                    0x02, 
                    0x02, 
                    0x04, 
                    0x06
                })
                Name (DMAT, Package (0x05)
                {
                    0x00, 
                    0x01, 
                    0x01, 
                    0x01, 
                    0x02
                })
                Name (RMFL, 0x01)
                OperationRegion (CF40, PCI_Config, 0x40, 0x18)
                Field (CF40, WordAcc, NoLock, Preserve)
                {
                        ,   1, 
                    IOR0,   1, 
                    UDM0,   1, 
                    UM60,   1, 
                    UCT0,   4, 
                    CRC0,   4, 
                    INI0,   4, 
                    ATT0,   6, 
                    Offset (0x03), 
                    RCT0,   6, 
                    Offset (0x04), 
                        ,   1, 
                    IOR1,   1, 
                    UDM1,   1, 
                    UM61,   1, 
                    UCT1,   4, 
                    CRC1,   4, 
                    INI1,   4, 
                    ATT1,   6, 
                    Offset (0x07), 
                    RCT1,   6, 
                    Offset (0x08), 
                        ,   1, 
                    IOR2,   1, 
                    UDM2,   1, 
                    UM62,   1, 
                    UCT2,   4, 
                    CRC2,   4, 
                    INI2,   4, 
                    ATT2,   6, 
                    Offset (0x0B), 
                    RCT2,   6, 
                    Offset (0x0C), 
                        ,   1, 
                    IOR3,   1, 
                    UDM3,   1, 
                    UM63,   1, 
                    UCT3,   4, 
                    CRC3,   4, 
                    INI3,   4, 
                    ATT3,   6, 
                    Offset (0x0F), 
                    RCT3,   6, 
                    Offset (0x10), 
                        ,   1, 
                    CHE0,   1, 
                    Offset (0x12), 
                        ,   1, 
                    CHE1,   1, 
                    Offset (0x14), 
                        ,   30, 
                    REMP,   1, 
                    Offset (0x18)
                }

                Name (IDEP, Buffer (0x14) {})
                CreateDWordField (IDEP, 0x00, GTM0)
                CreateDWordField (IDEP, 0x04, GTM1)
                CreateDWordField (IDEP, 0x08, GTM2)
                CreateDWordField (IDEP, 0x0C, GTM3)
                CreateDWordField (IDEP, 0x10, GTM4)
                Device (IDE0)
                {
                    Name (_ADR, 0x00)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Store (0xFFFFFFFF, Local0)
                        Store (0xFFFFFFFF, Local1)
                        Store (0xFFFFFFFF, Local2)
                        Store (0xFFFFFFFF, Local3)
                        Store (0x10, Local4)
                        Store (REMP, RMFL)
                        Store (0x00, REMP)
                        If (CHE0)
                        {
                            If (LNotEqual (ATT0, 0x00))
                            {
                                Add (RCT0, 0x01, Local5)
                                Add (ATT0, 0x01, Local6)
                                Add (Local5, Local6, Local5)
                                Multiply (UM60, 0x05, Local6)
                                Subtract (0x14, Local6, Local7)
                                Multiply (Local5, Local7, Local0)
                                ShiftRight (Local0, 0x01, Local0)
                                If (LLessEqual (Local0, 0xB4))
                                {
                                    Store (Local0, Local1)
                                }

                                If (IOR0)
                                {
                                    Or (Local4, 0x02, Local4)
                                }

                                If (UDM0)
                                {
                                    Add (UCT0, 0x01, Local5)
                                    Multiply (Local5, Local7, Local6)
                                    ShiftRight (Local6, 0x01, Local1)
                                    Or (Local4, 0x01, Local4)
                                }
                            }

                            If (LNotEqual (ATT1, 0x00))
                            {
                                Add (RCT1, 0x01, Local5)
                                Add (ATT1, 0x01, Local6)
                                Add (Local5, Local6, Local5)
                                Multiply (UM61, 0x05, Local6)
                                Subtract (0x14, Local6, Local7)
                                Multiply (Local5, Local7, Local2)
                                ShiftRight (Local2, 0x01, Local2)
                                If (LLessEqual (Local2, 0xB4))
                                {
                                    Store (Local2, Local3)
                                }

                                If (IOR1)
                                {
                                    Or (Local4, 0x08, Local4)
                                }

                                If (UDM1)
                                {
                                    Add (UCT1, 0x01, Local5)
                                    Multiply (Local5, Local7, Local6)
                                    ShiftRight (Local6, 0x01, Local3)
                                    Or (Local4, 0x04, Local4)
                                }
                            }
                        }

                        Store (RMFL, REMP)
                        Store (Local0, GTM0)
                        Store (Local1, GTM1)
                        Store (Local2, GTM2)
                        Store (Local3, GTM3)
                        Store (Local4, GTM4)
                        Return (IDEP)
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Store (Arg0, IDEP)
                        Store (GTM0, Local0)
                        Store (GTM1, Local1)
                        Store (GTM2, Local2)
                        Store (GTM3, Local3)
                        Store (GTM4, Local4)
                        Store (REMP, RMFL)
                        Store (0x00, REMP)
                        If (LAnd (LNotEqual (Local1, 0xFFFFFFFF), LNotEqual (Local1, 0x00)))
                        {
                            If (And (Local4, 0x01))
                            {
                                Store (0x01, UDM0)
                                If (LLess (Local1, 0x14))
                                {
                                    Store (0x01, UM60)
                                    Store (0x01, UCT0)
                                }
                                Else
                                {
                                    Store (0x00, UM60)
                                    Divide (Local1, 0x0A, Local6, Local5)
                                    Decrement (Local5)
                                    Store (Local5, UCT0)
                                    Store (Match (UM5T, MEQ, Local5, MTR, 0x00, 0x00), Local5)
                                    Store (DerefOf (Index (CRCT, Local5)), CRC0)
                                }
                            }
                        }

                        If (LAnd (LNotEqual (Local0, 0xFFFFFFFF), LNotEqual (Local0, 0x00)))
                        {
                            If (UM60)
                            {
                                Store (Match (DerefOf (Index (IO6T, 0x00)), MEQ, Local0, MTR, 
                                    0x00, 0x00), Local6)
                                Store (DerefOf (Index (DerefOf (Index (IO6T, 0x01)), Local6)), 
                                    ATT0)
                                Store (DerefOf (Index (DerefOf (Index (IO6T, 0x02)), Local6)), 
                                    RCT0)
                            }
                            Else
                            {
                                Store (Match (DerefOf (Index (IO5T, 0x00)), MEQ, Local0, MTR, 
                                    0x00, 0x00), Local6)
                                Store (DerefOf (Index (DerefOf (Index (IO5T, 0x01)), Local6)), 
                                    ATT0)
                                Store (DerefOf (Index (DerefOf (Index (IO5T, 0x02)), Local6)), 
                                    RCT0)
                                Store (DerefOf (Index (INTT, Local6)), INI0)
                            }
                        }

                        If (LAnd (LNotEqual (Local3, 0xFFFFFFFF), LNotEqual (Local3, 0x00)))
                        {
                            If (And (Local4, 0x04))
                            {
                                Store (0x01, UDM1)
                                If (LLess (Local3, 0x14))
                                {
                                    Store (0x01, UM61)
                                    Store (0x01, UCT1)
                                }
                                Else
                                {
                                    Store (0x00, UM61)
                                    Divide (Local3, 0x0A, Local6, Local5)
                                    Decrement (Local5)
                                    Store (Local5, UCT1)
                                    Store (Match (UM5T, MEQ, Local5, MTR, 0x00, 0x00), Local5)
                                    Store (DerefOf (Index (CRCT, Local5)), CRC1)
                                }
                            }
                        }

                        If (LAnd (LNotEqual (Local2, 0xFFFFFFFF), LNotEqual (Local2, 0x00)))
                        {
                            If (UM61)
                            {
                                Store (Match (DerefOf (Index (IO6T, 0x00)), MEQ, Local2, MTR, 
                                    0x00, 0x00), Local6)
                                Store (DerefOf (Index (DerefOf (Index (IO6T, 0x01)), Local6)), 
                                    ATT1)
                                Store (DerefOf (Index (DerefOf (Index (IO6T, 0x02)), Local6)), 
                                    RCT1)
                            }
                            Else
                            {
                                Store (Match (DerefOf (Index (IO5T, 0x00)), MEQ, Local2, MTR, 
                                    0x00, 0x00), Local6)
                                Store (DerefOf (Index (DerefOf (Index (IO5T, 0x01)), Local6)), 
                                    ATT1)
                                Store (DerefOf (Index (DerefOf (Index (IO5T, 0x02)), Local6)), 
                                    RCT1)
                                Store (DerefOf (Index (INTT, Local6)), INI1)
                            }
                        }

                        Store (RMFL, REMP)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local6)
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local7)
                            CreateByteField (Local6, 0x01, MODE)
                            CreateByteField (Local7, 0x01, UMOD)
                            Store (REMP, RMFL)
                            Store (0x00, REMP)
                            If (LNotEqual (ATT0, 0x00))
                            {
                                Add (ATT0, RCT0, Local5)
                                If (UM60)
                                {
                                    Store (Match (PIO6, MEQ, Local5, MTR, 0x00, 0x00), MODE)
                                }
                                Else
                                {
                                    Store (Match (PIO5, MEQ, Local5, MTR, 0x00, 0x00), MODE)
                                }

                                If (UDM0)
                                {
                                    If (UM60)
                                    {
                                        Store (Match (UM6T, MEQ, UCT0, MTR, 0x00, 0x00), UMOD)
                                    }
                                    Else
                                    {
                                        Store (Match (UM5T, MEQ, UCT0, MTR, 0x00, 0x00), UMOD)
                                    }

                                    Or (UMOD, 0x40, UMOD)
                                }
                                Else
                                {
                                    Store (DerefOf (Index (DMAT, MODE)), UMOD)
                                    Or (UMOD, 0x20, UMOD)
                                }

                                Or (MODE, 0x08, MODE)
                            }

                            Store (RMFL, REMP)
                            Concatenate (Local6, Local7, Local5)
                            Concatenate (Local5, Buffer (0x07)
                                {
                                     0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xF5
                                }, Local0)
                            Return (Local0)
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, 0x01)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                }, Local6)
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                }, Local7)
                            CreateByteField (Local6, 0x01, MODE)
                            CreateByteField (Local7, 0x01, UMOD)
                            Store (REMP, RMFL)
                            Store (0x00, REMP)
                            If (LNotEqual (ATT1, 0x00))
                            {
                                Add (ATT1, RCT1, Local5)
                                If (UM61)
                                {
                                    Store (Match (PIO6, MEQ, Local5, MTR, 0x00, 0x00), MODE)
                                }
                                Else
                                {
                                    Store (Match (PIO5, MEQ, Local5, MTR, 0x00, 0x00), MODE)
                                }

                                If (UDM1)
                                {
                                    If (UM61)
                                    {
                                        Store (Match (UM6T, MEQ, UCT1, MTR, 0x00, 0x00), UMOD)
                                    }
                                    Else
                                    {
                                        Store (Match (UM5T, MEQ, UCT1, MTR, 0x00, 0x00), UMOD)
                                    }

                                    Or (UMOD, 0x40, UMOD)
                                }
                                Else
                                {
                                    Store (DerefOf (Index (DMAT, MODE)), UMOD)
                                    Or (UMOD, 0x20, UMOD)
                                }

                                Or (MODE, 0x08, MODE)
                            }

                            Store (RMFL, REMP)
                            Concatenate (Local6, Local7, Local5)
                            Concatenate (Local5, Buffer (0x07)
                                {
                                     0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xF5
                                }, Local0)
                            Return (Local0)
                        }
                    }
                }

                Device (IDE1)
                {
                    Name (_ADR, 0x01)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Store (0xFFFFFFFF, Local0)
                        Store (0xFFFFFFFF, Local1)
                        Store (0xFFFFFFFF, Local2)
                        Store (0xFFFFFFFF, Local3)
                        Store (0x10, Local4)
                        Store (REMP, RMFL)
                        Store (0x00, REMP)
                        If (CHE1)
                        {
                            If (LNotEqual (ATT2, 0x00))
                            {
                                Add (RCT2, 0x01, Local5)
                                Add (ATT2, 0x01, Local6)
                                Add (Local5, Local6, Local5)
                                Multiply (UM62, 0x05, Local6)
                                Subtract (0x14, Local6, Local7)
                                Multiply (Local5, Local7, Local0)
                                ShiftRight (Local0, 0x01, Local0)
                                If (LLessEqual (Local0, 0xB4))
                                {
                                    Store (Local0, Local1)
                                }

                                If (IOR2)
                                {
                                    Or (Local4, 0x02, Local4)
                                }

                                If (UDM2)
                                {
                                    Add (UCT2, 0x01, Local5)
                                    Multiply (Local5, Local7, Local6)
                                    ShiftRight (Local6, 0x01, Local1)
                                    Or (Local4, 0x01, Local4)
                                }
                            }

                            If (LNotEqual (ATT3, 0x00))
                            {
                                Add (RCT3, 0x01, Local5)
                                Add (ATT3, 0x01, Local6)
                                Add (Local5, Local6, Local5)
                                Multiply (UM63, 0x05, Local6)
                                Subtract (0x14, Local6, Local7)
                                Multiply (Local5, Local7, Local2)
                                ShiftRight (Local2, 0x01, Local2)
                                If (LLessEqual (Local2, 0xB4))
                                {
                                    Store (Local2, Local3)
                                }

                                If (IOR3)
                                {
                                    Or (Local4, 0x08, Local4)
                                }

                                If (UDM3)
                                {
                                    Add (UCT3, 0x01, Local5)
                                    Multiply (Local5, Local7, Local6)
                                    ShiftRight (Local6, 0x01, Local3)
                                    Or (Local4, 0x04, Local4)
                                }
                            }
                        }

                        Store (RMFL, REMP)
                        Store (Local0, GTM0)
                        Store (Local1, GTM1)
                        Store (Local2, GTM2)
                        Store (Local3, GTM3)
                        Store (Local4, GTM4)
                        Return (IDEP)
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Store (Arg0, IDEP)
                        Store (GTM0, Local0)
                        Store (GTM1, Local1)
                        Store (GTM2, Local2)
                        Store (GTM3, Local3)
                        Store (GTM4, Local4)
                        Store (REMP, RMFL)
                        Store (0x00, REMP)
                        If (LAnd (LNotEqual (Local1, 0xFFFFFFFF), LNotEqual (Local1, 0x00)))
                        {
                            If (And (Local4, 0x01))
                            {
                                Store (0x01, UDM2)
                                If (LLess (Local1, 0x14))
                                {
                                    Store (0x01, UM62)
                                    Store (0x01, UCT2)
                                }
                                Else
                                {
                                    Store (0x00, UM62)
                                    Divide (Local1, 0x0A, Local6, Local5)
                                    Decrement (Local5)
                                    Store (Local5, UCT2)
                                    Store (Match (UM5T, MEQ, Local5, MTR, 0x00, 0x00), Local5)
                                    Store (DerefOf (Index (CRCT, Local5)), CRC2)
                                }
                            }
                        }

                        If (LAnd (LNotEqual (Local0, 0xFFFFFFFF), LNotEqual (Local0, 0x00)))
                        {
                            If (UM62)
                            {
                                Store (Match (DerefOf (Index (IO6T, 0x00)), MEQ, Local0, MTR, 
                                    0x00, 0x00), Local6)
                                Store (DerefOf (Index (DerefOf (Index (IO6T, 0x01)), Local6)), 
                                    ATT2)
                                Store (DerefOf (Index (DerefOf (Index (IO6T, 0x02)), Local6)), 
                                    RCT2)
                            }
                            Else
                            {
                                Store (Match (DerefOf (Index (IO5T, 0x00)), MEQ, Local0, MTR, 
                                    0x00, 0x00), Local6)
                                Store (DerefOf (Index (DerefOf (Index (IO5T, 0x01)), Local6)), 
                                    ATT2)
                                Store (DerefOf (Index (DerefOf (Index (IO5T, 0x02)), Local6)), 
                                    RCT2)
                                Store (DerefOf (Index (INTT, Local6)), INI2)
                            }
                        }

                        If (LAnd (LNotEqual (Local3, 0xFFFFFFFF), LNotEqual (Local3, 0x00)))
                        {
                            If (And (Local4, 0x04))
                            {
                                Store (0x01, UDM3)
                                If (LLess (Local3, 0x14))
                                {
                                    Store (0x01, UM63)
                                    Store (0x01, UCT3)
                                }
                                Else
                                {
                                    Store (0x00, UM63)
                                    Divide (Local3, 0x0A, Local6, Local5)
                                    Decrement (Local5)
                                    Store (Local5, UCT3)
                                    Store (Match (UM5T, MEQ, Local5, MTR, 0x00, 0x00), Local5)
                                    Store (DerefOf (Index (CRCT, Local5)), CRC3)
                                }
                            }
                        }

                        If (LAnd (LNotEqual (Local2, 0xFFFFFFFF), LNotEqual (Local2, 0x00)))
                        {
                            If (UM63)
                            {
                                Store (Match (DerefOf (Index (IO6T, 0x00)), MEQ, Local2, MTR, 
                                    0x00, 0x00), Local6)
                                Store (DerefOf (Index (DerefOf (Index (IO6T, 0x01)), Local6)), 
                                    ATT3)
                                Store (DerefOf (Index (DerefOf (Index (IO6T, 0x02)), Local6)), 
                                    RCT3)
                            }
                            Else
                            {
                                Store (Match (DerefOf (Index (IO5T, 0x00)), MEQ, Local2, MTR, 
                                    0x00, 0x00), Local6)
                                Store (DerefOf (Index (DerefOf (Index (IO5T, 0x01)), Local6)), 
                                    ATT3)
                                Store (DerefOf (Index (DerefOf (Index (IO5T, 0x02)), Local6)), 
                                    RCT3)
                                Store (DerefOf (Index (INTT, Local6)), INI3)
                            }
                        }

                        Store (RMFL, REMP)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, 0x00)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local6)
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local7)
                            CreateByteField (Local6, 0x01, MODE)
                            CreateByteField (Local7, 0x01, UMOD)
                            Store (REMP, RMFL)
                            Store (0x00, REMP)
                            If (LNotEqual (ATT2, 0x00))
                            {
                                Add (ATT2, RCT2, Local5)
                                If (UM62)
                                {
                                    Store (Match (PIO6, MEQ, Local5, MTR, 0x00, 0x00), MODE)
                                }
                                Else
                                {
                                    Store (Match (PIO5, MEQ, Local5, MTR, 0x00, 0x00), MODE)
                                }

                                If (UDM2)
                                {
                                    If (UM62)
                                    {
                                        Store (Match (UM6T, MEQ, UCT2, MTR, 0x00, 0x00), UMOD)
                                    }
                                    Else
                                    {
                                        Store (Match (UM5T, MEQ, UCT2, MTR, 0x00, 0x00), UMOD)
                                    }

                                    Or (UMOD, 0x40, UMOD)
                                }
                                Else
                                {
                                    Store (DerefOf (Index (DMAT, MODE)), UMOD)
                                    Or (UMOD, 0x20, UMOD)
                                }

                                Or (MODE, 0x08, MODE)
                            }

                            Store (RMFL, REMP)
                            Concatenate (Local6, Local7, Local5)
                            Concatenate (Local5, Buffer (0x07)
                                {
                                     0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xF5
                                }, Local0)
                            Return (Local0)
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, 0x01)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                }, Local6)
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                }, Local7)
                            CreateByteField (Local6, 0x01, MODE)
                            CreateByteField (Local7, 0x01, UMOD)
                            Store (REMP, RMFL)
                            Store (0x00, REMP)
                            If (LNotEqual (ATT3, 0x00))
                            {
                                Add (ATT3, RCT3, Local5)
                                If (UM63)
                                {
                                    Store (Match (PIO6, MEQ, Local5, MTR, 0x00, 0x00), MODE)
                                }
                                Else
                                {
                                    Store (Match (PIO5, MEQ, Local5, MTR, 0x00, 0x00), MODE)
                                }

                                If (UDM3)
                                {
                                    If (UM63)
                                    {
                                        Store (Match (UM6T, MEQ, UCT3, MTR, 0x00, 0x00), UMOD)
                                    }
                                    Else
                                    {
                                        Store (Match (UM5T, MEQ, UCT3, MTR, 0x00, 0x00), UMOD)
                                    }

                                    Or (UMOD, 0x40, UMOD)
                                }
                                Else
                                {
                                    Store (DerefOf (Index (DMAT, MODE)), UMOD)
                                    Or (UMOD, 0x20, UMOD)
                                }

                                Or (MODE, 0x08, MODE)
                            }

                            Store (RMFL, REMP)
                            Concatenate (Local6, Local7, Local5)
                            Concatenate (Local5, Buffer (0x07)
                                {
                                     0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xF5
                                }, Local0)
                            Return (Local0)
                        }
                    }
                }
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                Name (BUF0, ResourceTemplate ()
                {
                    WordBusNumber (ResourceConsumer, MinNotFixed, MaxNotFixed, PosDecode,
                        0x0000,             // Granularity
                        0x0000,             // Range Minimum
                        0x00FF,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x0100,             // Length
                        ,, )
                    IO (Decode16,
                        0x0CF8,             // Range Minimum
                        0x0CF8,             // Range Maximum
                        0x01,               // Alignment
                        0x08,               // Length
                        )
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x0000,             // Range Minimum
                        0x047F,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x0480,             // Length
                        ,, , TypeStatic)
                    IO (Decode16,
                        0x0480,             // Range Minimum
                        0x0480,             // Range Maximum
                        0x01,               // Alignment
                        0x10,               // Length
                        )
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x0490,             // Range Minimum
                        0x0CF7,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x0868,             // Length
                        ,, , TypeStatic)
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x0D00,             // Range Minimum
                        0x0FFF,             // Range Maximum
                        0x0000,             // Translation Offset
                        0x0300,             // Length
                        ,, , TypeStatic)
                    IO (Decode16,
                        0x1000,             // Range Minimum
                        0x1000,             // Range Maximum
                        0x01,               // Alignment
                        0xC0,               // Length
                        )
                    IO (Decode16,
                        0x10C0,             // Range Minimum
                        0x10C0,             // Range Maximum
                        0x01,               // Alignment
                        0x40,               // Length
                        )
                    WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                        0x0000,             // Granularity
                        0x1100,             // Range Minimum
                        0xFFFF,             // Range Maximum
                        0x0000,             // Translation Offset
                        0xEF00,             // Length
                        ,, , TypeStatic)
                    DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                        0x00000000,         // Granularity
                        0x000A0000,         // Range Minimum
                        0x000BFFFF,         // Range Maximum
                        0x00000000,         // Translation Offset
                        0x00020000,         // Length
                        ,, , AddressRangeMemory, TypeStatic)
                    DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                        0x00000000,         // Granularity
                        0x00100000,         // Range Minimum
                        0xFEBFFFFF,         // Range Maximum
                        0x00000000,         // Translation Offset
                        0xFFF00000,         // Length
                        ,, _Y04, AddressRangeMemory, TypeStatic)
                })
                CreateDWordField (BUF0, \_SB.PCI0._CRS._Y04._MIN, TCMM)  // _MIN: Minimum Base Address
                CreateDWordField (BUF0, \_SB.PCI0._CRS._Y04._LEN, TOMM)  // _LEN: Length
                Add (AMEM, 0x00010000, TCMM)
                Subtract (0xFEC00000, TCMM, TOMM)
                Return (BUF0)
            }

            Name (PICM, Package (0x1E)
            {
                Package (0x04)
                {
                    0x0006FFFF, 
                    0x00, 
                    \_SB.PCI0.LNKB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0006FFFF, 
                    0x01, 
                    \_SB.PCI0.LNKC, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0006FFFF, 
                    0x02, 
                    \_SB.PCI0.LNKD, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0006FFFF, 
                    0x03, 
                    \_SB.PCI0.LNKA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x00, 
                    \_SB.PCI0.LNKC, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x01, 
                    \_SB.PCI0.LNKD, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x02, 
                    \_SB.PCI0.LNKA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x03, 
                    \_SB.PCI0.LNKB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0008FFFF, 
                    0x00, 
                    \_SB.PCI0.LNKD, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0008FFFF, 
                    0x01, 
                    \_SB.PCI0.LNKA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0008FFFF, 
                    0x02, 
                    \_SB.PCI0.LNKB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0008FFFF, 
                    0x03, 
                    \_SB.PCI0.LNKC, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000AFFFF, 
                    0x00, 
                    \_SB.PCI0.LNKB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000AFFFF, 
                    0x01, 
                    \_SB.PCI0.LNKC, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000AFFFF, 
                    0x02, 
                    \_SB.PCI0.LNKD, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x000AFFFF, 
                    0x03, 
                    \_SB.PCI0.LNKA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x00, 
                    \_SB.PCI0.LNKA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x01, 
                    \_SB.PCI0.LNKB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x02, 
                    \_SB.PCI0.LNKC, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x03, 
                    \_SB.PCI0.LNKD, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0003FFFF, 
                    0x00, 
                    \_SB.PCI0.LNKE, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0003FFFF, 
                    0x01, 
                    \_SB.PCI0.LNKF, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0003FFFF, 
                    0x02, 
                    \_SB.PCI0.LNKG, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0003FFFF, 
                    0x03, 
                    \_SB.PCI0.LNKH, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x00, 
                    \_SB.PCI0.LNKD, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x01, 
                    \_SB.PCI0.LNKA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x02, 
                    \_SB.PCI0.LNKB, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x03, 
                    \_SB.PCI0.LNKC, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0001FFFF, 
                    0x00, 
                    \_SB.PCI0.LNKA, 
                    0x00
                }, 

                Package (0x04)
                {
                    0x0001FFFF, 
                    0x01, 
                    \_SB.PCI0.LNKB, 
                    0x00
                }
            })
            Name (APIC, Package (0x1E)
            {
                Package (0x04)
                {
                    0x0006FFFF, 
                    0x00, 
                    0x00, 
                    0x11
                }, 

                Package (0x04)
                {
                    0x0006FFFF, 
                    0x01, 
                    0x00, 
                    0x12
                }, 

                Package (0x04)
                {
                    0x0006FFFF, 
                    0x02, 
                    0x00, 
                    0x13
                }, 

                Package (0x04)
                {
                    0x0006FFFF, 
                    0x03, 
                    0x00, 
                    0x10
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x00, 
                    0x00, 
                    0x12
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x01, 
                    0x00, 
                    0x13
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x02, 
                    0x00, 
                    0x10
                }, 

                Package (0x04)
                {
                    0x0007FFFF, 
                    0x03, 
                    0x00, 
                    0x11
                }, 

                Package (0x04)
                {
                    0x0008FFFF, 
                    0x00, 
                    0x00, 
                    0x13
                }, 

                Package (0x04)
                {
                    0x0008FFFF, 
                    0x01, 
                    0x00, 
                    0x10
                }, 

                Package (0x04)
                {
                    0x0008FFFF, 
                    0x02, 
                    0x00, 
                    0x11
                }, 

                Package (0x04)
                {
                    0x0008FFFF, 
                    0x03, 
                    0x00, 
                    0x12
                }, 

                Package (0x04)
                {
                    0x000AFFFF, 
                    0x00, 
                    0x00, 
                    0x11
                }, 

                Package (0x04)
                {
                    0x000AFFFF, 
                    0x01, 
                    0x00, 
                    0x12
                }, 

                Package (0x04)
                {
                    0x000AFFFF, 
                    0x02, 
                    0x00, 
                    0x13
                }, 

                Package (0x04)
                {
                    0x000AFFFF, 
                    0x03, 
                    0x00, 
                    0x10
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x00, 
                    0x00, 
                    0x10
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x01, 
                    0x00, 
                    0x11
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x02, 
                    0x00, 
                    0x12
                }, 

                Package (0x04)
                {
                    0x0002FFFF, 
                    0x03, 
                    0x00, 
                    0x13
                }, 

                Package (0x04)
                {
                    0x0003FFFF, 
                    0x00, 
                    0x00, 
                    0x14
                }, 

                Package (0x04)
                {
                    0x0003FFFF, 
                    0x01, 
                    0x00, 
                    0x15
                }, 

                Package (0x04)
                {
                    0x0003FFFF, 
                    0x02, 
                    0x00, 
                    0x16
                }, 

                Package (0x04)
                {
                    0x0003FFFF, 
                    0x03, 
                    0x00, 
                    0x17
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x00, 
                    0x00, 
                    0x13
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x01, 
                    0x00, 
                    0x10
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x02, 
                    0x00, 
                    0x11
                }, 

                Package (0x04)
                {
                    0x0004FFFF, 
                    0x03, 
                    0x00, 
                    0x12
                }, 

                Package (0x04)
                {
                    0x0001FFFF, 
                    0x00, 
                    0x00, 
                    0x10
                }, 

                Package (0x04)
                {
                    0x0001FFFF, 
                    0x01, 
                    0x00, 
                    0x11
                }
            })
            Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
            {
                If (LNot (PICF))
                {
                    Return (PICM)
                }
                Else
                {
                    Return (APIC)
                }
            }

            Device (PCI1)
            {
                Name (_BBN, 0x00)  // _BBN: BIOS Bus Number
                Name (_ADR, 0x0006FFFF)  // _ADR: Address
            }

            Device (PCI2)
            {
                Name (_BBN, 0x00)  // _BBN: BIOS Bus Number
                Name (_ADR, 0x0007FFFF)  // _ADR: Address
            }

            Device (PCI3)
            {
                Name (_BBN, 0x00)  // _BBN: BIOS Bus Number
                Name (_ADR, 0x0008FFFF)  // _ADR: Address
            }

            Device (PCI4)
            {
                Name (_BBN, 0x00)  // _BBN: BIOS Bus Number
                Name (_ADR, 0x000AFFFF)  // _ADR: Address
            }

            Device (S962)
            {
                Name (_ADR, 0x00020000)  // _ADR: Address
                OperationRegion (PIRQ, PCI_Config, 0x41, 0x04)
                Scope (\)
                {
                    Field (\_SB.PCI0.S962.PIRQ, ByteAcc, NoLock, Preserve)
                    {
                        PIRA,   8, 
                        PIRB,   8, 
                        PIRC,   8, 
                        PIRD,   8
                    }
                }

                OperationRegion (PIR2, PCI_Config, 0x60, 0x04)
                Scope (\)
                {
                    Field (\_SB.PCI0.S962.PIR2, ByteAcc, NoLock, Preserve)
                    {
                        PIRE,   8, 
                        PIRF,   8, 
                        PIRG,   8, 
                        PIRH,   8
                    }
                }

                OperationRegion (APCE, PCI_Config, 0x48, 0x01)
                Scope (\)
                {
                    Field (\_SB.PCI0.S962.APCE, ByteAcc, NoLock, Preserve)
                    {
                        APC0,   8
                    }
                }

                OperationRegion (VERG, PCI_Config, 0xF0, 0x01)
                Scope (\)
                {
                    Field (\_SB.PCI0.S962.VERG, ByteAcc, NoLock, Preserve)
                    {
                        SBVR,   8
                    }
                }

                OperationRegion (PS2M, PCI_Config, 0x47, 0x01)
                Scope (\)
                {
                    Field (\_SB.PCI0.S962.PS2M, ByteAcc, NoLock, Preserve)
                    {
                        PS2S,   8
                    }
                }
            }

            Scope (\)
            {
                Method (DISD, 1, NotSerialized)
                {
                }

                Method (CKIO, 2, NotSerialized)
                {
                }

                Method (SLDM, 2, NotSerialized)
                {
                }
            }

            Device (USB0)
            {
                Name (_ADR, 0x00030000)  // _ADR: Address
                Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
                {
                    If (LEqual (OSFL, 0x02))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }
            }

            Device (USB1)
            {
                Name (_ADR, 0x00030001)  // _ADR: Address
                Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
                {
                    If (LEqual (OSFL, 0x02))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }
            }

            Device (USB2)
            {
                Name (_ADR, 0x00030002)  // _ADR: Address
                Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
                {
                    If (LEqual (OSFL, 0x02))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }
            }

            Device (USB3)
            {
                Name (_ADR, 0x00030003)  // _ADR: Address
                Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
                {
                    If (LEqual (OSFL, 0x02))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }
            }

            Device (MAC0)
            {
                Name (_ADR, 0x00040000)  // _ADR: Address
            }

            Device (AUD0)
            {
                Name (_ADR, 0x00020007)  // _ADR: Address
            }

            Device (AMR0)
            {
                Name (_ADR, 0x00020006)  // _ADR: Address
            }

            Name (BUFA, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared, )
                    {3,4,5,6,7,9,10,11,12,14,15}
            })
            Name (BUFB, ResourceTemplate ()
            {
                IRQ (Level, ActiveLow, Shared, _Y05)
                    {}
            })
            CreateWordField (BUFB, \_SB.PCI0._Y05._INT, IRQV)  // _INT: Interrupts
            Device (LNKA)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x01)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    And (PIRA, 0x80, Local0)
                    If (LEqual (Local0, 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Or (PIRA, 0x80, PIRA)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    And (PIRA, 0x0F, Local0)
                    ShiftLeft (0x01, Local0, IRQV)
                    Return (BUFB)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, 0x01, IRQ1)
                    FindSetRightBit (IRQ1, Local0)
                    Decrement (Local0)
                    Store (Local0, PIRA)
                }
            }

            Device (LNKB)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x02)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    And (PIRB, 0x80, Local0)
                    If (LEqual (Local0, 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Or (PIRB, 0x80, PIRB)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    And (PIRB, 0x0F, Local0)
                    ShiftLeft (0x01, Local0, IRQV)
                    Return (BUFB)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, 0x01, IRQ1)
                    FindSetRightBit (IRQ1, Local0)
                    Decrement (Local0)
                    Store (Local0, PIRB)
                }
            }

            Device (LNKC)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x03)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    And (PIRC, 0x80, Local0)
                    If (LEqual (Local0, 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Or (PIRC, 0x80, PIRC)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    And (PIRC, 0x0F, Local0)
                    ShiftLeft (0x01, Local0, IRQV)
                    Return (BUFB)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, 0x01, IRQ1)
                    FindSetRightBit (IRQ1, Local0)
                    Decrement (Local0)
                    Store (Local0, PIRC)
                }
            }

            Device (LNKD)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x04)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    And (PIRD, 0x80, Local0)
                    If (LEqual (Local0, 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Or (PIRD, 0x80, PIRD)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    And (PIRD, 0x0F, Local0)
                    ShiftLeft (0x01, Local0, IRQV)
                    Return (BUFB)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, 0x01, IRQ1)
                    FindSetRightBit (IRQ1, Local0)
                    Decrement (Local0)
                    Store (Local0, PIRD)
                }
            }

            Device (LNKE)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x05)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    And (PIRE, 0x80, Local0)
                    If (LEqual (Local0, 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Or (PIRE, 0x80, PIRE)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    And (PIRE, 0x0F, Local0)
                    ShiftLeft (0x01, Local0, IRQV)
                    Return (BUFB)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, 0x01, IRQ1)
                    FindSetRightBit (IRQ1, Local0)
                    Decrement (Local0)
                    Store (Local0, PIRE)
                }
            }

            Device (LNKF)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x06)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    And (PIRF, 0x80, Local0)
                    If (LEqual (Local0, 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Or (PIRF, 0x80, PIRF)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    And (PIRF, 0x0F, Local0)
                    ShiftLeft (0x01, Local0, IRQV)
                    Return (BUFB)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, 0x01, IRQ1)
                    FindSetRightBit (IRQ1, Local0)
                    Decrement (Local0)
                    Store (Local0, PIRF)
                }
            }

            Device (LNKG)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x07)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    And (PIRG, 0x80, Local0)
                    If (LEqual (Local0, 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Or (PIRG, 0x80, PIRG)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    And (PIRG, 0x0F, Local0)
                    ShiftLeft (0x01, Local0, IRQV)
                    Return (BUFB)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, 0x01, IRQ1)
                    FindSetRightBit (IRQ1, Local0)
                    Decrement (Local0)
                    Store (Local0, PIRG)
                }
            }

            Device (LNKH)
            {
                Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
                Name (_UID, 0x08)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    And (PIRH, 0x80, Local0)
                    If (LEqual (Local0, 0x80))
                    {
                        Return (0x09)
                    }
                    Else
                    {
                        Return (0x0B)
                    }
                }

                Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                {
                    Return (BUFA)
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    Or (PIRH, 0x80, PIRH)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    And (PIRH, 0x0F, Local0)
                    ShiftLeft (0x01, Local0, IRQV)
                    Return (BUFB)
                }

                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateWordField (Arg0, 0x01, IRQ1)
                    FindSetRightBit (IRQ1, Local0)
                    Decrement (Local0)
                    Store (Local0, PIRH)
                }
            }

            OperationRegion (\SCPP, SystemIO, 0x1048, 0x01)
            Field (\SCPP, ByteAcc, NoLock, Preserve)
            {
                SMIP,   8
            }

            Method (\_SB.PCI0._INI, 0, NotSerialized)  // _INI: Initialize
            {
                If (STRC (\_OS, "Microsoft Windows")) {}
                Else
                {
                    If (STRC (\_OS, "Microsoft Windows NT"))
                    {
                        Store (0x58, SMIP)
                        Store (0x00, OSFL)
                    }
                    Else
                    {
                        Store (0x02, OSFL)
                    }
                }
            }

            Device (SYSR)
            {
                Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                Name (_UID, 0x01)  // _UID: Unique ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0010,             // Range Minimum
                        0x0010,             // Range Maximum
                        0x01,               // Alignment
                        0x10,               // Length
                        )
                    IO (Decode16,
                        0x0022,             // Range Minimum
                        0x0022,             // Range Maximum
                        0x01,               // Alignment
                        0x1E,               // Length
                        )
                    IO (Decode16,
                        0x0044,             // Range Minimum
                        0x0044,             // Range Maximum
                        0x01,               // Alignment
                        0x1C,               // Length
                        )
                    IO (Decode16,
                        0x0062,             // Range Minimum
                        0x0062,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x0065,             // Range Minimum
                        0x0065,             // Range Maximum
                        0x01,               // Alignment
                        0x0B,               // Length
                        )
                    IO (Decode16,
                        0x0074,             // Range Minimum
                        0x0074,             // Range Maximum
                        0x01,               // Alignment
                        0x0C,               // Length
                        )
                    IO (Decode16,
                        0x0091,             // Range Minimum
                        0x0091,             // Range Maximum
                        0x01,               // Alignment
                        0x03,               // Length
                        )
                    IO (Decode16,
                        0x00A2,             // Range Minimum
                        0x00A2,             // Range Maximum
                        0x01,               // Alignment
                        0x1E,               // Length
                        )
                    IO (Decode16,
                        0x00E0,             // Range Minimum
                        0x00E0,             // Range Maximum
                        0x01,               // Alignment
                        0x10,               // Length
                        )
                    IO (Decode16,
                        0x04D0,             // Range Minimum
                        0x04D0,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x0294,             // Range Minimum
                        0x0294,             // Range Maximum
                        0x01,               // Alignment
                        0x04,               // Length
                        )
                })
            }

            Device (PIC)
            {
                Name (_HID, EisaId ("PNP0000"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0020,             // Range Minimum
                        0x0020,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IO (Decode16,
                        0x00A0,             // Range Minimum
                        0x00A0,             // Range Maximum
                        0x01,               // Alignment
                        0x02,               // Length
                        )
                    IRQNoFlags ()
                        {2}
                })
            }

            Device (DMA1)
            {
                Name (_HID, EisaId ("PNP0200"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    DMA (Compatibility, BusMaster, Transfer8, )
                        {4}
                    IO (Decode16,
                        0x0000,             // Range Minimum
                        0x0000,             // Range Maximum
                        0x01,               // Alignment
                        0x10,               // Length
                        )
                    IO (Decode16,
                        0x0080,             // Range Minimum
                        0x0080,             // Range Maximum
                        0x01,               // Alignment
                        0x11,               // Length
                        )
                    IO (Decode16,
                        0x0094,             // Range Minimum
                        0x0094,             // Range Maximum
                        0x01,               // Alignment
                        0x0C,               // Length
                        )
                    IO (Decode16,
                        0x00C0,             // Range Minimum
                        0x00C0,             // Range Maximum
                        0x01,               // Alignment
                        0x20,               // Length
                        )
                })
            }

            Device (TMR)
            {
                Name (_HID, EisaId ("PNP0100"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0040,             // Range Minimum
                        0x0040,             // Range Maximum
                        0x01,               // Alignment
                        0x04,               // Length
                        )
                    IRQNoFlags ()
                        {0}
                })
            }

            Device (RTC)
            {
                Name (_HID, EisaId ("PNP0B00"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0070,             // Range Minimum
                        0x0070,             // Range Maximum
                        0x04,               // Alignment
                        0x04,               // Length
                        )
                    IRQNoFlags ()
                        {8}
                })
            }

            Device (SPKR)
            {
                Name (_HID, EisaId ("PNP0800"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0061,             // Range Minimum
                        0x0061,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                })
            }

            Device (COPR)
            {
                Name (_HID, EisaId ("PNP0C04"))  // _HID: Hardware ID
                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x00F0,             // Range Minimum
                        0x00F0,             // Range Maximum
                        0x01,               // Alignment
                        0x10,               // Length
                        )
                    IRQNoFlags ()
                        {13}
                })
            }

            Scope (\)
            {
                OperationRegion (WIN1, SystemIO, 0x2E, 0x02)
                Field (WIN1, ByteAcc, NoLock, Preserve)
                {
                    INDP,   8, 
                    DATA,   8
                }

                IndexField (INDP, DATA, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x02), 
                    CFG,    8, 
                    Offset (0x07), 
                    LDN,    8, 
                    Offset (0x20), 
                    IDHI,   8, 
                    IDLO,   8, 
                    POWC,   8, 
                    Offset (0x29), 
                    CR29,   8, 
                    Offset (0x30), 
                    ACTR,   8, 
                    Offset (0x60), 
                    IOAH,   8, 
                    IOAL,   8, 
                    IO2H,   8, 
                    IO2L,   8, 
                    Offset (0x70), 
                    INTR,   8, 
                    Offset (0x72), 
                    INT1,   8, 
                    Offset (0x74), 
                    DMCH,   8, 
                    Offset (0xC0), 
                    GP40,   8, 
                    Offset (0xF0), 
                    CRF0,   8, 
                    CRF1,   8, 
                    CRF2,   8, 
                    CRF3,   8, 
                    CRF4,   8, 
                    CRF5,   8, 
                    CRF6,   8, 
                    CRF7,   8, 
                    CRF8,   8
                }

                Method (ENFG, 0, NotSerialized)
                {
                    Store (0x87, INDP)
                    Store (0x87, INDP)
                }

                Method (EXFG, 0, NotSerialized)
                {
                    Store (0xAA, INDP)
                }
            }

            Device (FDC0)
            {
                Name (_HID, EisaId ("PNP0700"))  // _HID: Hardware ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (Zero, LDN)
                    If (ACTR)
                    {
                        EXFG ()
                        Return (0x0F)
                    }
                    Else
                    {
                        If (LOr (IOAH, IOAL))
                        {
                            EXFG ()
                            Return (0x0D)
                        }
                        Else
                        {
                            EXFG ()
                            Return (0x00)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x00, LDN)
                    Store (Zero, ACTR)
                    SLDM (DMCH, 0x04)
                    EXFG ()
                    DISD (0x03)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF0, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x03F2,             // Range Minimum
                            0x03F2,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            _Y06)
                        IO (Decode16,
                            0x03F7,             // Range Minimum
                            0x03F7,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {6}
                        DMA (Compatibility, NotBusMaster, Transfer8, )
                            {2}
                    })
                    CreateByteField (BUF0, \_SB.PCI0.FDC0._CRS._Y06._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF0, 0x03, IOHI)
                    CreateByteField (BUF0, \_SB.PCI0.FDC0._CRS._Y06._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF0, 0x05, IORH)
                    ENFG ()
                    EXFG ()
                    Return (BUF0)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x03F2,             // Range Minimum
                            0x03F2,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IO (Decode16,
                            0x03F7,             // Range Minimum
                            0x03F7,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {6}
                        DMA (Compatibility, NotBusMaster, Transfer8, )
                            {2}
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    CreateWordField (Arg0, 0x19, IRQL)
                    CreateByteField (Arg0, 0x1C, DMAV)
                    ENFG ()
                    Store (Zero, LDN)
                    Store (One, ACTR)
                    SLDM (DMCH, DMCH)
                    EXFG ()
                    CKIO (IOAD, 0x03)
                }
            }

            Device (UAR1)
            {
                Name (_HID, EisaId ("PNP0501"))  // _HID: Hardware ID
                Name (_UID, 0x01)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (0x02, LDN)
                    If (ACTR)
                    {
                        EXFG ()
                        Return (0x0F)
                    }
                    Else
                    {
                        If (LOr (IOAH, IOAL))
                        {
                            EXFG ()
                            Return (0x0D)
                        }
                        Else
                        {
                            EXFG ()
                            Return (0x00)
                        }
                    }

                    EXFG ()
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x02, LDN)
                    Store (Zero, ACTR)
                    EXFG ()
                    DISD (0x00)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            _Y07)
                        IRQNoFlags (_Y08)
                            {}
                    })
                    CreateByteField (BUF1, \_SB.PCI0.UAR1._CRS._Y07._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF1, 0x03, IOHI)
                    CreateByteField (BUF1, \_SB.PCI0.UAR1._CRS._Y07._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF1, 0x05, IORH)
                    CreateWordField (BUF1, \_SB.PCI0.UAR1._CRS._Y08._INT, IRQW)  // _INT: Interrupts
                    ENFG ()
                    Store (0x02, LDN)
                    Store (IOAL, IOLO)
                    Store (IOAL, IORL)
                    Store (IOAH, IOHI)
                    Store (IOAH, IORH)
                    Store (One, Local0)
                    ShiftLeft (Local0, INTR, IRQW)
                    EXFG ()
                    Return (BUF1)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x03F8,             // Range Minimum
                            0x03F8,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x02F8,             // Range Minimum
                            0x02F8,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x03E8,             // Range Minimum
                            0x03E8,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x02E8,             // Range Minimum
                            0x02E8,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    CreateWordField (Arg0, 0x09, IRQW)
                    ENFG ()
                    Store (0x02, LDN)
                    Store (One, ACTR)
                    Store (IOLO, IOAL)
                    Store (IOHI, IOAH)
                    FindSetRightBit (IRQW, Local0)
                    Subtract (Local0, 0x01, INTR)
                    EXFG ()
                    CKIO (IOAD, 0x00)
                }
            }

            Device (LPT1)
            {
                Name (_HID, EisaId ("PNP0400"))  // _HID: Hardware ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (0x01, LDN)
                    And (CRF0, 0x02, Local0)
                    If (LNotEqual (Local0, 0x02))
                    {
                        If (ACTR)
                        {
                            EXFG ()
                            Return (0x0F)
                        }
                        Else
                        {
                            If (LOr (IOAH, IOAL))
                            {
                                EXFG ()
                                Return (0x0D)
                            }
                            Else
                            {
                                EXFG ()
                                Return (0x00)
                            }
                        }
                    }
                    Else
                    {
                        EXFG ()
                        Return (0x00)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x01, LDN)
                    Store (Zero, ACTR)
                    EXFG ()
                    DISD (0x02)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF5, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            _Y09)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            _Y0A)
                        IRQNoFlags (_Y0B)
                            {}
                    })
                    CreateByteField (BUF5, \_SB.PCI0.LPT1._CRS._Y09._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF5, 0x03, IOHI)
                    CreateByteField (BUF5, \_SB.PCI0.LPT1._CRS._Y09._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF5, 0x05, IORH)
                    CreateByteField (BUF5, \_SB.PCI0.LPT1._CRS._Y09._LEN, IOLE)  // _LEN: Length
                    CreateByteField (BUF5, \_SB.PCI0.LPT1._CRS._Y0A._MIN, IO21)  // _MIN: Minimum Base Address
                    CreateByteField (BUF5, 0x0B, IO22)
                    CreateByteField (BUF5, \_SB.PCI0.LPT1._CRS._Y0A._MAX, IO23)  // _MAX: Maximum Base Address
                    CreateByteField (BUF5, 0x0D, IO24)
                    CreateWordField (BUF5, \_SB.PCI0.LPT1._CRS._Y0B._INT, IRQW)  // _INT: Interrupts
                    ENFG ()
                    Store (0x01, LDN)
                    Store (IOAL, IOLO)
                    Store (IOLO, IORL)
                    Store (IOAH, IOHI)
                    Store (IOHI, IORH)
                    Store (IOAL, IO21)
                    Store (IOAL, IO23)
                    Add (IOAH, 0x04, IO22)
                    Add (IOAH, 0x04, IO24)
                    If (LEqual (IOLO, 0xBC))
                    {
                        Store (0x04, IOLE)
                    }
                    Else
                    {
                        Store (0x08, IOLE)
                    }

                    Store (One, Local0)
                    Store (INTR, Local5)
                    ShiftLeft (Local0, Local5, IRQW)
                    Store (One, ACTR)
                    EXFG ()
                    Return (BUF5)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0378,             // Range Minimum
                            0x0378,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IO (Decode16,
                            0x0778,             // Range Minimum
                            0x0778,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0278,             // Range Minimum
                            0x0278,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IO (Decode16,
                            0x0678,             // Range Minimum
                            0x0678,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x03BC,             // Range Minimum
                            0x03BC,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IO (Decode16,
                            0x03BC,             // Range Minimum
                            0x03BC,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    CreateByteField (Arg0, 0x04, IORL)
                    CreateByteField (Arg0, 0x05, IORH)
                    CreateWordField (Arg0, 0x11, IRQW)
                    ENFG ()
                    Store (0x01, LDN)
                    Store (One, ACTR)
                    Store (IOLO, IOAL)
                    Store (IOHI, IOAH)
                    FindSetLeftBit (IRQW, Local0)
                    Subtract (Local0, 0x01, Local0)
                    Store (Local0, INTR)
                    EXFG ()
                    CKIO (IOAD, 0x02)
                }
            }

            Device (ECP1)
            {
                Name (_HID, EisaId ("PNP0401"))  // _HID: Hardware ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (0x01, LDN)
                    And (CRF0, 0x02, Local0)
                    If (LEqual (Local0, 0x02))
                    {
                        If (ACTR)
                        {
                            EXFG ()
                            Return (0x0F)
                        }
                        Else
                        {
                            If (LOr (IOAH, IOAL))
                            {
                                EXFG ()
                                Return (0x0D)
                            }
                            Else
                            {
                                EXFG ()
                                Return (0x00)
                            }
                        }
                    }
                    Else
                    {
                        EXFG ()
                        Return (0x00)
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x01, LDN)
                    Store (Zero, ACTR)
                    SLDM (DMCH, 0x04)
                    EXFG ()
                    DISD (0x02)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF6, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            _Y0C)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            _Y0D)
                        IRQNoFlags (_Y0E)
                            {}
                        DMA (Compatibility, NotBusMaster, Transfer8, _Y0F)
                            {}
                    })
                    CreateByteField (BUF6, \_SB.PCI0.ECP1._CRS._Y0C._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF6, 0x03, IOHI)
                    CreateByteField (BUF6, \_SB.PCI0.ECP1._CRS._Y0C._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF6, 0x05, IORH)
                    CreateByteField (BUF6, \_SB.PCI0.ECP1._CRS._Y0C._LEN, IOLE)  // _LEN: Length
                    CreateByteField (BUF6, \_SB.PCI0.ECP1._CRS._Y0D._MIN, IOEL)  // _MIN: Minimum Base Address
                    CreateByteField (BUF6, 0x0B, IOEH)
                    CreateByteField (BUF6, \_SB.PCI0.ECP1._CRS._Y0D._MAX, IOML)  // _MAX: Maximum Base Address
                    CreateByteField (BUF6, 0x0D, IOMH)
                    CreateWordField (BUF6, \_SB.PCI0.ECP1._CRS._Y0E._INT, IRQW)  // _INT: Interrupts
                    CreateByteField (BUF6, \_SB.PCI0.ECP1._CRS._Y0F._DMA, DMAC)  // _DMA: Direct Memory Access
                    ENFG ()
                    Store (0x01, LDN)
                    Store (One, ACTR)
                    Store (IOAL, Local2)
                    Store (Local2, IOLO)
                    Store (IOAH, Local3)
                    Store (Local3, IOHI)
                    Or (Local3, 0x04, Local3)
                    Store (Local3, IOEH)
                    Store (Local3, IOMH)
                    Store (IOLO, IORL)
                    Store (IOLO, IOEL)
                    Store (IOLO, IOML)
                    Store (IOHI, IORH)
                    If (LEqual (IOLO, 0xBC))
                    {
                        Store (0x04, IOLE)
                    }
                    Else
                    {
                        Store (0x08, IOLE)
                    }

                    Store (One, Local0)
                    Store (INTR, Local5)
                    ShiftLeft (Local0, Local5, IRQW)
                    Store (One, Local0)
                    Store (DMCH, Local5)
                    ShiftLeft (Local0, Local5, DMAC)
                    EXFG ()
                    Return (BUF6)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0378,             // Range Minimum
                            0x0378,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IO (Decode16,
                            0x0778,             // Range Minimum
                            0x0778,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                        DMA (Compatibility, NotBusMaster, Transfer8, )
                            {0,1,3}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0278,             // Range Minimum
                            0x0278,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IO (Decode16,
                            0x0678,             // Range Minimum
                            0x0678,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                        DMA (Compatibility, NotBusMaster, Transfer8, )
                            {0,1,3}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x03BC,             // Range Minimum
                            0x03BC,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IO (Decode16,
                            0x07BC,             // Range Minimum
                            0x07BC,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                        DMA (Compatibility, NotBusMaster, Transfer8, )
                            {0,1,3}
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    CreateWordField (Arg0, 0x11, IRQW)
                    CreateByteField (Arg0, 0x14, DMAC)
                    ENFG ()
                    Store (0x01, LDN)
                    Store (One, ACTR)
                    Store (IOLO, IOAL)
                    Store (IOHI, IOAH)
                    FindSetLeftBit (IRQW, Local0)
                    Subtract (Local0, 0x01, Local0)
                    Store (Local0, INTR)
                    FindSetLeftBit (DMAC, Local1)
                    Store (DMCH, Local0)
                    Subtract (Local1, 0x01, DMCH)
                    SLDM (Local0, DMCH)
                    EXFG ()
                    CKIO (IOAD, 0x02)
                }
            }

            OperationRegion (KBCT, SystemIO, 0x60, 0x05)
            Field (KBCT, ByteAcc, NoLock, Preserve)
            {
                P060,   8, 
                Offset (0x04), 
                P064,   8
            }

            Device (PS2M)
            {
                Name (_HID, EisaId ("PNP0F13"))  // _HID: Hardware ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LEqual (PS2F, 0x00))
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (0x00)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF1, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {12}
                    })
                    Name (BUF2, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {12}
                    })
                    If (LEqual (KBDI, 0x01))
                    {
                        If (LEqual (OSFL, 0x02))
                        {
                            Return (BUF1)
                        }

                        If (LEqual (OSFL, 0x01))
                        {
                            Return (BUF1)
                        }
                        Else
                        {
                            Return (BUF2)
                        }
                    }
                    Else
                    {
                        Return (BUF1)
                    }
                }
            }

            Device (PS2K)
            {
                Name (_HID, EisaId ("PNP0303"))  // _HID: Hardware ID
                Name (_CID, EisaId ("PNP030B"))  // _CID: Compatible ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LEqual (KBDI, 0x01))
                    {
                        Return (0x00)
                    }
                    Else
                    {
                        Return (0x0F)
                    }
                }

                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0060,             // Range Minimum
                        0x0060,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x0064,             // Range Minimum
                        0x0064,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IRQNoFlags ()
                        {1}
                })
            }

            Device (PSMR)
            {
                Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                Name (_UID, 0x03)  // _UID: Unique ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (LEqual (KBDI, 0x00))
                    {
                        Return (0x00)
                    }

                    If (LEqual (PS2F, 0x00))
                    {
                        If (LEqual (OSFL, 0x02))
                        {
                            Return (0x0F)
                        }

                        If (LEqual (OSFL, 0x01))
                        {
                            Return (0x0F)
                        }

                        Return (0x00)
                    }

                    Return (0x0F)
                }

                Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                {
                    IO (Decode16,
                        0x0060,             // Range Minimum
                        0x0060,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                    IO (Decode16,
                        0x0064,             // Range Minimum
                        0x0064,             // Range Maximum
                        0x01,               // Alignment
                        0x01,               // Length
                        )
                })
            }

            Device (GAME)
            {
                Name (_HID, EisaId ("PNPB02F"))  // _HID: Hardware ID
                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (0x07, LDN)
                    If (LEqual (ACTR, 0x01))
                    {
                        EXFG ()
                        Return (0x0F)
                    }
                    Else
                    {
                        If (LNotEqual (IOAH, 0x00))
                        {
                            EXFG ()
                            Return (0x0D)
                        }
                        Else
                        {
                            EXFG ()
                            Return (0x00)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x07, LDN)
                    Store (0x00, ACTR)
                    EXFG ()
                    DISD (0x04)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x07,               // Length
                            _Y10)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            _Y11)
                    })
                    CreateByteField (BUF1, \_SB.PCI0.GAME._CRS._Y10._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF1, 0x03, IOHI)
                    CreateByteField (BUF1, \_SB.PCI0.GAME._CRS._Y10._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF1, 0x05, IORH)
                    CreateByteField (BUF1, \_SB.PCI0.GAME._CRS._Y11._MIN, IO21)  // _MIN: Minimum Base Address
                    CreateByteField (BUF1, 0x0B, IO22)
                    CreateByteField (BUF1, \_SB.PCI0.GAME._CRS._Y11._MAX, IO23)  // _MAX: Maximum Base Address
                    CreateByteField (BUF1, 0x0D, IO24)
                    ENFG ()
                    Store (0x07, LDN)
                    Store (IOAL, IOLO)
                    Store (IOAL, IORL)
                    Store (IOAH, IOHI)
                    Store (IOAH, IORH)
                    Subtract (IOAL, 0x01, IO21)
                    Subtract (IOAL, 0x01, IO23)
                    Store (IOAH, IO22)
                    Store (IOAH, IO24)
                    EXFG ()
                    Return (BUF1)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0201,             // Range Minimum
                            0x0201,             // Range Maximum
                            0x01,               // Alignment
                            0x07,               // Length
                            )
                        IO (Decode16,
                            0x0200,             // Range Minimum
                            0x0200,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0209,             // Range Minimum
                            0x0209,             // Range Maximum
                            0x01,               // Alignment
                            0x07,               // Length
                            )
                        IO (Decode16,
                            0x0208,             // Range Minimum
                            0x0208,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    ENFG ()
                    Store (0x07, LDN)
                    Store (0x01, ACTR)
                    Store (IOLO, IOAL)
                    Store (IOHI, IOAH)
                    EXFG ()
                    CKIO (IOAD, 0x04)
                }
            }

            Device (MIDI)
            {
                Name (_HID, EisaId ("PNPB006"))  // _HID: Hardware ID
                OperationRegion (MID1, SystemIO, 0x0290, 0x02)
                Field (MID1, ByteAcc, NoLock, Preserve)
                {
                    MD1,    8, 
                    ST1,    8
                }

                OperationRegion (MID2, SystemIO, 0x0300, 0x02)
                Field (MID2, ByteAcc, NoLock, Preserve)
                {
                    MD2,    8, 
                    ST2,    8
                }

                OperationRegion (MID3, SystemIO, 0x0330, 0x02)
                Field (MID3, ByteAcc, NoLock, Preserve)
                {
                    MD3,    8, 
                    ST3,    8
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    ENFG ()
                    Store (0x08, LDN)
                    If (LEqual (ACTR, 0x01))
                    {
                        EXFG ()
                        Return (0x0F)
                    }
                    Else
                    {
                        If (LNotEqual (IOAH, 0x00))
                        {
                            EXFG ()
                            Return (0x0D)
                        }
                        Else
                        {
                            EXFG ()
                            Return (0x00)
                        }
                    }
                }

                Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                {
                    ENFG ()
                    Store (0x08, LDN)
                    Store (0x00, ACTR)
                    EXFG ()
                    DISD (0x05)
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    Name (BUF1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            _Y12)
                        IRQNoFlags (_Y13)
                            {}
                    })
                    CreateByteField (BUF1, \_SB.PCI0.MIDI._CRS._Y12._MIN, IOLO)  // _MIN: Minimum Base Address
                    CreateByteField (BUF1, 0x03, IOHI)
                    CreateByteField (BUF1, \_SB.PCI0.MIDI._CRS._Y12._MAX, IORL)  // _MAX: Maximum Base Address
                    CreateByteField (BUF1, 0x05, IORH)
                    CreateWordField (BUF1, \_SB.PCI0.MIDI._CRS._Y13._INT, IRQW)  // _INT: Interrupts
                    ENFG ()
                    Store (0x08, LDN)
                    Store (IOAL, IOLO)
                    Store (IOAL, IORL)
                    Store (IOAH, IOHI)
                    Store (IOAH, IORH)
                    Store (One, Local0)
                    ShiftLeft (Local0, INTR, IRQW)
                    EXFG ()
                    Return (BUF1)
                }

                Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                {
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0330,             // Range Minimum
                            0x0330,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0300,             // Range Minimum
                            0x0300,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    StartDependentFnNoPri ()
                    {
                        IO (Decode16,
                            0x0290,             // Range Minimum
                            0x0290,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {3,4,5,7,9,10,11,12}
                    }
                    EndDependentFn ()
                })
                Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                {
                    CreateByteField (Arg0, 0x02, IOLO)
                    CreateByteField (Arg0, 0x03, IOHI)
                    CreateWordField (Arg0, 0x02, IOAD)
                    CreateWordField (Arg0, 0x09, IRQW)
                    ENFG ()
                    Store (0x08, LDN)
                    Store (0x01, ACTR)
                    Store (IOLO, IOAL)
                    Store (IOHI, IOAH)
                    FindSetLeftBit (IRQW, Local0)
                    Subtract (Local0, 0x01, Local0)
                    Store (Local0, INTR)
                    EXFG ()
                    CKIO (IOAD, 0x05)
                    If (LEqual (IOAD, 0x0290))
                    {
                        And (ST1, 0x40, Local0)
                        While (LEqual (Local0, 0x40))
                        {
                            Store (MD1, Local0)
                            And (ST1, 0x40, Local0)
                        }
                    }
                    Else
                    {
                        If (LEqual (IOAD, 0x0300))
                        {
                            And (ST2, 0x40, Local0)
                            While (LEqual (Local0, 0x40))
                            {
                                Store (MD2, Local0)
                                And (ST2, 0x40, Local0)
                            }
                        }
                        Else
                        {
                            And (ST3, 0x40, Local0)
                            While (LEqual (Local0, 0x40))
                            {
                                Store (MD3, Local0)
                                And (ST3, 0x40, Local0)
                            }
                        }
                    }
                }
            }

            Method (\_SB.PCI0._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                Return (Package (0x02)
                {
                    0x0B, 
                    0x05
                })
            }

            Method (\_SB.PCI0.UAR1._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                Return (Package (0x02)
                {
                    0x08, 
                    0x05
                })
            }

            Method (\_SB.FUTS._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                Return (Package (0x02)
                {
                    0x13, 
                    0x04
                })
            }

            Method (\_SB.PCI0.USB0._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                If (LEqual (OSFL, 0x00))
                {
                    Return (Package (0x02)
                    {
                        0x0E, 
                        0x03
                    })
                }

                If (LEqual (OSFL, 0x01))
                {
                    Return (Package (0x02)
                    {
                        0x0E, 
                        0x05
                    })
                }

                If (LEqual (OSFL, 0x02))
                {
                    Return (Package (0x02)
                    {
                        0x0E, 
                        0x05
                    })
                }
            }

            Method (\_SB.PCI0.USB1._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                If (LEqual (OSFL, 0x00))
                {
                    Return (Package (0x02)
                    {
                        0x04, 
                        0x03
                    })
                }

                If (LEqual (OSFL, 0x01))
                {
                    Return (Package (0x02)
                    {
                        0x04, 
                        0x05
                    })
                }

                If (LEqual (OSFL, 0x02))
                {
                    Return (Package (0x02)
                    {
                        0x04, 
                        0x05
                    })
                }
            }

            Method (\_SB.PCI0.USB2._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                If (LEqual (OSFL, 0x00))
                {
                    Return (Package (0x02)
                    {
                        0x07, 
                        0x03
                    })
                }

                If (LEqual (OSFL, 0x01))
                {
                    Return (Package (0x02)
                    {
                        0x07, 
                        0x05
                    })
                }

                If (LEqual (OSFL, 0x02))
                {
                    Return (Package (0x02)
                    {
                        0x07, 
                        0x05
                    })
                }
            }

            Method (\_SB.PCI0.USB3._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                If (LEqual (OSFL, 0x00))
                {
                    Return (Package (0x02)
                    {
                        0x06, 
                        0x03
                    })
                }

                If (LEqual (OSFL, 0x01))
                {
                    Return (Package (0x02)
                    {
                        0x06, 
                        0x05
                    })
                }

                If (LEqual (OSFL, 0x02))
                {
                    Return (Package (0x02)
                    {
                        0x06, 
                        0x05
                    })
                }
            }

            Method (\_SB.PCI0.MAC0._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                Return (Package (0x02)
                {
                    0x0C, 
                    0x05
                })
            }

            Method (\_SB.PCI0.AMR0._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                Return (Package (0x02)
                {
                    0x05, 
                    0x04
                })
            }

            Method (\_SB.PCI0.PS2M._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                Return (Package (0x02)
                {
                    0x0D, 
                    0x05
                })
            }

            Method (\_SB.PCI0.PS2K._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
            {
                Return (Package (0x02)
                {
                    0x0F, 
                    0x04
                })
            }
        }
    }

    OperationRegion (TEMM, SystemMemory, 0x000FF810, 0x0C)
    Field (TEMM, WordAcc, NoLock, Preserve)
    {
        TP1H,   16, 
        TP1L,   16, 
        TP2H,   16, 
        TP2L,   16, 
        TRPC,   16, 
        SENF,   16
    }

    Name (TVAR, Buffer (0x05)
    {
         0x00, 0x00, 0x00, 0x00, 0x00
    })
    CreateByteField (TVAR, 0x00, PLCY)
    CreateWordField (TVAR, 0x01, CTOS)
    CreateWordField (TVAR, 0x03, CTHY)
    Name (TBUF, Buffer (0x04)
    {
         0x00, 0x00, 0x00, 0x00
    })
    CreateByteField (TBUF, 0x00, DB00)
    CreateByteField (TBUF, 0x01, DB01)
    CreateWordField (TBUF, 0x00, DW00)
    CreateWordField (TBUF, 0x02, DW01)
    CreateDWordField (TBUF, 0x00, DATD)
    OperationRegion (IP, SystemIO, 0x0295, 0x02)
    Field (IP, ByteAcc, NoLock, Preserve)
    {
        INDS,   8, 
        DATS,   8
    }

    Method (SCFG, 1, NotSerialized)
    {
        SBYT (0x40, Arg0)
    }

    Method (STOS, 3, NotSerialized)
    {
        Store (GBYT (0x4E), Local0)
        Or (Local0, 0x01, Local1)
        SBYT (0x4E, Local1)
        SBYT (0x55, Arg1)
        SBYT (0x56, Arg0)
        SBYT (0x4E, Local0)
    }

    Method (STHY, 3, NotSerialized)
    {
        Store (GBYT (0x4E), Local0)
        Or (Local0, 0x01, Local1)
        SBYT (0x4E, Local1)
        SBYT (0x53, Arg1)
        SBYT (0x54, Arg0)
        SBYT (0x4E, Local0)
    }

    Method (RTMP, 0, NotSerialized)
    {
        Store (GBYT (0x4E), Local0)
        Or (Local0, 0x01, Local1)
        SBYT (0x4E, Local1)
        Store (GBYT (0x50), Local1)
        Store (GBYT (0x51), Local2)
        ShiftLeft (Local1, 0x08, Local1)
        Or (Local1, Local2, Local3)
        ShiftRight (Local3, 0x07, Local3)
        ShiftLeft (Local3, 0x02, Local1)
        Add (Local3, Local1, Local3)
        Add (Local3, 0x0AAC, Local3)
        If (LGreater (Local3, 0x0E8A))
        {
            Store (0x0AAC, Local3)
        }

        SBYT (0x4E, Local0)
        Return (Local3)
    }

    Method (SBYT, 2, NotSerialized)
    {
        Store (Arg0, INDS)
        Store (Arg1, DATS)
    }

    Method (GBYT, 1, NotSerialized)
    {
        Store (Arg0, INDS)
        Store (DATS, Local7)
        Return (Local7)
    }

    Method (SFAN, 1, NotSerialized)
    {
        SBYT (0x01, Arg0)
        SBYT (0x02, Arg0)
    }

    Scope (\_TZ)
    {
        Device (FAN)
        {
            Name (_HID, EisaId ("PNP0C0B"))  // _HID: Hardware ID
            Method (_INI, 0, NotSerialized)  // _INI: Initialize
            {
                Store (TP1H, CTOS)
                Store (TP1L, CTHY)
            }
        }

        ThermalZone (THRM)
        {
            Name (_AL0, Package (0x01)  // _ALx: Active List
            {
                FAN
            })
            Method (_AC0, 0, NotSerialized)  // _ACx: Active Cooling
            {
                If (Or (PLCY, PLCY, Local7))
                {
                    Return (TP2H)
                }
                Else
                {
                    Return (TP1H)
                }
            }

            Name (_PSL, Package (0x01)  // _PSL: Passive List
            {
                \_PR.CPU0
            })
            Name (_TSP, 0x3C)  // _TSP: Thermal Sampling Period
            Name (_TC1, 0x04)  // _TC1: Thermal Constant 1
            Name (_TC2, 0x03)  // _TC2: Thermal Constant 2
            Method (_PSV, 0, NotSerialized)  // _PSV: Passive Temperature
            {
                If (Or (PLCY, PLCY, Local7))
                {
                    Return (TP1H)
                }
                Else
                {
                    Return (TP2H)
                }
            }

            Method (_CRT, 0, NotSerialized)  // _CRT: Critical Temperature
            {
                Return (TRPC)
            }

            Method (_TMP, 0, NotSerialized)  // _TMP: Temperature
            {
                And (SENF, 0x01, Local6)
                If (LEqual (Local6, 0x01))
                {
                    Return (RTMP ())
                }
                Else
                {
                    Return (0x0B86)
                }
            }

            Method (_SCP, 1, NotSerialized)  // _SCP: Set Cooling Policy
            {
                If (Arg0)
                {
                    Store (One, PLCY)
                }
                Else
                {
                    Store (Zero, PLCY)
                }

                Notify (\_TZ.THRM, 0x81)
            }

            Method (STMP, 2, NotSerialized)
            {
                Store (Arg1, DW00)
                If (Arg0)
                {
                    STHY (DB00, DB01, DW00)
                }
                Else
                {
                    STOS (DB00, DB01, DW00)
                }
            }
        }
    }
}

