/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20120620-32 [Jul 22 2012]
 * Copyright (c) 2000 - 2012 Intel Corporation
 * 
 * Disassembly of (null), Tue Jul 24 14:58:03 2012
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x00006002 (24578)
 *     Revision         0x01 **** 32-bit table (V1), no 64-bit math support
 *     Checksum         0x5D
 *     OEM ID           "INTEL"
 *     OEM Table ID     "DG43GT"
 *     OEM Revision     0x00000023 (35)
 *     Compiler ID      "INTL"
 *     Compiler Version 0x20051117 (537202967)
 */

DefinitionBlock ("DSDT.aml", "DSDT", 1, "INTEL", "DG43GT", 0x00000023)
{
    Name (SP1O, 0x2E)
    Name (IOCE, 0x87)
    Name (IOCL, 0xAA)
    Name (SI1P, One)
    Name (PEBS, 0xE0000000)
    Name (PEBL, 0x10000000)
    Name (SRCB, 0xFED1C000)
    Name (SRCL, 0x4000)
    Name (SUSW, 0xFF)
    Name (PMBS, 0x0400)
    Name (PMLN, 0x80)
    Name (SMIP, 0xB2)
    Name (APCB, 0xFEC00000)
    Name (APCL, 0x00100000)
    Name (PM00, 0x0400)
    Name (PM20, 0x0420)
    Name (PM30, 0x0430)
    Name (SMBS, 0x1180)
    Name (SMBL, 0x20)
    Name (HPTB, 0xFED00000)
    Name (HPTC, 0xFED1F404)
    Name (GPBS, 0x0500)
    Name (GPLN, 0x80)
    Name (ACPH, 0xDE)
    Name (ASSB, Zero)
    Name (AOTB, Zero)
    Name (AAXB, Zero)
    Name (PEHP, One)
    Name (SHPC, Zero)
    Name (PEPM, One)
    Name (PEER, One)
    Name (PECS, One)
    Name (TOBS, 0x0460)
    Name (SUCC, One)
    Name (NVLD, 0x02)
    Name (CRIT, 0x04)
    Name (NCRT, 0x06)
    Name (LDST, One)
    Name (VRBS, 0xFFFF0000)
    Name (IGDS, Zero)
    Name (DPSD, One)
    Name (ITKE, One)
    Method (RRIO, 4, NotSerialized)
    {
        Store ("RRIO", Debug)
    }

    Method (RDMA, 3, NotSerialized)
    {
        Store ("rDMA", Debug)
    }

    Name (PICM, Zero)
    Method (_PIC, 1, NotSerialized)  // _PIC: Interrupt Model
    {
        If (Arg0)
        {
            Store (0xAA, DBG8)
        }
        Else
        {
            Store (0xAC, DBG8)
        }

        Store (Zero, DBG8)
        Store (Arg0, PICM)
    }

    Name (OSVR, Ones)
    Method (OSFL, 0, NotSerialized)
    {
        If (LNotEqual (OSVR, Ones))
        {
            Return (OSVR)
        }

        If (LEqual (PICM, Zero))
        {
            Store (0xAC, DBG8)
        }

        Store (One, OSVR)
        If (CondRefOf (_OSI, Local0))
        {
            If (_OSI ("Linux"))
            {
                Store (0x03, OSVR)
            }
            Else
            {
                If (_OSI ("Windows 2001"))
                {
                    Store (0x04, OSVR)
                }
                Else
                {
                    If (_OSI ("Windows 2001.1"))
                    {
                        Store (0x05, OSVR)
                    }
                    Else
                    {
                        If (_OSI ("FreeBSD"))
                        {
                            Store (0x06, OSVR)
                        }
                        Else
                        {
                            If (_OSI ("HP-UX"))
                            {
                                Store (0x07, OSVR)
                            }
                            Else
                            {
                                If (_OSI ("OpenVMS"))
                                {
                                    Store (0x08, OSVR)
                                }
                            }
                        }
                    }
                }
            }
        }
        Else
        {
            If (MCTH (_OS, "Microsoft Windows NT"))
            {
                Store (Zero, OSVR)
            }
            Else
            {
                If (MCTH (_OS, "Microsoft Windows"))
                {
                    Store (One, OSVR)
                }
                Else
                {
                    If (MCTH (_OS, "Microsoft WindowsME: Millennium Edition"))
                    {
                        Store (0x02, OSVR)
                    }
                    Else
                    {
                        If (MCTH (_OS, "Linux"))
                        {
                            Store (0x03, OSVR)
                        }
                        Else
                        {
                            If (MCTH (_OS, "FreeBSD"))
                            {
                                Store (0x06, OSVR)
                            }
                            Else
                            {
                                If (MCTH (_OS, "HP-UX"))
                                {
                                    Store (0x07, OSVR)
                                }
                                Else
                                {
                                    If (MCTH (_OS, "OpenVMS"))
                                    {
                                        Store (0x08, OSVR)
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        Return (OSVR)
    }

    Method (MCTH, 2, NotSerialized)
    {
        If (LLess (SizeOf (Arg0), SizeOf (Arg1)))
        {
            Return (Zero)
        }

        Add (SizeOf (Arg0), One, Local0)
        Name (BUF0, Buffer (Local0) {})
        Name (BUF1, Buffer (Local0) {})
        Store (Arg0, BUF0)
        Store (Arg1, BUF1)
        While (Local0)
        {
            Decrement (Local0)
            If (LNotEqual (DerefOf (Index (BUF0, Local0)), DerefOf (Index (
                BUF1, Local0))))
            {
                Return (Zero)
            }
        }

        Return (One)
    }

    Name (PRWP, Package (0x02)
    {
        Zero, 
        Zero
    })
    Method (GPRW, 2, NotSerialized)
    {
        Store (Arg0, Index (PRWP, Zero))
        Store (ShiftLeft (SS1, One), Local0)
        Or (Local0, ShiftLeft (SS2, 0x02), Local0)
        Or (Local0, ShiftLeft (SS3, 0x03), Local0)
        Or (Local0, ShiftLeft (SS4, 0x04), Local0)
        If (And (ShiftLeft (One, Arg1), Local0))
        {
            Store (Arg1, Index (PRWP, One))
        }
        Else
        {
            ShiftRight (Local0, One, Local0)
            If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
            {
                FindSetLeftBit (Local0, Index (PRWP, One))
            }
            Else
            {
                FindSetRightBit (Local0, Index (PRWP, One))
            }
        }

        Return (PRWP)
    }

    Name (WAKP, Package (0x02)
    {
        Zero, 
        Zero
    })
    OperationRegion (DEB0, SystemIO, 0x80, One)
    Field (DEB0, ByteAcc, NoLock, Preserve)
    {
        DBG8,   8
    }

    OperationRegion (DEB1, SystemIO, 0x90, 0x02)
    Field (DEB1, WordAcc, NoLock, Preserve)
    {
        DBG9,   16
    }

    Name (SS1, One)
    Name (SS2, Zero)
    Name (SS3, Zero)
    Name (SS4, One)
    Name (IOST, 0x0400)
    Name (TOPM, 0x7DFFFFFF)
    Name (ROMS, 0xFFE00000)
    Name (MG1B, 0x00000000)
    Name (MG1L, 0x00000000)
    Name (MG2B, 0x7E000000)
    Name (MG2L, 0x82000000)
    Scope (_SB)
    {
        Name (PR00, Package (0x1A)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0016FFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0016FFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                0x03, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                One, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x001BFFFF, 
                Zero, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                One, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0019FFFF, 
                Zero, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                0x02, 
                LNKC, 
                Zero
            }
        })
        Name (AR00, Package (0x1A)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0016FFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0016FFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                Zero, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                0x03, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                One, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0x001BFFFF, 
                Zero, 
                Zero, 
                0x16
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                One, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x03, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0019FFFF, 
                Zero, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                0x02, 
                Zero, 
                0x12
            }
        })
        Name (PR02, Package (0x09)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                Zero, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                0x02, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                0x03, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                Zero, 
                LNKH, 
                Zero
            }
        })
        Name (AR02, Package (0x09)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x16
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                Zero, 
                Zero, 
                0x16
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                One, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                0x02, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                0x03, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0x0006FFFF, 
                Zero, 
                Zero, 
                0x17
            }
        })
        Name (PR04, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR04, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR05, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR05, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x10
            }
        })
        Name (PR06, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKB, 
                Zero
            }
        })
        Name (AR06, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x11
            }
        })
        Name (PR07, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR07, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x12
            }
        })
        Name (PR08, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR08, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PRSA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {3,4,5,6,7,10,11,12,14,15}
        })
        Alias (PRSA, PRSB)
        Name (PRSC, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {3,4,5,6,10,11,12,14,15}
        })
        Alias (PRSC, PRSD)
        Alias (PRSA, PRSE)
        Alias (PRSA, PRSF)
        Alias (PRSA, PRSG)
        Alias (PRSA, PRSH)
        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A08"))  // _HID: Hardware ID
            Name (_CID, EisaId ("PNP0A03"))  // _CID: Compatible ID
            Name (_ADR, Zero)  // _ADR: Address
            Method (^BN00, 0, NotSerialized)
            {
                Return (Zero)
            }

            Method (_BBN, 0, NotSerialized)  // _BBN: BIOS Bus Number
            {
                Return (BN00 ())
            }

            Name (_UID, Zero)  // _UID: Unique ID
            Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
            {
                If (PICM)
                {
                    Return (AR00)
                }

                Return (PR00)
            }

            Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
            {
                If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                {
                    Return (0x02)
                }
                Else
                {
                    Return (0x03)
                }
            }

            Device (MCH)
            {
                Name (_HID, EisaId ("PNP0C01"))  // _HID: Hardware ID
                Name (_UID, 0x0A)  // _UID: Unique ID
                Name (MCHR, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0xFED14000,         // Address Base
                        0x00006000,         // Address Length
                        )
                    Memory32Fixed (ReadWrite,
                        0x00000000,         // Address Base
                        0x1FE00000,         // Address Length
                        _Y00)
                })
                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (MCHR, \_SB.PCI0.MCH._Y00._BAS, PCIB)  // _BAS: Base Address
                    CreateDWordField (MCHR, \_SB.PCI0.MCH._Y00._LEN, PCIL)  // _LEN: Length
                    Store (PEBS, PCIB)
                    Store (PEBL, PCIL)
                    Return (MCHR)
                }
            }

            Method (NPTS, 1, NotSerialized)
            {
            }

            Method (NWAK, 1, NotSerialized)
            {
            }

            Device (P0P1)
            {
                Name (_ADR, 0x00010000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x09, 0x03))
                }
            }

            Device (SBRG)
            {
                Name (_ADR, 0x001F0000)  // _ADR: Address
                Method (SPTS, 1, NotSerialized)
                {
                    Store (One, PS1S)
                    Store (One, PS1E)
                    Store (One, SLPS)
                }

                Method (SWAK, 1, NotSerialized)
                {
                    Store (Zero, SLPS)
                    Store (Zero, PS1E)
                }

                OperationRegion (APMP, SystemIO, SMIP, 0x02)
                Field (APMP, ByteAcc, NoLock, Preserve)
                {
                    APMC,   8, 
                    APMS,   8
                }

                Field (APMP, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x01), 
                        ,   1, 
                    BRTC,   1
                }

                OperationRegion (SMIE, SystemIO, PM30, 0x08)
                Field (SMIE, ByteAcc, NoLock, Preserve)
                {
                        ,   4, 
                    PS1E,   1, 
                        ,   31, 
                    PS1S,   1, 
                    Offset (0x08)
                }

                OperationRegion (GPOS, SystemIO, PM20, 0x04)
                Field (GPOS, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x01), 
                    MRIS,   1, 
                    PCES,   1, 
                        ,   1, 
                    PMES,   1, 
                        ,   1, 
                    PMBS,   1, 
                        ,   15, 
                    SOPM,   1, 
                    Offset (0x04)
                }

                OperationRegion (GPIO, SystemIO, GPBS, 0x3C)
                Field (GPIO, ByteAcc, NoLock, Preserve)
                {
                    Offset (0x38), 
                    Offset (0x39), 
                    Offset (0x3A), 
                    Offset (0x3B), 
                    GP56,   1, 
                    Offset (0x3C)
                }

                Scope (\_SB)
                {
                    Name (SLPS, Zero)
                    OperationRegion (PMS0, SystemIO, PMBS, 0x04)
                    Field (PMS0, ByteAcc, NoLock, Preserve)
                    {
                            ,   10, 
                        RTCS,   1, 
                            ,   3, 
                        PEXS,   1, 
                        WAKS,   1, 
                        Offset (0x03), 
                        PWBT,   1, 
                        Offset (0x04)
                    }

                    OperationRegion (GPES, SystemIO, 0x0420, 0x08)
                    Field (GPES, ByteAcc, NoLock, Preserve)
                    {
                        THMS,   1, 
                        HPLG,   1, 
                        SWGP,   1, 
                        UB1S,   1, 
                        UB2S,   1, 
                        UB5S,   1, 
                        TCSS,   1, 
                        SBWS,   1, 
                        RISS,   1, 
                        PESS,   1, 
                            ,   1, 
                        PMSS,   1, 
                        UB3S,   1, 
                        PBSS,   1, 
                        UB4S,   1, 
                        Offset (0x02), 
                        GPIS,   16, 
                        UB6S,   1, 
                        Offset (0x08)
                    }

                    Device (SLPB)
                    {
                        Name (_HID, EisaId ("PNP0C0E"))  // _HID: Hardware ID
                        Method (_STA, 0, NotSerialized)  // _STA: Status
                        {
                            Return (0x0F)
                        }

                        Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                        {
                            Return (Package (0x02)
                            {
                                0x1D, 
                                0x04
                            })
                        }
                    }
                }

                Scope (\_SB)
                {
                    Scope (PCI0)
                    {
                        Device (ICH9)
                        {
                            Name (_HID, EisaId ("PNP0C01"))  // _HID: Hardware ID
                            Name (_UID, 0x01C7)  // _UID: Unique ID
                            Name (_STA, 0x0F)  // _STA: Status
                            Name (ICHR, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x0000,             // Range Minimum
                                    0x0000,             // Range Maximum
                                    0x00,               // Alignment
                                    0x00,               // Length
                                    _Y01)
                                IO (Decode16,
                                    0x0000,             // Range Minimum
                                    0x0000,             // Range Maximum
                                    0x00,               // Alignment
                                    0x00,               // Length
                                    _Y02)
                                IO (Decode16,
                                    0x0000,             // Range Minimum
                                    0x0000,             // Range Maximum
                                    0x00,               // Alignment
                                    0x00,               // Length
                                    _Y03)
                                Memory32Fixed (ReadWrite,
                                    0x00000000,         // Address Base
                                    0x00000000,         // Address Length
                                    _Y05)
                                Memory32Fixed (ReadWrite,
                                    0x00000000,         // Address Base
                                    0x00000000,         // Address Length
                                    _Y04)
                                Memory32Fixed (ReadWrite,
                                    0xFEE00000,         // Address Base
                                    0x00010000,         // Address Length
                                    )
                                Memory32Fixed (ReadOnly,
                                    0xFF000000,         // Address Base
                                    0x01000000,         // Address Length
                                    )
                            })
                            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                            {
                                CreateWordField (ICHR, \_SB.PCI0.ICH9._Y01._MIN, PBB)  // _MIN: Minimum Base Address
                                CreateWordField (ICHR, \_SB.PCI0.ICH9._Y01._MAX, PBH)  // _MAX: Maximum Base Address
                                CreateByteField (ICHR, \_SB.PCI0.ICH9._Y01._LEN, PML)  // _LEN: Length
                                Store (PMBS, PBB)
                                Store (PMBS, PBH)
                                Store (PMLN, PML)
                                If (SMBS)
                                {
                                    CreateWordField (ICHR, \_SB.PCI0.ICH9._Y02._MIN, SMB)  // _MIN: Minimum Base Address
                                    CreateWordField (ICHR, \_SB.PCI0.ICH9._Y02._MAX, SMH)  // _MAX: Maximum Base Address
                                    CreateByteField (ICHR, \_SB.PCI0.ICH9._Y02._LEN, SML)  // _LEN: Length
                                    Store (SMBS, SMB)
                                    Store (SMBS, SMH)
                                    Store (SMBL, SML)
                                }

                                If (GPBS)
                                {
                                    CreateWordField (ICHR, \_SB.PCI0.ICH9._Y03._MIN, IGB)  // _MIN: Minimum Base Address
                                    CreateWordField (ICHR, \_SB.PCI0.ICH9._Y03._MAX, IGH)  // _MAX: Maximum Base Address
                                    CreateByteField (ICHR, \_SB.PCI0.ICH9._Y03._LEN, IGL)  // _LEN: Length
                                    Store (GPBS, IGB)
                                    Store (GPBS, IGH)
                                    Store (GPLN, IGL)
                                }

                                If (APCB)
                                {
                                    CreateDWordField (ICHR, \_SB.PCI0.ICH9._Y04._BAS, APB)  // _BAS: Base Address
                                    CreateDWordField (ICHR, \_SB.PCI0.ICH9._Y04._LEN, APL)  // _LEN: Length
                                    Store (APCB, APB)
                                    Store (APCL, APL)
                                }

                                CreateDWordField (ICHR, \_SB.PCI0.ICH9._Y05._BAS, RCB)  // _BAS: Base Address
                                CreateDWordField (ICHR, \_SB.PCI0.ICH9._Y05._LEN, RCL)  // _LEN: Length
                                Store (SRCB, RCB)
                                Store (SRCL, RCL)
                                Return (ICHR)
                            }
                        }
                    }
                }

                Device (SIO1)
                {
                    Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                    Method (_UID, 0, NotSerialized)  // _UID: Unique ID
                    {
                        Return (SP1O)
                    }

                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y06)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y07)
                    })
                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        If (LAnd (LLess (SP1O, 0x03F0), LGreater (SP1O, 0xF0)))
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIO1._Y06._MIN, GPI0)  // _MIN: Minimum Base Address
                            CreateWordField (CRS, \_SB.PCI0.SBRG.SIO1._Y06._MAX, GPI1)  // _MAX: Maximum Base Address
                            CreateByteField (CRS, \_SB.PCI0.SBRG.SIO1._Y06._LEN, GPIL)  // _LEN: Length
                            Store (SP1O, GPI0)
                            Store (SP1O, GPI1)
                            Store (0x02, GPIL)
                        }

                        CreateWordField (CRS, \_SB.PCI0.SBRG.SIO1._Y07._MIN, GP40)  // _MIN: Minimum Base Address
                        CreateWordField (CRS, \_SB.PCI0.SBRG.SIO1._Y07._MAX, GP41)  // _MAX: Maximum Base Address
                        CreateByteField (CRS, \_SB.PCI0.SBRG.SIO1._Y07._LEN, GPL4)  // _LEN: Length
                        ENFG (One)
                        If (ACTR)
                        {
                            ShiftLeft (IOAH, 0x08, Local0)
                            Or (IOAL, Local0, Local0)
                            Subtract (FindSetRightBit (Local0), One, Local1)
                            ShiftLeft (One, Local1, Local1)
                            If (And (OPT0, 0x02)) {}
                            Else
                            {
                                Or (Local0, 0x0400, GP40)
                                Or (Local0, 0x0400, GP41)
                                Store (Local1, GPL4)
                            }
                        }

                        EXFG ()
                        Return (CRS)
                    }

                    Name (DCAT, Package (0x15)
                    {
                        0x02, 
                        0x03, 
                        One, 
                        Zero, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0x05, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF, 
                        0xFF
                    })
                    Mutex (MUT0, 0x00)
                    Method (ENFG, 1, NotSerialized)
                    {
                        Acquire (MUT0, 0x0FFF)
                        Store (IOCE, INDX)
                        Store (IOCE, INDX)
                        Store (Arg0, LDN)
                    }

                    Method (EXFG, 0, NotSerialized)
                    {
                        Store (IOCL, INDX)
                        Release (MUT0)
                    }

                    Method (LPTM, 1, NotSerialized)
                    {
                        ENFG (CGLD (Arg0))
                        And (OPT0, 0x02, Local0)
                        EXFG ()
                        Return (Local0)
                    }

                    Method (UHID, 1, NotSerialized)
                    {
                        If (LEqual (Arg0, One))
                        {
                            ENFG (CGLD (Arg0))
                            And (OPT1, 0x38, Local0)
                            EXFG ()
                            If (Local0)
                            {
                                Return (0x1005D041)
                            }
                        }

                        Return (0x0105D041)
                    }

                    OperationRegion (IOID, SystemIO, SP1O, 0x02)
                    Field (IOID, ByteAcc, NoLock, Preserve)
                    {
                        INDX,   8, 
                        DATA,   8
                    }

                    IndexField (INDX, DATA, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0x07), 
                        LDN,    8, 
                        Offset (0x2C), 
                        OP2C,   8, 
                        OP2D,   8, 
                        Offset (0x30), 
                        ACTR,   8, 
                        Offset (0x60), 
                        IOAH,   8, 
                        IOAL,   8, 
                        IOH2,   8, 
                        IOL2,   8, 
                        Offset (0x70), 
                        INTR,   8, 
                        Offset (0x74), 
                        DMCH,   8, 
                        Offset (0xE0), 
                        RGE0,   8, 
                        RGE1,   8, 
                        RGE2,   8, 
                        RGE3,   8, 
                        RGE4,   8, 
                        RGE5,   8, 
                        RGE6,   8, 
                        RGE7,   8, 
                        Offset (0xF0), 
                        OPT0,   8, 
                        OPT1,   8, 
                        OPT2,   8, 
                        OPT3,   8, 
                        OPT4,   8, 
                        OPT5,   8, 
                        OPT6,   8, 
                        OPT7,   8, 
                        OPT8,   8, 
                        OPT9,   8, 
                        OPTA,   8
                    }

                    Method (CGLD, 1, NotSerialized)
                    {
                        Return (DerefOf (Index (DCAT, Arg0)))
                    }

                    Method (DSTA, 1, NotSerialized)
                    {
                        ENFG (CGLD (Arg0))
                        Store (ACTR, Local0)
                        EXFG ()
                        If (LEqual (Local0, 0xFF))
                        {
                            Return (Zero)
                        }

                        And (Local0, One, Local0)
                        Or (IOST, ShiftLeft (Local0, Arg0), IOST)
                        If (Local0)
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            If (And (ShiftLeft (One, Arg0), IOST))
                            {
                                Return (0x0D)
                            }
                            Else
                            {
                                Return (Zero)
                            }
                        }
                    }

                    Method (DCNT, 2, NotSerialized)
                    {
                        ENFG (CGLD (Arg0))
                        If (LAnd (LLess (DMCH, 0x04), LNotEqual (And (DMCH, 0x03, 
                            Local1), Zero)))
                        {
                            RDMA (Arg0, Arg1, Increment (Local1))
                        }

                        Store (Arg1, ACTR)
                        ShiftLeft (IOAH, 0x08, Local1)
                        Or (IOAL, Local1, Local1)
                        RRIO (Arg0, Arg1, Local1, 0x08)
                        EXFG ()
                    }

                    Name (CRS1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x00,               // Length
                            _Y0A)
                        IRQNoFlags (_Y08)
                            {}
                        DMA (Compatibility, NotBusMaster, Transfer8, _Y09)
                            {}
                    })
                    CreateWordField (CRS1, \_SB.PCI0.SBRG.SIO1._Y08._INT, IRQM)  // _INT: Interrupts
                    CreateByteField (CRS1, \_SB.PCI0.SBRG.SIO1._Y09._DMA, DMAM)  // _DMA: Direct Memory Access
                    CreateWordField (CRS1, \_SB.PCI0.SBRG.SIO1._Y0A._MIN, IO11)  // _MIN: Minimum Base Address
                    CreateWordField (CRS1, \_SB.PCI0.SBRG.SIO1._Y0A._MAX, IO12)  // _MAX: Maximum Base Address
                    CreateByteField (CRS1, \_SB.PCI0.SBRG.SIO1._Y0A._LEN, LEN1)  // _LEN: Length
                    Name (CRS2, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x00,               // Length
                            _Y0D)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x00,               // Length
                            _Y0E)
                        IRQNoFlags (_Y0B)
                            {6}
                        DMA (Compatibility, NotBusMaster, Transfer8, _Y0C)
                            {2}
                    })
                    CreateWordField (CRS2, \_SB.PCI0.SBRG.SIO1._Y0B._INT, IRQE)  // _INT: Interrupts
                    CreateByteField (CRS2, \_SB.PCI0.SBRG.SIO1._Y0C._DMA, DMAE)  // _DMA: Direct Memory Access
                    CreateWordField (CRS2, \_SB.PCI0.SBRG.SIO1._Y0D._MIN, IO21)  // _MIN: Minimum Base Address
                    CreateWordField (CRS2, \_SB.PCI0.SBRG.SIO1._Y0D._MAX, IO22)  // _MAX: Maximum Base Address
                    CreateByteField (CRS2, \_SB.PCI0.SBRG.SIO1._Y0D._LEN, LEN2)  // _LEN: Length
                    CreateWordField (CRS2, \_SB.PCI0.SBRG.SIO1._Y0E._MIN, IO31)  // _MIN: Minimum Base Address
                    CreateWordField (CRS2, \_SB.PCI0.SBRG.SIO1._Y0E._MAX, IO32)  // _MAX: Maximum Base Address
                    CreateByteField (CRS2, \_SB.PCI0.SBRG.SIO1._Y0E._LEN, LEN3)  // _LEN: Length
                    Method (DCRS, 2, NotSerialized)
                    {
                        ENFG (CGLD (Arg0))
                        ShiftLeft (IOAH, 0x08, IO11)
                        Or (IOAL, IO11, IO11)
                        Store (IO11, IO12)
                        Subtract (FindSetRightBit (IO11), One, Local0)
                        ShiftLeft (One, Local0, LEN1)
                        If (INTR)
                        {
                            ShiftLeft (One, INTR, IRQM)
                        }
                        Else
                        {
                            Store (Zero, IRQM)
                        }

                        If (LOr (LGreater (DMCH, 0x03), LEqual (Arg1, Zero)))
                        {
                            Store (Zero, DMAM)
                        }
                        Else
                        {
                            And (DMCH, 0x03, Local1)
                            ShiftLeft (One, Local1, DMAM)
                        }

                        EXFG ()
                        Return (CRS1)
                    }

                    Method (DSRS, 2, NotSerialized)
                    {
                        CreateWordField (Arg0, 0x09, IRQM)
                        CreateByteField (Arg0, 0x0C, DMAM)
                        CreateWordField (Arg0, 0x02, IO11)
                        ENFG (CGLD (Arg1))
                        ShiftLeft (IOAH, 0x08, Local1)
                        Or (IOAL, Local1, Local1)
                        RRIO (Arg1, Zero, Local1, 0x08)
                        RRIO (Arg1, One, IO11, 0x08)
                        And (IO11, 0xFF, IOAL)
                        ShiftRight (IO11, 0x08, IOAH)
                        If (IRQM)
                        {
                            FindSetRightBit (IRQM, Local0)
                            Subtract (Local0, One, INTR)
                        }
                        Else
                        {
                            Store (Zero, INTR)
                        }

                        If (DMAM)
                        {
                            FindSetRightBit (DMAM, Local0)
                            Subtract (Local0, One, DMCH)
                        }
                        Else
                        {
                            Store (0x04, DMCH)
                        }

                        EXFG ()
                        DCNT (Arg1, One)
                        Store (Arg1, Local2)
                        If (LGreater (Local2, Zero))
                        {
                            Subtract (Local2, One, Local2)
                        }
                    }
                }

                Name (PMFG, Zero)
                Method (SIOS, 1, NotSerialized)
                {
                    Store ("SIOS", Debug)
                    IOKS (Arg0)
                }

                Method (SIOW, 1, NotSerialized)
                {
                    Store ("SIOW", Debug)
                    IOKW (Arg0)
                }

                Method (SIOH, 0, NotSerialized)
                {
                    IOKH ()
                }

                Device (PS2K)
                {
                    Name (_HID, EisaId ("PNP0303"))  // _HID: Hardware ID
                    Name (_CID, EisaId ("PNP030B"))  // _CID: Compatible ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (And (IOST, 0x0400))
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }

                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {1}
                    })
                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IRQNoFlags ()
                                {1}
                        }
                        EndDependentFn ()
                    })
                }

                Method (PS2K._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x1D, 0x04))
                }

                Device (PS2M)
                {
                    Name (_HID, EisaId ("PNP0F03"))  // _HID: Hardware ID
                    Name (_CID, EisaId ("PNP0F13"))  // _CID: Compatible ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If (And (IOST, 0x4000))
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }

                    Name (M2R0, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {12}
                    })
                    Name (M2R1, ResourceTemplate ()
                    {
                        FixedIO (
                            0x0060,             // Address
                            0x01,               // Length
                            )
                        FixedIO (
                            0x0064,             // Address
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {12}
                    })
                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        If (And (IOST, 0x0400))
                        {
                            Return (M2R0)
                        }
                        Else
                        {
                            Return (M2R1)
                        }
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                        }
                        EndDependentFn ()
                    })
                }

                Method (PS2M._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x1D, 0x04))
                }

                Name (KBFG, One)
                Name (MSFG, One)
                Name (SWFG, Zero)
                OperationRegion (IOKP, SystemIO, 0x60, 0x05)
                Field (IOKP, ByteAcc, NoLock, Preserve)
                {
                    KP60,   8, 
                    Offset (0x04), 
                    KP64,   8
                }

                OperationRegion (KB64, SystemIO, 0x64, One)
                Field (KB64, ByteAcc, NoLock, Preserve)
                {
                        ,   1, 
                    KRDY,   1, 
                    Offset (0x01)
                }

                Method (IOKS, 1, NotSerialized)
                {
                    Store ("IOKS", Debug)
                    While (KRDY) {}
                    Store (0x60, KP64)
                    While (KRDY) {}
                    Store (0x47, KP60)
                    While (KRDY) {}
                    Store (0xD4, KP64)
                    While (KRDY) {}
                    Store (0xF4, KP60)
                    Store (0x1000, Local0)
                    While (Local0)
                    {
                        Store (KP60, Local1)
                        Subtract (Local0, One, Local0)
                    }

                    ^SIO1.ENFG (0x0A)
                    Store (^SIO1.RGE0, SWFG)
                    If (LEqual (Arg0, One))
                    {
                        If (KBFG)
                        {
                            Or (^SIO1.RGE0, 0x41, ^SIO1.RGE0)
                            Or (^SIO1.RGE4, 0x04, ^SIO1.RGE4)
                        }

                        If (MSFG)
                        {
                            Or (^SIO1.RGE0, 0x20, ^SIO1.RGE0)
                            Or (^SIO1.RGE4, 0x04, ^SIO1.RGE4)
                            Or (^SIO1.RGE4, 0x80, ^SIO1.RGE6)
                        }
                    }

                    If (LOr (LEqual (Arg0, 0x03), LEqual (Arg0, 0x04)))
                    {
                        If (KBFG)
                        {
                            Or (^SIO1.RGE0, 0x41, ^SIO1.RGE0)
                        }

                        If (MSFG)
                        {
                            Or (^SIO1.RGE0, 0x20, ^SIO1.RGE0)
                            Or (^SIO1.RGE4, 0x04, ^SIO1.RGE4)
                            Or (^SIO1.RGE4, 0x80, ^SIO1.RGE6)
                        }
                    }

                    While (^SIO1.OPT3)
                    {
                        Stall (0x50)
                        Store (0xFF, ^SIO1.OPT3)
                    }

                    ^SIO1.EXFG ()
                }

                Method (IOKW, 1, NotSerialized)
                {
                    Store ("IOKW", Debug)
                    ^SIO1.ENFG (0x0A)
                    Store (0x0A, ^SIO1.LDN)
                    Store (SWFG, ^SIO1.RGE0)
                    If (LOr (LEqual (Arg0, One), LEqual (Arg0, 0x03)))
                    {
                        ^SIO1.ENFG (0x09)
                        Store (Zero, ^SIO1.OPTA)
                        Store (One, ^SIO1.RGE1)
                        ^SIO1.ENFG (0x0A)
                        And (^SIO1.RGE4, 0xFB, ^SIO1.RGE4)
                    }

                    ^SIO1.EXFG ()
                }

                Method (IOKH, 0, NotSerialized)
                {
                    If (And (PMFG, 0x18))
                    {
                        Notify (PS2K, 0x02)
                        Notify (PS2M, 0x02)
                    }
                }

                Device (UAR1)
                {
                    Name (_UID, One)  // _UID: Unique ID
                    Method (_HID, 0, NotSerialized)  // _HID: Hardware ID
                    {
                        Return (^^SIO1.UHID (Zero))
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        Return (^^SIO1.DSTA (Zero))
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        ^^SIO1.DCNT (Zero, Zero)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Return (^^SIO1.DCRS (Zero, Zero))
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        ^^SIO1.DSRS (Arg0, Zero)
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {4}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03F8,             // Range Minimum
                                0x03F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02F8,             // Range Minimum
                                0x02F8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03E8,             // Range Minimum
                                0x03E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x02E8,             // Range Minimum
                                0x02E8,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {3,4,5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {}
                        }
                        EndDependentFn ()
                    })
                }

                Method (UAR1._PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x08, 0x03))
                }

                Device (LPTE)
                {
                    Method (_HID, 0, NotSerialized)  // _HID: Hardware ID
                    {
                        If (^^SIO1.LPTM (0x02))
                        {
                            Return (0x0104D041)
                        }
                        Else
                        {
                            Return (0x0004D041)
                        }
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        Return (^^SIO1.DSTA (0x02))
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        ^^SIO1.DCNT (0x02, Zero)
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        ^^SIO1.DCRS (0x02, One)
                        If (^^SIO1.LPTM (0x02))
                        {
                            Store (^^SIO1.IRQM, ^^SIO1.IRQE)
                            Store (^^SIO1.DMAM, ^^SIO1.DMAE)
                            Store (^^SIO1.IO11, ^^SIO1.IO21)
                            Store (^^SIO1.IO12, ^^SIO1.IO22)
                            Store (^^SIO1.LEN1, ^^SIO1.LEN2)
                            Add (^^SIO1.IO21, 0x0400, ^^SIO1.IO31)
                            Store (^^SIO1.IO31, ^^SIO1.IO32)
                            Store (^^SIO1.LEN2, ^^SIO1.LEN3)
                            Return (^^SIO1.CRS2)
                        }
                        Else
                        {
                            Return (^^SIO1.CRS1)
                        }
                    }

                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        ^^SIO1.DSRS (Arg0, 0x02)
                    }

                    Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
                    {
                        If (^^SIO1.LPTM (0x02))
                        {
                            Return (EPPR)
                        }
                        Else
                        {
                            Return (LPPR)
                        }
                    }

                    Name (LPPR, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {5}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {5,6,7,10,11,12}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {5,6,7,10,11,12}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {5,6,7,10,11,12}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {}
                        }
                        EndDependentFn ()
                    })
                    Name (EPPR, ResourceTemplate ()
                    {
                        StartDependentFn (0x00, 0x00)
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0778,             // Range Minimum
                                0x0778,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {5}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0778,             // Range Minimum
                                0x0778,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0678,             // Range Minimum
                                0x0678,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IO (Decode16,
                                0x07BC,             // Range Minimum
                                0x07BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {5,6,7,10,11,12}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0378,             // Range Minimum
                                0x0378,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0778,             // Range Minimum
                                0x0778,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x0278,             // Range Minimum
                                0x0278,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IO (Decode16,
                                0x0678,             // Range Minimum
                                0x0678,             // Range Maximum
                                0x01,               // Alignment
                                0x08,               // Length
                                )
                            IRQNoFlags ()
                                {}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {1,3}
                        }
                        StartDependentFnNoPri ()
                        {
                            IO (Decode16,
                                0x03BC,             // Range Minimum
                                0x03BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IO (Decode16,
                                0x07BC,             // Range Minimum
                                0x07BC,             // Range Maximum
                                0x01,               // Alignment
                                0x04,               // Length
                                )
                            IRQNoFlags ()
                                {}
                            DMA (Compatibility, NotBusMaster, Transfer8, )
                                {1,3}
                        }
                        EndDependentFn ()
                    })
                }

                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0020,             // Range Minimum
                            0x0020,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A0,             // Range Minimum
                            0x00A0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {2}
                    })
                }

                Device (DMAD)
                {
                    Name (_HID, EisaId ("PNP0200"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        DMA (Compatibility, BusMaster, Transfer8, )
                            {4}
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0081,             // Range Minimum
                            0x0081,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0087,             // Range Minimum
                            0x0087,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0089,             // Range Minimum
                            0x0089,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x008F,             // Range Minimum
                            0x008F,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x00C0,             // Range Minimum
                            0x00C0,             // Range Maximum
                            0x00,               // Alignment
                            0x20,               // Length
                            )
                    })
                }

                Device (TMR)
                {
                    Name (_HID, EisaId ("PNP0100"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {0}
                    })
                }

                Device (RTC0)
                {
                    Name (_HID, EisaId ("PNP0B00"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {8}
                    })
                }

                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0061,             // Range Minimum
                            0x0061,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                    })
                }

                Device (RMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
                    Name (_UID, 0x10)  // _UID: Unique ID
                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0010,             // Range Minimum
                            0x0010,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0022,             // Range Minimum
                            0x0022,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x0044,             // Range Minimum
                            0x0044,             // Range Maximum
                            0x00,               // Alignment
                            0x1C,               // Length
                            )
                        IO (Decode16,
                            0x0062,             // Range Minimum
                            0x0062,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0065,             // Range Minimum
                            0x0065,             // Range Maximum
                            0x00,               // Alignment
                            0x0B,               // Length
                            )
                        IO (Decode16,
                            0x0072,             // Range Minimum
                            0x0072,             // Range Maximum
                            0x00,               // Alignment
                            0x0E,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0084,             // Range Minimum
                            0x0084,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0088,             // Range Minimum
                            0x0088,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x008C,             // Range Minimum
                            0x008C,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0090,             // Range Minimum
                            0x0090,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x00A2,             // Range Minimum
                            0x00A2,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x00E0,             // Range Minimum
                            0x00E0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        Memory32Fixed (ReadOnly,
                            0xFFE00000,         // Address Base
                            0x00200000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0xFED30000,         // Address Base
                            0x00010000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0xFED08000,         // Address Base
                            0x00001000,         // Address Length
                            )
                        IO (Decode16,
                            0x0540,             // Range Minimum
                            0x0540,             // Range Maximum
                            0x00,               // Alignment
                            0x40,               // Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Return (CRS)
                    }
                }

                Device (COPR)
                {
                    Name (_HID, EisaId ("PNP0C04"))  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x00F0,             // Range Minimum
                            0x00F0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IRQNoFlags ()
                            {13}
                    })
                }

                OperationRegion (CF40, PCI_Config, 0x40, 0x04)
                Field (CF40, ByteAcc, NoLock, Preserve)
                {
                    CHE0,   1, 
                    MULT,   1, 
                        ,   1, 
                    CAB0,   1, 
                    CHE1,   1, 
                    Offset (0x01), 
                    AHEN,   1, 
                        ,   3, 
                    PRT0,   1, 
                    AHM0,   1, 
                    PRT1,   1, 
                    AHM1,   1, 
                    CF42,   6, 
                    SWAP,   1, 
                    PATA,   1, 
                        ,   6, 
                    WTEN,   1, 
                    Offset (0x04)
                }

                Name (PIOT, Package (0x05)
                {
                    0x0258, 
                    0x0186, 
                    0x014A, 
                    0xB4, 
                    0x78
                })
                Name (UDMA, Package (0x07)
                {
                    0x78, 
                    0x50, 
                    0x3C, 
                    0x28, 
                    0x1E, 
                    0x14, 
                    0x0F
                })
                Name (MDMA, Package (0x03)
                {
                    0x01E0, 
                    0x96, 
                    0x78
                })
                Name (IDEB, Buffer (0x14) {})
                CreateDWordField (IDEB, Zero, GTM0)
                CreateDWordField (IDEB, 0x04, GTM1)
                CreateDWordField (IDEB, 0x08, GTM2)
                CreateDWordField (IDEB, 0x0C, GTM3)
                CreateDWordField (IDEB, 0x10, GTM4)
                Name (PIO0, 0x04)
                Name (DMA0, 0x06)
                Name (MDA0, 0x02)
                Name (PIO1, 0x04)
                Name (DMA1, 0x06)
                Name (MDA1, 0x02)
                Name (PIO2, 0x04)
                Name (DMA2, 0x06)
                Name (MDA2, 0x02)
                Name (PIO3, 0x04)
                Name (DMA3, 0x06)
                Name (MDA3, 0x02)
                Name (FLGP, 0x1F)
                Name (FLGS, 0x1F)
                Device (IDE0)
                {
                    Name (_ADR, Zero)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Store (DerefOf (Index (PIOT, PIO0)), Local0)
                        Store (DerefOf (Index (PIOT, PIO1)), Local2)
                        Store (0x1A, Local4)
                        If (LAnd (FLGP, One))
                        {
                            If (LNot (MULT))
                            {
                                If (LAnd (CAB0, SWAP))
                                {
                                    Store (0x02, DMA0)
                                }
                            }

                            Store (DerefOf (Index (UDMA, DMA0)), Local1)
                            Or (Local4, One, Local4)
                        }
                        Else
                        {
                            Store (DerefOf (Index (MDMA, MDA0)), Local1)
                        }

                        If (LAnd (FLGP, 0x04))
                        {
                            If (LAnd (CAB0, SWAP))
                            {
                                Store (0x02, DMA1)
                            }

                            Store (DerefOf (Index (UDMA, DMA1)), Local3)
                            Or (Local4, 0x04, Local4)
                        }
                        Else
                        {
                            Store (DerefOf (Index (MDMA, MDA1)), Local3)
                        }

                        Store (Local0, GTM0)
                        Store (Local1, GTM1)
                        Store (Local2, GTM2)
                        Store (Local3, GTM3)
                        Store (Local4, GTM4)
                        Return (IDEB)
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Store (Arg0, IDEB)
                        Store (GTM0, Local0)
                        Store (GTM1, Local1)
                        Store (GTM2, Local2)
                        Store (GTM3, Local3)
                        Store (GTM4, Local4)
                        Store (Local4, FLGP)
                        If (LAnd (LNotEqual (Local0, 0xFFFFFFFF), LNotEqual (Local0, Zero)))
                        {
                            Store (Match (PIOT, MEQ, Local0, MTR, Zero, Zero), PIO0)
                        }

                        If (LAnd (LNotEqual (Local1, 0xFFFFFFFF), LNotEqual (Local1, Zero)))
                        {
                            If (LAnd (FLGP, One))
                            {
                                Store (Match (UDMA, MEQ, Local1, MTR, Zero, Zero), DMA0)
                            }
                            Else
                            {
                                Store (Match (MDMA, MEQ, Local1, MTR, Zero, Zero), MDA0)
                            }
                        }

                        If (LAnd (LNotEqual (Local2, 0xFFFFFFFF), LNotEqual (Local2, Zero)))
                        {
                            Store (Match (PIOT, MEQ, Local2, MTR, Zero, Zero), PIO1)
                        }

                        If (LAnd (LNotEqual (Local3, 0xFFFFFFFF), LNotEqual (Local3, Zero)))
                        {
                            If (LAnd (FLGP, 0x04))
                            {
                                Store (Match (UDMA, MEQ, Local3, MTR, Zero, Zero), DMA1)
                            }
                            Else
                            {
                                Store (Match (MDMA, MEQ, Local3, MTR, Zero, Zero), MDA1)
                            }
                        }
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local1)
                            CreateByteField (Local0, One, PIOM)
                            CreateByteField (Local1, One, DMAM)
                            Store (PIO0, PIOM)
                            Or (PIOM, 0x08, PIOM)
                            If (LAnd (FLGP, One))
                            {
                                Store (DMA0, DMAM)
                                Or (DMAM, 0x40, DMAM)
                            }
                            Else
                            {
                                Store (MDA0, DMAM)
                                Or (DMAM, 0x20, DMAM)
                            }

                            Concatenate (Local0, Local1, Local2)
                            Return (Local2)
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                }, Local0)
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                }, Local1)
                            CreateByteField (Local0, One, PIOM)
                            CreateByteField (Local1, One, DMAM)
                            Store (PIO1, PIOM)
                            Or (PIOM, 0x08, PIOM)
                            If (LAnd (FLGP, 0x04))
                            {
                                Store (DMA1, DMAM)
                                Or (DMAM, 0x40, DMAM)
                            }
                            Else
                            {
                                Store (MDA1, DMAM)
                                Or (DMAM, 0x20, DMAM)
                            }

                            Concatenate (Local0, Local1, Local2)
                            Return (Local2)
                        }
                    }
                }

                Device (IDE1)
                {
                    Name (_ADR, One)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Store (DerefOf (Index (PIOT, PIO2)), Local0)
                        Store (DerefOf (Index (PIOT, PIO3)), Local2)
                        Store (0x1A, Local4)
                        If (LAnd (FLGS, One))
                        {
                            If (LNot (MULT))
                            {
                                If (LAnd (CAB0, LNot (SWAP)))
                                {
                                    Store (0x02, DMA2)
                                }
                            }

                            Store (DerefOf (Index (UDMA, DMA2)), Local1)
                            Or (Local4, One, Local4)
                        }
                        Else
                        {
                            Store (DerefOf (Index (MDMA, MDA2)), Local1)
                        }

                        If (LAnd (FLGS, 0x04))
                        {
                            If (LAnd (CAB0, LNot (SWAP)))
                            {
                                Store (0x02, DMA3)
                            }

                            Store (DerefOf (Index (UDMA, DMA3)), Local3)
                            Or (Local4, 0x04, Local4)
                        }
                        Else
                        {
                            Store (DerefOf (Index (MDMA, MDA3)), Local3)
                        }

                        Store (Local0, GTM0)
                        Store (Local1, GTM1)
                        Store (Local2, GTM2)
                        Store (Local3, GTM3)
                        Store (Local4, GTM4)
                        Return (IDEB)
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        Store (Arg0, IDEB)
                        Store (GTM0, Local0)
                        Store (GTM1, Local1)
                        Store (GTM2, Local2)
                        Store (GTM3, Local3)
                        Store (GTM4, Local4)
                        Store (Local4, FLGS)
                        If (LAnd (LNotEqual (Local0, 0xFFFFFFFF), LNotEqual (Local0, Zero)))
                        {
                            Store (Match (PIOT, MEQ, Local0, MTR, Zero, Zero), PIO2)
                        }

                        If (LAnd (LNotEqual (Local1, 0xFFFFFFFF), LNotEqual (Local1, Zero)))
                        {
                            If (LAnd (FLGS, One))
                            {
                                Store (Match (UDMA, MEQ, Local1, MTR, Zero, Zero), DMA2)
                            }
                            Else
                            {
                                Store (Match (MDMA, MEQ, Local1, MTR, Zero, Zero), MDA2)
                            }
                        }

                        If (LAnd (LNotEqual (Local2, 0xFFFFFFFF), LNotEqual (Local2, Zero)))
                        {
                            Store (Match (PIOT, MEQ, Local2, MTR, Zero, Zero), PIO3)
                        }

                        If (LAnd (LNotEqual (Local3, 0xFFFFFFFF), LNotEqual (Local3, Zero)))
                        {
                            If (LAnd (FLGS, 0x04))
                            {
                                Store (Match (UDMA, MEQ, Local3, MTR, Zero, Zero), DMA3)
                            }
                            Else
                            {
                                Store (Match (MDMA, MEQ, Local3, MTR, Zero, Zero), MDA3)
                            }
                        }
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local0)
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                }, Local1)
                            CreateByteField (Local0, One, PIOM)
                            CreateByteField (Local1, One, DMAM)
                            Store (PIO2, PIOM)
                            Or (PIOM, 0x08, PIOM)
                            If (LAnd (FLGS, One))
                            {
                                Store (DMA2, DMAM)
                                Or (DMAM, 0x40, DMAM)
                            }
                            Else
                            {
                                Store (MDA2, DMAM)
                                Or (DMAM, 0x20, DMAM)
                            }

                            Concatenate (Local0, Local1, Local2)
                            Return (Local2)
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                }, Local0)
                            Store (Buffer (0x07)
                                {
                                     0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                }, Local1)
                            CreateByteField (Local0, One, PIOM)
                            CreateByteField (Local1, One, DMAM)
                            Store (PIO3, PIOM)
                            Or (PIOM, 0x08, PIOM)
                            If (LAnd (FLGS, 0x04))
                            {
                                Store (DMA3, DMAM)
                                Or (DMAM, 0x40, DMAM)
                            }
                            Else
                            {
                                Store (MDA3, DMAM)
                                Or (DMAM, 0x20, DMAM)
                            }

                            Concatenate (Local0, Local1, Local2)
                            Return (Local2)
                        }
                    }
                }
            }

            Device (SAT0)
            {
                Name (_ADR, 0x001F0002)  // _ADR: Address
            }

            Device (SAT1)
            {
                Name (_ADR, 0x001F0005)  // _ADR: Address
            }

            Device (SMB)
            {
                Name (_ADR, 0x001F0003)  // _ADR: Address
                OperationRegion (SMIO, SystemIO, SMBS, SMBL)
                Field (SMIO, ByteAcc, NoLock, Preserve)
                {
                    HSTS,   8, 
                    HCNT,   8, 
                    HCMD,   8, 
                    TSAD,   8, 
                    HDT0,   8, 
                    HDT1,   8, 
                    HBDT,   8, 
                    RSAD,   8, 
                    RSDA,   16, 
                    AUST,   8, 
                    AUCT,   8, 
                    SMLP,   8, 
                    SMBP,   8, 
                    SSTS,   8, 
                    SCMD,   8, 
                    NDAD,   8, 
                    NDLB,   8, 
                    NDHB,   8
                }

                Method (SMCS, 0, NotSerialized)
                {
                    Store (0x20, HSTS)
                }

                Scope (\_GPE)
                {
                    Method (_L07, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
                    {
                        Store (0x20, \_SB.PCI0.SMB.HSTS)
                    }

                    Method (_L1B, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
                    {
                        Store (0x20, \_SB.PCI0.SMB.HSTS)
                    }
                }
            }

            Device (USB0)
            {
                Name (_ADR, 0x001D0000)  // _ADR: Address
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                    Offset (0x01)
                }

                Name (_S4D, 0x02)  // _S4D: S4 Device State
                Name (_S3D, 0x02)  // _S3D: S3 Device State
                Name (_S2D, 0x02)  // _S2D: S2 Device State
                Name (_S1D, 0x02)  // _S1D: S1 Device State
                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x03, 0x03))
                }
            }

            Device (USB1)
            {
                Name (_ADR, 0x001D0001)  // _ADR: Address
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                    Offset (0x01)
                }

                Name (_S4D, 0x02)  // _S4D: S4 Device State
                Name (_S3D, 0x02)  // _S3D: S3 Device State
                Name (_S2D, 0x02)  // _S2D: S2 Device State
                Name (_S1D, 0x02)  // _S1D: S1 Device State
                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x04, 0x03))
                }
            }

            Device (USB2)
            {
                Name (_ADR, 0x001D0002)  // _ADR: Address
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                    Offset (0x01)
                }

                Name (_S4D, 0x02)  // _S4D: S4 Device State
                Name (_S3D, 0x02)  // _S3D: S3 Device State
                Name (_S2D, 0x02)  // _S2D: S2 Device State
                Name (_S1D, 0x02)  // _S1D: S1 Device State
                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0C, 0x03))
                }
            }

            Device (USB5)
            {
                Name (_ADR, 0x001A0002)  // _ADR: Address
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                    Offset (0x01)
                }

                Name (_S4D, 0x02)  // _S4D: S4 Device State
                Name (_S3D, 0x02)  // _S3D: S3 Device State
                Name (_S2D, 0x02)  // _S2D: S2 Device State
                Name (_S1D, 0x02)  // _S1D: S1 Device State
                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x20, 0x03))
                }
            }

            Device (USB3)
            {
                Name (_ADR, 0x001A0000)  // _ADR: Address
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                    Offset (0x01)
                }

                Name (_S4D, 0x02)  // _S4D: S4 Device State
                Name (_S3D, 0x02)  // _S3D: S3 Device State
                Name (_S2D, 0x02)  // _S2D: S2 Device State
                Name (_S1D, 0x02)  // _S1D: S1 Device State
                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0E, 0x03))
                }
            }

            Device (USB4)
            {
                Name (_ADR, 0x001A0001)  // _ADR: Address
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                    Offset (0x01)
                }

                Name (_S4D, 0x02)  // _S4D: S4 Device State
                Name (_S3D, 0x02)  // _S3D: S3 Device State
                Name (_S2D, 0x02)  // _S2D: S2 Device State
                Name (_S1D, 0x02)  // _S1D: S1 Device State
                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x05, 0x03))
                }
            }

            Device (PEX0)
            {
                Name (_ADR, 0x001C0000)  // _ADR: Address
                OperationRegion (PXRC, PCI_Config, Zero, 0x0100)
                Field (PXRC, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x60), 
                    Offset (0x62), 
                    PMS,    1, 
                    PMP,    1, 
                    Offset (0xD8), 
                        ,   30, 
                    HPE,    1, 
                    PCE,    1, 
                        ,   30, 
                    HPS,    1, 
                    PCS,    1
                }

                Method (CSS, 0, NotSerialized)
                {
                    Store (One, PMS)
                    Store (One, PCS)
                    Store (One, PMS)
                }

                Method (SPRT, 1, NotSerialized)
                {
                    CSS ()
                    Store (One, PCE)
                    CSS ()
                }

                Method (WPRT, 1, NotSerialized)
                {
                    Store (Zero, PCE)
                    CSS ()
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR04)
                    }

                    Return (PR04)
                }
            }

            Device (PEX1)
            {
                Name (_ADR, 0x001C0001)  // _ADR: Address
                OperationRegion (PXRC, PCI_Config, Zero, 0x0100)
                Field (PXRC, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x60), 
                    Offset (0x62), 
                    PMS,    1, 
                    PMP,    1, 
                    Offset (0xD8), 
                        ,   30, 
                    HPE,    1, 
                    PCE,    1, 
                        ,   30, 
                    HPS,    1, 
                    PCS,    1
                }

                Method (CSS, 0, NotSerialized)
                {
                    Store (One, PMS)
                    Store (One, PCS)
                    Store (One, PMS)
                }

                Method (SPRT, 1, NotSerialized)
                {
                    CSS ()
                    Store (One, PCE)
                    CSS ()
                }

                Method (WPRT, 1, NotSerialized)
                {
                    Store (Zero, PCE)
                    CSS ()
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR05)
                    }

                    Return (PR05)
                }
            }

            Device (PEX2)
            {
                Name (_ADR, 0x001C0002)  // _ADR: Address
                OperationRegion (PXRC, PCI_Config, Zero, 0x0100)
                Field (PXRC, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x60), 
                    Offset (0x62), 
                    PMS,    1, 
                    PMP,    1, 
                    Offset (0xD8), 
                        ,   30, 
                    HPE,    1, 
                    PCE,    1, 
                        ,   30, 
                    HPS,    1, 
                    PCS,    1
                }

                Method (CSS, 0, NotSerialized)
                {
                    Store (One, PMS)
                    Store (One, PCS)
                    Store (One, PMS)
                }

                Method (SPRT, 1, NotSerialized)
                {
                    CSS ()
                    Store (One, PCE)
                    CSS ()
                }

                Method (WPRT, 1, NotSerialized)
                {
                    Store (Zero, PCE)
                    CSS ()
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR06)
                    }

                    Return (PR06)
                }

                Device (J368)
                {
                    Name (_ADR, Zero)  // _ADR: Address
                    OperationRegion (CF40, PCI_Config, 0x40, 0x04)
                    Field (CF40, ByteAcc, NoLock, Preserve)
                    {
                        CHE0,   1, 
                        MULT,   1, 
                            ,   1, 
                        CAB0,   1, 
                        CHE1,   1, 
                        Offset (0x01), 
                        AHEN,   1, 
                            ,   3, 
                        PRT0,   1, 
                        AHM0,   1, 
                        PRT1,   1, 
                        AHM1,   1, 
                        CF42,   6, 
                        SWAP,   1, 
                        PATA,   1, 
                            ,   6, 
                        WTEN,   1, 
                        Offset (0x04)
                    }

                    Name (PIOT, Package (0x05)
                    {
                        0x0258, 
                        0x0186, 
                        0x014A, 
                        0xB4, 
                        0x78
                    })
                    Name (UDMA, Package (0x07)
                    {
                        0x78, 
                        0x50, 
                        0x3C, 
                        0x28, 
                        0x1E, 
                        0x14, 
                        0x0F
                    })
                    Name (MDMA, Package (0x03)
                    {
                        0x01E0, 
                        0x96, 
                        0x78
                    })
                    Name (IDEB, Buffer (0x14) {})
                    CreateDWordField (IDEB, Zero, GTM0)
                    CreateDWordField (IDEB, 0x04, GTM1)
                    CreateDWordField (IDEB, 0x08, GTM2)
                    CreateDWordField (IDEB, 0x0C, GTM3)
                    CreateDWordField (IDEB, 0x10, GTM4)
                    Name (PIO0, 0x04)
                    Name (DMA0, 0x06)
                    Name (MDA0, 0x02)
                    Name (PIO1, 0x04)
                    Name (DMA1, 0x06)
                    Name (MDA1, 0x02)
                    Name (PIO2, 0x04)
                    Name (DMA2, 0x06)
                    Name (MDA2, 0x02)
                    Name (PIO3, 0x04)
                    Name (DMA3, 0x06)
                    Name (MDA3, 0x02)
                    Name (FLGP, 0x1F)
                    Name (FLGS, 0x1F)
                    Device (IDE0)
                    {
                        Name (_ADR, Zero)  // _ADR: Address
                        Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                        {
                            Store (DerefOf (Index (PIOT, PIO0)), Local0)
                            Store (DerefOf (Index (PIOT, PIO1)), Local2)
                            Store (0x1A, Local4)
                            If (LAnd (FLGP, One))
                            {
                                If (LNot (MULT))
                                {
                                    If (LAnd (CAB0, SWAP))
                                    {
                                        Store (0x02, DMA0)
                                    }
                                }

                                Store (DerefOf (Index (UDMA, DMA0)), Local1)
                                Or (Local4, One, Local4)
                            }
                            Else
                            {
                                Store (DerefOf (Index (MDMA, MDA0)), Local1)
                            }

                            If (LAnd (FLGP, 0x04))
                            {
                                If (LAnd (CAB0, SWAP))
                                {
                                    Store (0x02, DMA1)
                                }

                                Store (DerefOf (Index (UDMA, DMA1)), Local3)
                                Or (Local4, 0x04, Local4)
                            }
                            Else
                            {
                                Store (DerefOf (Index (MDMA, MDA1)), Local3)
                            }

                            Store (Local0, GTM0)
                            Store (Local1, GTM1)
                            Store (Local2, GTM2)
                            Store (Local3, GTM3)
                            Store (Local4, GTM4)
                            Return (IDEB)
                        }

                        Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                        {
                            Store (Arg0, IDEB)
                            Store (GTM0, Local0)
                            Store (GTM1, Local1)
                            Store (GTM2, Local2)
                            Store (GTM3, Local3)
                            Store (GTM4, Local4)
                            Store (Local4, FLGP)
                            If (LAnd (LNotEqual (Local0, 0xFFFFFFFF), LNotEqual (Local0, Zero)))
                            {
                                Store (Match (PIOT, MEQ, Local0, MTR, Zero, Zero), PIO0)
                            }

                            If (LAnd (LNotEqual (Local1, 0xFFFFFFFF), LNotEqual (Local1, Zero)))
                            {
                                If (LAnd (FLGP, One))
                                {
                                    Store (Match (UDMA, MEQ, Local1, MTR, Zero, Zero), DMA0)
                                }
                                Else
                                {
                                    Store (Match (MDMA, MEQ, Local1, MTR, Zero, Zero), MDA0)
                                }
                            }

                            If (LAnd (LNotEqual (Local2, 0xFFFFFFFF), LNotEqual (Local2, Zero)))
                            {
                                Store (Match (PIOT, MEQ, Local2, MTR, Zero, Zero), PIO1)
                            }

                            If (LAnd (LNotEqual (Local3, 0xFFFFFFFF), LNotEqual (Local3, Zero)))
                            {
                                If (LAnd (FLGP, 0x04))
                                {
                                    Store (Match (UDMA, MEQ, Local3, MTR, Zero, Zero), DMA1)
                                }
                                Else
                                {
                                    Store (Match (MDMA, MEQ, Local3, MTR, Zero, Zero), MDA1)
                                }
                            }
                        }

                        Device (DRV0)
                        {
                            Name (_ADR, Zero)  // _ADR: Address
                            Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                            {
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                    }, Local0)
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                    }, Local1)
                                CreateByteField (Local0, One, PIOM)
                                CreateByteField (Local1, One, DMAM)
                                Store (PIO0, PIOM)
                                Or (PIOM, 0x08, PIOM)
                                If (LAnd (FLGP, One))
                                {
                                    Store (DMA0, DMAM)
                                    Or (DMAM, 0x40, DMAM)
                                }
                                Else
                                {
                                    Store (MDA0, DMAM)
                                    Or (DMAM, 0x20, DMAM)
                                }

                                Concatenate (Local0, Local1, Local2)
                                Return (Local2)
                            }
                        }

                        Device (DRV1)
                        {
                            Name (_ADR, One)  // _ADR: Address
                            Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                            {
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                    }, Local0)
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                    }, Local1)
                                CreateByteField (Local0, One, PIOM)
                                CreateByteField (Local1, One, DMAM)
                                Store (PIO1, PIOM)
                                Or (PIOM, 0x08, PIOM)
                                If (LAnd (FLGP, 0x04))
                                {
                                    Store (DMA1, DMAM)
                                    Or (DMAM, 0x40, DMAM)
                                }
                                Else
                                {
                                    Store (MDA1, DMAM)
                                    Or (DMAM, 0x20, DMAM)
                                }

                                Concatenate (Local0, Local1, Local2)
                                Return (Local2)
                            }
                        }
                    }

                    Device (IDE1)
                    {
                        Name (_ADR, One)  // _ADR: Address
                        Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                        {
                            Store (DerefOf (Index (PIOT, PIO2)), Local0)
                            Store (DerefOf (Index (PIOT, PIO3)), Local2)
                            Store (0x1A, Local4)
                            If (LAnd (FLGS, One))
                            {
                                If (LNot (MULT))
                                {
                                    If (LAnd (CAB0, LNot (SWAP)))
                                    {
                                        Store (0x02, DMA2)
                                    }
                                }

                                Store (DerefOf (Index (UDMA, DMA2)), Local1)
                                Or (Local4, One, Local4)
                            }
                            Else
                            {
                                Store (DerefOf (Index (MDMA, MDA2)), Local1)
                            }

                            If (LAnd (FLGS, 0x04))
                            {
                                If (LAnd (CAB0, LNot (SWAP)))
                                {
                                    Store (0x02, DMA3)
                                }

                                Store (DerefOf (Index (UDMA, DMA3)), Local3)
                                Or (Local4, 0x04, Local4)
                            }
                            Else
                            {
                                Store (DerefOf (Index (MDMA, MDA3)), Local3)
                            }

                            Store (Local0, GTM0)
                            Store (Local1, GTM1)
                            Store (Local2, GTM2)
                            Store (Local3, GTM3)
                            Store (Local4, GTM4)
                            Return (IDEB)
                        }

                        Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                        {
                            Store (Arg0, IDEB)
                            Store (GTM0, Local0)
                            Store (GTM1, Local1)
                            Store (GTM2, Local2)
                            Store (GTM3, Local3)
                            Store (GTM4, Local4)
                            Store (Local4, FLGS)
                            If (LAnd (LNotEqual (Local0, 0xFFFFFFFF), LNotEqual (Local0, Zero)))
                            {
                                Store (Match (PIOT, MEQ, Local0, MTR, Zero, Zero), PIO2)
                            }

                            If (LAnd (LNotEqual (Local1, 0xFFFFFFFF), LNotEqual (Local1, Zero)))
                            {
                                If (LAnd (FLGS, One))
                                {
                                    Store (Match (UDMA, MEQ, Local1, MTR, Zero, Zero), DMA2)
                                }
                                Else
                                {
                                    Store (Match (MDMA, MEQ, Local1, MTR, Zero, Zero), MDA2)
                                }
                            }

                            If (LAnd (LNotEqual (Local2, 0xFFFFFFFF), LNotEqual (Local2, Zero)))
                            {
                                Store (Match (PIOT, MEQ, Local2, MTR, Zero, Zero), PIO3)
                            }

                            If (LAnd (LNotEqual (Local3, 0xFFFFFFFF), LNotEqual (Local3, Zero)))
                            {
                                If (LAnd (FLGS, 0x04))
                                {
                                    Store (Match (UDMA, MEQ, Local3, MTR, Zero, Zero), DMA3)
                                }
                                Else
                                {
                                    Store (Match (MDMA, MEQ, Local3, MTR, Zero, Zero), MDA3)
                                }
                            }
                        }

                        Device (DRV0)
                        {
                            Name (_ADR, Zero)  // _ADR: Address
                            Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                            {
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                    }, Local0)
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                    }, Local1)
                                CreateByteField (Local0, One, PIOM)
                                CreateByteField (Local1, One, DMAM)
                                Store (PIO2, PIOM)
                                Or (PIOM, 0x08, PIOM)
                                If (LAnd (FLGS, One))
                                {
                                    Store (DMA2, DMAM)
                                    Or (DMAM, 0x40, DMAM)
                                }
                                Else
                                {
                                    Store (MDA2, DMAM)
                                    Or (DMAM, 0x20, DMAM)
                                }

                                Concatenate (Local0, Local1, Local2)
                                Return (Local2)
                            }
                        }

                        Device (DRV1)
                        {
                            Name (_ADR, One)  // _ADR: Address
                            Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                            {
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                    }, Local0)
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                    }, Local1)
                                CreateByteField (Local0, One, PIOM)
                                CreateByteField (Local1, One, DMAM)
                                Store (PIO3, PIOM)
                                Or (PIOM, 0x08, PIOM)
                                If (LAnd (FLGS, 0x04))
                                {
                                    Store (DMA3, DMAM)
                                    Or (DMAM, 0x40, DMAM)
                                }
                                Else
                                {
                                    Store (MDA3, DMAM)
                                    Or (DMAM, 0x20, DMAM)
                                }

                                Concatenate (Local0, Local1, Local2)
                                Return (Local2)
                            }
                        }
                    }
                }
            }

            Device (PEX3)
            {
                Name (_ADR, 0x001C0003)  // _ADR: Address
                OperationRegion (PXRC, PCI_Config, Zero, 0x0100)
                Field (PXRC, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x60), 
                    Offset (0x62), 
                    PMS,    1, 
                    PMP,    1, 
                    Offset (0xD8), 
                        ,   30, 
                    HPE,    1, 
                    PCE,    1, 
                        ,   30, 
                    HPS,    1, 
                    PCS,    1
                }

                Method (CSS, 0, NotSerialized)
                {
                    Store (One, PMS)
                    Store (One, PCS)
                    Store (One, PMS)
                }

                Method (SPRT, 1, NotSerialized)
                {
                    CSS ()
                    Store (One, PCE)
                    CSS ()
                }

                Method (WPRT, 1, NotSerialized)
                {
                    Store (Zero, PCE)
                    CSS ()
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR07)
                    }

                    Return (PR07)
                }
            }

            Device (PEX4)
            {
                Name (_ADR, 0x001C0004)  // _ADR: Address
                OperationRegion (PXRC, PCI_Config, Zero, 0x0100)
                Field (PXRC, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x60), 
                    Offset (0x62), 
                    PMS,    1, 
                    PMP,    1, 
                    Offset (0xD8), 
                        ,   30, 
                    HPE,    1, 
                    PCE,    1, 
                        ,   30, 
                    HPS,    1, 
                    PCS,    1
                }

                Method (CSS, 0, NotSerialized)
                {
                    Store (One, PMS)
                    Store (One, PCS)
                    Store (One, PMS)
                }

                Method (SPRT, 1, NotSerialized)
                {
                    CSS ()
                    Store (One, PCE)
                    CSS ()
                }

                Method (WPRT, 1, NotSerialized)
                {
                    Store (Zero, PCE)
                    CSS ()
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR08)
                    }

                    Return (PR08)
                }

                Device (JMB0)
                {
                    Name (_ADR, Zero)  // _ADR: Address
                    OperationRegion (CF40, PCI_Config, 0x40, 0x04)
                    Field (CF40, ByteAcc, NoLock, Preserve)
                    {
                        CHE0,   1, 
                        MULT,   1, 
                            ,   1, 
                        CAB0,   1, 
                        CHE1,   1, 
                        Offset (0x01), 
                        AHEN,   1, 
                            ,   3, 
                        PRT0,   1, 
                        AHM0,   1, 
                        PRT1,   1, 
                        AHM1,   1, 
                        CF42,   6, 
                        SWAP,   1, 
                        PATA,   1, 
                            ,   6, 
                        WTEN,   1, 
                        Offset (0x04)
                    }

                    Name (PIOT, Package (0x05)
                    {
                        0x0258, 
                        0x0186, 
                        0x014A, 
                        0xB4, 
                        0x78
                    })
                    Name (UDMA, Package (0x07)
                    {
                        0x78, 
                        0x50, 
                        0x3C, 
                        0x28, 
                        0x1E, 
                        0x14, 
                        0x0F
                    })
                    Name (MDMA, Package (0x03)
                    {
                        0x01E0, 
                        0x96, 
                        0x78
                    })
                    Name (IDEB, Buffer (0x14) {})
                    CreateDWordField (IDEB, Zero, GTM0)
                    CreateDWordField (IDEB, 0x04, GTM1)
                    CreateDWordField (IDEB, 0x08, GTM2)
                    CreateDWordField (IDEB, 0x0C, GTM3)
                    CreateDWordField (IDEB, 0x10, GTM4)
                    Name (PIO0, 0x04)
                    Name (DMA0, 0x06)
                    Name (MDA0, 0x02)
                    Name (PIO1, 0x04)
                    Name (DMA1, 0x06)
                    Name (MDA1, 0x02)
                    Name (PIO2, 0x04)
                    Name (DMA2, 0x06)
                    Name (MDA2, 0x02)
                    Name (PIO3, 0x04)
                    Name (DMA3, 0x06)
                    Name (MDA3, 0x02)
                    Name (FLGP, 0x1F)
                    Name (FLGS, 0x1F)
                    Device (IDE0)
                    {
                        Name (_ADR, Zero)  // _ADR: Address
                        Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                        {
                            Store (DerefOf (Index (PIOT, PIO0)), Local0)
                            Store (DerefOf (Index (PIOT, PIO1)), Local2)
                            Store (0x1A, Local4)
                            If (LAnd (FLGP, One))
                            {
                                If (LNot (MULT))
                                {
                                    If (LAnd (CAB0, SWAP))
                                    {
                                        Store (0x02, DMA0)
                                    }
                                }

                                Store (DerefOf (Index (UDMA, DMA0)), Local1)
                                Or (Local4, One, Local4)
                            }
                            Else
                            {
                                Store (DerefOf (Index (MDMA, MDA0)), Local1)
                            }

                            If (LAnd (FLGP, 0x04))
                            {
                                If (LAnd (CAB0, SWAP))
                                {
                                    Store (0x02, DMA1)
                                }

                                Store (DerefOf (Index (UDMA, DMA1)), Local3)
                                Or (Local4, 0x04, Local4)
                            }
                            Else
                            {
                                Store (DerefOf (Index (MDMA, MDA1)), Local3)
                            }

                            Store (Local0, GTM0)
                            Store (Local1, GTM1)
                            Store (Local2, GTM2)
                            Store (Local3, GTM3)
                            Store (Local4, GTM4)
                            Return (IDEB)
                        }

                        Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                        {
                            Store (Arg0, IDEB)
                            Store (GTM0, Local0)
                            Store (GTM1, Local1)
                            Store (GTM2, Local2)
                            Store (GTM3, Local3)
                            Store (GTM4, Local4)
                            Store (Local4, FLGP)
                            If (LAnd (LNotEqual (Local0, 0xFFFFFFFF), LNotEqual (Local0, Zero)))
                            {
                                Store (Match (PIOT, MEQ, Local0, MTR, Zero, Zero), PIO0)
                            }

                            If (LAnd (LNotEqual (Local1, 0xFFFFFFFF), LNotEqual (Local1, Zero)))
                            {
                                If (LAnd (FLGP, One))
                                {
                                    Store (Match (UDMA, MEQ, Local1, MTR, Zero, Zero), DMA0)
                                }
                                Else
                                {
                                    Store (Match (MDMA, MEQ, Local1, MTR, Zero, Zero), MDA0)
                                }
                            }

                            If (LAnd (LNotEqual (Local2, 0xFFFFFFFF), LNotEqual (Local2, Zero)))
                            {
                                Store (Match (PIOT, MEQ, Local2, MTR, Zero, Zero), PIO1)
                            }

                            If (LAnd (LNotEqual (Local3, 0xFFFFFFFF), LNotEqual (Local3, Zero)))
                            {
                                If (LAnd (FLGP, 0x04))
                                {
                                    Store (Match (UDMA, MEQ, Local3, MTR, Zero, Zero), DMA1)
                                }
                                Else
                                {
                                    Store (Match (MDMA, MEQ, Local3, MTR, Zero, Zero), MDA1)
                                }
                            }
                        }

                        Device (DRV0)
                        {
                            Name (_ADR, Zero)  // _ADR: Address
                            Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                            {
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                    }, Local0)
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                    }, Local1)
                                CreateByteField (Local0, One, PIOM)
                                CreateByteField (Local1, One, DMAM)
                                Store (PIO0, PIOM)
                                Or (PIOM, 0x08, PIOM)
                                If (LAnd (FLGP, One))
                                {
                                    Store (DMA0, DMAM)
                                    Or (DMAM, 0x40, DMAM)
                                }
                                Else
                                {
                                    Store (MDA0, DMAM)
                                    Or (DMAM, 0x20, DMAM)
                                }

                                Concatenate (Local0, Local1, Local2)
                                Return (Local2)
                            }
                        }

                        Device (DRV1)
                        {
                            Name (_ADR, One)  // _ADR: Address
                            Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                            {
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                    }, Local0)
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                    }, Local1)
                                CreateByteField (Local0, One, PIOM)
                                CreateByteField (Local1, One, DMAM)
                                Store (PIO1, PIOM)
                                Or (PIOM, 0x08, PIOM)
                                If (LAnd (FLGP, 0x04))
                                {
                                    Store (DMA1, DMAM)
                                    Or (DMAM, 0x40, DMAM)
                                }
                                Else
                                {
                                    Store (MDA1, DMAM)
                                    Or (DMAM, 0x20, DMAM)
                                }

                                Concatenate (Local0, Local1, Local2)
                                Return (Local2)
                            }
                        }
                    }

                    Device (IDE1)
                    {
                        Name (_ADR, One)  // _ADR: Address
                        Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                        {
                            Store (DerefOf (Index (PIOT, PIO2)), Local0)
                            Store (DerefOf (Index (PIOT, PIO3)), Local2)
                            Store (0x1A, Local4)
                            If (LAnd (FLGS, One))
                            {
                                If (LNot (MULT))
                                {
                                    If (LAnd (CAB0, LNot (SWAP)))
                                    {
                                        Store (0x02, DMA2)
                                    }
                                }

                                Store (DerefOf (Index (UDMA, DMA2)), Local1)
                                Or (Local4, One, Local4)
                            }
                            Else
                            {
                                Store (DerefOf (Index (MDMA, MDA2)), Local1)
                            }

                            If (LAnd (FLGS, 0x04))
                            {
                                If (LAnd (CAB0, LNot (SWAP)))
                                {
                                    Store (0x02, DMA3)
                                }

                                Store (DerefOf (Index (UDMA, DMA3)), Local3)
                                Or (Local4, 0x04, Local4)
                            }
                            Else
                            {
                                Store (DerefOf (Index (MDMA, MDA3)), Local3)
                            }

                            Store (Local0, GTM0)
                            Store (Local1, GTM1)
                            Store (Local2, GTM2)
                            Store (Local3, GTM3)
                            Store (Local4, GTM4)
                            Return (IDEB)
                        }

                        Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                        {
                            Store (Arg0, IDEB)
                            Store (GTM0, Local0)
                            Store (GTM1, Local1)
                            Store (GTM2, Local2)
                            Store (GTM3, Local3)
                            Store (GTM4, Local4)
                            Store (Local4, FLGS)
                            If (LAnd (LNotEqual (Local0, 0xFFFFFFFF), LNotEqual (Local0, Zero)))
                            {
                                Store (Match (PIOT, MEQ, Local0, MTR, Zero, Zero), PIO2)
                            }

                            If (LAnd (LNotEqual (Local1, 0xFFFFFFFF), LNotEqual (Local1, Zero)))
                            {
                                If (LAnd (FLGS, One))
                                {
                                    Store (Match (UDMA, MEQ, Local1, MTR, Zero, Zero), DMA2)
                                }
                                Else
                                {
                                    Store (Match (MDMA, MEQ, Local1, MTR, Zero, Zero), MDA2)
                                }
                            }

                            If (LAnd (LNotEqual (Local2, 0xFFFFFFFF), LNotEqual (Local2, Zero)))
                            {
                                Store (Match (PIOT, MEQ, Local2, MTR, Zero, Zero), PIO3)
                            }

                            If (LAnd (LNotEqual (Local3, 0xFFFFFFFF), LNotEqual (Local3, Zero)))
                            {
                                If (LAnd (FLGS, 0x04))
                                {
                                    Store (Match (UDMA, MEQ, Local3, MTR, Zero, Zero), DMA3)
                                }
                                Else
                                {
                                    Store (Match (MDMA, MEQ, Local3, MTR, Zero, Zero), MDA3)
                                }
                            }
                        }

                        Device (DRV0)
                        {
                            Name (_ADR, Zero)  // _ADR: Address
                            Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                            {
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                    }, Local0)
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                    }, Local1)
                                CreateByteField (Local0, One, PIOM)
                                CreateByteField (Local1, One, DMAM)
                                Store (PIO2, PIOM)
                                Or (PIOM, 0x08, PIOM)
                                If (LAnd (FLGS, One))
                                {
                                    Store (DMA2, DMAM)
                                    Or (DMAM, 0x40, DMAM)
                                }
                                Else
                                {
                                    Store (MDA2, DMAM)
                                    Or (DMAM, 0x20, DMAM)
                                }

                                Concatenate (Local0, Local1, Local2)
                                Return (Local2)
                            }
                        }

                        Device (DRV1)
                        {
                            Name (_ADR, One)  // _ADR: Address
                            Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                            {
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                    }, Local0)
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                    }, Local1)
                                CreateByteField (Local0, One, PIOM)
                                CreateByteField (Local1, One, DMAM)
                                Store (PIO3, PIOM)
                                Or (PIOM, 0x08, PIOM)
                                If (LAnd (FLGS, 0x04))
                                {
                                    Store (DMA3, DMAM)
                                    Or (DMAM, 0x40, DMAM)
                                }
                                Else
                                {
                                    Store (MDA3, DMAM)
                                    Or (DMAM, 0x20, DMAM)
                                }

                                Concatenate (Local0, Local1, Local2)
                                Return (Local2)
                            }
                        }
                    }
                }

                Device (JMB1)
                {
                    Name (_ADR, One)  // _ADR: Address
                    OperationRegion (CF40, PCI_Config, 0x40, 0x04)
                    Field (CF40, ByteAcc, NoLock, Preserve)
                    {
                        CHE0,   1, 
                        MULT,   1, 
                            ,   1, 
                        CAB0,   1, 
                        CHE1,   1, 
                        Offset (0x01), 
                        AHEN,   1, 
                            ,   3, 
                        PRT0,   1, 
                        AHM0,   1, 
                        PRT1,   1, 
                        AHM1,   1, 
                        CF42,   6, 
                        SWAP,   1, 
                        PATA,   1, 
                            ,   6, 
                        WTEN,   1, 
                        Offset (0x04)
                    }

                    Name (PIOT, Package (0x05)
                    {
                        0x0258, 
                        0x0186, 
                        0x014A, 
                        0xB4, 
                        0x78
                    })
                    Name (UDMA, Package (0x07)
                    {
                        0x78, 
                        0x50, 
                        0x3C, 
                        0x28, 
                        0x1E, 
                        0x14, 
                        0x0F
                    })
                    Name (MDMA, Package (0x03)
                    {
                        0x01E0, 
                        0x96, 
                        0x78
                    })
                    Name (IDEB, Buffer (0x14) {})
                    CreateDWordField (IDEB, Zero, GTM0)
                    CreateDWordField (IDEB, 0x04, GTM1)
                    CreateDWordField (IDEB, 0x08, GTM2)
                    CreateDWordField (IDEB, 0x0C, GTM3)
                    CreateDWordField (IDEB, 0x10, GTM4)
                    Name (PIO0, 0x04)
                    Name (DMA0, 0x06)
                    Name (MDA0, 0x02)
                    Name (PIO1, 0x04)
                    Name (DMA1, 0x06)
                    Name (MDA1, 0x02)
                    Name (PIO2, 0x04)
                    Name (DMA2, 0x06)
                    Name (MDA2, 0x02)
                    Name (PIO3, 0x04)
                    Name (DMA3, 0x06)
                    Name (MDA3, 0x02)
                    Name (FLGP, 0x1F)
                    Name (FLGS, 0x1F)
                    Device (IDE0)
                    {
                        Name (_ADR, Zero)  // _ADR: Address
                        Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                        {
                            Store (DerefOf (Index (PIOT, PIO0)), Local0)
                            Store (DerefOf (Index (PIOT, PIO1)), Local2)
                            Store (0x1A, Local4)
                            If (LAnd (FLGP, One))
                            {
                                If (LAnd (CAB0, SWAP))
                                {
                                    Store (0x02, DMA0)
                                }

                                Store (DerefOf (Index (UDMA, DMA0)), Local1)
                                Or (Local4, One, Local4)
                            }
                            Else
                            {
                                Store (DerefOf (Index (MDMA, MDA0)), Local1)
                            }

                            If (LAnd (FLGP, 0x04))
                            {
                                If (LAnd (CAB0, SWAP))
                                {
                                    Store (0x02, DMA1)
                                }

                                Store (DerefOf (Index (UDMA, DMA1)), Local3)
                                Or (Local4, 0x04, Local4)
                            }
                            Else
                            {
                                Store (DerefOf (Index (MDMA, MDA1)), Local3)
                            }

                            Store (Local0, GTM0)
                            Store (Local1, GTM1)
                            Store (Local2, GTM2)
                            Store (Local3, GTM3)
                            Store (Local4, GTM4)
                            Return (IDEB)
                        }

                        Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                        {
                            Store (Arg0, IDEB)
                            Store (GTM0, Local0)
                            Store (GTM1, Local1)
                            Store (GTM2, Local2)
                            Store (GTM3, Local3)
                            Store (GTM4, Local4)
                            Store (Local4, FLGP)
                            If (LAnd (LNotEqual (Local0, 0xFFFFFFFF), LNotEqual (Local0, Zero)))
                            {
                                Store (Match (PIOT, MEQ, Local0, MTR, Zero, Zero), PIO0)
                            }

                            If (LAnd (LNotEqual (Local1, 0xFFFFFFFF), LNotEqual (Local1, Zero)))
                            {
                                If (LAnd (FLGP, One))
                                {
                                    Store (Match (UDMA, MEQ, Local1, MTR, Zero, Zero), DMA0)
                                }
                                Else
                                {
                                    Store (Match (MDMA, MEQ, Local1, MTR, Zero, Zero), MDA0)
                                }
                            }

                            If (LAnd (LNotEqual (Local2, 0xFFFFFFFF), LNotEqual (Local2, Zero)))
                            {
                                Store (Match (PIOT, MEQ, Local2, MTR, Zero, Zero), PIO1)
                            }

                            If (LAnd (LNotEqual (Local3, 0xFFFFFFFF), LNotEqual (Local3, Zero)))
                            {
                                If (LAnd (FLGP, 0x04))
                                {
                                    Store (Match (UDMA, MEQ, Local3, MTR, Zero, Zero), DMA1)
                                }
                                Else
                                {
                                    Store (Match (MDMA, MEQ, Local3, MTR, Zero, Zero), MDA1)
                                }
                            }
                        }

                        Device (DRV0)
                        {
                            Name (_ADR, Zero)  // _ADR: Address
                            Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                            {
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                    }, Local0)
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                    }, Local1)
                                CreateByteField (Local0, One, PIOM)
                                CreateByteField (Local1, One, DMAM)
                                Store (PIO0, PIOM)
                                Or (PIOM, 0x08, PIOM)
                                If (LAnd (FLGP, One))
                                {
                                    Store (DMA0, DMAM)
                                    Or (DMAM, 0x40, DMAM)
                                }
                                Else
                                {
                                    Store (MDA0, DMAM)
                                    Or (DMAM, 0x20, DMAM)
                                }

                                Concatenate (Local0, Local1, Local2)
                                Return (Local2)
                            }
                        }

                        Device (DRV1)
                        {
                            Name (_ADR, One)  // _ADR: Address
                            Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                            {
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                    }, Local0)
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                    }, Local1)
                                CreateByteField (Local0, One, PIOM)
                                CreateByteField (Local1, One, DMAM)
                                Store (PIO1, PIOM)
                                Or (PIOM, 0x08, PIOM)
                                If (LAnd (FLGP, 0x04))
                                {
                                    Store (DMA1, DMAM)
                                    Or (DMAM, 0x40, DMAM)
                                }
                                Else
                                {
                                    Store (MDA1, DMAM)
                                    Or (DMAM, 0x20, DMAM)
                                }

                                Concatenate (Local0, Local1, Local2)
                                Return (Local2)
                            }
                        }
                    }

                    Device (IDE1)
                    {
                        Name (_ADR, One)  // _ADR: Address
                        Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                        {
                            Store (DerefOf (Index (PIOT, PIO2)), Local0)
                            Store (DerefOf (Index (PIOT, PIO3)), Local2)
                            Store (0x1A, Local4)
                            If (LAnd (FLGS, One))
                            {
                                If (LAnd (CAB0, LNot (SWAP)))
                                {
                                    Store (0x02, DMA2)
                                }

                                Store (DerefOf (Index (UDMA, DMA2)), Local1)
                                Or (Local4, One, Local4)
                            }
                            Else
                            {
                                Store (DerefOf (Index (MDMA, MDA2)), Local1)
                            }

                            If (LAnd (FLGS, 0x04))
                            {
                                If (LAnd (CAB0, LNot (SWAP)))
                                {
                                    Store (0x02, DMA3)
                                }

                                Store (DerefOf (Index (UDMA, DMA3)), Local3)
                                Or (Local4, 0x04, Local4)
                            }
                            Else
                            {
                                Store (DerefOf (Index (MDMA, MDA3)), Local3)
                            }

                            Store (Local0, GTM0)
                            Store (Local1, GTM1)
                            Store (Local2, GTM2)
                            Store (Local3, GTM3)
                            Store (Local4, GTM4)
                            Return (IDEB)
                        }

                        Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                        {
                            Store (Arg0, IDEB)
                            Store (GTM0, Local0)
                            Store (GTM1, Local1)
                            Store (GTM2, Local2)
                            Store (GTM3, Local3)
                            Store (GTM4, Local4)
                            Store (Local4, FLGS)
                            If (LAnd (LNotEqual (Local0, 0xFFFFFFFF), LNotEqual (Local0, Zero)))
                            {
                                Store (Match (PIOT, MEQ, Local0, MTR, Zero, Zero), PIO2)
                            }

                            If (LAnd (LNotEqual (Local1, 0xFFFFFFFF), LNotEqual (Local1, Zero)))
                            {
                                If (LAnd (FLGS, One))
                                {
                                    Store (Match (UDMA, MEQ, Local1, MTR, Zero, Zero), DMA2)
                                }
                                Else
                                {
                                    Store (Match (MDMA, MEQ, Local1, MTR, Zero, Zero), MDA2)
                                }
                            }

                            If (LAnd (LNotEqual (Local2, 0xFFFFFFFF), LNotEqual (Local2, Zero)))
                            {
                                Store (Match (PIOT, MEQ, Local2, MTR, Zero, Zero), PIO3)
                            }

                            If (LAnd (LNotEqual (Local3, 0xFFFFFFFF), LNotEqual (Local3, Zero)))
                            {
                                If (LAnd (FLGS, 0x04))
                                {
                                    Store (Match (UDMA, MEQ, Local3, MTR, Zero, Zero), DMA3)
                                }
                                Else
                                {
                                    Store (Match (MDMA, MEQ, Local3, MTR, Zero, Zero), MDA3)
                                }
                            }
                        }

                        Device (DRV0)
                        {
                            Name (_ADR, Zero)  // _ADR: Address
                            Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                            {
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                    }, Local0)
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF
                                    }, Local1)
                                CreateByteField (Local0, One, PIOM)
                                CreateByteField (Local1, One, DMAM)
                                Store (PIO2, PIOM)
                                Or (PIOM, 0x08, PIOM)
                                If (LAnd (FLGS, One))
                                {
                                    Store (DMA2, DMAM)
                                    Or (DMAM, 0x40, DMAM)
                                }
                                Else
                                {
                                    Store (MDA2, DMAM)
                                    Or (DMAM, 0x20, DMAM)
                                }

                                Concatenate (Local0, Local1, Local2)
                                Return (Local2)
                            }
                        }

                        Device (DRV1)
                        {
                            Name (_ADR, One)  // _ADR: Address
                            Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                            {
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                    }, Local0)
                                Store (Buffer (0x07)
                                    {
                                         0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF
                                    }, Local1)
                                CreateByteField (Local0, One, PIOM)
                                CreateByteField (Local1, One, DMAM)
                                Store (PIO3, PIOM)
                                Or (PIOM, 0x08, PIOM)
                                If (LAnd (FLGS, 0x04))
                                {
                                    Store (DMA3, DMAM)
                                    Or (DMAM, 0x40, DMAM)
                                }
                                Else
                                {
                                    Store (MDA3, DMAM)
                                    Or (DMAM, 0x20, DMAM)
                                }

                                Concatenate (Local0, Local1, Local2)
                                Return (Local2)
                            }
                        }
                    }
                }
            }

            Device (GBE)
            {
                Name (_ADR, 0x00190000)  // _ADR: Address
                OperationRegion (BPME, PCI_Config, 0xCD, One)
                Field (BPME, ByteAcc, NoLock, Preserve)
                {
                        ,   7, 
                    GPMS,   1
                }

                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0D, 0x04))
                }
            }

            Device (P0P2)
            {
                Name (_ADR, 0x001E0000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0B, 0x05))
                }

                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If (PICM)
                    {
                        Return (AR02)
                    }

                    Return (PR02)
                }

                Device (PCI2)
                {
                    Name (_ADR, 0x0004FFFF)  // _ADR: Address
                    Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                    {
                        Return (GPRW (0x0B, 0x04))
                    }
                }
            }

            Device (EUSB)
            {
                Name (_ADR, 0x001D0007)  // _ADR: Address
                Name (_S4D, 0x02)  // _S4D: S4 Device State
                Name (_S3D, 0x02)  // _S3D: S3 Device State
                Name (_S2D, 0x02)  // _S2D: S2 Device State
                Name (_S1D, 0x02)  // _S1D: S1 Device State
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0D, 0x03))
                }
            }

            Device (USBE)
            {
                Name (_ADR, 0x001A0007)  // _ADR: Address
                Name (_S4D, 0x02)  // _S4D: S4 Device State
                Name (_S3D, 0x02)  // _S3D: S3 Device State
                Name (_S2D, 0x02)  // _S2D: S2 Device State
                Name (_S1D, 0x02)  // _S1D: S1 Device State
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (GPRW (0x0D, 0x03))
                }
            }
        }

        Scope (\_GPE)
        {
            Method (_L09, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.P0P1, 0x02)
                Notify (\_SB.PCI0.PEX0, 0x02)
                Notify (\_SB.PCI0.PEX1, 0x02)
                Notify (\_SB.PCI0.PEX2, 0x02)
                Notify (\_SB.PCI0.PEX3, 0x02)
                Notify (\_SB.PCI0.PEX4, 0x02)
            }

            Method (_L1D, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                \_SB.PCI0.SBRG.SIOH ()
            }

            Method (_L08, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                \_SB.PCI0.SBRG.SIOH ()
            }

            Method (_L03, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.USB0, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L04, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.USB1, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0C, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.USB2, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L20, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.USB5, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0E, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.USB3, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L05, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.USB4, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0D, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.GBE, 0x02)
                Notify (\_SB.PCI0.EUSB, 0x02)
                Notify (\_SB.PCI0.USBE, 0x02)
            }

            Method (_L0B, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
            {
                Notify (\_SB.PCI0.P0P2, 0x02)
                Notify (\_SB.PCI0.P0P2.PCI2, 0x02)
            }
        }

        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))  // _HID: Hardware ID
            Name (_UID, 0xAA)  // _UID: Unique ID
            Name (_STA, 0x0B)  // _STA: Status
        }
    }

    OperationRegion (_SB.PCI0.SBRG.PIX0, PCI_Config, 0x60, 0x0C)
    Field (\_SB.PCI0.SBRG.PIX0, ByteAcc, NoLock, Preserve)
    {
        PIRA,   8, 
        PIRB,   8, 
        PIRC,   8, 
        PIRD,   8, 
        Offset (0x08), 
        PIRE,   8, 
        PIRF,   8, 
        PIRG,   8, 
        PIRH,   8
    }

    Scope (_SB)
    {
        Name (BUFA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {15}
        })
        CreateWordField (BUFA, One, IRA0)
        Device (LNKA)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, One)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                And (PIRA, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSA)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                Or (PIRA, 0x80, PIRA)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                And (PIRA, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRA)
            }
        }

        Device (LNKB)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x02)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                And (PIRB, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSB)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                Or (PIRB, 0x80, PIRB)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                And (PIRB, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRB)
            }
        }

        Device (LNKC)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x03)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                And (PIRC, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSC)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                Or (PIRC, 0x80, PIRC)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                And (PIRC, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRC)
            }
        }

        Device (LNKD)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x04)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                And (PIRD, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSD)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                Or (PIRD, 0x80, PIRD)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                And (PIRD, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRD)
            }
        }

        Device (LNKE)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x05)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                And (PIRE, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSE)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                Or (PIRE, 0x80, PIRE)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                And (PIRE, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRE)
            }
        }

        Device (LNKF)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x06)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                And (PIRF, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSF)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                Or (PIRF, 0x80, PIRF)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                And (PIRF, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRF)
            }
        }

        Device (LNKG)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x07)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                And (PIRG, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSG)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                Or (PIRG, 0x80, PIRG)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                And (PIRG, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRG)
            }
        }

        Device (LNKH)
        {
            Name (_HID, EisaId ("PNP0C0F"))  // _HID: Hardware ID
            Name (_UID, 0x08)  // _UID: Unique ID
            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                And (PIRH, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)  // _PRS: Possible Resource Settings
            {
                Return (PRSH)
            }

            Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
            {
                Or (PIRH, 0x80, PIRH)
            }

            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                And (PIRH, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRH)
            }
        }
    }

    Scope (_PR)
    {
        OperationRegion (SSDT, SystemMemory, 0x7DD5AC18, 0x02CC)
        Name (DCOR, 0x01)
        Name (NCST, 0x04)
        Name (NPSS, 0x02)
        Name (HNDL, 0x80000000)
        Name (CINT, Zero)
        Name (APSS, Package (0x02)
        {
            Package (0x06)
            {
                0x09C1, 
                0x00006978, 
                0x000A, 
                0x000A, 
                0x4723, 
                0x4723
            }, 

            Package (0x06)
            {
                0x07CE, 
                0x000035E8, 
                0x000A, 
                0x000A, 
                0x0616, 
                0x0616
            }
        })
        Name (C1ST, Package (0x02)
        {
            One, 
            Package (0x04)
            {
                ResourceTemplate ()
                {
                    Register (FFixedHW, 
                        0x00,               // Bit Width
                        0x00,               // Bit Offset
                        0x0000000000000000, // Address
                        ,)
                }, 

                One, 
                0x14, 
                0x03E8
            }
        })
        Name (C2ST, Package (0x03)
        {
            0x02, 
            Package (0x04)
            {
                ResourceTemplate ()
                {
                    Register (FFixedHW, 
                        0x00,               // Bit Width
                        0x00,               // Bit Offset
                        0x0000000000000000, // Address
                        ,)
                }, 

                One, 
                0x14, 
                0x03E8
            }, 

            Package (0x04)
            {
                ResourceTemplate ()
                {
                    Register (SystemIO, 
                        0x08,               // Bit Width
                        0x00,               // Bit Offset
                        0x0000000000000414, // Address
                        ,)
                }, 

                0x02, 
                0x28, 
                0x02EE
            }
        })
        Name (C3ST, Package (0x04)
        {
            0x03, 
            Package (0x04)
            {
                ResourceTemplate ()
                {
                    Register (FFixedHW, 
                        0x00,               // Bit Width
                        0x00,               // Bit Offset
                        0x0000000000000000, // Address
                        ,)
                }, 

                One, 
                0x14, 
                0x03E8
            }, 

            Package (0x04)
            {
                ResourceTemplate ()
                {
                    Register (SystemIO, 
                        0x08,               // Bit Width
                        0x00,               // Bit Offset
                        0x0000000000000414, // Address
                        ,)
                }, 

                0x02, 
                0x28, 
                0x02EE
            }, 

            Package (0x04)
            {
                ResourceTemplate ()
                {
                    Register (SystemIO, 
                        0x08,               // Bit Width
                        0x00,               // Bit Offset
                        0x0000000000000415, // Address
                        ,)
                }, 

                0x03, 
                0x3C, 
                0x01F4
            }
        })
        Name (C4ST, Package (0x05)
        {
            0x04, 
            Package (0x04)
            {
                ResourceTemplate ()
                {
                    Register (FFixedHW, 
                        0x00,               // Bit Width
                        0x00,               // Bit Offset
                        0x0000000000000000, // Address
                        ,)
                }, 

                One, 
                0x14, 
                0x03E8
            }, 

            Package (0x04)
            {
                ResourceTemplate ()
                {
                    Register (SystemIO, 
                        0x08,               // Bit Width
                        0x00,               // Bit Offset
                        0x0000000000000414, // Address
                        ,)
                }, 

                0x02, 
                0x28, 
                0x02EE
            }, 

            Package (0x04)
            {
                ResourceTemplate ()
                {
                    Register (SystemIO, 
                        0x08,               // Bit Width
                        0x00,               // Bit Offset
                        0x0000000000000415, // Address
                        ,)
                }, 

                0x03, 
                0x3C, 
                0x01F4
            }, 

            Package (0x04)
            {
                ResourceTemplate ()
                {
                    Register (SystemIO, 
                        0x08,               // Bit Width
                        0x00,               // Bit Offset
                        0x0000000000000416, // Address
                        ,)
                }, 

                0x04, 
                0x50, 
                0x0104
            }
        })
        Processor (CPU1, 0x01, 0x00000410, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LEqual (CINT, Zero))
                {
                    Store (One, CINT)
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        If (LNotEqual (NPSS, Zero))
                        {
                            Load (SSDT, HNDL)
                        }
                    }
                    Else
                    {
                        Store (One, NCST)
                    }
                }
            }

            Method (_CST, 0, NotSerialized)  // _CST: C-States
            {
                If (LEqual (NCST, 0x02))
                {
                    Return (C2ST)
                }

                If (LEqual (NCST, 0x03))
                {
                    Return (C3ST)
                }

                If (LEqual (NCST, 0x04))
                {
                    Return (C4ST)
                }

                Return (C1ST)
            }
        }

        Processor (CPU2, 0x02, 0x00000410, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LEqual (CINT, Zero))
                {
                    Store (One, CINT)
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        If (LNotEqual (NPSS, Zero))
                        {
                            Load (SSDT, HNDL)
                        }
                    }
                    Else
                    {
                        Store (One, NCST)
                    }
                }
            }

            Method (_CST, 0, NotSerialized)  // _CST: C-States
            {
                If (LEqual (NCST, 0x02))
                {
                    Return (C2ST)
                }

                If (LEqual (NCST, 0x03))
                {
                    Return (C3ST)
                }

                If (LEqual (NCST, 0x04))
                {
                    Return (C4ST)
                }

                Return (C1ST)
            }
        }

        Processor (CPU3, 0x03, 0x00000410, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LEqual (CINT, Zero))
                {
                    Store (One, CINT)
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        If (LNotEqual (NPSS, Zero))
                        {
                            Load (SSDT, HNDL)
                        }
                    }
                    Else
                    {
                        Store (One, NCST)
                    }
                }
            }

            Method (_CST, 0, NotSerialized)  // _CST: C-States
            {
                If (LEqual (NCST, 0x02))
                {
                    Return (C2ST)
                }

                If (LEqual (NCST, 0x03))
                {
                    Return (C3ST)
                }

                If (LEqual (NCST, 0x04))
                {
                    Return (C4ST)
                }

                Return (C1ST)
            }
        }

        Processor (CPU4, 0x04, 0x00000410, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LEqual (CINT, Zero))
                {
                    Store (One, CINT)
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        If (LNotEqual (NPSS, Zero))
                        {
                            Load (SSDT, HNDL)
                        }
                    }
                    Else
                    {
                        Store (One, NCST)
                    }
                }
            }

            Method (_CST, 0, NotSerialized)  // _CST: C-States
            {
                If (LEqual (NCST, 0x02))
                {
                    Return (C2ST)
                }

                If (LEqual (NCST, 0x03))
                {
                    Return (C3ST)
                }

                If (LEqual (NCST, 0x04))
                {
                    Return (C4ST)
                }

                Return (C1ST)
            }
        }

        Processor (CPU5, 0x05, 0x00000410, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LEqual (CINT, Zero))
                {
                    Store (One, CINT)
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        If (LNotEqual (NPSS, Zero))
                        {
                            Load (SSDT, HNDL)
                        }
                    }
                    Else
                    {
                        Store (One, NCST)
                    }
                }
            }

            Method (_CST, 0, NotSerialized)  // _CST: C-States
            {
                If (LEqual (NCST, 0x02))
                {
                    Return (C2ST)
                }

                If (LEqual (NCST, 0x03))
                {
                    Return (C3ST)
                }

                If (LEqual (NCST, 0x04))
                {
                    Return (C4ST)
                }

                Return (C1ST)
            }
        }

        Processor (CPU6, 0x06, 0x00000410, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LEqual (CINT, Zero))
                {
                    Store (One, CINT)
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        If (LNotEqual (NPSS, Zero))
                        {
                            Load (SSDT, HNDL)
                        }
                    }
                    Else
                    {
                        Store (One, NCST)
                    }
                }
            }

            Method (_CST, 0, NotSerialized)  // _CST: C-States
            {
                If (LEqual (NCST, 0x02))
                {
                    Return (C2ST)
                }

                If (LEqual (NCST, 0x03))
                {
                    Return (C3ST)
                }

                If (LEqual (NCST, 0x04))
                {
                    Return (C4ST)
                }

                Return (C1ST)
            }
        }

        Processor (CPU7, 0x07, 0x00000410, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LEqual (CINT, Zero))
                {
                    Store (One, CINT)
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        If (LNotEqual (NPSS, Zero))
                        {
                            Load (SSDT, HNDL)
                        }
                    }
                    Else
                    {
                        Store (One, NCST)
                    }
                }
            }

            Method (_CST, 0, NotSerialized)  // _CST: C-States
            {
                If (LEqual (NCST, 0x02))
                {
                    Return (C2ST)
                }

                If (LEqual (NCST, 0x03))
                {
                    Return (C3ST)
                }

                If (LEqual (NCST, 0x04))
                {
                    Return (C4ST)
                }

                Return (C1ST)
            }
        }

        Processor (CPU8, 0x08, 0x00000410, 0x06)
        {
            Name (TYPE, 0x80000000)
            Method (_PDC, 1, NotSerialized)  // _PDC: Processor Driver Capabilities
            {
                CreateDWordField (Arg0, 0x08, DAT0)
                Store (DAT0, TYPE)
                If (LEqual (CINT, Zero))
                {
                    Store (One, CINT)
                    If (LOr (LEqual (And (TYPE, 0x1B), 0x1B), LEqual (DCOR, 
                        Zero)))
                    {
                        If (LNotEqual (NPSS, Zero))
                        {
                            Load (SSDT, HNDL)
                        }
                    }
                    Else
                    {
                        Store (One, NCST)
                    }
                }
            }

            Method (_CST, 0, NotSerialized)  // _CST: C-States
            {
                If (LEqual (NCST, 0x02))
                {
                    Return (C2ST)
                }

                If (LEqual (NCST, 0x03))
                {
                    Return (C3ST)
                }

                If (LEqual (NCST, 0x04))
                {
                    Return (C4ST)
                }

                Return (C1ST)
            }
        }
    }

    Scope (_SB)
    {
        Scope (PCI0)
        {
            Device (HPET)
            {
                Name (_HID, EisaId ("PNP0103"))  // _HID: Hardware ID
                Name (CRS, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0xFED00000,         // Address Base
                        0x00000400,         // Address Length
                        _Y0F)
                })
                OperationRegion (HCNT, SystemMemory, HPTC, 0x04)
                Field (HCNT, DWordAcc, NoLock, Preserve)
                {
                    HPTS,   2, 
                        ,   5, 
                    HPTE,   1
                }

                Method (_STA, 0, NotSerialized)  // _STA: Status
                {
                    If (HPTE)
                    {
                        Return (0x0F)
                    }
                    Else
                    {
                        Return (Zero)
                    }
                }

                Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                {
                    CreateDWordField (CRS, \_SB.PCI0.HPET._Y0F._BAS, HTBS)  // _BAS: Base Address
                    Multiply (HPTS, 0x1000, Local0)
                    Add (Local0, 0xFED00000, HTBS)
                    Return (CRS)
                }
            }
        }
    }

    Scope (_SB)
    {
        Scope (PCI0)
        {
            Method (_INI, 0, NotSerialized)  // _INI: Initialize
            {
            }

            Name (CRS, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x00FF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0100,             // Length
                    ,, )
                IO (Decode16,
                    0x0CF8,             // Range Minimum
                    0x0CF8,             // Range Maximum
                    0x01,               // Alignment
                    0x08,               // Length
                    )
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x0CF7,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0CF8,             // Length
                    ,, , TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0D00,             // Range Minimum
                    0xFFFF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0xF300,             // Length
                    ,, , TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000A0000,         // Range Minimum
                    0x000BFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, _Y10, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, _Y11, AddressRangeMemory, TypeStatic)
            })
            CreateDWordField (CRS, \_SB.PCI0._Y10._MIN, MIN5)  // _MIN: Minimum Base Address
            CreateDWordField (CRS, \_SB.PCI0._Y10._MAX, MAX5)  // _MAX: Maximum Base Address
            CreateDWordField (CRS, \_SB.PCI0._Y10._LEN, LEN5)  // _LEN: Length
            CreateDWordField (CRS, \_SB.PCI0._Y11._MIN, MIN6)  // _MIN: Minimum Base Address
            CreateDWordField (CRS, \_SB.PCI0._Y11._MAX, MAX6)  // _MAX: Maximum Base Address
            CreateDWordField (CRS, \_SB.PCI0._Y11._LEN, LEN6)  // _LEN: Length
            Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
            {
                Store (MG1L, Local0)
                If (Local0)
                {
                    Store (MG1B, MIN5)
                    Store (MG1L, LEN5)
                    Add (MIN5, Decrement (Local0), MAX5)
                }

                Store (MG2B, MIN6)
                Store (MG2L, LEN6)
                Store (MG2L, Local0)
                Add (MIN6, Decrement (Local0), MAX6)
                Return (CRS)
            }
        }
    }

    Name (WOTB, Zero)
    Name (WSSB, Zero)
    Name (WAXB, Zero)
    Method (_PTS, 1, NotSerialized)  // _PTS: Prepare To Sleep
    {
        OperationRegion (GPS3, SystemIO, 0x050C, 0x04)
        Field (GPS3, ByteAcc, NoLock, Preserve)
        {
            LED0,   27, 
            LED1,   1, 
            LED2,   1
        }

        Store (Zero, LED1)
        Store (One, LED2)
        Store (Arg0, DBG8)
        If (LAnd (LEqual (Arg0, 0x04), LEqual (OSFL (), 0x02)))
        {
            Sleep (0x0BB8)
        }

        PTS (Arg0)
        Store (Zero, Index (WAKP, Zero))
        Store (Zero, Index (WAKP, One))
        Store (ASSB, WSSB)
        Store (AOTB, WOTB)
        Store (AAXB, WAXB)
        Store (Arg0, ASSB)
        Store (OSFL (), AOTB)
        Store (Zero, AAXB)
        Store (One, \_SB.SLPS)
    }

    Method (_WAK, 1, NotSerialized)  // _WAK: Wake
    {
        OperationRegion (GPS3, SystemIO, 0x050C, 0x04)
        Field (GPS3, ByteAcc, NoLock, Preserve)
        {
            LED0,   27, 
            LED1,   1, 
            LED2,   1
        }

        Store (One, LED1)
        Store (Zero, LED2)
        ShiftLeft (Arg0, 0x04, DBG8)
        WAK (Arg0)
        If (ASSB)
        {
            Store (WSSB, ASSB)
            Store (WOTB, AOTB)
            Store (WAXB, AAXB)
        }

        If (DerefOf (Index (WAKP, Zero)))
        {
            Store (Zero, Index (WAKP, One))
        }
        Else
        {
            Store (Arg0, Index (WAKP, One))
        }

        Return (WAKP)
    }

    Method (_SB.PCI0.SBRG.PS2K._PSW, 1, NotSerialized)  // _PSW: Power State Wake
    {
        Store (Arg0, KBFG)
    }

    Method (_SB.PCI0.SBRG.PS2M._PSW, 1, NotSerialized)  // _PSW: Power State Wake
    {
        Store (Arg0, MSFG)
    }

    Scope (_SB)
    {
        Scope (PCI0)
        {
            Method (_OSC, 4, NotSerialized)  // _OSC: Operating System Capabilities
            {
                Name (SUPP, Zero)
                Name (CTRL, Zero)
                CreateDWordField (Arg3, Zero, CDW1)
                CreateDWordField (Arg3, 0x04, CDW2)
                CreateDWordField (Arg3, 0x08, CDW3)
                If (LEqual (Arg0, Buffer (0x10)
                        {
                            /* 0000 */   0x5B, 0x4D, 0xDB, 0x33, 0xF7, 0x1F, 0x1C, 0x40,
                            /* 0008 */   0x96, 0x57, 0x74, 0x41, 0xC0, 0x3D, 0xD7, 0x66
                        }))
                {
                    Store (CDW2, SUPP)
                    Store (CDW3, CTRL)
                    If (LNotEqual (And (SUPP, 0x16), 0x16))
                    {
                        And (CTRL, 0x1E, CTRL)
                    }

                    If (LNot (PEHP))
                    {
                        And (CTRL, 0x1E, CTRL)
                    }

                    If (LNot (SHPC))
                    {
                        And (CTRL, 0x1D, CTRL)
                    }

                    If (LNot (PEPM))
                    {
                        And (CTRL, 0x1B, CTRL)
                    }

                    If (LNot (PEER))
                    {
                        And (CTRL, 0x15, CTRL)
                    }

                    If (LNot (PECS))
                    {
                        And (CTRL, 0x0F, CTRL)
                    }

                    If (LNotEqual (Arg1, One))
                    {
                        Or (CDW1, 0x08, CDW1)
                    }

                    If (LNotEqual (CDW3, CTRL))
                    {
                        Or (CDW1, 0x10, CDW1)
                    }

                    Store (CTRL, CDW3)
                    Return (Arg3)
                }
                Else
                {
                    Or (CDW1, 0x04, CDW1)
                    Return (Arg3)
                }
            }
        }
    }

    Device (OMSC)
    {
        Name (_HID, EisaId ("PNP0C02"))  // _HID: Hardware ID
        Name (_UID, 0x0E11)  // _UID: Unique ID
    }

    Device (_SB.RMEM)
    {
        Name (_HID, EisaId ("PNP0C01"))  // _HID: Hardware ID
        Name (_UID, One)  // _UID: Unique ID
    }

    Scope (_SB.PCI0)
    {
        Device (GFX0)
        {
            Name (_ADR, 0x00020000)  // _ADR: Address
            Name (OPBS, 0xFFFFFF00)
            Method (OPBA, 0, NotSerialized)
            {
                Store (ASLS, Local0)
                If (LEqual (Local0, 0xFFFFFFFF))
                {
                    Store (0xFF000000, Local0)
                }

                Return (Local0)
            }

            Method (_ROM, 2, NotSerialized)  // _ROM: Read-Only Memory
            {
                If (IGDS)
                {
                    OperationRegion (VNVS, SystemMemory, VRBS, 0x00010000)
                    Field (VNVS, ByteAcc, NoLock, Preserve)
                    {
                        VBRG,   524288
                    }

                    Multiply (Arg0, 0x08, Local0)
                    Multiply (Arg1, 0x08, Local1)
                    CreateField (VBRG, Local0, Local1, TBF)
                    Return (TBF)
                }
            }

            Scope (^^PCI0)
            {
                OperationRegion (MCHP, PCI_Config, 0x40, 0xC0)
                Field (MCHP, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x60), 
                    TASM,   10, 
                    Offset (0x62)
                }
            }

            OperationRegion (IGDP, PCI_Config, 0x40, 0xC0)
            Field (IGDP, AnyAcc, NoLock, Preserve)
            {
                Offset (0x12), 
                    ,   1, 
                GIVD,   1, 
                    ,   2, 
                GUMA,   3, 
                Offset (0x14), 
                    ,   4, 
                GMFN,   1, 
                Offset (0x18), 
                Offset (0x8C), 
                CDCT,   10, 
                Offset (0x8E), 
                Offset (0xA8), 
                GSSE,   1, 
                GSSB,   14, 
                GSES,   1, 
                Offset (0xBC), 
                ASLS,   32
            }

            Name (M512, 0x08)
            Name (M1GB, 0x10)
            Scope (\)
            {
                Name (ASLA, 0xFFFF0000)
                Name (PVID, 0x00010000)
            }

            OperationRegion (IGDM, SystemMemory, OPBA (), 0x2000)
            Field (IGDM, AnyAcc, NoLock, Preserve)
            {
                SIGN,   128, 
                SIZE,   32, 
                OVER,   32, 
                SVER,   256, 
                VVER,   128, 
                GVER,   128, 
                MBOX,   32, 
                Offset (0xE0), 
                KSV0,   32, 
                KSV1,   8, 
                Offset (0xF0), 
                IBTT,   8, 
                IPSC,   8, 
                IPAT,   8, 
                IBIA,   8, 
                IBLC,   8, 
                ITVF,   4, 
                ITVM,   4, 
                IDVM,   8, 
                IDVS,   8, 
                ISSC,   8, 
                Offset (0x100), 
                DRDY,   32, 
                CSTS,   32, 
                CEVT,   32, 
                Offset (0x120), 
                DIDL,   32, 
                DDL2,   32, 
                DDL3,   32, 
                DDL4,   32, 
                DDL5,   32, 
                DDL6,   32, 
                DDL7,   32, 
                DDL8,   32, 
                CPDL,   32, 
                CPL2,   32, 
                CPL3,   32, 
                CPL4,   32, 
                CPL5,   32, 
                CPL6,   32, 
                CPL7,   32, 
                CPL8,   32, 
                CADL,   32, 
                CAL2,   32, 
                CAL3,   32, 
                CAL4,   32, 
                CAL5,   32, 
                CAL6,   32, 
                CAL7,   32, 
                CAL8,   32, 
                NADL,   32, 
                NDL2,   32, 
                NDL3,   32, 
                NDL4,   32, 
                NDL5,   32, 
                NDL6,   32, 
                NDL7,   32, 
                NDL8,   32, 
                ASLP,   32, 
                TIDX,   32, 
                CHPD,   32, 
                CLID,   32, 
                CDCK,   32, 
                SXSW,   32, 
                EVTS,   32, 
                CNOT,   32, 
                NRDY,   32, 
                Offset (0x200), 
                SCIE,   1, 
                GEFC,   4, 
                GXFC,   3, 
                GESF,   8, 
                Offset (0x204), 
                PARM,   32, 
                DSLP,   32, 
                Offset (0x300), 
                ARDY,   32, 
                ASLC,   32, 
                TCHE,   32, 
                ALSI,   32, 
                BCLP,   32, 
                PFIT,   32, 
                CBLV,   32, 
                BCLM,   320, 
                CPFM,   32, 
                EPFM,   32, 
                Offset (0x400), 
                GVD1,   57344
            }

            OperationRegion (TCOI, SystemIO, TOBS, 0x08)
            Field (TCOI, WordAcc, NoLock, Preserve)
            {
                Offset (0x04), 
                    ,   9, 
                SCIS,   1, 
                Offset (0x06)
            }

            Name (DBTB, Package (0x15)
            {
                Zero, 
                0x07, 
                0x38, 
                0x01C0, 
                0x0E00, 
                0x3F, 
                0x01C7, 
                0x0E07, 
                0x01F8, 
                0x0E38, 
                0x0FC0, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                0x7000, 
                0x7007, 
                0x7038, 
                0x71C0, 
                0x7E00
            })
            Method (GSCI, 0, NotSerialized)
            {
                If (LEqual (GEFC, 0x04))
                {
                    Store (GBDA (), GXFC)
                }

                If (LEqual (GEFC, 0x06))
                {
                    Store (SBCB (), GXFC)
                }

                Store (One, SCIS)
                Store (Zero, GEFC)
                Store (Zero, GSSE)
                Store (Zero, SCIE)
                Return (Zero)
            }

            Method (GBDA, 0, NotSerialized)
            {
                If (LEqual (GESF, Zero))
                {
                    Store (0x0679, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, One))
                {
                    Store (0x0240, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x04))
                {
                    And (PARM, 0xEFFF0000, PARM)
                    And (PARM, ShiftLeft (DerefOf (Index (DBTB, IBTT)), 0x10), 
                        PARM)
                    Or (IBTT, PARM, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x05))
                {
                    Store (IPSC, PARM)
                    Or (PARM, ShiftLeft (IPAT, 0x08), PARM)
                    Add (PARM, 0x0100, PARM)
                    Or (PARM, ShiftLeft (LDST, 0x10), PARM)
                    XOr (PARM, 0x00010000, PARM)
                    Or (PARM, ShiftLeft (IBIA, 0x14), PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x06))
                {
                    Store (ITVF, PARM)
                    Or (PARM, ShiftLeft (ITVM, 0x04), PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x07))
                {
                    Name (MEMS, 0x0D)
                    Store (GIVD, PARM)
                    XOr (PARM, One, PARM)
                    Or (PARM, ShiftLeft (GMFN, One), PARM)
                    Or (PARM, 0x1800, PARM)
                    Or (ShiftLeft (CDCT, 0x15), PARM, PARM)
                    If (LEqual (IDVM, One))
                    {
                        Store (0x11, MEMS)
                    }

                    If (LLess (TASM, M512))
                    {
                        Or (PARM, ShiftLeft (One, MEMS), PARM)
                    }
                    Else
                    {
                        If (LLess (TASM, M1GB))
                        {
                            If (LLess (IDVS, 0x03))
                            {
                                Or (PARM, ShiftLeft (IDVS, MEMS), PARM)
                            }
                            Else
                            {
                                Or (PARM, ShiftLeft (0x02, MEMS), PARM)
                            }
                        }
                        Else
                        {
                            Or (PARM, ShiftLeft (IDVS, MEMS), PARM)
                        }
                    }

                    Store (One, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x0A))
                {
                    Store (Zero, PARM)
                    If (ISSC)
                    {
                        Or (PARM, 0x03, PARM)
                    }

                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x0B))
                {
                    Store (KSV0, PARM)
                    Store (KSV1, GESF)
                    Return (SUCC)
                }

                Store (Zero, GESF)
                Return (CRIT)
            }

            Method (SBCB, 0, NotSerialized)
            {
                If (LEqual (GESF, Zero))
                {
                    Store (0x20, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, One))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x03))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x04))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x05))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x06))
                {
                    ShiftRight (PARM, 0x1C, Local0)
                    If (LEqual (Local0, Zero))
                    {
                        And (PARM, 0x0F, ITVF)
                        And (PARM, 0xF0, ITVM)
                    }

                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x07))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x08))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x09))
                {
                    And (PARM, 0xFF, IBTT)
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x0A))
                {
                    ShiftRight (PARM, 0x1C, Local0)
                    If (LEqual (Local0, Zero))
                    {
                        And (PARM, 0xFF, IPSC)
                        Subtract (And (ShiftRight (PARM, 0x08), 0xFF), One, IPAT)
                        And (ShiftRight (PARM, 0x12), 0x03, IBLC)
                        And (ShiftRight (PARM, 0x14), 0x07, IBIA)
                    }

                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x0B))
                {
                    If (LEqual (And (ShiftRight (PARM, 0x0B), 0x03), 0x02))
                    {
                        And (ShiftRight (PARM, 0x0D), 0x0F, Local0)
                        And (ShiftRight (PARM, 0x11), 0x0F, Local1)
                        If (Local0)
                        {
                            Store (Zero, IDVM)
                            Store (Local0, IDVS)
                        }

                        If (Local1)
                        {
                            Store (One, IDVM)
                            Store (Local1, IDVS)
                        }
                    }

                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x10))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x11))
                {
                    Store (ShiftLeft (LDST, 0x08), PARM)
                    Add (PARM, 0x0100, PARM)
                    NAnd (PARM, 0x0200, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x12))
                {
                    If (And (PARM, One))
                    {
                        If (LEqual (ShiftRight (PARM, One), One))
                        {
                            Store (One, ISSC)
                        }
                        Else
                        {
                            Store (Zero, GESF)
                            Return (CRIT)
                        }
                    }
                    Else
                    {
                        Store (Zero, ISSC)
                    }

                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x13))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                Store (Zero, GESF)
                Return (SUCC)
            }

            Method (OPTS, 1, NotSerialized)
            {
                If (LEqual (Arg0, 0x03))
                {
                    Store (ASLS, OPBS)
                }
            }

            Method (OWAK, 1, NotSerialized)
            {
                If (LEqual (Arg0, 0x03))
                {
                    Store (OPBS, ASLS)
                    Store (One, GSES)
                }
            }
        }
    }

    Scope (_GPE)
    {
        Method (_L06, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            \_SB.PCI0.GFX0.GSCI ()
        }
    }

    Scope (_SB)
    {
        OperationRegion (SMIR, SystemIO, PM30, 0x08)
        Field (SMIR, ByteAcc, NoLock, Preserve)
        {
                ,   1, 
                ,   3, 
            SE,     1, 
            Offset (0x04), 
                ,   4, 
            SS,     1
        }

        Method (ITKS, 1, NotSerialized)
        {
            Store (One, SS)
            Store (One, SE)
        }

        Method (ITKW, 1, NotSerialized)
        {
            Store (Zero, SE)
            Store (One, SS)
        }
    }

    Name (_S0, Package (0x04)  // _S0_: S0 System State
    {
        Zero, 
        Zero, 
        Zero, 
        Zero
    })
    If (SS1)
    {
        Name (_S1, Package (0x04)  // _S1_: S1 System State
        {
            One, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS3)
    {
        Name (_S3, Package (0x04)  // _S3_: S3 System State
        {
            0x05, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS4)
    {
        Name (_S4, Package (0x04)  // _S4_: S4 System State
        {
            0x06, 
            Zero, 
            Zero, 
            Zero
        })
    }

    Name (_S5, Package (0x04)  // _S5_: S5 System State
    {
        0x07, 
        Zero, 
        Zero, 
        Zero
    })
    Method (PTS, 1, NotSerialized)
    {
        If (Arg0)
        {
            \_SB.PCI0.SBRG.SPTS (Arg0)
            \_SB.PCI0.PEX0.SPRT (Arg0)
            \_SB.PCI0.PEX1.SPRT (Arg0)
            \_SB.PCI0.PEX2.SPRT (Arg0)
            \_SB.PCI0.PEX3.SPRT (Arg0)
            \_SB.PCI0.PEX4.SPRT (Arg0)
            \_SB.PCI0.GFX0.OPTS (Arg0)
            \_SB.ITKS (Arg0)
            \_SB.PCI0.SBRG.SIOS (Arg0)
        }
    }

    Method (WAK, 1, NotSerialized)
    {
        \_SB.PCI0.SBRG.SWAK (Arg0)
        If (\_SB.PCI0.PEX0.PMS)
        {
            \_SB.PCI0.PEX0.WPRT (Arg0)
            Notify (\_SB.PCI0.PEX0, 0x02)
        }
        Else
        {
            \_SB.PCI0.PEX0.WPRT (Arg0)
        }

        If (\_SB.PCI0.PEX1.PMS)
        {
            \_SB.PCI0.PEX1.WPRT (Arg0)
            Notify (\_SB.PCI0.PEX1, 0x02)
        }
        Else
        {
            \_SB.PCI0.PEX1.WPRT (Arg0)
        }

        If (\_SB.PCI0.PEX2.PMS)
        {
            \_SB.PCI0.PEX2.WPRT (Arg0)
            Notify (\_SB.PCI0.PEX2, 0x02)
        }
        Else
        {
            \_SB.PCI0.PEX2.WPRT (Arg0)
        }

        If (\_SB.PCI0.PEX3.PMS)
        {
            \_SB.PCI0.PEX3.WPRT (Arg0)
            Notify (\_SB.PCI0.PEX3, 0x02)
        }
        Else
        {
            \_SB.PCI0.PEX3.WPRT (Arg0)
        }

        If (\_SB.PCI0.PEX4.PMS)
        {
            \_SB.PCI0.PEX4.WPRT (Arg0)
            Notify (\_SB.PCI0.PEX4, 0x02)
        }
        Else
        {
            \_SB.PCI0.PEX4.WPRT (Arg0)
        }

        \_SB.PCI0.GFX0.OWAK (Arg0)
        \_SB.ITKW (Arg0)
        \_SB.PCI0.SBRG.SIOW (Arg0)
    }
}

