/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20110112-32 [Oct 20 2011]
 * Copyright (c) 2000 - 2011 Intel Corporation
 * 
 * Disassembly of (null), Fri Feb 10 21:01:20 2012
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x00006D9F (28063)
 *     Revision         0x02
 *     Checksum         0xD1
 *     OEM ID           "965HG"
 *     OEM Table ID     "965HGP03"
 *     OEM Revision     0x00000000 (0)
 *     Compiler ID      "INTL"
 *     Compiler Version 0x20051117 (537202967)
 */

DefinitionBlock ("DSDT.aml", "DSDT", 2, "965HG", "965HGP03", 0x00000000)
{
    External (NNAB, MethodObj)    // 0 Arguments
    External (IDAB, MethodObj)    // 0 Arguments

    Scope (_PR)
    {
        Processor (P001, 0x01, 0x00000810, 0x06) {}
        Alias (P001, CPU1)
    }

    Scope (_PR)
    {
        Processor (P002, 0x02, 0x00000810, 0x06) {}
        Alias (P002, CPU2)
    }

    Scope (_PR)
    {
        Processor (P003, 0x03, 0x00000810, 0x06) {}
        Alias (P003, CPU3)
    }

    Scope (_PR)
    {
        Processor (P004, 0x04, 0x00000810, 0x06) {}
        Alias (P004, CPU4)
    }

    Name (DP80, 0x80)
    Name (DP90, 0x90)
    Name (APIC, One)
    Name (PMBS, 0x0800)
    Name (PMLN, 0x80)
    Name (GPBS, 0x0500)
    Name (GPLN, 0x80)
    Name (SMBS, Zero)
    Name (SMBL, Zero)
    Name (PM30, 0x0830)
    Name (SUSW, 0xFF)
    Name (TPBA, 0xFED40000)
    Name (TPBL, Zero)
    Name (SMIP, 0xB2)
    Name (MIEC, Zero)
    Name (TOBS, 0x0860)
    Name (SUCC, One)
    Name (NVLD, 0x02)
    Name (CRIT, 0x04)
    Name (NCRT, 0x06)
    Name (LIDS, One)
    Name (CHST, 0x0B)
    Name (DVMT, 0x05)
    Name (PCIB, 0xE0000000)
    Name (PCIL, 0x10000000)
    Name (PEHP, One)
    Name (SHPC, Zero)
    Name (PEPM, One)
    Name (PEER, One)
    Name (PECS, One)
    Name (ITEC, One)
    Name (BWRN, 0x0A)
    Name (BLOW, 0x05)
    Name (BCRT, Zero)
    OperationRegion (BIOS, SystemMemory, 0x7DC9E064, 0xFF)
    Field (BIOS, ByteAcc, NoLock, Preserve)
    {
        SS1,    1, 
        SS2,    1, 
        SS3,    1, 
        SS4,    1, 
                Offset (0x01), 
        IOST,   16, 
        TOPM,   32, 
        ROMS,   32, 
        MG1B,   32, 
        MG1L,   32, 
        MG2B,   32, 
        MG2L,   32, 
                Offset (0x1C), 
        DMAX,   8, 
        HPTA,   32, 
        CPB0,   32, 
        CPB1,   32, 
        CPB2,   32, 
        CPB3,   32, 
        ASSB,   8, 
        AOTB,   8, 
        AAXB,   32, 
        SMIF,   8, 
        DTSE,   8, 
        DTS1,   8, 
        DTS2,   8, 
        MPEN,   8, 
        TPMF,   8, 
        MG3B,   32, 
        MG3L,   32, 
        MH1B,   32, 
        MH1L,   32, 
        OSTP,   8
    }

    Method (RRIO, 4, NotSerialized)
    {
        Store ("RRIO", Debug)
    }

    Method (RDMA, 3, NotSerialized)
    {
        Store ("rDMA", Debug)
    }

    Name (PICM, Zero)
    Method (_PIC, 1, NotSerialized)
    {
        If (Arg0)
        {
            Store (0xAA, DBG8)
        }
        Else
        {
            Store (0xAC, DBG8)
        }

        Store (Arg0, PICM)
    }

    Name (OSVR, Ones)
    Method (OSFL, 0, NotSerialized)
    {
        If (LNotEqual (OSVR, Ones))
        {
            Return (OSVR)
        }

        Name (TTT0, Zero)
        Store (OSYS (), TTT0)
        If (LEqual (TTT0, One))
        {
            Store (0x03, OSVR)
        }
        Else
        {
            If (LEqual (TTT0, 0x10))
            {
                Store (One, OSVR)
            }
            Else
            {
                If (LEqual (TTT0, 0x11))
                {
                    Store (0x02, OSVR)
                }
                Else
                {
                    If (LEqual (TTT0, 0x12))
                    {
                        Store (0x04, OSVR)
                    }
                    Else
                    {
                        If (LEqual (TTT0, 0x13))
                        {
                            Store (Zero, OSVR)
                        }
                        Else
                        {
                            If (LEqual (TTT0, 0x14))
                            {
                                Store (Zero, OSVR)
                            }
                            Else
                            {
                                If (LEqual (TTT0, 0x15))
                                {
                                    Store (Zero, OSVR)
                                }
                            }
                        }
                    }
                }
            }
        }

        Return (OSVR)
    }

    Method (MCTH, 2, NotSerialized)
    {
        If (LLess (SizeOf (Arg0), SizeOf (Arg1)))
        {
            Return (Zero)
        }

        Add (SizeOf (Arg0), One, Local0)
        Name (BUF0, Buffer (Local0) {})
        Name (BUF1, Buffer (Local0) {})
        Store (Arg0, BUF0)
        Store (Arg1, BUF1)
        While (Local0)
        {
            Decrement (Local0)
            If (LNotEqual (DerefOf (Index (BUF0, Local0)), DerefOf (Index (
                BUF1, Local0))))
            {
                Return (Zero)
            }
        }

        Return (One)
    }

    Name (PRWP, Package (0x02)
    {
        Zero, 
        Zero
    })
    Method (GPRW, 2, NotSerialized)
    {
        Store (Arg0, Index (PRWP, Zero))
        Store (ShiftLeft (SS1, One), Local0)
        Or (Local0, ShiftLeft (SS2, 0x02), Local0)
        Or (Local0, ShiftLeft (SS3, 0x03), Local0)
        Or (Local0, ShiftLeft (SS4, 0x04), Local0)
        If (And (ShiftLeft (One, Arg1), Local0))
        {
            Store (Arg1, Index (PRWP, One))
        }
        Else
        {
            ShiftRight (Local0, One, Local0)
            If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
            {
                FindSetLeftBit (Local0, Index (PRWP, One))
            }
            Else
            {
                FindSetRightBit (Local0, Index (PRWP, One))
            }
        }

        Return (PRWP)
    }

    Name (WAKP, Package (0x02)
    {
        Zero, 
        Zero
    })
    OperationRegion (DEB0, SystemIO, DP80, One)
    Field (DEB0, ByteAcc, NoLock, Preserve)
    {
        DBG8,   8
    }

    OperationRegion (DEB1, SystemIO, DP90, 0x02)
    Field (DEB1, WordAcc, NoLock, Preserve)
    {
        DBG9,   16
    }

    Method (OSYS, 0, NotSerialized)
    {
        Store (0x10, Local0)
        If (CondRefOf (_OSI, Local1))
        {
            If (_OSI ("Windows 2000"))
            {
                Store (0x12, Local0)
            }

            If (_OSI ("Windows 2001"))
            {
                Store (0x13, Local0)
            }

            If (_OSI ("Windows 2001 SP1"))
            {
                Store (0x13, Local0)
            }

            If (_OSI ("Windows 2001 SP2"))
            {
                Store (0x13, Local0)
            }

            If (_OSI ("Windows 2001.1"))
            {
                Store (0x14, Local0)
            }

            If (_OSI ("Windows 2001.1 SP1"))
            {
                Store (0x14, Local0)
            }

            If (_OSI ("Windows 2006"))
            {
                Store (0x15, Local0)
            }
        }
        Else
        {
            If (MCTH (_OS, "Microsoft Windows NT"))
            {
                Store (0x12, Local0)
            }
            Else
            {
                If (MCTH (_OS, "Microsoft WindowsME: Millennium Edition"))
                {
                    Store (0x11, Local0)
                }
            }
        }

        Return (Local0)
    }

    Scope (_SB)
    {
        Name (PR00, Package (0x16)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                One, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001BFFFF, 
                Zero, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x0019FFFF, 
                Zero, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                One, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x03, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                0x02, 
                LNKC, 
                Zero
            }
        })
        Name (AR00, Package (0x16)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                One, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                0x03, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001BFFFF, 
                Zero, 
                Zero, 
                0x16
            }, 

            Package (0x04)
            {
                0x0019FFFF, 
                Zero, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                One, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x03, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                Zero, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x03, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001AFFFF, 
                0x02, 
                Zero, 
                0x12
            }
        })
        Name (PR02, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR02, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR04, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR04, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR05, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR05, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x10
            }
        })
        Name (PR06, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKB, 
                Zero
            }
        })
        Name (AR06, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x11
            }
        })
        Name (PR08, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR08, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR09, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR09, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x10
            }
        })
        Name (PR07, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKC, 
                Zero
            }
        })
        Name (AR07, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x12
            }
        })
        Name (PRSA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {3,4,6,7,10,11,12,14,15}
        })
        Name (PRSB, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {5}
        })
        Alias (PRSA, PRSC)
        Alias (PRSA, PRSD)
        Alias (PRSA, PRSE)
        Alias (PRSA, PRSF)
        Alias (PRSA, PRSG)
        Alias (PRSA, PRSH)
        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A08"))
            Name (_ADR, Zero)
            Method (^BN00, 0, NotSerialized)
            {
                Return (Zero)
            }

            Method (_BBN, 0, NotSerialized)
            {
                Return (BN00 ())
            }

            Name (_UID, Zero)
            Method (_PRT, 0, NotSerialized)
            {
                If (PICM)
                {
                    Return (AR00)
                }

                Return (PR00)
            }

            Method (_S3D, 0, NotSerialized)
            {
                If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                {
                    Return (0x02)
                }
                Else
                {
                    Return (0x03)
                }
            }

            Name (_CID, EisaId ("PNP0A03"))
            Device (MCH)
            {
                Name (_HID, EisaId ("PNP0C02"))
                Name (_UID, 0x0A)
                Name (_CRS, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0xFED10000,         // Address Base
                        0x0000A000,         // Address Length
                        )
                })
            }

            Method (NPTS, 1, NotSerialized)
            {
            }

            Method (NWAK, 1, NotSerialized)
            {
            }

            Device (P0P2)
            {
                Name (_ADR, 0x00010000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR02)
                    }

                    Return (PR02)
                }
            }

            Device (P0P1)
            {
                Name (_ADR, 0x001E0000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0B, 0x04))
                }
            }

            Device (SBRG)
            {
                Name (_ADR, 0x001F0000)
                Device (IELK)
                {
                    Name (_HID, "AWY0001")
                    OperationRegion (RXA0, PCI_Config, 0xA0, 0x20)
                    Field (RXA0, ByteAcc, NoLock, Preserve)
                    {
                            ,   9, 
                        PBLV,   1, 
                                Offset (0x10), 
                            ,   1, 
                        PBMS,   1, 
                            ,   1, 
                        PMCS,   1, 
                        ECNS,   1, 
                                Offset (0x11), 
                        ECT1,   16, 
                        ELEN,   1, 
                                Offset (0x14)
                    }

                    Method (\_GPE._L0A, 0, NotSerialized)
                    {
                        Notify (\_SB.PCI0.SBRG.IELK, 0x81)
                        Store (One, \_SB.PCI0.SBRG.IELK.PMCS)
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        If (ELEN)
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }

                    Method (SMOD, 1, NotSerialized)
                    {
                    }

                    Method (GPBS, 0, NotSerialized)
                    {
                        Return (XOr (PBLV, One))
                    }
                }

                Method (SPTS, 1, NotSerialized)
                {
                    Store (One, PS1S)
                    Store (One, PS1E)
                    Store (One, SLPS)
                }

                Method (SWAK, 1, NotSerialized)
                {
                    Store (Zero, SLPS)
                    Store (Zero, PS1E)
                    If (LAnd (LEqual (Arg0, One), RTCS)) {}
                    Else
                    {
                        If (LAnd (LEqual (Arg0, 0x03), BRTC)) {}
                        Else
                        {
                            Notify (PWRB, 0x02)
                        }
                    }
                }

                OperationRegion (APMP, SystemIO, SMIP, 0x02)
                Field (APMP, ByteAcc, NoLock, Preserve)
                {
                    APMC,   8, 
                    APMS,   8
                }

                Field (APMP, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x01), 
                        ,   1, 
                    BRTC,   1
                }

                OperationRegion (PMS0, SystemIO, PMBS, 0x04)
                Field (PMS0, ByteAcc, NoLock, Preserve)
                {
                        ,   10, 
                    RTCS,   1, 
                        ,   4, 
                    WAKS,   1, 
                            Offset (0x03), 
                    PWBT,   1, 
                            Offset (0x04)
                }

                OperationRegion (SMIE, SystemIO, PM30, 0x08)
                Field (SMIE, ByteAcc, NoLock, Preserve)
                {
                        ,   4, 
                    PS1E,   1, 
                        ,   31, 
                    PS1S,   1, 
                            Offset (0x08)
                }

                Scope (\_SB)
                {
                    Name (SLPS, Zero)
                    Device (SLPB)
                    {
                        Name (_HID, EisaId ("PNP0C0E"))
                        Method (_STA, 0, NotSerialized)
                        {
                            If (LNotEqual (SUSW, 0xFF))
                            {
                                Return (0x0F)
                            }

                            Return (Zero)
                        }

                        Method (SBEV, 0, NotSerialized)
                        {
                            If (SLPS)
                            {
                                Notify (SLPB, 0x02)
                            }
                            Else
                            {
                                Notify (SLPB, 0x80)
                            }
                        }

                        Method (\_GPE._L1B, 0, NotSerialized)
                        {
                            \_SB.SLPB.SBEV ()
                        }

                        Method (_PRW, 0, NotSerialized)
                        {
                            Return (Package (0x02)
                            {
                                0x1B, 
                                0x04
                            })
                        }
                    }
                }

                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0020,             // Range Minimum
                            0x0020,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A0,             // Range Minimum
                            0x00A0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {2}
                    })
                }

                Device (DMAD)
                {
                    Name (_HID, EisaId ("PNP0200"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        DMA (Compatibility, BusMaster, Transfer8, )
                            {4}
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0081,             // Range Minimum
                            0x0081,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0087,             // Range Minimum
                            0x0087,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0089,             // Range Minimum
                            0x0089,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x008F,             // Range Minimum
                            0x008F,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x00C0,             // Range Minimum
                            0x00C0,             // Range Maximum
                            0x00,               // Alignment
                            0x20,               // Length
                            )
                    })
                }

                Device (TMR)
                {
                    Name (_HID, EisaId ("PNP0100"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {0}
                    })
                }

                Device (RTC0)
                {
                    Name (_HID, EisaId ("PNP0B00"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {8}
                    })
                }

                Device (PS2K)
                {
                    Name (_HID, EisaId ("PNP0303"))
                    Name (_CID, EisaId ("PNP030B"))
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (Zero)
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {1}
                    })
                }

                Device (PS2M)
                {
                    Name (_HID, EisaId ("PNP0F03"))
                    Name (_CID, EisaId ("PNP0F13"))
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0C, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (Zero)
                    }

                    Name (M2R0, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {12}
                    })
                    Name (M2R1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {12}
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (M2R0)
                        }
                        Else
                        {
                            Return (M2R1)
                        }
                    }
                }

                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0061,             // Range Minimum
                            0x0061,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                    })
                }

                Device (COPR)
                {
                    Name (_HID, EisaId ("PNP0C04"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x00F0,             // Range Minimum
                            0x00F0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IRQNoFlags ()
                            {13}
                    })
                }

                Device (RMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x10)
                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0010,             // Range Minimum
                            0x0010,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0022,             // Range Minimum
                            0x0022,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x0044,             // Range Minimum
                            0x0044,             // Range Maximum
                            0x00,               // Alignment
                            0x1C,               // Length
                            )
                        IO (Decode16,
                            0x0063,             // Range Minimum
                            0x0063,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0065,             // Range Minimum
                            0x0065,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0067,             // Range Minimum
                            0x0067,             // Range Maximum
                            0x00,               // Alignment
                            0x09,               // Length
                            )
                        IO (Decode16,
                            0x0072,             // Range Minimum
                            0x0072,             // Range Maximum
                            0x00,               // Alignment
                            0x0E,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0084,             // Range Minimum
                            0x0084,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0088,             // Range Minimum
                            0x0088,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x008C,             // Range Minimum
                            0x008C,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0090,             // Range Minimum
                            0x0090,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x00A2,             // Range Minimum
                            0x00A2,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x00E0,             // Range Minimum
                            0x00E0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            )
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            )
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED1C000,         // Address Base
                            0x00004000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateWordField (CRS, 0x7A, GP00)
                        CreateWordField (CRS, 0x7C, GP01)
                        CreateByteField (CRS, 0x7F, GP0L)
                        Store (PMBS, GP00)
                        Store (PMBS, GP01)
                        Store (PMLN, GP0L)
                        If (SMBS)
                        {
                            CreateWordField (CRS, 0x82, GP10)
                            CreateWordField (CRS, 0x84, GP11)
                            CreateByteField (CRS, 0x87, GP1L)
                            Store (SMBS, GP10)
                            Store (SMBS, GP11)
                            Store (SMBL, GP1L)
                        }

                        If (GPBS)
                        {
                            CreateWordField (CRS, 0x8A, GP20)
                            CreateWordField (CRS, 0x8C, GP21)
                            CreateByteField (CRS, 0x8F, GP2L)
                            Store (GPBS, GP20)
                            Store (GPBS, GP21)
                            Store (GPLN, GP2L)
                        }

                        CreateDWordField (CRS, 0xA4, TML1)
                        CreateDWordField (CRS, 0xA0, TMB1)
                        CreateDWordField (CRS, 0xB0, TML2)
                        CreateDWordField (CRS, 0xAC, TMB2)
                        Store (0xFED20000, TMB1)
                        Subtract (TPBA, 0xFED20000, TML1)
                        If (TPMF)
                        {
                            Add (TPBA, TPBL, TMB2)
                        }
                        Else
                        {
                            Add (TPBA, Zero, TMB2)
                        }

                        Subtract (0xFED90000, TMB2, TML2)
                        Return (CRS)
                    }
                }

                Device (HPET)
                {
                    Name (_HID, EisaId ("PNP0103"))
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0xFED00000,         // Address Base
                            0x00000400,         // Address Length
                            )
                    })
                    OperationRegion (^LPCR, SystemMemory, 0xFED1F404, 0x04)
                    Field (LPCR, AnyAcc, NoLock, Preserve)
                    {
                        HPTS,   2, 
                            ,   5, 
                        HPTE,   1, 
                                Offset (0x04)
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        If (LEqual (OSFL (), Zero))
                        {
                            If (HPTE)
                            {
                                Return (0x0F)
                            }
                        }
                        Else
                        {
                            If (HPTE)
                            {
                                Return (0x0B)
                            }
                        }

                        Return (Zero)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, 0x04, HPT)
                        Multiply (HPTS, 0x1000, Local0)
                        Add (Local0, 0xFED00000, HPT)
                        Return (CRS)
                    }
                }

                OperationRegion (RX80, PCI_Config, Zero, 0xFF)
                Field (RX80, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x80), 
                    LPCD,   16, 
                    LPCE,   16
                }

                Name (DBPT, Package (0x04)
                {
                    Package (0x08)
                    {
                        0x03F8, 
                        0x02F8, 
                        0x0220, 
                        0x0228, 
                        0x0238, 
                        0x02E8, 
                        0x0338, 
                        0x03E8
                    }, 

                    Package (0x08)
                    {
                        0x03F8, 
                        0x02F8, 
                        0x0220, 
                        0x0228, 
                        0x0238, 
                        0x02E8, 
                        0x0338, 
                        0x03E8
                    }, 

                    Package (0x03)
                    {
                        0x0378, 
                        0x0278, 
                        0x03BC
                    }, 

                    Package (0x02)
                    {
                        0x03F0, 
                        0x0370
                    }
                })
                Name (DDLT, Package (0x04)
                {
                    Package (0x02)
                    {
                        Zero, 
                        0xFFF8
                    }, 

                    Package (0x02)
                    {
                        0x04, 
                        0xFF8F
                    }, 

                    Package (0x02)
                    {
                        0x08, 
                        0xFCFF
                    }, 

                    Package (0x02)
                    {
                        0x0C, 
                        0xEFFF
                    }
                })
                Method (RRIO, 4, NotSerialized)
                {
                    If (LAnd (LLessEqual (Arg0, 0x03), LGreaterEqual (Arg0, Zero)))
                    {
                        Store (Match (DerefOf (Index (DBPT, Arg0)), MEQ, Arg2, MTR, 
                            Zero, Zero), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            Store (DerefOf (Index (DerefOf (Index (DDLT, Arg0)), Zero)), 
                                Local1)
                            Store (DerefOf (Index (DerefOf (Index (DDLT, Arg0)), One)), 
                                Local2)
                            ShiftLeft (Local0, Local1, Local0)
                            And (LPCD, Local2, LPCD)
                            Or (LPCD, Local0, LPCD)
                            WX82 (Arg0, Arg1)
                        }
                    }

                    If (LEqual (Arg0, 0x08))
                    {
                        If (LEqual (Arg2, 0x0200))
                        {
                            WX82 (0x08, Arg0)
                        }
                        Else
                        {
                            If (LEqual (Arg2, 0x0208))
                            {
                                WX82 (0x09, Arg0)
                            }
                        }
                    }

                    If (LAnd (LLessEqual (Arg0, 0x0D), LGreaterEqual (Arg0, 0x0A)))
                    {
                        WX82 (Arg0, Arg1)
                    }
                }

                Method (WX82, 2, NotSerialized)
                {
                    ShiftLeft (One, Arg0, Local0)
                    If (Arg1)
                    {
                        Or (LPCE, Local0, LPCE)
                    }
                    Else
                    {
                        Not (Local0, Local0)
                        And (LPCE, Local0, LPCE)
                    }
                }

                Method (RDMA, 3, NotSerialized)
                {
                }

                Device (FWH)
                {
                    Name (_HID, EisaId ("INT0800"))
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            )
                    })
                    CreateDWordField (CRS, 0x04, BS00)
                    CreateDWordField (CRS, 0x08, BL00)
                    CreateDWordField (CRS, 0x10, BS10)
                    CreateDWordField (CRS, 0x14, BL10)
                    Method (_CRS, 0, NotSerialized)
                    {
                        Store (0xFF800000, Local0)
                        FindSetRightBit (FHD0, Local1)
                        Decrement (Local1)
                        If (Local1)
                        {
                            Multiply (Local1, 0x00080000, Local1)
                        }

                        Add (Local0, Local1, Local2)
                        Store (Local2, BS00)
                        Add (BS00, 0x00400000, BS10)
                        Subtract (Zero, BS10, BL00)
                        Store (BL00, BL10)
                        Return (CRS)
                    }
                }

                Device (FWHE)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x03)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, 0x04, BS00)
                        CreateDWordField (CRS, 0x08, BL00)
                        If (LEqual (^^FWH.BS00, Zero))
                        {
                            ^^FWH._CRS ()
                        }

                        Add (^^FWH.BS00, ^^FWH.BL00, BS00)
                        Subtract (^^FWH.BS10, BS00, BL00)
                        Return (CRS)
                    }
                }

                OperationRegion (FHR0, PCI_Config, 0xD8, 0x02)
                Field (FHR0, ByteAcc, NoLock, Preserve)
                {
                    FHD1,   4, 
                            Offset (0x01), 
                    FHD0,   8
                }

                Device (^PCIE)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x11)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0xE0000000,         // Address Base
                            0x10000000,         // Address Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, 0x04, BAS1)
                        CreateDWordField (CRS, 0x08, LEN1)
                        Store (PCIB, BAS1)
                        Store (PCIL, LEN1)
                        Return (CRS)
                    }
                }

                Device (OMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, Zero)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            )
                    })
                    Name (CRS1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (APIC)
                        {
                            CreateDWordField (CRS, 0x08, ML01)
                            CreateDWordField (CRS, 0x04, MB01)
                            CreateDWordField (CRS, 0x14, ML02)
                            CreateDWordField (CRS, 0x10, MB02)
                            Store (0xFEC00000, MB01)
                            Store (0x1000, ML01)
                            Store (0xFEE00000, MB02)
                            Store (0x1000, ML02)
                            CreateDWordField (CRS1, 0x18, ML03)
                            CreateDWordField (CRS1, 0x14, MB03)
                            CreateDWordField (CRS1, 0x24, ML04)
                            CreateDWordField (CRS1, 0x20, MB04)
                            Store (0xFEC00000, MB03)
                            Store (0x1000, ML03)
                            Store (0xFEE00000, MB04)
                            Store (0x1000, ML04)
                        }

                        ShiftLeft (0x05, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (CRS)
                        }
                        Else
                        {
                            Return (CRS1)
                        }
                    }
                }

                Device (^^RMEM)
                {
                    Name (_HID, EisaId ("PNP0C01"))
                    Name (_UID, One)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x000A0000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x000E0000,         // Address Base
                            0x00020000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0x00100000,         // Address Base
                            0x00000000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            )
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, 0x10, BAS1)
                        CreateDWordField (CRS, 0x14, LEN1)
                        CreateDWordField (CRS, 0x1C, BAS2)
                        CreateDWordField (CRS, 0x20, LEN2)
                        CreateDWordField (CRS, 0x2C, LEN3)
                        CreateDWordField (CRS, 0x34, BAS4)
                        CreateDWordField (CRS, 0x38, LEN4)
                        If (OSFL ()) {}
                        Else
                        {
                            If (MG1B)
                            {
                                If (LGreater (MG1B, 0x000C0000))
                                {
                                    Store (0x000C0000, BAS1)
                                    Subtract (MG1B, BAS1, LEN1)
                                }
                            }
                            Else
                            {
                                Store (0x000C0000, BAS1)
                                Store (0x00020000, LEN1)
                            }

                            If (Add (MG1B, MG1L, Local0))
                            {
                                Store (Local0, BAS2)
                                Subtract (0x00100000, BAS2, LEN2)
                            }
                        }

                        Subtract (MG2B, 0x00100000, LEN3)
                        Store (MH1B, BAS4)
                        Subtract (Zero, BAS4, LEN4)
                        Return (CRS)
                    }
                }
            }

            Device (SATA)
            {
                Name (_ADR, 0x001F0002)
                Name (^NATA, Package (0x01)
                {
                    0x001F0002
                })
                Name (\FZTF, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF5
                })
                Name (REGF, One)
                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (Arg1, REGF)
                    }
                }

                Name (TIM0, Package (0x08)
                {
                    Package (0x04)
                    {
                        0x78, 
                        0xB4, 
                        0xF0, 
                        0x0384
                    }, 

                    Package (0x04)
                    {
                        0x23, 
                        0x21, 
                        0x10, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0B, 
                        0x09, 
                        0x04, 
                        Zero
                    }, 

                    Package (0x06)
                    {
                        0x78, 
                        0x5A, 
                        0x3C, 
                        0x28, 
                        0x1E, 
                        0x14
                    }, 

                    Package (0x06)
                    {
                        Zero, 
                        One, 
                        0x02, 
                        One, 
                        0x02, 
                        One
                    }, 

                    Package (0x06)
                    {
                        Zero, 
                        Zero, 
                        Zero, 
                        One, 
                        One, 
                        One
                    }, 

                    Package (0x04)
                    {
                        0x04, 
                        0x03, 
                        0x02, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x02, 
                        One, 
                        Zero, 
                        Zero
                    }
                })
                Name (TMD0, Buffer (0x14) {})
                CreateDWordField (TMD0, Zero, PIO0)
                CreateDWordField (TMD0, 0x04, DMA0)
                CreateDWordField (TMD0, 0x08, PIO1)
                CreateDWordField (TMD0, 0x0C, DMA1)
                CreateDWordField (TMD0, 0x10, CHNF)
                OperationRegion (CFG2, PCI_Config, 0x40, 0x20)
                Field (CFG2, DWordAcc, NoLock, Preserve)
                {
                    PMPT,   4, 
                    PSPT,   4, 
                    PMRI,   6, 
                            Offset (0x02), 
                    SMPT,   4, 
                    SSPT,   4, 
                    SMRI,   6, 
                            Offset (0x04), 
                    PSRI,   4, 
                    SSRI,   4, 
                            Offset (0x08), 
                    PM3E,   1, 
                    PS3E,   1, 
                    SM3E,   1, 
                    SS3E,   1, 
                            Offset (0x0A), 
                    PMUT,   2, 
                        ,   2, 
                    PSUT,   2, 
                            Offset (0x0B), 
                    SMUT,   2, 
                        ,   2, 
                    SSUT,   2, 
                            Offset (0x0C), 
                            Offset (0x14), 
                    PM6E,   1, 
                    PS6E,   1, 
                    SM6E,   1, 
                    SS6E,   1, 
                    PMCR,   1, 
                    PSCR,   1, 
                    SMCR,   1, 
                    SSCR,   1, 
                        ,   4, 
                    PMAE,   1, 
                    PSAE,   1, 
                    SMAE,   1, 
                    SSAE,   1
                }

                Name (GMPT, Zero)
                Name (GMUE, Zero)
                Name (GMUT, Zero)
                Name (GMCR, Zero)
                Name (GSPT, Zero)
                Name (GSUE, Zero)
                Name (GSUT, Zero)
                Name (GSCR, Zero)
                Device (CHN0)
                {
                    Name (_ADR, Zero)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (PSCR, One, Local1)
                        Or (PMCR, Local1, Local0)
                        ShiftLeft (PMAE, 0x02, Local3)
                        ShiftLeft (PM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PM3E, Local3, Local1)
                        ShiftLeft (PMPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        ShiftLeft (PSAE, 0x02, Local3)
                        ShiftLeft (PS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PS3E, Local3, Local2)
                        ShiftLeft (PSPT, 0x04, Local3)
                        Or (Local2, Local3, Local2)
                        Return (GTM (PMRI, Local1, PMUT, PSRI, Local2, PSUT, Local0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        ShiftLeft (PMAE, 0x02, Local3)
                        ShiftLeft (PM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PM3E, Local3, Local0)
                        ShiftLeft (PMPT, 0x04, Local3)
                        Or (Local0, Local3, Local0)
                        ShiftLeft (PSAE, 0x02, Local3)
                        ShiftLeft (PS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PS3E, Local3, Local1)
                        ShiftLeft (PSPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        Store (PMRI, GMPT)
                        Store (Local0, GMUE)
                        Store (PMUT, GMUT)
                        Store (PMCR, GMCR)
                        Store (PSRI, GSPT)
                        Store (Local1, GSUE)
                        Store (PSUT, GSUT)
                        Store (PSCR, GSCR)
                        STM ()
                        Store (GMPT, PMRI)
                        Store (GMUE, Local0)
                        Store (GMUT, PMUT)
                        Store (GMCR, PMCR)
                        Store (GSUE, Local1)
                        Store (GSUT, PSUT)
                        Store (GSCR, PSCR)
                        If (And (Local0, One))
                        {
                            Store (One, PM3E)
                        }
                        Else
                        {
                            Store (Zero, PM3E)
                        }

                        If (And (Local0, 0x02))
                        {
                            Store (One, PM6E)
                        }
                        Else
                        {
                            Store (Zero, PM6E)
                        }

                        If (And (Local0, 0x04))
                        {
                            Store (One, PMAE)
                        }
                        Else
                        {
                            Store (Zero, PMAE)
                        }

                        If (And (Local1, One))
                        {
                            Store (One, PS3E)
                        }
                        Else
                        {
                            Store (Zero, PS3E)
                        }

                        If (And (Local1, 0x02))
                        {
                            Store (One, PS6E)
                        }
                        Else
                        {
                            Store (Zero, PS6E)
                        }

                        If (And (Local1, 0x04))
                        {
                            Store (One, PSAE)
                        }
                        Else
                        {
                            Store (Zero, PSAE)
                        }

                        Store (GTF (Zero, Arg1), ATA0)
                        Store (GTF (One, Arg2), ATA1)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA0))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA1))
                        }
                    }
                }

                Device (CHN1)
                {
                    Name (_ADR, One)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (SSCR, One, Local1)
                        Or (SMCR, Local1, Local0)
                        ShiftLeft (SMAE, 0x02, Local3)
                        ShiftLeft (SM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SM3E, Local3, Local1)
                        ShiftLeft (SMPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        ShiftLeft (SSAE, 0x02, Local3)
                        ShiftLeft (SS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SS3E, Local3, Local2)
                        ShiftLeft (SSPT, 0x04, Local3)
                        Or (Local2, Local3, Local2)
                        Return (GTM (SMRI, Local1, SMUT, SSRI, Local2, SSUT, Local0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        ShiftLeft (SMAE, 0x02, Local3)
                        ShiftLeft (SM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SM3E, Local3, Local0)
                        ShiftLeft (SMPT, 0x04, Local3)
                        Or (Local0, Local3, Local0)
                        ShiftLeft (SSAE, 0x02, Local3)
                        ShiftLeft (SS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SS3E, Local3, Local1)
                        ShiftLeft (SSPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        Store (SMRI, GMPT)
                        Store (Local0, GMUE)
                        Store (SMUT, GMUT)
                        Store (SMCR, GMCR)
                        Store (SSRI, GSPT)
                        Store (Local1, GSUE)
                        Store (SSUT, GSUT)
                        Store (SSCR, GSCR)
                        STM ()
                        Store (GMPT, SMRI)
                        Store (GMUE, Local0)
                        Store (GMUT, SMUT)
                        Store (GMCR, SMCR)
                        Store (GSUE, Local1)
                        Store (GSUT, SSUT)
                        Store (GSCR, SSCR)
                        If (And (Local0, One))
                        {
                            Store (One, SM3E)
                        }
                        Else
                        {
                            Store (Zero, SM3E)
                        }

                        If (And (Local0, 0x02))
                        {
                            Store (One, SM6E)
                        }
                        Else
                        {
                            Store (Zero, SM6E)
                        }

                        If (And (Local0, 0x04))
                        {
                            Store (One, SMAE)
                        }
                        Else
                        {
                            Store (Zero, SMAE)
                        }

                        If (And (Local1, One))
                        {
                            Store (One, SS3E)
                        }
                        Else
                        {
                            Store (Zero, SS3E)
                        }

                        If (And (Local1, 0x02))
                        {
                            Store (One, SS6E)
                        }
                        Else
                        {
                            Store (Zero, SS6E)
                        }

                        If (And (Local1, 0x04))
                        {
                            Store (One, SSAE)
                        }
                        Else
                        {
                            Store (Zero, SSAE)
                        }

                        Store (GTF (Zero, Arg1), ATA2)
                        Store (GTF (One, Arg2), ATA3)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA2))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA3))
                        }
                    }
                }

                Method (GTM, 7, Serialized)
                {
                    Store (Ones, PIO0)
                    Store (Ones, PIO1)
                    Store (Ones, DMA0)
                    Store (Ones, DMA1)
                    Store (0x10, CHNF)
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }

                    If (And (Arg1, 0x20))
                    {
                        Or (CHNF, 0x02, CHNF)
                    }

                    Store (Match (DerefOf (Index (TIM0, One)), MEQ, Arg0, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA0)
                    Store (Local7, PIO0)
                    If (And (Arg4, 0x20))
                    {
                        Or (CHNF, 0x08, CHNF)
                    }

                    Store (Match (DerefOf (Index (TIM0, 0x02)), MEQ, Arg3, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA1)
                    Store (Local7, PIO1)
                    If (And (Arg1, 0x07))
                    {
                        Store (Arg2, Local5)
                        If (And (Arg1, 0x02))
                        {
                            Add (Local5, 0x02, Local5)
                        }

                        If (And (Arg1, 0x04))
                        {
                            Add (Local5, 0x04, Local5)
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA0)
                        Or (CHNF, One, CHNF)
                    }

                    If (And (Arg4, 0x07))
                    {
                        Store (Arg5, Local5)
                        If (And (Arg4, 0x02))
                        {
                            Add (Local5, 0x02, Local5)
                        }

                        If (And (Arg4, 0x04))
                        {
                            Add (Local5, 0x04, Local5)
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA1)
                        Or (CHNF, 0x04, CHNF)
                    }

                    Store (TMD0, Debug)
                    Return (TMD0)
                }

                Method (STM, 0, Serialized)
                {
                    If (REGF)
                    {
                        Store (Zero, GMUE)
                        Store (Zero, GMUT)
                        Store (Zero, GSUE)
                        Store (Zero, GSUT)
                        If (And (CHNF, One))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA0, MTR, 
                                Zero, Zero), Local0)
                            If (LGreater (Local0, 0x05))
                            {
                                Store (0x05, Local0)
                            }

                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), 
                                GMUT)
                            Or (GMUE, One, GMUE)
                            If (LGreater (Local0, 0x02))
                            {
                                Or (GMUE, 0x02, GMUE)
                            }

                            If (LGreater (Local0, 0x04))
                            {
                                And (GMUE, 0xFD, GMUE)
                                Or (GMUE, 0x04, GMUE)
                            }
                        }
                        Else
                        {
                            If (Or (LEqual (PIO0, Ones), LEqual (PIO0, Zero)))
                            {
                                If (And (LLess (DMA0, Ones), LGreater (DMA0, Zero)))
                                {
                                    Store (DMA0, PIO0)
                                    Or (GMUE, 0x80, GMUE)
                                }
                            }
                        }

                        If (And (CHNF, 0x04))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA1, MTR, 
                                Zero, Zero), Local0)
                            If (LGreater (Local0, 0x05))
                            {
                                Store (0x05, Local0)
                            }

                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), 
                                GSUT)
                            Or (GSUE, One, GSUE)
                            If (LGreater (Local0, 0x02))
                            {
                                Or (GSUE, 0x02, GSUE)
                            }

                            If (LGreater (Local0, 0x04))
                            {
                                And (GSUE, 0xFD, GSUE)
                                Or (GSUE, 0x04, GSUE)
                            }
                        }
                        Else
                        {
                            If (Or (LEqual (PIO1, Ones), LEqual (PIO1, Zero)))
                            {
                                If (And (LLess (DMA1, Ones), LGreater (DMA1, Zero)))
                                {
                                    Store (DMA1, PIO1)
                                    Or (GSUE, 0x80, GSUE)
                                }
                            }
                        }

                        If (And (CHNF, 0x02))
                        {
                            Or (GMUE, 0x20, GMUE)
                        }

                        If (And (CHNF, 0x08))
                        {
                            Or (GSUE, 0x20, GSUE)
                        }

                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO0, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, One)), Local0)), 
                            Local1)
                        Store (Local1, GMPT)
                        If (LLess (Local0, 0x03))
                        {
                            Or (GMUE, 0x50, GMUE)
                        }

                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO1, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Local0)), 
                            Local1)
                        Store (Local1, GSPT)
                        If (LLess (Local0, 0x03))
                        {
                            Or (GSUE, 0x50, GSUE)
                        }
                    }
                }

                Name (AT01, Buffer (0x07)
                {
                    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (AT02, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90
                })
                Name (AT03, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6
                })
                Name (AT04, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91
                })
                Name (ATA0, Buffer (0x1D) {})
                Name (ATA1, Buffer (0x1D) {})
                Name (ATA2, Buffer (0x1D) {})
                Name (ATA3, Buffer (0x1D) {})
                Name (ATAB, Buffer (0x1D) {})
                CreateByteField (ATAB, Zero, CMDC)
                Method (GTFB, 3, Serialized)
                {
                    Multiply (CMDC, 0x38, Local0)
                    Add (Local0, 0x08, Local1)
                    CreateField (ATAB, Local1, 0x38, CMDX)
                    Multiply (CMDC, 0x07, Local0)
                    CreateByteField (ATAB, Add (Local0, 0x02), A001)
                    CreateByteField (ATAB, Add (Local0, 0x06), A005)
                    Store (Arg0, CMDX)
                    Store (Arg1, A001)
                    Store (Arg2, A005)
                    Increment (CMDC)
                }

                Method (GTF, 2, Serialized)
                {
                    Store (Arg1, Debug)
                    Store (Zero, CMDC)
                    Name (ID49, 0x0C00)
                    Name (ID59, Zero)
                    Name (ID53, 0x04)
                    Name (ID63, 0x0F00)
                    Name (ID88, 0x0F00)
                    Name (IRDY, One)
                    Name (PIOT, Zero)
                    Name (DMAT, Zero)
                    If (LEqual (SizeOf (Arg1), 0x0200))
                    {
                        CreateWordField (Arg1, 0x62, IW49)
                        Store (IW49, ID49)
                        CreateWordField (Arg1, 0x6A, IW53)
                        Store (IW53, ID53)
                        CreateWordField (Arg1, 0x7E, IW63)
                        Store (IW63, ID63)
                        CreateWordField (Arg1, 0x76, IW59)
                        Store (IW59, ID59)
                        CreateWordField (Arg1, 0xB0, IW88)
                        Store (IW88, ID88)
                    }

                    Store (0xA0, Local7)
                    If (Arg0)
                    {
                        Store (0xB0, Local7)
                        And (CHNF, 0x08, IRDY)
                        If (And (CHNF, 0x10))
                        {
                            Store (PIO1, PIOT)
                        }
                        Else
                        {
                            Store (PIO0, PIOT)
                        }

                        If (And (CHNF, 0x04))
                        {
                            If (And (CHNF, 0x10))
                            {
                                Store (DMA1, DMAT)
                            }
                            Else
                            {
                                Store (DMA0, DMAT)
                            }
                        }
                    }
                    Else
                    {
                        And (CHNF, 0x02, IRDY)
                        Store (PIO0, PIOT)
                        If (And (CHNF, One))
                        {
                            Store (DMA0, DMAT)
                        }
                    }

                    If (LAnd (LAnd (And (ID53, 0x04), And (ID88, 0xFF00
                        )), DMAT))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMAT, MTR, 
                            Zero, Zero), Local1)
                        If (LGreater (Local1, 0x05))
                        {
                            Store (0x05, Local1)
                        }

                        GTFB (AT01, Or (0x40, Local1), Local7)
                    }
                    Else
                    {
                        If (LAnd (And (ID63, 0xFF00), PIOT))
                        {
                            And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                                Zero, Zero), 0x03, Local0)
                            Or (0x20, DerefOf (Index (DerefOf (Index (TIM0, 0x07)), Local0
                                )), Local1)
                            GTFB (AT01, Local1, Local7)
                        }
                    }

                    If (IRDY)
                    {
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Or (0x08, DerefOf (Index (DerefOf (Index (TIM0, 0x06)), Local0
                            )), Local1)
                        GTFB (AT01, Local1, Local7)
                    }
                    Else
                    {
                        If (And (ID49, 0x0400))
                        {
                            GTFB (AT01, One, Local7)
                        }
                    }

                    If (LAnd (And (ID59, 0x0100), And (ID59, 0xFF)))
                    {
                        GTFB (AT03, And (ID59, 0xFF), Local7)
                    }

                    Store (ATAB, Debug)
                    Return (ATAB)
                }

                Method (RATA, 1, NotSerialized)
                {
                    CreateByteField (Arg0, Zero, CMDN)
                    Multiply (CMDN, 0x38, Local0)
                    CreateField (Arg0, 0x08, Local0, RETB)
                    Store (RETB, Debug)
                    Return (Concatenate (RETB, FZTF))
                }
            }

            Device (SAT1)
            {
                Name (_ADR, 0x001F0005)
                Name (REGF, One)
                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (Arg1, REGF)
                    }
                }

                Name (TIM0, Package (0x08)
                {
                    Package (0x04)
                    {
                        0x78, 
                        0xB4, 
                        0xF0, 
                        0x0384
                    }, 

                    Package (0x04)
                    {
                        0x23, 
                        0x21, 
                        0x10, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0B, 
                        0x09, 
                        0x04, 
                        Zero
                    }, 

                    Package (0x06)
                    {
                        0x78, 
                        0x5A, 
                        0x3C, 
                        0x28, 
                        0x1E, 
                        0x14
                    }, 

                    Package (0x06)
                    {
                        Zero, 
                        One, 
                        0x02, 
                        One, 
                        0x02, 
                        One
                    }, 

                    Package (0x06)
                    {
                        Zero, 
                        Zero, 
                        Zero, 
                        One, 
                        One, 
                        One
                    }, 

                    Package (0x04)
                    {
                        0x04, 
                        0x03, 
                        0x02, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x02, 
                        One, 
                        Zero, 
                        Zero
                    }
                })
                Name (TMD0, Buffer (0x14) {})
                CreateDWordField (TMD0, Zero, PIO0)
                CreateDWordField (TMD0, 0x04, DMA0)
                CreateDWordField (TMD0, 0x08, PIO1)
                CreateDWordField (TMD0, 0x0C, DMA1)
                CreateDWordField (TMD0, 0x10, CHNF)
                OperationRegion (CFG2, PCI_Config, 0x40, 0x20)
                Field (CFG2, DWordAcc, NoLock, Preserve)
                {
                    PMPT,   4, 
                    PSPT,   4, 
                    PMRI,   6, 
                            Offset (0x02), 
                    SMPT,   4, 
                    SSPT,   4, 
                    SMRI,   6, 
                            Offset (0x04), 
                    PSRI,   4, 
                    SSRI,   4, 
                            Offset (0x08), 
                    PM3E,   1, 
                    PS3E,   1, 
                    SM3E,   1, 
                    SS3E,   1, 
                            Offset (0x0A), 
                    PMUT,   2, 
                        ,   2, 
                    PSUT,   2, 
                            Offset (0x0B), 
                    SMUT,   2, 
                        ,   2, 
                    SSUT,   2, 
                            Offset (0x0C), 
                            Offset (0x14), 
                    PM6E,   1, 
                    PS6E,   1, 
                    SM6E,   1, 
                    SS6E,   1, 
                    PMCR,   1, 
                    PSCR,   1, 
                    SMCR,   1, 
                    SSCR,   1, 
                        ,   4, 
                    PMAE,   1, 
                    PSAE,   1, 
                    SMAE,   1, 
                    SSAE,   1
                }

                Name (GMPT, Zero)
                Name (GMUE, Zero)
                Name (GMUT, Zero)
                Name (GMCR, Zero)
                Name (GSPT, Zero)
                Name (GSUE, Zero)
                Name (GSUT, Zero)
                Name (GSCR, Zero)
                Device (CHN0)
                {
                    Name (_ADR, Zero)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (PSCR, One, Local1)
                        Or (PMCR, Local1, Local0)
                        ShiftLeft (PMAE, 0x02, Local3)
                        ShiftLeft (PM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PM3E, Local3, Local1)
                        ShiftLeft (PMPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        ShiftLeft (PSAE, 0x02, Local3)
                        ShiftLeft (PS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PS3E, Local3, Local2)
                        ShiftLeft (PSPT, 0x04, Local3)
                        Or (Local2, Local3, Local2)
                        Return (GTM (PMRI, Local1, PMUT, PSRI, Local2, PSUT, Local0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        ShiftLeft (PMAE, 0x02, Local3)
                        ShiftLeft (PM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PM3E, Local3, Local0)
                        ShiftLeft (PMPT, 0x04, Local3)
                        Or (Local0, Local3, Local0)
                        ShiftLeft (PSAE, 0x02, Local3)
                        ShiftLeft (PS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PS3E, Local3, Local1)
                        ShiftLeft (PSPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        Store (PMRI, GMPT)
                        Store (Local0, GMUE)
                        Store (PMUT, GMUT)
                        Store (PMCR, GMCR)
                        Store (PSRI, GSPT)
                        Store (Local1, GSUE)
                        Store (PSUT, GSUT)
                        Store (PSCR, GSCR)
                        STM ()
                        Store (GMPT, PMRI)
                        Store (GMUE, Local0)
                        Store (GMUT, PMUT)
                        Store (GMCR, PMCR)
                        Store (GSUE, Local1)
                        Store (GSUT, PSUT)
                        Store (GSCR, PSCR)
                        If (And (Local0, One))
                        {
                            Store (One, PM3E)
                        }
                        Else
                        {
                            Store (Zero, PM3E)
                        }

                        If (And (Local0, 0x02))
                        {
                            Store (One, PM6E)
                        }
                        Else
                        {
                            Store (Zero, PM6E)
                        }

                        If (And (Local0, 0x04))
                        {
                            Store (One, PMAE)
                        }
                        Else
                        {
                            Store (Zero, PMAE)
                        }

                        If (And (Local1, One))
                        {
                            Store (One, PS3E)
                        }
                        Else
                        {
                            Store (Zero, PS3E)
                        }

                        If (And (Local1, 0x02))
                        {
                            Store (One, PS6E)
                        }
                        Else
                        {
                            Store (Zero, PS6E)
                        }

                        If (And (Local1, 0x04))
                        {
                            Store (One, PSAE)
                        }
                        Else
                        {
                            Store (Zero, PSAE)
                        }

                        Store (GTF (Zero, Arg1), ATA0)
                        Store (GTF (One, Arg2), ATA1)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA0))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA1))
                        }
                    }
                }

                Device (CHN1)
                {
                    Name (_ADR, One)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (SSCR, One, Local1)
                        Or (SMCR, Local1, Local0)
                        ShiftLeft (SMAE, 0x02, Local3)
                        ShiftLeft (SM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SM3E, Local3, Local1)
                        ShiftLeft (SMPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        ShiftLeft (SSAE, 0x02, Local3)
                        ShiftLeft (SS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SS3E, Local3, Local2)
                        ShiftLeft (SSPT, 0x04, Local3)
                        Or (Local2, Local3, Local2)
                        Return (GTM (SMRI, Local1, SMUT, SSRI, Local2, SSUT, Local0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        ShiftLeft (SMAE, 0x02, Local3)
                        ShiftLeft (SM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SM3E, Local3, Local0)
                        ShiftLeft (SMPT, 0x04, Local3)
                        Or (Local0, Local3, Local0)
                        ShiftLeft (SSAE, 0x02, Local3)
                        ShiftLeft (SS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SS3E, Local3, Local1)
                        ShiftLeft (SSPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        Store (SMRI, GMPT)
                        Store (Local0, GMUE)
                        Store (SMUT, GMUT)
                        Store (SMCR, GMCR)
                        Store (SSRI, GSPT)
                        Store (Local1, GSUE)
                        Store (SSUT, GSUT)
                        Store (SSCR, GSCR)
                        STM ()
                        Store (GMPT, SMRI)
                        Store (GMUE, Local0)
                        Store (GMUT, SMUT)
                        Store (GMCR, SMCR)
                        Store (GSUE, Local1)
                        Store (GSUT, SSUT)
                        Store (GSCR, SSCR)
                        If (And (Local0, One))
                        {
                            Store (One, SM3E)
                        }
                        Else
                        {
                            Store (Zero, SM3E)
                        }

                        If (And (Local0, 0x02))
                        {
                            Store (One, SM6E)
                        }
                        Else
                        {
                            Store (Zero, SM6E)
                        }

                        If (And (Local0, 0x04))
                        {
                            Store (One, SMAE)
                        }
                        Else
                        {
                            Store (Zero, SMAE)
                        }

                        If (And (Local1, One))
                        {
                            Store (One, SS3E)
                        }
                        Else
                        {
                            Store (Zero, SS3E)
                        }

                        If (And (Local1, 0x02))
                        {
                            Store (One, SS6E)
                        }
                        Else
                        {
                            Store (Zero, SS6E)
                        }

                        If (And (Local1, 0x04))
                        {
                            Store (One, SSAE)
                        }
                        Else
                        {
                            Store (Zero, SSAE)
                        }

                        Store (GTF (Zero, Arg1), ATA2)
                        Store (GTF (One, Arg2), ATA3)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA2))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA3))
                        }
                    }
                }

                Method (GTM, 7, Serialized)
                {
                    Store (Ones, PIO0)
                    Store (Ones, PIO1)
                    Store (Ones, DMA0)
                    Store (Ones, DMA1)
                    Store (0x10, CHNF)
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }

                    If (And (Arg1, 0x20))
                    {
                        Or (CHNF, 0x02, CHNF)
                    }

                    Store (Match (DerefOf (Index (TIM0, One)), MEQ, Arg0, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA0)
                    Store (Local7, PIO0)
                    If (And (Arg4, 0x20))
                    {
                        Or (CHNF, 0x08, CHNF)
                    }

                    Store (Match (DerefOf (Index (TIM0, 0x02)), MEQ, Arg3, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA1)
                    Store (Local7, PIO1)
                    If (And (Arg1, 0x07))
                    {
                        Store (Arg2, Local5)
                        If (And (Arg1, 0x02))
                        {
                            Add (Local5, 0x02, Local5)
                        }

                        If (And (Arg1, 0x04))
                        {
                            Add (Local5, 0x04, Local5)
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA0)
                        Or (CHNF, One, CHNF)
                    }

                    If (And (Arg4, 0x07))
                    {
                        Store (Arg5, Local5)
                        If (And (Arg4, 0x02))
                        {
                            Add (Local5, 0x02, Local5)
                        }

                        If (And (Arg4, 0x04))
                        {
                            Add (Local5, 0x04, Local5)
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA1)
                        Or (CHNF, 0x04, CHNF)
                    }

                    Store (TMD0, Debug)
                    Return (TMD0)
                }

                Method (STM, 0, Serialized)
                {
                    If (REGF)
                    {
                        Store (Zero, GMUE)
                        Store (Zero, GMUT)
                        Store (Zero, GSUE)
                        Store (Zero, GSUT)
                        If (And (CHNF, One))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA0, MTR, 
                                Zero, Zero), Local0)
                            If (LGreater (Local0, 0x05))
                            {
                                Store (0x05, Local0)
                            }

                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), 
                                GMUT)
                            Or (GMUE, One, GMUE)
                            If (LGreater (Local0, 0x02))
                            {
                                Or (GMUE, 0x02, GMUE)
                            }

                            If (LGreater (Local0, 0x04))
                            {
                                And (GMUE, 0xFD, GMUE)
                                Or (GMUE, 0x04, GMUE)
                            }
                        }
                        Else
                        {
                            If (Or (LEqual (PIO0, Ones), LEqual (PIO0, Zero)))
                            {
                                If (And (LLess (DMA0, Ones), LGreater (DMA0, Zero)))
                                {
                                    Store (DMA0, PIO0)
                                    Or (GMUE, 0x80, GMUE)
                                }
                            }
                        }

                        If (And (CHNF, 0x04))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA1, MTR, 
                                Zero, Zero), Local0)
                            If (LGreater (Local0, 0x05))
                            {
                                Store (0x05, Local0)
                            }

                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), 
                                GSUT)
                            Or (GSUE, One, GSUE)
                            If (LGreater (Local0, 0x02))
                            {
                                Or (GSUE, 0x02, GSUE)
                            }

                            If (LGreater (Local0, 0x04))
                            {
                                And (GSUE, 0xFD, GSUE)
                                Or (GSUE, 0x04, GSUE)
                            }
                        }
                        Else
                        {
                            If (Or (LEqual (PIO1, Ones), LEqual (PIO1, Zero)))
                            {
                                If (And (LLess (DMA1, Ones), LGreater (DMA1, Zero)))
                                {
                                    Store (DMA1, PIO1)
                                    Or (GSUE, 0x80, GSUE)
                                }
                            }
                        }

                        If (And (CHNF, 0x02))
                        {
                            Or (GMUE, 0x20, GMUE)
                        }

                        If (And (CHNF, 0x08))
                        {
                            Or (GSUE, 0x20, GSUE)
                        }

                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO0, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, One)), Local0)), 
                            Local1)
                        Store (Local1, GMPT)
                        If (LLess (Local0, 0x03))
                        {
                            Or (GMUE, 0x50, GMUE)
                        }

                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO1, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Local0)), 
                            Local1)
                        Store (Local1, GSPT)
                        If (LLess (Local0, 0x03))
                        {
                            Or (GSUE, 0x50, GSUE)
                        }
                    }
                }

                Name (AT01, Buffer (0x07)
                {
                    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (AT02, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90
                })
                Name (AT03, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6
                })
                Name (AT04, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91
                })
                Name (ATA0, Buffer (0x1D) {})
                Name (ATA1, Buffer (0x1D) {})
                Name (ATA2, Buffer (0x1D) {})
                Name (ATA3, Buffer (0x1D) {})
                Name (ATAB, Buffer (0x1D) {})
                CreateByteField (ATAB, Zero, CMDC)
                Method (GTFB, 3, Serialized)
                {
                    Multiply (CMDC, 0x38, Local0)
                    Add (Local0, 0x08, Local1)
                    CreateField (ATAB, Local1, 0x38, CMDX)
                    Multiply (CMDC, 0x07, Local0)
                    CreateByteField (ATAB, Add (Local0, 0x02), A001)
                    CreateByteField (ATAB, Add (Local0, 0x06), A005)
                    Store (Arg0, CMDX)
                    Store (Arg1, A001)
                    Store (Arg2, A005)
                    Increment (CMDC)
                }

                Method (GTF, 2, Serialized)
                {
                    Store (Arg1, Debug)
                    Store (Zero, CMDC)
                    Name (ID49, 0x0C00)
                    Name (ID59, Zero)
                    Name (ID53, 0x04)
                    Name (ID63, 0x0F00)
                    Name (ID88, 0x0F00)
                    Name (IRDY, One)
                    Name (PIOT, Zero)
                    Name (DMAT, Zero)
                    If (LEqual (SizeOf (Arg1), 0x0200))
                    {
                        CreateWordField (Arg1, 0x62, IW49)
                        Store (IW49, ID49)
                        CreateWordField (Arg1, 0x6A, IW53)
                        Store (IW53, ID53)
                        CreateWordField (Arg1, 0x7E, IW63)
                        Store (IW63, ID63)
                        CreateWordField (Arg1, 0x76, IW59)
                        Store (IW59, ID59)
                        CreateWordField (Arg1, 0xB0, IW88)
                        Store (IW88, ID88)
                    }

                    Store (0xA0, Local7)
                    If (Arg0)
                    {
                        Store (0xB0, Local7)
                        And (CHNF, 0x08, IRDY)
                        If (And (CHNF, 0x10))
                        {
                            Store (PIO1, PIOT)
                        }
                        Else
                        {
                            Store (PIO0, PIOT)
                        }

                        If (And (CHNF, 0x04))
                        {
                            If (And (CHNF, 0x10))
                            {
                                Store (DMA1, DMAT)
                            }
                            Else
                            {
                                Store (DMA0, DMAT)
                            }
                        }
                    }
                    Else
                    {
                        And (CHNF, 0x02, IRDY)
                        Store (PIO0, PIOT)
                        If (And (CHNF, One))
                        {
                            Store (DMA0, DMAT)
                        }
                    }

                    If (LAnd (LAnd (And (ID53, 0x04), And (ID88, 0xFF00
                        )), DMAT))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMAT, MTR, 
                            Zero, Zero), Local1)
                        If (LGreater (Local1, 0x05))
                        {
                            Store (0x05, Local1)
                        }

                        GTFB (AT01, Or (0x40, Local1), Local7)
                    }
                    Else
                    {
                        If (LAnd (And (ID63, 0xFF00), PIOT))
                        {
                            And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                                Zero, Zero), 0x03, Local0)
                            Or (0x20, DerefOf (Index (DerefOf (Index (TIM0, 0x07)), Local0
                                )), Local1)
                            GTFB (AT01, Local1, Local7)
                        }
                    }

                    If (IRDY)
                    {
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Or (0x08, DerefOf (Index (DerefOf (Index (TIM0, 0x06)), Local0
                            )), Local1)
                        GTFB (AT01, Local1, Local7)
                    }
                    Else
                    {
                        If (And (ID49, 0x0400))
                        {
                            GTFB (AT01, One, Local7)
                        }
                    }

                    If (LAnd (And (ID59, 0x0100), And (ID59, 0xFF)))
                    {
                        GTFB (AT03, And (ID59, 0xFF), Local7)
                    }

                    Store (ATAB, Debug)
                    Return (ATAB)
                }

                Method (RATA, 1, NotSerialized)
                {
                    CreateByteField (Arg0, Zero, CMDN)
                    Multiply (CMDN, 0x38, Local0)
                    CreateField (Arg0, 0x08, Local0, RETB)
                    Store (RETB, Debug)
                    Return (Concatenate (RETB, FZTF))
                }
            }

            Device (USB2)
            {
                Name (_ADR, 0x001D0002)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0C, 0x04))
                }
            }

            Device (USB4)
            {
                Name (_ADR, 0x001A0001)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x05, 0x04))
                }
            }

            Device (USB6)
            {
                Name (_ADR, 0x001A0002)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x20, 0x04))
                }
            }

            Device (GBE)
            {
                Name (_ADR, 0x00190000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0D, 0x04))
                }
            }

            Device (P0P4)
            {
                Name (_ADR, 0x001C0000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR04)
                    }

                    Return (PR04)
                }
            }

            Device (P0P5)
            {
                Name (_ADR, 0x001C0001)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR05)
                    }

                    Return (PR05)
                }
            }

            Device (P0P6)
            {
                Name (_ADR, 0x001C0002)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR06)
                    }

                    Return (PR06)
                }
            }

            Device (P0P7)
            {
                Name (_ADR, 0x001C0003)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR07)
                    }

                    Return (PR07)
                }
            }

            Device (P0P8)
            {
                Name (_ADR, 0x001C0004)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR08)
                    }

                    Return (PR08)
                }
            }

            Device (P0P9)
            {
                Name (_ADR, 0x001C0005)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR09)
                    }

                    Return (PR09)
                }
            }

            Device (USB0)
            {
                Name (_ADR, 0x001D0000)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Device (HUBM)
                {
                    Name (_ADR, Zero)
                    Device (PR01)
                    {
                        Name (_ADR, One)
                        Name (_UPC, Package (0x04)
                        {
                            0xFF, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Buffer (0x10)
                        {
                            /* 0000 */    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x30, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x03, 0x04))
                }
            }

            Device (USB1)
            {
                Name (_ADR, 0x001D0001)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Device (HUBM)
                {
                    Name (_ADR, Zero)
                    Device (PR01)
                    {
                        Name (_ADR, One)
                        Name (_UPC, Package (0x04)
                        {
                            Zero, 
                            0xFF, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Buffer (0x10)
                        {
                            /* 0000 */    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x30, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                    }

                    Device (PR02)
                    {
                        Name (_ADR, 0x02)
                        Name (_UPC, Package (0x04)
                        {
                            0xFF, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Buffer (0x10)
                        {
                            /* 0000 */    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x30, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x04, 0x04))
                }
            }

            Device (USB3)
            {
                Name (_ADR, 0x001A0000)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Device (HUBM)
                {
                    Name (_ADR, Zero)
                    Device (PR01)
                    {
                        Name (_ADR, One)
                        Name (_UPC, Package (0x04)
                        {
                            0xFF, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Buffer (0x10)
                        {
                            /* 0000 */    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x30, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                    }

                    Device (PR02)
                    {
                        Name (_ADR, 0x02)
                        Name (_UPC, Package (0x04)
                        {
                            0xFF, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Buffer (0x10)
                        {
                            /* 0000 */    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x31, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }

            Device (USB5)
            {
                Name (_ADR, 0x001D0003)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PSW, 1, NotSerialized)
                {
                    If (Arg0)
                    {
                        Store (0x03, USBW)
                    }
                    Else
                    {
                        Store (Zero, USBW)
                    }
                }

                Device (HUBM)
                {
                    Name (_ADR, Zero)
                    Device (PR01)
                    {
                        Name (_ADR, One)
                        Name (_UPC, Package (0x04)
                        {
                            0xFF, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Buffer (0x10)
                        {
                            /* 0000 */    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x30, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                    }

                    Device (PR02)
                    {
                        Name (_ADR, 0x02)
                        Name (_UPC, Package (0x04)
                        {
                            0xFF, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Buffer (0x10)
                        {
                            /* 0000 */    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x30, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x20, 0x04))
                }
            }

            Device (EUSB)
            {
                Name (_ADR, 0x001D0007)
                Device (HUBN)
                {
                    Name (_ADR, Zero)
                    Device (PR01)
                    {
                        Name (_ADR, One)
                        Name (_UPC, Package (0x04)
                        {
                            0xFF, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Buffer (0x10)
                        {
                            /* 0000 */    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x30, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                    }

                    Device (PR04)
                    {
                        Name (_ADR, 0x04)
                        Name (_UPC, Package (0x04)
                        {
                            0xFF, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Buffer (0x10)
                        {
                            /* 0000 */    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x30, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0D, 0x04))
                }
            }

            Device (USBE)
            {
                Name (_ADR, 0x001A0007)
                Device (HUBN)
                {
                    Name (_ADR, Zero)
                    Device (PR01)
                    {
                        Name (_ADR, One)
                        Name (_UPC, Package (0x04)
                        {
                            0xFF, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Buffer (0x10)
                        {
                            /* 0000 */    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x30, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                    }

                    Device (PR02)
                    {
                        Name (_ADR, 0x02)
                        Name (_UPC, Package (0x04)
                        {
                            0xFF, 
                            Zero, 
                            Zero, 
                            Zero
                        })
                        Name (_PLD, Buffer (0x10)
                        {
                            /* 0000 */    0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x30, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
                        })
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0D, 0x04))
                }
            }
        }

        Scope (\_GPE)
        {
            Method (_L09, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.P0P2, 0x02)
                Notify (\_SB.PCI0.P0P4, 0x02)
                Notify (\_SB.PCI0.P0P5, 0x02)
                Notify (\_SB.PCI0.P0P6, 0x02)
                Notify (\_SB.PCI0.P0P7, 0x02)
                Notify (\_SB.PCI0.P0P8, 0x02)
                Notify (\_SB.PCI0.P0P9, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0B, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.P0P1, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0C, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB2, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L05, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB4, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L20, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB6, 0x02)
                Notify (\_SB.PCI0.USB5, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0D, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.GBE, 0x02)
                Notify (\_SB.PCI0.EUSB, 0x02)
                Notify (\_SB.PCI0.USBE, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L03, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB0, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L04, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB1, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0E, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB3, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
        }

        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))
            Name (_UID, 0xAA)
            Name (_STA, 0x0B)
        }
    }

    OperationRegion (_SB.PCI0.SBRG.PIX0, PCI_Config, 0x60, 0x0C)
    Field (\_SB.PCI0.SBRG.PIX0, ByteAcc, NoLock, Preserve)
    {
        PIRA,   8, 
        PIRB,   8, 
        PIRC,   8, 
        PIRD,   8, 
                Offset (0x08), 
        PIRE,   8, 
        PIRF,   8, 
        PIRG,   8, 
        PIRH,   8
    }

    Scope (_SB)
    {
        Name (BUFA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {15}
        })
        CreateWordField (BUFA, One, IRA0)
        Device (LNKA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, One)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRA, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSA)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRA, 0x80, PIRA)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRA, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRA)
            }
        }

        Device (LNKB)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x02)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRB, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSB)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRB, 0x80, PIRB)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRB, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRB)
            }
        }

        Device (LNKC)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x03)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRC, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSC)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRC, 0x80, PIRC)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRC, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRC)
            }
        }

        Device (LNKD)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x04)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRD, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSD)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRD, 0x80, PIRD)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRD, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRD)
            }
        }

        Device (LNKE)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x05)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRE, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSE)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRE, 0x80, PIRE)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRE, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRE)
            }
        }

        Device (LNKF)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x06)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRF, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSF)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRF, 0x80, PIRF)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRF, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRF)
            }
        }

        Device (LNKG)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x07)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRG, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSG)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRG, 0x80, PIRG)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRG, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRG)
            }
        }

        Device (LNKH)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x08)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRH, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSH)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRH, 0x80, PIRH)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRH, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRH)
            }
        }
    }

    Scope (_SB)
    {
        Name (XCPD, Zero)
        Name (XNPT, One)
        Name (XCAP, 0x02)
        Name (XDCP, 0x04)
        Name (XDCT, 0x08)
        Name (XDST, 0x0A)
        Name (XLCP, 0x0C)
        Name (XLCT, 0x10)
        Name (XLST, 0x12)
        Name (XSCP, 0x14)
        Name (XSCT, 0x18)
        Name (XSST, 0x1A)
        Name (XRCT, 0x1C)
        Mutex (MUTE, 0x00)
        Method (RBPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, One)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (RWPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (RDPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (WBPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x0FFF)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, One)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (WWPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (WDPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (RWDP, 3, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            And (XCFG, Arg2, Local1)
            Or (Local1, Arg1, XCFG)
            Release (MUTE)
        }

        Method (RPME, 1, NotSerialized)
        {
            Add (Arg0, 0x84, Local0)
            Store (RDPE (Local0), Local1)
            If (LEqual (Local1, Ones))
            {
                Return (Zero)
            }
            Else
            {
                If (LAnd (Local1, 0x00010000))
                {
                    WDPE (Local0, And (Local1, 0x00010000))
                    Return (One)
                }

                Return (Zero)
            }
        }
    }

    Scope (_SB.PCI0)
    {
        Device (GFX0)
        {
            Name (_ADR, 0x00020000)
            OperationRegion (IGDM, SystemMemory, 0x7DC9E0E4, 0x2000)
            Field (IGDM, AnyAcc, NoLock, Preserve)
            {
                SIGN,   128, 
                SIZE,   32, 
                OVER,   32, 
                SVER,   256, 
                VVER,   128, 
                GVER,   128, 
                MBOX,   32, 
                DMOD,   32, 
                        Offset (0xE0), 
                KSV0,   32, 
                KSV1,   8, 
                        Offset (0xF0), 
                IBTT,   8, 
                IPSC,   2, 
                IPAT,   4, 
                        Offset (0xF2), 
                IBIA,   3, 
                IBLC,   2, 
                    ,   1, 
                ITVF,   4, 
                ITVM,   4, 
                        Offset (0xF4), 
                IDVM,   1, 
                IDVS,   2, 
                ISSC,   1, 
                PAVP,   4, 
                CSTE,   16, 
                NSTE,   16, 
                        Offset (0x100), 
                DRDY,   32, 
                CSTS,   32, 
                CEVT,   32, 
                        Offset (0x120), 
                DIDL,   32, 
                DDL2,   32, 
                DDL3,   32, 
                DDL4,   32, 
                DDL5,   32, 
                DDL6,   32, 
                DDL7,   32, 
                DDL8,   32, 
                CPDL,   32, 
                CPL2,   32, 
                CPL3,   32, 
                CPL4,   32, 
                CPL5,   32, 
                CPL6,   32, 
                CPL7,   32, 
                CPL8,   32, 
                CADL,   32, 
                CAL2,   32, 
                CAL3,   32, 
                CAL4,   32, 
                CAL5,   32, 
                CAL6,   32, 
                CAL7,   32, 
                CAL8,   32, 
                NADL,   32, 
                NDL2,   32, 
                NDL3,   32, 
                NDL4,   32, 
                NDL5,   32, 
                NDL6,   32, 
                NDL7,   32, 
                NDL8,   32, 
                ASLP,   32, 
                TIDX,   32, 
                CHPD,   32, 
                CLID,   32, 
                CDCK,   32, 
                SXSW,   32, 
                EVTS,   32, 
                CNOT,   32, 
                NRDY,   32, 
                        Offset (0x200), 
                SCIE,   1, 
                GEFC,   4, 
                GXFC,   3, 
                GESF,   8, 
                        Offset (0x204), 
                PARM,   32, 
                DSLP,   32, 
                        Offset (0x300), 
                ARDY,   32, 
                ASLC,   32, 
                TCHE,   32, 
                ALSI,   32, 
                BCLP,   32, 
                PFIT,   32, 
                CBLV,   32, 
                BCLM,   320, 
                CPFM,   32, 
                EPFM,   32, 
                PLUT,   592, 
                PFMB,   32, 
                DDCV,   32, 
                        Offset (0x400), 
                GVD1,   49152, 
                PHED,   32, 
                BDDC,   2048
            }

            OperationRegion (TCOI, SystemIO, TOBS, 0x08)
            Field (TCOI, WordAcc, NoLock, Preserve)
            {
                        Offset (0x04), 
                    ,   9, 
                SCIS,   1, 
                        Offset (0x06)
            }

            Name (DBTB, Package (0x15)
            {
                Zero, 
                0x07, 
                0x38, 
                0x01C0, 
                0x0E00, 
                0x3F, 
                0x01C7, 
                0x0E07, 
                0x01F8, 
                0x0E38, 
                0x0FC0, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                Zero, 
                0x7000, 
                0x7007, 
                0x7038, 
                0x71C0, 
                0x7E00
            })
            Method (GSCI, 0, Serialized)
            {
                If (LEqual (GEFC, 0x04))
                {
                    Store (GBDA (), GXFC)
                }

                If (LEqual (GEFC, 0x06))
                {
                    Store (SBCB (), GXFC)
                }

                Store (Zero, GEFC)
                Store (One, SCIS)
                Store (Zero, GSSE)
                Store (Zero, SCIE)
                Return (Zero)
            }

            Method (GBDA, 0, Serialized)
            {
                If (LEqual (GESF, Zero))
                {
                    If (LGreaterEqual (DVMT, 0x05))
                    {
                        Store (0x0679, PARM)
                    }
                    Else
                    {
                        Store (0x0279, PARM)
                    }

                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, One))
                {
                    Store (0x0240, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x04))
                {
                    And (PARM, 0xEFFF0000, PARM)
                    And (PARM, ShiftLeft (DerefOf (Index (DBTB, IBTT)), 0x10), 
                        PARM)
                    Or (IBTT, PARM, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x05))
                {
                    Store (IPSC, PARM)
                    Or (PARM, ShiftLeft (IPAT, 0x08), PARM)
                    Add (PARM, 0x0100, PARM)
                    Or (PARM, ShiftLeft (LIDS, 0x10), PARM)
                    Add (PARM, 0x00010000, PARM)
                    Or (PARM, ShiftLeft (IBIA, 0x14), PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x06))
                {
                    Store (ITVF, PARM)
                    Or (PARM, ShiftLeft (ITVM, 0x04), PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x07))
                {
                    If (LGreaterEqual (DVMT, 0x05))
                    {
                        Store (GIVD, PARM)
                        XOr (PARM, One, PARM)
                        Or (PARM, ShiftLeft (GMFN, One), PARM)
                        Or (PARM, 0x1800, PARM)
                        Or (PARM, ShiftLeft (IDVS, 0x11), PARM)
                        Or (ShiftLeft (CDCT, 0x15), PARM, PARM)
                    }
                    Else
                    {
                        Name (MEMS, 0x0D)
                        Store (GIVD, PARM)
                        XOr (PARM, One, PARM)
                        Or (PARM, ShiftLeft (GMFN, One), PARM)
                        Or (PARM, 0x1000, PARM)
                        Or (ShiftLeft (CDCT, 0x15), PARM, PARM)
                        If (LEqual (IDVM, One))
                        {
                            Store (0x11, MEMS)
                        }

                        If (LLess (TASM, M512))
                        {
                            Or (PARM, ShiftLeft (One, MEMS), PARM)
                        }
                        Else
                        {
                            If (LLess (TASM, M1GB))
                            {
                                If (LLess (IDVS, 0x03))
                                {
                                    Or (PARM, ShiftLeft (IDVS, MEMS), PARM)
                                }
                                Else
                                {
                                    Or (PARM, ShiftLeft (0x02, MEMS), PARM)
                                }
                            }
                            Else
                            {
                                Or (PARM, ShiftLeft (IDVS, MEMS), PARM)
                            }
                        }
                    }

                    Store (One, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x0A))
                {
                    Store (Zero, PARM)
                    If (ISSC)
                    {
                        Or (PARM, 0x03, PARM)
                    }

                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x0B))
                {
                    Store (KSV0, PARM)
                    Store (KSV1, GESF)
                    Return (SUCC)
                }

                Store (Zero, GESF)
                Return (CRIT)
            }

            Method (SBCB, 0, Serialized)
            {
                If (LEqual (GESF, Zero))
                {
                    Store (0x20, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, One))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x03))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x04))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x05))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x06))
                {
                    Store (And (PARM, 0x0F), ITVF)
                    Store (ShiftRight (And (PARM, 0xF0), 0x04), ITVM)
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x07))
                {
                    If (LEqual (PARM, Zero))
                    {
                        Store (CLID, Local0)
                        If (And (0x80000000, Local0))
                        {
                            And (CLID, 0x0F, CLID)
                            GLID (CLID)
                        }
                    }

                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x08))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x09))
                {
                    And (PARM, 0xFF, IBTT)
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x0A))
                {
                    And (PARM, 0xFF, IPSC)
                    If (And (ShiftRight (PARM, 0x08), 0xFF))
                    {
                        And (ShiftRight (PARM, 0x08), 0xFF, IPAT)
                        Decrement (IPAT)
                    }

                    And (ShiftRight (PARM, 0x14), 0x07, IBIA)
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x0B))
                {
                    If (LGreaterEqual (And (ShiftRight (PARM, 0x0B), 0x03), 
                        0x02))
                    {
                        And (ShiftRight (PARM, 0x0D), 0x0F, Local0)
                        And (ShiftRight (PARM, 0x11), 0x0F, Local1)
                        If (Local0)
                        {
                            Store (Zero, IDVM)
                            Store (Local0, IDVS)
                        }

                        If (Local1)
                        {
                            Store (One, IDVM)
                            Store (Local1, IDVS)
                        }
                    }

                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x10))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x11))
                {
                    Store (ShiftLeft (LIDS, 0x08), PARM)
                    Add (PARM, 0x0100, PARM)
                    Store (Zero, GESF)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x12))
                {
                    If (And (PARM, One))
                    {
                        If (LEqual (ShiftRight (PARM, One), One))
                        {
                            Store (One, ISSC)
                        }
                        Else
                        {
                            Store (Zero, GESF)
                            Return (CRIT)
                        }
                    }
                    Else
                    {
                        Store (Zero, ISSC)
                    }

                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LEqual (GESF, 0x13))
                {
                    Store (Zero, GESF)
                    Store (Zero, PARM)
                    Return (SUCC)
                }

                If (LGreaterEqual (DVMT, 0x05))
                {
                    If (LEqual (GESF, 0x14))
                    {
                        And (PARM, 0x0F, PAVP)
                        Store (Zero, GESF)
                        Store (Zero, PARM)
                        Return (SUCC)
                    }
                }

                Store (Zero, GESF)
                Return (SUCC)
            }

            Scope (^^PCI0)
            {
                OperationRegion (MCHP, PCI_Config, 0x40, 0xC0)
                Field (MCHP, AnyAcc, NoLock, Preserve)
                {
                            Offset (0x60), 
                    TASM,   10, 
                            Offset (0x62)
                }
            }

            OperationRegion (IGDP, PCI_Config, 0x40, 0xC0)
            Field (IGDP, AnyAcc, NoLock, Preserve)
            {
                        Offset (0x12), 
                    ,   1, 
                GIVD,   1, 
                    ,   2, 
                GUMA,   3, 
                        Offset (0x14), 
                    ,   4, 
                GMFN,   1, 
                        Offset (0x18), 
                        Offset (0x8C), 
                CDCT,   10, 
                        Offset (0x8E), 
                        Offset (0xA4), 
                ASLE,   8, 
                        Offset (0xA8), 
                GSSE,   1, 
                GSSB,   14, 
                GSES,   1, 
                        Offset (0xB0), 
                    ,   12, 
                CDVL,   1, 
                        Offset (0xB2), 
                        Offset (0xB5), 
                LBPC,   8, 
                        Offset (0xBC), 
                ASLS,   32
            }

            Name (M512, 0x04)
            Name (M1GB, 0x08)
            Method (PDRD, 0, NotSerialized)
            {
                If (LNot (DRDY))
                {
                    Sleep (ASLP)
                }

                Return (LNot (DRDY))
            }

            Method (PSTS, 0, NotSerialized)
            {
                If (LGreater (CSTS, 0x02))
                {
                    Sleep (ASLP)
                }

                Return (LEqual (CSTS, 0x03))
            }

            Method (OSYS, 0, NotSerialized)
            {
                Store (0x07D0, Local1)
                If (CondRefOf (_OSI, Local0))
                {
                    If (_OSI ("Linux"))
                    {
                        Store (One, Local1)
                    }

                    If (_OSI ("Windows 2001"))
                    {
                        Store (0x07D1, Local1)
                    }

                    If (_OSI ("Windows 2001 SP1"))
                    {
                        Store (0x07D1, Local1)
                    }

                    If (_OSI ("Windows 2001 SP2"))
                    {
                        Store (0x07D2, Local1)
                    }

                    If (_OSI ("Windows 2006"))
                    {
                        Store (0x07D6, Local1)
                    }
                }

                Return (Local1)
            }

            Method (GNOT, 2, NotSerialized)
            {
                If (PDRD ())
                {
                    Return (One)
                }

                Store (Arg0, CEVT)
                Store (0x03, CSTS)
                If (LAnd (LEqual (CHPD, Zero), LEqual (Arg1, Zero)))
                {
                    If (LOr (LGreater (OSYS (), 0x07D0), LLess (OSYS (), 0x07D6)))
                    {
                        Notify (PCI0, Arg1)
                    }
                    Else
                    {
                        Notify (GFX0, Arg1)
                    }
                }

                Notify (GFX0, 0x80)
                Return (Zero)
            }

            Method (GHDS, 1, NotSerialized)
            {
                Store (Arg0, TIDX)
                Return (GNOT (One, Zero))
            }

            Method (GLID, 1, NotSerialized)
            {
                Store (Arg0, CLID)
                Return (GNOT (0x02, Zero))
            }

            Method (GDCK, 1, NotSerialized)
            {
                Store (Arg0, CDCK)
                Return (GNOT (0x04, Zero))
            }

            Method (PARD, 0, NotSerialized)
            {
                If (LNot (ARDY))
                {
                    Sleep (ASLP)
                }

                Return (LNot (ARDY))
            }

            Method (AINT, 2, NotSerialized)
            {
                If (LNot (And (TCHE, ShiftLeft (One, Arg0))))
                {
                    Return (One)
                }

                If (PARD ())
                {
                    Return (One)
                }

                If (LEqual (Arg0, 0x02))
                {
                    If (CPFM)
                    {
                        And (CPFM, 0x0F, Local0)
                        And (EPFM, 0x0F, Local1)
                        If (LEqual (Local0, One))
                        {
                            If (And (Local1, 0x06))
                            {
                                Store (0x06, PFIT)
                            }
                            Else
                            {
                                If (And (Local1, 0x08))
                                {
                                    Store (0x08, PFIT)
                                }
                                Else
                                {
                                    Store (One, PFIT)
                                }
                            }
                        }

                        If (LEqual (Local0, 0x06))
                        {
                            If (And (Local1, 0x08))
                            {
                                Store (0x08, PFIT)
                            }
                            Else
                            {
                                If (And (Local1, One))
                                {
                                    Store (One, PFIT)
                                }
                                Else
                                {
                                    Store (0x06, PFIT)
                                }
                            }
                        }

                        If (LEqual (Local0, 0x08))
                        {
                            If (And (Local1, One))
                            {
                                Store (One, PFIT)
                            }
                            Else
                            {
                                If (And (Local1, 0x06))
                                {
                                    Store (0x06, PFIT)
                                }
                                Else
                                {
                                    Store (0x08, PFIT)
                                }
                            }
                        }
                    }
                    Else
                    {
                        XOr (PFIT, 0x07, PFIT)
                    }

                    Or (PFIT, 0x80000000, PFIT)
                    Store (0x04, ASLC)
                }
                Else
                {
                    If (LEqual (Arg0, One))
                    {
                        Store (Divide (Multiply (Arg1, 0xFF), 0x64, ), BCLP)
                        Or (BCLP, 0x80000000, BCLP)
                        Store (0x02, ASLC)
                    }
                    Else
                    {
                        If (LEqual (Arg0, Zero))
                        {
                            Store (Arg1, ALSI)
                            Store (One, ASLC)
                        }
                        Else
                        {
                            Return (One)
                        }
                    }
                }

                Store (Zero, LBPC)
                Return (Zero)
            }

            Method (SCIP, 0, NotSerialized)
            {
                If (Not (GIVD))
                {
                    If (LNotEqual (OVER, Zero))
                    {
                        Return (One)
                    }
                }

                Return (Zero)
            }

            Scope (\_GPE)
            {
                Method (_L06, 0, NotSerialized)
                {
                    \_SB.PCI0.GFX0.GSCI ()
                }
            }

            Name (OPBS, 0xFFFFFF00)
            Method (OPTS, 1, NotSerialized)
            {
                If (LEqual (Arg0, 0x03))
                {
                    Store (ASLS, OPBS)
                }
            }

            Method (OWAK, 1, NotSerialized)
            {
                If (LEqual (Arg0, 0x03))
                {
                    Store (OPBS, ASLS)
                    Store (One, GSES)
                }
            }
        }
    }

    Scope (_SB.PCI0.GFX0)
    {
        Name (DSEN, Zero)
        Name (NDID, Zero)
        Name (DID1, 0x80000100)
        Name (DID2, 0x80000400)
        Name (DID3, 0x80000300)
        Name (DID4, 0x04)
        Name (DID5, 0x05)
        Name (DID6, Zero)
        Name (DID7, Zero)
        Name (DID8, Zero)
        OperationRegion (IGDC, PCI_Config, 0x54, 0x04)
        Field (IGDC, ByteAcc, NoLock, Preserve)
        {
                ,   3, 
            IGEF,   1
        }

        OperationRegion (OPR0, SystemIO, 0x80, One)
        Field (OPR0, ByteAcc, NoLock, Preserve)
        {
            DP80,   8
        }

        OperationRegion (OPR1, SystemIO, 0xB2, One)
        Field (OPR1, ByteAcc, NoLock, Preserve)
        {
            DPB2,   8
        }

        OperationRegion (OPR2, SystemIO, 0xB3, One)
        Field (OPR2, ByteAcc, NoLock, Preserve)
        {
            DPB3,   8
        }

        Method (_DOS, 1, NotSerialized)
        {
            Store (And (Arg0, 0x07), DSEN)
        }

        Method (_DOD, 0, NotSerialized)
        {
            Store (Zero, NDID)
            If (LNotEqual (DIDL, Zero))
            {
                Store (SDDL (DID1), DID1)
            }

            If (LNotEqual (DDL2, Zero))
            {
                Store (SDDL (DID2), DID2)
            }

            If (CondRefOf (IDAB))
            {
                IDAB ()
            }
            Else
            {
                If (LNotEqual (DDL3, Zero))
                {
                    Store (SDDL (DID3), DID3)
                }

                If (LNotEqual (DDL4, Zero))
                {
                    Store (SDDL (DID4), DID4)
                }

                If (LNotEqual (DDL5, Zero))
                {
                    Store (SDDL (DID5), DID5)
                }
            }

            If (LEqual (NDID, One))
            {
                Name (TMP1, Package (0x01)
                {
                    Ones
                })
                Store (Or (0x00010000, DID1), Index (TMP1, Zero))
                Return (TMP1)
            }

            If (LEqual (NDID, 0x02))
            {
                Name (TMP2, Package (0x02)
                {
                    Ones, 
                    Ones
                })
                Store (Or (0x00010000, DID1), Index (TMP2, Zero))
                Store (Or (0x00010000, DID2), Index (TMP2, One))
                Return (TMP2)
            }

            If (LEqual (NDID, 0x03))
            {
                Name (TMP3, Package (0x03)
                {
                    Ones, 
                    Ones, 
                    Ones
                })
                Store (Or (0x00010000, DID1), Index (TMP3, Zero))
                Store (Or (0x00010000, DID2), Index (TMP3, One))
                Store (Or (0x00010000, DID3), Index (TMP3, 0x02))
                Return (TMP3)
            }

            If (LEqual (NDID, 0x04))
            {
                Name (TMP4, Package (0x04)
                {
                    Ones, 
                    Ones, 
                    Ones, 
                    Ones
                })
                Store (Or (0x00010000, DID1), Index (TMP4, Zero))
                Store (Or (0x00010000, DID2), Index (TMP4, One))
                Store (Or (0x00010000, DID3), Index (TMP4, 0x02))
                Store (Or (0x00010000, DID4), Index (TMP4, 0x03))
                Return (TMP4)
            }

            If (CondRefOf (NNAB))
            {
                NNAB ()
            }
            Else
            {
                If (LGreater (NDID, 0x04))
                {
                    Name (TMP5, Package (0x05)
                    {
                        Ones, 
                        Ones, 
                        Ones, 
                        Ones, 
                        Ones
                    })
                    Store (Or (0x00010000, DID1), Index (TMP5, Zero))
                    Store (Or (0x00010000, DID2), Index (TMP5, One))
                    Store (Or (0x00010000, DID3), Index (TMP5, 0x02))
                    Store (Or (0x00010000, DID4), Index (TMP5, 0x03))
                    Store (Or (0x00010000, DID4), Index (TMP5, 0x04))
                    Return (TMP5)
                }
            }

            Return (Package (0x01)
            {
                0x0400
            })
        }

        Device (DD01)
        {
            Method (_ADR, 0, Serialized)
            {
                If (LEqual (DID1, Zero))
                {
                    Return (One)
                }
                Else
                {
                    Return (And (0xFFFF, DID1))
                }
            }

            Method (_DCS, 0, NotSerialized)
            {
                Return (CDDS (DID1))
            }

            Method (_DGS, 0, NotSerialized)
            {
                Return (NDDS (DID1))
            }

            Method (_DSS, 1, NotSerialized)
            {
                If (LEqual (And (Arg0, 0xC0000000), 0xC0000000))
                {
                    Store (NSTE, CSTE)
                }
            }
        }

        Device (DD02)
        {
            Method (_ADR, 0, Serialized)
            {
                If (LEqual (DID2, Zero))
                {
                    Return (0x02)
                }
                Else
                {
                    Return (And (0xFFFF, DID2))
                }
            }

            Method (_DCS, 0, NotSerialized)
            {
                Return (CDDS (DID2))
            }

            Method (_DGS, 0, NotSerialized)
            {
                Return (NDDS (DID2))
            }

            Method (_DSS, 1, NotSerialized)
            {
                If (LEqual (And (Arg0, 0xC0000000), 0xC0000000))
                {
                    Store (NSTE, CSTE)
                }
            }
        }

        Device (DD03)
        {
            Method (_ADR, 0, Serialized)
            {
                If (LEqual (DID3, Zero))
                {
                    Return (0x03)
                }
                Else
                {
                    Return (And (0xFFFF, DID3))
                }
            }

            Method (_DCS, 0, NotSerialized)
            {
                If (LEqual (DID3, Zero))
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (CDDS (DID3))
                }
            }

            Method (_DGS, 0, NotSerialized)
            {
                Return (NDDS (DID3))
            }

            Method (_DSS, 1, NotSerialized)
            {
                If (LEqual (And (Arg0, 0xC0000000), 0xC0000000))
                {
                    Store (NSTE, CSTE)
                }
            }
        }

        Device (DD04)
        {
            Method (_ADR, 0, Serialized)
            {
                If (LEqual (DID4, Zero))
                {
                    Return (0x04)
                }
                Else
                {
                    Return (And (0xFFFF, DID4))
                }
            }

            Method (_DCS, 0, NotSerialized)
            {
                If (LEqual (DID4, Zero))
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (CDDS (DID4))
                }
            }

            Method (_DGS, 0, NotSerialized)
            {
                Return (NDDS (DID4))
            }

            Method (_DSS, 1, NotSerialized)
            {
                If (LEqual (And (Arg0, 0xC0000000), 0xC0000000))
                {
                    Store (NSTE, CSTE)
                }
            }
        }

        Device (DD05)
        {
            Method (_ADR, 0, Serialized)
            {
                If (LEqual (DID5, Zero))
                {
                    Return (0x05)
                }
                Else
                {
                    Return (And (0xFFFF, DID5))
                }
            }

            Method (_DCS, 0, NotSerialized)
            {
                If (LEqual (DID5, Zero))
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (CDDS (DID5))
                }
            }

            Method (_DGS, 0, NotSerialized)
            {
                Return (NDDS (DID5))
            }

            Method (_DSS, 1, NotSerialized)
            {
                If (LEqual (And (Arg0, 0xC0000000), 0xC0000000))
                {
                    Store (NSTE, CSTE)
                }
            }
        }

        Device (DD06)
        {
            Method (_ADR, 0, Serialized)
            {
                If (LEqual (DID6, Zero))
                {
                    Return (0x06)
                }
                Else
                {
                    Return (And (0xFFFF, DID6))
                }
            }

            Method (_DCS, 0, NotSerialized)
            {
                If (LEqual (DID6, Zero))
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (CDDS (DID6))
                }
            }

            Method (_DGS, 0, NotSerialized)
            {
                Return (NDDS (DID6))
            }

            Method (_DSS, 1, NotSerialized)
            {
                If (LEqual (And (Arg0, 0xC0000000), 0xC0000000))
                {
                    Store (NSTE, CSTE)
                }
            }
        }

        Device (DD07)
        {
            Method (_ADR, 0, Serialized)
            {
                If (LEqual (DID7, Zero))
                {
                    Return (0x07)
                }
                Else
                {
                    Return (And (0xFFFF, DID7))
                }
            }

            Method (_DCS, 0, NotSerialized)
            {
                If (LEqual (DID7, Zero))
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (CDDS (DID7))
                }
            }

            Method (_DGS, 0, NotSerialized)
            {
                Return (NDDS (DID7))
            }

            Method (_DSS, 1, NotSerialized)
            {
                If (LEqual (And (Arg0, 0xC0000000), 0xC0000000))
                {
                    Store (NSTE, CSTE)
                }
            }
        }

        Device (DD08)
        {
            Method (_ADR, 0, Serialized)
            {
                If (LEqual (DID8, Zero))
                {
                    Return (0x08)
                }
                Else
                {
                    Return (And (0xFFFF, DID8))
                }
            }

            Method (_DCS, 0, NotSerialized)
            {
                If (LEqual (DID8, Zero))
                {
                    Return (0x0B)
                }
                Else
                {
                    Return (CDDS (DID8))
                }
            }

            Method (_DGS, 0, NotSerialized)
            {
                Return (NDDS (DID8))
            }

            Method (_DSS, 1, NotSerialized)
            {
                If (LEqual (And (Arg0, 0xC0000000), 0xC0000000))
                {
                    Store (NSTE, CSTE)
                }
            }
        }

        Method (SDDL, 1, NotSerialized)
        {
            Increment (NDID)
            Store (And (Arg0, 0x0F0F), Local0)
            Or (0x80000000, Local0, Local1)
            If (LEqual (DIDL, Local0))
            {
                Return (Local1)
            }

            If (LEqual (DDL2, Local0))
            {
                Return (Local1)
            }

            If (LEqual (DDL3, Local0))
            {
                Return (Local1)
            }

            If (LEqual (DDL4, Local0))
            {
                Return (Local1)
            }

            If (LEqual (DDL5, Local0))
            {
                Return (Local1)
            }

            If (LEqual (DDL6, Local0))
            {
                Return (Local1)
            }

            If (LEqual (DDL7, Local0))
            {
                Return (Local1)
            }

            If (LEqual (DDL8, Local0))
            {
                Return (Local1)
            }

            Return (Zero)
        }

        Method (CDDS, 1, NotSerialized)
        {
            Store (And (Arg0, 0x0F0F), Local0)
            If (LEqual (Zero, Local0))
            {
                Return (0x1D)
            }

            If (LEqual (CADL, Local0))
            {
                Return (0x1F)
            }

            If (LEqual (CAL2, Local0))
            {
                Return (0x1F)
            }

            If (LEqual (CAL3, Local0))
            {
                Return (0x1F)
            }

            If (LEqual (CAL4, Local0))
            {
                Return (0x1F)
            }

            If (LEqual (CAL5, Local0))
            {
                Return (0x1F)
            }

            If (LEqual (CAL6, Local0))
            {
                Return (0x1F)
            }

            If (LEqual (CAL7, Local0))
            {
                Return (0x1F)
            }

            If (LEqual (CAL8, Local0))
            {
                Return (0x1F)
            }

            Return (0x1D)
        }

        Method (NDDS, 1, NotSerialized)
        {
            Store (And (Arg0, 0x0F0F), Local0)
            If (LEqual (Zero, Local0))
            {
                Return (Zero)
            }

            If (LEqual (NADL, Local0))
            {
                Return (One)
            }

            If (LEqual (NDL2, Local0))
            {
                Return (One)
            }

            If (LEqual (NDL3, Local0))
            {
                Return (One)
            }

            If (LEqual (NDL4, Local0))
            {
                Return (One)
            }

            If (LEqual (NDL5, Local0))
            {
                Return (One)
            }

            If (LEqual (NDL6, Local0))
            {
                Return (One)
            }

            If (LEqual (NDL7, Local0))
            {
                Return (One)
            }

            If (LEqual (NDL8, Local0))
            {
                Return (One)
            }

            Return (Zero)
        }

        Method (HKDS, 0, NotSerialized)
        {
            Store (And (DSEN, 0x03), Local0)
            If (LEqual (Local0, Zero))
            {
                GNOT (One, Zero)
            }
        }
    }

    Scope (\)
    {
        OperationRegion (IO2E, SystemIO, 0x2E, 0x02)
        Field (IO2E, ByteAcc, NoLock, Preserve)
        {
            EC2E,   8, 
            EC2F,   8
        }

        OperationRegion (IO68, SystemIO, 0x68, 0x05)
        Field (IO68, ByteAcc, NoLock, Preserve)
        {
            EC68,   8, 
                    Offset (0x04), 
            EC6C,   8
        }
    }

    Mutex (MUEC, 0x00)
    Name (ECON, Zero)
    Name (LIDF, One)
    Scope (_SB.PCI0.SBRG)
    {
        Device (EC0)
        {
            Name (_HID, EisaId ("PNP0C09"))
            Name (_UID, One)
            Name (_CRS, ResourceTemplate ()
            {
                IO (Decode16,
                    0x0062,             // Range Minimum
                    0x0062,             // Range Maximum
                    0x00,               // Alignment
                    0x01,               // Length
                    )
                IO (Decode16,
                    0x0066,             // Range Minimum
                    0x0066,             // Range Maximum
                    0x00,               // Alignment
                    0x01,               // Length
                    )
            })
            Scope (\_SB.PCI0.SBRG.EC0)
            {
                Name (_GPE, 0x1C)
            }

            Method (_Q14, 0, NotSerialized)
            {
                Store (0x14, DBG8)
                Sleep (0x19)
                Store (0x14, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (GGGE, 0, NotSerialized)
            {
                If (ECON)
                {
                    If (LEqual (Acquire (MUEC, 0xA000), Zero))
                    {
                        If (ITEC)
                        {
                            Store (ST3G, Local0)
                        }

                        Release (MUEC)
                    }
                }

                Return (Local0)
            }

            Method (_Q20, 0, NotSerialized)
            {
                Store (0x20, DBG8)
                Notify (ADP1, 0x80)
                Sleep (0x0A)
                Notify (BAT1, Zero)
                Notify (BAT1, 0x80)
                Notify (\_PR.CPU1, 0x80)
                Notify (\_PR.CPU1, 0x81)
                Store (0x20, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (_Q21, 0, NotSerialized)
            {
                Store (0x21, DBG8)
                Sleep (0x19)
                Store (LSTE, LIDF)
                Notify (LID, 0x80)
                Store (0x21, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (_Q22, 0, NotSerialized)
            {
                Store (0x22, DBG8)
                Sleep (0xFA)
                Notify (BAT1, Zero)
                Notify (BAT1, 0x80)
                Store (0x22, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (_Q25, 0, NotSerialized)
            {
                Store (0x25, DBG8)
                Sleep (0x19)
                ^^^GFX0.HKDS ()
                Store (0x25, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (_Q28, 0, NotSerialized)
            {
                Store (0x28, DBG8)
                Sleep (0x19)
                Store (0x28, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (_Q29, 0, NotSerialized)
            {
                Store (0x29, DBG8)
                Sleep (0x19)
                Store (0x29, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (PWMG, 0, NotSerialized)
            {
                If (ECON)
                {
                    If (LEqual (Acquire (MUEC, 0xA000), Zero))
                    {
                        If (ITEC)
                        {
                            Store (BRIV, Local0)
                        }

                        Release (MUEC)
                    }
                }

                Return (Local0)
            }

            Method (_Q2A, 0, NotSerialized)
            {
                Store (0x2A, DBG8)
                Sleep (0x19)
                Store (0x2A, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (_Q2F, 0, NotSerialized)
            {
                Store (0x2F, DBG8)
                Sleep (0x19)
                Notify (SLPB, 0x80)
                Store (0x2F, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (_Q30, 0, NotSerialized)
            {
                Store (0x30, DBG8)
                Sleep (0x19)
                Store (0x30, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (_Q31, 0, NotSerialized)
            {
                Store (0x31, DBG8)
                Sleep (0x19)
                Store (0x31, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (_Q34, 0, NotSerialized)
            {
                Store (0x34, DBG8)
                Sleep (0x19)
                Store (0x34, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (TCPD, 0, NotSerialized)
            {
                If (ECON)
                {
                    If (LEqual (Acquire (MUEC, 0xA000), Zero))
                    {
                        If (ITEC)
                        {
                            Store (STTP, Local0)
                        }

                        Release (MUEC)
                    }
                }

                Return (Local0)
            }

            Method (_Q35, 0, NotSerialized)
            {
                Store (0x35, DBG8)
                Sleep (0x19)
                Store (0x35, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (WLLC, 0, NotSerialized)
            {
                If (ECON)
                {
                    If (LEqual (Acquire (MUEC, 0xA000), Zero))
                    {
                        If (ITEC)
                        {
                            Store (SWLN, Local0)
                        }

                        Release (MUEC)
                    }
                }

                Return (Local0)
            }

            Method (_Q36, 0, NotSerialized)
            {
                Store (0x36, DBG8)
                Sleep (0x19)
                Store (0x36, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (WCAM, 0, NotSerialized)
            {
                If (ECON)
                {
                    If (LEqual (Acquire (MUEC, 0xA000), Zero))
                    {
                        If (ITEC)
                        {
                            Store (WECS, Local0)
                        }

                        Release (MUEC)
                    }
                }

                Return (Local0)
            }

            Method (_Q37, 0, NotSerialized)
            {
                Store (0x37, DBG8)
                Sleep (0x19)
                Store (0x37, ^^FXWD.QNUM)
                Notify (FXWD, 0xF0)
            }

            Method (EBTS, 0, NotSerialized)
            {
                If (ECON)
                {
                    If (LEqual (Acquire (MUEC, 0xA000), Zero))
                    {
                        If (ITEC)
                        {
                            Store (BLTS, Local0)
                        }

                        Release (MUEC)
                    }
                }

                Return (Local0)
            }

            Method (_REG, 2, NotSerialized)
            {
                If (LAnd (LEqual (Arg0, 0x03), LEqual (Arg1, One)))
                {
                    Store (Arg1, ECON)
                    If (LEqual (OSFL (), One))
                    {
                        Store (One, ECOS)
                    }

                    If (LEqual (OSFL (), Zero))
                    {
                        Store (0x02, ECOS)
                    }

                    If (LEqual (OSFL (), 0x02))
                    {
                        Store (0x03, ECOS)
                    }

                    If (LEqual (OSFL (), 0x04))
                    {
                        Store (0x04, ECOS)
                    }
                }
            }

            Method (ECAV, 0, NotSerialized)
            {
                Return (ECON)
            }

            Name (TPS, One)
            Name (ATT, 0x3C)
            Name (PTT, 0x3C)
            OperationRegion (EC, EmbeddedControl, Zero, 0xFF)
            Field (EC, ByteAcc, NoLock, Preserve)
            {
                SMPR,   8, 
                SMST,   8, 
                SMAD,   8, 
                SMCM,   8, 
                SMD0,   264, 
                SMAA,   8, 
                SAD0,   8, 
                SAD1,   8, 
                SBD0,   8, 
                SBD1,   8, 
                        Offset (0x2E), 
                BLTS,   1, 
                WECS,   1, 
                    ,   1, 
                    ,   1, 
                STTP,   1, 
                ST3G,   1, 
                    ,   1, 
                SWLN,   1, 
                    ,   1, 
                    ,   1, 
                    ,   1, 
                    ,   1, 
                TPST,   1, 
                TGST,   1, 
                    ,   1, 
                WLPS,   1, 
                LSTE,   1, 
                ENS1,   1, 
                KBCS,   1, 
                PWON,   1, 
                ENS3,   1, 
                ENS4,   1, 
                ENS5,   1, 
                SCAO,   1, 
                ECTF,   1, 
                ECFF,   1, 
                ESTF,   1, 
                ESFF,   1, 
                CTET,   1, 
                CTEC,   1, 
                STEC,   1, 
                        Offset (0x32), 
                PBPO,   1, 
                CFON,   1, 
                SES3,   1, 
                SBON,   1, 
                SCON,   1, 
                    ,   1, 
                ABSD,   1, 
                S3PO,   1, 
                SYCT,   8, 
                SBTS,   1, 
                SBCS,   1, 
                SBDS,   1, 
                SBFS,   1, 
                SBWS,   1, 
                SBLS,   1, 
                SBCL,   1, 
                SBFL,   1, 
                BALA,   8, 
                TMP1,   8, 
                TMP2,   8, 
                BRIV,   8, 
                MDCH,   8, 
                MDVL,   8, 
                MDVH,   8, 
                MBTY,   8, 
                SBPC,   1, 
                SBBL,   1, 
                    ,   1, 
                SBOD,   1, 
                        Offset (0x3E), 
                RTMP,   8, 
                LTMP,   8, 
                POWS,   1, 
                        Offset (0x41), 
                    ,   3, 
                    ,   4, 
                SYTT,   8, 
                STOF,   8, 
                LDCT,   1, 
                RDCT,   1, 
                RDDS,   1, 
                RDLT,   1, 
                RDHT,   1, 
                LLTA,   1, 
                LHTA,   1, 
                ADCB,   1, 
                    ,   8, 
                BRII,   8, 
                ADSV,   8, 
                MOBL,   8, 
                SMIS,   1, 
                SMPS,   1, 
                ACMS,   1, 
                EADC,   1, 
                    ,   4, 
                SLS1,   8, 
                SLS2,   8, 
                SS4C,   1, 
                STRT,   1, 
                STFL,   1, 
                STRB,   1, 
                    ,   4, 
                FPWM,   8, 
                RTAL,   1, 
                RCAL,   1, 
                    ,   1, 
                TDAL,   1, 
                OTAL,   1, 
                    ,   1, 
                TCAL,   1, 
                OCAL,   1, 
                SME0,   1, 
                SME1,   1, 
                SME2,   1, 
                SME3,   1, 
                FLDC,   1, 
                    ,   1, 
                DSCH,   1, 
                INIT,   1, 
                        Offset (0x50), 
                SDCL,   8, 
                SDCH,   8, 
                SDVL,   8, 
                SDVH,   8, 
                MBSL,   8, 
                MBSH,   8, 
                SBSL,   8, 
                SBSH,   8, 
                SBTY,   8, 
                SCCL,   8, 
                SCCH,   8, 
                SPOL,   8, 
                SFCL,   8, 
                SFCH,   8, 
                SCUL,   8, 
                SCUH,   8, 
                MFCL,   8, 
                MFCH,   8, 
                        Offset (0x64), 
                BATS,   2, 
                        Offset (0x65), 
                CPFL,   8, 
                CPFH,   8, 
                CPUT,   8, 
                CPCT,   8, 
                CPTT,   8, 
                CTOF,   8, 
                SYFL,   8, 
                SYFH,   8, 
                        Offset (0x70), 
                SYST,   8, 
                MBTS,   1, 
                    ,   1, 
                MBFS,   1, 
                MBWS,   1, 
                MBLS,   1, 
                MBCL,   1, 
                MBDS,   1, 
                MBFL,   1, 
                MBCS,   1, 
                        Offset (0x73), 
                        Offset (0x74), 
                        Offset (0x75), 
                    ,   5, 
                FLCH,   1, 
                        Offset (0x76), 
                        Offset (0x77), 
                        Offset (0x78), 
                MVOL,   8, 
                MVOH,   8, 
                MCCL,   8, 
                MCCH,   8, 
                MTEH,   16, 
                MRCL,   8, 
                MRCH,   8, 
                SWQN,   8, 
                TEMP,   8, 
                        Offset (0xA4), 
                    ,   1, 
                G3EX,   1, 
                        Offset (0xAA), 
                ECOS,   4, 
                        Offset (0xF8), 
                ECVH,   8, 
                ECVL,   8
            }

            Method (EPTS, 1, NotSerialized)
            {
            }

            Method (EWAK, 1, NotSerialized)
            {
                Store (LSTE, LIDF)
                Return (LIDF)
            }

            Device (LID)
            {
                Name (_HID, EisaId ("PNP0C0D"))
                Method (_LID, 0, NotSerialized)
                {
                    Store (LSTE, LIDF)
                    Return (LIDF)
                    If (ECON)
                    {
                        Return (Zero)
                    }
                    Else
                    {
                        Return (One)
                    }
                }
            }

            Device (ADP1)
            {
                Name (_HID, "ACPI0003")
                Method (_PSR, 0, NotSerialized)
                {
                    If (ECON)
                    {
                        Acquire (MUEC, 0x1770)
                        If (SCAO)
                        {
                            Return (Zero)
                        }
                        Else
                        {
                            Return (One)
                        }

                        Release (MUEC)
                    }
                }

                Method (_PCL, 0, NotSerialized)
                {
                    Return (_SB)
                }
            }

            Device (BAT1)
            {
                Name (_HID, EisaId ("PNP0C0A"))
                Name (_UID, Zero)
                Method (_PCL, 0, NotSerialized)
                {
                    Return (_SB)
                }

                Method (_STA, 0, NotSerialized)
                {
                    Store (0x0F, Local0)
                    If (ECON)
                    {
                        If (MBTS)
                        {
                            Store (0x1F, Local0)
                        }
                    }

                    Return (Local0)
                }

                Name (BIF1, Package (0x0D)
                {
                    One, 
                    0x1450, 
                    0x1450, 
                    One, 
                    0x2B5C, 
                    0x0208, 
                    0x0104, 
                    0x34, 
                    0x34, 
                    "903SAM", 
                    "00001", 
                    "LION", 
                    "SMP"
                })
                Name (BIF2, Package (0x0D)
                {
                    One, 
                    0x0A28, 
                    0x0A28, 
                    One, 
                    0x2B5C, 
                    0x0104, 
                    0x82, 
                    0x1A, 
                    0x1A, 
                    "903SAM", 
                    "00001", 
                    "LION", 
                    "SMP"
                })
                Name (BIF3, Package (0x0D)
                {
                    One, 
                    0x0898, 
                    0x0898, 
                    One, 
                    0x2B5C, 
                    0xDC, 
                    0x6E, 
                    0x16, 
                    0x16, 
                    "903SAM", 
                    "00001", 
                    "LION", 
                    "SMP"
                })
                Method (_BIF, 0, NotSerialized)
                {
                    Store (BATS, Local0)
                    And (Local0, 0x03, Local0)
                    If (LEqual (Local0, Zero))
                    {
                        Store (0x90, DBG8)
                        If (ECON)
                        {
                            If (MBTS)
                            {
                                Store (MFCH, Local0)
                                Store (MFCL, Local1)
                                Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                Store (Local0, Index (BIF1, 0x02))
                                Multiply (Local0, 0x0A, Local1)
                                Divide (Local1, 0x64, Local2, Local3)
                                Store (Local3, Index (BIF1, 0x05))
                                Multiply (Local0, 0x05, Local1)
                                Divide (Local1, 0x64, Local2, Local3)
                                Store (Local3, Index (BIF1, 0x06))
                            }
                        }

                        Return (BIF1)
                    }

                    If (LEqual (Local0, One))
                    {
                        Store (0x91, DBG8)
                        If (ECON)
                        {
                            If (MBTS)
                            {
                                Store (MFCH, Local0)
                                Store (MFCL, Local1)
                                Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                Store (Local0, Index (BIF2, 0x02))
                                Multiply (Local0, 0x0A, Local1)
                                Divide (Local1, 0x64, Local2, Local3)
                                Store (Local3, Index (BIF2, 0x05))
                                Multiply (Local0, 0x05, Local1)
                                Divide (Local1, 0x64, Local2, Local3)
                                Store (Local3, Index (BIF2, 0x06))
                            }
                        }

                        Return (BIF2)
                    }

                    If (LEqual (Local0, 0x02))
                    {
                        Store (0x92, DBG8)
                        If (ECON)
                        {
                            If (MBTS)
                            {
                                Store (MFCH, Local0)
                                Store (MFCL, Local1)
                                Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                Store (Local0, Index (BIF3, 0x02))
                                Multiply (Local0, 0x0A, Local1)
                                Divide (Local1, 0x64, Local2, Local3)
                                Store (Local3, Index (BIF3, 0x05))
                                Multiply (Local0, 0x05, Local1)
                                Divide (Local1, 0x64, Local2, Local3)
                                Store (Local3, Index (BIF3, 0x06))
                            }
                        }

                        Return (BIF3)
                    }
                }

                Name (BST1, Package (0x04)
                {
                    Zero, 
                    0x04B0, 
                    0x08E3, 
                    0x30D6
                })
                Method (_BST, 0, NotSerialized)
                {
                    If (ECON)
                    {
                        If (MBTS)
                        {
                            If (SCAO)
                            {
                                Store (One, Local1)
                            }
                            Else
                            {
                                If (FLCH)
                                {
                                    Store (Zero, Local1)
                                }
                                Else
                                {
                                    Store (0x02, Local1)
                                }
                            }

                            Store (Local1, Index (BST1, Zero))
                            If (MBCS)
                            {
                                Store (MCCH, Local0)
                                Store (MCCL, Local1)
                                Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                            }
                            Else
                            {
                                If (SCAO)
                                {
                                    Store (MCCH, Local0)
                                    Store (MCCL, Local1)
                                    Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                    Subtract (0x00010000, Local0, Local0)
                                }
                                Else
                                {
                                    Store (MCCH, Local0)
                                    Store (MCCL, Local1)
                                    Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                                }
                            }

                            Store (MRCH, Local4)
                            Store (MRCL, Local5)
                            Or (ShiftLeft (Local4, 0x08), Local5, Local4)
                            Store (Local4, Index (BST1, 0x02))
                            Store (MVOH, Local0)
                            Store (MVOL, Local1)
                            Or (ShiftLeft (Local0, 0x08), Local1, Local0)
                            Store (Local0, Index (BST1, 0x03))
                        }
                    }

                    Return (BST1)
                }
            }
        }
    }

    Method (DC2S, 1, NotSerialized)
    {
        Name (STR1, Buffer (0x21)
        {
            "000000                          "
        })
        Store (Arg0, Local1)
        Store (0x05, Local3)
        While (LGreater (Local1, Zero))
        {
            Store (Zero, Local0)
            Divide (Local1, 0x0A, Local0, Local1)
            And (Local0, 0x0F, Local0)
            Or (Local0, 0x30, Local0)
            Store (Local0, Index (STR1, Local3))
            Decrement (Local3)
        }

        Return (STR1)
    }

    Scope (_SB)
    {
        Scope (PCI0)
        {
            Name (CRS, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x00FF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0100,             // Length
                    ,, )
                IO (Decode16,
                    0x0CF8,             // Range Minimum
                    0x0CF8,             // Range Maximum
                    0x01,               // Alignment
                    0x08,               // Length
                    )
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x0CF7,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0CF8,             // Length
                    ,, , TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0D00,             // Range Minimum
                    0xFFFF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0xF300,             // Length
                    ,, , TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000A0000,         // Range Minimum
                    0x000BFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C0000,         // Range Minimum
                    0x000DFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, , AddressRangeMemory, TypeStatic)
            })
            CreateDWordField (CRS, 0x5C, MIN5)
            CreateDWordField (CRS, 0x60, MAX5)
            CreateDWordField (CRS, 0x68, LEN5)
            CreateDWordField (CRS, 0x76, MIN6)
            CreateDWordField (CRS, 0x7A, MAX6)
            CreateDWordField (CRS, 0x82, LEN6)
            CreateDWordField (CRS, 0x90, MIN7)
            CreateDWordField (CRS, 0x94, MAX7)
            CreateDWordField (CRS, 0x9C, LEN7)
            Method (_CRS, 0, NotSerialized)
            {
                Store (MG1L, Local0)
                If (Local0)
                {
                    Store (MG1B, MIN5)
                    Store (MG1L, LEN5)
                    Add (MIN5, Decrement (Local0), MAX5)
                }

                Store (MG2B, MIN6)
                Store (MG2L, LEN6)
                Store (MG2L, Local0)
                Add (MIN6, Decrement (Local0), MAX6)
                Store (MG3B, MIN7)
                Store (MG3L, LEN7)
                Store (MG3L, Local0)
                Add (MIN7, Decrement (Local0), MAX7)
                Return (CRS)
            }
        }
    }

    Name (WOTB, Zero)
    Name (WSSB, Zero)
    Name (WAXB, Zero)
    Method (_PTS, 1, NotSerialized)
    {
        Store (Arg0, DBG8)
        PTS (Arg0)
        If (LEqual (Arg0, One))
        {
            Store (0x88, DBG8)
            ECWR (0x88)
        }

        Store (Zero, Index (WAKP, Zero))
        Store (Zero, Index (WAKP, One))
        If (LAnd (LEqual (Arg0, 0x04), LEqual (OSFL (), 0x02)))
        {
            Sleep (0x0BB8)
        }

        Store (ASSB, WSSB)
        Store (AOTB, WOTB)
        Store (AAXB, WAXB)
        Store (Arg0, ASSB)
        Store (OSFL (), AOTB)
        Store (OSYS (), OSTP)
        Store (Zero, AAXB)
    }

    Method (_WAK, 1, NotSerialized)
    {
        ShiftLeft (Arg0, 0x04, DBG8)
        WAK (Arg0)
        If (ASSB)
        {
            Store (WSSB, ASSB)
            Store (WOTB, AOTB)
            Store (WAXB, AAXB)
        }

        If (LEqual (Arg0, One))
        {
            Store (0x89, DBG8)
            ECWR (0x89)
        }

        If (DerefOf (Index (WAKP, Zero)))
        {
            Store (Zero, Index (WAKP, One))
        }
        Else
        {
            Store (Arg0, Index (WAKP, One))
        }

        Return (WAKP)
    }

    OperationRegion (EC1, SystemIO, 0x62, One)
    Field (EC1, ByteAcc, NoLock, Preserve)
    {
        ECDA,   8
    }

    OperationRegion (EC2, SystemIO, 0x66, One)
    Field (EC2, ByteAcc, NoLock, Preserve)
    {
        ECCM,   8
    }

    Method (OBFU, 0, NotSerialized)
    {
        Store (One, Local0)
        While (Local0)
        {
            Sleep (One)
            Store (ECCM, Local1)
            If (And (Local1, One))
            {
                Store (Zero, Local0)
            }
        }
    }

    Method (OBFE, 0, NotSerialized)
    {
        Store (One, Local0)
        While (Local0)
        {
            Sleep (One)
            Store (ECCM, Local1)
            If (Not (And (Local1, 0x02, Local1)))
            {
                Store (Zero, Local0)
            }
        }
    }

    Method (ECWR, 1, NotSerialized)
    {
        OBFE ()
        Store (Arg0, ECCM)
        OBFE ()
    }

    Scope (_SB.PCI0.SBRG)
    {
        Device (FXWD)
        {
            Name (_HID, "PNP0C14")
            Name (_UID, Zero)
            Name (_WDG, Buffer (0x3C)
            {
                /* 0000 */    0x17, 0xBE, 0xA1, 0xD2, 0x71, 0xC0, 0x34, 0x4C, 
                /* 0008 */    0xBD, 0xCD, 0x01, 0xF5, 0xE0, 0x82, 0x1C, 0x96, 
                /* 0010 */    0x46, 0x4E, 0x01, 0x02, 0x88, 0xFF, 0xAA, 0xFD, 
                /* 0018 */    0xDA, 0x08, 0x68, 0x4F, 0x8D, 0xCD, 0x9C, 0x46, 
                /* 0020 */    0x35, 0xD7, 0x21, 0xFD, 0xF0, 0x00, 0x01, 0x08, 
                /* 0028 */    0x21, 0x12, 0x90, 0x05, 0x66, 0xD5, 0xD1, 0x11, 
                /* 0030 */    0xB2, 0xF0, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0x10, 
                /* 0038 */    0x4C, 0x59, 0x01, 0x00
            })
            Name (QNUM, Zero)
            Name (ECF0, One)
            Method (WEF0, 1, NotSerialized)
            {
                If (LEqual (Arg0, Zero))
                {
                    Store (Zero, ECF0)
                }
                Else
                {
                    Store (One, ECF0)
                }
            }

            OperationRegion (FXEC, EmbeddedControl, Zero, 0xFF)
            Field (FXEC, ByteAcc, NoLock, Preserve)
            {
                        Offset (0x2E), 
                BLTS,   1, 
                WECS,   1, 
                    ,   1, 
                    ,   1, 
                STTP,   1, 
                ST3G,   1, 
                    ,   1, 
                SWLN,   1, 
                        Offset (0x36), 
                TMP1,   8, 
                TMP2,   8, 
                BRIV,   8, 
                        Offset (0x40), 
                CPFH,   8, 
                CPFL,   8, 
                        Offset (0x80), 
                SWQN,   8, 
                TEMP,   8, 
                        Offset (0xA4), 
                    ,   1, 
                G3EX,   1, 
                        Offset (0xF8), 
                ECVH,   8, 
                ECVL,   8
            }

            Method (WMFN, 3, NotSerialized)
            {
                CreateDWordField (Arg2, Zero, INDX)
                CreateDWordField (Arg2, 0x04, DATA)
                If (LEqual (Arg1, One))
                {
                    If (LEqual (INDX, One))
                    {
                        ShiftLeft (ECVH, 0x08, Local0)
                        Add (Local0, ECVL, Local1)
                        Return (Local1)
                    }
                    Else
                    {
                        If (LEqual (INDX, 0x03))
                        {
                            Return (SWLN)
                        }
                        Else
                        {
                            If (LEqual (INDX, 0x09))
                            {
                                Return (BRIV)
                            }
                            Else
                            {
                                If (LEqual (INDX, 0x05))
                                {
                                    Return (STTP)
                                }
                                Else
                                {
                                    If (LEqual (INDX, 0x07))
                                    {
                                        Return (ST3G)
                                    }
                                    Else
                                    {
                                        If (LEqual (INDX, 0x02))
                                        {
                                            Return (BLTS)
                                        }
                                        Else
                                        {
                                            If (LEqual (INDX, 0x06))
                                            {
                                                Return (WECS)
                                            }
                                            Else
                                            {
                                                If (LEqual (INDX, 0x12))
                                                {
                                                    ShiftLeft (CPFH, 0x08, Local0)
                                                    Add (Local0, CPFL, Local1)
                                                    Return (Local1)
                                                }
                                                Else
                                                {
                                                    If (LEqual (INDX, 0x21))
                                                    {
                                                        Return (TMP1)
                                                    }
                                                    Else
                                                    {
                                                        If (LEqual (INDX, 0x2D))
                                                        {
                                                            Return (TMP2)
                                                        }
                                                        Else
                                                        {
                                                            If (LEqual (INDX, 0x41))
                                                            {
                                                                Return (G3EX)
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            Method (_WED, 1, NotSerialized)
            {
                If (LEqual (Arg0, 0xF0))
                {
                    Return (QNUM)
                }
            }

            Method (GPWM, 0, NotSerialized)
            {
                ^^EC0.PWMG ()
            }

            Method (GWLL, 0, NotSerialized)
            {
                ^^EC0.WLLC ()
            }

            Method (EGGG, 0, NotSerialized)
            {
                ^^EC0.GGGE ()
            }

            Method (CAME, 0, NotSerialized)
            {
                ^^EC0.WCAM ()
            }

            Method (TCPD, 0, NotSerialized)
            {
                ^^EC0.TCPD ()
            }

            Name (WQLY, Buffer (0x0461)
            {
                /* 0000 */    0x46, 0x4F, 0x4D, 0x42, 0x01, 0x00, 0x00, 0x00, 
                /* 0008 */    0x51, 0x04, 0x00, 0x00, 0xF4, 0x0F, 0x00, 0x00, 
                /* 0010 */    0x44, 0x53, 0x00, 0x01, 0x1A, 0x7D, 0xDA, 0x54, 
                /* 0018 */    0x28, 0xDE, 0x87, 0x00, 0x01, 0x06, 0x18, 0x42, 
                /* 0020 */    0x10, 0x07, 0x10, 0x22, 0x21, 0x04, 0x12, 0x01, 
                /* 0028 */    0xA1, 0xC8, 0x2C, 0x0C, 0x86, 0x10, 0x38, 0x2E, 
                /* 0030 */    0x24, 0x15, 0x07, 0x85, 0x12, 0x02, 0xA1, 0xFE, 
                /* 0038 */    0x04, 0xF2, 0x2B, 0x00, 0xA1, 0x43, 0x01, 0x32, 
                /* 0040 */    0x05, 0x18, 0x14, 0xE0, 0x14, 0x41, 0x04, 0xBD, 
                /* 0048 */    0x0A, 0xB0, 0x29, 0xC0, 0xA4, 0x00, 0x8B, 0x02, 
                /* 0050 */    0xB4, 0x0B, 0xB0, 0x2C, 0x40, 0xB7, 0x00, 0xE9, 
                /* 0058 */    0xB0, 0x44, 0x24, 0x38, 0x4A, 0x0C, 0x38, 0x4A, 
                /* 0060 */    0x27, 0xB6, 0x70, 0xC3, 0x06, 0x2F, 0x14, 0x45, 
                /* 0068 */    0x33, 0x88, 0x92, 0xA0, 0x5C, 0x04, 0xE9, 0x82, 
                /* 0070 */    0x90, 0x72, 0x01, 0xBE, 0x11, 0x34, 0x80, 0x28, 
                /* 0078 */    0xBD, 0x0B, 0xB0, 0x2D, 0xC0, 0x34, 0x3C, 0x91, 
                /* 0080 */    0x3A, 0x04, 0x94, 0x9C, 0x21, 0xA0, 0x06, 0xD0, 
                /* 0088 */    0xEA, 0x04, 0x84, 0x5F, 0xE9, 0x94, 0x90, 0x04, 
                /* 0090 */    0xE1, 0x8C, 0x55, 0xFC, 0x0C, 0x34, 0x87, 0x13, 
                /* 0098 */    0x38, 0xA7, 0xCE, 0x31, 0xE4, 0x78, 0x5C, 0xE8, 
                /* 00A0 */    0x41, 0xF0, 0xE0, 0x26, 0x40, 0x58, 0x84, 0x21, 
                /* 00A8 */    0x4B, 0xDE, 0xA2, 0x09, 0x0C, 0xD3, 0x30, 0x16, 
                /* 00B0 */    0xEA, 0x62, 0xD4, 0xA8, 0x91, 0xB2, 0x01, 0x19, 
                /* 00B8 */    0xA2, 0x24, 0x38, 0xD4, 0xA8, 0x2D, 0x51, 0x80, 
                /* 00C0 */    0xF9, 0x71, 0xC8, 0xF0, 0xE8, 0xC8, 0x58, 0x42, 
                /* 00C8 */    0x32, 0x69, 0x43, 0x41, 0x49, 0x81, 0xD0, 0xD8, 
                /* 00D0 */    0xCE, 0xD3, 0x33, 0x8A, 0x58, 0xF2, 0x94, 0x04, 
                /* 00D8 */    0x93, 0xC0, 0xA3, 0x88, 0x6C, 0x34, 0x0E, 0x8D, 
                /* 00E0 */    0x1D, 0x86, 0x87, 0x19, 0xEC, 0x20, 0x0E, 0xA3, 
                /* 00E8 */    0x6C, 0x64, 0x11, 0x78, 0x42, 0x47, 0x7A, 0xDC, 
                /* 00F0 */    0x85, 0xCD, 0x53, 0xA8, 0x31, 0x9A, 0x83, 0x22, 
                /* 00F8 */    0xA2, 0x8F, 0x02, 0xE8, 0x31, 0x85, 0x3D, 0xDA, 
                /* 0100 */    0xD8, 0xE7, 0x6B, 0xE1, 0x83, 0x15, 0xC6, 0x11, 
                /* 0108 */    0x1C, 0x57, 0x82, 0xFF, 0xFF, 0x99, 0x9F, 0xC1, 
                /* 0110 */    0x29, 0x44, 0x8B, 0x50, 0x90, 0x00, 0xEB, 0x18, 
                /* 0118 */    0xC2, 0x3C, 0xA4, 0x28, 0x01, 0xE3, 0xC5, 0xE8, 
                /* 0120 */    0x19, 0x47, 0x28, 0x41, 0xC2, 0xC4, 0x8E, 0x11, 
                /* 0128 */    0xCE, 0x38, 0x9E, 0xD4, 0xE9, 0x18, 0xF6, 0x20, 
                /* 0130 */    0x4C, 0x10, 0xE5, 0x50, 0x30, 0x32, 0x20, 0x04, 
                /* 0138 */    0x1D, 0xED, 0x18, 0x4D, 0x60, 0xF7, 0xB3, 0x91, 
                /* 0140 */    0xB2, 0x13, 0x81, 0x8C, 0x09, 0x50, 0x78, 0x15, 
                /* 0148 */    0x10, 0x46, 0x6F, 0x02, 0x6C, 0x0D, 0x46, 0x13, 
                /* 0150 */    0x0B, 0x12, 0x26, 0xCA, 0xB1, 0x9D, 0x53, 0x67, 
                /* 0158 */    0x18, 0x42, 0x89, 0x17, 0x34, 0x58, 0x88, 0x28, 
                /* 0160 */    0xE1, 0xA2, 0xD5, 0x28, 0xC0, 0x1A, 0xAE, 0x50, 
                /* 0168 */    0x5E, 0x24, 0xC2, 0xC7, 0x09, 0x76, 0x90, 0xB5, 
                /* 0170 */    0x09, 0xB0, 0x3F, 0x08, 0x12, 0xEE, 0x44, 0x20, 
                /* 0178 */    0x09, 0x20, 0x8A, 0x34, 0x1A, 0xD4, 0x71, 0xC1, 
                /* 0180 */    0xA7, 0x02, 0x9F, 0x08, 0x9E, 0x12, 0x3C, 0xB0, 
                /* 0188 */    0xE3, 0x0A, 0x72, 0x18, 0xC7, 0xF5, 0x10, 0xF1, 
                /* 0190 */    0x38, 0xE0, 0x81, 0xB3, 0x7B, 0x82, 0x7F, 0x08, 
                /* 0198 */    0x3E, 0x1F, 0xE0, 0x5D, 0x03, 0xEA, 0x62, 0xF0, 
                /* 01A0 */    0x58, 0xC0, 0x86, 0x19, 0x0E, 0x33, 0x44, 0x4F, 
                /* 01A8 */    0x36, 0xDC, 0x09, 0x1C, 0x22, 0x03, 0xF4, 0xA0, 
                /* 01B0 */    0x9E, 0x08, 0xB0, 0xC3, 0x3A, 0x99, 0xC7, 0x81, 
                /* 01B8 */    0x37, 0x8A, 0x66, 0xEF, 0x12, 0x84, 0xE0, 0x78, 
                /* 01C0 */    0x7C, 0x8D, 0x60, 0x13, 0x4E, 0x60, 0xF9, 0x83, 
                /* 01C8 */    0x40, 0x8D, 0xCC, 0xD0, 0x9E, 0xF2, 0x69, 0xBD, 
                /* 01D0 */    0x0E, 0xF8, 0x34, 0x61, 0x02, 0x8B, 0x85, 0x90, 
                /* 01D8 */    0x02, 0x08, 0x8D, 0x07, 0xFC, 0x8A, 0x0F, 0x1E, 
                /* 01E0 */    0xE4, 0xCE, 0xE0, 0xF9, 0xFA, 0x24, 0x82, 0x3D, 
                /* 01E8 */    0x97, 0xC0, 0xBB, 0x09, 0x44, 0x7E, 0x78, 0x08, 
                /* 01F0 */    0xF5, 0xFF, 0x7F, 0xC0, 0x60, 0x97, 0x11, 0x8F, 
                /* 01F8 */    0x21, 0x48, 0xA0, 0x60, 0x0F, 0x08, 0x2F, 0x00, 
                /* 0200 */    0x3E, 0x9B, 0x00, 0x97, 0x40, 0xCF, 0x0F, 0x0D, 
                /* 0208 */    0xD5, 0xE2, 0x5F, 0x04, 0xB2, 0xB1, 0x56, 0x9F, 
                /* 0210 */    0x37, 0x68, 0x04, 0x2A, 0x79, 0xBC, 0x45, 0x10, 
                /* 0218 */    0xAD, 0xA7, 0x08, 0x04, 0x81, 0x85, 0x83, 0xE9, 
                /* 0220 */    0x43, 0x63, 0x68, 0x4B, 0xA6, 0x90, 0x2C, 0x1A, 
                /* 0228 */    0x8D, 0xC7, 0x83, 0x24, 0x30, 0x82, 0x33, 0x88, 
                /* 0230 */    0x01, 0x9D, 0x12, 0x42, 0x4E, 0x8E, 0x02, 0x28, 
                /* 0238 */    0x1D, 0xE3, 0x24, 0x23, 0x64, 0x83, 0x7C, 0x02, 
                /* 0240 */    0x70, 0x28, 0x08, 0xDD, 0x1E, 0x3C, 0x41, 0xDF, 
                /* 0248 */    0x04, 0xF8, 0x15, 0xC5, 0x67, 0x03, 0x43, 0x5B, 
                /* 0250 */    0xE0, 0xD5, 0x03, 0x34, 0xB3, 0xE0, 0x48, 0x7C, 
                /* 0258 */    0x89, 0x07, 0x12, 0x36, 0x41, 0x35, 0xB7, 0x1F, 
                /* 0260 */    0x3E, 0x0C, 0x8A, 0xC5, 0x08, 0x3C, 0xE8, 0xC7, 
                /* 0268 */    0x03, 0xD8, 0x57, 0x0F, 0x9F, 0x67, 0x7C, 0xE3, 
                /* 0270 */    0x78, 0xD5, 0x48, 0x50, 0xDF, 0xED, 0x00, 0x14, 
                /* 0278 */    0x40, 0x3E, 0x0D, 0xF8, 0x9E, 0xF3, 0x42, 0xC0, 
                /* 0280 */    0xC6, 0xF0, 0xAA, 0x63, 0x34, 0xA3, 0x73, 0x69, 
                /* 0288 */    0x63, 0x47, 0x89, 0x19, 0x3B, 0x05, 0xF1, 0xD8, 
                /* 0290 */    0x1D, 0x74, 0xEC, 0xE8, 0xB3, 0x84, 0xFF, 0xFF, 
                /* 0298 */    0x63, 0x7B, 0x1D, 0x78, 0xFB, 0x30, 0x81, 0x83, 
                /* 02A0 */    0x4D, 0x9D, 0x1E, 0x3D, 0xF0, 0x73, 0x3D, 0xB5, 
                /* 02A8 */    0x27, 0x10, 0xCF, 0xC2, 0x73, 0x07, 0xCF, 0x8D, 
                /* 02B0 */    0xE8, 0x21, 0x21, 0x8A, 0xEF, 0x1C, 0x87, 0x7E, 
                /* 02B8 */    0x24, 0xB8, 0x71, 0x78, 0xEE, 0x7C, 0x08, 0x9E, 
                /* 02C0 */    0x3B, 0x1F, 0x9A, 0x8F, 0x1A, 0xF0, 0x07, 0x8F, 
                /* 02C8 */    0x1D, 0x13, 0x76, 0xF2, 0x60, 0x84, 0xC7, 0x04, 
                /* 02D0 */    0x86, 0x90, 0x05, 0x08, 0xC9, 0x1A, 0x17, 0x6A, 
                /* 02D8 */    0x9C, 0x3E, 0x12, 0x31, 0xEC, 0x17, 0x0B, 0x1F, 
                /* 02E0 */    0x82, 0xCE, 0xF1, 0x1D, 0xE2, 0x25, 0x82, 0x8D, 
                /* 02E8 */    0xCD, 0xB0, 0x1E, 0x39, 0x87, 0x35, 0x5A, 0xD8, 
                /* 02F0 */    0x03, 0x7E, 0x22, 0xF1, 0x6D, 0xC6, 0x33, 0xF3, 
                /* 02F8 */    0x15, 0xC8, 0xE7, 0x18, 0xB0, 0x00, 0xE2, 0xAF, 
                /* 0300 */    0x1F, 0xEF, 0x00, 0x9E, 0x80, 0x4F, 0x03, 0x60, 
                /* 0308 */    0x3B, 0x83, 0xB0, 0x8B, 0x11, 0x7E, 0x20, 0x3A, 
                /* 0310 */    0x8E, 0xA0, 0x65, 0xBD, 0x19, 0x34, 0xE1, 0xC7, 
                /* 0318 */    0x11, 0xF6, 0xFF, 0x3F, 0x8E, 0xE0, 0xC4, 0x1C, 
                /* 0320 */    0x47, 0x28, 0x84, 0x65, 0xC0, 0x48, 0x04, 0x84, 
                /* 0328 */    0xCE, 0x10, 0x3C, 0xF6, 0x19, 0x82, 0x82, 0x78, 
                /* 0330 */    0xE4, 0x8E, 0x7A, 0x86, 0x40, 0x1F, 0x08, 0x7C, 
                /* 0338 */    0x1C, 0xC1, 0x1E, 0x22, 0x60, 0x5E, 0x47, 0xD8, 
                /* 0340 */    0x38, 0xC1, 0x76, 0x1F, 0x81, 0x77, 0x88, 0x80, 
                /* 0348 */    0x47, 0xE0, 0x43, 0x04, 0xF8, 0x0E, 0x1E, 0xE0, 
                /* 0350 */    0x1D, 0x24, 0x38, 0x0F, 0x1E, 0x80, 0x87, 0xFF, 
                /* 0358 */    0xFF, 0xC1, 0x03, 0x38, 0x9D, 0x65, 0x7C, 0xF0, 
                /* 0360 */    0x00, 0x9C, 0x9C, 0x36, 0xD8, 0xC1, 0x03, 0x86, 
                /* 0368 */    0xF4, 0x57, 0x82, 0xCF, 0x52, 0x7E, 0x09, 0x48, 
                /* 0370 */    0x2C, 0x0C, 0xEA, 0xB0, 0x08, 0xBC, 0x8F, 0x63, 
                /* 0378 */    0xF8, 0x53, 0x07, 0xCC, 0x13, 0x9A, 0xC1, 0xE2, 
                /* 0380 */    0xF8, 0xD2, 0x61, 0xA3, 0x10, 0xBA, 0x64, 0xE2, 
                /* 0388 */    0x8E, 0x8F, 0xE0, 0xF8, 0xFF, 0x1F, 0x1F, 0xF1, 
                /* 0390 */    0x87, 0x44, 0xD8, 0x93, 0x39, 0xA6, 0x47, 0x87, 
                /* 0398 */    0x08, 0x41, 0x22, 0x3C, 0x18, 0x46, 0x78, 0x39, 
                /* 03A0 */    0x34, 0x46, 0x28, 0x1F, 0x12, 0xAD, 0xF9, 0x6A, 
                /* 03A8 */    0x28, 0x28, 0x23, 0xF9, 0x90, 0xC8, 0x46, 0x11, 
                /* 03B0 */    0x24, 0x58, 0xAC, 0x97, 0x8A, 0xA7, 0xC4, 0x40, 
                /* 03B8 */    0x8F, 0x8B, 0x2F, 0x89, 0x1E, 0x81, 0x0F, 0x89, 
                /* 03C0 */    0x2C, 0xFA, 0xD3, 0x41, 0x27, 0x01, 0x1F, 0x12, 
                /* 03C8 */    0x01, 0x7E, 0x48, 0x38, 0x53, 0xE8, 0x2C, 0x84, 
                /* 03D0 */    0x3F, 0x2B, 0x9C, 0xF4, 0x6B, 0xC1, 0x49, 0x87, 
                /* 03D8 */    0x7D, 0x83, 0x60, 0x27, 0x13, 0x2E, 0xEA, 0x64, 
                /* 03E0 */    0x82, 0x3A, 0x4C, 0xF8, 0x1C, 0xC1, 0x2E, 0x32, 
                /* 03E8 */    0xFC, 0x80, 0x85, 0x19, 0x19, 0xFF, 0xFF, 0x9F, 
                /* 03F0 */    0x46, 0x80, 0xDF, 0x51, 0xE7, 0x6D, 0xC2, 0x47, 
                /* 03F8 */    0x1D, 0x18, 0x67, 0x1C, 0xF0, 0xC9, 0x3B, 0x65, 
                /* 0400 */    0x82, 0x6A, 0xDC, 0x4F, 0xD3, 0xC0, 0xEA, 0x4A, 
                /* 0408 */    0xE4, 0xD3, 0x34, 0xB8, 0xCE, 0x03, 0xEC, 0x24, 
                /* 0410 */    0x0D, 0x4B, 0xA1, 0x4D, 0x9F, 0x1A, 0x8D, 0x5A, 
                /* 0418 */    0x35, 0x28, 0x53, 0xA3, 0x4C, 0x83, 0x5A, 0x7D, 
                /* 0420 */    0x2A, 0x35, 0x66, 0xCC, 0xC6, 0xF9, 0xC0, 0xCF, 
                /* 0428 */    0x03, 0x9D, 0x0F, 0x1C, 0x09, 0x84, 0x2A, 0x7C, 
                /* 0430 */    0x24, 0xC8, 0xC8, 0xA8, 0x0C, 0x22, 0x20, 0x0B, 
                /* 0438 */    0x7F, 0x7B, 0x08, 0xC8, 0x31, 0x40, 0x04, 0xE4, 
                /* 0440 */    0x80, 0x6B, 0x10, 0x90, 0xE3, 0x82, 0x08, 0xC8, 
                /* 0448 */    0x41, 0x8E, 0xD7, 0x02, 0x72, 0x2C, 0x10, 0x01, 
                /* 0450 */    0x39, 0xFC, 0xF3, 0x40, 0x20, 0x96, 0xBE, 0x0E, 
                /* 0458 */    0x81, 0x58, 0xFC, 0xBB, 0x53, 0x20, 0xFE, 0xFF, 
                /* 0460 */    0x03
            })
        }
    }

    Name (_S0, Package (0x04)
    {
        Zero, 
        Zero, 
        Zero, 
        Zero
    })
    If (SS1)
    {
        Name (_S1, Package (0x04)
        {
            One, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS3)
    {
        Name (_S3, Package (0x04)
        {
            0x05, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS4)
    {
        Name (_S4, Package (0x04)
        {
            0x06, 
            Zero, 
            Zero, 
            Zero
        })
    }

    Name (_S5, Package (0x04)
    {
        0x07, 
        Zero, 
        Zero, 
        Zero
    })
    Method (PTS, 1, NotSerialized)
    {
        If (Arg0)
        {
            \_SB.PCI0.NPTS (Arg0)
            \_SB.PCI0.SBRG.SPTS (Arg0)
            \_SB.PCI0.SBRG.EC0.EPTS (Arg0)
            \_SB.PCI0.GFX0.OPTS (Arg0)
        }
    }

    Method (WAK, 1, NotSerialized)
    {
        \_SB.PCI0.NWAK (Arg0)
        \_SB.PCI0.SBRG.SWAK (Arg0)
        \_SB.PCI0.SBRG.EC0.EWAK (Arg0)
        \_SB.PCI0.GFX0.OWAK (Arg0)
    }
}

