/* Test eComStation setup */
/* (c) 2008 eCo Software, */
/* The script is developed on the money earned by Samm */
/* The latest version: http://ecomstation.ru/projects/acpitools/download/acpi-test.cmd */

call	RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
   


bootdrive=lib_boot_drive()

log4="acpi-test4.log"
log5="acpi-test5.log"
log7="acpi-test7.log"


say "Test eComStation configuration, is it ready for ACPI.PSD?"
say "(c) 2008 eCo Software"
say "Version of script: 3.13"
say ""

/* Test 1 - Checking snoop.lst  */
Test1:

say "Test 1 - Checking snoop.lst"

filename=bootdrive'\OS2\BOOT\SNOOP.LST'

    nlines=lines(filename)
    
    if nlines=0 then
    do
       say "PROBLEM FOUND: "filename" is empty, add one line: ibmkbd.snp"
    end   

    test1failed=0
    do while lines(filename)
        line=TRANSLATE(linein(filename))
        if line='IBMKBD.SNP' then 
        do 
        end
        
        else if line='' then 
        do 
        end
        
        else 
        do 
           test1failed=1
           say "Test 1, PROBLEM FOUND: "filename", Keep ibmkbd.snp, remove other snoopers"
           leave
        end   
    end
    
    if test1failed=0 then say "Test 1 - OK"
    

/* Test 2 - Checking CONFIG.SYS, APM.SYS  */

Test2:    

say ""
say "Test 2 - Checking CONFIG.SYS"

filename=bootdrive'\CONFIG.SYS'

    nlines=lines(filename)
    
    test2failed=0
    acpihere=0
    do while lines(filename)
        line=TRANSLATE(linein(filename))
        
        if line='BASEDEV=APM.SYS' then         
        do
           test2failed=1
           say "Test 2 - PROBLEM FOUND: "filename" contains old IBM APM.SYS, remove this line"
           leave
        end
        
        if POS('PSD=ACPI.PSD', line)>0 then
        do
           acpihere=1
           if POS('/ACPI', line)>0 then
           do
             test2failed=1
             say "Test 2 - PROBLEM FOUND: "filename" ACPI.PSD /ACPI - incorrect switch, do you mean /APIC?"
             leave
           end 
        end
        
    end

    if acpihere=0 then say "Test 2 - PROBLEM FOUND: Where is PSD=ACPI.PSD?!"
    if test2failed=0 then say "Test 2 - OK"
    
    

/* Test 3 - Checking RESOURCE.SYS  */

Test3:

say ""
say "Test 3 - Checking RESOURCE.SYS"
    
filename=bootdrive'\OS2\BOOT\RESOURCE.SYS'

test3failed=0
sum=0

   filesize=stream(filename,'c','query size') 
   if filesize<> 55402 then
   do
        test3failed=1
        say "Test 3 - PROBLEM FOUND: Wrong RESOURCE.SYS (sub-test 1)"
   
   end
   else 
   do
      /*    ⠪ ⮤: */
      do while chars(filename)>0
        char=charin(filename)
        charcode = C2D(char)
        sum=sum+charcode
      end
   
      /*say sum*/
   
      if sum<> 6163862 then
      do
        test3failed=1
        say "Test 3 - PROBLEM FOUND: Wrong RESOURCE.SYS (sub-test 2)"
      end
      
   end
   
   
   if test3failed=0 then
   do
      say "Test 3 - OK, RESOURCE.SYS seems correct" 
   
   end
   


/* Test 4 - Checking OS2KRNL  */

Test4:

say ""
say "Test 4 - Checking OS2KRNL"

filename=bootdrive'\OS2KRNL'
goodSMP='14.104a#@_SMP'
goodUNI='14.104a#@_UNI'

test4failed=0
'@bldlevel 'filename' > '||log4
do while lines(log4)>0
  line=linein(log4)
  
  signature=POS('Signature',line) 
  /* say signature */
  if signature>0 then 
  do
     parse var line "@#IBM:" SigStr " " .
     version1=POS(goodSMP,line) 
     version2=POS(goodUNI,line) 
     /*say version1 version2 */
     
     if (version1=0 & version2=0) then
     do
        test4failed=1
        say "Test 4 - PROBLEM FOUND: Wrong version of kernel, please use:"
        say "           "goodSMP" or "
        say "           "goodUNI
        say "        Currently you have: "SigStr
        
        leave
     end   
     else 
     do
       if version1<>0 then version=goodSMP
       else version=goodUNI
     end
     
  end
  
end

    if test4failed=0 then 
    do
      say "Test 4 - OK, the system is equipped with supported version of kernel" 
      say "        " version
    end  


    
    
/* Test 5 - Checking Danis506  */

Test5:

say ""
say "Test 5 - Checking danis506"

filename=bootdrive'\OS2\BOOT\DANIS506.ADD'

goodDanis.0=5
goodDanis.1="1.8.2"
goodDanis.2="1.8.3"
goodDanis.3="1.8.4"
goodDanis.4="1.8.5"
goodDanis.5="1.8.6"
idealDanis="1.8.5"

test5failed=0
test5ok=0
'@bldlevel 'filename' > '||log5
do while lines(log5)>0
  line=TRANSLATE(linein(log5))
  
  signature=POS('FILE VERSION:',line) 
  /*say signature*/
  if signature>0 then 
  do
      /*say "ops" line*/
       
      do i=1 to goodDanis.0
        goodDanis=POS(goodDanis.i, line) 
        /* say goodDanis.i goodDanis */
        if goodDanis>0 then 
        do
           test5ok=1
           foundDanis=goodDanis.i
        end   
      end
      
      if test5ok=0 then 
      do
         test5failed=1
         say "Test 5 - PROBLEM FOUND: Wrong version of Danis506.add is used"
         say "        Please upgrade to" idealDanis
         say "        Currently you have: "         
         say "        "line
        
         leave
      end   
      
      /*
     else 
     do
       if version1<>0 then version=goodSMP
       else version=goodUNI
     end
     */
     
  end
  
end

    if test5failed=0 then 
    do
      say "Test 5 - OK, the system is equipped with modern DANIS506.ADD" 
      say "         Found version: " foundDanis
    end  

    
    
    
/* Test 6 - Checking duplicate ACPI.PSD  */
Test6:

say ""
say "Test 6 - Checking duplicates"
test6failed=0

duplicates.0=2
duplicates.1=bootdrive'\ACPI.PSD'
duplicates.2=bootdrive'OS2\ACPI.PSD'


      do i=1 to duplicates.0
         if STREAM(duplicates.i, 'C', "QUERY EXISTS") <> '' then 
         do
         
            test6failed=1
            say "Test 6 - PROBLEM FOUND: Duplicate ACPI.PSD is found, remove it"
            say "        "duplicates.i
        
            leave
         end
      end  
    
    
    if test6failed=0 then 
    do
      say "Test 6 - OK, can't find duplicates of ACPI.PSD on bootable disk" 
    end  
    


/* Test 7 - Checking ACPI files version  */

Test7:

say ""
say "Test 7 - Checking ACPI files version"


ACPIfiles.0=2
ACPIfiles.1=bootdrive'\OS2\BOOT\ACPI.PSD'
ACPIfiles.2=bootdrive'\OS2\BOOT\APM.ADD'

goodACPIVER.1='3.13'
goodACPIVER.2='1.27'

test7failed=0

do i=1 to ACPIfiles.0
  filename=ACPIfiles.i
  logX='acpi-test-7-'i'.log'
  '@bldlevel 'filename' > '||logX
  do while lines(logX)>0
    line=TRANSLATE(linein(logX))
  
    signature=POS('FILE VERSION:',line) 
    /* say filename signature  */
  
    if signature>0 then 
    do
       vernum=POS(goodACPIVER.i,line) 
       verword=SUBSTR(line,18)
       
       if vernum>0 then say filename "- OK, version: "goodACPIVER.i
       else 
       do 
          say "Test 7 - PROBLEM FOUND" filename "ver." verword ", should be "goodACPIVER.i
          test7failed=1
       end  
       
      /*
      */ 
     /*say version1 version2 */
     
     /*
     if (version1=0 & version2=0) then
     do
        test4failed=1
        say "Test 4, PROBLEM FOUND: Wrong version of kernel, please use:"
        say "           "goodSMP" or "
        say "           "goodUNI
        say "        Currently you have: "
        
        leave
     end   
     else 
     do
       if version1<>0 then version=goodSMP
       else version=goodUNI
     end
     
     */
    end
  
  end

end

    if test7failed=0 then 
    do
      say "Test 7 - OK, you are using the latest ACPI components" 
    end  


TestExit:
say "bye" 
    
exit
  



/* 㧮  */

lib_boot_drive: Procedure
If \Rxfuncquery('SysBootDrive') Then
do
  bootdrive = SysBootDrive()
end
else
do
  call log 'No SysBootDrive function. Trying find bootdrive via PATH.'
  parse upper value VALUE( "PATH",, "OS2ENVIRONMENT" ) with "\OS2\SYSTEM" -2, bootdrive +2
  if bootdrive = '' then
  do
    errmsg='Can not detect boot drive. Please update REXXUTIL.DLL.'
    signal error
  end
end

return bootdrive
  
